/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Atom_pntr_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mmdb1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MMDB1_ATOM_PNTR_BASE_HPP
#define OBJECTS_MMDB1_ATOM_PNTR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/mmdb1/Atom_id.hpp>
#include <objects/mmdb1/Molecule_id.hpp>
#include <objects/mmdb1/Residue_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Atoms, residues and molecules within the current biostruc are referenced 
/// by hierarchical pointers.
class NCBI_MMDB1_EXPORT CAtom_pntr_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAtom_pntr_Base(void);
    // destructor
    virtual ~CAtom_pntr_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CMolecule_id TMolecule_id;
    typedef CResidue_id TResidue_id;
    typedef CAtom_id TAtom_id;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_molecule_id,
        e_residue_id,
        e_atom_id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CMolecule_id TMolecule_id
    ///  Check whether the Molecule_id data member has been assigned a value.
    bool IsSetMolecule_id(void) const;
    /// Check whether it is safe or not to call GetMolecule_id method.
    bool CanGetMolecule_id(void) const;
    void ResetMolecule_id(void);
    const TMolecule_id& GetMolecule_id(void) const;
    void SetMolecule_id(const TMolecule_id& value);
    TMolecule_id& SetMolecule_id(void);

    /// mandatory
    /// typedef CResidue_id TResidue_id
    ///  Check whether the Residue_id data member has been assigned a value.
    bool IsSetResidue_id(void) const;
    /// Check whether it is safe or not to call GetResidue_id method.
    bool CanGetResidue_id(void) const;
    void ResetResidue_id(void);
    const TResidue_id& GetResidue_id(void) const;
    void SetResidue_id(const TResidue_id& value);
    TResidue_id& SetResidue_id(void);

    /// mandatory
    /// typedef CAtom_id TAtom_id
    ///  Check whether the Atom_id data member has been assigned a value.
    bool IsSetAtom_id(void) const;
    /// Check whether it is safe or not to call GetAtom_id method.
    bool CanGetAtom_id(void) const;
    void ResetAtom_id(void);
    const TAtom_id& GetAtom_id(void) const;
    void SetAtom_id(const TAtom_id& value);
    TAtom_id& SetAtom_id(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAtom_pntr_Base(const CAtom_pntr_Base&);
    CAtom_pntr_Base& operator=(const CAtom_pntr_Base&);

    // data
    Uint4 m_set_State[1];
    CMolecule_id m_Molecule_id;
    CResidue_id m_Residue_id;
    CAtom_id m_Atom_id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAtom_pntr_Base::IsSetMolecule_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAtom_pntr_Base::CanGetMolecule_id(void) const
{
    return IsSetMolecule_id();
}

inline
void CAtom_pntr_Base::ResetMolecule_id(void)
{
    m_Molecule_id = CMolecule_id(0);
    m_set_State[0] &= ~0x3;
}

inline
const CAtom_pntr_Base::TMolecule_id& CAtom_pntr_Base::GetMolecule_id(void) const
{
    if (!CanGetMolecule_id()) {
        ThrowUnassigned(0);
    }
    return m_Molecule_id;
}

inline
void CAtom_pntr_Base::SetMolecule_id(const CAtom_pntr_Base::TMolecule_id& value)
{
    m_Molecule_id = value;
    m_set_State[0] |= 0x3;
}

inline
CAtom_pntr_Base::TMolecule_id& CAtom_pntr_Base::SetMolecule_id(void)
{
    m_set_State[0] |= 0x1;
    return m_Molecule_id;
}

inline
bool CAtom_pntr_Base::IsSetResidue_id(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAtom_pntr_Base::CanGetResidue_id(void) const
{
    return IsSetResidue_id();
}

inline
void CAtom_pntr_Base::ResetResidue_id(void)
{
    m_Residue_id = CResidue_id(0);
    m_set_State[0] &= ~0xc;
}

inline
const CAtom_pntr_Base::TResidue_id& CAtom_pntr_Base::GetResidue_id(void) const
{
    if (!CanGetResidue_id()) {
        ThrowUnassigned(1);
    }
    return m_Residue_id;
}

inline
void CAtom_pntr_Base::SetResidue_id(const CAtom_pntr_Base::TResidue_id& value)
{
    m_Residue_id = value;
    m_set_State[0] |= 0xc;
}

inline
CAtom_pntr_Base::TResidue_id& CAtom_pntr_Base::SetResidue_id(void)
{
    m_set_State[0] |= 0x4;
    return m_Residue_id;
}

inline
bool CAtom_pntr_Base::IsSetAtom_id(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAtom_pntr_Base::CanGetAtom_id(void) const
{
    return IsSetAtom_id();
}

inline
void CAtom_pntr_Base::ResetAtom_id(void)
{
    m_Atom_id = CAtom_id(0);
    m_set_State[0] &= ~0x30;
}

inline
const CAtom_pntr_Base::TAtom_id& CAtom_pntr_Base::GetAtom_id(void) const
{
    if (!CanGetAtom_id()) {
        ThrowUnassigned(2);
    }
    return m_Atom_id;
}

inline
void CAtom_pntr_Base::SetAtom_id(const CAtom_pntr_Base::TAtom_id& value)
{
    m_Atom_id = value;
    m_set_State[0] |= 0x30;
}

inline
CAtom_pntr_Base::TAtom_id& CAtom_pntr_Base::SetAtom_id(void)
{
    m_set_State[0] |= 0x10;
    return m_Atom_id;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MMDB1_ATOM_PNTR_BASE_HPP
