/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Mim_date_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'mim.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MIM_MIM_DATE_BASE_HPP
#define OBJECTS_MIM_MIM_DATE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_MIM_EXPORT CMim_date_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CMim_date_Base(void);
    // destructor
    virtual ~CMim_date_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TYear;
    typedef int TMonth;
    typedef int TDay;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_year,
        e_month,
        e_day
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TYear
    ///  Check whether the Year data member has been assigned a value.
    bool IsSetYear(void) const;
    /// Check whether it is safe or not to call GetYear method.
    bool CanGetYear(void) const;
    void ResetYear(void);
    TYear GetYear(void) const;
    void SetYear(TYear value);
    TYear& SetYear(void);

    /// optional
    /// typedef int TMonth
    ///  Check whether the Month data member has been assigned a value.
    bool IsSetMonth(void) const;
    /// Check whether it is safe or not to call GetMonth method.
    bool CanGetMonth(void) const;
    void ResetMonth(void);
    TMonth GetMonth(void) const;
    void SetMonth(TMonth value);
    TMonth& SetMonth(void);

    /// optional
    /// typedef int TDay
    ///  Check whether the Day data member has been assigned a value.
    bool IsSetDay(void) const;
    /// Check whether it is safe or not to call GetDay method.
    bool CanGetDay(void) const;
    void ResetDay(void);
    TDay GetDay(void) const;
    void SetDay(TDay value);
    TDay& SetDay(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CMim_date_Base(const CMim_date_Base&);
    CMim_date_Base& operator=(const CMim_date_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Year;
    int m_Month;
    int m_Day;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CMim_date_Base::IsSetYear(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CMim_date_Base::CanGetYear(void) const
{
    return IsSetYear();
}

inline
void CMim_date_Base::ResetYear(void)
{
    m_Year = 0;
    m_set_State[0] &= ~0x3;
}

inline
CMim_date_Base::TYear CMim_date_Base::GetYear(void) const
{
    if (!CanGetYear()) {
        ThrowUnassigned(0);
    }
    return m_Year;
}

inline
void CMim_date_Base::SetYear(CMim_date_Base::TYear value)
{
    m_Year = value;
    m_set_State[0] |= 0x3;
}

inline
CMim_date_Base::TYear& CMim_date_Base::SetYear(void)
{
#ifdef _DEBUG
    if (!IsSetYear()) {
        memset(&m_Year,UnassignedByte(),sizeof(m_Year));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Year;
}

inline
bool CMim_date_Base::IsSetMonth(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CMim_date_Base::CanGetMonth(void) const
{
    return IsSetMonth();
}

inline
void CMim_date_Base::ResetMonth(void)
{
    m_Month = 0;
    m_set_State[0] &= ~0xc;
}

inline
CMim_date_Base::TMonth CMim_date_Base::GetMonth(void) const
{
    if (!CanGetMonth()) {
        ThrowUnassigned(1);
    }
    return m_Month;
}

inline
void CMim_date_Base::SetMonth(CMim_date_Base::TMonth value)
{
    m_Month = value;
    m_set_State[0] |= 0xc;
}

inline
CMim_date_Base::TMonth& CMim_date_Base::SetMonth(void)
{
#ifdef _DEBUG
    if (!IsSetMonth()) {
        memset(&m_Month,UnassignedByte(),sizeof(m_Month));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Month;
}

inline
bool CMim_date_Base::IsSetDay(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CMim_date_Base::CanGetDay(void) const
{
    return IsSetDay();
}

inline
void CMim_date_Base::ResetDay(void)
{
    m_Day = 0;
    m_set_State[0] &= ~0x30;
}

inline
CMim_date_Base::TDay CMim_date_Base::GetDay(void) const
{
    if (!CanGetDay()) {
        ThrowUnassigned(2);
    }
    return m_Day;
}

inline
void CMim_date_Base::SetDay(CMim_date_Base::TDay value)
{
    m_Day = value;
    m_set_State[0] |= 0x30;
}

inline
CMim_date_Base::TDay& CMim_date_Base::SetDay(void)
{
#ifdef _DEBUG
    if (!IsSetDay()) {
        memset(&m_Day,UnassignedByte(),sizeof(m_Day));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Day;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MIM_MIM_DATE_BASE_HPP
