/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Quantity_constraint_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_QUANTITY_CONSTRAINT_BASE_HPP
#define OBJECTS_MACRO_QUANTITY_CONSTRAINT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CQuantity_constraint_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CQuantity_constraint_Base(void);
    // destructor
    virtual ~CQuantity_constraint_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,   ///< No variant selected
        e_Equals,
        e_Greater_than,
        e_Less_than
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 4 ///< == e_Less_than+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef int TEquals;
    typedef int TGreater_than;
    typedef int TLess_than;

    // getters
    // setters

    // typedef int TEquals
    bool IsEquals(void) const;
    TEquals GetEquals(void) const;
    TEquals& SetEquals(void);
    void SetEquals(TEquals value);

    // typedef int TGreater_than
    bool IsGreater_than(void) const;
    TGreater_than GetGreater_than(void) const;
    TGreater_than& SetGreater_than(void);
    void SetGreater_than(TGreater_than value);

    // typedef int TLess_than
    bool IsLess_than(void) const;
    TLess_than GetLess_than(void) const;
    TLess_than& SetLess_than(void);
    void SetLess_than(TLess_than value);


private:
    // copy constructor and assignment operator
    CQuantity_constraint_Base(const CQuantity_constraint_Base& );
    CQuantity_constraint_Base& operator=(const CQuantity_constraint_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        TEquals m_Equals;
        TGreater_than m_Greater_than;
        TLess_than m_Less_than;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CQuantity_constraint_Base::E_Choice CQuantity_constraint_Base::Which(void) const
{
    return m_choice;
}

inline
void CQuantity_constraint_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CQuantity_constraint_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CQuantity_constraint_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CQuantity_constraint_Base::IsEquals(void) const
{
    return m_choice == e_Equals;
}

inline
CQuantity_constraint_Base::TEquals CQuantity_constraint_Base::GetEquals(void) const
{
    CheckSelected(e_Equals);
    return m_Equals;
}

inline
CQuantity_constraint_Base::TEquals& CQuantity_constraint_Base::SetEquals(void)
{
    Select(e_Equals, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Equals;
}

inline
void CQuantity_constraint_Base::SetEquals(CQuantity_constraint_Base::TEquals value)
{
    Select(e_Equals, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Equals = value;
}

inline
bool CQuantity_constraint_Base::IsGreater_than(void) const
{
    return m_choice == e_Greater_than;
}

inline
CQuantity_constraint_Base::TGreater_than CQuantity_constraint_Base::GetGreater_than(void) const
{
    CheckSelected(e_Greater_than);
    return m_Greater_than;
}

inline
CQuantity_constraint_Base::TGreater_than& CQuantity_constraint_Base::SetGreater_than(void)
{
    Select(e_Greater_than, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Greater_than;
}

inline
void CQuantity_constraint_Base::SetGreater_than(CQuantity_constraint_Base::TGreater_than value)
{
    Select(e_Greater_than, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Greater_than = value;
}

inline
bool CQuantity_constraint_Base::IsLess_than(void) const
{
    return m_choice == e_Less_than;
}

inline
CQuantity_constraint_Base::TLess_than CQuantity_constraint_Base::GetLess_than(void) const
{
    CheckSelected(e_Less_than);
    return m_Less_than;
}

inline
CQuantity_constraint_Base::TLess_than& CQuantity_constraint_Base::SetLess_than(void)
{
    Select(e_Less_than, NCBI_NS_NCBI::eDoNotResetVariant);
    return m_Less_than;
}

inline
void CQuantity_constraint_Base::SetLess_than(CQuantity_constraint_Base::TLess_than value)
{
    Select(e_Less_than, NCBI_NS_NCBI::eDoNotResetVariant);
    m_Less_than = value;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_QUANTITY_CONSTRAINT_BASE_HPP
