/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Extend_to_feature_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_MACRO_EXTEND_TO_FEATURE_BASE_HPP
#define OBJECTS_MACRO_EXTEND_TO_FEATURE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <objects/macro/Macro_feature_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CQuantity_constraint;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CExtend_to_feature_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CExtend_to_feature_Base(void);
    // destructor
    virtual ~CExtend_to_feature_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef EMacro_feature_type TType;
    typedef bool TInclude_feat;
    typedef CQuantity_constraint TDistance;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_type,
        e_include_feat,
        e_distance
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef EMacro_feature_type TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// mandatory
    /// typedef bool TInclude_feat
    ///  Check whether the Include_feat data member has been assigned a value.
    bool IsSetInclude_feat(void) const;
    /// Check whether it is safe or not to call GetInclude_feat method.
    bool CanGetInclude_feat(void) const;
    void ResetInclude_feat(void);
    TInclude_feat GetInclude_feat(void) const;
    void SetInclude_feat(TInclude_feat value);
    TInclude_feat& SetInclude_feat(void);

    /// optional
    /// typedef CQuantity_constraint TDistance
    ///  Check whether the Distance data member has been assigned a value.
    bool IsSetDistance(void) const;
    /// Check whether it is safe or not to call GetDistance method.
    bool CanGetDistance(void) const;
    void ResetDistance(void);
    const TDistance& GetDistance(void) const;
    void SetDistance(TDistance& value);
    TDistance& SetDistance(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CExtend_to_feature_Base(const CExtend_to_feature_Base&);
    CExtend_to_feature_Base& operator=(const CExtend_to_feature_Base&);

    // data
    Uint4 m_set_State[1];
    EMacro_feature_type m_Type;
    bool m_Include_feat;
    CRef< TDistance > m_Distance;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CExtend_to_feature_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CExtend_to_feature_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CExtend_to_feature_Base::ResetType(void)
{
    m_Type = (ncbi::objects::EMacro_feature_type)(0);
    m_set_State[0] &= ~0x3;
}

inline
CExtend_to_feature_Base::TType CExtend_to_feature_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(0);
    }
    return m_Type;
}

inline
void CExtend_to_feature_Base::SetType(CExtend_to_feature_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0x3;
}

inline
CExtend_to_feature_Base::TType& CExtend_to_feature_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Type;
}

inline
bool CExtend_to_feature_Base::IsSetInclude_feat(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CExtend_to_feature_Base::CanGetInclude_feat(void) const
{
    return IsSetInclude_feat();
}

inline
void CExtend_to_feature_Base::ResetInclude_feat(void)
{
    m_Include_feat = 0;
    m_set_State[0] &= ~0xc;
}

inline
CExtend_to_feature_Base::TInclude_feat CExtend_to_feature_Base::GetInclude_feat(void) const
{
    if (!CanGetInclude_feat()) {
        ThrowUnassigned(1);
    }
    return m_Include_feat;
}

inline
void CExtend_to_feature_Base::SetInclude_feat(CExtend_to_feature_Base::TInclude_feat value)
{
    m_Include_feat = value;
    m_set_State[0] |= 0xc;
}

inline
CExtend_to_feature_Base::TInclude_feat& CExtend_to_feature_Base::SetInclude_feat(void)
{
#ifdef _DEBUG
    if (!IsSetInclude_feat()) {
        memset(&m_Include_feat,UnassignedByte(),sizeof(m_Include_feat));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Include_feat;
}

inline
bool CExtend_to_feature_Base::IsSetDistance(void) const
{
    return m_Distance.NotEmpty();
}

inline
bool CExtend_to_feature_Base::CanGetDistance(void) const
{
    return IsSetDistance();
}

inline
const CExtend_to_feature_Base::TDistance& CExtend_to_feature_Base::GetDistance(void) const
{
    if (!CanGetDistance()) {
        ThrowUnassigned(2);
    }
    return (*m_Distance);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_EXTEND_TO_FEATURE_BASE_HPP
