/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID2_Error_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID2_ID2_ERROR_BASE_HPP
#define OBJECTS_ID2_ID2_ERROR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID2_EXPORT CID2_Error_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID2_Error_Base(void);
    // destructor
    virtual ~CID2_Error_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum ESeverity {
        eSeverity_warning             = 1,  ///< nothing harmful happened
        eSeverity_failed_command      = 2,  ///< command cannot be completed this time
        eSeverity_failed_connection   = 3,  ///< connection cannot be reused, reconnect is required
        eSeverity_failed_server       = 4,  ///< server cannot be used for a while
        eSeverity_no_data             = 5,  ///< resolve request gives no data  probably temporarily (see retry-delay field)
        eSeverity_restricted_data     = 6,  ///< data exists but client doesn't have permission to get it
        eSeverity_unsupported_command = 7,  ///< this request type is not supported by server
        eSeverity_invalid_arguments   = 8  ///< error in request packet, cannot retry
    };
    
    /// Access to ESeverity's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESeverity)(void);
    
    // types
    typedef ESeverity TSeverity;
    typedef int TRetry_delay;
    typedef string TMessage;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_severity,
        e_retry_delay,
        e_message
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef ESeverity TSeverity
    ///  Check whether the Severity data member has been assigned a value.
    bool IsSetSeverity(void) const;
    /// Check whether it is safe or not to call GetSeverity method.
    bool CanGetSeverity(void) const;
    void ResetSeverity(void);
    TSeverity GetSeverity(void) const;
    void SetSeverity(TSeverity value);
    TSeverity& SetSeverity(void);

    /// client may retry the request after specified time in seconds 
    /// optional
    /// typedef int TRetry_delay
    ///  Check whether the Retry_delay data member has been assigned a value.
    bool IsSetRetry_delay(void) const;
    /// Check whether it is safe or not to call GetRetry_delay method.
    bool CanGetRetry_delay(void) const;
    void ResetRetry_delay(void);
    TRetry_delay GetRetry_delay(void) const;
    void SetRetry_delay(TRetry_delay value);
    TRetry_delay& SetRetry_delay(void);

    /// optional
    /// typedef string TMessage
    ///  Check whether the Message data member has been assigned a value.
    bool IsSetMessage(void) const;
    /// Check whether it is safe or not to call GetMessage method.
    bool CanGetMessage(void) const;
    void ResetMessage(void);
    const TMessage& GetMessage(void) const;
    void SetMessage(const TMessage& value);
    void SetMessage(TMessage&& value);
    TMessage& SetMessage(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID2_Error_Base(const CID2_Error_Base&);
    CID2_Error_Base& operator=(const CID2_Error_Base&);

    // data
    Uint4 m_set_State[1];
    ESeverity m_Severity;
    int m_Retry_delay;
    string m_Message;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID2_Error_Base::IsSetSeverity(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CID2_Error_Base::CanGetSeverity(void) const
{
    return IsSetSeverity();
}

inline
void CID2_Error_Base::ResetSeverity(void)
{
    m_Severity = (ESeverity)(0);
    m_set_State[0] &= ~0x3;
}

inline
CID2_Error_Base::TSeverity CID2_Error_Base::GetSeverity(void) const
{
    if (!CanGetSeverity()) {
        ThrowUnassigned(0);
    }
    return m_Severity;
}

inline
void CID2_Error_Base::SetSeverity(CID2_Error_Base::TSeverity value)
{
    m_Severity = value;
    m_set_State[0] |= 0x3;
}

inline
CID2_Error_Base::TSeverity& CID2_Error_Base::SetSeverity(void)
{
#ifdef _DEBUG
    if (!IsSetSeverity()) {
        memset(&m_Severity,UnassignedByte(),sizeof(m_Severity));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Severity;
}

inline
bool CID2_Error_Base::IsSetRetry_delay(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CID2_Error_Base::CanGetRetry_delay(void) const
{
    return IsSetRetry_delay();
}

inline
void CID2_Error_Base::ResetRetry_delay(void)
{
    m_Retry_delay = 0;
    m_set_State[0] &= ~0xc;
}

inline
CID2_Error_Base::TRetry_delay CID2_Error_Base::GetRetry_delay(void) const
{
    if (!CanGetRetry_delay()) {
        ThrowUnassigned(1);
    }
    return m_Retry_delay;
}

inline
void CID2_Error_Base::SetRetry_delay(CID2_Error_Base::TRetry_delay value)
{
    m_Retry_delay = value;
    m_set_State[0] |= 0xc;
}

inline
CID2_Error_Base::TRetry_delay& CID2_Error_Base::SetRetry_delay(void)
{
#ifdef _DEBUG
    if (!IsSetRetry_delay()) {
        memset(&m_Retry_delay,UnassignedByte(),sizeof(m_Retry_delay));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Retry_delay;
}

inline
bool CID2_Error_Base::IsSetMessage(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CID2_Error_Base::CanGetMessage(void) const
{
    return IsSetMessage();
}

inline
const CID2_Error_Base::TMessage& CID2_Error_Base::GetMessage(void) const
{
    if (!CanGetMessage()) {
        ThrowUnassigned(2);
    }
    return m_Message;
}

inline
void CID2_Error_Base::SetMessage(const CID2_Error_Base::TMessage& value)
{
    m_Message = value;
    m_set_State[0] |= 0x30;
}

inline
void CID2_Error_Base::SetMessage(CID2_Error_Base::TMessage&& value)
{
    m_Message = std::forward<CID2_Error_Base::TMessage>(value);
    m_set_State[0] |= 0x30;
}

inline
CID2_Error_Base::TMessage& CID2_Error_Base::SetMessage(void)
{
#ifdef _DEBUG
    if (!IsSetMessage()) {
        m_Message = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Message;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID2_ID2_ERROR_BASE_HPP
