/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file ID1Seq_hist_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'id1.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ID1_ID1SEQ_HIST_BASE_HPP
#define OBJECTS_ID1_ID1SEQ_HIST_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_hist;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ID1_EXPORT CID1Seq_hist_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CID1Seq_hist_Base(void);
    // destructor
    virtual ~CID1Seq_hist_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CSeq_hist THist;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_hist
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef CSeq_hist THist
    ///  Check whether the Hist data member has been assigned a value.
    bool IsSetHist(void) const;
    /// Check whether it is safe or not to call GetHist method.
    bool CanGetHist(void) const;
    void ResetHist(void);
    const THist& GetHist(void) const;
    void SetHist(THist& value);
    THist& SetHist(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CID1Seq_hist_Base(const CID1Seq_hist_Base&);
    CID1Seq_hist_Base& operator=(const CID1Seq_hist_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< THist > m_Hist;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CID1Seq_hist_Base::IsSetHist(void) const
{
    return m_Hist.NotEmpty();
}

inline
bool CID1Seq_hist_Base::CanGetHist(void) const
{
    return true;
}

inline
const CID1Seq_hist_Base::THist& CID1Seq_hist_Base::GetHist(void) const
{
    if ( !m_Hist ) {
        const_cast<CID1Seq_hist_Base*>(this)->ResetHist();
    }
    return (*m_Hist);
}

inline
CID1Seq_hist_Base::THist& CID1Seq_hist_Base::SetHist(void)
{
    if ( !m_Hist ) {
        ResetHist();
    }
    return (*m_Hist);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ID1_ID1SEQ_HIST_BASE_HPP
