/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file HG_Link_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'homologene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_HOMOLOGENE_HG_LINK_BASE_HPP
#define OBJECTS_HOMOLOGENE_HG_LINK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class CHG_Link_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHG_Link_Base(void);
    // destructor
    virtual ~CHG_Link_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string THypertext;
    typedef string TUrl;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_hypertext,
        e_url
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string THypertext
    ///  Check whether the Hypertext data member has been assigned a value.
    bool IsSetHypertext(void) const;
    /// Check whether it is safe or not to call GetHypertext method.
    bool CanGetHypertext(void) const;
    void ResetHypertext(void);
    const THypertext& GetHypertext(void) const;
    void SetHypertext(const THypertext& value);
    void SetHypertext(THypertext&& value);
    THypertext& SetHypertext(void);

    /// optional
    /// typedef string TUrl
    ///  Check whether the Url data member has been assigned a value.
    bool IsSetUrl(void) const;
    /// Check whether it is safe or not to call GetUrl method.
    bool CanGetUrl(void) const;
    void ResetUrl(void);
    const TUrl& GetUrl(void) const;
    void SetUrl(const TUrl& value);
    void SetUrl(TUrl&& value);
    TUrl& SetUrl(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHG_Link_Base(const CHG_Link_Base&);
    CHG_Link_Base& operator=(const CHG_Link_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Hypertext;
    string m_Url;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHG_Link_Base::IsSetHypertext(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CHG_Link_Base::CanGetHypertext(void) const
{
    return IsSetHypertext();
}

inline
const CHG_Link_Base::THypertext& CHG_Link_Base::GetHypertext(void) const
{
    if (!CanGetHypertext()) {
        ThrowUnassigned(0);
    }
    return m_Hypertext;
}

inline
void CHG_Link_Base::SetHypertext(const CHG_Link_Base::THypertext& value)
{
    m_Hypertext = value;
    m_set_State[0] |= 0x3;
}

inline
void CHG_Link_Base::SetHypertext(CHG_Link_Base::THypertext&& value)
{
    m_Hypertext = std::forward<CHG_Link_Base::THypertext>(value);
    m_set_State[0] |= 0x3;
}

inline
CHG_Link_Base::THypertext& CHG_Link_Base::SetHypertext(void)
{
#ifdef _DEBUG
    if (!IsSetHypertext()) {
        m_Hypertext = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Hypertext;
}

inline
bool CHG_Link_Base::IsSetUrl(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CHG_Link_Base::CanGetUrl(void) const
{
    return IsSetUrl();
}

inline
const CHG_Link_Base::TUrl& CHG_Link_Base::GetUrl(void) const
{
    if (!CanGetUrl()) {
        ThrowUnassigned(1);
    }
    return m_Url;
}

inline
void CHG_Link_Base::SetUrl(const CHG_Link_Base::TUrl& value)
{
    m_Url = value;
    m_set_State[0] |= 0xc;
}

inline
void CHG_Link_Base::SetUrl(CHG_Link_Base::TUrl&& value)
{
    m_Url = std::forward<CHG_Link_Base::TUrl>(value);
    m_set_State[0] |= 0xc;
}

inline
CHG_Link_Base::TUrl& CHG_Link_Base::SetUrl(void)
{
#ifdef _DEBUG
    if (!IsSetUrl()) {
        m_Url = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Url;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_HOMOLOGENE_HG_LINK_BASE_HPP
