/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GC_External_Seqid_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genome_collection.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENOMECOLL_GC_EXTERNAL_SEQID_BASE_HPP
#define OBJECTS_GENOMECOLL_GC_EXTERNAL_SEQID_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_id;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_GENOME_COLLECTION_EXPORT CGC_External_Seqid_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGC_External_Seqid_Base(void);
    // destructor
    virtual ~CGC_External_Seqid_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TExternal;
    typedef CSeq_id TId;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_external,
        e_id
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef string TExternal
    ///  Check whether the External data member has been assigned a value.
    bool IsSetExternal(void) const;
    /// Check whether it is safe or not to call GetExternal method.
    bool CanGetExternal(void) const;
    void ResetExternal(void);
    const TExternal& GetExternal(void) const;
    void SetExternal(const TExternal& value);
    void SetExternal(TExternal&& value);
    TExternal& SetExternal(void);

    /// mandatory
    /// typedef CSeq_id TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGC_External_Seqid_Base(const CGC_External_Seqid_Base&);
    CGC_External_Seqid_Base& operator=(const CGC_External_Seqid_Base&);

    // data
    Uint4 m_set_State[1];
    string m_External;
    CRef< TId > m_Id;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGC_External_Seqid_Base::IsSetExternal(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGC_External_Seqid_Base::CanGetExternal(void) const
{
    return IsSetExternal();
}

inline
const CGC_External_Seqid_Base::TExternal& CGC_External_Seqid_Base::GetExternal(void) const
{
    if (!CanGetExternal()) {
        ThrowUnassigned(0);
    }
    return m_External;
}

inline
void CGC_External_Seqid_Base::SetExternal(const CGC_External_Seqid_Base::TExternal& value)
{
    m_External = value;
    m_set_State[0] |= 0x3;
}

inline
void CGC_External_Seqid_Base::SetExternal(CGC_External_Seqid_Base::TExternal&& value)
{
    m_External = std::forward<CGC_External_Seqid_Base::TExternal>(value);
    m_set_State[0] |= 0x3;
}

inline
CGC_External_Seqid_Base::TExternal& CGC_External_Seqid_Base::SetExternal(void)
{
#ifdef _DEBUG
    if (!IsSetExternal()) {
        m_External = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_External;
}

inline
bool CGC_External_Seqid_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CGC_External_Seqid_Base::CanGetId(void) const
{
    return true;
}

inline
const CGC_External_Seqid_Base::TId& CGC_External_Seqid_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CGC_External_Seqid_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CGC_External_Seqid_Base::TId& CGC_External_Seqid_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENOMECOLL_GC_EXTERNAL_SEQID_BASE_HPP
