/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GBL_Gene_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'genesbyloc.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GENESBYLOC_GBL_GENE_BASE_HPP
#define OBJECTS_GENESBYLOC_GBL_GENE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// a single gene record
class NCBI_GENESBYLOC_EXPORT CGBL_Gene_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGBL_Gene_Base(void);
    // destructor
    virtual ~CGBL_Gene_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TGeneid;
    typedef string TSymbol;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_geneid,
        e_symbol
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// NCBI GeneID
    /// mandatory
    /// typedef int TGeneid
    ///  Check whether the Geneid data member has been assigned a value.
    bool IsSetGeneid(void) const;
    /// Check whether it is safe or not to call GetGeneid method.
    bool CanGetGeneid(void) const;
    void ResetGeneid(void);
    TGeneid GetGeneid(void) const;
    void SetGeneid(TGeneid value);
    TGeneid& SetGeneid(void);

    /// official or interim symbol for the gene
    /// mandatory
    /// typedef string TSymbol
    ///  Check whether the Symbol data member has been assigned a value.
    bool IsSetSymbol(void) const;
    /// Check whether it is safe or not to call GetSymbol method.
    bool CanGetSymbol(void) const;
    void ResetSymbol(void);
    const TSymbol& GetSymbol(void) const;
    void SetSymbol(const TSymbol& value);
    void SetSymbol(TSymbol&& value);
    TSymbol& SetSymbol(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGBL_Gene_Base(const CGBL_Gene_Base&);
    CGBL_Gene_Base& operator=(const CGBL_Gene_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Geneid;
    string m_Symbol;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGBL_Gene_Base::IsSetGeneid(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGBL_Gene_Base::CanGetGeneid(void) const
{
    return IsSetGeneid();
}

inline
void CGBL_Gene_Base::ResetGeneid(void)
{
    m_Geneid = 0;
    m_set_State[0] &= ~0x3;
}

inline
CGBL_Gene_Base::TGeneid CGBL_Gene_Base::GetGeneid(void) const
{
    if (!CanGetGeneid()) {
        ThrowUnassigned(0);
    }
    return m_Geneid;
}

inline
void CGBL_Gene_Base::SetGeneid(CGBL_Gene_Base::TGeneid value)
{
    m_Geneid = value;
    m_set_State[0] |= 0x3;
}

inline
CGBL_Gene_Base::TGeneid& CGBL_Gene_Base::SetGeneid(void)
{
#ifdef _DEBUG
    if (!IsSetGeneid()) {
        memset(&m_Geneid,UnassignedByte(),sizeof(m_Geneid));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Geneid;
}

inline
bool CGBL_Gene_Base::IsSetSymbol(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGBL_Gene_Base::CanGetSymbol(void) const
{
    return IsSetSymbol();
}

inline
const CGBL_Gene_Base::TSymbol& CGBL_Gene_Base::GetSymbol(void) const
{
    if (!CanGetSymbol()) {
        ThrowUnassigned(1);
    }
    return m_Symbol;
}

inline
void CGBL_Gene_Base::SetSymbol(const CGBL_Gene_Base::TSymbol& value)
{
    m_Symbol = value;
    m_set_State[0] |= 0xc;
}

inline
void CGBL_Gene_Base::SetSymbol(CGBL_Gene_Base::TSymbol&& value)
{
    m_Symbol = std::forward<CGBL_Gene_Base::TSymbol>(value);
    m_set_State[0] |= 0xc;
}

inline
CGBL_Gene_Base::TSymbol& CGBL_Gene_Base::SetSymbol(void)
{
#ifdef _DEBUG
    if (!IsSetSymbol()) {
        m_Symbol = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Symbol;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GENESBYLOC_GBL_GENE_BASE_HPP
