/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file GBProject_ver2_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'gbproj.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_GBPROJ_GBPROJECT_VER2_BASE_HPP
#define OBJECTS_GBPROJ_GBPROJECT_VER2_BASE_HPP

// extra headers
#include <objects/gbproj/gbproj_export.h>

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CDummyObsoleteType;
class CLoaderDescriptor;
class CProjectAnnot;
class CProjectDescr;
class CProjectFolder;
class CProjectHistoryItem;
class CUser_object;
class CViewDescriptor;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///
/// Version 2 project
/// With version two we start a new paradigm
/// The first item in the project *MUST* be a non-optional version stamp,
/// composed as an integer.  This allows us to use a binary ASN.1 fingerprint to
/// determine the version prior to reading a file.
///
class NCBI_GBPROJ_EXPORT CGBProject_ver2_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGBProject_ver2_Base(void);
    // destructor
    virtual ~CGBProject_ver2_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TProject_version;
    typedef int TCounter;
    typedef CProjectDescr TDescr;
    typedef CProjectFolder TData;
    typedef CDummyObsoleteType TObsolete_orig_message;
    typedef list< CRef< CProjectHistoryItem > > THistory;
    typedef string TData_plugin;
    typedef string TPlugin_param;
    typedef list< CRef< CProjectAnnot > > TAnnot;
    typedef list< CRef< CLoaderDescriptor > > TLoaders;
    typedef list< CRef< CViewDescriptor > > TViews;
    typedef list< CRef< CUser_object > > TView_settings;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_project_version,
        e_counter,
        e_descr,
        e_data,
        e_obsolete_orig_message,
        e_history,
        e_data_plugin,
        e_plugin_param,
        e_annot,
        e_loaders,
        e_views,
        e_view_settings
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 13> TmemberIndex;

    // getters
    // setters

    /// the version for this project
    /// for this particular instance, this should always be 2
    /// this data element *MUST* be first
    /// mandatory
    /// typedef string TProject_version
    ///  Check whether the Project_version data member has been assigned a value.
    bool IsSetProject_version(void) const;
    /// Check whether it is safe or not to call GetProject_version method.
    bool CanGetProject_version(void) const;
    void ResetProject_version(void);
    const TProject_version& GetProject_version(void) const;
    void SetProject_version(const TProject_version& value);
    void SetProject_version(TProject_version&& value);
    TProject_version& SetProject_version(void);

    /// next counter for project items
    /// optional with default 0
    /// typedef int TCounter
    ///  Check whether the Counter data member has been assigned a value.
    bool IsSetCounter(void) const;
    /// Check whether it is safe or not to call GetCounter method.
    bool CanGetCounter(void) const;
    void ResetCounter(void);
    void SetDefaultCounter(void);
    TCounter GetCounter(void) const;
    void SetCounter(TCounter value);
    TCounter& SetCounter(void);

    /// standard descriptors
    /// mandatory
    /// typedef CProjectDescr TDescr
    ///  Check whether the Descr data member has been assigned a value.
    bool IsSetDescr(void) const;
    /// Check whether it is safe or not to call GetDescr method.
    bool CanGetDescr(void) const;
    void ResetDescr(void);
    const TDescr& GetDescr(void) const;
    void SetDescr(TDescr& value);
    TDescr& SetDescr(void);

    /// a set of extra analyses perfromed by the user
    /// each of these may have descriptors
    /// mandatory
    /// typedef CProjectFolder TData
    ///  Check whether the Data data member has been assigned a value.
    bool IsSetData(void) const;
    /// Check whether it is safe or not to call GetData method.
    bool CanGetData(void) const;
    void ResetData(void);
    const TData& GetData(void) const;
    void SetData(TData& value);
    TData& SetData(void);

    /// a copy of the original plugin message used to generate this project
    /// This is deprecated. DO NOT USE THIS FIELD.
    /// The original spec is: orig-message PluginMessage OPTIONAL.
    /// It is intended to be removed, but a complete
    /// removal will cause order shift for the rest of
    /// fields in this choice, and cause deserialization
    /// failure for existing ASN file since this filed is
    /// in the middle of the spec.
    /// optional
    /// typedef CDummyObsoleteType TObsolete_orig_message
    ///  Check whether the Obsolete_orig_message data member has been assigned a value.
    bool IsSetObsolete_orig_message(void) const;
    /// Check whether it is safe or not to call GetObsolete_orig_message method.
    bool CanGetObsolete_orig_message(void) const;
    void ResetObsolete_orig_message(void);
    const TObsolete_orig_message& GetObsolete_orig_message(void) const;
    void SetObsolete_orig_message(TObsolete_orig_message& value);
    TObsolete_orig_message& SetObsolete_orig_message(void);

    /// history of things done to this object
    /// optional
    /// typedef list< CRef< CProjectHistoryItem > > THistory
    ///  Check whether the History data member has been assigned a value.
    bool IsSetHistory(void) const;
    /// Check whether it is safe or not to call GetHistory method.
    bool CanGetHistory(void) const;
    void ResetHistory(void);
    const THistory& GetHistory(void) const;
    THistory& SetHistory(void);

    ///name of the plugin that can handle External Data for the project
    /// optional
    /// typedef string TData_plugin
    ///  Check whether the Data_plugin data member has been assigned a value.
    bool IsSetData_plugin(void) const;
    /// Check whether it is safe or not to call GetData_plugin method.
    bool CanGetData_plugin(void) const;
    void ResetData_plugin(void);
    const TData_plugin& GetData_plugin(void) const;
    void SetData_plugin(const TData_plugin& value);
    void SetData_plugin(TData_plugin&& value);
    TData_plugin& SetData_plugin(void);

    ///optional parameter for the data-plugin
    /// optional
    /// typedef string TPlugin_param
    ///  Check whether the Plugin_param data member has been assigned a value.
    bool IsSetPlugin_param(void) const;
    /// Check whether it is safe or not to call GetPlugin_param method.
    bool CanGetPlugin_param(void) const;
    void ResetPlugin_param(void);
    const TPlugin_param& GetPlugin_param(void) const;
    void SetPlugin_param(const TPlugin_param& value);
    void SetPlugin_param(TPlugin_param&& value);
    TPlugin_param& SetPlugin_param(void);

    /// arbitrary annotations
    /// optional
    /// typedef list< CRef< CProjectAnnot > > TAnnot
    ///  Check whether the Annot data member has been assigned a value.
    bool IsSetAnnot(void) const;
    /// Check whether it is safe or not to call GetAnnot method.
    bool CanGetAnnot(void) const;
    void ResetAnnot(void);
    const TAnnot& GetAnnot(void) const;
    TAnnot& SetAnnot(void);

    /// a set of data sources including data loader and data
    /// optional
    /// typedef list< CRef< CLoaderDescriptor > > TLoaders
    ///  Check whether the Loaders data member has been assigned a value.
    bool IsSetLoaders(void) const;
    /// Check whether it is safe or not to call GetLoaders method.
    bool CanGetLoaders(void) const;
    void ResetLoaders(void);
    const TLoaders& GetLoaders(void) const;
    TLoaders& SetLoaders(void);

    ///- set of views, associated with project
    /// optional
    /// typedef list< CRef< CViewDescriptor > > TViews
    ///  Check whether the Views data member has been assigned a value.
    bool IsSetViews(void) const;
    /// Check whether it is safe or not to call GetViews method.
    bool CanGetViews(void) const;
    void ResetViews(void);
    const TViews& GetViews(void) const;
    TViews& SetViews(void);

    /// set of view-specific settings
    /// optional
    /// typedef list< CRef< CUser_object > > TView_settings
    ///  Check whether the View_settings data member has been assigned a value.
    bool IsSetView_settings(void) const;
    /// Check whether it is safe or not to call GetView_settings method.
    bool CanGetView_settings(void) const;
    void ResetView_settings(void);
    const TView_settings& GetView_settings(void) const;
    TView_settings& SetView_settings(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGBProject_ver2_Base(const CGBProject_ver2_Base&);
    CGBProject_ver2_Base& operator=(const CGBProject_ver2_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Project_version;
    int m_Counter;
    CRef< TDescr > m_Descr;
    CRef< TData > m_Data;
    CRef< TObsolete_orig_message > m_Obsolete_orig_message;
    list< CRef< CProjectHistoryItem > > m_History;
    string m_Data_plugin;
    string m_Plugin_param;
    list< CRef< CProjectAnnot > > m_Annot;
    list< CRef< CLoaderDescriptor > > m_Loaders;
    list< CRef< CViewDescriptor > > m_Views;
    list< CRef< CUser_object > > m_View_settings;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGBProject_ver2_Base::IsSetProject_version(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGBProject_ver2_Base::CanGetProject_version(void) const
{
    return IsSetProject_version();
}

inline
const CGBProject_ver2_Base::TProject_version& CGBProject_ver2_Base::GetProject_version(void) const
{
    if (!CanGetProject_version()) {
        ThrowUnassigned(0);
    }
    return m_Project_version;
}

inline
void CGBProject_ver2_Base::SetProject_version(const CGBProject_ver2_Base::TProject_version& value)
{
    m_Project_version = value;
    m_set_State[0] |= 0x3;
}

inline
void CGBProject_ver2_Base::SetProject_version(CGBProject_ver2_Base::TProject_version&& value)
{
    m_Project_version = std::forward<CGBProject_ver2_Base::TProject_version>(value);
    m_set_State[0] |= 0x3;
}

inline
CGBProject_ver2_Base::TProject_version& CGBProject_ver2_Base::SetProject_version(void)
{
#ifdef _DEBUG
    if (!IsSetProject_version()) {
        m_Project_version = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Project_version;
}

inline
bool CGBProject_ver2_Base::IsSetCounter(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGBProject_ver2_Base::CanGetCounter(void) const
{
    return true;
}

inline
void CGBProject_ver2_Base::ResetCounter(void)
{
    m_Counter = 0;
    m_set_State[0] &= ~0xc;
}

inline
void CGBProject_ver2_Base::SetDefaultCounter(void)
{
    ResetCounter();
}

inline
CGBProject_ver2_Base::TCounter CGBProject_ver2_Base::GetCounter(void) const
{
    return m_Counter;
}

inline
void CGBProject_ver2_Base::SetCounter(CGBProject_ver2_Base::TCounter value)
{
    m_Counter = value;
    m_set_State[0] |= 0xc;
}

inline
CGBProject_ver2_Base::TCounter& CGBProject_ver2_Base::SetCounter(void)
{
#ifdef _DEBUG
    if (!IsSetCounter()) {
        memset(&m_Counter,UnassignedByte(),sizeof(m_Counter));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Counter;
}

inline
bool CGBProject_ver2_Base::IsSetDescr(void) const
{
    return m_Descr.NotEmpty();
}

inline
bool CGBProject_ver2_Base::CanGetDescr(void) const
{
    return true;
}

inline
const CGBProject_ver2_Base::TDescr& CGBProject_ver2_Base::GetDescr(void) const
{
    if ( !m_Descr ) {
        const_cast<CGBProject_ver2_Base*>(this)->ResetDescr();
    }
    return (*m_Descr);
}

inline
CGBProject_ver2_Base::TDescr& CGBProject_ver2_Base::SetDescr(void)
{
    if ( !m_Descr ) {
        ResetDescr();
    }
    return (*m_Descr);
}

inline
bool CGBProject_ver2_Base::IsSetData(void) const
{
    return m_Data.NotEmpty();
}

inline
bool CGBProject_ver2_Base::CanGetData(void) const
{
    return true;
}

inline
const CGBProject_ver2_Base::TData& CGBProject_ver2_Base::GetData(void) const
{
    if ( !m_Data ) {
        const_cast<CGBProject_ver2_Base*>(this)->ResetData();
    }
    return (*m_Data);
}

inline
CGBProject_ver2_Base::TData& CGBProject_ver2_Base::SetData(void)
{
    if ( !m_Data ) {
        ResetData();
    }
    return (*m_Data);
}

inline
bool CGBProject_ver2_Base::IsSetObsolete_orig_message(void) const
{
    return m_Obsolete_orig_message.NotEmpty();
}

inline
bool CGBProject_ver2_Base::CanGetObsolete_orig_message(void) const
{
    return IsSetObsolete_orig_message();
}

inline
const CGBProject_ver2_Base::TObsolete_orig_message& CGBProject_ver2_Base::GetObsolete_orig_message(void) const
{
    if (!CanGetObsolete_orig_message()) {
        ThrowUnassigned(4);
    }
    return (*m_Obsolete_orig_message);
}

inline
bool CGBProject_ver2_Base::IsSetHistory(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CGBProject_ver2_Base::CanGetHistory(void) const
{
    return true;
}

inline
const CGBProject_ver2_Base::THistory& CGBProject_ver2_Base::GetHistory(void) const
{
    return m_History;
}

inline
CGBProject_ver2_Base::THistory& CGBProject_ver2_Base::SetHistory(void)
{
    m_set_State[0] |= 0x400;
    return m_History;
}

inline
bool CGBProject_ver2_Base::IsSetData_plugin(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CGBProject_ver2_Base::CanGetData_plugin(void) const
{
    return IsSetData_plugin();
}

inline
const CGBProject_ver2_Base::TData_plugin& CGBProject_ver2_Base::GetData_plugin(void) const
{
    if (!CanGetData_plugin()) {
        ThrowUnassigned(6);
    }
    return m_Data_plugin;
}

inline
void CGBProject_ver2_Base::SetData_plugin(const CGBProject_ver2_Base::TData_plugin& value)
{
    m_Data_plugin = value;
    m_set_State[0] |= 0x3000;
}

inline
void CGBProject_ver2_Base::SetData_plugin(CGBProject_ver2_Base::TData_plugin&& value)
{
    m_Data_plugin = std::forward<CGBProject_ver2_Base::TData_plugin>(value);
    m_set_State[0] |= 0x3000;
}

inline
CGBProject_ver2_Base::TData_plugin& CGBProject_ver2_Base::SetData_plugin(void)
{
#ifdef _DEBUG
    if (!IsSetData_plugin()) {
        m_Data_plugin = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Data_plugin;
}

inline
bool CGBProject_ver2_Base::IsSetPlugin_param(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CGBProject_ver2_Base::CanGetPlugin_param(void) const
{
    return IsSetPlugin_param();
}

inline
const CGBProject_ver2_Base::TPlugin_param& CGBProject_ver2_Base::GetPlugin_param(void) const
{
    if (!CanGetPlugin_param()) {
        ThrowUnassigned(7);
    }
    return m_Plugin_param;
}

inline
void CGBProject_ver2_Base::SetPlugin_param(const CGBProject_ver2_Base::TPlugin_param& value)
{
    m_Plugin_param = value;
    m_set_State[0] |= 0xc000;
}

inline
void CGBProject_ver2_Base::SetPlugin_param(CGBProject_ver2_Base::TPlugin_param&& value)
{
    m_Plugin_param = std::forward<CGBProject_ver2_Base::TPlugin_param>(value);
    m_set_State[0] |= 0xc000;
}

inline
CGBProject_ver2_Base::TPlugin_param& CGBProject_ver2_Base::SetPlugin_param(void)
{
#ifdef _DEBUG
    if (!IsSetPlugin_param()) {
        m_Plugin_param = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_Plugin_param;
}

inline
bool CGBProject_ver2_Base::IsSetAnnot(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CGBProject_ver2_Base::CanGetAnnot(void) const
{
    return true;
}

inline
const CGBProject_ver2_Base::TAnnot& CGBProject_ver2_Base::GetAnnot(void) const
{
    return m_Annot;
}

inline
CGBProject_ver2_Base::TAnnot& CGBProject_ver2_Base::SetAnnot(void)
{
    m_set_State[0] |= 0x10000;
    return m_Annot;
}

inline
bool CGBProject_ver2_Base::IsSetLoaders(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CGBProject_ver2_Base::CanGetLoaders(void) const
{
    return true;
}

inline
const CGBProject_ver2_Base::TLoaders& CGBProject_ver2_Base::GetLoaders(void) const
{
    return m_Loaders;
}

inline
CGBProject_ver2_Base::TLoaders& CGBProject_ver2_Base::SetLoaders(void)
{
    m_set_State[0] |= 0x40000;
    return m_Loaders;
}

inline
bool CGBProject_ver2_Base::IsSetViews(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CGBProject_ver2_Base::CanGetViews(void) const
{
    return true;
}

inline
const CGBProject_ver2_Base::TViews& CGBProject_ver2_Base::GetViews(void) const
{
    return m_Views;
}

inline
CGBProject_ver2_Base::TViews& CGBProject_ver2_Base::SetViews(void)
{
    m_set_State[0] |= 0x100000;
    return m_Views;
}

inline
bool CGBProject_ver2_Base::IsSetView_settings(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CGBProject_ver2_Base::CanGetView_settings(void) const
{
    return true;
}

inline
const CGBProject_ver2_Base::TView_settings& CGBProject_ver2_Base::GetView_settings(void) const
{
    return m_View_settings;
}

inline
CGBProject_ver2_Base::TView_settings& CGBProject_ver2_Base::SetView_settings(void)
{
    m_set_State[0] |= 0x400000;
    return m_View_settings;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_GBPROJ_GBPROJECT_VER2_BASE_HPP
