/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Gene_source_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrezgene.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZGENE_GENE_SOURCE_BASE_HPP
#define OBJECTS_ENTREZGENE_GENE_SOURCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_ENTREZGENE_EXPORT CGene_source_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CGene_source_Base(void);
    // destructor
    virtual ~CGene_source_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TSrc;
    typedef int TSrc_int;
    typedef string TSrc_str1;
    typedef string TSrc_str2;
    typedef bool TGene_display;
    typedef bool TLocus_display;
    typedef bool TExtra_terms;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_src,
        e_src_int,
        e_src_str1,
        e_src_str2,
        e_gene_display,
        e_locus_display,
        e_extra_terms
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 8> TmemberIndex;

    // getters
    // setters

    /// key to the source within NCBI locuslink, Ecoli, etc 
    /// mandatory
    /// typedef string TSrc
    ///  Check whether the Src data member has been assigned a value.
    bool IsSetSrc(void) const;
    /// Check whether it is safe or not to call GetSrc method.
    bool CanGetSrc(void) const;
    void ResetSrc(void);
    const TSrc& GetSrc(void) const;
    void SetSrc(const TSrc& value);
    void SetSrc(TSrc&& value);
    TSrc& SetSrc(void);

    /// eg. locuslink id 
    /// optional
    /// typedef int TSrc_int
    ///  Check whether the Src_int data member has been assigned a value.
    bool IsSetSrc_int(void) const;
    /// Check whether it is safe or not to call GetSrc_int method.
    bool CanGetSrc_int(void) const;
    void ResetSrc_int(void);
    TSrc_int GetSrc_int(void) const;
    void SetSrc_int(TSrc_int value);
    TSrc_int& SetSrc_int(void);

    /// eg. chromosome1 
    /// optional
    /// typedef string TSrc_str1
    ///  Check whether the Src_str1 data member has been assigned a value.
    bool IsSetSrc_str1(void) const;
    /// Check whether it is safe or not to call GetSrc_str1 method.
    bool CanGetSrc_str1(void) const;
    void ResetSrc_str1(void);
    const TSrc_str1& GetSrc_str1(void) const;
    void SetSrc_str1(const TSrc_str1& value);
    void SetSrc_str1(TSrc_str1&& value);
    TSrc_str1& SetSrc_str1(void);

    /// see note 3
    /// optional
    /// typedef string TSrc_str2
    ///  Check whether the Src_str2 data member has been assigned a value.
    bool IsSetSrc_str2(void) const;
    /// Check whether it is safe or not to call GetSrc_str2 method.
    bool CanGetSrc_str2(void) const;
    void ResetSrc_str2(void);
    const TSrc_str2& GetSrc_str2(void) const;
    void SetSrc_str2(const TSrc_str2& value);
    void SetSrc_str2(TSrc_str2&& value);
    TSrc_str2& SetSrc_str2(void);

    /// do we have a URL for gene display? 
    /// optional with default false
    /// typedef bool TGene_display
    ///  Check whether the Gene_display data member has been assigned a value.
    bool IsSetGene_display(void) const;
    /// Check whether it is safe or not to call GetGene_display method.
    bool CanGetGene_display(void) const;
    void ResetGene_display(void);
    void SetDefaultGene_display(void);
    TGene_display GetGene_display(void) const;
    void SetGene_display(TGene_display value);
    TGene_display& SetGene_display(void);

    /// do we have a URL for map/locus display? 
    /// optional with default false
    /// typedef bool TLocus_display
    ///  Check whether the Locus_display data member has been assigned a value.
    bool IsSetLocus_display(void) const;
    /// Check whether it is safe or not to call GetLocus_display method.
    bool CanGetLocus_display(void) const;
    void ResetLocus_display(void);
    void SetDefaultLocus_display(void);
    TLocus_display GetLocus_display(void) const;
    void SetLocus_display(TLocus_display value);
    TLocus_display& SetLocus_display(void);

    /// do we have a URL for extra indexing terms? 
    /// optional with default false
    /// typedef bool TExtra_terms
    ///  Check whether the Extra_terms data member has been assigned a value.
    bool IsSetExtra_terms(void) const;
    /// Check whether it is safe or not to call GetExtra_terms method.
    bool CanGetExtra_terms(void) const;
    void ResetExtra_terms(void);
    void SetDefaultExtra_terms(void);
    TExtra_terms GetExtra_terms(void) const;
    void SetExtra_terms(TExtra_terms value);
    TExtra_terms& SetExtra_terms(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CGene_source_Base(const CGene_source_Base&);
    CGene_source_Base& operator=(const CGene_source_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Src;
    int m_Src_int;
    string m_Src_str1;
    string m_Src_str2;
    bool m_Gene_display;
    bool m_Locus_display;
    bool m_Extra_terms;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CGene_source_Base::IsSetSrc(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CGene_source_Base::CanGetSrc(void) const
{
    return IsSetSrc();
}

inline
const CGene_source_Base::TSrc& CGene_source_Base::GetSrc(void) const
{
    if (!CanGetSrc()) {
        ThrowUnassigned(0);
    }
    return m_Src;
}

inline
void CGene_source_Base::SetSrc(const CGene_source_Base::TSrc& value)
{
    m_Src = value;
    m_set_State[0] |= 0x3;
}

inline
void CGene_source_Base::SetSrc(CGene_source_Base::TSrc&& value)
{
    m_Src = std::forward<CGene_source_Base::TSrc>(value);
    m_set_State[0] |= 0x3;
}

inline
CGene_source_Base::TSrc& CGene_source_Base::SetSrc(void)
{
#ifdef _DEBUG
    if (!IsSetSrc()) {
        m_Src = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Src;
}

inline
bool CGene_source_Base::IsSetSrc_int(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CGene_source_Base::CanGetSrc_int(void) const
{
    return IsSetSrc_int();
}

inline
void CGene_source_Base::ResetSrc_int(void)
{
    m_Src_int = 0;
    m_set_State[0] &= ~0xc;
}

inline
CGene_source_Base::TSrc_int CGene_source_Base::GetSrc_int(void) const
{
    if (!CanGetSrc_int()) {
        ThrowUnassigned(1);
    }
    return m_Src_int;
}

inline
void CGene_source_Base::SetSrc_int(CGene_source_Base::TSrc_int value)
{
    m_Src_int = value;
    m_set_State[0] |= 0xc;
}

inline
CGene_source_Base::TSrc_int& CGene_source_Base::SetSrc_int(void)
{
#ifdef _DEBUG
    if (!IsSetSrc_int()) {
        memset(&m_Src_int,UnassignedByte(),sizeof(m_Src_int));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Src_int;
}

inline
bool CGene_source_Base::IsSetSrc_str1(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CGene_source_Base::CanGetSrc_str1(void) const
{
    return IsSetSrc_str1();
}

inline
const CGene_source_Base::TSrc_str1& CGene_source_Base::GetSrc_str1(void) const
{
    if (!CanGetSrc_str1()) {
        ThrowUnassigned(2);
    }
    return m_Src_str1;
}

inline
void CGene_source_Base::SetSrc_str1(const CGene_source_Base::TSrc_str1& value)
{
    m_Src_str1 = value;
    m_set_State[0] |= 0x30;
}

inline
void CGene_source_Base::SetSrc_str1(CGene_source_Base::TSrc_str1&& value)
{
    m_Src_str1 = std::forward<CGene_source_Base::TSrc_str1>(value);
    m_set_State[0] |= 0x30;
}

inline
CGene_source_Base::TSrc_str1& CGene_source_Base::SetSrc_str1(void)
{
#ifdef _DEBUG
    if (!IsSetSrc_str1()) {
        m_Src_str1 = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Src_str1;
}

inline
bool CGene_source_Base::IsSetSrc_str2(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CGene_source_Base::CanGetSrc_str2(void) const
{
    return IsSetSrc_str2();
}

inline
const CGene_source_Base::TSrc_str2& CGene_source_Base::GetSrc_str2(void) const
{
    if (!CanGetSrc_str2()) {
        ThrowUnassigned(3);
    }
    return m_Src_str2;
}

inline
void CGene_source_Base::SetSrc_str2(const CGene_source_Base::TSrc_str2& value)
{
    m_Src_str2 = value;
    m_set_State[0] |= 0xc0;
}

inline
void CGene_source_Base::SetSrc_str2(CGene_source_Base::TSrc_str2&& value)
{
    m_Src_str2 = std::forward<CGene_source_Base::TSrc_str2>(value);
    m_set_State[0] |= 0xc0;
}

inline
CGene_source_Base::TSrc_str2& CGene_source_Base::SetSrc_str2(void)
{
#ifdef _DEBUG
    if (!IsSetSrc_str2()) {
        m_Src_str2 = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Src_str2;
}

inline
bool CGene_source_Base::IsSetGene_display(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CGene_source_Base::CanGetGene_display(void) const
{
    return true;
}

inline
void CGene_source_Base::ResetGene_display(void)
{
    m_Gene_display = false;
    m_set_State[0] &= ~0x300;
}

inline
void CGene_source_Base::SetDefaultGene_display(void)
{
    ResetGene_display();
}

inline
CGene_source_Base::TGene_display CGene_source_Base::GetGene_display(void) const
{
    return m_Gene_display;
}

inline
void CGene_source_Base::SetGene_display(CGene_source_Base::TGene_display value)
{
    m_Gene_display = value;
    m_set_State[0] |= 0x300;
}

inline
CGene_source_Base::TGene_display& CGene_source_Base::SetGene_display(void)
{
#ifdef _DEBUG
    if (!IsSetGene_display()) {
        memset(&m_Gene_display,UnassignedByte(),sizeof(m_Gene_display));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Gene_display;
}

inline
bool CGene_source_Base::IsSetLocus_display(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CGene_source_Base::CanGetLocus_display(void) const
{
    return true;
}

inline
void CGene_source_Base::ResetLocus_display(void)
{
    m_Locus_display = false;
    m_set_State[0] &= ~0xc00;
}

inline
void CGene_source_Base::SetDefaultLocus_display(void)
{
    ResetLocus_display();
}

inline
CGene_source_Base::TLocus_display CGene_source_Base::GetLocus_display(void) const
{
    return m_Locus_display;
}

inline
void CGene_source_Base::SetLocus_display(CGene_source_Base::TLocus_display value)
{
    m_Locus_display = value;
    m_set_State[0] |= 0xc00;
}

inline
CGene_source_Base::TLocus_display& CGene_source_Base::SetLocus_display(void)
{
#ifdef _DEBUG
    if (!IsSetLocus_display()) {
        memset(&m_Locus_display,UnassignedByte(),sizeof(m_Locus_display));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Locus_display;
}

inline
bool CGene_source_Base::IsSetExtra_terms(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CGene_source_Base::CanGetExtra_terms(void) const
{
    return true;
}

inline
void CGene_source_Base::ResetExtra_terms(void)
{
    m_Extra_terms = false;
    m_set_State[0] &= ~0x3000;
}

inline
void CGene_source_Base::SetDefaultExtra_terms(void)
{
    ResetExtra_terms();
}

inline
CGene_source_Base::TExtra_terms CGene_source_Base::GetExtra_terms(void) const
{
    return m_Extra_terms;
}

inline
void CGene_source_Base::SetExtra_terms(CGene_source_Base::TExtra_terms value)
{
    m_Extra_terms = value;
    m_set_State[0] |= 0x3000;
}

inline
CGene_source_Base::TExtra_terms& CGene_source_Base::SetExtra_terms(void)
{
#ifdef _DEBUG
    if (!IsSetExtra_terms()) {
        memset(&m_Extra_terms,UnassignedByte(),sizeof(m_Extra_terms));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Extra_terms;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZGENE_GENE_SOURCE_BASE_HPP
