/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Entrez2_boolean_term_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'entrez2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_ENTREZ2_ENTREZ2_BOOLEAN_TERM_BASE_HPP
#define OBJECTS_ENTREZ2_ENTREZ2_BOOLEAN_TERM_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/entrez2/Entrez2_field_id.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///*****************************************
/// the term is both sent and received as parts of
///   queries and replies. The attributes can be filled in
///   by either, but may be ignored by one or the other. Flags are
///   shown if a real value is only of use in the query (Q), only
///   in the reply (R), or used in both (B)
/// do-not-explode and do-not-translate are only active set by
///   by the query. However, they retain those settings in the
///   return value so they can be resent with a new query
///******************************************
class NCBI_ENTREZ2_EXPORT CEntrez2_boolean_term_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CEntrez2_boolean_term_Base(void);
    // destructor
    virtual ~CEntrez2_boolean_term_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef CEntrez2_field_id TField;
    typedef string TTerm;
    typedef int TTerm_count;
    typedef bool TDo_not_explode;
    typedef bool TDo_not_translate;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_field,
        e_term,
        e_term_count,
        e_do_not_explode,
        e_do_not_translate
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// B
    /// mandatory
    /// typedef CEntrez2_field_id TField
    ///  Check whether the Field data member has been assigned a value.
    bool IsSetField(void) const;
    /// Check whether it is safe or not to call GetField method.
    bool CanGetField(void) const;
    void ResetField(void);
    const TField& GetField(void) const;
    void SetField(const TField& value);
    TField& SetField(void);

    /// B
    /// mandatory
    /// typedef string TTerm
    ///  Check whether the Term data member has been assigned a value.
    bool IsSetTerm(void) const;
    /// Check whether it is safe or not to call GetTerm method.
    bool CanGetTerm(void) const;
    void ResetTerm(void);
    const TTerm& GetTerm(void) const;
    void SetTerm(const TTerm& value);
    void SetTerm(TTerm&& value);
    TTerm& SetTerm(void);

    /// R count of records with term
    /// optional
    /// typedef int TTerm_count
    ///  Check whether the Term_count data member has been assigned a value.
    bool IsSetTerm_count(void) const;
    /// Check whether it is safe or not to call GetTerm_count method.
    bool CanGetTerm_count(void) const;
    void ResetTerm_count(void);
    TTerm_count GetTerm_count(void) const;
    void SetTerm_count(TTerm_count value);
    TTerm_count& SetTerm_count(void);

    /// Q do not explode term
    /// optional with default false
    /// typedef bool TDo_not_explode
    ///  Check whether the Do_not_explode data member has been assigned a value.
    bool IsSetDo_not_explode(void) const;
    /// Check whether it is safe or not to call GetDo_not_explode method.
    bool CanGetDo_not_explode(void) const;
    void ResetDo_not_explode(void);
    void SetDefaultDo_not_explode(void);
    TDo_not_explode GetDo_not_explode(void) const;
    void SetDo_not_explode(TDo_not_explode value);
    TDo_not_explode& SetDo_not_explode(void);

    /// Q do not use synonyms
    /// optional with default false
    /// typedef bool TDo_not_translate
    ///  Check whether the Do_not_translate data member has been assigned a value.
    bool IsSetDo_not_translate(void) const;
    /// Check whether it is safe or not to call GetDo_not_translate method.
    bool CanGetDo_not_translate(void) const;
    void ResetDo_not_translate(void);
    void SetDefaultDo_not_translate(void);
    TDo_not_translate GetDo_not_translate(void) const;
    void SetDo_not_translate(TDo_not_translate value);
    TDo_not_translate& SetDo_not_translate(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CEntrez2_boolean_term_Base(const CEntrez2_boolean_term_Base&);
    CEntrez2_boolean_term_Base& operator=(const CEntrez2_boolean_term_Base&);

    // data
    Uint4 m_set_State[1];
    CEntrez2_field_id m_Field;
    string m_Term;
    int m_Term_count;
    bool m_Do_not_explode;
    bool m_Do_not_translate;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CEntrez2_boolean_term_Base::IsSetField(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CEntrez2_boolean_term_Base::CanGetField(void) const
{
    return IsSetField();
}

inline
const CEntrez2_boolean_term_Base::TField& CEntrez2_boolean_term_Base::GetField(void) const
{
    if (!CanGetField()) {
        ThrowUnassigned(0);
    }
    return m_Field;
}

inline
void CEntrez2_boolean_term_Base::SetField(const CEntrez2_boolean_term_Base::TField& value)
{
    m_Field = value;
    m_set_State[0] |= 0x3;
}

inline
CEntrez2_boolean_term_Base::TField& CEntrez2_boolean_term_Base::SetField(void)
{
    m_set_State[0] |= 0x1;
    return m_Field;
}

inline
bool CEntrez2_boolean_term_Base::IsSetTerm(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CEntrez2_boolean_term_Base::CanGetTerm(void) const
{
    return IsSetTerm();
}

inline
const CEntrez2_boolean_term_Base::TTerm& CEntrez2_boolean_term_Base::GetTerm(void) const
{
    if (!CanGetTerm()) {
        ThrowUnassigned(1);
    }
    return m_Term;
}

inline
void CEntrez2_boolean_term_Base::SetTerm(const CEntrez2_boolean_term_Base::TTerm& value)
{
    m_Term = value;
    m_set_State[0] |= 0xc;
}

inline
void CEntrez2_boolean_term_Base::SetTerm(CEntrez2_boolean_term_Base::TTerm&& value)
{
    m_Term = std::forward<CEntrez2_boolean_term_Base::TTerm>(value);
    m_set_State[0] |= 0xc;
}

inline
CEntrez2_boolean_term_Base::TTerm& CEntrez2_boolean_term_Base::SetTerm(void)
{
#ifdef _DEBUG
    if (!IsSetTerm()) {
        m_Term = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Term;
}

inline
bool CEntrez2_boolean_term_Base::IsSetTerm_count(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CEntrez2_boolean_term_Base::CanGetTerm_count(void) const
{
    return IsSetTerm_count();
}

inline
void CEntrez2_boolean_term_Base::ResetTerm_count(void)
{
    m_Term_count = 0;
    m_set_State[0] &= ~0x30;
}

inline
CEntrez2_boolean_term_Base::TTerm_count CEntrez2_boolean_term_Base::GetTerm_count(void) const
{
    if (!CanGetTerm_count()) {
        ThrowUnassigned(2);
    }
    return m_Term_count;
}

inline
void CEntrez2_boolean_term_Base::SetTerm_count(CEntrez2_boolean_term_Base::TTerm_count value)
{
    m_Term_count = value;
    m_set_State[0] |= 0x30;
}

inline
CEntrez2_boolean_term_Base::TTerm_count& CEntrez2_boolean_term_Base::SetTerm_count(void)
{
#ifdef _DEBUG
    if (!IsSetTerm_count()) {
        memset(&m_Term_count,UnassignedByte(),sizeof(m_Term_count));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Term_count;
}

inline
bool CEntrez2_boolean_term_Base::IsSetDo_not_explode(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CEntrez2_boolean_term_Base::CanGetDo_not_explode(void) const
{
    return true;
}

inline
void CEntrez2_boolean_term_Base::ResetDo_not_explode(void)
{
    m_Do_not_explode = false;
    m_set_State[0] &= ~0xc0;
}

inline
void CEntrez2_boolean_term_Base::SetDefaultDo_not_explode(void)
{
    ResetDo_not_explode();
}

inline
CEntrez2_boolean_term_Base::TDo_not_explode CEntrez2_boolean_term_Base::GetDo_not_explode(void) const
{
    return m_Do_not_explode;
}

inline
void CEntrez2_boolean_term_Base::SetDo_not_explode(CEntrez2_boolean_term_Base::TDo_not_explode value)
{
    m_Do_not_explode = value;
    m_set_State[0] |= 0xc0;
}

inline
CEntrez2_boolean_term_Base::TDo_not_explode& CEntrez2_boolean_term_Base::SetDo_not_explode(void)
{
#ifdef _DEBUG
    if (!IsSetDo_not_explode()) {
        memset(&m_Do_not_explode,UnassignedByte(),sizeof(m_Do_not_explode));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Do_not_explode;
}

inline
bool CEntrez2_boolean_term_Base::IsSetDo_not_translate(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CEntrez2_boolean_term_Base::CanGetDo_not_translate(void) const
{
    return true;
}

inline
void CEntrez2_boolean_term_Base::ResetDo_not_translate(void)
{
    m_Do_not_translate = false;
    m_set_State[0] &= ~0x300;
}

inline
void CEntrez2_boolean_term_Base::SetDefaultDo_not_translate(void)
{
    ResetDo_not_translate();
}

inline
CEntrez2_boolean_term_Base::TDo_not_translate CEntrez2_boolean_term_Base::GetDo_not_translate(void) const
{
    return m_Do_not_translate;
}

inline
void CEntrez2_boolean_term_Base::SetDo_not_translate(CEntrez2_boolean_term_Base::TDo_not_translate value)
{
    m_Do_not_translate = value;
    m_set_State[0] |= 0x300;
}

inline
CEntrez2_boolean_term_Base::TDo_not_translate& CEntrez2_boolean_term_Base::SetDo_not_translate(void)
{
#ifdef _DEBUG
    if (!IsSetDo_not_translate()) {
        memset(&m_Do_not_translate,UnassignedByte(),sizeof(m_Do_not_translate));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Do_not_translate;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_ENTREZ2_ENTREZ2_BOOLEAN_TERM_BASE_HPP
