/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file FxnSet_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'docsum.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_DOCSUM_FXNSET_BASE_HPP
#define OBJECTS_DOCSUM_FXNSET_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///functional relationship of SNP (and possibly alleles) to genes at
///				contig location as defined in organism-specific bxxx_SNPContigLocusId_xxx
///				tables.
class NCBI_DOCSUM_EXPORT CFxnSet_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CFxnSet_Base(void);
    // destructor
    virtual ~CFxnSet_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        ///variation in region of gene, but not in
        ///										transcript - deprecated
        enum EAttlist_fxnClass {
            eAttlist_fxnClass_locus_region                      =  1,
            eAttlist_fxnClass_coding_unknown                    =  2,
            eAttlist_fxnClass_synonymous_codon                  =  3,
            eAttlist_fxnClass_non_synonymous_codon              =  4,
            eAttlist_fxnClass_mrna_utr                          =  5,
            eAttlist_fxnClass_intron_variant                    =  6,
            eAttlist_fxnClass_splice_region_variant             =  7,
            eAttlist_fxnClass_reference                         =  8,
            eAttlist_fxnClass_coding_exception                  =  9,
            eAttlist_fxnClass_coding_sequence_variant           = 10,
            eAttlist_fxnClass_nc_transcript_variant             = 11,
            eAttlist_fxnClass_downstream_variant_500B           = 12,
            eAttlist_fxnClass_upstream_variant_2KB              = 13,
            eAttlist_fxnClass_nonsense                          = 14,
            eAttlist_fxnClass_missense                          = 15,
            eAttlist_fxnClass_frameshift_variant                = 16,
            eAttlist_fxnClass_utr_variant_3_prime               = 17,
            eAttlist_fxnClass_utr_variant_5_prime               = 18,
            eAttlist_fxnClass_splice_acceptor_variant           = 19,
            eAttlist_fxnClass_splice_donor_variant              = 20,
            eAttlist_fxnClass_cds_indel                         = 21,
            eAttlist_fxnClass_stop_gained                       = 22,
            eAttlist_fxnClass_stop_lost                         = 23,
            eAttlist_fxnClass_complex_change_in_transcript      = 24,
            eAttlist_fxnClass_incomplete_terminal_codon_variant = 25,
            eAttlist_fxnClass_nmd_transcript_variant            = 26,
            eAttlist_fxnClass_mature_miRNA_variant              = 27,
            eAttlist_fxnClass_upstream_variant_5KB              = 28,
            eAttlist_fxnClass_downstream_variant_5KB            = 29,
            eAttlist_fxnClass_intergenic                        = 30
        };
        
        /// Access to EAttlist_fxnClass's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_fxnClass)(void);
        
        // types
        typedef int TGeneId;
        typedef string TSymbol;
        typedef string TMrnaAcc;
        typedef int TMrnaVer;
        typedef string TProtAcc;
        typedef int TProtVer;
        typedef EAttlist_fxnClass TFxnClass;
        typedef int TReadingFrame;
        typedef string TAllele;
        typedef string TResidue;
        typedef int TAaPosition;
        typedef int TMrnaPosition;
        typedef string TSoTerm;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_geneId,
            e_symbol,
            e_mrnaAcc,
            e_mrnaVer,
            e_protAcc,
            e_protVer,
            e_fxnClass,
            e_readingFrame,
            e_allele,
            e_residue,
            e_aaPosition,
            e_mrnaPosition,
            e_soTerm
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 14> TmemberIndex;
    
        // getters
        // setters
    
        ///gene-id of gene as aligned to contig
        /// optional
        /// typedef int TGeneId
        ///  Check whether the GeneId data member has been assigned a value.
        bool IsSetGeneId(void) const;
        /// Check whether it is safe or not to call GetGeneId method.
        bool CanGetGeneId(void) const;
        void ResetGeneId(void);
        TGeneId GetGeneId(void) const;
        void SetGeneId(TGeneId value);
        TGeneId& SetGeneId(void);
    
        ///symbol (official if present in Entrez Gene) of
        ///						gene
        /// optional
        /// typedef string TSymbol
        ///  Check whether the Symbol data member has been assigned a value.
        bool IsSetSymbol(void) const;
        /// Check whether it is safe or not to call GetSymbol method.
        bool CanGetSymbol(void) const;
        void ResetSymbol(void);
        const TSymbol& GetSymbol(void) const;
        void SetSymbol(const TSymbol& value);
        void SetSymbol(TSymbol&& value);
        TSymbol& SetSymbol(void);
    
        ///mRNA accession if variation in transcript
        /// optional
        /// typedef string TMrnaAcc
        ///  Check whether the MrnaAcc data member has been assigned a value.
        bool IsSetMrnaAcc(void) const;
        /// Check whether it is safe or not to call GetMrnaAcc method.
        bool CanGetMrnaAcc(void) const;
        void ResetMrnaAcc(void);
        const TMrnaAcc& GetMrnaAcc(void) const;
        void SetMrnaAcc(const TMrnaAcc& value);
        void SetMrnaAcc(TMrnaAcc&& value);
        TMrnaAcc& SetMrnaAcc(void);
    
        ///mRNA sequence version if variation is in
        ///						transcripot
        /// optional
        /// typedef int TMrnaVer
        ///  Check whether the MrnaVer data member has been assigned a value.
        bool IsSetMrnaVer(void) const;
        /// Check whether it is safe or not to call GetMrnaVer method.
        bool CanGetMrnaVer(void) const;
        void ResetMrnaVer(void);
        TMrnaVer GetMrnaVer(void) const;
        void SetMrnaVer(TMrnaVer value);
        TMrnaVer& SetMrnaVer(void);
    
        ///protein accession if variation in protein
        /// optional
        /// typedef string TProtAcc
        ///  Check whether the ProtAcc data member has been assigned a value.
        bool IsSetProtAcc(void) const;
        /// Check whether it is safe or not to call GetProtAcc method.
        bool CanGetProtAcc(void) const;
        void ResetProtAcc(void);
        const TProtAcc& GetProtAcc(void) const;
        void SetProtAcc(const TProtAcc& value);
        void SetProtAcc(TProtAcc&& value);
        TProtAcc& SetProtAcc(void);
    
        ///protein version if variation is in
        ///						protein
        /// optional
        /// typedef int TProtVer
        ///  Check whether the ProtVer data member has been assigned a value.
        bool IsSetProtVer(void) const;
        /// Check whether it is safe or not to call GetProtVer method.
        bool CanGetProtVer(void) const;
        void ResetProtVer(void);
        TProtVer GetProtVer(void) const;
        void SetProtVer(TProtVer value);
        TProtVer& SetProtVer(void);
    
        /// optional
        /// typedef EAttlist_fxnClass TFxnClass
        ///  Check whether the FxnClass data member has been assigned a value.
        bool IsSetFxnClass(void) const;
        /// Check whether it is safe or not to call GetFxnClass method.
        bool CanGetFxnClass(void) const;
        void ResetFxnClass(void);
        TFxnClass GetFxnClass(void) const;
        void SetFxnClass(TFxnClass value);
        TFxnClass& SetFxnClass(void);
    
        /// optional
        /// typedef int TReadingFrame
        ///  Check whether the ReadingFrame data member has been assigned a value.
        bool IsSetReadingFrame(void) const;
        /// Check whether it is safe or not to call GetReadingFrame method.
        bool CanGetReadingFrame(void) const;
        void ResetReadingFrame(void);
        TReadingFrame GetReadingFrame(void) const;
        void SetReadingFrame(TReadingFrame value);
        TReadingFrame& SetReadingFrame(void);
    
        ///variation allele: * suffix indicates allele of contig at this
        ///						location
        /// optional
        /// typedef string TAllele
        ///  Check whether the Allele data member has been assigned a value.
        bool IsSetAllele(void) const;
        /// Check whether it is safe or not to call GetAllele method.
        bool CanGetAllele(void) const;
        void ResetAllele(void);
        const TAllele& GetAllele(void) const;
        void SetAllele(const TAllele& value);
        void SetAllele(TAllele&& value);
        TAllele& SetAllele(void);
    
        ///translated amino acid residue for allele
        /// optional
        /// typedef string TResidue
        ///  Check whether the Residue data member has been assigned a value.
        bool IsSetResidue(void) const;
        /// Check whether it is safe or not to call GetResidue method.
        bool CanGetResidue(void) const;
        void ResetResidue(void);
        const TResidue& GetResidue(void) const;
        void SetResidue(const TResidue& value);
        void SetResidue(TResidue&& value);
        TResidue& SetResidue(void);
    
        ///position of the variant residue in peptide
        ///						sequence
        /// optional
        /// typedef int TAaPosition
        ///  Check whether the AaPosition data member has been assigned a value.
        bool IsSetAaPosition(void) const;
        /// Check whether it is safe or not to call GetAaPosition method.
        bool CanGetAaPosition(void) const;
        void ResetAaPosition(void);
        TAaPosition GetAaPosition(void) const;
        void SetAaPosition(TAaPosition value);
        TAaPosition& SetAaPosition(void);
    
        /// optional
        /// typedef int TMrnaPosition
        ///  Check whether the MrnaPosition data member has been assigned a value.
        bool IsSetMrnaPosition(void) const;
        /// Check whether it is safe or not to call GetMrnaPosition method.
        bool CanGetMrnaPosition(void) const;
        void ResetMrnaPosition(void);
        TMrnaPosition GetMrnaPosition(void) const;
        void SetMrnaPosition(TMrnaPosition value);
        TMrnaPosition& SetMrnaPosition(void);
    
        /// optional
        /// typedef string TSoTerm
        ///  Check whether the SoTerm data member has been assigned a value.
        bool IsSetSoTerm(void) const;
        /// Check whether it is safe or not to call GetSoTerm method.
        bool CanGetSoTerm(void) const;
        void ResetSoTerm(void);
        const TSoTerm& GetSoTerm(void) const;
        void SetSoTerm(const TSoTerm& value);
        void SetSoTerm(TSoTerm&& value);
        TSoTerm& SetSoTerm(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        int m_GeneId;
        string m_Symbol;
        string m_MrnaAcc;
        int m_MrnaVer;
        string m_ProtAcc;
        int m_ProtVer;
        EAttlist_fxnClass m_FxnClass;
        int m_ReadingFrame;
        string m_Allele;
        string m_Residue;
        int m_AaPosition;
        int m_MrnaPosition;
        string m_SoTerm;
    };
    // types
    typedef C_Attlist TAttlist;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_attlist,
        e_fxnSet
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    ///functional relationship of SNP (and possibly alleles) to genes at
    ///				contig location as defined in organism-specific bxxx_SNPContigLocusId_xxx
    ///				tables.
    /// mandatory
    ///  Check whether the FxnSet data member has been assigned a value.
    bool IsSetFxnSet(void) const;
    /// Check whether it is safe or not to call GetFxnSet method.
    bool CanGetFxnSet(void) const;
    void ResetFxnSet(void);
    void SetFxnSet(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CFxnSet_Base(const CFxnSet_Base&);
    CFxnSet_Base& operator=(const CFxnSet_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAttlist > m_Attlist;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CFxnSet_Base::C_Attlist::IsSetGeneId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetGeneId(void) const
{
    return IsSetGeneId();
}

inline
void CFxnSet_Base::C_Attlist::ResetGeneId(void)
{
    m_GeneId = 0;
    m_set_State[0] &= ~0x3;
}

inline
CFxnSet_Base::C_Attlist::TGeneId CFxnSet_Base::C_Attlist::GetGeneId(void) const
{
    if (!CanGetGeneId()) {
        ThrowUnassigned(0);
    }
    return m_GeneId;
}

inline
void CFxnSet_Base::C_Attlist::SetGeneId(CFxnSet_Base::C_Attlist::TGeneId value)
{
    m_GeneId = value;
    m_set_State[0] |= 0x3;
}

inline
CFxnSet_Base::C_Attlist::TGeneId& CFxnSet_Base::C_Attlist::SetGeneId(void)
{
#ifdef _DEBUG
    if (!IsSetGeneId()) {
        memset(&m_GeneId,UnassignedByte(),sizeof(m_GeneId));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_GeneId;
}

inline
bool CFxnSet_Base::C_Attlist::IsSetSymbol(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetSymbol(void) const
{
    return IsSetSymbol();
}

inline
const CFxnSet_Base::C_Attlist::TSymbol& CFxnSet_Base::C_Attlist::GetSymbol(void) const
{
    if (!CanGetSymbol()) {
        ThrowUnassigned(1);
    }
    return m_Symbol;
}

inline
void CFxnSet_Base::C_Attlist::SetSymbol(const CFxnSet_Base::C_Attlist::TSymbol& value)
{
    m_Symbol = value;
    m_set_State[0] |= 0xc;
}

inline
void CFxnSet_Base::C_Attlist::SetSymbol(CFxnSet_Base::C_Attlist::TSymbol&& value)
{
    m_Symbol = std::forward<CFxnSet_Base::C_Attlist::TSymbol>(value);
    m_set_State[0] |= 0xc;
}

inline
CFxnSet_Base::C_Attlist::TSymbol& CFxnSet_Base::C_Attlist::SetSymbol(void)
{
#ifdef _DEBUG
    if (!IsSetSymbol()) {
        m_Symbol = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Symbol;
}

inline
bool CFxnSet_Base::C_Attlist::IsSetMrnaAcc(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetMrnaAcc(void) const
{
    return IsSetMrnaAcc();
}

inline
const CFxnSet_Base::C_Attlist::TMrnaAcc& CFxnSet_Base::C_Attlist::GetMrnaAcc(void) const
{
    if (!CanGetMrnaAcc()) {
        ThrowUnassigned(2);
    }
    return m_MrnaAcc;
}

inline
void CFxnSet_Base::C_Attlist::SetMrnaAcc(const CFxnSet_Base::C_Attlist::TMrnaAcc& value)
{
    m_MrnaAcc = value;
    m_set_State[0] |= 0x30;
}

inline
void CFxnSet_Base::C_Attlist::SetMrnaAcc(CFxnSet_Base::C_Attlist::TMrnaAcc&& value)
{
    m_MrnaAcc = std::forward<CFxnSet_Base::C_Attlist::TMrnaAcc>(value);
    m_set_State[0] |= 0x30;
}

inline
CFxnSet_Base::C_Attlist::TMrnaAcc& CFxnSet_Base::C_Attlist::SetMrnaAcc(void)
{
#ifdef _DEBUG
    if (!IsSetMrnaAcc()) {
        m_MrnaAcc = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_MrnaAcc;
}

inline
bool CFxnSet_Base::C_Attlist::IsSetMrnaVer(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetMrnaVer(void) const
{
    return IsSetMrnaVer();
}

inline
void CFxnSet_Base::C_Attlist::ResetMrnaVer(void)
{
    m_MrnaVer = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CFxnSet_Base::C_Attlist::TMrnaVer CFxnSet_Base::C_Attlist::GetMrnaVer(void) const
{
    if (!CanGetMrnaVer()) {
        ThrowUnassigned(3);
    }
    return m_MrnaVer;
}

inline
void CFxnSet_Base::C_Attlist::SetMrnaVer(CFxnSet_Base::C_Attlist::TMrnaVer value)
{
    m_MrnaVer = value;
    m_set_State[0] |= 0xc0;
}

inline
CFxnSet_Base::C_Attlist::TMrnaVer& CFxnSet_Base::C_Attlist::SetMrnaVer(void)
{
#ifdef _DEBUG
    if (!IsSetMrnaVer()) {
        memset(&m_MrnaVer,UnassignedByte(),sizeof(m_MrnaVer));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_MrnaVer;
}

inline
bool CFxnSet_Base::C_Attlist::IsSetProtAcc(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetProtAcc(void) const
{
    return IsSetProtAcc();
}

inline
const CFxnSet_Base::C_Attlist::TProtAcc& CFxnSet_Base::C_Attlist::GetProtAcc(void) const
{
    if (!CanGetProtAcc()) {
        ThrowUnassigned(4);
    }
    return m_ProtAcc;
}

inline
void CFxnSet_Base::C_Attlist::SetProtAcc(const CFxnSet_Base::C_Attlist::TProtAcc& value)
{
    m_ProtAcc = value;
    m_set_State[0] |= 0x300;
}

inline
void CFxnSet_Base::C_Attlist::SetProtAcc(CFxnSet_Base::C_Attlist::TProtAcc&& value)
{
    m_ProtAcc = std::forward<CFxnSet_Base::C_Attlist::TProtAcc>(value);
    m_set_State[0] |= 0x300;
}

inline
CFxnSet_Base::C_Attlist::TProtAcc& CFxnSet_Base::C_Attlist::SetProtAcc(void)
{
#ifdef _DEBUG
    if (!IsSetProtAcc()) {
        m_ProtAcc = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_ProtAcc;
}

inline
bool CFxnSet_Base::C_Attlist::IsSetProtVer(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetProtVer(void) const
{
    return IsSetProtVer();
}

inline
void CFxnSet_Base::C_Attlist::ResetProtVer(void)
{
    m_ProtVer = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CFxnSet_Base::C_Attlist::TProtVer CFxnSet_Base::C_Attlist::GetProtVer(void) const
{
    if (!CanGetProtVer()) {
        ThrowUnassigned(5);
    }
    return m_ProtVer;
}

inline
void CFxnSet_Base::C_Attlist::SetProtVer(CFxnSet_Base::C_Attlist::TProtVer value)
{
    m_ProtVer = value;
    m_set_State[0] |= 0xc00;
}

inline
CFxnSet_Base::C_Attlist::TProtVer& CFxnSet_Base::C_Attlist::SetProtVer(void)
{
#ifdef _DEBUG
    if (!IsSetProtVer()) {
        memset(&m_ProtVer,UnassignedByte(),sizeof(m_ProtVer));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_ProtVer;
}

inline
bool CFxnSet_Base::C_Attlist::IsSetFxnClass(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetFxnClass(void) const
{
    return IsSetFxnClass();
}

inline
void CFxnSet_Base::C_Attlist::ResetFxnClass(void)
{
    m_FxnClass = (EAttlist_fxnClass)(0);
    m_set_State[0] &= ~0x3000;
}

inline
CFxnSet_Base::C_Attlist::TFxnClass CFxnSet_Base::C_Attlist::GetFxnClass(void) const
{
    if (!CanGetFxnClass()) {
        ThrowUnassigned(6);
    }
    return m_FxnClass;
}

inline
void CFxnSet_Base::C_Attlist::SetFxnClass(CFxnSet_Base::C_Attlist::TFxnClass value)
{
    m_FxnClass = value;
    m_set_State[0] |= 0x3000;
}

inline
CFxnSet_Base::C_Attlist::TFxnClass& CFxnSet_Base::C_Attlist::SetFxnClass(void)
{
#ifdef _DEBUG
    if (!IsSetFxnClass()) {
        memset(&m_FxnClass,UnassignedByte(),sizeof(m_FxnClass));
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_FxnClass;
}

inline
bool CFxnSet_Base::C_Attlist::IsSetReadingFrame(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetReadingFrame(void) const
{
    return IsSetReadingFrame();
}

inline
void CFxnSet_Base::C_Attlist::ResetReadingFrame(void)
{
    m_ReadingFrame = 0;
    m_set_State[0] &= ~0xc000;
}

inline
CFxnSet_Base::C_Attlist::TReadingFrame CFxnSet_Base::C_Attlist::GetReadingFrame(void) const
{
    if (!CanGetReadingFrame()) {
        ThrowUnassigned(7);
    }
    return m_ReadingFrame;
}

inline
void CFxnSet_Base::C_Attlist::SetReadingFrame(CFxnSet_Base::C_Attlist::TReadingFrame value)
{
    m_ReadingFrame = value;
    m_set_State[0] |= 0xc000;
}

inline
CFxnSet_Base::C_Attlist::TReadingFrame& CFxnSet_Base::C_Attlist::SetReadingFrame(void)
{
#ifdef _DEBUG
    if (!IsSetReadingFrame()) {
        memset(&m_ReadingFrame,UnassignedByte(),sizeof(m_ReadingFrame));
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_ReadingFrame;
}

inline
bool CFxnSet_Base::C_Attlist::IsSetAllele(void) const
{
    return ((m_set_State[0] & 0x30000) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetAllele(void) const
{
    return IsSetAllele();
}

inline
const CFxnSet_Base::C_Attlist::TAllele& CFxnSet_Base::C_Attlist::GetAllele(void) const
{
    if (!CanGetAllele()) {
        ThrowUnassigned(8);
    }
    return m_Allele;
}

inline
void CFxnSet_Base::C_Attlist::SetAllele(const CFxnSet_Base::C_Attlist::TAllele& value)
{
    m_Allele = value;
    m_set_State[0] |= 0x30000;
}

inline
void CFxnSet_Base::C_Attlist::SetAllele(CFxnSet_Base::C_Attlist::TAllele&& value)
{
    m_Allele = std::forward<CFxnSet_Base::C_Attlist::TAllele>(value);
    m_set_State[0] |= 0x30000;
}

inline
CFxnSet_Base::C_Attlist::TAllele& CFxnSet_Base::C_Attlist::SetAllele(void)
{
#ifdef _DEBUG
    if (!IsSetAllele()) {
        m_Allele = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10000;
    return m_Allele;
}

inline
bool CFxnSet_Base::C_Attlist::IsSetResidue(void) const
{
    return ((m_set_State[0] & 0xc0000) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetResidue(void) const
{
    return IsSetResidue();
}

inline
const CFxnSet_Base::C_Attlist::TResidue& CFxnSet_Base::C_Attlist::GetResidue(void) const
{
    if (!CanGetResidue()) {
        ThrowUnassigned(9);
    }
    return m_Residue;
}

inline
void CFxnSet_Base::C_Attlist::SetResidue(const CFxnSet_Base::C_Attlist::TResidue& value)
{
    m_Residue = value;
    m_set_State[0] |= 0xc0000;
}

inline
void CFxnSet_Base::C_Attlist::SetResidue(CFxnSet_Base::C_Attlist::TResidue&& value)
{
    m_Residue = std::forward<CFxnSet_Base::C_Attlist::TResidue>(value);
    m_set_State[0] |= 0xc0000;
}

inline
CFxnSet_Base::C_Attlist::TResidue& CFxnSet_Base::C_Attlist::SetResidue(void)
{
#ifdef _DEBUG
    if (!IsSetResidue()) {
        m_Residue = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40000;
    return m_Residue;
}

inline
bool CFxnSet_Base::C_Attlist::IsSetAaPosition(void) const
{
    return ((m_set_State[0] & 0x300000) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetAaPosition(void) const
{
    return IsSetAaPosition();
}

inline
void CFxnSet_Base::C_Attlist::ResetAaPosition(void)
{
    m_AaPosition = 0;
    m_set_State[0] &= ~0x300000;
}

inline
CFxnSet_Base::C_Attlist::TAaPosition CFxnSet_Base::C_Attlist::GetAaPosition(void) const
{
    if (!CanGetAaPosition()) {
        ThrowUnassigned(10);
    }
    return m_AaPosition;
}

inline
void CFxnSet_Base::C_Attlist::SetAaPosition(CFxnSet_Base::C_Attlist::TAaPosition value)
{
    m_AaPosition = value;
    m_set_State[0] |= 0x300000;
}

inline
CFxnSet_Base::C_Attlist::TAaPosition& CFxnSet_Base::C_Attlist::SetAaPosition(void)
{
#ifdef _DEBUG
    if (!IsSetAaPosition()) {
        memset(&m_AaPosition,UnassignedByte(),sizeof(m_AaPosition));
    }
#endif
    m_set_State[0] |= 0x100000;
    return m_AaPosition;
}

inline
bool CFxnSet_Base::C_Attlist::IsSetMrnaPosition(void) const
{
    return ((m_set_State[0] & 0xc00000) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetMrnaPosition(void) const
{
    return IsSetMrnaPosition();
}

inline
void CFxnSet_Base::C_Attlist::ResetMrnaPosition(void)
{
    m_MrnaPosition = 0;
    m_set_State[0] &= ~0xc00000;
}

inline
CFxnSet_Base::C_Attlist::TMrnaPosition CFxnSet_Base::C_Attlist::GetMrnaPosition(void) const
{
    if (!CanGetMrnaPosition()) {
        ThrowUnassigned(11);
    }
    return m_MrnaPosition;
}

inline
void CFxnSet_Base::C_Attlist::SetMrnaPosition(CFxnSet_Base::C_Attlist::TMrnaPosition value)
{
    m_MrnaPosition = value;
    m_set_State[0] |= 0xc00000;
}

inline
CFxnSet_Base::C_Attlist::TMrnaPosition& CFxnSet_Base::C_Attlist::SetMrnaPosition(void)
{
#ifdef _DEBUG
    if (!IsSetMrnaPosition()) {
        memset(&m_MrnaPosition,UnassignedByte(),sizeof(m_MrnaPosition));
    }
#endif
    m_set_State[0] |= 0x400000;
    return m_MrnaPosition;
}

inline
bool CFxnSet_Base::C_Attlist::IsSetSoTerm(void) const
{
    return ((m_set_State[0] & 0x3000000) != 0);
}

inline
bool CFxnSet_Base::C_Attlist::CanGetSoTerm(void) const
{
    return IsSetSoTerm();
}

inline
const CFxnSet_Base::C_Attlist::TSoTerm& CFxnSet_Base::C_Attlist::GetSoTerm(void) const
{
    if (!CanGetSoTerm()) {
        ThrowUnassigned(12);
    }
    return m_SoTerm;
}

inline
void CFxnSet_Base::C_Attlist::SetSoTerm(const CFxnSet_Base::C_Attlist::TSoTerm& value)
{
    m_SoTerm = value;
    m_set_State[0] |= 0x3000000;
}

inline
void CFxnSet_Base::C_Attlist::SetSoTerm(CFxnSet_Base::C_Attlist::TSoTerm&& value)
{
    m_SoTerm = std::forward<CFxnSet_Base::C_Attlist::TSoTerm>(value);
    m_set_State[0] |= 0x3000000;
}

inline
CFxnSet_Base::C_Attlist::TSoTerm& CFxnSet_Base::C_Attlist::SetSoTerm(void)
{
#ifdef _DEBUG
    if (!IsSetSoTerm()) {
        m_SoTerm = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000000;
    return m_SoTerm;
}

inline
bool CFxnSet_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CFxnSet_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CFxnSet_Base::TAttlist& CFxnSet_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CFxnSet_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CFxnSet_Base::TAttlist& CFxnSet_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CFxnSet_Base::IsSetFxnSet(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CFxnSet_Base::CanGetFxnSet(void) const
{
    return false;
}

inline
void CFxnSet_Base::ResetFxnSet(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CFxnSet_Base::SetFxnSet(void)
{
    m_set_State[0] |= 0xc;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_DOCSUM_FXNSET_BASE_HPP
