/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file BaseURL_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'docsum.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_DOCSUM_BASEURL_BASE_HPP
#define OBJECTS_DOCSUM_BASEURL_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
///URL value from dbSNP_main.BaseURL links table. attributes provide
///				context information and URL id that is referenced within individual refSNP
///				objects.
class NCBI_DOCSUM_EXPORT CBaseURL_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBaseURL_Base(void);
    // destructor
    virtual ~CBaseURL_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef int TUrlId;
        typedef string TResourceName;
        typedef string TResourceId;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_urlId,
            e_resourceName,
            e_resourceId
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;
    
        // getters
        // setters
    
        ///Resource identifier from
        ///								dbSNP_main.baseURL.
        /// optional
        /// typedef int TUrlId
        ///  Check whether the UrlId data member has been assigned a value.
        bool IsSetUrlId(void) const;
        /// Check whether it is safe or not to call GetUrlId method.
        bool CanGetUrlId(void) const;
        void ResetUrlId(void);
        TUrlId GetUrlId(void) const;
        void SetUrlId(TUrlId value);
        TUrlId& SetUrlId(void);
    
        ///Name of linked resource
        /// optional
        /// typedef string TResourceName
        ///  Check whether the ResourceName data member has been assigned a value.
        bool IsSetResourceName(void) const;
        /// Check whether it is safe or not to call GetResourceName method.
        bool CanGetResourceName(void) const;
        void ResetResourceName(void);
        const TResourceName& GetResourceName(void) const;
        void SetResourceName(const TResourceName& value);
        void SetResourceName(TResourceName&& value);
        TResourceName& SetResourceName(void);
    
        ///identifier expected by resource for
        ///								URL
        /// optional
        /// typedef string TResourceId
        ///  Check whether the ResourceId data member has been assigned a value.
        bool IsSetResourceId(void) const;
        /// Check whether it is safe or not to call GetResourceId method.
        bool CanGetResourceId(void) const;
        void ResetResourceId(void);
        const TResourceId& GetResourceId(void) const;
        void SetResourceId(const TResourceId& value);
        void SetResourceId(TResourceId&& value);
        TResourceId& SetResourceId(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        int m_UrlId;
        string m_ResourceName;
        string m_ResourceId;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef string TBaseURL;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_attlist,
        e_baseURL
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    ///URL value from dbSNP_main.BaseURL links table. attributes provide
    ///				context information and URL id that is referenced within individual refSNP
    ///				objects.
    /// mandatory
    /// typedef string TBaseURL
    ///  Check whether the BaseURL data member has been assigned a value.
    bool IsSetBaseURL(void) const;
    /// Check whether it is safe or not to call GetBaseURL method.
    bool CanGetBaseURL(void) const;
    void ResetBaseURL(void);
    const TBaseURL& GetBaseURL(void) const;
    void SetBaseURL(const TBaseURL& value);
    void SetBaseURL(TBaseURL&& value);
    TBaseURL& SetBaseURL(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBaseURL_Base(const CBaseURL_Base&);
    CBaseURL_Base& operator=(const CBaseURL_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAttlist > m_Attlist;
    string m_BaseURL;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBaseURL_Base::C_Attlist::IsSetUrlId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBaseURL_Base::C_Attlist::CanGetUrlId(void) const
{
    return IsSetUrlId();
}

inline
void CBaseURL_Base::C_Attlist::ResetUrlId(void)
{
    m_UrlId = 0;
    m_set_State[0] &= ~0x3;
}

inline
CBaseURL_Base::C_Attlist::TUrlId CBaseURL_Base::C_Attlist::GetUrlId(void) const
{
    if (!CanGetUrlId()) {
        ThrowUnassigned(0);
    }
    return m_UrlId;
}

inline
void CBaseURL_Base::C_Attlist::SetUrlId(CBaseURL_Base::C_Attlist::TUrlId value)
{
    m_UrlId = value;
    m_set_State[0] |= 0x3;
}

inline
CBaseURL_Base::C_Attlist::TUrlId& CBaseURL_Base::C_Attlist::SetUrlId(void)
{
#ifdef _DEBUG
    if (!IsSetUrlId()) {
        memset(&m_UrlId,UnassignedByte(),sizeof(m_UrlId));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_UrlId;
}

inline
bool CBaseURL_Base::C_Attlist::IsSetResourceName(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBaseURL_Base::C_Attlist::CanGetResourceName(void) const
{
    return IsSetResourceName();
}

inline
const CBaseURL_Base::C_Attlist::TResourceName& CBaseURL_Base::C_Attlist::GetResourceName(void) const
{
    if (!CanGetResourceName()) {
        ThrowUnassigned(1);
    }
    return m_ResourceName;
}

inline
void CBaseURL_Base::C_Attlist::SetResourceName(const CBaseURL_Base::C_Attlist::TResourceName& value)
{
    m_ResourceName = value;
    m_set_State[0] |= 0xc;
}

inline
void CBaseURL_Base::C_Attlist::SetResourceName(CBaseURL_Base::C_Attlist::TResourceName&& value)
{
    m_ResourceName = std::forward<CBaseURL_Base::C_Attlist::TResourceName>(value);
    m_set_State[0] |= 0xc;
}

inline
CBaseURL_Base::C_Attlist::TResourceName& CBaseURL_Base::C_Attlist::SetResourceName(void)
{
#ifdef _DEBUG
    if (!IsSetResourceName()) {
        m_ResourceName = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_ResourceName;
}

inline
bool CBaseURL_Base::C_Attlist::IsSetResourceId(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBaseURL_Base::C_Attlist::CanGetResourceId(void) const
{
    return IsSetResourceId();
}

inline
const CBaseURL_Base::C_Attlist::TResourceId& CBaseURL_Base::C_Attlist::GetResourceId(void) const
{
    if (!CanGetResourceId()) {
        ThrowUnassigned(2);
    }
    return m_ResourceId;
}

inline
void CBaseURL_Base::C_Attlist::SetResourceId(const CBaseURL_Base::C_Attlist::TResourceId& value)
{
    m_ResourceId = value;
    m_set_State[0] |= 0x30;
}

inline
void CBaseURL_Base::C_Attlist::SetResourceId(CBaseURL_Base::C_Attlist::TResourceId&& value)
{
    m_ResourceId = std::forward<CBaseURL_Base::C_Attlist::TResourceId>(value);
    m_set_State[0] |= 0x30;
}

inline
CBaseURL_Base::C_Attlist::TResourceId& CBaseURL_Base::C_Attlist::SetResourceId(void)
{
#ifdef _DEBUG
    if (!IsSetResourceId()) {
        m_ResourceId = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_ResourceId;
}

inline
bool CBaseURL_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CBaseURL_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CBaseURL_Base::TAttlist& CBaseURL_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CBaseURL_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CBaseURL_Base::TAttlist& CBaseURL_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CBaseURL_Base::IsSetBaseURL(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBaseURL_Base::CanGetBaseURL(void) const
{
    return IsSetBaseURL();
}

inline
const CBaseURL_Base::TBaseURL& CBaseURL_Base::GetBaseURL(void) const
{
    if (!CanGetBaseURL()) {
        ThrowUnassigned(1);
    }
    return m_BaseURL;
}

inline
void CBaseURL_Base::SetBaseURL(const CBaseURL_Base::TBaseURL& value)
{
    m_BaseURL = value;
    m_set_State[0] |= 0xc;
}

inline
void CBaseURL_Base::SetBaseURL(CBaseURL_Base::TBaseURL&& value)
{
    m_BaseURL = std::forward<CBaseURL_Base::TBaseURL>(value);
    m_set_State[0] |= 0xc;
}

inline
CBaseURL_Base::TBaseURL& CBaseURL_Base::SetBaseURL(void)
{
#ifdef _DEBUG
    if (!IsSetBaseURL()) {
        m_BaseURL = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_BaseURL;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_DOCSUM_BASEURL_BASE_HPP
