/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Assembly_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'docsum.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_DOCSUM_ASSEMBLY_BASE_HPP
#define OBJECTS_DOCSUM_ASSEMBLY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CComponent;


// generated classes

/////////////////////////////////////////////////////////////////////////////
///A collection of genome sequence records (curated gene regions (NG's),
///				contigs (NWNT's) and chromosomes (NC/AC's) produced by a genome sequence project.
///				Structure is populated from ContigInfo tables.
class NCBI_DOCSUM_EXPORT CAssembly_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAssembly_Base(void);
    // destructor
    virtual ~CAssembly_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        // types
        typedef int TDbSnpBuild;
        typedef string TGenomeBuild;
        typedef string TGroupLabel;
        typedef string TAssemblySource;
        typedef bool TCurrent;
        typedef bool TReference;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_dbSnpBuild,
            e_genomeBuild,
            e_groupLabel,
            e_assemblySource,
            e_current,
            e_reference
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;
    
        // getters
        // setters
    
        ///dbSNP build number defining the rsid set aligned to this
        ///						assembly
        /// mandatory
        /// typedef int TDbSnpBuild
        ///  Check whether the DbSnpBuild data member has been assigned a value.
        bool IsSetDbSnpBuild(void) const;
        /// Check whether it is safe or not to call GetDbSnpBuild method.
        bool CanGetDbSnpBuild(void) const;
        void ResetDbSnpBuild(void);
        TDbSnpBuild GetDbSnpBuild(void) const;
        void SetDbSnpBuild(TDbSnpBuild value);
        TDbSnpBuild& SetDbSnpBuild(void);
    
        ///assembly build number with possible 'subbuild' version
        ///						numbers to reflect updates in gene annotation (human e.g. 34_3, 35_1,
        ///						36_1)
        /// mandatory
        /// typedef string TGenomeBuild
        ///  Check whether the GenomeBuild data member has been assigned a value.
        bool IsSetGenomeBuild(void) const;
        /// Check whether it is safe or not to call GetGenomeBuild method.
        bool CanGetGenomeBuild(void) const;
        void ResetGenomeBuild(void);
        const TGenomeBuild& GetGenomeBuild(void) const;
        void SetGenomeBuild(const TGenomeBuild& value);
        void SetGenomeBuild(TGenomeBuild&& value);
        TGenomeBuild& SetGenomeBuild(void);
    
        ///High-level classification of the assembly to distinguish
        ///						reference projects from alternate solutions. GroupLabel field from
        ///						organism/build-specific ContigInfo tables. "reference" is occasionally used
        ///						as the preferred assembly; standards will converge as additional organism
        ///						genome projects are finished. Note that some organism assembly names include
        ///						extended characters like '~' and '/' that may be incompatible with OS
        ///						filename conventions.
        /// optional
        /// typedef string TGroupLabel
        ///  Check whether the GroupLabel data member has been assigned a value.
        bool IsSetGroupLabel(void) const;
        /// Check whether it is safe or not to call GetGroupLabel method.
        bool CanGetGroupLabel(void) const;
        void ResetGroupLabel(void);
        const TGroupLabel& GetGroupLabel(void) const;
        void SetGroupLabel(const TGroupLabel& value);
        void SetGroupLabel(TGroupLabel&& value);
        TGroupLabel& SetGroupLabel(void);
    
        ///Name of the group(s) or organization(s) that generated the
        ///						assembly
        /// optional
        /// typedef string TAssemblySource
        ///  Check whether the AssemblySource data member has been assigned a value.
        bool IsSetAssemblySource(void) const;
        /// Check whether it is safe or not to call GetAssemblySource method.
        bool CanGetAssemblySource(void) const;
        void ResetAssemblySource(void);
        const TAssemblySource& GetAssemblySource(void) const;
        void SetAssemblySource(const TAssemblySource& value);
        void SetAssemblySource(TAssemblySource&& value);
        TAssemblySource& SetAssemblySource(void);
    
        ///Marks the current genomic assembly
        /// optional
        /// typedef bool TCurrent
        ///  Check whether the Current data member has been assigned a value.
        bool IsSetCurrent(void) const;
        /// Check whether it is safe or not to call GetCurrent method.
        bool CanGetCurrent(void) const;
        void ResetCurrent(void);
        TCurrent GetCurrent(void) const;
        void SetCurrent(TCurrent value);
        TCurrent& SetCurrent(void);
    
        /// optional
        /// typedef bool TReference
        ///  Check whether the Reference data member has been assigned a value.
        bool IsSetReference(void) const;
        /// Check whether it is safe or not to call GetReference method.
        bool CanGetReference(void) const;
        void ResetReference(void);
        TReference GetReference(void) const;
        void SetReference(TReference value);
        TReference& SetReference(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        int m_DbSnpBuild;
        string m_GenomeBuild;
        string m_GroupLabel;
        string m_AssemblySource;
        bool m_Current;
        bool m_Reference;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_SnpStat : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_SnpStat(void);
        // destructor
        ~C_SnpStat(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            ///summary measure of placement precision in the
            ///									assembly
            enum ESnpStat_attlist_mapWeight {
                eSnpStat_attlist_mapWeight_unmapped           = 1,
                eSnpStat_attlist_mapWeight_unique_in_contig   = 2,
                eSnpStat_attlist_mapWeight_two_hits_in_contig = 3,
                eSnpStat_attlist_mapWeight_less_10_hits       = 4,
                eSnpStat_attlist_mapWeight_multiple_hits      = 5
            };
            
            /// Access to ESnpStat_attlist_mapWeight's attributes (values, names) as defined in spec
            static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ESnpStat_attlist_mapWeight)(void);
            
            // types
            typedef ESnpStat_attlist_mapWeight TMapWeight;
            typedef int TChromCount;
            typedef int TPlacedContigCount;
            typedef int TUnplacedContigCount;
            typedef int TSeqlocCount;
            typedef int THapCount;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_mapWeight,
                e_chromCount,
                e_placedContigCount,
                e_unplacedContigCount,
                e_seqlocCount,
                e_hapCount
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;
        
            // getters
            // setters
        
            /// mandatory
            /// typedef ESnpStat_attlist_mapWeight TMapWeight
            ///  Check whether the MapWeight data member has been assigned a value.
            bool IsSetMapWeight(void) const;
            /// Check whether it is safe or not to call GetMapWeight method.
            bool CanGetMapWeight(void) const;
            void ResetMapWeight(void);
            TMapWeight GetMapWeight(void) const;
            void SetMapWeight(TMapWeight value);
            TMapWeight& SetMapWeight(void);
        
            ///number of distinct chromosomes in the
            ///									mapset
            /// optional
            /// typedef int TChromCount
            ///  Check whether the ChromCount data member has been assigned a value.
            bool IsSetChromCount(void) const;
            /// Check whether it is safe or not to call GetChromCount method.
            bool CanGetChromCount(void) const;
            void ResetChromCount(void);
            TChromCount GetChromCount(void) const;
            void SetChromCount(TChromCount value);
            TChromCount& SetChromCount(void);
        
            ///number of distinct contigs [ gi |
            ///									accession[.version] ] in the mapset
            /// optional
            /// typedef int TPlacedContigCount
            ///  Check whether the PlacedContigCount data member has been assigned a value.
            bool IsSetPlacedContigCount(void) const;
            /// Check whether it is safe or not to call GetPlacedContigCount method.
            bool CanGetPlacedContigCount(void) const;
            void ResetPlacedContigCount(void);
            TPlacedContigCount GetPlacedContigCount(void) const;
            void SetPlacedContigCount(TPlacedContigCount value);
            TPlacedContigCount& SetPlacedContigCount(void);
        
            ///number of sequence postions to a contig with
            ///									unknown chromosomal assignment
            /// optional
            /// typedef int TUnplacedContigCount
            ///  Check whether the UnplacedContigCount data member has been assigned a value.
            bool IsSetUnplacedContigCount(void) const;
            /// Check whether it is safe or not to call GetUnplacedContigCount method.
            bool CanGetUnplacedContigCount(void) const;
            void ResetUnplacedContigCount(void);
            TUnplacedContigCount GetUnplacedContigCount(void) const;
            void SetUnplacedContigCount(TUnplacedContigCount value);
            TUnplacedContigCount& SetUnplacedContigCount(void);
        
            ///total number of sequence positions in the
            ///									mapset
            /// optional
            /// typedef int TSeqlocCount
            ///  Check whether the SeqlocCount data member has been assigned a value.
            bool IsSetSeqlocCount(void) const;
            /// Check whether it is safe or not to call GetSeqlocCount method.
            bool CanGetSeqlocCount(void) const;
            void ResetSeqlocCount(void);
            TSeqlocCount GetSeqlocCount(void) const;
            void SetSeqlocCount(TSeqlocCount value);
            TSeqlocCount& SetSeqlocCount(void);
        
            ///Number of hits to alternative genomic haplotypes
            ///									(e.g. HLA DR region, KIR, or pseudo-autosomal regions like PAR)
            ///									within the assembly mapset. Note that positions on haplotypes
            ///									defined in other assemblies (a different assembly_group_label
            ///									value) will not be counted in this value.
            /// optional
            /// typedef int THapCount
            ///  Check whether the HapCount data member has been assigned a value.
            bool IsSetHapCount(void) const;
            /// Check whether it is safe or not to call GetHapCount method.
            bool CanGetHapCount(void) const;
            void ResetHapCount(void);
            THapCount GetHapCount(void) const;
            void SetHapCount(THapCount value);
            THapCount& SetHapCount(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            ESnpStat_attlist_mapWeight m_MapWeight;
            int m_ChromCount;
            int m_PlacedContigCount;
            int m_UnplacedContigCount;
            int m_SeqlocCount;
            int m_HapCount;
        };
        // types
        typedef C_Attlist TAttlist;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_snpStat
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        /// mandatory
        ///  Check whether the SnpStat data member has been assigned a value.
        bool IsSetSnpStat(void) const;
        /// Check whether it is safe or not to call GetSnpStat method.
        bool CanGetSnpStat(void) const;
        void ResetSnpStat(void);
        void SetSnpStat(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_SnpStat(const C_SnpStat&);
        C_SnpStat& operator=(const C_SnpStat&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef list< CRef< CComponent > > TComponent;
    typedef C_SnpStat TSnpStat;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_attlist,
        e_component,
        e_snpStat
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// optional
    /// typedef list< CRef< CComponent > > TComponent
    ///  Check whether the Component data member has been assigned a value.
    bool IsSetComponent(void) const;
    /// Check whether it is safe or not to call GetComponent method.
    bool CanGetComponent(void) const;
    void ResetComponent(void);
    const TComponent& GetComponent(void) const;
    TComponent& SetComponent(void);

    /// mandatory
    /// typedef C_SnpStat TSnpStat
    ///  Check whether the SnpStat data member has been assigned a value.
    bool IsSetSnpStat(void) const;
    /// Check whether it is safe or not to call GetSnpStat method.
    bool CanGetSnpStat(void) const;
    void ResetSnpStat(void);
    const TSnpStat& GetSnpStat(void) const;
    void SetSnpStat(TSnpStat& value);
    TSnpStat& SetSnpStat(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAssembly_Base(const CAssembly_Base&);
    CAssembly_Base& operator=(const CAssembly_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAttlist > m_Attlist;
    list< CRef< CComponent > > m_Component;
    CRef< TSnpStat > m_SnpStat;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAssembly_Base::C_Attlist::IsSetDbSnpBuild(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAssembly_Base::C_Attlist::CanGetDbSnpBuild(void) const
{
    return IsSetDbSnpBuild();
}

inline
void CAssembly_Base::C_Attlist::ResetDbSnpBuild(void)
{
    m_DbSnpBuild = 0;
    m_set_State[0] &= ~0x3;
}

inline
CAssembly_Base::C_Attlist::TDbSnpBuild CAssembly_Base::C_Attlist::GetDbSnpBuild(void) const
{
    if (!CanGetDbSnpBuild()) {
        ThrowUnassigned(0);
    }
    return m_DbSnpBuild;
}

inline
void CAssembly_Base::C_Attlist::SetDbSnpBuild(CAssembly_Base::C_Attlist::TDbSnpBuild value)
{
    m_DbSnpBuild = value;
    m_set_State[0] |= 0x3;
}

inline
CAssembly_Base::C_Attlist::TDbSnpBuild& CAssembly_Base::C_Attlist::SetDbSnpBuild(void)
{
#ifdef _DEBUG
    if (!IsSetDbSnpBuild()) {
        memset(&m_DbSnpBuild,UnassignedByte(),sizeof(m_DbSnpBuild));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_DbSnpBuild;
}

inline
bool CAssembly_Base::C_Attlist::IsSetGenomeBuild(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAssembly_Base::C_Attlist::CanGetGenomeBuild(void) const
{
    return IsSetGenomeBuild();
}

inline
const CAssembly_Base::C_Attlist::TGenomeBuild& CAssembly_Base::C_Attlist::GetGenomeBuild(void) const
{
    if (!CanGetGenomeBuild()) {
        ThrowUnassigned(1);
    }
    return m_GenomeBuild;
}

inline
void CAssembly_Base::C_Attlist::SetGenomeBuild(const CAssembly_Base::C_Attlist::TGenomeBuild& value)
{
    m_GenomeBuild = value;
    m_set_State[0] |= 0xc;
}

inline
void CAssembly_Base::C_Attlist::SetGenomeBuild(CAssembly_Base::C_Attlist::TGenomeBuild&& value)
{
    m_GenomeBuild = std::forward<CAssembly_Base::C_Attlist::TGenomeBuild>(value);
    m_set_State[0] |= 0xc;
}

inline
CAssembly_Base::C_Attlist::TGenomeBuild& CAssembly_Base::C_Attlist::SetGenomeBuild(void)
{
#ifdef _DEBUG
    if (!IsSetGenomeBuild()) {
        m_GenomeBuild = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_GenomeBuild;
}

inline
bool CAssembly_Base::C_Attlist::IsSetGroupLabel(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAssembly_Base::C_Attlist::CanGetGroupLabel(void) const
{
    return IsSetGroupLabel();
}

inline
const CAssembly_Base::C_Attlist::TGroupLabel& CAssembly_Base::C_Attlist::GetGroupLabel(void) const
{
    if (!CanGetGroupLabel()) {
        ThrowUnassigned(2);
    }
    return m_GroupLabel;
}

inline
void CAssembly_Base::C_Attlist::SetGroupLabel(const CAssembly_Base::C_Attlist::TGroupLabel& value)
{
    m_GroupLabel = value;
    m_set_State[0] |= 0x30;
}

inline
void CAssembly_Base::C_Attlist::SetGroupLabel(CAssembly_Base::C_Attlist::TGroupLabel&& value)
{
    m_GroupLabel = std::forward<CAssembly_Base::C_Attlist::TGroupLabel>(value);
    m_set_State[0] |= 0x30;
}

inline
CAssembly_Base::C_Attlist::TGroupLabel& CAssembly_Base::C_Attlist::SetGroupLabel(void)
{
#ifdef _DEBUG
    if (!IsSetGroupLabel()) {
        m_GroupLabel = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_GroupLabel;
}

inline
bool CAssembly_Base::C_Attlist::IsSetAssemblySource(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CAssembly_Base::C_Attlist::CanGetAssemblySource(void) const
{
    return IsSetAssemblySource();
}

inline
const CAssembly_Base::C_Attlist::TAssemblySource& CAssembly_Base::C_Attlist::GetAssemblySource(void) const
{
    if (!CanGetAssemblySource()) {
        ThrowUnassigned(3);
    }
    return m_AssemblySource;
}

inline
void CAssembly_Base::C_Attlist::SetAssemblySource(const CAssembly_Base::C_Attlist::TAssemblySource& value)
{
    m_AssemblySource = value;
    m_set_State[0] |= 0xc0;
}

inline
void CAssembly_Base::C_Attlist::SetAssemblySource(CAssembly_Base::C_Attlist::TAssemblySource&& value)
{
    m_AssemblySource = std::forward<CAssembly_Base::C_Attlist::TAssemblySource>(value);
    m_set_State[0] |= 0xc0;
}

inline
CAssembly_Base::C_Attlist::TAssemblySource& CAssembly_Base::C_Attlist::SetAssemblySource(void)
{
#ifdef _DEBUG
    if (!IsSetAssemblySource()) {
        m_AssemblySource = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x40;
    return m_AssemblySource;
}

inline
bool CAssembly_Base::C_Attlist::IsSetCurrent(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CAssembly_Base::C_Attlist::CanGetCurrent(void) const
{
    return IsSetCurrent();
}

inline
void CAssembly_Base::C_Attlist::ResetCurrent(void)
{
    m_Current = 0;
    m_set_State[0] &= ~0x300;
}

inline
CAssembly_Base::C_Attlist::TCurrent CAssembly_Base::C_Attlist::GetCurrent(void) const
{
    if (!CanGetCurrent()) {
        ThrowUnassigned(4);
    }
    return m_Current;
}

inline
void CAssembly_Base::C_Attlist::SetCurrent(CAssembly_Base::C_Attlist::TCurrent value)
{
    m_Current = value;
    m_set_State[0] |= 0x300;
}

inline
CAssembly_Base::C_Attlist::TCurrent& CAssembly_Base::C_Attlist::SetCurrent(void)
{
#ifdef _DEBUG
    if (!IsSetCurrent()) {
        memset(&m_Current,UnassignedByte(),sizeof(m_Current));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Current;
}

inline
bool CAssembly_Base::C_Attlist::IsSetReference(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CAssembly_Base::C_Attlist::CanGetReference(void) const
{
    return IsSetReference();
}

inline
void CAssembly_Base::C_Attlist::ResetReference(void)
{
    m_Reference = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CAssembly_Base::C_Attlist::TReference CAssembly_Base::C_Attlist::GetReference(void) const
{
    if (!CanGetReference()) {
        ThrowUnassigned(5);
    }
    return m_Reference;
}

inline
void CAssembly_Base::C_Attlist::SetReference(CAssembly_Base::C_Attlist::TReference value)
{
    m_Reference = value;
    m_set_State[0] |= 0xc00;
}

inline
CAssembly_Base::C_Attlist::TReference& CAssembly_Base::C_Attlist::SetReference(void)
{
#ifdef _DEBUG
    if (!IsSetReference()) {
        memset(&m_Reference,UnassignedByte(),sizeof(m_Reference));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_Reference;
}

inline
bool CAssembly_Base::C_SnpStat::C_Attlist::IsSetMapWeight(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAssembly_Base::C_SnpStat::C_Attlist::CanGetMapWeight(void) const
{
    return IsSetMapWeight();
}

inline
void CAssembly_Base::C_SnpStat::C_Attlist::ResetMapWeight(void)
{
    m_MapWeight = (ESnpStat_attlist_mapWeight)(0);
    m_set_State[0] &= ~0x3;
}

inline
CAssembly_Base::C_SnpStat::C_Attlist::TMapWeight CAssembly_Base::C_SnpStat::C_Attlist::GetMapWeight(void) const
{
    if (!CanGetMapWeight()) {
        ThrowUnassigned(0);
    }
    return m_MapWeight;
}

inline
void CAssembly_Base::C_SnpStat::C_Attlist::SetMapWeight(CAssembly_Base::C_SnpStat::C_Attlist::TMapWeight value)
{
    m_MapWeight = value;
    m_set_State[0] |= 0x3;
}

inline
CAssembly_Base::C_SnpStat::C_Attlist::TMapWeight& CAssembly_Base::C_SnpStat::C_Attlist::SetMapWeight(void)
{
#ifdef _DEBUG
    if (!IsSetMapWeight()) {
        memset(&m_MapWeight,UnassignedByte(),sizeof(m_MapWeight));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_MapWeight;
}

inline
bool CAssembly_Base::C_SnpStat::C_Attlist::IsSetChromCount(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAssembly_Base::C_SnpStat::C_Attlist::CanGetChromCount(void) const
{
    return IsSetChromCount();
}

inline
void CAssembly_Base::C_SnpStat::C_Attlist::ResetChromCount(void)
{
    m_ChromCount = 0;
    m_set_State[0] &= ~0xc;
}

inline
CAssembly_Base::C_SnpStat::C_Attlist::TChromCount CAssembly_Base::C_SnpStat::C_Attlist::GetChromCount(void) const
{
    if (!CanGetChromCount()) {
        ThrowUnassigned(1);
    }
    return m_ChromCount;
}

inline
void CAssembly_Base::C_SnpStat::C_Attlist::SetChromCount(CAssembly_Base::C_SnpStat::C_Attlist::TChromCount value)
{
    m_ChromCount = value;
    m_set_State[0] |= 0xc;
}

inline
CAssembly_Base::C_SnpStat::C_Attlist::TChromCount& CAssembly_Base::C_SnpStat::C_Attlist::SetChromCount(void)
{
#ifdef _DEBUG
    if (!IsSetChromCount()) {
        memset(&m_ChromCount,UnassignedByte(),sizeof(m_ChromCount));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_ChromCount;
}

inline
bool CAssembly_Base::C_SnpStat::C_Attlist::IsSetPlacedContigCount(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAssembly_Base::C_SnpStat::C_Attlist::CanGetPlacedContigCount(void) const
{
    return IsSetPlacedContigCount();
}

inline
void CAssembly_Base::C_SnpStat::C_Attlist::ResetPlacedContigCount(void)
{
    m_PlacedContigCount = 0;
    m_set_State[0] &= ~0x30;
}

inline
CAssembly_Base::C_SnpStat::C_Attlist::TPlacedContigCount CAssembly_Base::C_SnpStat::C_Attlist::GetPlacedContigCount(void) const
{
    if (!CanGetPlacedContigCount()) {
        ThrowUnassigned(2);
    }
    return m_PlacedContigCount;
}

inline
void CAssembly_Base::C_SnpStat::C_Attlist::SetPlacedContigCount(CAssembly_Base::C_SnpStat::C_Attlist::TPlacedContigCount value)
{
    m_PlacedContigCount = value;
    m_set_State[0] |= 0x30;
}

inline
CAssembly_Base::C_SnpStat::C_Attlist::TPlacedContigCount& CAssembly_Base::C_SnpStat::C_Attlist::SetPlacedContigCount(void)
{
#ifdef _DEBUG
    if (!IsSetPlacedContigCount()) {
        memset(&m_PlacedContigCount,UnassignedByte(),sizeof(m_PlacedContigCount));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_PlacedContigCount;
}

inline
bool CAssembly_Base::C_SnpStat::C_Attlist::IsSetUnplacedContigCount(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CAssembly_Base::C_SnpStat::C_Attlist::CanGetUnplacedContigCount(void) const
{
    return IsSetUnplacedContigCount();
}

inline
void CAssembly_Base::C_SnpStat::C_Attlist::ResetUnplacedContigCount(void)
{
    m_UnplacedContigCount = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CAssembly_Base::C_SnpStat::C_Attlist::TUnplacedContigCount CAssembly_Base::C_SnpStat::C_Attlist::GetUnplacedContigCount(void) const
{
    if (!CanGetUnplacedContigCount()) {
        ThrowUnassigned(3);
    }
    return m_UnplacedContigCount;
}

inline
void CAssembly_Base::C_SnpStat::C_Attlist::SetUnplacedContigCount(CAssembly_Base::C_SnpStat::C_Attlist::TUnplacedContigCount value)
{
    m_UnplacedContigCount = value;
    m_set_State[0] |= 0xc0;
}

inline
CAssembly_Base::C_SnpStat::C_Attlist::TUnplacedContigCount& CAssembly_Base::C_SnpStat::C_Attlist::SetUnplacedContigCount(void)
{
#ifdef _DEBUG
    if (!IsSetUnplacedContigCount()) {
        memset(&m_UnplacedContigCount,UnassignedByte(),sizeof(m_UnplacedContigCount));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_UnplacedContigCount;
}

inline
bool CAssembly_Base::C_SnpStat::C_Attlist::IsSetSeqlocCount(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CAssembly_Base::C_SnpStat::C_Attlist::CanGetSeqlocCount(void) const
{
    return IsSetSeqlocCount();
}

inline
void CAssembly_Base::C_SnpStat::C_Attlist::ResetSeqlocCount(void)
{
    m_SeqlocCount = 0;
    m_set_State[0] &= ~0x300;
}

inline
CAssembly_Base::C_SnpStat::C_Attlist::TSeqlocCount CAssembly_Base::C_SnpStat::C_Attlist::GetSeqlocCount(void) const
{
    if (!CanGetSeqlocCount()) {
        ThrowUnassigned(4);
    }
    return m_SeqlocCount;
}

inline
void CAssembly_Base::C_SnpStat::C_Attlist::SetSeqlocCount(CAssembly_Base::C_SnpStat::C_Attlist::TSeqlocCount value)
{
    m_SeqlocCount = value;
    m_set_State[0] |= 0x300;
}

inline
CAssembly_Base::C_SnpStat::C_Attlist::TSeqlocCount& CAssembly_Base::C_SnpStat::C_Attlist::SetSeqlocCount(void)
{
#ifdef _DEBUG
    if (!IsSetSeqlocCount()) {
        memset(&m_SeqlocCount,UnassignedByte(),sizeof(m_SeqlocCount));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_SeqlocCount;
}

inline
bool CAssembly_Base::C_SnpStat::C_Attlist::IsSetHapCount(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CAssembly_Base::C_SnpStat::C_Attlist::CanGetHapCount(void) const
{
    return IsSetHapCount();
}

inline
void CAssembly_Base::C_SnpStat::C_Attlist::ResetHapCount(void)
{
    m_HapCount = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CAssembly_Base::C_SnpStat::C_Attlist::THapCount CAssembly_Base::C_SnpStat::C_Attlist::GetHapCount(void) const
{
    if (!CanGetHapCount()) {
        ThrowUnassigned(5);
    }
    return m_HapCount;
}

inline
void CAssembly_Base::C_SnpStat::C_Attlist::SetHapCount(CAssembly_Base::C_SnpStat::C_Attlist::THapCount value)
{
    m_HapCount = value;
    m_set_State[0] |= 0xc00;
}

inline
CAssembly_Base::C_SnpStat::C_Attlist::THapCount& CAssembly_Base::C_SnpStat::C_Attlist::SetHapCount(void)
{
#ifdef _DEBUG
    if (!IsSetHapCount()) {
        memset(&m_HapCount,UnassignedByte(),sizeof(m_HapCount));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_HapCount;
}

inline
bool CAssembly_Base::C_SnpStat::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CAssembly_Base::C_SnpStat::CanGetAttlist(void) const
{
    return true;
}

inline
const CAssembly_Base::C_SnpStat::TAttlist& CAssembly_Base::C_SnpStat::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_SnpStat*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CAssembly_Base::C_SnpStat::TAttlist& CAssembly_Base::C_SnpStat::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CAssembly_Base::C_SnpStat::IsSetSnpStat(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAssembly_Base::C_SnpStat::CanGetSnpStat(void) const
{
    return false;
}

inline
void CAssembly_Base::C_SnpStat::ResetSnpStat(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CAssembly_Base::C_SnpStat::SetSnpStat(void)
{
    m_set_State[0] |= 0xc;
}

inline
bool CAssembly_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CAssembly_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CAssembly_Base::TAttlist& CAssembly_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CAssembly_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CAssembly_Base::TAttlist& CAssembly_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CAssembly_Base::IsSetComponent(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAssembly_Base::CanGetComponent(void) const
{
    return true;
}

inline
const CAssembly_Base::TComponent& CAssembly_Base::GetComponent(void) const
{
    return m_Component;
}

inline
CAssembly_Base::TComponent& CAssembly_Base::SetComponent(void)
{
    m_set_State[0] |= 0x4;
    return m_Component;
}

inline
bool CAssembly_Base::IsSetSnpStat(void) const
{
    return m_SnpStat.NotEmpty();
}

inline
bool CAssembly_Base::CanGetSnpStat(void) const
{
    return true;
}

inline
const CAssembly_Base::TSnpStat& CAssembly_Base::GetSnpStat(void) const
{
    if ( !m_SnpStat ) {
        const_cast<CAssembly_Base*>(this)->ResetSnpStat();
    }
    return (*m_SnpStat);
}

inline
CAssembly_Base::TSnpStat& CAssembly_Base::SetSnpStat(void)
{
    if ( !m_SnpStat ) {
        ResetSnpStat();
    }
    return (*m_SnpStat);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_DOCSUM_ASSEMBLY_BASE_HPP
