/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Assay_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'docsum.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_DOCSUM_ASSAY_BASE_HPP
#define OBJECTS_DOCSUM_ASSAY_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_DOCSUM_EXPORT CAssay_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CAssay_Base(void);
    // destructor
    virtual ~CAssay_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Attlist(void);
        // destructor
        ~C_Attlist(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        enum EAttlist_batchType {
            eAttlist_batchType_snpassay   = 1,
            eAttlist_batchType_validation = 2,
            eAttlist_batchType_doublehit  = 3
        };
        
        /// Access to EAttlist_batchType's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_batchType)(void);
        
        enum EAttlist_molType {
            eAttlist_molType_genomic = 1,
            eAttlist_molType_cDNA    = 2,
            eAttlist_molType_mito    = 3,
            eAttlist_molType_chloro  = 4
        };
        
        /// Access to EAttlist_molType's attributes (values, names) as defined in spec
        static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EAttlist_molType)(void);
        
        // types
        typedef string THandle;
        typedef string TBatch;
        typedef int TBatchId;
        typedef EAttlist_batchType TBatchType;
        typedef EAttlist_molType TMolType;
        typedef int TSampleSize;
        typedef string TPopulation;
        typedef string TLinkoutUrl;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_handle,
            e_batch,
            e_batchId,
            e_batchType,
            e_molType,
            e_sampleSize,
            e_population,
            e_linkoutUrl
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 9> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef string THandle
        ///  Check whether the Handle data member has been assigned a value.
        bool IsSetHandle(void) const;
        /// Check whether it is safe or not to call GetHandle method.
        bool CanGetHandle(void) const;
        void ResetHandle(void);
        const THandle& GetHandle(void) const;
        void SetHandle(const THandle& value);
        void SetHandle(THandle&& value);
        THandle& SetHandle(void);
    
        /// optional
        /// typedef string TBatch
        ///  Check whether the Batch data member has been assigned a value.
        bool IsSetBatch(void) const;
        /// Check whether it is safe or not to call GetBatch method.
        bool CanGetBatch(void) const;
        void ResetBatch(void);
        const TBatch& GetBatch(void) const;
        void SetBatch(const TBatch& value);
        void SetBatch(TBatch&& value);
        TBatch& SetBatch(void);
    
        /// optional
        /// typedef int TBatchId
        ///  Check whether the BatchId data member has been assigned a value.
        bool IsSetBatchId(void) const;
        /// Check whether it is safe or not to call GetBatchId method.
        bool CanGetBatchId(void) const;
        void ResetBatchId(void);
        TBatchId GetBatchId(void) const;
        void SetBatchId(TBatchId value);
        TBatchId& SetBatchId(void);
    
        /// optional
        /// typedef EAttlist_batchType TBatchType
        ///  Check whether the BatchType data member has been assigned a value.
        bool IsSetBatchType(void) const;
        /// Check whether it is safe or not to call GetBatchType method.
        bool CanGetBatchType(void) const;
        void ResetBatchType(void);
        TBatchType GetBatchType(void) const;
        void SetBatchType(TBatchType value);
        TBatchType& SetBatchType(void);
    
        /// optional
        /// typedef EAttlist_molType TMolType
        ///  Check whether the MolType data member has been assigned a value.
        bool IsSetMolType(void) const;
        /// Check whether it is safe or not to call GetMolType method.
        bool CanGetMolType(void) const;
        void ResetMolType(void);
        TMolType GetMolType(void) const;
        void SetMolType(TMolType value);
        TMolType& SetMolType(void);
    
        /// optional
        /// typedef int TSampleSize
        ///  Check whether the SampleSize data member has been assigned a value.
        bool IsSetSampleSize(void) const;
        /// Check whether it is safe or not to call GetSampleSize method.
        bool CanGetSampleSize(void) const;
        void ResetSampleSize(void);
        TSampleSize GetSampleSize(void) const;
        void SetSampleSize(TSampleSize value);
        TSampleSize& SetSampleSize(void);
    
        /// optional
        /// typedef string TPopulation
        ///  Check whether the Population data member has been assigned a value.
        bool IsSetPopulation(void) const;
        /// Check whether it is safe or not to call GetPopulation method.
        bool CanGetPopulation(void) const;
        void ResetPopulation(void);
        const TPopulation& GetPopulation(void) const;
        void SetPopulation(const TPopulation& value);
        void SetPopulation(TPopulation&& value);
        TPopulation& SetPopulation(void);
    
        /// optional
        /// typedef string TLinkoutUrl
        ///  Check whether the LinkoutUrl data member has been assigned a value.
        bool IsSetLinkoutUrl(void) const;
        /// Check whether it is safe or not to call GetLinkoutUrl method.
        bool CanGetLinkoutUrl(void) const;
        void ResetLinkoutUrl(void);
        const TLinkoutUrl& GetLinkoutUrl(void) const;
        void SetLinkoutUrl(const TLinkoutUrl& value);
        void SetLinkoutUrl(TLinkoutUrl&& value);
        TLinkoutUrl& SetLinkoutUrl(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Attlist(const C_Attlist&);
        C_Attlist& operator=(const C_Attlist&);
    
        // data
        Uint4 m_set_State[1];
        string m_Handle;
        string m_Batch;
        int m_BatchId;
        EAttlist_batchType m_BatchType;
        EAttlist_molType m_MolType;
        int m_SampleSize;
        string m_Population;
        string m_LinkoutUrl;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Method : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Method(void);
        // destructor
        ~C_Method(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_EMethod : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_EMethod(void);
            // destructor
            ~C_EMethod(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            /////////////////////////////////////////////////////////////////////////////
            class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
            {
                typedef CSerialObject Tparent;
            public:
                // constructor
                C_Attlist(void);
                // destructor
                ~C_Attlist(void);
            
                // type info
                DECLARE_INTERNAL_TYPE_INFO();
            
                // types
                typedef string TName;
                typedef string TId;
            
                // member index
                enum class E_memberIndex {
                    e__allMandatory = 0,
                    e_name,
                    e_id
                };
                typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
            
                // getters
                // setters
            
                ///Submitters method identifier
                /// optional
                /// typedef string TName
                ///  Check whether the Name data member has been assigned a value.
                bool IsSetName(void) const;
                /// Check whether it is safe or not to call GetName method.
                bool CanGetName(void) const;
                void ResetName(void);
                const TName& GetName(void) const;
                void SetName(const TName& value);
                void SetName(TName&& value);
                TName& SetName(void);
            
                ///dbSNP method identifier
                /// optional
                /// typedef string TId
                ///  Check whether the Id data member has been assigned a value.
                bool IsSetId(void) const;
                /// Check whether it is safe or not to call GetId method.
                bool CanGetId(void) const;
                void ResetId(void);
                const TId& GetId(void) const;
                void SetId(const TId& value);
                void SetId(TId&& value);
                TId& SetId(void);
            
                /// Reset the whole object
                void Reset(void);
            
            
            private:
                // Prohibit copy constructor and assignment operator
                C_Attlist(const C_Attlist&);
                C_Attlist& operator=(const C_Attlist&);
            
                // data
                Uint4 m_set_State[1];
                string m_Name;
                string m_Id;
            };
            // types
            typedef C_Attlist TAttlist;
            typedef string TException;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_attlist,
                e_exception
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            /// mandatory
            /// typedef C_Attlist TAttlist
            ///  Check whether the Attlist data member has been assigned a value.
            bool IsSetAttlist(void) const;
            /// Check whether it is safe or not to call GetAttlist method.
            bool CanGetAttlist(void) const;
            void ResetAttlist(void);
            const TAttlist& GetAttlist(void) const;
            void SetAttlist(TAttlist& value);
            TAttlist& SetAttlist(void);
        
            ///description of deviation from/addition to
            ///										given method 
            /// mandatory
            /// typedef string TException
            ///  Check whether the Exception data member has been assigned a value.
            bool IsSetException(void) const;
            /// Check whether it is safe or not to call GetException method.
            bool CanGetException(void) const;
            void ResetException(void);
            const TException& GetException(void) const;
            void SetException(const TException& value);
            void SetException(TException&& value);
            TException& SetException(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_EMethod(const C_EMethod&);
            C_EMethod& operator=(const C_EMethod&);
        
            // data
            Uint4 m_set_State[1];
            CRef< TAttlist > m_Attlist;
            string m_Exception;
        };
        // types
        typedef C_EMethod TEMethod;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_eMethod
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 2> TmemberIndex;
    
        // getters
        // setters
    
        /// optional
        /// typedef C_EMethod TEMethod
        ///  Check whether the EMethod data member has been assigned a value.
        bool IsSetEMethod(void) const;
        /// Check whether it is safe or not to call GetEMethod method.
        bool CanGetEMethod(void) const;
        void ResetEMethod(void);
        const TEMethod& GetEMethod(void) const;
        void SetEMethod(TEMethod& value);
        TEMethod& SetEMethod(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Method(const C_Method&);
        C_Method& operator=(const C_Method&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TEMethod > m_EMethod;
    };
    /////////////////////////////////////////////////////////////////////////////
    class NCBI_DOCSUM_EXPORT C_Taxonomy : public CSerialObject
    {
        typedef CSerialObject Tparent;
    public:
        // constructor
        C_Taxonomy(void);
        // destructor
        ~C_Taxonomy(void);
    
        // type info
        DECLARE_INTERNAL_TYPE_INFO();
    
        /////////////////////////////////////////////////////////////////////////////
        class NCBI_DOCSUM_EXPORT C_Attlist : public CSerialObject
        {
            typedef CSerialObject Tparent;
        public:
            // constructor
            C_Attlist(void);
            // destructor
            ~C_Attlist(void);
        
            // type info
            DECLARE_INTERNAL_TYPE_INFO();
        
            // types
            typedef int TId;
            typedef string TOrganism;
        
            // member index
            enum class E_memberIndex {
                e__allMandatory = 0,
                e_id,
                e_organism
            };
            typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
        
            // getters
            // setters
        
            ///NCBI taxonomy ID for
            ///									variation
            /// mandatory
            /// typedef int TId
            ///  Check whether the Id data member has been assigned a value.
            bool IsSetId(void) const;
            /// Check whether it is safe or not to call GetId method.
            bool CanGetId(void) const;
            void ResetId(void);
            TId GetId(void) const;
            void SetId(TId value);
            TId& SetId(void);
        
            /// optional
            /// typedef string TOrganism
            ///  Check whether the Organism data member has been assigned a value.
            bool IsSetOrganism(void) const;
            /// Check whether it is safe or not to call GetOrganism method.
            bool CanGetOrganism(void) const;
            void ResetOrganism(void);
            const TOrganism& GetOrganism(void) const;
            void SetOrganism(const TOrganism& value);
            void SetOrganism(TOrganism&& value);
            TOrganism& SetOrganism(void);
        
            /// Reset the whole object
            void Reset(void);
        
        
        private:
            // Prohibit copy constructor and assignment operator
            C_Attlist(const C_Attlist&);
            C_Attlist& operator=(const C_Attlist&);
        
            // data
            Uint4 m_set_State[1];
            int m_Id;
            string m_Organism;
        };
        // types
        typedef C_Attlist TAttlist;
    
        // member index
        enum class E_memberIndex {
            e__allMandatory = 0,
            e_attlist,
            e_taxonomy
        };
        typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;
    
        // getters
        // setters
    
        /// mandatory
        /// typedef C_Attlist TAttlist
        ///  Check whether the Attlist data member has been assigned a value.
        bool IsSetAttlist(void) const;
        /// Check whether it is safe or not to call GetAttlist method.
        bool CanGetAttlist(void) const;
        void ResetAttlist(void);
        const TAttlist& GetAttlist(void) const;
        void SetAttlist(TAttlist& value);
        TAttlist& SetAttlist(void);
    
        /// mandatory
        ///  Check whether the Taxonomy data member has been assigned a value.
        bool IsSetTaxonomy(void) const;
        /// Check whether it is safe or not to call GetTaxonomy method.
        bool CanGetTaxonomy(void) const;
        void ResetTaxonomy(void);
        void SetTaxonomy(void);
    
        /// Reset the whole object
        void Reset(void);
    
    
    private:
        // Prohibit copy constructor and assignment operator
        C_Taxonomy(const C_Taxonomy&);
        C_Taxonomy& operator=(const C_Taxonomy&);
    
        // data
        Uint4 m_set_State[1];
        CRef< TAttlist > m_Attlist;
    };
    // types
    typedef C_Attlist TAttlist;
    typedef C_Method TMethod;
    typedef C_Taxonomy TTaxonomy;
    typedef list< string > TStrains;
    typedef string TComment;
    typedef list< string > TCitation;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_attlist,
        e_method,
        e_taxonomy,
        e_strains,
        e_comment,
        e_citation
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 7> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef C_Attlist TAttlist
    ///  Check whether the Attlist data member has been assigned a value.
    bool IsSetAttlist(void) const;
    /// Check whether it is safe or not to call GetAttlist method.
    bool CanGetAttlist(void) const;
    void ResetAttlist(void);
    const TAttlist& GetAttlist(void) const;
    void SetAttlist(TAttlist& value);
    TAttlist& SetAttlist(void);

    /// mandatory
    /// typedef C_Method TMethod
    ///  Check whether the Method data member has been assigned a value.
    bool IsSetMethod(void) const;
    /// Check whether it is safe or not to call GetMethod method.
    bool CanGetMethod(void) const;
    void ResetMethod(void);
    const TMethod& GetMethod(void) const;
    void SetMethod(TMethod& value);
    TMethod& SetMethod(void);

    /// mandatory
    /// typedef C_Taxonomy TTaxonomy
    ///  Check whether the Taxonomy data member has been assigned a value.
    bool IsSetTaxonomy(void) const;
    /// Check whether it is safe or not to call GetTaxonomy method.
    bool CanGetTaxonomy(void) const;
    void ResetTaxonomy(void);
    const TTaxonomy& GetTaxonomy(void) const;
    void SetTaxonomy(TTaxonomy& value);
    TTaxonomy& SetTaxonomy(void);

    /// optional
    /// typedef list< string > TStrains
    ///  Check whether the Strains data member has been assigned a value.
    bool IsSetStrains(void) const;
    /// Check whether it is safe or not to call GetStrains method.
    bool CanGetStrains(void) const;
    void ResetStrains(void);
    const TStrains& GetStrains(void) const;
    TStrains& SetStrains(void);

    /// optional
    /// typedef string TComment
    ///  Check whether the Comment data member has been assigned a value.
    bool IsSetComment(void) const;
    /// Check whether it is safe or not to call GetComment method.
    bool CanGetComment(void) const;
    void ResetComment(void);
    const TComment& GetComment(void) const;
    void SetComment(const TComment& value);
    void SetComment(TComment&& value);
    TComment& SetComment(void);

    /// optional
    /// typedef list< string > TCitation
    ///  Check whether the Citation data member has been assigned a value.
    bool IsSetCitation(void) const;
    /// Check whether it is safe or not to call GetCitation method.
    bool CanGetCitation(void) const;
    void ResetCitation(void);
    const TCitation& GetCitation(void) const;
    TCitation& SetCitation(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CAssay_Base(const CAssay_Base&);
    CAssay_Base& operator=(const CAssay_Base&);

    // data
    Uint4 m_set_State[1];
    CRef< TAttlist > m_Attlist;
    CRef< TMethod > m_Method;
    CRef< TTaxonomy > m_Taxonomy;
    list< string > m_Strains;
    string m_Comment;
    list< string > m_Citation;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CAssay_Base::C_Attlist::IsSetHandle(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAssay_Base::C_Attlist::CanGetHandle(void) const
{
    return IsSetHandle();
}

inline
const CAssay_Base::C_Attlist::THandle& CAssay_Base::C_Attlist::GetHandle(void) const
{
    if (!CanGetHandle()) {
        ThrowUnassigned(0);
    }
    return m_Handle;
}

inline
void CAssay_Base::C_Attlist::SetHandle(const CAssay_Base::C_Attlist::THandle& value)
{
    m_Handle = value;
    m_set_State[0] |= 0x3;
}

inline
void CAssay_Base::C_Attlist::SetHandle(CAssay_Base::C_Attlist::THandle&& value)
{
    m_Handle = std::forward<CAssay_Base::C_Attlist::THandle>(value);
    m_set_State[0] |= 0x3;
}

inline
CAssay_Base::C_Attlist::THandle& CAssay_Base::C_Attlist::SetHandle(void)
{
#ifdef _DEBUG
    if (!IsSetHandle()) {
        m_Handle = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Handle;
}

inline
bool CAssay_Base::C_Attlist::IsSetBatch(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAssay_Base::C_Attlist::CanGetBatch(void) const
{
    return IsSetBatch();
}

inline
const CAssay_Base::C_Attlist::TBatch& CAssay_Base::C_Attlist::GetBatch(void) const
{
    if (!CanGetBatch()) {
        ThrowUnassigned(1);
    }
    return m_Batch;
}

inline
void CAssay_Base::C_Attlist::SetBatch(const CAssay_Base::C_Attlist::TBatch& value)
{
    m_Batch = value;
    m_set_State[0] |= 0xc;
}

inline
void CAssay_Base::C_Attlist::SetBatch(CAssay_Base::C_Attlist::TBatch&& value)
{
    m_Batch = std::forward<CAssay_Base::C_Attlist::TBatch>(value);
    m_set_State[0] |= 0xc;
}

inline
CAssay_Base::C_Attlist::TBatch& CAssay_Base::C_Attlist::SetBatch(void)
{
#ifdef _DEBUG
    if (!IsSetBatch()) {
        m_Batch = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Batch;
}

inline
bool CAssay_Base::C_Attlist::IsSetBatchId(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CAssay_Base::C_Attlist::CanGetBatchId(void) const
{
    return IsSetBatchId();
}

inline
void CAssay_Base::C_Attlist::ResetBatchId(void)
{
    m_BatchId = 0;
    m_set_State[0] &= ~0x30;
}

inline
CAssay_Base::C_Attlist::TBatchId CAssay_Base::C_Attlist::GetBatchId(void) const
{
    if (!CanGetBatchId()) {
        ThrowUnassigned(2);
    }
    return m_BatchId;
}

inline
void CAssay_Base::C_Attlist::SetBatchId(CAssay_Base::C_Attlist::TBatchId value)
{
    m_BatchId = value;
    m_set_State[0] |= 0x30;
}

inline
CAssay_Base::C_Attlist::TBatchId& CAssay_Base::C_Attlist::SetBatchId(void)
{
#ifdef _DEBUG
    if (!IsSetBatchId()) {
        memset(&m_BatchId,UnassignedByte(),sizeof(m_BatchId));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_BatchId;
}

inline
bool CAssay_Base::C_Attlist::IsSetBatchType(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CAssay_Base::C_Attlist::CanGetBatchType(void) const
{
    return IsSetBatchType();
}

inline
void CAssay_Base::C_Attlist::ResetBatchType(void)
{
    m_BatchType = (EAttlist_batchType)(0);
    m_set_State[0] &= ~0xc0;
}

inline
CAssay_Base::C_Attlist::TBatchType CAssay_Base::C_Attlist::GetBatchType(void) const
{
    if (!CanGetBatchType()) {
        ThrowUnassigned(3);
    }
    return m_BatchType;
}

inline
void CAssay_Base::C_Attlist::SetBatchType(CAssay_Base::C_Attlist::TBatchType value)
{
    m_BatchType = value;
    m_set_State[0] |= 0xc0;
}

inline
CAssay_Base::C_Attlist::TBatchType& CAssay_Base::C_Attlist::SetBatchType(void)
{
#ifdef _DEBUG
    if (!IsSetBatchType()) {
        memset(&m_BatchType,UnassignedByte(),sizeof(m_BatchType));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_BatchType;
}

inline
bool CAssay_Base::C_Attlist::IsSetMolType(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CAssay_Base::C_Attlist::CanGetMolType(void) const
{
    return IsSetMolType();
}

inline
void CAssay_Base::C_Attlist::ResetMolType(void)
{
    m_MolType = (EAttlist_molType)(0);
    m_set_State[0] &= ~0x300;
}

inline
CAssay_Base::C_Attlist::TMolType CAssay_Base::C_Attlist::GetMolType(void) const
{
    if (!CanGetMolType()) {
        ThrowUnassigned(4);
    }
    return m_MolType;
}

inline
void CAssay_Base::C_Attlist::SetMolType(CAssay_Base::C_Attlist::TMolType value)
{
    m_MolType = value;
    m_set_State[0] |= 0x300;
}

inline
CAssay_Base::C_Attlist::TMolType& CAssay_Base::C_Attlist::SetMolType(void)
{
#ifdef _DEBUG
    if (!IsSetMolType()) {
        memset(&m_MolType,UnassignedByte(),sizeof(m_MolType));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_MolType;
}

inline
bool CAssay_Base::C_Attlist::IsSetSampleSize(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CAssay_Base::C_Attlist::CanGetSampleSize(void) const
{
    return IsSetSampleSize();
}

inline
void CAssay_Base::C_Attlist::ResetSampleSize(void)
{
    m_SampleSize = 0;
    m_set_State[0] &= ~0xc00;
}

inline
CAssay_Base::C_Attlist::TSampleSize CAssay_Base::C_Attlist::GetSampleSize(void) const
{
    if (!CanGetSampleSize()) {
        ThrowUnassigned(5);
    }
    return m_SampleSize;
}

inline
void CAssay_Base::C_Attlist::SetSampleSize(CAssay_Base::C_Attlist::TSampleSize value)
{
    m_SampleSize = value;
    m_set_State[0] |= 0xc00;
}

inline
CAssay_Base::C_Attlist::TSampleSize& CAssay_Base::C_Attlist::SetSampleSize(void)
{
#ifdef _DEBUG
    if (!IsSetSampleSize()) {
        memset(&m_SampleSize,UnassignedByte(),sizeof(m_SampleSize));
    }
#endif
    m_set_State[0] |= 0x400;
    return m_SampleSize;
}

inline
bool CAssay_Base::C_Attlist::IsSetPopulation(void) const
{
    return ((m_set_State[0] & 0x3000) != 0);
}

inline
bool CAssay_Base::C_Attlist::CanGetPopulation(void) const
{
    return IsSetPopulation();
}

inline
const CAssay_Base::C_Attlist::TPopulation& CAssay_Base::C_Attlist::GetPopulation(void) const
{
    if (!CanGetPopulation()) {
        ThrowUnassigned(6);
    }
    return m_Population;
}

inline
void CAssay_Base::C_Attlist::SetPopulation(const CAssay_Base::C_Attlist::TPopulation& value)
{
    m_Population = value;
    m_set_State[0] |= 0x3000;
}

inline
void CAssay_Base::C_Attlist::SetPopulation(CAssay_Base::C_Attlist::TPopulation&& value)
{
    m_Population = std::forward<CAssay_Base::C_Attlist::TPopulation>(value);
    m_set_State[0] |= 0x3000;
}

inline
CAssay_Base::C_Attlist::TPopulation& CAssay_Base::C_Attlist::SetPopulation(void)
{
#ifdef _DEBUG
    if (!IsSetPopulation()) {
        m_Population = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1000;
    return m_Population;
}

inline
bool CAssay_Base::C_Attlist::IsSetLinkoutUrl(void) const
{
    return ((m_set_State[0] & 0xc000) != 0);
}

inline
bool CAssay_Base::C_Attlist::CanGetLinkoutUrl(void) const
{
    return IsSetLinkoutUrl();
}

inline
const CAssay_Base::C_Attlist::TLinkoutUrl& CAssay_Base::C_Attlist::GetLinkoutUrl(void) const
{
    if (!CanGetLinkoutUrl()) {
        ThrowUnassigned(7);
    }
    return m_LinkoutUrl;
}

inline
void CAssay_Base::C_Attlist::SetLinkoutUrl(const CAssay_Base::C_Attlist::TLinkoutUrl& value)
{
    m_LinkoutUrl = value;
    m_set_State[0] |= 0xc000;
}

inline
void CAssay_Base::C_Attlist::SetLinkoutUrl(CAssay_Base::C_Attlist::TLinkoutUrl&& value)
{
    m_LinkoutUrl = std::forward<CAssay_Base::C_Attlist::TLinkoutUrl>(value);
    m_set_State[0] |= 0xc000;
}

inline
CAssay_Base::C_Attlist::TLinkoutUrl& CAssay_Base::C_Attlist::SetLinkoutUrl(void)
{
#ifdef _DEBUG
    if (!IsSetLinkoutUrl()) {
        m_LinkoutUrl = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4000;
    return m_LinkoutUrl;
}

inline
bool CAssay_Base::C_Method::C_EMethod::C_Attlist::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAssay_Base::C_Method::C_EMethod::C_Attlist::CanGetName(void) const
{
    return IsSetName();
}

inline
const CAssay_Base::C_Method::C_EMethod::C_Attlist::TName& CAssay_Base::C_Method::C_EMethod::C_Attlist::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CAssay_Base::C_Method::C_EMethod::C_Attlist::SetName(const CAssay_Base::C_Method::C_EMethod::C_Attlist::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CAssay_Base::C_Method::C_EMethod::C_Attlist::SetName(CAssay_Base::C_Method::C_EMethod::C_Attlist::TName&& value)
{
    m_Name = std::forward<CAssay_Base::C_Method::C_EMethod::C_Attlist::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CAssay_Base::C_Method::C_EMethod::C_Attlist::TName& CAssay_Base::C_Method::C_EMethod::C_Attlist::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CAssay_Base::C_Method::C_EMethod::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAssay_Base::C_Method::C_EMethod::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
const CAssay_Base::C_Method::C_EMethod::C_Attlist::TId& CAssay_Base::C_Method::C_EMethod::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(1);
    }
    return m_Id;
}

inline
void CAssay_Base::C_Method::C_EMethod::C_Attlist::SetId(const CAssay_Base::C_Method::C_EMethod::C_Attlist::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0xc;
}

inline
void CAssay_Base::C_Method::C_EMethod::C_Attlist::SetId(CAssay_Base::C_Method::C_EMethod::C_Attlist::TId&& value)
{
    m_Id = std::forward<CAssay_Base::C_Method::C_EMethod::C_Attlist::TId>(value);
    m_set_State[0] |= 0xc;
}

inline
CAssay_Base::C_Method::C_EMethod::C_Attlist::TId& CAssay_Base::C_Method::C_EMethod::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Id;
}

inline
bool CAssay_Base::C_Method::C_EMethod::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CAssay_Base::C_Method::C_EMethod::CanGetAttlist(void) const
{
    return true;
}

inline
const CAssay_Base::C_Method::C_EMethod::TAttlist& CAssay_Base::C_Method::C_EMethod::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_EMethod*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CAssay_Base::C_Method::C_EMethod::TAttlist& CAssay_Base::C_Method::C_EMethod::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CAssay_Base::C_Method::C_EMethod::IsSetException(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAssay_Base::C_Method::C_EMethod::CanGetException(void) const
{
    return IsSetException();
}

inline
const CAssay_Base::C_Method::C_EMethod::TException& CAssay_Base::C_Method::C_EMethod::GetException(void) const
{
    if (!CanGetException()) {
        ThrowUnassigned(1);
    }
    return m_Exception;
}

inline
void CAssay_Base::C_Method::C_EMethod::SetException(const CAssay_Base::C_Method::C_EMethod::TException& value)
{
    m_Exception = value;
    m_set_State[0] |= 0xc;
}

inline
void CAssay_Base::C_Method::C_EMethod::SetException(CAssay_Base::C_Method::C_EMethod::TException&& value)
{
    m_Exception = std::forward<CAssay_Base::C_Method::C_EMethod::TException>(value);
    m_set_State[0] |= 0xc;
}

inline
CAssay_Base::C_Method::C_EMethod::TException& CAssay_Base::C_Method::C_EMethod::SetException(void)
{
#ifdef _DEBUG
    if (!IsSetException()) {
        m_Exception = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Exception;
}

inline
bool CAssay_Base::C_Method::IsSetEMethod(void) const
{
    return m_EMethod.NotEmpty();
}

inline
bool CAssay_Base::C_Method::CanGetEMethod(void) const
{
    return IsSetEMethod();
}

inline
const CAssay_Base::C_Method::TEMethod& CAssay_Base::C_Method::GetEMethod(void) const
{
    if (!CanGetEMethod()) {
        ThrowUnassigned(0);
    }
    return (*m_EMethod);
}

inline
bool CAssay_Base::C_Taxonomy::C_Attlist::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CAssay_Base::C_Taxonomy::C_Attlist::CanGetId(void) const
{
    return IsSetId();
}

inline
void CAssay_Base::C_Taxonomy::C_Attlist::ResetId(void)
{
    m_Id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CAssay_Base::C_Taxonomy::C_Attlist::TId CAssay_Base::C_Taxonomy::C_Attlist::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CAssay_Base::C_Taxonomy::C_Attlist::SetId(CAssay_Base::C_Taxonomy::C_Attlist::TId value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
CAssay_Base::C_Taxonomy::C_Attlist::TId& CAssay_Base::C_Taxonomy::C_Attlist::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        memset(&m_Id,UnassignedByte(),sizeof(m_Id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CAssay_Base::C_Taxonomy::C_Attlist::IsSetOrganism(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAssay_Base::C_Taxonomy::C_Attlist::CanGetOrganism(void) const
{
    return IsSetOrganism();
}

inline
const CAssay_Base::C_Taxonomy::C_Attlist::TOrganism& CAssay_Base::C_Taxonomy::C_Attlist::GetOrganism(void) const
{
    if (!CanGetOrganism()) {
        ThrowUnassigned(1);
    }
    return m_Organism;
}

inline
void CAssay_Base::C_Taxonomy::C_Attlist::SetOrganism(const CAssay_Base::C_Taxonomy::C_Attlist::TOrganism& value)
{
    m_Organism = value;
    m_set_State[0] |= 0xc;
}

inline
void CAssay_Base::C_Taxonomy::C_Attlist::SetOrganism(CAssay_Base::C_Taxonomy::C_Attlist::TOrganism&& value)
{
    m_Organism = std::forward<CAssay_Base::C_Taxonomy::C_Attlist::TOrganism>(value);
    m_set_State[0] |= 0xc;
}

inline
CAssay_Base::C_Taxonomy::C_Attlist::TOrganism& CAssay_Base::C_Taxonomy::C_Attlist::SetOrganism(void)
{
#ifdef _DEBUG
    if (!IsSetOrganism()) {
        m_Organism = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Organism;
}

inline
bool CAssay_Base::C_Taxonomy::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CAssay_Base::C_Taxonomy::CanGetAttlist(void) const
{
    return true;
}

inline
const CAssay_Base::C_Taxonomy::TAttlist& CAssay_Base::C_Taxonomy::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<C_Taxonomy*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CAssay_Base::C_Taxonomy::TAttlist& CAssay_Base::C_Taxonomy::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CAssay_Base::C_Taxonomy::IsSetTaxonomy(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CAssay_Base::C_Taxonomy::CanGetTaxonomy(void) const
{
    return false;
}

inline
void CAssay_Base::C_Taxonomy::ResetTaxonomy(void)
{
    m_set_State[0] &= ~0xc;
}

inline
void CAssay_Base::C_Taxonomy::SetTaxonomy(void)
{
    m_set_State[0] |= 0xc;
}

inline
bool CAssay_Base::IsSetAttlist(void) const
{
    return m_Attlist.NotEmpty();
}

inline
bool CAssay_Base::CanGetAttlist(void) const
{
    return true;
}

inline
const CAssay_Base::TAttlist& CAssay_Base::GetAttlist(void) const
{
    if ( !m_Attlist ) {
        const_cast<CAssay_Base*>(this)->ResetAttlist();
    }
    return (*m_Attlist);
}

inline
CAssay_Base::TAttlist& CAssay_Base::SetAttlist(void)
{
    if ( !m_Attlist ) {
        ResetAttlist();
    }
    return (*m_Attlist);
}

inline
bool CAssay_Base::IsSetMethod(void) const
{
    return m_Method.NotEmpty();
}

inline
bool CAssay_Base::CanGetMethod(void) const
{
    return true;
}

inline
const CAssay_Base::TMethod& CAssay_Base::GetMethod(void) const
{
    if ( !m_Method ) {
        const_cast<CAssay_Base*>(this)->ResetMethod();
    }
    return (*m_Method);
}

inline
CAssay_Base::TMethod& CAssay_Base::SetMethod(void)
{
    if ( !m_Method ) {
        ResetMethod();
    }
    return (*m_Method);
}

inline
bool CAssay_Base::IsSetTaxonomy(void) const
{
    return m_Taxonomy.NotEmpty();
}

inline
bool CAssay_Base::CanGetTaxonomy(void) const
{
    return true;
}

inline
const CAssay_Base::TTaxonomy& CAssay_Base::GetTaxonomy(void) const
{
    if ( !m_Taxonomy ) {
        const_cast<CAssay_Base*>(this)->ResetTaxonomy();
    }
    return (*m_Taxonomy);
}

inline
CAssay_Base::TTaxonomy& CAssay_Base::SetTaxonomy(void)
{
    if ( !m_Taxonomy ) {
        ResetTaxonomy();
    }
    return (*m_Taxonomy);
}

inline
bool CAssay_Base::IsSetStrains(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CAssay_Base::CanGetStrains(void) const
{
    return true;
}

inline
const CAssay_Base::TStrains& CAssay_Base::GetStrains(void) const
{
    return m_Strains;
}

inline
CAssay_Base::TStrains& CAssay_Base::SetStrains(void)
{
    m_set_State[0] |= 0x40;
    return m_Strains;
}

inline
bool CAssay_Base::IsSetComment(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CAssay_Base::CanGetComment(void) const
{
    return IsSetComment();
}

inline
const CAssay_Base::TComment& CAssay_Base::GetComment(void) const
{
    if (!CanGetComment()) {
        ThrowUnassigned(4);
    }
    return m_Comment;
}

inline
void CAssay_Base::SetComment(const CAssay_Base::TComment& value)
{
    m_Comment = value;
    m_set_State[0] |= 0x300;
}

inline
void CAssay_Base::SetComment(CAssay_Base::TComment&& value)
{
    m_Comment = std::forward<CAssay_Base::TComment>(value);
    m_set_State[0] |= 0x300;
}

inline
CAssay_Base::TComment& CAssay_Base::SetComment(void)
{
#ifdef _DEBUG
    if (!IsSetComment()) {
        m_Comment = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Comment;
}

inline
bool CAssay_Base::IsSetCitation(void) const
{
    return ((m_set_State[0] & 0xc00) != 0);
}

inline
bool CAssay_Base::CanGetCitation(void) const
{
    return true;
}

inline
const CAssay_Base::TCitation& CAssay_Base::GetCitation(void) const
{
    return m_Citation;
}

inline
CAssay_Base::TCitation& CAssay_Base::SetCitation(void)
{
    m_set_State[0] |= 0x400;
    return m_Citation;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_DOCSUM_ASSAY_BASE_HPP
