/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_color_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_COLOR_BASE_HPP
#define OBJECTS_CN3D_CN3D_COLOR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// RGB triplet, interpreted (after division by the scale-factor) as floating
/// point values which should range from [0..1]. The default scale-factor is
/// 255, so that one can conveniently set integer byte values [0..255] for
/// colors with the scale-factor already set appropriately to map to [0..1].
///    An alpha value is allowed, but is currently ignored by Cn3D.
class NCBI_CN3D_EXPORT CCn3d_color_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCn3d_color_Base(void);
    // destructor
    virtual ~CCn3d_color_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TScale_factor;
    typedef int TRed;
    typedef int TGreen;
    typedef int TBlue;
    typedef int TAlpha;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_scale_factor,
        e_red,
        e_green,
        e_blue,
        e_alpha
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// optional with default 255
    /// typedef int TScale_factor
    ///  Check whether the Scale_factor data member has been assigned a value.
    bool IsSetScale_factor(void) const;
    /// Check whether it is safe or not to call GetScale_factor method.
    bool CanGetScale_factor(void) const;
    void ResetScale_factor(void);
    void SetDefaultScale_factor(void);
    TScale_factor GetScale_factor(void) const;
    void SetScale_factor(TScale_factor value);
    TScale_factor& SetScale_factor(void);

    /// mandatory
    /// typedef int TRed
    ///  Check whether the Red data member has been assigned a value.
    bool IsSetRed(void) const;
    /// Check whether it is safe or not to call GetRed method.
    bool CanGetRed(void) const;
    void ResetRed(void);
    TRed GetRed(void) const;
    void SetRed(TRed value);
    TRed& SetRed(void);

    /// mandatory
    /// typedef int TGreen
    ///  Check whether the Green data member has been assigned a value.
    bool IsSetGreen(void) const;
    /// Check whether it is safe or not to call GetGreen method.
    bool CanGetGreen(void) const;
    void ResetGreen(void);
    TGreen GetGreen(void) const;
    void SetGreen(TGreen value);
    TGreen& SetGreen(void);

    /// mandatory
    /// typedef int TBlue
    ///  Check whether the Blue data member has been assigned a value.
    bool IsSetBlue(void) const;
    /// Check whether it is safe or not to call GetBlue method.
    bool CanGetBlue(void) const;
    void ResetBlue(void);
    TBlue GetBlue(void) const;
    void SetBlue(TBlue value);
    TBlue& SetBlue(void);

    /// optional with default 255
    /// typedef int TAlpha
    ///  Check whether the Alpha data member has been assigned a value.
    bool IsSetAlpha(void) const;
    /// Check whether it is safe or not to call GetAlpha method.
    bool CanGetAlpha(void) const;
    void ResetAlpha(void);
    void SetDefaultAlpha(void);
    TAlpha GetAlpha(void) const;
    void SetAlpha(TAlpha value);
    TAlpha& SetAlpha(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCn3d_color_Base(const CCn3d_color_Base&);
    CCn3d_color_Base& operator=(const CCn3d_color_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Scale_factor;
    int m_Red;
    int m_Green;
    int m_Blue;
    int m_Alpha;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCn3d_color_Base::IsSetScale_factor(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCn3d_color_Base::CanGetScale_factor(void) const
{
    return true;
}

inline
void CCn3d_color_Base::ResetScale_factor(void)
{
    m_Scale_factor = 255;
    m_set_State[0] &= ~0x3;
}

inline
void CCn3d_color_Base::SetDefaultScale_factor(void)
{
    ResetScale_factor();
}

inline
CCn3d_color_Base::TScale_factor CCn3d_color_Base::GetScale_factor(void) const
{
    return m_Scale_factor;
}

inline
void CCn3d_color_Base::SetScale_factor(CCn3d_color_Base::TScale_factor value)
{
    m_Scale_factor = value;
    m_set_State[0] |= 0x3;
}

inline
CCn3d_color_Base::TScale_factor& CCn3d_color_Base::SetScale_factor(void)
{
#ifdef _DEBUG
    if (!IsSetScale_factor()) {
        memset(&m_Scale_factor,UnassignedByte(),sizeof(m_Scale_factor));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Scale_factor;
}

inline
bool CCn3d_color_Base::IsSetRed(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCn3d_color_Base::CanGetRed(void) const
{
    return IsSetRed();
}

inline
void CCn3d_color_Base::ResetRed(void)
{
    m_Red = 0;
    m_set_State[0] &= ~0xc;
}

inline
CCn3d_color_Base::TRed CCn3d_color_Base::GetRed(void) const
{
    if (!CanGetRed()) {
        ThrowUnassigned(1);
    }
    return m_Red;
}

inline
void CCn3d_color_Base::SetRed(CCn3d_color_Base::TRed value)
{
    m_Red = value;
    m_set_State[0] |= 0xc;
}

inline
CCn3d_color_Base::TRed& CCn3d_color_Base::SetRed(void)
{
#ifdef _DEBUG
    if (!IsSetRed()) {
        memset(&m_Red,UnassignedByte(),sizeof(m_Red));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Red;
}

inline
bool CCn3d_color_Base::IsSetGreen(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCn3d_color_Base::CanGetGreen(void) const
{
    return IsSetGreen();
}

inline
void CCn3d_color_Base::ResetGreen(void)
{
    m_Green = 0;
    m_set_State[0] &= ~0x30;
}

inline
CCn3d_color_Base::TGreen CCn3d_color_Base::GetGreen(void) const
{
    if (!CanGetGreen()) {
        ThrowUnassigned(2);
    }
    return m_Green;
}

inline
void CCn3d_color_Base::SetGreen(CCn3d_color_Base::TGreen value)
{
    m_Green = value;
    m_set_State[0] |= 0x30;
}

inline
CCn3d_color_Base::TGreen& CCn3d_color_Base::SetGreen(void)
{
#ifdef _DEBUG
    if (!IsSetGreen()) {
        memset(&m_Green,UnassignedByte(),sizeof(m_Green));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Green;
}

inline
bool CCn3d_color_Base::IsSetBlue(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CCn3d_color_Base::CanGetBlue(void) const
{
    return IsSetBlue();
}

inline
void CCn3d_color_Base::ResetBlue(void)
{
    m_Blue = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CCn3d_color_Base::TBlue CCn3d_color_Base::GetBlue(void) const
{
    if (!CanGetBlue()) {
        ThrowUnassigned(3);
    }
    return m_Blue;
}

inline
void CCn3d_color_Base::SetBlue(CCn3d_color_Base::TBlue value)
{
    m_Blue = value;
    m_set_State[0] |= 0xc0;
}

inline
CCn3d_color_Base::TBlue& CCn3d_color_Base::SetBlue(void)
{
#ifdef _DEBUG
    if (!IsSetBlue()) {
        memset(&m_Blue,UnassignedByte(),sizeof(m_Blue));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Blue;
}

inline
bool CCn3d_color_Base::IsSetAlpha(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CCn3d_color_Base::CanGetAlpha(void) const
{
    return true;
}

inline
void CCn3d_color_Base::ResetAlpha(void)
{
    m_Alpha = 255;
    m_set_State[0] &= ~0x300;
}

inline
void CCn3d_color_Base::SetDefaultAlpha(void)
{
    ResetAlpha();
}

inline
CCn3d_color_Base::TAlpha CCn3d_color_Base::GetAlpha(void) const
{
    return m_Alpha;
}

inline
void CCn3d_color_Base::SetAlpha(CCn3d_color_Base::TAlpha value)
{
    m_Alpha = value;
    m_set_State[0] |= 0x300;
}

inline
CCn3d_color_Base::TAlpha& CCn3d_color_Base::SetAlpha(void)
{
#ifdef _DEBUG
    if (!IsSetAlpha()) {
        memset(&m_Alpha,UnassignedByte(),sizeof(m_Alpha));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Alpha;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_COLOR_BASE_HPP
