/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cn3d_backbone_label_style_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cn3d.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CN3D_CN3D_BACKBONE_LABEL_STYLE_BASE_HPP
#define OBJECTS_CN3D_CN3D_BACKBONE_LABEL_STYLE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// style blob for backbone labels
class NCBI_CN3D_EXPORT CCn3d_backbone_label_style_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCn3d_backbone_label_style_Base(void);
    // destructor
    virtual ~CCn3d_backbone_label_style_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    enum EType {
        eType_one_letter   = 1,
        eType_three_letter = 2
    };
    
    /// Access to EType's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(EType)(void);
    
    enum ENumber {
        eNumber_none       = 0,
        eNumber_sequential = 1,  ///< from 1, by residues present, to match sequence
        eNumber_pdb        = 2  ///< use number assigned by PDB
    };
    
    /// Access to ENumber's attributes (values, names) as defined in spec
    static const NCBI_NS_NCBI::CEnumeratedTypeValues* ENUM_METHOD_NAME(ENumber)(void);
    
    // types
    typedef int TSpacing;
    typedef EType TType;
    typedef ENumber TNumber;
    typedef bool TTermini;
    typedef bool TWhite;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_spacing,
        e_type,
        e_number,
        e_termini,
        e_white
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// zero means none
    /// mandatory
    /// typedef int TSpacing
    ///  Check whether the Spacing data member has been assigned a value.
    bool IsSetSpacing(void) const;
    /// Check whether it is safe or not to call GetSpacing method.
    bool CanGetSpacing(void) const;
    void ResetSpacing(void);
    TSpacing GetSpacing(void) const;
    void SetSpacing(TSpacing value);
    TSpacing& SetSpacing(void);

    /// mandatory
    /// typedef EType TType
    ///  Check whether the Type data member has been assigned a value.
    bool IsSetType(void) const;
    /// Check whether it is safe or not to call GetType method.
    bool CanGetType(void) const;
    void ResetType(void);
    TType GetType(void) const;
    void SetType(TType value);
    TType& SetType(void);

    /// mandatory
    /// typedef ENumber TNumber
    ///  Check whether the Number data member has been assigned a value.
    bool IsSetNumber(void) const;
    /// Check whether it is safe or not to call GetNumber method.
    bool CanGetNumber(void) const;
    void ResetNumber(void);
    TNumber GetNumber(void) const;
    void SetNumber(TNumber value);
    TNumber& SetNumber(void);

    /// mandatory
    /// typedef bool TTermini
    ///  Check whether the Termini data member has been assigned a value.
    bool IsSetTermini(void) const;
    /// Check whether it is safe or not to call GetTermini method.
    bool CanGetTermini(void) const;
    void ResetTermini(void);
    TTermini GetTermini(void) const;
    void SetTermini(TTermini value);
    TTermini& SetTermini(void);

    /// all white, or (if false) color of alpha carbon
    /// mandatory
    /// typedef bool TWhite
    ///  Check whether the White data member has been assigned a value.
    bool IsSetWhite(void) const;
    /// Check whether it is safe or not to call GetWhite method.
    bool CanGetWhite(void) const;
    void ResetWhite(void);
    TWhite GetWhite(void) const;
    void SetWhite(TWhite value);
    TWhite& SetWhite(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCn3d_backbone_label_style_Base(const CCn3d_backbone_label_style_Base&);
    CCn3d_backbone_label_style_Base& operator=(const CCn3d_backbone_label_style_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Spacing;
    EType m_Type;
    ENumber m_Number;
    bool m_Termini;
    bool m_White;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCn3d_backbone_label_style_Base::IsSetSpacing(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCn3d_backbone_label_style_Base::CanGetSpacing(void) const
{
    return IsSetSpacing();
}

inline
void CCn3d_backbone_label_style_Base::ResetSpacing(void)
{
    m_Spacing = 0;
    m_set_State[0] &= ~0x3;
}

inline
CCn3d_backbone_label_style_Base::TSpacing CCn3d_backbone_label_style_Base::GetSpacing(void) const
{
    if (!CanGetSpacing()) {
        ThrowUnassigned(0);
    }
    return m_Spacing;
}

inline
void CCn3d_backbone_label_style_Base::SetSpacing(CCn3d_backbone_label_style_Base::TSpacing value)
{
    m_Spacing = value;
    m_set_State[0] |= 0x3;
}

inline
CCn3d_backbone_label_style_Base::TSpacing& CCn3d_backbone_label_style_Base::SetSpacing(void)
{
#ifdef _DEBUG
    if (!IsSetSpacing()) {
        memset(&m_Spacing,UnassignedByte(),sizeof(m_Spacing));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Spacing;
}

inline
bool CCn3d_backbone_label_style_Base::IsSetType(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CCn3d_backbone_label_style_Base::CanGetType(void) const
{
    return IsSetType();
}

inline
void CCn3d_backbone_label_style_Base::ResetType(void)
{
    m_Type = (EType)(0);
    m_set_State[0] &= ~0xc;
}

inline
CCn3d_backbone_label_style_Base::TType CCn3d_backbone_label_style_Base::GetType(void) const
{
    if (!CanGetType()) {
        ThrowUnassigned(1);
    }
    return m_Type;
}

inline
void CCn3d_backbone_label_style_Base::SetType(CCn3d_backbone_label_style_Base::TType value)
{
    m_Type = value;
    m_set_State[0] |= 0xc;
}

inline
CCn3d_backbone_label_style_Base::TType& CCn3d_backbone_label_style_Base::SetType(void)
{
#ifdef _DEBUG
    if (!IsSetType()) {
        memset(&m_Type,UnassignedByte(),sizeof(m_Type));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Type;
}

inline
bool CCn3d_backbone_label_style_Base::IsSetNumber(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCn3d_backbone_label_style_Base::CanGetNumber(void) const
{
    return IsSetNumber();
}

inline
void CCn3d_backbone_label_style_Base::ResetNumber(void)
{
    m_Number = (ENumber)(0);
    m_set_State[0] &= ~0x30;
}

inline
CCn3d_backbone_label_style_Base::TNumber CCn3d_backbone_label_style_Base::GetNumber(void) const
{
    if (!CanGetNumber()) {
        ThrowUnassigned(2);
    }
    return m_Number;
}

inline
void CCn3d_backbone_label_style_Base::SetNumber(CCn3d_backbone_label_style_Base::TNumber value)
{
    m_Number = value;
    m_set_State[0] |= 0x30;
}

inline
CCn3d_backbone_label_style_Base::TNumber& CCn3d_backbone_label_style_Base::SetNumber(void)
{
#ifdef _DEBUG
    if (!IsSetNumber()) {
        memset(&m_Number,UnassignedByte(),sizeof(m_Number));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Number;
}

inline
bool CCn3d_backbone_label_style_Base::IsSetTermini(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CCn3d_backbone_label_style_Base::CanGetTermini(void) const
{
    return IsSetTermini();
}

inline
void CCn3d_backbone_label_style_Base::ResetTermini(void)
{
    m_Termini = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CCn3d_backbone_label_style_Base::TTermini CCn3d_backbone_label_style_Base::GetTermini(void) const
{
    if (!CanGetTermini()) {
        ThrowUnassigned(3);
    }
    return m_Termini;
}

inline
void CCn3d_backbone_label_style_Base::SetTermini(CCn3d_backbone_label_style_Base::TTermini value)
{
    m_Termini = value;
    m_set_State[0] |= 0xc0;
}

inline
CCn3d_backbone_label_style_Base::TTermini& CCn3d_backbone_label_style_Base::SetTermini(void)
{
#ifdef _DEBUG
    if (!IsSetTermini()) {
        memset(&m_Termini,UnassignedByte(),sizeof(m_Termini));
    }
#endif
    m_set_State[0] |= 0x40;
    return m_Termini;
}

inline
bool CCn3d_backbone_label_style_Base::IsSetWhite(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CCn3d_backbone_label_style_Base::CanGetWhite(void) const
{
    return IsSetWhite();
}

inline
void CCn3d_backbone_label_style_Base::ResetWhite(void)
{
    m_White = 0;
    m_set_State[0] &= ~0x300;
}

inline
CCn3d_backbone_label_style_Base::TWhite CCn3d_backbone_label_style_Base::GetWhite(void) const
{
    if (!CanGetWhite()) {
        ThrowUnassigned(4);
    }
    return m_White;
}

inline
void CCn3d_backbone_label_style_Base::SetWhite(CCn3d_backbone_label_style_Base::TWhite value)
{
    m_White = value;
    m_set_State[0] |= 0x300;
}

inline
CCn3d_backbone_label_style_Base::TWhite& CCn3d_backbone_label_style_Base::SetWhite(void)
{
#ifdef _DEBUG
    if (!IsSetWhite()) {
        memset(&m_White,UnassignedByte(),sizeof(m_White));
    }
#endif
    m_set_State[0] |= 0x100;
    return m_White;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CN3D_CN3D_BACKBONE_LABEL_STYLE_BASE_HPP
