/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Feature_evidence_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_FEATURE_EVIDENCE_BASE_HPP
#define OBJECTS_CDD_FEATURE_EVIDENCE_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBiostruc_annot_set;
class CCdd_book_ref;
class CPub;
class CSeq_feat;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_CDD_EXPORT CFeature_evidence_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CFeature_evidence_Base(void);
    // destructor
    virtual ~CFeature_evidence_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();


    /// Choice variants.
    enum E_Choice {
        e_not_set = 0,  ///< No variant selected
        e_Comment,      ///< so we can spell out what doesn't  fit in any other category
        e_Reference,    ///< evidence via a literature reference
        e_Bsannot,      ///< evidence via Biostruc-features, such  as structure superpositions 
        e_Seqfeat,      ///< evidence is a Sequence feature found  elsewhere
        e_Book_ref      ///< evidence is a book chapter or figure
    };
    /// Maximum+1 value of the choice variant enumerator.
    enum E_ChoiceStopper {
        e_MaxChoice = 6 ///< == e_Book_ref+1
    };

    /// Reset the whole object
    virtual void Reset(void);

    /// Reset the selection (set it to e_not_set).
    virtual void ResetSelection(void);

    /// Which variant is currently selected.
    E_Choice Which(void) const;

    /// Verify selection, throw exception if it differs from the expected.
    void CheckSelected(E_Choice index) const;

    /// Throw 'InvalidSelection' exception.
    NCBI_NORETURN void ThrowInvalidSelection(E_Choice index) const;

    /// Retrieve selection name (for diagnostic purposes).
    static string SelectionName(E_Choice index);

    /// Select the requested variant if needed.
    void Select(E_Choice index, EResetVariant reset = eDoResetVariant);
    /// Select the requested variant if needed,
    /// allocating CObject variants from memory pool.
    void Select(E_Choice index,
                EResetVariant reset,
                CObjectMemoryPool* pool);

    // types
    typedef string TComment;
    typedef CPub TReference;
    typedef CBiostruc_annot_set TBsannot;
    typedef CSeq_feat TSeqfeat;
    typedef CCdd_book_ref TBook_ref;

    // getters
    // setters

    // typedef string TComment
    bool IsComment(void) const;
    const TComment& GetComment(void) const;
    TComment& SetComment(void);
    void SetComment(const TComment& value);

    // typedef CPub TReference
    bool IsReference(void) const;
    const TReference& GetReference(void) const;
    TReference& SetReference(void);
    void SetReference(TReference& value);

    // typedef CBiostruc_annot_set TBsannot
    bool IsBsannot(void) const;
    const TBsannot& GetBsannot(void) const;
    TBsannot& SetBsannot(void);
    void SetBsannot(TBsannot& value);

    // typedef CSeq_feat TSeqfeat
    bool IsSeqfeat(void) const;
    const TSeqfeat& GetSeqfeat(void) const;
    TSeqfeat& SetSeqfeat(void);
    void SetSeqfeat(TSeqfeat& value);

    // typedef CCdd_book_ref TBook_ref
    bool IsBook_ref(void) const;
    const TBook_ref& GetBook_ref(void) const;
    TBook_ref& SetBook_ref(void);
    void SetBook_ref(TBook_ref& value);


private:
    // copy constructor and assignment operator
    CFeature_evidence_Base(const CFeature_evidence_Base& );
    CFeature_evidence_Base& operator=(const CFeature_evidence_Base& );
    // choice state
    E_Choice m_choice;
    // helper methods
    void DoSelect(E_Choice index, CObjectMemoryPool* pool = 0);

    static const char* const sm_SelectionNames[];
    // data
    union {
        NCBI_NS_NCBI::CUnionBuffer<NCBI_NS_STD::string> m_string;
        NCBI_NS_NCBI::CSerialObject *m_object;
    };
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
CFeature_evidence_Base::E_Choice CFeature_evidence_Base::Which(void) const
{
    return m_choice;
}

inline
void CFeature_evidence_Base::CheckSelected(E_Choice index) const
{
    if ( m_choice != index )
        ThrowInvalidSelection(index);
}

inline
void CFeature_evidence_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset, NCBI_NS_NCBI::CObjectMemoryPool* pool)
{
    if ( reset == NCBI_NS_NCBI::eDoResetVariant || m_choice != index ) {
        if ( m_choice != e_not_set )
            ResetSelection();
        DoSelect(index, pool);
    }
}

inline
void CFeature_evidence_Base::Select(E_Choice index, NCBI_NS_NCBI::EResetVariant reset)
{
    Select(index, reset, 0);
}

inline
bool CFeature_evidence_Base::IsComment(void) const
{
    return m_choice == e_Comment;
}

inline
const CFeature_evidence_Base::TComment& CFeature_evidence_Base::GetComment(void) const
{
    CheckSelected(e_Comment);
    return *m_string;
}

inline
CFeature_evidence_Base::TComment& CFeature_evidence_Base::SetComment(void)
{
    Select(e_Comment, NCBI_NS_NCBI::eDoNotResetVariant);
    return *m_string;
}

inline
bool CFeature_evidence_Base::IsReference(void) const
{
    return m_choice == e_Reference;
}

inline
bool CFeature_evidence_Base::IsBsannot(void) const
{
    return m_choice == e_Bsannot;
}

inline
bool CFeature_evidence_Base::IsSeqfeat(void) const
{
    return m_choice == e_Seqfeat;
}

inline
bool CFeature_evidence_Base::IsBook_ref(void) const
{
    return m_choice == e_Book_ref;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_FEATURE_EVIDENCE_BASE_HPP
