/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cdd_repeat_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_CDD_REPEAT_BASE_HPP
#define OBJECTS_CDD_CDD_REPEAT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>
BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// record whether the CD contains
/// repeated sequence/structure motifs
class NCBI_CDD_EXPORT CCdd_repeat_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCdd_repeat_Base(void);
    // destructor
    virtual ~CCdd_repeat_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TCount;
    typedef CSeq_loc TLocation;
    typedef int TAvglen;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_count,
        e_location,
        e_avglen
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 4> TmemberIndex;

    // getters
    // setters

    /// number of tandem repeats in the CD
    /// mandatory
    /// typedef int TCount
    ///  Check whether the Count data member has been assigned a value.
    bool IsSetCount(void) const;
    /// Check whether it is safe or not to call GetCount method.
    bool CanGetCount(void) const;
    void ResetCount(void);
    TCount GetCount(void) const;
    void SetCount(TCount value);
    TCount& SetCount(void);

    /// location on the representative
    /// optional
    /// typedef CSeq_loc TLocation
    ///  Check whether the Location data member has been assigned a value.
    bool IsSetLocation(void) const;
    /// Check whether it is safe or not to call GetLocation method.
    bool CanGetLocation(void) const;
    void ResetLocation(void);
    const TLocation& GetLocation(void) const;
    void SetLocation(TLocation& value);
    TLocation& SetLocation(void);

    /// average repeat length
    /// optional
    /// typedef int TAvglen
    ///  Check whether the Avglen data member has been assigned a value.
    bool IsSetAvglen(void) const;
    /// Check whether it is safe or not to call GetAvglen method.
    bool CanGetAvglen(void) const;
    void ResetAvglen(void);
    TAvglen GetAvglen(void) const;
    void SetAvglen(TAvglen value);
    TAvglen& SetAvglen(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCdd_repeat_Base(const CCdd_repeat_Base&);
    CCdd_repeat_Base& operator=(const CCdd_repeat_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Count;
    CRef< TLocation > m_Location;
    int m_Avglen;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCdd_repeat_Base::IsSetCount(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCdd_repeat_Base::CanGetCount(void) const
{
    return IsSetCount();
}

inline
void CCdd_repeat_Base::ResetCount(void)
{
    m_Count = 0;
    m_set_State[0] &= ~0x3;
}

inline
CCdd_repeat_Base::TCount CCdd_repeat_Base::GetCount(void) const
{
    if (!CanGetCount()) {
        ThrowUnassigned(0);
    }
    return m_Count;
}

inline
void CCdd_repeat_Base::SetCount(CCdd_repeat_Base::TCount value)
{
    m_Count = value;
    m_set_State[0] |= 0x3;
}

inline
CCdd_repeat_Base::TCount& CCdd_repeat_Base::SetCount(void)
{
#ifdef _DEBUG
    if (!IsSetCount()) {
        memset(&m_Count,UnassignedByte(),sizeof(m_Count));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Count;
}

inline
bool CCdd_repeat_Base::IsSetLocation(void) const
{
    return m_Location.NotEmpty();
}

inline
bool CCdd_repeat_Base::CanGetLocation(void) const
{
    return IsSetLocation();
}

inline
const CCdd_repeat_Base::TLocation& CCdd_repeat_Base::GetLocation(void) const
{
    if (!CanGetLocation()) {
        ThrowUnassigned(1);
    }
    return (*m_Location);
}

inline
bool CCdd_repeat_Base::IsSetAvglen(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CCdd_repeat_Base::CanGetAvglen(void) const
{
    return IsSetAvglen();
}

inline
void CCdd_repeat_Base::ResetAvglen(void)
{
    m_Avglen = 0;
    m_set_State[0] &= ~0x30;
}

inline
CCdd_repeat_Base::TAvglen CCdd_repeat_Base::GetAvglen(void) const
{
    if (!CanGetAvglen()) {
        ThrowUnassigned(2);
    }
    return m_Avglen;
}

inline
void CCdd_repeat_Base::SetAvglen(CCdd_repeat_Base::TAvglen value)
{
    m_Avglen = value;
    m_set_State[0] |= 0x30;
}

inline
CCdd_repeat_Base::TAvglen& CCdd_repeat_Base::SetAvglen(void)
{
#ifdef _DEBUG
    if (!IsSetAvglen()) {
        memset(&m_Avglen,UnassignedByte(),sizeof(m_Avglen));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Avglen;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_CDD_REPEAT_BASE_HPP
