/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Cdd_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'cdd.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_CDD_CDD_BASE_HPP
#define OBJECTS_CDD_CDD_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CAlign_annot_set;
class CBioseq;
class CBiostruc_annot_set;
class CCdd_descr_set;
class CCdd_id;
class CCdd_id_set;
class CCn3d_style_dictionary;
class CCn3d_user_annotations;
class CDomain_parent;
class CMatrix;
class CPssmWithParameters;
class CReject_id;
class CSeq_annot;
class CSeq_entry;
class CSeq_id;
class CSeq_interval;
class CSequence_tree;
class CTriangle;
class CUpdate_align;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// the Cdd is the basic ASN.1 object storing an annotated and curated set of
/// alignments (formulated as a set of pairwise master-slave alignments). 
/// The alignment data are contained in Seq-annots, and a special type of
/// object, the Update-align, contains additional alignment data from unfinished
/// editing sessions and update processes. The Biostruc-annot-set holds 
/// structure superposition information for multiple structure-derived rows in
/// the alignment.
/// Version numbers in Global-ids are meant to be updated every time the Cdd is
/// changed in a way that does not require Global-ids to be changed (sequences
/// added in update cycle, annotation changed, alignment errors fixed)
class NCBI_CDD_EXPORT CCdd_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CCdd_Base(void);
    // destructor
    virtual ~CCdd_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TName;
    typedef CCdd_id_set TId;
    typedef CCdd_descr_set TDescription;
    typedef list< CRef< CSeq_annot > > TSeqannot;
    typedef CBiostruc_annot_set TFeatures;
    typedef CSeq_entry TSequences;
    typedef CSeq_interval TProfile_range;
    typedef CBioseq TTrunc_master;
    typedef CMatrix TPosfreq;
    typedef CMatrix TScoremat;
    typedef CTriangle TDistance;
    typedef CCdd_id TParent;
    typedef CCdd_id_set TChildren;
    typedef CCdd_id_set TSiblings;
    typedef CCdd_id_set TNeighbors;
    typedef list< CRef< CUpdate_align > > TPending;
    typedef list< CRef< CReject_id > > TRejects;
    typedef list< CRef< CSeq_id > > TMaster3d;
    typedef CAlign_annot_set TAlignannot;
    typedef CCn3d_style_dictionary TStyle_dictionary;
    typedef CCn3d_user_annotations TUser_annotations;
    typedef list< CRef< CDomain_parent > > TAncestors;
    typedef CPssmWithParameters TScoreparams;
    typedef CSequence_tree TSeqtree;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_name,
        e_id,
        e_description,
        e_seqannot,
        e_features,
        e_sequences,
        e_profile_range,
        e_trunc_master,
        e_posfreq,
        e_scoremat,
        e_distance,
        e_parent,
        e_children,
        e_siblings,
        e_neighbors,
        e_pending,
        e_rejects,
        e_master3d,
        e_alignannot,
        e_style_dictionary,
        e_user_annotations,
        e_ancestors,
        e_scoreparams,
        e_seqtree
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 25> TmemberIndex;

    // getters
    // setters

    /// a short name (can be the accession..)
    /// mandatory
    /// typedef string TName
    ///  Check whether the Name data member has been assigned a value.
    bool IsSetName(void) const;
    /// Check whether it is safe or not to call GetName method.
    bool CanGetName(void) const;
    void ResetName(void);
    const TName& GetName(void) const;
    void SetName(const TName& value);
    void SetName(TName&& value);
    TName& SetName(void);

    /// this CD's Ids
    /// mandatory
    /// typedef CCdd_id_set TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(TId& value);
    TId& SetId(void);

    /// status, references, etc.
    /// optional
    /// typedef CCdd_descr_set TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    void SetDescription(TDescription& value);
    TDescription& SetDescription(void);

    /// contains the CD alignment
    /// optional
    /// typedef list< CRef< CSeq_annot > > TSeqannot
    ///  Check whether the Seqannot data member has been assigned a value.
    bool IsSetSeqannot(void) const;
    /// Check whether it is safe or not to call GetSeqannot method.
    bool CanGetSeqannot(void) const;
    void ResetSeqannot(void);
    const TSeqannot& GetSeqannot(void) const;
    TSeqannot& SetSeqannot(void);

    /// contains structure
    /// alignment data
    /// or "core" definitions
    /// optional
    /// typedef CBiostruc_annot_set TFeatures
    ///  Check whether the Features data member has been assigned a value.
    bool IsSetFeatures(void) const;
    /// Check whether it is safe or not to call GetFeatures method.
    bool CanGetFeatures(void) const;
    void ResetFeatures(void);
    const TFeatures& GetFeatures(void) const;
    void SetFeatures(TFeatures& value);
    TFeatures& SetFeatures(void);

    /// store as bioseq-set inside seq-entry
    /// optional
    /// typedef CSeq_entry TSequences
    ///  Check whether the Sequences data member has been assigned a value.
    bool IsSetSequences(void) const;
    /// Check whether it is safe or not to call GetSequences method.
    bool CanGetSequences(void) const;
    void ResetSequences(void);
    const TSequences& GetSequences(void) const;
    void SetSequences(TSequences& value);
    TSequences& SetSequences(void);

    /// profile for this region only
    /// also stores the Seq-id of the master
    /// optional
    /// typedef CSeq_interval TProfile_range
    ///  Check whether the Profile_range data member has been assigned a value.
    bool IsSetProfile_range(void) const;
    /// Check whether it is safe or not to call GetProfile_range method.
    bool CanGetProfile_range(void) const;
    void ResetProfile_range(void);
    const TProfile_range& GetProfile_range(void) const;
    void SetProfile_range(TProfile_range& value);
    TProfile_range& SetProfile_range(void);

    /// holds the truncated master, which
    /// may be something like a consensus,
    /// uses the same sequence coordinate
    /// frame as the profile-range
    /// optional
    /// typedef CBioseq TTrunc_master
    ///  Check whether the Trunc_master data member has been assigned a value.
    bool IsSetTrunc_master(void) const;
    /// Check whether it is safe or not to call GetTrunc_master method.
    bool CanGetTrunc_master(void) const;
    void ResetTrunc_master(void);
    const TTrunc_master& GetTrunc_master(void) const;
    void SetTrunc_master(TTrunc_master& value);
    TTrunc_master& SetTrunc_master(void);

    /// relative residue frequencies
    /// optional
    /// typedef CMatrix TPosfreq
    ///  Check whether the Posfreq data member has been assigned a value.
    bool IsSetPosfreq(void) const;
    /// Check whether it is safe or not to call GetPosfreq method.
    bool CanGetPosfreq(void) const;
    void ResetPosfreq(void);
    const TPosfreq& GetPosfreq(void) const;
    void SetPosfreq(TPosfreq& value);
    TPosfreq& SetPosfreq(void);

    /// Position dependent score matrix
    /// optional
    /// typedef CMatrix TScoremat
    ///  Check whether the Scoremat data member has been assigned a value.
    bool IsSetScoremat(void) const;
    /// Check whether it is safe or not to call GetScoremat method.
    bool CanGetScoremat(void) const;
    void ResetScoremat(void);
    const TScoremat& GetScoremat(void) const;
    void SetScoremat(TScoremat& value);
    TScoremat& SetScoremat(void);

    /// pairwise distances for all seqs.
    /// optional
    /// typedef CTriangle TDistance
    ///  Check whether the Distance data member has been assigned a value.
    bool IsSetDistance(void) const;
    /// Check whether it is safe or not to call GetDistance method.
    bool CanGetDistance(void) const;
    void ResetDistance(void);
    const TDistance& GetDistance(void) const;
    void SetDistance(TDistance& value);
    TDistance& SetDistance(void);

    /// this CD is the result of a split
    /// optional
    /// typedef CCdd_id TParent
    ///  Check whether the Parent data member has been assigned a value.
    bool IsSetParent(void) const;
    /// Check whether it is safe or not to call GetParent method.
    bool CanGetParent(void) const;
    void ResetParent(void);
    const TParent& GetParent(void) const;
    void SetParent(TParent& value);
    TParent& SetParent(void);

    /// this CD has been split, not used
    /// optional
    /// typedef CCdd_id_set TChildren
    ///  Check whether the Children data member has been assigned a value.
    bool IsSetChildren(void) const;
    /// Check whether it is safe or not to call GetChildren method.
    bool CanGetChildren(void) const;
    void ResetChildren(void);
    const TChildren& GetChildren(void) const;
    void SetChildren(TChildren& value);
    TChildren& SetChildren(void);

    /// related CDs (common hits), clusters
    /// optional
    /// typedef CCdd_id_set TSiblings
    ///  Check whether the Siblings data member has been assigned a value.
    bool IsSetSiblings(void) const;
    /// Check whether it is safe or not to call GetSiblings method.
    bool CanGetSiblings(void) const;
    void ResetSiblings(void);
    const TSiblings& GetSiblings(void) const;
    void SetSiblings(TSiblings& value);
    TSiblings& SetSiblings(void);

    /// co-occurring CDs, not used
    /// optional
    /// typedef CCdd_id_set TNeighbors
    ///  Check whether the Neighbors data member has been assigned a value.
    bool IsSetNeighbors(void) const;
    /// Check whether it is safe or not to call GetNeighbors method.
    bool CanGetNeighbors(void) const;
    void ResetNeighbors(void);
    const TNeighbors& GetNeighbors(void) const;
    void SetNeighbors(TNeighbors& value);
    TNeighbors& SetNeighbors(void);

    /// contains alignments from
    /// update or "lower panel"
    /// optional
    /// typedef list< CRef< CUpdate_align > > TPending
    ///  Check whether the Pending data member has been assigned a value.
    bool IsSetPending(void) const;
    /// Check whether it is safe or not to call GetPending method.
    bool CanGetPending(void) const;
    void ResetPending(void);
    const TPending& GetPending(void) const;
    TPending& SetPending(void);

    /// SeqIds of rejected CD-
    /// members, ignore in update
    /// optional
    /// typedef list< CRef< CReject_id > > TRejects
    ///  Check whether the Rejects data member has been assigned a value.
    bool IsSetRejects(void) const;
    /// Check whether it is safe or not to call GetRejects method.
    bool CanGetRejects(void) const;
    void ResetRejects(void);
    const TRejects& GetRejects(void) const;
    TRejects& SetRejects(void);

    /// record if CD has a 3D representative
    /// optional
    /// typedef list< CRef< CSeq_id > > TMaster3d
    ///  Check whether the Master3d data member has been assigned a value.
    bool IsSetMaster3d(void) const;
    /// Check whether it is safe or not to call GetMaster3d method.
    bool CanGetMaster3d(void) const;
    void ResetMaster3d(void);
    const TMaster3d& GetMaster3d(void) const;
    TMaster3d& SetMaster3d(void);

    /// alignment annotation
    /// optional
    /// typedef CAlign_annot_set TAlignannot
    ///  Check whether the Alignannot data member has been assigned a value.
    bool IsSetAlignannot(void) const;
    /// Check whether it is safe or not to call GetAlignannot method.
    bool CanGetAlignannot(void) const;
    void ResetAlignannot(void);
    const TAlignannot& GetAlignannot(void) const;
    void SetAlignannot(TAlignannot& value);
    TAlignannot& SetAlignannot(void);

    /// record rendering styles
    /// optional
    /// typedef CCn3d_style_dictionary TStyle_dictionary
    ///  Check whether the Style_dictionary data member has been assigned a value.
    bool IsSetStyle_dictionary(void) const;
    /// Check whether it is safe or not to call GetStyle_dictionary method.
    bool CanGetStyle_dictionary(void) const;
    void ResetStyle_dictionary(void);
    const TStyle_dictionary& GetStyle_dictionary(void) const;
    void SetStyle_dictionary(TStyle_dictionary& value);
    TStyle_dictionary& SetStyle_dictionary(void);

    /// user annotations in Cn3D
    /// optional
    /// typedef CCn3d_user_annotations TUser_annotations
    ///  Check whether the User_annotations data member has been assigned a value.
    bool IsSetUser_annotations(void) const;
    /// Check whether it is safe or not to call GetUser_annotations method.
    bool CanGetUser_annotations(void) const;
    void ResetUser_annotations(void);
    const TUser_annotations& GetUser_annotations(void) const;
    void SetUser_annotations(TUser_annotations& value);
    TUser_annotations& SetUser_annotations(void);

    /// list of parents
    /// optional
    /// typedef list< CRef< CDomain_parent > > TAncestors
    ///  Check whether the Ancestors data member has been assigned a value.
    bool IsSetAncestors(void) const;
    /// Check whether it is safe or not to call GetAncestors method.
    bool CanGetAncestors(void) const;
    void ResetAncestors(void);
    const TAncestors& GetAncestors(void) const;
    TAncestors& SetAncestors(void);

    /// optional
    /// typedef CPssmWithParameters TScoreparams
    ///  Check whether the Scoreparams data member has been assigned a value.
    bool IsSetScoreparams(void) const;
    /// Check whether it is safe or not to call GetScoreparams method.
    bool CanGetScoreparams(void) const;
    void ResetScoreparams(void);
    const TScoreparams& GetScoreparams(void) const;
    void SetScoreparams(TScoreparams& value);
    TScoreparams& SetScoreparams(void);

    /// optional
    /// typedef CSequence_tree TSeqtree
    ///  Check whether the Seqtree data member has been assigned a value.
    bool IsSetSeqtree(void) const;
    /// Check whether it is safe or not to call GetSeqtree method.
    bool CanGetSeqtree(void) const;
    void ResetSeqtree(void);
    const TSeqtree& GetSeqtree(void) const;
    void SetSeqtree(TSeqtree& value);
    TSeqtree& SetSeqtree(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CCdd_Base(const CCdd_Base&);
    CCdd_Base& operator=(const CCdd_Base&);

    // data
    Uint4 m_set_State[2];
    string m_Name;
    CRef< TId > m_Id;
    CRef< TDescription > m_Description;
    list< CRef< CSeq_annot > > m_Seqannot;
    CRef< TFeatures > m_Features;
    CRef< TSequences > m_Sequences;
    CRef< TProfile_range > m_Profile_range;
    CRef< TTrunc_master > m_Trunc_master;
    CRef< TPosfreq > m_Posfreq;
    CRef< TScoremat > m_Scoremat;
    CRef< TDistance > m_Distance;
    CRef< TParent > m_Parent;
    CRef< TChildren > m_Children;
    CRef< TSiblings > m_Siblings;
    CRef< TNeighbors > m_Neighbors;
    list< CRef< CUpdate_align > > m_Pending;
    list< CRef< CReject_id > > m_Rejects;
    list< CRef< CSeq_id > > m_Master3d;
    CRef< TAlignannot > m_Alignannot;
    CRef< TStyle_dictionary > m_Style_dictionary;
    CRef< TUser_annotations > m_User_annotations;
    list< CRef< CDomain_parent > > m_Ancestors;
    CRef< TScoreparams > m_Scoreparams;
    CRef< TSeqtree > m_Seqtree;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CCdd_Base::IsSetName(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CCdd_Base::CanGetName(void) const
{
    return IsSetName();
}

inline
const CCdd_Base::TName& CCdd_Base::GetName(void) const
{
    if (!CanGetName()) {
        ThrowUnassigned(0);
    }
    return m_Name;
}

inline
void CCdd_Base::SetName(const CCdd_Base::TName& value)
{
    m_Name = value;
    m_set_State[0] |= 0x3;
}

inline
void CCdd_Base::SetName(CCdd_Base::TName&& value)
{
    m_Name = std::forward<CCdd_Base::TName>(value);
    m_set_State[0] |= 0x3;
}

inline
CCdd_Base::TName& CCdd_Base::SetName(void)
{
#ifdef _DEBUG
    if (!IsSetName()) {
        m_Name = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Name;
}

inline
bool CCdd_Base::IsSetId(void) const
{
    return m_Id.NotEmpty();
}

inline
bool CCdd_Base::CanGetId(void) const
{
    return true;
}

inline
const CCdd_Base::TId& CCdd_Base::GetId(void) const
{
    if ( !m_Id ) {
        const_cast<CCdd_Base*>(this)->ResetId();
    }
    return (*m_Id);
}

inline
CCdd_Base::TId& CCdd_Base::SetId(void)
{
    if ( !m_Id ) {
        ResetId();
    }
    return (*m_Id);
}

inline
bool CCdd_Base::IsSetDescription(void) const
{
    return m_Description.NotEmpty();
}

inline
bool CCdd_Base::CanGetDescription(void) const
{
    return IsSetDescription();
}

inline
const CCdd_Base::TDescription& CCdd_Base::GetDescription(void) const
{
    if (!CanGetDescription()) {
        ThrowUnassigned(2);
    }
    return (*m_Description);
}

inline
bool CCdd_Base::IsSetSeqannot(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CCdd_Base::CanGetSeqannot(void) const
{
    return true;
}

inline
const CCdd_Base::TSeqannot& CCdd_Base::GetSeqannot(void) const
{
    return m_Seqannot;
}

inline
CCdd_Base::TSeqannot& CCdd_Base::SetSeqannot(void)
{
    m_set_State[0] |= 0x40;
    return m_Seqannot;
}

inline
bool CCdd_Base::IsSetFeatures(void) const
{
    return m_Features.NotEmpty();
}

inline
bool CCdd_Base::CanGetFeatures(void) const
{
    return IsSetFeatures();
}

inline
const CCdd_Base::TFeatures& CCdd_Base::GetFeatures(void) const
{
    if (!CanGetFeatures()) {
        ThrowUnassigned(4);
    }
    return (*m_Features);
}

inline
bool CCdd_Base::IsSetSequences(void) const
{
    return m_Sequences.NotEmpty();
}

inline
bool CCdd_Base::CanGetSequences(void) const
{
    return IsSetSequences();
}

inline
const CCdd_Base::TSequences& CCdd_Base::GetSequences(void) const
{
    if (!CanGetSequences()) {
        ThrowUnassigned(5);
    }
    return (*m_Sequences);
}

inline
bool CCdd_Base::IsSetProfile_range(void) const
{
    return m_Profile_range.NotEmpty();
}

inline
bool CCdd_Base::CanGetProfile_range(void) const
{
    return IsSetProfile_range();
}

inline
const CCdd_Base::TProfile_range& CCdd_Base::GetProfile_range(void) const
{
    if (!CanGetProfile_range()) {
        ThrowUnassigned(6);
    }
    return (*m_Profile_range);
}

inline
bool CCdd_Base::IsSetTrunc_master(void) const
{
    return m_Trunc_master.NotEmpty();
}

inline
bool CCdd_Base::CanGetTrunc_master(void) const
{
    return IsSetTrunc_master();
}

inline
const CCdd_Base::TTrunc_master& CCdd_Base::GetTrunc_master(void) const
{
    if (!CanGetTrunc_master()) {
        ThrowUnassigned(7);
    }
    return (*m_Trunc_master);
}

inline
bool CCdd_Base::IsSetPosfreq(void) const
{
    return m_Posfreq.NotEmpty();
}

inline
bool CCdd_Base::CanGetPosfreq(void) const
{
    return IsSetPosfreq();
}

inline
const CCdd_Base::TPosfreq& CCdd_Base::GetPosfreq(void) const
{
    if (!CanGetPosfreq()) {
        ThrowUnassigned(8);
    }
    return (*m_Posfreq);
}

inline
bool CCdd_Base::IsSetScoremat(void) const
{
    return m_Scoremat.NotEmpty();
}

inline
bool CCdd_Base::CanGetScoremat(void) const
{
    return IsSetScoremat();
}

inline
const CCdd_Base::TScoremat& CCdd_Base::GetScoremat(void) const
{
    if (!CanGetScoremat()) {
        ThrowUnassigned(9);
    }
    return (*m_Scoremat);
}

inline
bool CCdd_Base::IsSetDistance(void) const
{
    return m_Distance.NotEmpty();
}

inline
bool CCdd_Base::CanGetDistance(void) const
{
    return IsSetDistance();
}

inline
const CCdd_Base::TDistance& CCdd_Base::GetDistance(void) const
{
    if (!CanGetDistance()) {
        ThrowUnassigned(10);
    }
    return (*m_Distance);
}

inline
bool CCdd_Base::IsSetParent(void) const
{
    return m_Parent.NotEmpty();
}

inline
bool CCdd_Base::CanGetParent(void) const
{
    return IsSetParent();
}

inline
const CCdd_Base::TParent& CCdd_Base::GetParent(void) const
{
    if (!CanGetParent()) {
        ThrowUnassigned(11);
    }
    return (*m_Parent);
}

inline
bool CCdd_Base::IsSetChildren(void) const
{
    return m_Children.NotEmpty();
}

inline
bool CCdd_Base::CanGetChildren(void) const
{
    return IsSetChildren();
}

inline
const CCdd_Base::TChildren& CCdd_Base::GetChildren(void) const
{
    if (!CanGetChildren()) {
        ThrowUnassigned(12);
    }
    return (*m_Children);
}

inline
bool CCdd_Base::IsSetSiblings(void) const
{
    return m_Siblings.NotEmpty();
}

inline
bool CCdd_Base::CanGetSiblings(void) const
{
    return IsSetSiblings();
}

inline
const CCdd_Base::TSiblings& CCdd_Base::GetSiblings(void) const
{
    if (!CanGetSiblings()) {
        ThrowUnassigned(13);
    }
    return (*m_Siblings);
}

inline
bool CCdd_Base::IsSetNeighbors(void) const
{
    return m_Neighbors.NotEmpty();
}

inline
bool CCdd_Base::CanGetNeighbors(void) const
{
    return IsSetNeighbors();
}

inline
const CCdd_Base::TNeighbors& CCdd_Base::GetNeighbors(void) const
{
    if (!CanGetNeighbors()) {
        ThrowUnassigned(14);
    }
    return (*m_Neighbors);
}

inline
bool CCdd_Base::IsSetPending(void) const
{
    return ((m_set_State[0] & 0xc0000000) != 0);
}

inline
bool CCdd_Base::CanGetPending(void) const
{
    return true;
}

inline
const CCdd_Base::TPending& CCdd_Base::GetPending(void) const
{
    return m_Pending;
}

inline
CCdd_Base::TPending& CCdd_Base::SetPending(void)
{
    m_set_State[0] |= 0x40000000;
    return m_Pending;
}

inline
bool CCdd_Base::IsSetRejects(void) const
{
    return ((m_set_State[1] & 0x3) != 0);
}

inline
bool CCdd_Base::CanGetRejects(void) const
{
    return true;
}

inline
const CCdd_Base::TRejects& CCdd_Base::GetRejects(void) const
{
    return m_Rejects;
}

inline
CCdd_Base::TRejects& CCdd_Base::SetRejects(void)
{
    m_set_State[1] |= 0x1;
    return m_Rejects;
}

inline
bool CCdd_Base::IsSetMaster3d(void) const
{
    return ((m_set_State[1] & 0xc) != 0);
}

inline
bool CCdd_Base::CanGetMaster3d(void) const
{
    return true;
}

inline
const CCdd_Base::TMaster3d& CCdd_Base::GetMaster3d(void) const
{
    return m_Master3d;
}

inline
CCdd_Base::TMaster3d& CCdd_Base::SetMaster3d(void)
{
    m_set_State[1] |= 0x4;
    return m_Master3d;
}

inline
bool CCdd_Base::IsSetAlignannot(void) const
{
    return m_Alignannot.NotEmpty();
}

inline
bool CCdd_Base::CanGetAlignannot(void) const
{
    return IsSetAlignannot();
}

inline
const CCdd_Base::TAlignannot& CCdd_Base::GetAlignannot(void) const
{
    if (!CanGetAlignannot()) {
        ThrowUnassigned(18);
    }
    return (*m_Alignannot);
}

inline
bool CCdd_Base::IsSetStyle_dictionary(void) const
{
    return m_Style_dictionary.NotEmpty();
}

inline
bool CCdd_Base::CanGetStyle_dictionary(void) const
{
    return IsSetStyle_dictionary();
}

inline
const CCdd_Base::TStyle_dictionary& CCdd_Base::GetStyle_dictionary(void) const
{
    if (!CanGetStyle_dictionary()) {
        ThrowUnassigned(19);
    }
    return (*m_Style_dictionary);
}

inline
bool CCdd_Base::IsSetUser_annotations(void) const
{
    return m_User_annotations.NotEmpty();
}

inline
bool CCdd_Base::CanGetUser_annotations(void) const
{
    return IsSetUser_annotations();
}

inline
const CCdd_Base::TUser_annotations& CCdd_Base::GetUser_annotations(void) const
{
    if (!CanGetUser_annotations()) {
        ThrowUnassigned(20);
    }
    return (*m_User_annotations);
}

inline
bool CCdd_Base::IsSetAncestors(void) const
{
    return ((m_set_State[1] & 0xc00) != 0);
}

inline
bool CCdd_Base::CanGetAncestors(void) const
{
    return true;
}

inline
const CCdd_Base::TAncestors& CCdd_Base::GetAncestors(void) const
{
    return m_Ancestors;
}

inline
CCdd_Base::TAncestors& CCdd_Base::SetAncestors(void)
{
    m_set_State[1] |= 0x400;
    return m_Ancestors;
}

inline
bool CCdd_Base::IsSetScoreparams(void) const
{
    return m_Scoreparams.NotEmpty();
}

inline
bool CCdd_Base::CanGetScoreparams(void) const
{
    return IsSetScoreparams();
}

inline
const CCdd_Base::TScoreparams& CCdd_Base::GetScoreparams(void) const
{
    if (!CanGetScoreparams()) {
        ThrowUnassigned(22);
    }
    return (*m_Scoreparams);
}

inline
bool CCdd_Base::IsSetSeqtree(void) const
{
    return m_Seqtree.NotEmpty();
}

inline
bool CCdd_Base::CanGetSeqtree(void) const
{
    return IsSetSeqtree();
}

inline
const CCdd_Base::TSeqtree& CCdd_Base::GetSeqtree(void) const
{
    if (!CanGetSeqtree()) {
        ThrowUnassigned(23);
    }
    return (*m_Seqtree);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_CDD_CDD_BASE_HPP
