/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Hit_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastxml2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTXML2_HIT_BASE_HPP
#define OBJECTS_BLASTXML2_HIT_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::

#ifndef BEGIN_blastxml2_SCOPE
#  define BEGIN_blastxml2_SCOPE BEGIN_SCOPE(blastxml2)
#  define END_blastxml2_SCOPE END_SCOPE(blastxml2)
#endif
BEGIN_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::


// forward declarations
class CHitDescr;
class CHsp;


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BLASTXML2_EXPORT CHit_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHit_Base(void);
    // destructor
    virtual ~CHit_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TNum;
    typedef list< CRef< CHitDescr > > TDescription;
    typedef int TLen;
    typedef list< CRef< CHsp > > THsps;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_num,
        e_description,
        e_len,
        e_hsps
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// hit number
    /// mandatory
    /// typedef int TNum
    ///  Check whether the Num data member has been assigned a value.
    bool IsSetNum(void) const;
    /// Check whether it is safe or not to call GetNum method.
    bool CanGetNum(void) const;
    void ResetNum(void);
    TNum GetNum(void) const;
    void SetNum(TNum value);
    TNum& SetNum(void);

    /// ID, title, and taxonomy for each entry in the PIG
    /// mandatory
    /// typedef list< CRef< CHitDescr > > TDescription
    ///  Check whether the Description data member has been assigned a value.
    bool IsSetDescription(void) const;
    /// Check whether it is safe or not to call GetDescription method.
    bool CanGetDescription(void) const;
    void ResetDescription(void);
    const TDescription& GetDescription(void) const;
    TDescription& SetDescription(void);

    /// length of subject
    /// mandatory
    /// typedef int TLen
    ///  Check whether the Len data member has been assigned a value.
    bool IsSetLen(void) const;
    /// Check whether it is safe or not to call GetLen method.
    bool CanGetLen(void) const;
    void ResetLen(void);
    TLen GetLen(void) const;
    void SetLen(TLen value);
    TLen& SetLen(void);

    /// all HSP regions for the given subject
    /// optional
    /// typedef list< CRef< CHsp > > THsps
    ///  Check whether the Hsps data member has been assigned a value.
    bool IsSetHsps(void) const;
    /// Check whether it is safe or not to call GetHsps method.
    bool CanGetHsps(void) const;
    void ResetHsps(void);
    const THsps& GetHsps(void) const;
    THsps& SetHsps(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHit_Base(const CHit_Base&);
    CHit_Base& operator=(const CHit_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Num;
    list< CRef< CHitDescr > > m_Description;
    int m_Len;
    list< CRef< CHsp > > m_Hsps;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHit_Base::IsSetNum(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CHit_Base::CanGetNum(void) const
{
    return IsSetNum();
}

inline
void CHit_Base::ResetNum(void)
{
    m_Num = 0;
    m_set_State[0] &= ~0x3;
}

inline
CHit_Base::TNum CHit_Base::GetNum(void) const
{
    if (!CanGetNum()) {
        ThrowUnassigned(0);
    }
    return m_Num;
}

inline
void CHit_Base::SetNum(CHit_Base::TNum value)
{
    m_Num = value;
    m_set_State[0] |= 0x3;
}

inline
CHit_Base::TNum& CHit_Base::SetNum(void)
{
#ifdef _DEBUG
    if (!IsSetNum()) {
        memset(&m_Num,UnassignedByte(),sizeof(m_Num));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Num;
}

inline
bool CHit_Base::IsSetDescription(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CHit_Base::CanGetDescription(void) const
{
    return true;
}

inline
const CHit_Base::TDescription& CHit_Base::GetDescription(void) const
{
    return m_Description;
}

inline
CHit_Base::TDescription& CHit_Base::SetDescription(void)
{
    m_set_State[0] |= 0x4;
    return m_Description;
}

inline
bool CHit_Base::IsSetLen(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CHit_Base::CanGetLen(void) const
{
    return IsSetLen();
}

inline
void CHit_Base::ResetLen(void)
{
    m_Len = 0;
    m_set_State[0] &= ~0x30;
}

inline
CHit_Base::TLen CHit_Base::GetLen(void) const
{
    if (!CanGetLen()) {
        ThrowUnassigned(2);
    }
    return m_Len;
}

inline
void CHit_Base::SetLen(CHit_Base::TLen value)
{
    m_Len = value;
    m_set_State[0] |= 0x30;
}

inline
CHit_Base::TLen& CHit_Base::SetLen(void)
{
#ifdef _DEBUG
    if (!IsSetLen()) {
        memset(&m_Len,UnassignedByte(),sizeof(m_Len));
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Len;
}

inline
bool CHit_Base::IsSetHsps(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CHit_Base::CanGetHsps(void) const
{
    return true;
}

inline
const CHit_Base::THsps& CHit_Base::GetHsps(void) const
{
    return m_Hsps;
}

inline
CHit_Base::THsps& CHit_Base::SetHsps(void)
{
    m_set_State[0] |= 0x40;
    return m_Hsps;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTXML2_HIT_BASE_HPP
