/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file HitDescr_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastxml2.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTXML2_HITDESCR_BASE_HPP
#define OBJECTS_BLASTXML2_HITDESCR_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::

#ifndef BEGIN_blastxml2_SCOPE
#  define BEGIN_blastxml2_SCOPE BEGIN_SCOPE(blastxml2)
#  define END_blastxml2_SCOPE END_SCOPE(blastxml2)
#endif
BEGIN_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Description of entries for this (possibly non-redundant) sequence.
class NCBI_BLASTXML2_EXPORT CHitDescr_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CHitDescr_Base(void);
    // destructor
    virtual ~CHitDescr_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef string TId;
    typedef string TAccession;
    typedef string TTitle;
    typedef NCBI_NS_NCBI::TTaxId TTaxid;
    typedef string TSciname;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_id,
        e_accession,
        e_title,
        e_taxid,
        e_sciname
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 6> TmemberIndex;

    // getters
    // setters

    /// SeqId of subject
    /// mandatory
    /// typedef string TId
    ///  Check whether the Id data member has been assigned a value.
    bool IsSetId(void) const;
    /// Check whether it is safe or not to call GetId method.
    bool CanGetId(void) const;
    void ResetId(void);
    const TId& GetId(void) const;
    void SetId(const TId& value);
    void SetId(TId&& value);
    TId& SetId(void);

    /// accession
    /// optional
    /// typedef string TAccession
    ///  Check whether the Accession data member has been assigned a value.
    bool IsSetAccession(void) const;
    /// Check whether it is safe or not to call GetAccession method.
    bool CanGetAccession(void) const;
    void ResetAccession(void);
    const TAccession& GetAccession(void) const;
    void SetAccession(const TAccession& value);
    void SetAccession(TAccession&& value);
    TAccession& SetAccession(void);

    /// title (definition line) of subject
    /// optional
    /// typedef string TTitle
    ///  Check whether the Title data member has been assigned a value.
    bool IsSetTitle(void) const;
    /// Check whether it is safe or not to call GetTitle method.
    bool CanGetTitle(void) const;
    void ResetTitle(void);
    const TTitle& GetTitle(void) const;
    void SetTitle(const TTitle& value);
    void SetTitle(TTitle&& value);
    TTitle& SetTitle(void);

    /// NCBI taxid (9606 for human)
    /// optional
    /// typedef NCBI_NS_NCBI::TTaxId TTaxid
    ///  Check whether the Taxid data member has been assigned a value.
    bool IsSetTaxid(void) const;
    /// Check whether it is safe or not to call GetTaxid method.
    bool CanGetTaxid(void) const;
    void ResetTaxid(void);
    TTaxid GetTaxid(void) const;
    void SetTaxid(TTaxid value);
    TTaxid& SetTaxid(void);

    /// binomial scientific name ("Homo sapiens" for human).  
    /// optional
    /// typedef string TSciname
    ///  Check whether the Sciname data member has been assigned a value.
    bool IsSetSciname(void) const;
    /// Check whether it is safe or not to call GetSciname method.
    bool CanGetSciname(void) const;
    void ResetSciname(void);
    const TSciname& GetSciname(void) const;
    void SetSciname(const TSciname& value);
    void SetSciname(TSciname&& value);
    TSciname& SetSciname(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CHitDescr_Base(const CHitDescr_Base&);
    CHitDescr_Base& operator=(const CHitDescr_Base&);

    // data
    Uint4 m_set_State[1];
    string m_Id;
    string m_Accession;
    string m_Title;
    int m_Taxid;
    string m_Sciname;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CHitDescr_Base::IsSetId(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CHitDescr_Base::CanGetId(void) const
{
    return IsSetId();
}

inline
const CHitDescr_Base::TId& CHitDescr_Base::GetId(void) const
{
    if (!CanGetId()) {
        ThrowUnassigned(0);
    }
    return m_Id;
}

inline
void CHitDescr_Base::SetId(const CHitDescr_Base::TId& value)
{
    m_Id = value;
    m_set_State[0] |= 0x3;
}

inline
void CHitDescr_Base::SetId(CHitDescr_Base::TId&& value)
{
    m_Id = std::forward<CHitDescr_Base::TId>(value);
    m_set_State[0] |= 0x3;
}

inline
CHitDescr_Base::TId& CHitDescr_Base::SetId(void)
{
#ifdef _DEBUG
    if (!IsSetId()) {
        m_Id = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Id;
}

inline
bool CHitDescr_Base::IsSetAccession(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CHitDescr_Base::CanGetAccession(void) const
{
    return IsSetAccession();
}

inline
const CHitDescr_Base::TAccession& CHitDescr_Base::GetAccession(void) const
{
    if (!CanGetAccession()) {
        ThrowUnassigned(1);
    }
    return m_Accession;
}

inline
void CHitDescr_Base::SetAccession(const CHitDescr_Base::TAccession& value)
{
    m_Accession = value;
    m_set_State[0] |= 0xc;
}

inline
void CHitDescr_Base::SetAccession(CHitDescr_Base::TAccession&& value)
{
    m_Accession = std::forward<CHitDescr_Base::TAccession>(value);
    m_set_State[0] |= 0xc;
}

inline
CHitDescr_Base::TAccession& CHitDescr_Base::SetAccession(void)
{
#ifdef _DEBUG
    if (!IsSetAccession()) {
        m_Accession = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Accession;
}

inline
bool CHitDescr_Base::IsSetTitle(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CHitDescr_Base::CanGetTitle(void) const
{
    return IsSetTitle();
}

inline
const CHitDescr_Base::TTitle& CHitDescr_Base::GetTitle(void) const
{
    if (!CanGetTitle()) {
        ThrowUnassigned(2);
    }
    return m_Title;
}

inline
void CHitDescr_Base::SetTitle(const CHitDescr_Base::TTitle& value)
{
    m_Title = value;
    m_set_State[0] |= 0x30;
}

inline
void CHitDescr_Base::SetTitle(CHitDescr_Base::TTitle&& value)
{
    m_Title = std::forward<CHitDescr_Base::TTitle>(value);
    m_set_State[0] |= 0x30;
}

inline
CHitDescr_Base::TTitle& CHitDescr_Base::SetTitle(void)
{
#ifdef _DEBUG
    if (!IsSetTitle()) {
        m_Title = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Title;
}

inline
bool CHitDescr_Base::IsSetTaxid(void) const
{
    return ((m_set_State[0] & 0xc0) != 0);
}

inline
bool CHitDescr_Base::CanGetTaxid(void) const
{
    return IsSetTaxid();
}

inline
void CHitDescr_Base::ResetTaxid(void)
{
    m_Taxid = 0;
    m_set_State[0] &= ~0xc0;
}

inline
CHitDescr_Base::TTaxid CHitDescr_Base::GetTaxid(void) const
{
    if (!CanGetTaxid()) {
        ThrowUnassigned(3);
    }
    return reinterpret_cast<const TTaxid&>(m_Taxid);
}

inline
void CHitDescr_Base::SetTaxid(CHitDescr_Base::TTaxid value)
{
    reinterpret_cast<TTaxid&>(m_Taxid) = value;
    m_set_State[0] |= 0xc0;
}

inline
CHitDescr_Base::TTaxid& CHitDescr_Base::SetTaxid(void)
{
#ifdef _DEBUG
    if (!IsSetTaxid()) {
        memset(&m_Taxid,UnassignedByte(),sizeof(m_Taxid));
    }
#endif
    m_set_State[0] |= 0x40;
    return reinterpret_cast<TTaxid&>(m_Taxid);
}

inline
bool CHitDescr_Base::IsSetSciname(void) const
{
    return ((m_set_State[0] & 0x300) != 0);
}

inline
bool CHitDescr_Base::CanGetSciname(void) const
{
    return IsSetSciname();
}

inline
const CHitDescr_Base::TSciname& CHitDescr_Base::GetSciname(void) const
{
    if (!CanGetSciname()) {
        ThrowUnassigned(4);
    }
    return m_Sciname;
}

inline
void CHitDescr_Base::SetSciname(const CHitDescr_Base::TSciname& value)
{
    m_Sciname = value;
    m_set_State[0] |= 0x300;
}

inline
void CHitDescr_Base::SetSciname(CHitDescr_Base::TSciname&& value)
{
    m_Sciname = std::forward<CHitDescr_Base::TSciname>(value);
    m_set_State[0] |= 0x300;
}

inline
CHitDescr_Base::TSciname& CHitDescr_Base::SetSciname(void)
{
#ifdef _DEBUG
    if (!IsSetSciname()) {
        m_Sciname = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x100;
    return m_Sciname;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_blastxml2_SCOPE // namespace ncbi::objects::blastxml2::

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTXML2_HITDESCR_BASE_HPP
