/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast_db_mask_info_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blastdb.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLASTDB_BLAST_DB_MASK_INFO_BASE_HPP
#define OBJECTS_BLASTDB_BLAST_DB_MASK_INFO_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <objects/blastdb/Blast_filter_program.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CBlast_mask_list;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Defines the masking information for a set of sequences
class NCBI_BLASTDB_EXPORT CBlast_db_mask_info_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast_db_mask_info_Base(void);
    // destructor
    virtual ~CBlast_db_mask_info_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef int TAlgo_id;
    typedef int TAlgo_program;
    typedef string TAlgo_options;
    typedef CBlast_mask_list TMasks;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_algo_id,
        e_algo_program,
        e_algo_options,
        e_masks
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 5> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef int TAlgo_id
    ///  Check whether the Algo_id data member has been assigned a value.
    bool IsSetAlgo_id(void) const;
    /// Check whether it is safe or not to call GetAlgo_id method.
    bool CanGetAlgo_id(void) const;
    void ResetAlgo_id(void);
    TAlgo_id GetAlgo_id(void) const;
    void SetAlgo_id(TAlgo_id value);
    TAlgo_id& SetAlgo_id(void);

    /// mandatory
    /// typedef int TAlgo_program
    ///  Check whether the Algo_program data member has been assigned a value.
    bool IsSetAlgo_program(void) const;
    /// Check whether it is safe or not to call GetAlgo_program method.
    bool CanGetAlgo_program(void) const;
    void ResetAlgo_program(void);
    TAlgo_program GetAlgo_program(void) const;
    void SetAlgo_program(TAlgo_program value);
    TAlgo_program& SetAlgo_program(void);

    /// mandatory
    /// typedef string TAlgo_options
    ///  Check whether the Algo_options data member has been assigned a value.
    bool IsSetAlgo_options(void) const;
    /// Check whether it is safe or not to call GetAlgo_options method.
    bool CanGetAlgo_options(void) const;
    void ResetAlgo_options(void);
    const TAlgo_options& GetAlgo_options(void) const;
    void SetAlgo_options(const TAlgo_options& value);
    void SetAlgo_options(TAlgo_options&& value);
    TAlgo_options& SetAlgo_options(void);

    /// This object was originally created to allow pagination of the sequence
    /// masks, but this feature was discontinued in 01/21/2010
    /// mandatory
    /// typedef CBlast_mask_list TMasks
    ///  Check whether the Masks data member has been assigned a value.
    bool IsSetMasks(void) const;
    /// Check whether it is safe or not to call GetMasks method.
    bool CanGetMasks(void) const;
    void ResetMasks(void);
    const TMasks& GetMasks(void) const;
    void SetMasks(TMasks& value);
    TMasks& SetMasks(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast_db_mask_info_Base(const CBlast_db_mask_info_Base&);
    CBlast_db_mask_info_Base& operator=(const CBlast_db_mask_info_Base&);

    // data
    Uint4 m_set_State[1];
    int m_Algo_id;
    int m_Algo_program;
    string m_Algo_options;
    CRef< TMasks > m_Masks;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast_db_mask_info_Base::IsSetAlgo_id(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast_db_mask_info_Base::CanGetAlgo_id(void) const
{
    return IsSetAlgo_id();
}

inline
void CBlast_db_mask_info_Base::ResetAlgo_id(void)
{
    m_Algo_id = 0;
    m_set_State[0] &= ~0x3;
}

inline
CBlast_db_mask_info_Base::TAlgo_id CBlast_db_mask_info_Base::GetAlgo_id(void) const
{
    if (!CanGetAlgo_id()) {
        ThrowUnassigned(0);
    }
    return m_Algo_id;
}

inline
void CBlast_db_mask_info_Base::SetAlgo_id(CBlast_db_mask_info_Base::TAlgo_id value)
{
    m_Algo_id = value;
    m_set_State[0] |= 0x3;
}

inline
CBlast_db_mask_info_Base::TAlgo_id& CBlast_db_mask_info_Base::SetAlgo_id(void)
{
#ifdef _DEBUG
    if (!IsSetAlgo_id()) {
        memset(&m_Algo_id,UnassignedByte(),sizeof(m_Algo_id));
    }
#endif
    m_set_State[0] |= 0x1;
    return m_Algo_id;
}

inline
bool CBlast_db_mask_info_Base::IsSetAlgo_program(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast_db_mask_info_Base::CanGetAlgo_program(void) const
{
    return IsSetAlgo_program();
}

inline
void CBlast_db_mask_info_Base::ResetAlgo_program(void)
{
    m_Algo_program = (int)(0);
    m_set_State[0] &= ~0xc;
}

inline
CBlast_db_mask_info_Base::TAlgo_program CBlast_db_mask_info_Base::GetAlgo_program(void) const
{
    if (!CanGetAlgo_program()) {
        ThrowUnassigned(1);
    }
    return m_Algo_program;
}

inline
void CBlast_db_mask_info_Base::SetAlgo_program(CBlast_db_mask_info_Base::TAlgo_program value)
{
    m_Algo_program = value;
    m_set_State[0] |= 0xc;
}

inline
CBlast_db_mask_info_Base::TAlgo_program& CBlast_db_mask_info_Base::SetAlgo_program(void)
{
#ifdef _DEBUG
    if (!IsSetAlgo_program()) {
        memset(&m_Algo_program,UnassignedByte(),sizeof(m_Algo_program));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Algo_program;
}

inline
bool CBlast_db_mask_info_Base::IsSetAlgo_options(void) const
{
    return ((m_set_State[0] & 0x30) != 0);
}

inline
bool CBlast_db_mask_info_Base::CanGetAlgo_options(void) const
{
    return IsSetAlgo_options();
}

inline
const CBlast_db_mask_info_Base::TAlgo_options& CBlast_db_mask_info_Base::GetAlgo_options(void) const
{
    if (!CanGetAlgo_options()) {
        ThrowUnassigned(2);
    }
    return m_Algo_options;
}

inline
void CBlast_db_mask_info_Base::SetAlgo_options(const CBlast_db_mask_info_Base::TAlgo_options& value)
{
    m_Algo_options = value;
    m_set_State[0] |= 0x30;
}

inline
void CBlast_db_mask_info_Base::SetAlgo_options(CBlast_db_mask_info_Base::TAlgo_options&& value)
{
    m_Algo_options = std::forward<CBlast_db_mask_info_Base::TAlgo_options>(value);
    m_set_State[0] |= 0x30;
}

inline
CBlast_db_mask_info_Base::TAlgo_options& CBlast_db_mask_info_Base::SetAlgo_options(void)
{
#ifdef _DEBUG
    if (!IsSetAlgo_options()) {
        m_Algo_options = UnassignedString();
    }
#endif
    m_set_State[0] |= 0x10;
    return m_Algo_options;
}

inline
bool CBlast_db_mask_info_Base::IsSetMasks(void) const
{
    return m_Masks.NotEmpty();
}

inline
bool CBlast_db_mask_info_Base::CanGetMasks(void) const
{
    return true;
}

inline
const CBlast_db_mask_info_Base::TMasks& CBlast_db_mask_info_Base::GetMasks(void) const
{
    if ( !m_Masks ) {
        const_cast<CBlast_db_mask_info_Base*>(this)->ResetMasks();
    }
    return (*m_Masks);
}

inline
CBlast_db_mask_info_Base::TMasks& CBlast_db_mask_info_Base::SetMasks(void)
{
    if ( !m_Masks ) {
        ResetMasks();
    }
    return (*m_Masks);
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLASTDB_BLAST_DB_MASK_INFO_BASE_HPP
