/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Blast4_mask_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'blast.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BLAST_BLAST4_MASK_BASE_HPP
#define OBJECTS_BLAST_BLAST4_MASK_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <list>
#include <objects/blast/Blast4_frame_type.hpp>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// forward declarations
class CSeq_loc;


// generated classes

/////////////////////////////////////////////////////////////////////////////
/// Masking locations for a query's frame. The locations field is a single
/// Seq-loc of type Packed-int, which contains all the masking locations for the
/// translation frame specified by the frame field.
/// Notes:
/// On input (i.e.: when the client specifies masking locations as a
/// Blast4-parameter), in the case of protein queries, the frame field must 
/// always be notset, in the case of nucleotide queries (regardless of whether 
/// the search will translate these or not), the frame must be plus1. Masking 
/// locations in the translated encoding are not permitted.
/// On output (i.e.: when blast 4 server encodes these as part of the 
/// Blast4-get-search-results-reply), the same conventions as above apply for
/// non-translated protein and nucleotide queries, but in the case of translated
/// nucleotide queries, the frame field can be specified in any of the
/// translation frames as appropriate.
class NCBI_BLAST_EXPORT CBlast4_mask_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CBlast4_mask_Base(void);
    // destructor
    virtual ~CBlast4_mask_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef list< CRef< CSeq_loc > > TLocations;
    typedef EBlast4_frame_type TFrame;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_locations,
        e_frame
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// mandatory
    /// typedef list< CRef< CSeq_loc > > TLocations
    ///  Check whether the Locations data member has been assigned a value.
    bool IsSetLocations(void) const;
    /// Check whether it is safe or not to call GetLocations method.
    bool CanGetLocations(void) const;
    void ResetLocations(void);
    const TLocations& GetLocations(void) const;
    TLocations& SetLocations(void);

    /// mandatory
    /// typedef EBlast4_frame_type TFrame
    ///  Check whether the Frame data member has been assigned a value.
    bool IsSetFrame(void) const;
    /// Check whether it is safe or not to call GetFrame method.
    bool CanGetFrame(void) const;
    void ResetFrame(void);
    TFrame GetFrame(void) const;
    void SetFrame(TFrame value);
    TFrame& SetFrame(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CBlast4_mask_Base(const CBlast4_mask_Base&);
    CBlast4_mask_Base& operator=(const CBlast4_mask_Base&);

    // data
    Uint4 m_set_State[1];
    list< CRef< CSeq_loc > > m_Locations;
    EBlast4_frame_type m_Frame;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CBlast4_mask_Base::IsSetLocations(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CBlast4_mask_Base::CanGetLocations(void) const
{
    return true;
}

inline
const CBlast4_mask_Base::TLocations& CBlast4_mask_Base::GetLocations(void) const
{
    return m_Locations;
}

inline
CBlast4_mask_Base::TLocations& CBlast4_mask_Base::SetLocations(void)
{
    m_set_State[0] |= 0x1;
    return m_Locations;
}

inline
bool CBlast4_mask_Base::IsSetFrame(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CBlast4_mask_Base::CanGetFrame(void) const
{
    return IsSetFrame();
}

inline
void CBlast4_mask_Base::ResetFrame(void)
{
    m_Frame = (ncbi::objects::EBlast4_frame_type)(0);
    m_set_State[0] &= ~0xc;
}

inline
CBlast4_mask_Base::TFrame CBlast4_mask_Base::GetFrame(void) const
{
    if (!CanGetFrame()) {
        ThrowUnassigned(1);
    }
    return m_Frame;
}

inline
void CBlast4_mask_Base::SetFrame(CBlast4_mask_Base::TFrame value)
{
    m_Frame = value;
    m_set_State[0] |= 0xc;
}

inline
CBlast4_mask_Base::TFrame& CBlast4_mask_Base::SetFrame(void)
{
#ifdef _DEBUG
    if (!IsSetFrame()) {
        memset(&m_Frame,UnassignedByte(),sizeof(m_Frame));
    }
#endif
    m_set_State[0] |= 0x4;
    return m_Frame;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BLAST_BLAST4_MASK_BASE_HPP
