/* $Id$
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file DistanceMatrix_.hpp
/// Data storage class.
///
/// This file was generated by application DATATOOL
/// using the following specifications:
/// 'biotree.asn'.
///
/// ATTENTION:
///   Don't edit or commit this file into CVS as this file will
///   be overridden (by DATATOOL) without warning!

#ifndef OBJECTS_BIOTREE_DISTANCEMATRIX_BASE_HPP
#define OBJECTS_BIOTREE_DISTANCEMATRIX_BASE_HPP

// standard includes
#include <serial/serialbase.hpp>

// generated includes
#include <string>
#include <vector>

BEGIN_NCBI_SCOPE

#ifndef BEGIN_objects_SCOPE
#  define BEGIN_objects_SCOPE BEGIN_SCOPE(objects)
#  define END_objects_SCOPE END_SCOPE(objects)
#endif
BEGIN_objects_SCOPE // namespace ncbi::objects::


// generated classes

/////////////////////////////////////////////////////////////////////////////
class NCBI_BIOTREE_EXPORT CDistanceMatrix_Base : public CSerialObject
{
    typedef CSerialObject Tparent;
public:
    // constructor
    CDistanceMatrix_Base(void);
    // destructor
    virtual ~CDistanceMatrix_Base(void);

    // type info
    DECLARE_INTERNAL_TYPE_INFO();

    // types
    typedef vector< string > TLabels;
    typedef vector< double > TDistances;

    // member index
    enum class E_memberIndex {
        e__allMandatory = 0,
        e_labels,
        e_distances
    };
    typedef Tparent::CMemberIndex<E_memberIndex, 3> TmemberIndex;

    // getters
    // setters

    /// n labels
    /// mandatory
    /// typedef vector< string > TLabels
    ///  Check whether the Labels data member has been assigned a value.
    bool IsSetLabels(void) const;
    /// Check whether it is safe or not to call GetLabels method.
    bool CanGetLabels(void) const;
    void ResetLabels(void);
    const TLabels& GetLabels(void) const;
    TLabels& SetLabels(void);

    /// n(n-1)/2 pairwise distances
    /// (0, 1)...(0, n), (1, 2)...(1, n)...
    /// mandatory
    /// typedef vector< double > TDistances
    ///  Check whether the Distances data member has been assigned a value.
    bool IsSetDistances(void) const;
    /// Check whether it is safe or not to call GetDistances method.
    bool CanGetDistances(void) const;
    void ResetDistances(void);
    const TDistances& GetDistances(void) const;
    TDistances& SetDistances(void);

    /// Reset the whole object
    virtual void Reset(void);


private:
    // Prohibit copy constructor and assignment operator
    CDistanceMatrix_Base(const CDistanceMatrix_Base&);
    CDistanceMatrix_Base& operator=(const CDistanceMatrix_Base&);

    // data
    Uint4 m_set_State[1];
    vector< string > m_Labels;
    vector< double > m_Distances;
};






///////////////////////////////////////////////////////////
///////////////////// inline methods //////////////////////
///////////////////////////////////////////////////////////
inline
bool CDistanceMatrix_Base::IsSetLabels(void) const
{
    return ((m_set_State[0] & 0x3) != 0);
}

inline
bool CDistanceMatrix_Base::CanGetLabels(void) const
{
    return true;
}

inline
const CDistanceMatrix_Base::TLabels& CDistanceMatrix_Base::GetLabels(void) const
{
    return m_Labels;
}

inline
CDistanceMatrix_Base::TLabels& CDistanceMatrix_Base::SetLabels(void)
{
    m_set_State[0] |= 0x1;
    return m_Labels;
}

inline
bool CDistanceMatrix_Base::IsSetDistances(void) const
{
    return ((m_set_State[0] & 0xc) != 0);
}

inline
bool CDistanceMatrix_Base::CanGetDistances(void) const
{
    return true;
}

inline
const CDistanceMatrix_Base::TDistances& CDistanceMatrix_Base::GetDistances(void) const
{
    return m_Distances;
}

inline
CDistanceMatrix_Base::TDistances& CDistanceMatrix_Base::SetDistances(void)
{
    m_set_State[0] |= 0x4;
    return m_Distances;
}

///////////////////////////////////////////////////////////
////////////////// end of inline methods //////////////////
///////////////////////////////////////////////////////////





END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_BIOTREE_DISTANCEMATRIX_BASE_HPP
