define("tool_componentlibrary/search",["exports","tool_componentlibrary/lunr","tool_componentlibrary/selectors","core/log","core/notification","core/key_codes"],(function(_exports,_lunr,_selectors,_log,_notification,_key_codes){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Interface to the Lunr search engines.
   *
   * @module     tool_componentlibrary/search
   * @copyright  2021 Bas Brands <bas@moodle.com>
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.search=void 0,_lunr=_interopRequireDefault(_lunr),_selectors=_interopRequireDefault(_selectors),_log=_interopRequireDefault(_log),_notification=_interopRequireDefault(_notification);let lunrIndex=null,pagesIndex=null;const initLunr=jsonFile=>{(async jsonFile=>{const response=await fetch(jsonFile);return response.ok||_log.default.debug("Error getting Hugo index file: ".concat(response.status)),await response.json()})(jsonFile).then((jsondata=>(pagesIndex=jsondata,lunrIndex=(0,_lunr.default)((function(){this.ref("uri"),this.field("title",{boost:10}),this.field("content"),this.field("tags",{boost:5}),jsondata.forEach((p=>{this.add(p)}))})),null))).catch(_notification.default.exception)},searchIndex=query=>lunrIndex.search(query+" "+query+"*").map((result=>pagesIndex.filter((page=>page.uri===result.ref))[0])),renderResults=results=>{const dropdownMenu=document.querySelector(_selectors.default.dropdownmenu);if(!results.length)return void dropdownMenu.classList.remove("show");dropdownMenu.innerHTML="";const baseUrl=M.cfg.wwwroot+"/admin/tool/componentlibrary/docspage.php";results.slice(0,10).forEach((function(result){const link=document.createElement("a"),chapter=result.uri.split("/")[1];link.appendChild(document.createTextNode("".concat(chapter," > ").concat(result.title))),link.classList.add("dropdown-item"),link.href=baseUrl+result.uri,dropdownMenu.appendChild(link)})),dropdownMenu.classList.add("show")};_exports.search=jsonFile=>{initLunr(jsonFile),(()=>{const searchInput=document.querySelector(_selectors.default.searchinput);searchInput.addEventListener("keyup",(e=>{const query=e.currentTarget.value;query.length<2?document.querySelector(_selectors.default.dropdownmenu).classList.remove("show"):renderResults(searchIndex(query))})),searchInput.addEventListener("keydown",(e=>{e.keyCode===_key_codes.enter&&e.preventDefault(),e.keyCode===_key_codes.escape&&(searchInput.value="")}))})()}}));

//# sourceMappingURL=search.min.js.map