/* gee-0.8.vapi generated by valac 0.56.3, do not modify. */

[CCode (gir_namespace = "Gee", gir_version = "0.8")]
namespace Gee {
	/**
	 * Helpers for equal, hash and compare functions.
	 *
	 * With those functions, you can retrieve the equal, hash and compare
	 * functions that best match your element, key or value types. Supported
	 * types are (non-boxed) primitive, string and ``Object`` types.
	 *
	 * A special care is taken for classes inheriting from the
	 * {@link Comparable} interface. For such types, an appropriate compare
	 * function is returned that calls {@link Comparable.compare_to}.
	 *
	 */
	namespace Functions {
		/**
		 * Get a comparator function for a given type.
		 *
		 * @param t the type which to get a comparator function for.
		 *
		 * @return the comparator function corresponding to the given type.
		 */
		[CCode (cheader_filename = "gee.h")]
		public static GLib.CompareDataFunc<void*> get_compare_func_for (GLib.Type t);
		/**
		 * Get a equality testing function for a given type.
		 *
		 * @param t the type which to get an equality testing function for.
		 *
		 * @return the equality testing function corresponding to the given type.
		 */
		[CCode (cheader_filename = "gee.h")]
		public static Gee.EqualDataFunc<void*> get_equal_func_for (GLib.Type t);
		/**
		 * Get a hash function for a given type.
		 *
		 * @param t the type which to get the hash function for.
		 *
		 * @return the hash function corresponding to the given type.
		 */
		[CCode (cheader_filename = "gee.h")]
		public static Gee.HashDataFunc<void*> get_hash_func_for (GLib.Type t);
	}
	[CCode (cheader_filename = "gee.h")]
	public abstract class AbstractBidirList<G> : Gee.AbstractList<G>, Gee.BidirList<G> {
		protected AbstractBidirList ();
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.BidirListIterator<G> bidir_list_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public new virtual Gee.BidirList<G> read_only_view { owned get; }
	}
	/**
	 * Skeletal implementation of the {@link BidirSortedSet} interface.
	 *
	 * Contains common code shared by all set implementations.
	 *
	 * @see TreeSet
	 */
	[CCode (cheader_filename = "gee.h")]
	public abstract class AbstractBidirSortedMap<K,V> : Gee.AbstractSortedMap<K,V>, Gee.BidirSortedMap<K,V> {
		protected AbstractBidirSortedMap ();
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.BidirMapIterator<K,V> bidir_map_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public new virtual Gee.BidirSortedMap<K,V> read_only_view { owned get; }
	}
	/**
	 * Skeletal implementation of the {@link BidirSortedSet} interface.
	 *
	 * Contains common code shared by all set implementations.
	 *
	 * @see TreeSet
	 */
	[CCode (cheader_filename = "gee.h")]
	public abstract class AbstractBidirSortedSet<G> : Gee.AbstractSortedSet<G>, Gee.BidirSortedSet<G> {
		protected AbstractBidirSortedSet ();
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.BidirIterator<G> bidir_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public new virtual Gee.BidirSortedSet<G> read_only_view { owned get; }
	}
	/**
	 * Skeletal implementation of the {@link Collection} interface.
	 *
	 * Contains common code shared by all collection implementations.
	 *
	 * @see AbstractList
	 * @see AbstractSet
	 * @see AbstractMultiSet
	 */
	[CCode (cheader_filename = "gee.h")]
	public abstract class AbstractCollection<G> : GLib.Object, Gee.Traversable<G>, Gee.Iterable<G>, Gee.Collection<G> {
		protected AbstractCollection ();
		/**
		 * {@inheritDoc}
		 */
		public abstract bool add (G item);
		/**
		 * {@inheritDoc}
		 */
		public abstract void clear ();
		/**
		 * {@inheritDoc}
		 */
		public abstract bool contains (G item);
		public virtual bool @foreach (Gee.ForallFunc<G> f);
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.Iterator<G> iterator ();
		/**
		 * {@inheritDoc}
		 */
		public abstract bool remove (G item);
		/**
		 * {@inheritDoc}
		 */
		public abstract bool read_only { get; }
		/**
		 * {@inheritDoc}
		 */
		public virtual Gee.Collection<G> read_only_view { owned get; }
		/**
		 * {@inheritDoc}
		 */
		public abstract int size { get; }
	}
	/**
	 * Skeletal implementation of the {@link List} interface.
	 *
	 * Contains common code shared by all list implementations.
	 *
	 * @see ArrayList
	 * @see LinkedList
	 */
	[CCode (cheader_filename = "gee.h")]
	public abstract class AbstractList<G> : Gee.AbstractCollection<G>, Gee.List<G> {
		protected AbstractList ();
		/**
		 * {@inheritDoc}
		 */
		public new abstract G @get (int index);
		/**
		 * {@inheritDoc}
		 */
		public abstract int index_of (G item);
		/**
		 * {@inheritDoc}
		 */
		public abstract void insert (int index, G item);
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.ListIterator<G> list_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public abstract G remove_at (int index);
		/**
		 * {@inheritDoc}
		 */
		public new abstract void @set (int index, G item);
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.List<G>? slice (int start, int stop);
		/**
		 * {@inheritDoc}
		 */
		public new virtual Gee.List<G> read_only_view { owned get; }
	}
	/**
	 * Skeletal implementation of the {@link Map} interface.
	 *
	 * Contains common code shared by all map implementations.
	 *
	 * @see HashMap
	 * @see TreeMap
	 */
	[CCode (cheader_filename = "gee.h")]
	public abstract class AbstractMap<K,V> : GLib.Object, Gee.Traversable<Gee.Map.Entry<K,V>>, Gee.Iterable<Gee.Map.Entry<K,V>>, Gee.Map<K,V> {
		protected AbstractMap ();
		/**
		 * {@inheritDoc}
		 */
		public abstract void clear ();
		/**
		 * {@inheritDoc}
		 */
		public virtual bool @foreach (Gee.ForallFunc<Gee.Map.Entry<K,V>> f);
		/**
		 * {@inheritDoc}
		 */
		public new abstract V @get (K key);
		/**
		 * {@inheritDoc}
		 */
		public abstract bool has (K key, V value);
		/**
		 * {@inheritDoc}
		 */
		public abstract bool has_key (K key);
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.MapIterator<K,V> map_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public new abstract void @set (K key, V value);
		/**
		 * {@inheritDoc}
		 */
		public virtual Gee.Iterator<A> stream<A> (owned Gee.StreamFunc<Gee.Map.Entry<K,V>,A> f);
		/**
		 * {@inheritDoc}
		 */
		public abstract bool unset (K key, out V value = null);
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.Set<Gee.Map.Entry<K,V>> entries { owned get; }
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.Set<K> keys { owned get; }
		/**
		 * {@inheritDoc}
		 */
		public abstract bool read_only { get; }
		/**
		 * {@inheritDoc}
		 */
		public virtual Gee.Map<K,V> read_only_view { owned get; }
		/**
		 * {@inheritDoc}
		 */
		public abstract int size { get; }
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.Collection<V> values { owned get; }
	}
	/**
	 * Skeletal implementation of the {@link MultiMap} interface.
	 *
	 * @see HashMultiMap
	 * @see TreeMultiMap
	 */
	[CCode (cheader_filename = "gee.h")]
	public abstract class AbstractMultiMap<K,V> : GLib.Object, Gee.MultiMap<K,V> {
		protected Gee.Map<K,Gee.Collection<V>> _storage_map;
		protected AbstractMultiMap (Gee.Map<K,Gee.Collection<V>> storage_map);
		protected abstract Gee.MultiSet<K> create_multi_key_set ();
		protected abstract Gee.Collection<V> create_value_storage ();
		protected abstract Gee.EqualDataFunc<V> get_value_equal_func ();
		public new virtual Gee.MultiMap<K,V> read_only_view { owned get; }
	}
	/**
	 * Skeletal implementation of the {@link MultiSet} interface.
	 *
	 * @see HashMultiSet
	 * @see TreeMultiSet
	 */
	[CCode (cheader_filename = "gee.h")]
	public abstract class AbstractMultiSet<G> : Gee.AbstractCollection<G>, Gee.MultiSet<G> {
		protected Gee.Map<G,int> _storage_map;
		/**
		 * Constructs a new, empty abstract multi set.
		 */
		protected AbstractMultiSet (Gee.Map<G,int> storage_map);
		public override bool add (G item);
		public override void clear ();
		public override bool contains (G item);
		public override Gee.Iterator<G> iterator ();
		public override bool remove (G item);
		public override bool read_only { get; }
		public new virtual Gee.MultiSet<G> read_only_view { owned get; }
		public override int size { get; }
	}
	/**
	 * Skeletal implementation of the {@link Queue} interface.
	 *
	 * Contains common code shared by all queue implementations.
	 *
	 * @see PriorityQueue
	 */
	[CCode (cheader_filename = "gee.h")]
	public abstract class AbstractQueue<G> : Gee.AbstractCollection<G>, Gee.Queue<G> {
		protected AbstractQueue ();
		/**
		 * {@inheritDoc}
		 */
		public abstract G peek ();
		/**
		 * {@inheritDoc}
		 */
		public abstract G poll ();
		/**
		 * {@inheritDoc}
		 */
		public abstract int capacity { get; }
		/**
		 * {@inheritDoc}
		 */
		public abstract bool is_full { get; }
		/**
		 * {@inheritDoc}
		 */
		public abstract int remaining_capacity { get; }
	}
	/**
	 * Skeletal implementation of the {@link Set} interface.
	 *
	 * Contains common code shared by all set implementations.
	 *
	 * @see HashSet
	 * @see TreeSet
	 */
	[CCode (cheader_filename = "gee.h")]
	public abstract class AbstractSet<G> : Gee.AbstractCollection<G>, Gee.Set<G> {
		protected AbstractSet ();
		/**
		 * {@inheritDoc}
		 */
		public new virtual Gee.Set<G> read_only_view { owned get; }
	}
	[CCode (cheader_filename = "gee.h")]
	public abstract class AbstractSortedMap<K,V> : Gee.AbstractMap<K,V>, Gee.SortedMap<K,V> {
		protected AbstractSortedMap ();
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.SortedMap<K,V> head_map (K before);
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.SortedMap<K,V> sub_map (K before, K after);
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.SortedMap<K,V> tail_map (K after);
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.SortedSet<Gee.Map.Entry<K,V>> ascending_entries { owned get; }
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.SortedSet<K> ascending_keys { owned get; }
	}
	/**
	 * Skeletal implementation of the {@link SortedSet} interface.
	 *
	 * Contains common code shared by all set implementations.
	 *
	 * @see TreeSet
	 */
	[CCode (cheader_filename = "gee.h")]
	public abstract class AbstractSortedSet<G> : Gee.AbstractSet<G>, Gee.SortedSet<G> {
		protected AbstractSortedSet ();
		/**
		 * {@inheritDoc}
		 */
		public abstract G ceil (G element);
		/**
		 * {@inheritDoc}
		 */
		public abstract G first ();
		/**
		 * {@inheritDoc}
		 */
		public abstract G floor (G element);
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.SortedSet<G> head_set (G before);
		/**
		 * {@inheritDoc}
		 */
		public abstract G higher (G element);
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.Iterator<G>? iterator_at (G element);
		/**
		 * {@inheritDoc}
		 */
		public abstract G last ();
		/**
		 * {@inheritDoc}
		 */
		public abstract G lower (G element);
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.SortedSet<G> sub_set (G from, G to);
		/**
		 * {@inheritDoc}
		 */
		public abstract Gee.SortedSet<G> tail_set (G after);
		/**
		 * {@inheritDoc}
		 */
		public new virtual Gee.SortedSet<G> read_only_view { owned get; }
	}
	/**
	 * Resizable array implementation of the {@link List} interface.
	 *
	 * The storage array grows automatically when needed.
	 *
	 * This implementation is pretty good for rarely modified data. Because they are
	 * stored in an array this structure does not fit for highly mutable data. For an
	 * alternative implementation see {@link LinkedList}.
	 *
	 * @see LinkedList
	 */
	[CCode (cheader_filename = "gee.h")]
	public class ArrayList<G> : Gee.AbstractBidirList<G> {
		/**
		 * Constructs a new, empty array list.
		 *
		 * If not provided, the function parameter is requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param equal_func an optional element equality testing function
		 */
		public ArrayList (owned Gee.EqualDataFunc<G>? equal_func = null);
		/**
		 * {@inheritDoc}
		 */
		public override bool add (G item);
		/**
		 * {@inheritDoc}
		 */
		public bool add_all (Gee.Collection<G> collection);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.BidirListIterator<G> bidir_list_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override void clear ();
		/**
		 * {@inheritDoc}
		 */
		public override bool contains (G item);
		/**
		 * {@inheritDoc}
		 */
		public override bool @foreach (Gee.ForallFunc<G> f);
		/**
		 * {@inheritDoc}
		 */
		public override G @get (int index);
		/**
		 * {@inheritDoc}
		 */
		public override int index_of (G item);
		/**
		 * {@inheritDoc}
		 */
		public override void insert (int index, G item);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Iterator<G> iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override Gee.ListIterator<G> list_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override bool remove (G item);
		/**
		 * {@inheritDoc}
		 */
		public override G remove_at (int index);
		/**
		 * {@inheritDoc}
		 */
		public override void @set (int index, G item);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.List<G>? slice (int start, int stop);
		/**
		 * Constructs a new array list based on provided array.
		 *
		 * If not provided, the function parameter is requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param items initial items to be put into array
		 * @param equal_func an optional element equality testing function
		 */
		public ArrayList.wrap (owned G[] items, owned Gee.EqualDataFunc<G>? equal_func = null);
		/**
		 * The elements' equality testing function.
		 */
		[CCode (notify = false)]
		public Gee.EqualDataFunc<G> equal_func { get; private set; }
		/**
		 * {@inheritDoc}
		 */
		public override bool read_only { get; }
		/**
		 * {@inheritDoc}
		 */
		public override int size { get; }
	}
	/**
	 * Resizable array implementation of the {@link Deque} interface.
	 *
	 * The storage array grows automatically when needed.
	 *
	 * This implementation is pretty good for lookups at the end or random.
	 * Because they are stored in an array this structure does not fit for deleting
	 * arbitrary elements. For an alternative implementation see {@link LinkedList}.
	 *
	 * @see LinkedList
	 */
	[CCode (cheader_filename = "gee.h")]
	public class ArrayQueue<G> : Gee.AbstractQueue<G>, Gee.Deque<G> {
		/**
		 * Constructs a new, empty array queue.
		 *
		 * If not provided, the function parameter is requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param equal_func an optional element equality testing function
		 */
		public ArrayQueue (owned Gee.EqualDataFunc<G>? equal_func = null);
		/**
		 * {@inheritDoc}
		 */
		public override bool add (G element);
		/**
		 * {@inheritDoc}
		 */
		public override void clear ();
		/**
		 * {@inheritDoc}
		 */
		public override bool contains (G item);
		/**
		 * {@inheritDoc}
		 */
		public override bool @foreach (Gee.ForallFunc<G> f);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Iterator<G> iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override G peek ();
		/**
		 * {@inheritDoc}
		 */
		public override G poll ();
		/**
		 * {@inheritDoc}
		 */
		public override bool remove (G item);
		/**
		 * {@inheritDoc}
		 */
		public override int capacity { get; }
		[CCode (notify = false)]
		public Gee.EqualDataFunc<G> equal_func { get; private set; }
		public bool is_empty { get; }
		/**
		 * {@inheritDoc}
		 */
		public override bool is_full { get; }
		/**
		 * {@inheritDoc}
		 */
		public override bool read_only { get; }
		/**
		 * {@inheritDoc}
		 */
		public override int remaining_capacity { get; }
		/**
		 * {@inheritDoc}
		 */
		public override int size { get; }
	}
	/**
	 * A single-linked list. This implementation is based on
	 * [[http://www.cse.yorku.ca/~ruppert/papers/lfll.pdf|Mikhail Fomitchev and  Eric Ruppert paper ]].
	 *
	 * Many threads are allowed to operate on the same structure as well as modification
	 * of structure during iteration is allowed. However the change may not be immediately
	 * visible to other threads.
	 */
	[CCode (cheader_filename = "gee.h")]
	public class ConcurrentList<G> : Gee.AbstractList<G> {
		/**
		 * Construct new, empty single linked list
		 *
		 * If not provided, the function parameter is requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param equal_func an optional element equality testing function
		 */
		public ConcurrentList (owned Gee.EqualDataFunc<G>? equal_func = null);
		/**
		 * {@inheritDoc}
		 */
		public override bool add (G item);
		/**
		 * {@inheritDoc}
		 */
		public override void clear ();
		/**
		 * {@inheritDoc}
		 */
		public override bool contains (G item);
		/**
		 * {@inheritDoc}
		 */
		public override G @get (int index);
		/**
		 * {@inheritDoc}
		 */
		public override int index_of (G item);
		/**
		 * {@inheritDoc}
		 */
		public override void insert (int index, G item);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Iterator<G> iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override Gee.ListIterator<G> list_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override bool remove (G item);
		/**
		 * {@inheritDoc}
		 */
		public override G remove_at (int index);
		/**
		 * {@inheritDoc}
		 */
		public override void @set (int index, G item);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.List<G>? slice (int start, int end);
		/**
		 * The elements' equality testing function.
		 */
		[CCode (notify = false)]
		public Gee.EqualDataFunc<G> equal_func { get; private set; }
		/**
		 * {@inheritDoc}
		 */
		public bool is_empty { get; }
		/**
		 * {@inheritDoc}
		 */
		public override bool read_only { get; }
		/**
		 * {@inheritDoc}
		 */
		public override int size { get; }
	}
	/**
	 * A skip-linked list. This implementation is based on
	 * [[http://www.cse.yorku.ca/~ruppert/Mikhail.pdf|Mikhail Fomitchev Master Thesis]].
	 *
	 * Many threads are allowed to operate on the same structure as well as modification
	 * of structure during iteration is allowed. However the change may not be immediately
	 * visible to other threads.
	 */
	[CCode (cheader_filename = "gee.h")]
	public class ConcurrentSet<G> : Gee.AbstractSortedSet<G> {
		public enum RangeType {
			HEAD,
			TAIL,
			BOUNDED,
			EMPTY
		}
		public ConcurrentSet (owned GLib.CompareDataFunc<G>? compare_func = null);
		public override bool add (G key);
		public override G ceil (G element);
		public override void clear ();
		public override bool contains (G key);
		public override G first ();
		public override G floor (G element);
		public override Gee.SortedSet<G> head_set (G before);
		public override G higher (G element);
		public override Gee.Iterator<G> iterator ();
		public override Gee.Iterator<G>? iterator_at (G element);
		public override G last ();
		public override G lower (G element);
		public override bool remove (G item);
		public override Gee.SortedSet<G> sub_set (G from, G to);
		public override Gee.SortedSet<G> tail_set (G after);
		public override bool read_only { get; }
		public override int size { get; }
	}
	/**
	 * Hash table implementation of the {@link Map} interface.
	 *
	 * This implementation is better fit for highly heterogeneous key values.
	 * In case of high key hashes redundancy or higher amount of data prefer using
	 * tree implementation like {@link TreeMap}.
	 *
	 * @see TreeMap
	 */
	[CCode (cheader_filename = "gee.h")]
	public class HashMap<K,V> : Gee.AbstractMap<K,V> {
		/**
		 * Constructs a new, empty hash map.
		 *
		 * If not provided, the functions parameters are requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param key_hash_func an optional key hash function
		 * @param key_equal_func an optional key equality testing function
		 * @param value_equal_func an optional value equality testing function
		 */
		public HashMap (owned Gee.HashDataFunc<K>? key_hash_func = null, owned Gee.EqualDataFunc<K>? key_equal_func = null, owned Gee.EqualDataFunc<V>? value_equal_func = null);
		/**
		 * {@inheritDoc}
		 */
		public override void clear ();
		/**
		 * {@inheritDoc}
		 */
		public override V @get (K key);
		/**
		 * {@inheritDoc}
		 */
		public override bool has (K key, V value);
		/**
		 * {@inheritDoc}
		 */
		public override bool has_key (K key);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.MapIterator<K,V> map_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override void @set (K key, V value);
		/**
		 * {@inheritDoc}
		 */
		public override bool unset (K key, out V value = null);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Set<Gee.Map.Entry<K,V>> entries { owned get; }
		/**
		 * The keys' equality testing function.
		 */
		[CCode (notify = false)]
		public Gee.EqualDataFunc<K> key_equal_func { get; private set; }
		/**
		 * The keys' hash function.
		 */
		[CCode (notify = false)]
		public Gee.HashDataFunc<K> key_hash_func { get; private set; }
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Set<K> keys { owned get; }
		/**
		 * {@inheritDoc}
		 */
		public override bool read_only { get; }
		/**
		 * {@inheritDoc}
		 */
		public override int size { get; }
		/**
		 * The values' equality testing function.
		 */
		[CCode (notify = false)]
		public Gee.EqualDataFunc<V> value_equal_func { get; private set; }
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Collection<V> values { owned get; }
	}
	/**
	 * Hash table implementation of the {@link MultiMap} interface.
	 */
	[CCode (cheader_filename = "gee.h")]
	public class HashMultiMap<K,V> : Gee.AbstractMultiMap<K,V> {
		/**
		 * Constructs a new, empty hash multimap.
		 *
		 * If not provided, the functions parameters are requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param key_hash_func an optional key hash function
		 * @param key_equal_func an optional key equality testing function
		 * @param value_hash_func an optional value hash function
		 * @param value_equal_func an optional value equality testing function
		 */
		public HashMultiMap (owned Gee.HashDataFunc<K>? key_hash_func = null, owned Gee.EqualDataFunc<K>? key_equal_func = null, owned Gee.HashDataFunc<V>? value_hash_func = null, owned Gee.EqualDataFunc<V>? value_equal_func = null);
		protected override Gee.MultiSet<K> create_multi_key_set ();
		protected override Gee.Collection<V> create_value_storage ();
		protected override Gee.EqualDataFunc<V> get_value_equal_func ();
		public Gee.EqualDataFunc<K> key_equal_func { get; }
		public Gee.HashDataFunc<K> key_hash_func { get; }
		[CCode (notify = false)]
		public Gee.EqualDataFunc<V> value_equal_func { get; private set; }
		[CCode (notify = false)]
		public Gee.HashDataFunc<V> value_hash_func { get; private set; }
	}
	/**
	 * Hash table implementation of the {@link MultiSet} interface.
	 */
	[CCode (cheader_filename = "gee.h")]
	public class HashMultiSet<G> : Gee.AbstractMultiSet<G> {
		/**
		 * Constructs a new, empty hash multi set.
		 *
		 * If not provided, the functions parameters are requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param hash_func an optional element hash function
		 * @param equal_func an optional element equality testing function
		 */
		[CCode (cname = "gee_hash_multi_set_new_fixed")]
		public HashMultiSet (owned Gee.HashDataFunc<G>? hash_func = null, owned Gee.EqualDataFunc<G>? equal_func = null);
		/**
		 * Constructs a new, empty hash multi set.
		 *
		 * If not provided, the functions parameters are requested to the
		 * {@link Functions} function factory methods.
		 *
		 * Note: this function is only for backward ABI compatibility.
		 *   It contains memory leak and SHOULD NOT BE USED.
		 * 
		 *
		 * @param hash_func an optional element hash function
		 * @param equal_func an optional element equality testing function
		 */
		[CCode (cname = "gee_hash_multi_set_new")]
		[Version (deprecated = true, deprecated_since = "0.13.3", replacement = "gee_hash_multi_set_new_fixed")]
		public HashMultiSet.broken (Gee.HashDataFunc<G>? hash_func = null, Gee.EqualDataFunc<G>? equal_func = null);
		public Gee.EqualDataFunc<G> equal_func { get; }
		public Gee.HashDataFunc<G> hash_func { get; }
	}
	/**
	 * Hash table implementation of the {@link Set} interface.
	 *
	 * This implementation is better fit for highly heterogeneous values.
	 * In case of high value hashes redundancy or higher amount of data prefer using
	 * tree implementation like {@link TreeSet}.
	 *
	 * @see TreeSet
	 */
	[CCode (cheader_filename = "gee.h")]
	public class HashSet<G> : Gee.AbstractSet<G> {
		/**
		 * Constructs a new, empty hash set.
		 *
		 * If not provided, the functions parameters are requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param hash_func an optional hash function
		 * @param equal_func an optional equality testing function
		 */
		public HashSet (owned Gee.HashDataFunc<G>? hash_func = null, owned Gee.EqualDataFunc<G>? equal_func = null);
		/**
		 * {@inheritDoc}
		 */
		public override bool add (G key);
		/**
		 * {@inheritDoc}
		 */
		public override void clear ();
		/**
		 * {@inheritDoc}
		 */
		public override bool contains (G key);
		/**
		 * {@inheritDoc}
		 */
		public override bool @foreach (Gee.ForallFunc<G> f);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Iterator<G> iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override bool remove (G key);
		/**
		 * The elements' equality testing function.
		 */
		[CCode (notify = false)]
		public Gee.EqualDataFunc<G> equal_func { get; private set; }
		/**
		 * The elements' hash function.
		 */
		[CCode (notify = false)]
		public Gee.HashDataFunc<G> hash_func { get; private set; }
		/**
		 * {@inheritDoc}
		 */
		public override bool read_only { get; }
		/**
		 * {@inheritDoc}
		 */
		public override int size { get; }
	}
	/**
	 * Hazard pointer is a method of protecting a pointer shared by many threads.
	 * If you want to use atomic pointer that may be freed you should use following code:
	 *
	 * {{{
	 *    string *shared_pointer = ...;
	 *    HazardPointer<string> hptr = HazardPointer.get_hazard_pointer (&shared_pointer);
	 *    // my_string contains value from shared_pinter. It is valid as long as hptr is alive.
	 *    unowned string my_string = ptr.get ();
	 *    // instead of delete
	 *    ptr.release ((ptr) => {string *sptr = ptr;string ref = (owned)sptr;});
	 *    });
	 * }}}
	 *
	 * In some cases you may use helper methods which might involve copying of object (and are unsafe for unowned objects):
	 * {{{
	 *    Gtk.Window *window = ...;
	 *    Gtk.Window? local_window = HazardPointer.get_pointer (&window);
	 *    HazardPointer.set_pointer (&window, ...)
	 *    local_window = HazardPointer.exchange_pointer (&window, null);
	 *    HazardPointer.compare_and_exchange (&window, null, local_window);
	 * }}}
	 *
	 * The class also provides helper methods if least significant bits are used for storing flags.
	 *
	 * HazardPointers are not thread-safe (unless documentation states otherwise).
	 */
	[CCode (cheader_filename = "gee.h")]
	[Compact]
	public class HazardPointer<G> {
		/**
		 * Create a new context. User does not need to create explicitly however it might be benefitial
		 * if he is about to issue bunch of commands he might consider it benefitial to fine-tune the creation of contexts.
		 *
		 * {{{
		 *   Context ctx = new Context ();
		 *   lock_free_collection.operation1 ();
		 *   // Normally on exit the thread exit operation would be executed but here the default operation of
		 *   // child context is executed.
		 *   lock_free_collection.operation2 ();
		 * }}}
		 *
		 * Please note that the Context in implicitly part of stack and:
		 *
		 * 1. It cannot be moved between threads.
		 * 2. If in given thread the child (created later) context is alive parent must be alive as well.
		 */
		[Compact]
		public class Context {
			public Context (Gee.HazardPointer.Policy? policy = null);
			/**
			 * Ensure that whole context is freed. Please note that it might block.
			 */
			public void free_all ();
			/**
			 * Pushes the current context to releaser. Please note that it might block.
			 */
			public void release ();
			/**
			 * Tries to free all freed pointer in current context.
			 */
			public void try_free ();
			/**
			 * Tries to push the current context to releaser.
			 */
			public void try_release ();
		}
		/**
		 * Policy determines what happens on exit from Context.
		 */
		public enum Policy {
			/**
			 * Performs default action on exit from thread.
			 */
			DEFAULT,
			/**
			 * Performs the same action as on exit from current thread.
			 */
			THREAD_EXIT,
			/**
			 * Goes through the free list and attempts to free un-freed elements.
			 */
			TRY_FREE,
			/**
			 * Goes through the free list and attempts to free un-freed elements
			 * until all elements are freed.
			 */
			FREE,
			/**
			 * Release the un-freed elements to either helper thread or to main loop.
			 * Please note if the operation would block it is not performed.
			 */
			TRY_RELEASE,
			/**
			 * Release the un-freed elements to either helper thread or to main loop.
			 * Please note it may block while adding to queue.
			 */
			RELEASE;
			/**
			 * Checks if the policy is concrete or if it depends on global variables.
			 *
			 * @return ``true`` if this policy does not depend on global variables
			 */
			public bool is_concrete ();
			/**
			 * Checks if policy blocks or is lock-free.
			 * Please note that it works on a concrete policy only.
			 *
			 * @return ``true`` if the policy may block the thread.
			 */
			public bool is_blocking ();
			/**
			 * Checks if policy guarantees freeing all elements.
			 * Please note that it works on a concrete policy only.
			 *
			 * @return ``true`` if the policy guarantees freeing all elements.
			 */
			public bool is_safe ();
			/**
			 * Finds concrete policy which corresponds to given policy.
			 *
			 * @return Policy that corresponds to given policy at given time in given thread.
			 */
			public Gee.HazardPointer.Policy to_concrete ();
		}
		/**
		 * Release policy determines what happens with object freed by Policy.TRY_RELEASE
		 * and Policy.RELEASE.
		 */
		public enum ReleasePolicy {
			/**
			 * Libgee spawns helper thread to free those elements.
			 * This is default.
			 */
			HELPER_THREAD,
			/**
			 * Libgee uses GLib main loop.
			 * This is recommended for application using GLib main loop.
			 */
			MAIN_LOOP;
		}
		/**
		 * Creates a hazard pointer for a pointer.
		 *
		 * @param ptr Protected pointer
		 */
		public HazardPointer (G* ptr);
		/**
		 * Compares and exchanges objects.
		 *
		 * @param aptr Atomic pointer.
		 * @param old_ptr Old pointer.
		 * @param _new_ptr New value.
		 * @param old_mask Old mask.
		 * @param new_mask New mask.
		 * @return Value that was previously stored.
		 */
		public static bool compare_and_exchange_pointer<G> (G** aptr, G old_ptr, owned G _new_ptr, size_t mask = 0, size_t old_mask = 0, size_t new_mask = 0);
		/**
		 * Exchange objects safely.
		 *
		 * @param aptr Atomic pointer.
		 * @param new_ptr New value
		 * @param mask Mask of flags.
		 * @param new_mask New mask.
		 * @param old_mask Previous mask mask.
		 * @return Hazard pointer containing old value.
		 */
		public static Gee.HazardPointer<G>? exchange_hazard_pointer<G> (G** aptr, owned G new_ptr, size_t mask = 0, size_t new_mask = 0, out size_t old_mask = null);
		/**
		 * Exchange objects safely.
		 *
		 * @param aptr Atomic pointer.
		 * @param new_ptr New value
		 * @param mask Mask of flags.
		 * @param new_mask New mask.
		 * @param old_mask Previous mask mask.
		 * @return Value that was previously stored.
		 */
		public static G exchange_pointer<G> (G** aptr, owned G new_ptr, size_t mask = 0, size_t new_mask = 0, out size_t old_mask = null);
		/**
		 * Gets the pointer hold by hazard pointer.
		 *
		 * @param other_thread Have to be set to ``true`` if accessed from thread that did not create this thread.
		 * @return The value hold by pointer.
		 */
		public new unowned G @get (bool other_thread = false);
		/**
		 * Gets hazard pointer from atomic pointer safely.
		 *
		 * @param aptr Atomic pointer.
		 * @param mask Mask of bits.
		 * @param mask_out Result of mask.
		 * @return Hazard pointer containing the element.
		 */
		public static Gee.HazardPointer<G>? get_hazard_pointer<G> (G** aptr, size_t mask = 0, out size_t mask_out = null);
		/**
		 * Copy an object from atomic pointer.
		 *
		 * @param aptr Atomic pointer.
		 * @param mask Mask of flags.
		 * @param mask_out Result of mask.
		 * @return A copy of object from atomic pointer.
		 */
		public static G get_pointer<G> (G** aptr, size_t mask = 0, out size_t mask_out = null);
		/**
		 * Free the pointer.
		 *
		 * @param notify method freeing object
		 */
		public void release (owned GLib.DestroyNotify notify);
		/**
		 * Sets default policy (i.e. default policy for user-created contexts).
		 * The policy must be concrete and should not be blocking.
		 *
		 * @param policy New default policy.
		 */
		public static void set_default_policy (Gee.HazardPointer.Policy policy);
		/**
		 * Sets object safely
		 *
		 * @param aptr Atomic pointer.
		 * @param new_ptr New value
		 * @param mask Mask of flags.
		 * @param new_mask New mask.
		 */
		public static void set_pointer<G> (G** aptr, owned G new_ptr, size_t mask = 0, size_t new_mask = 0);
		/**
		 * Sets release (i.e. how exactly the released objects arefreed).
		 *
		 * The method can be only set before any objects is released and is not thread-safe.
		 *
		 * @param policy New release policy.
		 */
		public static bool set_release_policy (Gee.HazardPointer.ReleasePolicy policy);
		/**
		 * Sets thread exit policy (i.e. default policy for the top-most Context).
		 * The policy must be concrete and should not be unsafe.
		 *
		 * @param policy New thread policy.
		 */
		public static void set_thread_exit_policy (Gee.HazardPointer.Policy policy);
	}
	/**
	 * Represents a lazy value. I.e. value that is computed on demand.
	 *
	 * This class is not thread-safe.
	 */
	[CCode (cheader_filename = "gee.h")]
	public class Lazy<G> {
		public Lazy (owned Gee.LazyFunc<G> func);
		public void eval ();
		public Lazy.from_value (G item);
		public new G @get ();
		/**
		 * Provides a future for a lazy value.
		 *
		 * Note: The future can be requested only once and all access must be
		 *   done through it.
		 */
		public Gee.Future<G>? future { owned get; }
		public new G value { get; }
	}
	/**
	 * Doubly-linked list implementation of the {@link List} interface.
	 *
	 * This implementation is pretty well designed for highly mutable data. When
	 * indexed access is privileged prefer using {@link ArrayList}.
	 *
	 * @see ArrayList
	 */
	[CCode (cheader_filename = "gee.h")]
	public class LinkedList<G> : Gee.AbstractBidirList<G>, Gee.Queue<G>, Gee.Deque<G> {
		/**
		 * Constructs a new, empty linked list.
		 *
		 * If not provided, the function parameter is requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param equal_func an optional element equality testing function
		 */
		public LinkedList (owned Gee.EqualDataFunc<G>? equal_func = null);
		/**
		 * {@inheritDoc}
		 */
		public override bool add (G item);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.BidirListIterator<G> bidir_list_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override void clear ();
		/**
		 * {@inheritDoc}
		 */
		public override bool contains (G item);
		/**
		 * {@inheritDoc}
		 */
		public G first ();
		/**
		 * {@inheritDoc}
		 */
		public override bool @foreach (Gee.ForallFunc<G> f);
		/**
		 * {@inheritDoc}
		 */
		public override G @get (int index);
		/**
		 * {@inheritDoc}
		 */
		public override int index_of (G item);
		/**
		 * {@inheritDoc}
		 */
		public override void insert (int index, G item);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Iterator<G> iterator ();
		/**
		 * {@inheritDoc}
		 */
		public G last ();
		/**
		 * {@inheritDoc}
		 */
		public override Gee.ListIterator<G> list_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override bool remove (G item);
		/**
		 * {@inheritDoc}
		 */
		public override G remove_at (int index);
		/**
		 * {@inheritDoc}
		 */
		public override void @set (int index, G item);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.List<G>? slice (int start, int stop);
		/**
		 * The elements' equality testing function.
		 */
		[CCode (notify = false)]
		public Gee.EqualDataFunc<G> equal_func { get; private set; }
		/**
		 * {@inheritDoc}
		 */
		public override bool read_only { get; }
		/**
		 * {@inheritDoc}
		 */
		public override int size { get; }
	}
	/**
	 * Relaxed fibonacci heap priority queue implementation of the {@link Queue}.
	 *
	 * The elements of the priority queue are ordered according to their natural
	 * ordering, or by a compare_func provided at queue construction time. A
	 * priority queue does not permit null elements and does not have bounded
	 * capacity.
	 *
	 * This implementation provides O(1) time for offer and peek methods, and
	 * O(log n) for poll method. It is based on the algorithms described by
	 * Boyapati Chandra Sekhar in:
	 *
	 *   "Worst Case Efficient Data Structures
	 *      for Priority Queues and Deques with Heap Order"
	 *   Boyapati Chandra Sekhar (under the guidance of Prof. C. Pandu Rangan)
	 *   Department of Computer Science and Engineering
	 *   Indian Institute of Technology, Madras
	 *   May 1996
	 */
	[CCode (cheader_filename = "gee.h")]
	public class PriorityQueue<G> : Gee.AbstractQueue<G> {
		/**
		 * Constructs a new, empty priority queue.
		 *
		 * If not provided, the function parameter is requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param compare_func an optional element comparator function
		 */
		public PriorityQueue (owned GLib.CompareDataFunc<G>? compare_func = null);
		/**
		 * {@inheritDoc}
		 */
		public override bool add (G item);
		/**
		 * {@inheritDoc}
		 */
		public override void clear ();
		/**
		 * {@inheritDoc}
		 */
		public override bool contains (G item);
		/**
		 * {@inheritDoc}
		 */
		public int drain (Gee.Collection<G> recipient, int amount = -1);
		/**
		 * {@inheritDoc}
		 */
		public override bool @foreach (Gee.ForallFunc<G> f);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Iterator<G> iterator ();
		/**
		 * {@inheritDoc}
		 */
		public bool offer (G element);
		/**
		 * {@inheritDoc}
		 */
		public override G peek ();
		/**
		 * {@inheritDoc}
		 */
		public override G poll ();
		/**
		 * {@inheritDoc}
		 */
		public override bool remove (G item);
		/**
		 * {@inheritDoc}
		 */
		public override int capacity { get; }
		/**
		 * The elements' comparator function.
		 */
		[CCode (notify = false)]
		public GLib.CompareDataFunc<G> compare_func { get; private set; }
		/**
		 * {@inheritDoc}
		 */
		public override bool is_full { get; }
		/**
		 * {@inheritDoc}
		 */
		public override bool read_only { get; }
		/**
		 * {@inheritDoc}
		 */
		public override int remaining_capacity { get; }
		/**
		 * {@inheritDoc}
		 */
		public override int size { get; }
	}
	/**
	 * Promise allows to set a value with associated {@link Future}. Please note that
	 * value can be stored only once.
	 *
	 * Typically the producer will create promise and return {@link future} while
	 * keeping the promise to itself. Then when value is ready it can call {@link set_value}.
	 *
	 * @see Future
	 * @see task
	 * @since 0.11.0
	 */
	[CCode (cheader_filename = "gee.h")]
	public class Promise<G> {
		public Promise ();
		/**
		 * Sets the exception.
		 *
		 * @param exception Exception thrown
		 */
		public void set_exception (owned GLib.Error exception);
		/**
		 * Sets the value of the future.
		 *
		 * @param value Value of future
		 */
		public void set_value (owned G value);
		/**
		 * {@link Future} value of this promise
		 */
		public Gee.Future<G> future { get; }
	}
	/**
	 * Left-leaning red-black tree implementation of the {@link Map} interface.
	 *
	 * This implementation is especially well designed for large quantity of
	 * data. The (balanced) tree implementation insure that the set and get
	 * methods are in logarithmic complexity.
	 *
	 * @see HashMap
	 */
	[CCode (cheader_filename = "gee.h")]
	public class TreeMap<K,V> : Gee.AbstractBidirSortedMap<K,V> {
		/**
		 * Constructs a new, empty tree map sorted according to the specified
		 * comparator function.
		 *
		 * If not provided, the functions parameters are requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param key_compare_func an optional key comparator function
		 * @param value_equal_func an optional values equality testing function
		 */
		public TreeMap (owned GLib.CompareDataFunc<K>? key_compare_func = null, owned Gee.EqualDataFunc<V>? value_equal_func = null);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.BidirMapIterator<K,V> bidir_map_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override void clear ();
		/**
		 * {@inheritDoc}
		 */
		public override V @get (K key);
		/**
		 * {@inheritDoc}
		 */
		public override bool has (K key, V value);
		/**
		 * {@inheritDoc}
		 */
		public override bool has_key (K key);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.SortedMap<K,V> head_map (K before);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.MapIterator<K,V> map_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override void @set (K key, V value);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.SortedMap<K,V> sub_map (K after, K before);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.SortedMap<K,V> tail_map (K after);
		/**
		 * {@inheritDoc}
		 */
		public override bool unset (K key, out V value = null);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.SortedSet<Gee.Map.Entry<K,V>> ascending_entries { owned get; }
		/**
		 * {@inheritDoc}
		 */
		public override Gee.SortedSet<K> ascending_keys { owned get; }
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Set<Gee.Map.Entry<K,V>> entries { owned get; }
		/**
		 * The keys' comparator function.
		 */
		[CCode (notify = false)]
		public GLib.CompareDataFunc<K> key_compare_func { get; private set; }
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Set<K> keys { owned get; }
		public override bool read_only { get; }
		/**
		 * {@inheritDoc}
		 */
		public override int size { get; }
		/**
		 * The values' equality testing function.
		 */
		[CCode (notify = false)]
		public Gee.EqualDataFunc<V> value_equal_func { get; private set; }
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Collection<V> values { owned get; }
	}
	/**
	 * Left-leaning red-black tree implementation of the {@link MultiMap}
	 * interface.
	 */
	[CCode (cheader_filename = "gee.h")]
	public class TreeMultiMap<K,V> : Gee.AbstractMultiMap<K,V> {
		/**
		 * Constructs a new, empty tree multimap.
		 *
		 * If not provided, the functions parameters are requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param key_compare_func an optional key comparator function
		 * @param value_compare_func an optional value comparator function
		 */
		public TreeMultiMap (owned GLib.CompareDataFunc<K>? key_compare_func = null, owned GLib.CompareDataFunc<V>? value_compare_func = null);
		protected override Gee.MultiSet<K> create_multi_key_set ();
		protected override Gee.Collection<V> create_value_storage ();
		protected override Gee.EqualDataFunc<V> get_value_equal_func ();
		public GLib.CompareDataFunc<K> key_compare_func { get; }
		[CCode (notify = false)]
		public GLib.CompareDataFunc<V> value_compare_func { get; private set; }
	}
	/**
	 * Left-leaning red-black tree implementation of the {@link MultiSet}
	 * interface.
	 */
	[CCode (cheader_filename = "gee.h")]
	public class TreeMultiSet<G> : Gee.AbstractMultiSet<G> {
		/**
		 * Constructs a new, empty tree multi set.
		 *
		 * If not provided, the function parameter is requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param compare_func an optional element comparator function
		 */
		public TreeMultiSet (owned GLib.CompareDataFunc<G>? compare_func = null);
		public GLib.CompareDataFunc<G> compare_func { get; }
	}
	/**
	 * Left-leaning red-black tree implementation of the {@link Set} interface.
	 *
	 * This implementation is especially well designed for large quantity of
	 * data. The (balanced) tree implementation insure that the set and get
	 * methods are in logarithmic complexity. For a linear implementation see
	 * {@link HashSet}.
	 *
	 * @see HashSet
	 */
	[CCode (cheader_filename = "gee.h")]
	public class TreeSet<G> : Gee.AbstractBidirSortedSet<G> {
		/**
		 * Constructs a new, empty tree set sorted according to the specified
		 * comparator function.
		 *
		 * If not provided, the function parameter is requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param compare_func an optional element comparator function
		 */
		public TreeSet (owned GLib.CompareDataFunc<G>? compare_func = null);
		/**
		 * {@inheritDoc}
		 *
		 * If the element already exists in the set it will not be added twice.
		 */
		public override bool add (G item);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.BidirIterator<G> bidir_iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override G ceil (G item);
		/**
		 * {@inheritDoc}
		 */
		public override void clear ();
		/**
		 * {@inheritDoc}
		 */
		public override bool contains (G item);
		/**
		 * {@inheritDoc}
		 */
		public override G first ();
		/**
		 * {@inheritDoc}
		 */
		public override G floor (G item);
		/**
		 * {@inheritDoc}
		 */
		public override bool @foreach (Gee.ForallFunc<G> f);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.SortedSet<G> head_set (G before);
		/**
		 * {@inheritDoc}
		 */
		public override G higher (G item);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Iterator<G> iterator ();
		/**
		 * {@inheritDoc}
		 */
		public override Gee.Iterator<G>? iterator_at (G item);
		/**
		 * {@inheritDoc}
		 */
		public override G last ();
		/**
		 * {@inheritDoc}
		 */
		public override G lower (G item);
		/**
		 * {@inheritDoc}
		 */
		public override bool remove (G item);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.SortedSet<G> sub_set (G after, G before);
		/**
		 * {@inheritDoc}
		 */
		public override Gee.SortedSet<G> tail_set (G after);
		/**
		 * The elements' comparator function.
		 */
		[CCode (notify = false)]
		public GLib.CompareDataFunc<G> compare_func { get; private set; }
		/**
		 * {@inheritDoc}
		 */
		public override bool read_only { get; }
		/**
		 * {@inheritDoc}
		 */
		public override int size { get; }
	}
	/**
	 * Unrolled doubly-linked list implementation of the {@link List} interface.
	 *
	 * The unrolled doubly-linked list combines the advantages and disadvantages
	 * of the {@link ArrayList} and {@link LinkedList} and is usually suitable when
	 * modifications and read operations are balanced.
	 *
	 * Please note that in our benchmarks the speed of most operations (insertion,
	 * deletion, sequential read) was on par or better then {@link ArrayList} and
	 * {@link LinkedList} except the prepending operation.
	 *
	 * @see ArrayList
	 * @see LinkedList
	 */
	[CCode (cheader_filename = "gee.h")]
	public class UnrolledLinkedList<G> : Gee.AbstractBidirList<G>, Gee.Queue<G>, Gee.Deque<G> {
		/**
		 * Constructs a new, empty linked list.
		 *
		 * If not provided, the function parameter is requested to the
		 * {@link Functions} function factory methods.
		 *
		 * @param equal_func an optional element equality testing function
		 */
		public UnrolledLinkedList (owned Gee.EqualDataFunc<G>? equal_func = null);
		public override bool add (G item);
		public override Gee.BidirListIterator<G> bidir_list_iterator ();
		public override void clear ();
		public override bool contains (G item);
		public override bool @foreach (Gee.ForallFunc<G> f);
		public override G @get (int index);
		public override int index_of (G item);
		public override void insert (int index, G item);
		public override Gee.Iterator<G> iterator ();
		public override Gee.ListIterator<G> list_iterator ();
		public override bool remove (G item);
		public override G remove_at (int index);
		public override void @set (int index, G item);
		public override Gee.List<G>? slice (int start, int stop);
		/**
		 * The elements' equality testing function.
		 */
		[CCode (notify = false)]
		public Gee.EqualDataFunc<G> equal_func { get; private set; }
		public override bool read_only { get; }
		public override int size { get; }
	}
	/**
	 * A bi-directional iterator.
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface BidirIterator<G> : Gee.Iterator<G> {
		/**
		 * Rewinds to the first element in the iteration.
		 *
		 * @return ``true`` if the iterator has a first element
		 */
		public abstract bool first ();
		/**
		 * Checks whether there is a previous element in the iteration.
		 *
		 * @return ``true`` if the iterator has a previous element
		 */
		public abstract bool has_previous ();
		/**
		 * Advances to the last element in the iteration.
		 *
		 * @return ``true`` if the iterator has a last element
		 */
		public abstract bool last ();
		/**
		 * Rewinds to the previous element in the iteration.
		 *
		 * @return ``true`` if the iterator has a previous element
		 */
		public abstract bool previous ();
	}
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface BidirList<G> : Gee.List<G> {
		/**
		 * Returns a BidirListIterator that can be used for iteration over this list.
		 *
		 * @return a BidirListIterator that can be used for iteration over this list
		 */
		public new abstract Gee.BidirListIterator<G> bidir_list_iterator ();
		/**
		 * The read-only view of this list.
		 */
		public new abstract Gee.BidirList<G> read_only_view { owned get; }
	}
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface BidirListIterator<G> : Gee.BidirIterator<G>, Gee.ListIterator<G> {
		/**
		 * Inserts the specified item before the current item in the iteration. The
		 * iterator points to the same element as before.
		 *
		 * Please note that if iterator points in-between elements the element
		 * is added between neighbouring elements and the iterator point between
		 * added element and the next one.
		 */
		public abstract void insert (G item);
	}
	/**
	 * A bi-directional Map iterator.
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface BidirMapIterator<K,V> : Gee.MapIterator<K,V> {
		/**
		 * Goes back to the first element.
		 *
		 * @return `true` if the iterator has a first element
		 */
		public abstract bool first ();
		/**
		 * Checks whether there is a previous element in the iteration.
		 *
		 * @return `true` if the iterator has a previous element
		 */
		public abstract bool has_previous ();
		/**
		 * Advances to the last element in the iteration.
		 *
		 * @return `true` if the iterator has a last element
		 */
		public abstract bool last ();
		/**
		 * Rewinds to the previous element in the iteration.
		 *
		 * @return `true` if the iterator has a previous element
		 */
		public abstract bool previous ();
	}
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface BidirSortedMap<K,V> : Gee.SortedMap<K,V> {
		/**
		 * Returns a bi-directional iterator for this map.
		 *
		 * @return a bi-directional map iterator
		 */
		public abstract Gee.BidirMapIterator<K,V> bidir_map_iterator ();
		/**
		 * Returns an immutable empty sorted set.
		 *
		 * @return an immutable empty sorted set
		 */
		public static Gee.BidirSortedMap<K,V> empty<K,V> ();
		/**
		 * The read-only view of this set.
		 */
		public new abstract Gee.BidirSortedMap<K,V> read_only_view { owned get; }
	}
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface BidirSortedSet<G> : Gee.SortedSet<G> {
		/**
		 * Returns a {@link BidirIterator} that can be used for bi-directional
		 * iteration over this sorted set.
		 *
		 * @return a {@link BidirIterator} over this sorted set
		 */
		public abstract Gee.BidirIterator<G> bidir_iterator ();
		/**
		 * Returns an immutable empty sorted set.
		 *
		 * @return an immutable empty sorted set
		 */
		public static Gee.BidirSortedSet<G> empty<G> ();
		/**
		 * The read-only view of this set.
		 */
		public new abstract Gee.BidirSortedSet<G> read_only_view { owned get; }
	}
	/**
	 * A generic collection of objects.
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface Collection<G> : Gee.Iterable<G> {
		/**
		 * Adds an item to this collection. Must not be called on read-only
		 * collections.
		 *
		 * @param item the item to add to the collection
		 *
		 * @return     ``true`` if the collection has been changed, ``false`` otherwise
		 */
		[CCode (ordering = 1)]
		public abstract bool add (G item);
		/**
		 * Adds all items in the input collection to this collection.
		 *
		 * @param collection the collection which items will be added to this
		 *                   collection.
		 *
		 * @return     ``true`` if the collection has been changed, ``false`` otherwise
		 */
		[CCode (ordering = 4)]
		public virtual bool add_all (Gee.Collection<G> collection);
		/**
		 * Adds all items in the input array to this collection.
		 *
		 * @param array the array which items will be added to this
		 *              collection.
		 *
		 * @return     ``true`` if the collection has been changed, ``false`` otherwise
		 */
		[CCode (ordering = 13)]
		public virtual bool add_all_array (G[] array);
		[CCode (ordering = 16)]
		public virtual bool add_all_iterator (Gee.Iterator<G> iter);
		/**
		 * Removes all items from this collection. Must not be called on
		 * read-only collections.
		 */
		[CCode (ordering = 3)]
		public abstract void clear ();
		/**
		 * Determines whether this collection contains the specified item.
		 *
		 * @param item the item to locate in the collection
		 *
		 * @return     ``true`` if item is found, ``false`` otherwise
		 */
		[CCode (ordering = 0)]
		public abstract bool contains (G item);
		/**
		 * Returns ``true`` it this collection contains all items as the input
		 * collection.
		 *
		 * @param collection the collection which items will be compared with
		 *                   this collection.
		 *
		 * @return     ``true`` if the collection has been changed, ``false`` otherwise
		 */
		[CCode (ordering = 5)]
		public virtual bool contains_all (Gee.Collection<G> collection);
		/**
		 * Returns ``true`` it this collection contains all items as the input
		 * array.
		 *
		 * @param array the array which items will be compared with
		 *              this collection.
		 *
		 * @return     ``true`` if the collection has been changed, ``false`` otherwise
		 */
		[CCode (ordering = 14)]
		public virtual bool contains_all_array (G[] array);
		[CCode (ordering = 17)]
		public virtual bool contains_all_iterator (Gee.Iterator<G> iter);
		/**
		 * Returns an immutable empty collection.
		 *
		 * @return an immutable empty collection
		 */
		public static Gee.Collection<G> empty<G> ();
		/**
		 * Removes the first occurrence of an item from this collection. Must not
		 * be called on read-only collections.
		 *
		 * @param item the item to remove from the collection
		 *
		 * @return     ``true`` if the collection has been changed, ``false`` otherwise
		 */
		[CCode (ordering = 2)]
		public abstract bool remove (G item);
		/**
		 * Removes the subset of items in this collection corresponding to the
		 * elements in the input collection. If there is several occurrences of
		 * the same value in this collection they are decremented of the number
		 * of occurrences in the input collection.
		 *
		 * @param collection the collection which items will be compared with
		 *                   this collection.
		 *
		 * @return     ``true`` if the collection has been changed, ``false`` otherwise
		 */
		[CCode (ordering = 6)]
		public virtual bool remove_all (Gee.Collection<G> collection);
		/**
		 * Removes the subset of items in this collection corresponding to the
		 * elements in the input array. If there is several occurrences of
		 * the same value in this collection they are decremented of the number
		 * of occurrences in the input array.
		 *
		 * @param array the array which items will be compared with
		 *              this collection.
		 *
		 * @return     ``true`` if the collection has been changed, ``false`` otherwise
		 */
		[CCode (ordering = 15)]
		public virtual bool remove_all_array (G[] array);
		[CCode (ordering = 18)]
		public virtual bool remove_all_iterator (Gee.Iterator<G> iter);
		/**
		 * Removes all items in this collection that are not contained in the input
		 * collection. In other words all common items of both collections are
		 * retained in this collection.
		 *
		 * @param collection the collection which items will be compared with
		 *                   this collection.
		 *
		 * @return     ``true`` if the collection has been changed, ``false`` otherwise
		 */
		[CCode (ordering = 7)]
		public virtual bool retain_all (Gee.Collection<G> collection);
		/**
		 * Returns an array containing all of items from this collection.
		 *
		 * @return an array containing all of items from this collection
		 */
		[CCode (ordering = 8)]
		public virtual G[] to_array ();
		/**
		 * Specifies whether this collection is empty.
		 */
		[CCode (ordering = 10)]
		public virtual bool is_empty { get; }
		/**
		 * Specifies whether this collection can change - i.e. whether {@link add},
		 * {@link remove} etc. are legal operations.
		 */
		[CCode (ordering = 11)]
		public abstract bool read_only { get; }
		/**
		 * The read-only view of this collection.
		 */
		[CCode (ordering = 12)]
		public abstract Gee.Collection<G> read_only_view { owned get; }
		/**
		 * The number of items in this collection.
		 */
		[CCode (ordering = 9)]
		public abstract int size { get; }
	}
	/**
	 * This interface defines a total ordering among instances of each class
	 * implementing it.
	 *
	 * In other words:
	 *
	 *   * It's irreflexive: For all `a` it holds that `a.compare_to(a) == 0`
	 *   * It's transitive: For all `a`, `b` and `c` if `a.compare_to(b) < 0` and
	 *     `b.compare_to(c) < 0` then `a.compare_to(c) < 0`.
	 *   * It's trichotomous: For all `a` and `b` it holds that
	 *     `a.compare_to(b) = -b.compare_to(a)`.
	 *
	 * Note: The relationship must be immutable. In other words if at one point of
	 *   program `a.compare_to(b)` had certain value then call `a.compare_to(b)`
	 *   //must always// return the original value until end of `a` and `b` lifetime.
	 *
	 * @see Hashable
	 */
	[CCode (cheader_filename = "gee.h")]
	public interface Comparable<G> : GLib.Object {
		/**
		 * Compares this object with the specified object.
		 *
		 * @return a negative integer, zero, or a positive integer as this object
		 *         is less than, equal to, or greater than the specified object
		 */
		public abstract int compare_to (G object);
	}
	/**
	 * A double-ended queue.
	 *
	 * A deque can be used either as a queue (First-In-First-Out behavior) or as a
	 * stack (Last-In-First-Out behavior).
	 *
	 * The methods defined by this interface behaves exactely in the same way as
	 * the {@link Queue} methods with respect to capacity bounds.
	 *
	 * The Deque interface inherits from the {@link Queue} interface. Thus, to use
	 * a deque as a queue, you can equivalently use the following method set:
	 *
	 * ||<)(> ''Queue method'' ||<)(>  ''Deque method'' ||
	 * || {@link Queue.offer}  || {@link offer_tail}    ||
	 * || {@link Queue.peek}   || {@link peek_head}     ||
	 * || {@link Queue.poll}   || {@link poll_head}     ||
	 * || {@link Queue.drain}  || {@link drain_head}    ||
	 *
	 * To use a deque as a stack, just use the method set that acts at the head of
	 * the deque:
	 *
	 * ||<)(> ''Operation'' ||<)(>  ''Deque method'' ||
	 * || push an element   || {@link offer_head}    ||
	 * || peek an element   || {@link peek_head}     ||
	 * || pop an element    || {@link poll_head}     ||
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface Deque<G> : Gee.Queue<G> {
		/**
		 * Drains the specified amount of elements from the head of this queue in
		 * the specified recipient collection.
		 *
		 * @param recipient the recipient collection to drain the elements to
		 * @param amount    the amount of elements to drain
		 *
		 * @return          the amount of elements that were actually drained
		 */
		public abstract int drain_head (Gee.Collection<G> recipient, int amount = -1);
		/**
		 * Drains the specified amount of elements from the tail of this queue in
		 * the specified recipient collection.
		 *
		 * @param recipient the recipient collection to drain the elements to
		 * @param amount    the amount of elements to drain
		 *
		 * @return          the amount of elements that were actually drained
		 */
		public abstract int drain_tail (Gee.Collection<G> recipient, int amount = -1);
		/**
		 * Offers the specified element to the head of this deque.
		 *
		 * @param element the element to offer to the queue
		 *
		 * @return        ``true`` if the element was added to the queue
		 */
		public abstract bool offer_head (G element);
		/**
		 * Offers the specified element to the tail of this deque
		 *
		 * @param element the element to offer to the queue
		 *
		 * @return        ``true`` if the element was added to the queue
		 */
		public abstract bool offer_tail (G element);
		/**
		 * Peeks (retrieves, but not remove) an element from this queue.
		 *
		 * @return the element peeked from the queue (or ``null`` if none was
		 *         available)
		 */
		public abstract G peek_head ();
		/**
		 * Peeks (retrieves, but not remove) an element from the tail of this
		 * queue.
		 *
		 * @return the element peeked from the queue (or ``null`` if none was
		 *         available)
		 */
		public abstract G peek_tail ();
		/**
		 * Polls (retrieves and remove) an element from the head of this queue.
		 *
		 * @return the element polled from the queue (or ``null`` if none was
		 *         available)
		 */
		public abstract G poll_head ();
		/**
		 * Polls (retrieves and remove) an element from the tail of this queue.
		 *
		 * @return the element polled from the queue (or ``null`` if none was
		 *         available)
		 */
		public abstract G poll_tail ();
	}
	/**
	 * Future is a value which might not yet be computed - for example it is calculated
	 * in different thread or depends on I/O value.
	 *
	 * All methods can be called from many threads as part of interface.
	 *
	 * Note: Statement that call does not block does not mean that it is lock-free.
	 *   Internally the implementation is allowed to take mutex but it should guarantee
	 *   that it is not for a long time (including blocking on anything else, I/O calls
	 *   or callbacks).
	 *
	 * @see Promise
	 * @see Lazy
	 * @see task
	 * @see async_task
	 * @since 0.11.0
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface Future<G> : GLib.Object {
		public delegate Gee.Future<A> FlatMapFunc<A,G> (G value);
		public delegate unowned A LightMapFunc<A,G> (G value);
		public delegate A MapFunc<A,G> (G value);
		[CCode (scope = "async")]
		public delegate C ZipFunc<A,B,C> (A a, B b);
		/**
		 * Maps a future value to another future value which is returned (call does not block).
		 *
		 * Note: As time taken by function does not contribute to
		 *   {@link wait_until} and the implementation is allowed to compute
		 *   value eagerly by {@link wait_async} it is recommended to put the
		 *   larger computation inside the returned future for example by
		 *   {@link task}
		 *
		 * @param func Function applied to {@link value}
		 * @return Value of a future returned by function
		 *
		 * @see map
		 */
		[CCode (ordering = 6)]
		public virtual Gee.Future<A> flat_map<A> (owned Gee.Future.FlatMapFunc<A,G> func);
		/**
		 * Maps a future value to another value by a function and returns the
		 * another value in future.
		 *
		 * Note: The function may be reevaluated at any time and it might
		 *   be called lazily. Therefore it is recommended for it to be
		 *   idempotent. If the function needs to be called eagerly or have
		 *   side-effects it is recommended to use {@link map}.
		 *
		 * Note: As time taken by function does not contribute to
		 *   {@link wait_until} and the implementation is allowed to compute
		 *   value eagerly by {@link wait_async} it is recommended to use
		 *   {@link task} and {@link flat_map} for longer computation.
		 *
		 * @param func Function applied to {@link value}
		 * @return Value returned by function
		 *
		 * @see flat_map
		 * @see map
		 * @since 0.11.4
		 */
		[CCode (cname = "gee_future_light_map_fixed", ordering = 10, vfunc_name = "light_map_fixed")]
		public virtual Gee.Future<A> light_map<A> (owned Gee.Future.LightMapFunc<A,G> func);
		[CCode (cname = "gee_future_light_map", ordering = 4, vfunc_name = "light_map")]
		public virtual Gee.Future<A> light_map_broken<A> (Gee.Future.LightMapFunc<A,G> func);
		/**
		 * Maps a future value to another value by a function and returns the
		 * another value in future.
		 *
		 * Note: As time taken by function might not contribute to
		 *   {@link wait_until} and the implementation is allowed to compute
		 *   value eagerly by {@link wait_async} it is recommended to use
		 *   {@link task} and {@link flat_map} for longer computation.
		 *
		 * @param func Function applied to {@link value}
		 * @return Value returned by function
		 *
		 * @see flat_map
		 * @see light_map
		 */
		[CCode (ordering = 3)]
		public virtual Gee.Future<A> map<A> (owned Gee.Future.MapFunc<A,G> func);
		/**
		 * Waits until the value is ready.
		 *
		 * @return The {@link value} associated with future
		 * @see ready
		 * @see wait_until
		 * @see wait_async
		 */
		[CCode (ordering = 0)]
		public abstract unowned G wait () throws Gee.FutureError;
		/**
		 * Reschedules the callback until the {@link value} is available.
		 *
		 * @return The {@link value} associated with future
		 * @see ready
		 * @see wait
		 * @see wait_until
		 */
		[CCode (ordering = 2)]
		public abstract async unowned G wait_async () throws Gee.FutureError;
		/**
		 * Waits until the value is ready or deadline have passed.
		 *
		 * @param end_time The time when the wait should finish
		 * @param value The {@link value} associated with future if the wait was successful
		 * @return ``true`` if the value was ready within deadline or ``false`` otherwise
		 * @see ready
		 * @see wait
		 * @see wait_async
		 */
		[CCode (ordering = 1)]
		public abstract bool wait_until (int64 end_time, out unowned G value = null) throws Gee.FutureError;
		/**
		 * Combines values of two futures using a function returning the combined
		 * value in future (call does not block).
		 *
		 * Note: As time taken by function does not contribute to
		 *   {@link wait_until} and the implementation is allowed to compute
		 *   value eagerly by {@link wait_async} it is recommended to return a
		 *   future from {@link task} and use {@link flat_map} for longer computation.
		 *
		 * @param zip_func Function applied to values
		 * @param second Second parameter
		 * @return A combine value
		 * @since 0.11.4
		 */
		[CCode (ordering = 5)]
		public virtual Gee.Future<B> zip<A,B> (owned Gee.Future.ZipFunc<G,A,B> zip_func, Gee.Future<A> second);
		/**
		 * Checks the exception that have been set. I.e. if the computation
		 * has thrown the exception it should be set here and the {@link wait},
		 * {@link wait_until} and {@link wait_async} should throw
		 * {@link FutureError.EXCEPTION}.
		 *
		 * @since 0.11.5
		 */
		[CCode (ordering = 9)]
		public abstract GLib.Error? exception { get; }
		/**
		 * Checks if value is ready. If it is calls to {@link wait} and
		 * {@link wait_until} will not block and value is returned immediately.
		 */
		[CCode (ordering = 8)]
		public abstract bool ready { get; }
		/**
		 * The value associated with Future. If value is not ready getting value
		 * will block until value is ready.
		 *
		 * Returned value is always the same and it is alive at least as long
		 * as the future.
		 */
		[CCode (ordering = 7)]
		public new virtual G value { get; }
	}
	/**
	 * This interface defines a hash function among instances of each class
	 * implementing it.
	 *
	 * @see Comparable
	 */
	[CCode (cheader_filename = "gee.h")]
	public interface Hashable<G> : GLib.Object {
		/**
		 * Compares this object with the specified object. This defines the
		 * equivalence relation between them.
		 *
		 * In other words:
		 *
		 *  * It must be reflexive: for all objects `a` it holds that
		 *    `a.equal_to(a)`.
		 *  * It must be symmetric: for all objects `a` and `b` if
		 *    `a.equal_to(b)` then `b.equal_to(a)`.
		 *  * It must be transitive: if `a.equal_to(b)` and `b.equal_to(c)` then
		 *    `a.equal_to(c)`.
		 *
		 * Note: Relationship //must not// change during lifetime of an object.
		 *
		 * @param object Object this objest is compared with
		 * @return true if objects are equal
		 */
		public abstract bool equal_to (G object);
		/**
		 * Computes hash for an objects. Two hashes of equal objects have to be
		 * equal.
		 *
		 * Note: Hash //must not// change during lifetime of an object.
		 *
		 * @return hash of an object
		 */
		public abstract uint hash ();
	}
	/**
	 * An object that can provide an {@link Iterator}.
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface Iterable<G> : GLib.Object, Gee.Traversable<G> {
		/**
		 * Returns a {@link Iterator} that can be used for simple iteration over a
		 * collection.
		 *
		 * @return a {@link Iterator} that can be used for simple iteration over a
		 *         collection
		 */
		public abstract Gee.Iterator<G> iterator ();
	}
	/**
	 * An iterator over a collection.
	 *
	 * Gee's iterators are "on-track" iterators. They always point to an item
	 * except before the first call to {@link next}, or, when an
	 * item has been removed, until the next call to {@link next}.
	 *
	 * Please note that when the iterator is out of track, neither {@link get} nor
	 * {@link remove} are defined and both might fail. After the next call to
	 * {@link next}, they will be defined again.
	 *
	 * Please also note that, unless specified otherwise, iterators before iteration
	 * started should behave as if after deletion of the first element. Whenever
	 * documentation states about the iterator 'out of track', 'invalid' or
	 * 'in-between elements' this refers to the same concept.
	 */
	[CCode (cheader_filename = "gee.h")]
	public interface Iterator<G> : GLib.Object, Gee.Traversable<G> {
		/**
		 * Concatenate iterators.
		 *
		 * @param iters Iterators of iterators
		 * @return Iterator containing values of each iterator
		 */
		public static Gee.Iterator<G> concat<G> (Gee.Iterator<Gee.Iterator<G>> iters);
		/**
		 * Returns the current element in the iteration.
		 *
		 * @return the current element in the iteration
		 */
		public abstract G @get ();
		/**
		 * Checks whether there is a next element in the iteration.
		 *
		 * @return ``true`` if the iterator has a next element
		 */
		public abstract bool has_next ();
		/**
		 * Advances to the next element in the iteration.
		 *
		 * @return ``true`` if the iterator has a next element
		 */
		public abstract bool next ();
		/**
		 * Removes the current element in the iteration. The cursor is set in an
		 * in-between state. Both {@link get} and {@link remove} will fail until
		 * the next move of the cursor (calling {@link next}).
		 */
		public abstract void remove ();
		/**
		 * Create iterator from unfolding function. The lazy value is
		 * force-evaluated before progressing to next element.
		 *
		 * @param f Unfolding function
		 * @param current If iterator is to be valid it contains the current value of it
		 */
		public static Gee.Iterator<A> unfold<A> (owned Gee.UnfoldFunc<A> f, owned Gee.Lazy<G>? current = null);
		/**
		 * Determines whether the call to {@link remove} is legal assuming the
		 * iterator is valid. The value must not change in runtime hence the user
		 * of iterator may cache it.
		 */
		public abstract bool read_only { get; }
		/**
		 * Determines whether the call to {@link get} is legal. It is false at the
		 * beginning and after {@link remove} call and true otherwise.
		 */
		public abstract bool valid { get; }
	}
	/**
	 * An ordered collection.
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface List<G> : Gee.Collection<G> {
		/**
		 * Returns an immutable empty list.
		 *
		 * @return an immutable empty list
		 */
		public static Gee.List<G> empty<G> ();
		/**
		 * Returns the first item of the list. Fails if the list is empty.
		 *
		 * @return      first item in the list
		 */
		public virtual G first ();
		/**
		 * Returns the item at the specified index in this list.
		 *
		 * @param index zero-based index of the item to be returned
		 *
		 * @return      the item at the specified index in the list
		 */
		public abstract G @get (int index);
		/**
		 * Returns the index of the first occurrence of the specified item in
		 * this list.
		 *
		 * @return the index of the first occurrence of the specified item, or
		 *         -1 if the item could not be found
		 */
		public abstract int index_of (G item);
		/**
		 * Inserts an item into this list at the specified position.
		 *
		 * @param index zero-based index at which item is inserted
		 * @param item  item to insert into the list
		 */
		public abstract void insert (int index, G item);
		/**
		 * Inserts items into this list for the input collection at the
		 * specified position.
		 *
		 * @param index zero-based index of the items to be inserted
		 * @param collection collection of items to be inserted
		 */
		public virtual void insert_all (int index, Gee.Collection<G> collection);
		/**
		 * Returns the last item of the list. Fails if the list is empty.
		 *
		 * @return      last item in the list
		 */
		public virtual G last ();
		/**
		 * Returns a ListIterator that can be used for iteration over this list.
		 *
		 * @return a ListIterator that can be used for iteration over this list
		 */
		public new abstract Gee.ListIterator<G> list_iterator ();
		/**
		 * Removes the item at the specified index of this list.
		 *
		 * @param index zero-based index of the item to be removed
		 *
		 * @return      the removed element
		 */
		public abstract G remove_at (int index);
		/**
		 * Sets the item at the specified index in this list.
		 *
		 * @param index zero-based index of the item to be set
		 */
		public abstract void @set (int index, G item);
		/**
		 * Returns a slice of this list.
		 *
		 * @param start zero-based index of the slice's first element
		 * @param stop  zero-based index of the position after the end of the slice
		 *
		 * @return A list containing a slice of this list
		 */
		public abstract Gee.List<G>? slice (int start, int stop);
		/**
		 * Sorts items by comparing with the specified compare function.
		 *
		 * @param compare_func compare function to use to compare items
		 */
		public virtual void sort (owned GLib.CompareDataFunc<G>? compare_func = null);
		/**
		 * The read-only view of this list.
		 */
		public new abstract Gee.List<G> read_only_view { owned get; }
	}
	/**
	 * A list iterator. This supports bi-directional and index-based iteration.
	 */
	[CCode (cheader_filename = "gee.h")]
	public interface ListIterator<G> : Gee.Iterator<G> {
		/**
		 * Adds the specified item after the current item in the iteration. The
		 * iterator is moved to the point of the new added item.
		 *
		 * Please note that if iterator points in-between elements the element
		 * is added after the current element and iterator point on it.
		 */
		public abstract void add (G item);
		/**
		 * Returns the current index in the iteration.
		 *
		 * @return the current index
		 */
		public abstract int index ();
		/**
		 * Sets the current item in the iteration to the specified new item.
		 */
		public abstract void @set (G item);
	}
	/**
	 * An object that maps keys to values.
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface Map<K,V> : GLib.Object, Gee.Iterable<Gee.Map.Entry<K,V>> {
		/**
		 * An entry of a map.
		 */
		public abstract class Entry<K,V> : GLib.Object {
			protected Entry ();
			/**
			 * The key of this entry.
			 */
			public abstract K key { get; }
			/**
			 * ``true`` if the setting value is permitted.
			 */
			public abstract bool read_only { get; }
			/**
			 * The value of this entry.
			 */
			public abstract V value { get; set; }
		}
		/**
		 * Removes all items from this collection. Must not be called on
		 * read-only collections.
		 */
		public abstract void clear ();
		/**
		 * Determines whether this map contains the specified key.
		 *
		 * @param key the key to locate in the map
		 *
		 * @return    ``true`` if key is found, ``false`` otherwise
		 */
		[Version (deprecated = true, replacement = "Map.has_key")]
		public bool contains (K key);
		/**
		 * Returns ``true`` if this map contains all the same items as the input
		 * map.
		 *
		 * @param map the map which items will be compared with this map
		 */
		[Version (deprecated = true, replacement = "Map.has_all")]
		public bool contains_all (Gee.Map<K,V> map);
		/**
		 * Returns an immutable empty map.
		 *
		 * @return an immutable empty map
		 */
		public static Gee.Map<K,V> empty<K,V> ();
		/**
		 * Returns the value of the specified key in this map.
		 *
		 * @param key the key whose value is to be retrieved
		 *
		 * @return    the value associated with the key, or ``null`` if the key
		 *            couldn't be found
		 */
		public abstract V @get (K key);
		/**
		 * Determines whether this map has the specified key/value entry.
		 *
		 * @param key the key to locate in the map
		 * @param value the corresponding value
		 *
		 * @return    ``true`` if key is found, ``false`` otherwise
		 */
		public abstract bool has (K key, V value);
		/**
		 * Returns ``true`` if this map contains all the same items as the input
		 * map.
		 *
		 * @param map the map which items will be compared with this map
		 */
		public virtual bool has_all (Gee.Map<K,V> map);
		/**
		 * Determines whether this map has the specified key.
		 *
		 * @param key the key to locate in the map
		 *
		 * @return    ``true`` if key is found, ``false`` otherwise
		 */
		public abstract bool has_key (K key);
		/**
		 * Returns an iterator for this map.
		 *
		 * @return a map iterator
		 */
		public abstract Gee.MapIterator<K,V> map_iterator ();
		/**
		 * Removes the specified key from this map.
		 *
		 * @param key   the key to remove from the map
		 * @param value the receiver variable for the removed value
		 *
		 * @return    ``true`` if the map has been changed, ``false`` otherwise
		 */
		[Version (deprecated = true, replacement = "Map.unset")]
		public bool remove (K key, out V value = null);
		/**
		 * Removes all items from this map that are common to the input map
		 * and this map.
		 *
		 * @param map the map which common items are deleted from this map
		 */
		[Version (deprecated = true, replacement = "Map.unset_all")]
		public bool remove_all (Gee.Map<K,V> map);
		/**
		 * Inserts a new key and value into this map.
		 *
		 * @param key   the key to insert
		 * @param value the value to associate with the key
		 */
		public abstract void @set (K key, V value);
		/**
		 * Inserts all items that are contained in the input map to this map.
		 *
		 * @param map the map which items are inserted to this map
		 */
		public virtual void set_all (Gee.Map<K,V> map);
		/**
		 * Removes the specified key from this map.
		 *
		 * @param key   the key to remove from the map
		 * @param value the receiver variable for the removed value
		 *
		 * @return    ``true`` if the map has been changed, ``false`` otherwise
		 */
		public abstract bool unset (K key, out V value = null);
		/**
		 * Removes all items from this map that are common to the input map
		 * and this map.
		 *
		 * @param map the map which common items are deleted from this map
		 */
		public virtual bool unset_all (Gee.Map<K,V> map);
		/**
		 * The read-only view of the entries of this map.
		 */
		public abstract Gee.Set<Gee.Map.Entry<K,V>> entries { owned get; }
		/**
		 * Specifies whether this map is empty.
		 */
		public virtual bool is_empty { get; }
		/**
		 * The type of the keys in this map.
		 */
		public GLib.Type key_type { get; }
		/**
		 * The read-only view of the keys of this map.
		 */
		public abstract Gee.Set<K> keys { owned get; }
		/**
		 * Specifies whether this collection can change - i.e. whether {@link set},
		 * {@link remove} etc. are legal operations.
		 */
		public abstract bool read_only { get; }
		/**
		 * The read-only view this map.
		 */
		public abstract Gee.Map<K,V> read_only_view { owned get; }
		/**
		 * The number of items in this map.
		 */
		public abstract int size { get; }
		/**
		 * The type of the values in this map.
		 */
		public GLib.Type value_type { get; }
		/**
		 * The read-only view of the values of this map.
		 */
		public abstract Gee.Collection<V> values { owned get; }
	}
	/**
	 * An iterator over a map.
	 *
	 * Gee's iterators are "on-track" iterators. They always point to an item
	 * except before the first call to {@link next}, or, when an
	 * item has been removed, until the next call to {@link next}.
	 *
	 * Please note that when the iterator is out of track, neither {@link get_key},
	 * {@link get_value}, {@link set_value} nor {@link unset} are defined and all
	 * will fail. After the next call to {@link next}, they will
	 * be defined again.
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface MapIterator<K,V> : GLib.Object {
		/**
		 * Standard aggregation function.
		 *
		 * It takes a function, seed and first element, returns the new seed and
		 * progress to next element when the operation repeats.
		 *
		 * Operation moves the iterator to last element in iteration. If iterator
		 * points at some element it will be included in iteration.
		 */
		public virtual A fold<A> (Gee.FoldMapFunc<A,K,V> f, owned A seed);
		/**
		 * Apply function to each element returned by iterator. 
		 *
		 * Operation moves the iterator to last element in iteration. If iterator
		 * points at some element it will be included in iteration.
		 */
		public new virtual bool @foreach (Gee.ForallMapFunc<K,V> f);
		/**
		 * Returns the current key in the iteration.
		 *
		 * @return the current key in the iteration
		 */
		public abstract K get_key ();
		/**
		 * Returns the value associated with the current key in the iteration.
		 *
		 * @return the value for the current key
		 */
		public abstract V get_value ();
		/**
		 * Checks whether there is a next entry in the iteration.
		 *
		 * @return ``true`` if the iterator has a next entry
		 */
		public abstract bool has_next ();
		/**
		 * Advances to the next entry in the iteration.
		 *
		 * @return ``true`` if the iterator has a next entry
		 */
		public abstract bool next ();
		/**
		 * Sets the value associated with the current key in the iteration.
		 *
		 * @param value the new value for the current key
		 */
		public abstract void set_value (V value);
		/**
		 * Unsets the current entry in the iteration. The cursor is set in an
		 * in-between state. {@link get_key}, {@link get_value}, {@link set_value}
		 * and {@link unset} will fail until the next move of the cursor (calling
		 * {@link next}).
		 */
		public abstract void unset ();
		/**
		 * Determines whether the call to {@link set_value} is legal assuming the
		 * iterator is valid. The value must not change in runtime hence the user
		 * of iterator may cache it.
		 */
		public abstract bool mutable { get; }
		/**
		 * Determines whether the call to {@link unset} is legal assuming the
		 * iterator is valid. The value must not change in runtime hence the user
		 * of iterator may cache it.
		 */
		public abstract bool read_only { get; }
		/**
		 * Determines whether the call to {@link get_key}, {@link get_value} and
		 * {@link set_value} is legal. It is false at the beginning and after
		 * {@link unset} call and true otherwise.
		 */
		public abstract bool valid { get; }
	}
	/**
	 * A map with multiple values per key.
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface MultiMap<K,V> : GLib.Object {
		/**
		 * Removes all items from this collection.
		 */
		public abstract void clear ();
		/**
		 * Determines whether this map contains the specified key.
		 *
		 * @param key the key to locate in the map
		 *
		 * @return    ``true`` if key is found, ``false`` otherwise
		 */
		public abstract bool contains (K key);
		/**
		 * Returns the values for the specified key in this map.
		 *
		 * @param key the key whose values are to be retrieved
		 *
		 * @return    a Collection of values associated with the given key
		 */
		public abstract Gee.Collection<V> @get (K key);
		/**
		 * Returns the keys of this multimap as a read-only set.
		 *
		 * @return the keys of the map
		 */
		public abstract Gee.MultiSet<K> get_all_keys ();
		/**
		 * Returns the keys of this multimap as a read-only set.
		 *
		 * @return the keys of the map
		 */
		public abstract Gee.Set<K> get_keys ();
		/**
		 * Returns the values of this map as a read-only collection.
		 *
		 * @return the values of the map
		 */
		public abstract Gee.Collection<V> get_values ();
		/**
		 * Returns an iterator for this map.
		 *
		 * @return a map iterator
		 */
		public abstract Gee.MapIterator<K,V> map_iterator ();
		/**
		 * Removes the specified key/value pair from this multimap.
		 *
		 * @param key   the key to remove from the map
		 * @param value the value to remove from the map
		 *
		 * @return      ``true`` if the map has been changed, ``false`` otherwise
		 */
		public abstract bool remove (K key, V value);
		/**
		 * Removes the specified key and all the associated values from this
		 * multimap.
		 *
		 * @param key the key to remove from the map
		 *
		 * @return    ``true`` if the map has been changed, ``false`` otherwise
		 */
		public abstract bool remove_all (K key);
		/**
		 * Inserts a key/value pair into this map.
		 *
		 * @param key   the key to insert
		 * @param value the value to associate with the key
		 */
		public abstract void @set (K key, V value);
		/**
		 * The type of the keys in this multimap.
		 */
		public GLib.Type key_type { get; }
		/**
		 * Specifies whether this collection can change - i.e. whether {@link set},
		 * {@link remove} etc. are legal operations.
		 */
		public abstract bool read_only { get; }
		public virtual Gee.MultiMap<K,V> read_only_view { owned get; }
		/**
		 * The number of key/value pairs in this map.
		 */
		public abstract int size { get; }
		/**
		 * The type of the values in this multimap.
		 */
		public GLib.Type value_type { get; }
	}
	/**
	 * A collection with duplicate elements.
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface MultiSet<G> : Gee.Collection<G> {
		/**
		 * Returns the number of occurrences of an item in this multiset.
		 *
		 * @param item the item to count occurrences of
		 *
		 * @return     the number of occurrences of the item in this multiset.
		 */
		public abstract int count (G item);
		/**
		 * Returns an immutable empty set.
		 *
		 * @return an immutable empty set
		 */
		public static Gee.Set<G> empty<G> ();
		/**
		 * The read-only view of this set.
		 */
		public new virtual Gee.MultiSet<G> read_only_view { owned get; }
	}
	/**
	 * A collection designed for holding elements prior to processing.
	 *
	 * Although all Queue implementations do not limit the amount of elements they
	 * can contain, this interface supports for capacity-bounded queues. When
	 * capacity is not bound, then the {@link capacity} and
	 * {@link remaining_capacity} both return {@link UNBOUNDED_CAPACITY}.
	 *
	 * This interface defines methods that will never fail whatever the state of
	 * the queue is. For capacity-bounded queues, those methods will either return
	 * ``false`` or ``null`` to specify that the insert or retrieval did not occur
	 * because the queue was full or empty.
	 *
	 * Queue implementations are not limited to First-In-First-Out behavior and can
	 * offer different orderings of their elements. Each Queue implementation must
	 * specify how it orders its elements.
	 *
	 * Queue implementations do not allow insertion of ``null`` elements, although
	 * some implementations, such as {@link LinkedList}, do not prohibit insertion
	 * of ``null``. Even in the implementations that permit it, ``null`` should not be
	 * inserted into a Queue, as ``null`` is also used as a special return value by
	 * the poll method to indicate that the queue contains no elements.
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface Queue<G> : Gee.Collection<G> {
		/**
		 * The unbounded capacity value.
		 */
		public const int UNBOUNDED_CAPACITY;
		/**
		 * Drains the specified amount of elements from this queue in the specified
		 * recipient collection.
		 *
		 * @param recipient the recipient collection to drain the elements to
		 * @param amount    the amount of elements to drain
		 *
		 * @return          the amount of elements that were actually drained
		 */
		public virtual int drain (Gee.Collection<G> recipient, int amount = -1);
		/**
		 * Offers the specified element to this queue.
		 *
		 * @param element the element to offer to the queue
		 *
		 * @return        ``true`` if the element was added to the queue
		 */
		public virtual bool offer (G element);
		/**
		 * Peeks (retrieves, but not remove) an element from this queue.
		 *
		 * @return the element peeked from the queue (or ``null`` if none was
		 *         available)
		 */
		public abstract G peek ();
		/**
		 * Polls (retrieves and remove) an element from this queue.
		 *
		 * @return the element polled from the queue (or ``null`` if none was
		 *         available)
		 */
		public abstract G poll ();
		/**
		 * The capacity of this queue (or ``UNBOUNDED_CAPACITY`` if capacity is not bound).
		 */
		public abstract int capacity { get; }
		/**
		 * Specifies whether this queue is full.
		 */
		public abstract bool is_full { get; }
		/**
		 * The remaining capacity of this queue (or ``UNBOUNDED_CAPACITY`` if capacity is not
		 * bound).
		 */
		public abstract int remaining_capacity { get; }
	}
	/**
	 * A collection without duplicate elements.
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface Set<G> : Gee.Collection<G> {
		/**
		 * Returns an immutable empty set.
		 *
		 * @return an immutable empty set
		 */
		public static Gee.Set<G> empty<G> ();
		/**
		 * The read-only view of this set.
		 */
		public new abstract Gee.Set<G> read_only_view { owned get; }
	}
	[CCode (cheader_filename = "gee.h")]
	public interface SortedMap<K,V> : Gee.Map<K,V> {
		/**
		 * Returns an immutable empty map.
		 *
		 * @return an immutable empty map
		 */
		public static Gee.Map<K,V> empty<K,V> ();
		/**
		 * Returns map containing pairs with key strictly lower the the argument.
		 */
		public abstract Gee.SortedMap<K,V> head_map (K before);
		/**
		 * Returns right-open map (i.e. containing all pair which key is strictly
		 * lower then the second argument and equal or bigger then the first one).
		 *
		 * Null as one parameter means that it should include all from this side.
		 */
		public abstract Gee.SortedMap<K,V> sub_map (K before, K after);
		/**
		 * Returns map containing pairs with key equal or larger then the argument.
		 */
		public abstract Gee.SortedMap<K,V> tail_map (K after);
		/**
		 * Returns the entries in ascending order.
		 */
		public abstract Gee.SortedSet<Gee.Map.Entry<K,V>> ascending_entries { owned get; }
		/**
		 * Returns the keys in ascending order.
		 */
		public abstract Gee.SortedSet<K> ascending_keys { owned get; }
		/**
		 * The read-only view this map.
		 */
		public new abstract Gee.SortedMap<K,V> read_only_view { owned get; }
	}
	/**
	 * A sorted set, which you can navigate over and get sub-sets of.
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface SortedSet<G> : Gee.Set<G> {
		/**
		 * Returns the element which is higher or equal then the specified element.
		 *
		 * @param element the element which you want the higher or equal element
		 *                for
		 *
		 * @return        the corresponding element
		 */
		public abstract G ceil (G element);
		/**
		 * Returns an immutable empty sorted set.
		 *
		 * @return an immutable empty sorted set
		 */
		public static Gee.SortedSet<G> empty<G> ();
		/**
		 * Returns the first element of the sorted set. Set must not be empty.
		 *
		 * @return the first element in the sorted set
		 */
		public abstract G first ();
		/**
		 * Returns the element which is lower or equal then the specified element.
		 *
		 * @param element the element which you want the lower or equal element for
		 *
		 * @return        the corresponding element
		 */
		public abstract G floor (G element);
		/**
		 * Returns the sub-set of this sorted set containing elements strictly
		 * lower than the specified element.
		 *
		 * @param before the lower inclusive bound for the sub-set
		 *
		 * @return     the corresponding sub-set of this sorted set
		 */
		public abstract Gee.SortedSet<G> head_set (G before);
		/**
		 * Returns the element which is strictly higher than the specified element.
		 *
		 * @param element the element which you want the strictly higher element
		 *                for
		 *
		 * @return        the corresponding element
		 */
		public abstract G higher (G element);
		/**
		 * Returns a {@link BidirIterator} initially pointed at the specified
		 * element.
		 *
		 * @param element the element to point the iterator at
		 *
		 * @return        a {@link BidirIterator} over this sorted set, or null if
		 *                the specified element is not in this set
		 */
		public abstract Gee.Iterator<G>? iterator_at (G element);
		/**
		 * Returns the last element of the sorted set. Set must not be empty.
		 *
		 * @return the last element in the sorted set
		 */
		public abstract G last ();
		/**
		 * Returns the element which is strictly lower than the specified element.
		 *
		 * @param element the element which you want the lower element for
		 *
		 * @return        the corresponding element
		 */
		public abstract G lower (G element);
		/**
		 * Returns the right-open sub-set of this sorted set, thus containing
		 * elements equal or higher than the specified ``from`` element, and stricly
		 * lower than the specified ``to`` element.
		 *
		 * @param from the lower inclusive bound for the sub-set
		 * @param to   the higher exclusive bound for the sub-set
		 *
		 * @return     the corresponding sub-set of this sorted set
		 */
		public abstract Gee.SortedSet<G> sub_set (G from, G to);
		/**
		 * Returns the sub-set of this sorted set containing elements equal or
		 * higher than the specified element.
		 *
		 * @param after the higher exclusive bound for the sub-set
		 *
		 * @return   the corresponding sub-set of this sorted set
		 */
		public abstract Gee.SortedSet<G> tail_set (G after);
		/**
		 * The read-only view of this set.
		 */
		public new abstract Gee.SortedSet<G> read_only_view { owned get; }
	}
	/**
	 * It's a common interface for {@link Iterator} and {@link Iterable}. It
	 * provides a fast, high level functions.
	 *
	 * ''{@link Iterator} implementation:'' Please note that most of the functions
	 * affect the state of the iterator by moving it forward.
	 * Even if the iterator is {@link BidirIterator} it ''must not''
	 * rewind the state.
	 *
	 * ''{@link Iterable} implementation:'' validy ({@link Iterator.valid})
	 * of returned iterator is the same as for invalid
	 * iterator. In other words the following code is semantically equivalent:
	 *
	 * {{{
	 *     var x = iterable.function (args);
	 *     var x = iterable.iterator ().function(args);
	 * }}}
	 *
	 * @since 0.7.0
	 */
	[CCode (cheader_filename = "gee.h")]
	[GenericAccessors]
	public interface Traversable<G> : GLib.Object {
		public enum Stream {
			YIELD,
			CONTINUE,
			END,
			WAIT
		}
		/**
		 * Checks whether all elements match the given predicate.
		 *
		 * @param pred Predicate to be called to check for matches
		 * @return Whether all elements match or not
		 * @since 0.19.91
		 */
		[CCode (ordering = 12)]
		public virtual bool all_match (owned Gee.Predicate<G> pred);
		/**
		 * Returns whether any element matches the given predicate.
		 *
		 * This is similar to @first_match, with the difference that it
		 * just returns whether there is a match or not, not the value
		 * of the match.
		 *
		 * @param pred Predicate to be called to check for matches
		 * @return Whether there was a match or not
		 * @since 0.19.91
		 */
		[CCode (ordering = 11)]
		public virtual bool any_match (owned Gee.Predicate<G> pred);
		/**
		 * Creates a new iterator which contains elements from iterable. The
		 * first argument states the offset i.e. number of elements the iterator
		 * skips by default.
		 *
		 * Note: In {@link Iterator} implementation resulting iterator is
		 *    {@link Iterator.valid} when parent iterator is
		 *    {@link Iterator.valid} and the offset is 0. Using the parent
		 *    iterator is not allowed before the inner iterator
		 *    {@link Iterator.next} return false and then it points on its last
		 *    element.
		 *
		 * @param offset the offset to first element the iterator is pointing to
		 * @param length maximum number of elements iterator may return. Negative
		 *        value means that the number is unbounded
		 */
		[CCode (ordering = 6)]
		public virtual Gee.Iterator<G> chop (int offset, int length = -1);
		/**
		 * Creates a new iterator that contains only values that fulfills the
		 * predicate.
		 *
		 * Note: When the method is called on {@link Iterator} using the parent
		 *    iterator is not allowed before the inner iterator
		 *    {@link Iterator.next} return false and then it points on its last
		 *    element. The resulting iterator is {@link Iterator.valid} if parent
		 *    iterator is {@link Iterator.valid} and value it is pointing at
		 *    fulfills the predicate.
		 *
		 * @param pred predicate to check should the value be retained
		 * @return Iterator containing values of subsequent values of seed
		 */
		[CCode (ordering = 5)]
		public virtual Gee.Iterator<G> filter (owned Gee.Predicate<G> pred);
		/**
		 * Returns the first element that matches a given condition
		 *
		 * @param pred Predicate to be called to check for matches
		 * @return The first element that matches or null
		 * @since 0.19.91
		 */
		[CCode (ordering = 10)]
		public virtual G first_match (owned Gee.Predicate<G> pred);
		/**
		 * A fused concatenate and map. The function is applied to each element
		 * of iteration and the resulting values are concatenated.
		 *
		 * The iterator is lazy evaluated but value is force-evaluated when
		 * iterator is moved to next value.
		 *
		 * Note: Default implementation uses {@link stream}.
		 *
		 * Note: In {@link Iterator} implementation if the parent iterator is
		 *    {@link Iterator.valid} and function returns a valid iterator the
		 *    resulting iterator is also valid. Using the parent iterator is not
		 *    allowed before the inner iterator {@link Iterator.next}
		 *    return false and then it points on its last element.
		 *
		 * @since 0.11.1
		 * @param f mapping function
		 * @return Iterator over returned values
		 */
		[CCode (ordering = 8)]
		public virtual Gee.Iterator<A> flat_map<A> (owned Gee.FlatMapFunc<A,G> f);
		/**
		 * Standard aggregation function.
		 *
		 * It takes a function, seed and first element, returns the new seed and
		 * progress to next element when the operation repeats.
		 *
		 * Note: Default implementation uses {@link foreach}.
		 *
		 * Note: In {@link Iterator} implementation operation moves the
		 *    iterator to last element in iteration. If iterator is
		 *    {@link Iterator.valid} the current element will be considered
		 *    as well.
		 *
		 */
		[CCode (ordering = 2)]
		public virtual A fold<A> (Gee.FoldFunc<A,G> f, owned A seed);
		/**
		 * Apply function to each element returned by iterator until last element
		 * or function return ''false''.
		 *
		 * ''{@link Iterator} implementation:'' Operation moves the iterator
		 * to last element in iteration or the first element that returned ''false''.
		 * If iterator points at some element it will be included in iteration.
		 *
		 * @param f function applied to every element of the collection
		 *
		 * @return ''false'' if the argument returned ''false'' at last invocation and
		 *         ''true'' otherwise.
		 */
		[CCode (ordering = 0)]
		public new abstract bool @foreach (Gee.ForallFunc<G> f);
		/**
		 * Produces an iterator pointing at elements generated by function passed.
		 *
		 * Iterator is lazy evaluated but value is force-evaluated when
		 * iterator moves to next element. ({@link Iterator.next})
		 *
		 * Note: Default implementation uses {@link stream}.
		 *
		 * Note: In {@link Iterator} implementation if the parent iterator is
		 *    {@link Iterator.valid} so is the returned one. Using the parent
		 *    iterator is not allowed before the inner iterator {@link Iterator.next}
		 *    return false and then it points on its last element.
		 *    The resulting iterator is {@link Iterator.valid} if the parent
		 *    iterator is.
		 *
		 * @param f Mapping function
		 * @return Iterator listing mapped value
		 */
		[CCode (ordering = 3)]
		public virtual Gee.Iterator<A> map<A> (Gee.MapFunc<A,G> f);
		/**
		 * Returns the item in the sequence that contains the max value
		 * based on the given compare function.
		 *
		 * @param compare Function to be called for comparisons
		 * @return The item containing the max value.
		 * @since 0.19.91
		 */
		[CCode (ordering = 13)]
		public virtual G max (owned GLib.CompareDataFunc<G> compare);
		/**
		 * Returns the item in the sequence that contains the min value
		 * based on the given compare function.
		 *
		 * @param compare Function to be called for comparisons
		 * @return The item containing the min value.
		 * @since 0.19.91
		 */
		[CCode (ordering = 14)]
		public virtual G min (owned GLib.CompareDataFunc<G> compare);
		/**
		 * Returns a new iterator containing the elements in the source
		 * ordered as specified by the comparison function.
		 *
		 * @param compare Comparison function
		 * @return A new iterator with the source elements sorted.
		 * @since 0.19.91
		 */
		[CCode (ordering = 15)]
		public virtual Gee.Iterator<G> order_by (owned GLib.CompareDataFunc<G>? compare = null);
		/**
		 * Creates a new iterator that is initially pointing to seed. Then
		 * subsequent values are obtained after applying the function to previous
		 * value and the subsequent items.
		 *
		 * The resulting iterator is always valid and it contains the seed value.
		 *
		 * Note: Default implementation uses {@link stream}.
		 *
		 * Note: When the method is called on {@link Iterator}, using the parent
		 *    iterator is not allowed before the inner iterator
		 *    {@link Iterator.next} returns false and then it points to its last
		 *    element. The resulting iterator is {@link Iterator.valid}.
		 *
		 * @param f Folding function
		 * @param seed original seed value
		 * @return Iterator containing values of subsequent values of seed
		 */
		[CCode (ordering = 4)]
		public virtual Gee.Iterator<A> scan<A> (Gee.FoldFunc<A,G> f, owned A seed);
		/**
		 * Stream function is an abstract function allowing writing many
		 * operations.
		 *
		 * The stream function accepts three parameter:
		 *
		 *   1. state. It is usually the last returned value from function but
		 *      it may be {@link Stream.END} when {@link Stream.CONTINUE} was
		 *      returned and there was no more elements.
		 *   1. input. It is valid only if first argument is
		 *      {@link Stream.CONTINUE}
		 *   1. output. It is valid only if result is Stream.YIELD
		 *
		 * It may return one of 3 results:
		 *
		 *   1. {@link Stream.YIELD}. It means that value was yielded and can
		 *      be passed to outgoing iterator.
		 *   1. {@link Stream.CONTINUE}. It means that the function needs to be
		 *      called with next element or with {@link Stream.END} if it is
		 *      end of stream). If the state element was Stream.END during the
		 *      current iteration function ''must not'' return {@link Stream.CONTINUE}.
		 *   1. {@link Stream.WAIT}. Simply denotes that iterator should skip an element.
		 *      Usually the function is called once again with {@link Stream.WAIT} as
		 *      state however it do affect the initial validity of iterator.
		 *   1. {@link Stream.END}. It means that the last argument was yielded.
		 *
		 * If the function yields the value immediately then the returning iterator
		 * is {@link Iterator.valid} and points to this value as well as in case when the
		 * parent iterator is {@link Iterator.valid} and function yields
		 * after consuming 1 input. In other case returned iterator is invalid including
		 * when the first value returned is {@link Stream.WAIT}.
		 *
		 * Note: In {@link Iterator} implementation: if iterator is
		 *    {@link Iterator.valid} the current value should be fed
		 *    immediately to function if during initial call function returns
		 *    {@link Stream.CONTINUE}. The parent iterator cannot be used before
		 *    the functions return {@link Stream.END} afterwards it points on the
		 *    last element consumed.
		 *
		 * @param f function generating stream
		 * @return iterator containing values yielded by stream
		 */
		[CCode (ordering = 1)]
		public virtual Gee.Iterator<A> stream<A> (owned Gee.StreamFunc<G,A> f);
		/**
		 * Splits the traversable into multiple ones, caching the result if needed.
		 *
		 * Note: In {@link Iterator} implementation using the parent iterator is
		 *   not allowed. However if any of the forked iterators {@link Iterator.next}
		 *   return false then it is treated as if the parent iterator
		 *   {@link Iterator.next} returned false.
		 *
		 * Note: The returned arrey might contain parent iterator if it is allowed
		 *   by implementation. For example the iteration over collection does
		 *   not need to generate and cache the results.
		 *   In such case it is recommended to return the value as the first element
		 *   of the array. This allows the consumer to check just the first element
		 *   if it can perform optimizations for such case. However it //must// not
		 *   depend on the order (that's for optimization only).
		 *
		 * Note: The resulting iterators does not need to be thread safe.
		 *
		 * @param forks Number of iterators in array
		 * @return An array with created iterators
		 * @since 0.11.5
		 */
		[CCode (ordering = 9)]
		public virtual Gee.Iterator<G>[] tee (uint forks);
		/**
		 * The type of the elements in this collection.
		 */
		[CCode (ordering = 7)]
		public virtual GLib.Type element_type { get; }
	}
	[CCode (cheader_filename = "gee.h")]
	public errordomain FutureError {
		/**
		 * The promise have been abandon - this indicates an error in program.
		 */
		ABANDON_PROMISE,
		/**
		 * Exception field has been set.
		 */
		EXCEPTION
	}
	/**
	 * A function comparing two object defining equivalence relationship.
	 *
	 * In other words if `equal_to` is `EqualDataFunc` then:
	 *
	 *  * It must be reflexive: for all objects `a` it holds that
	 *    `equal_to(a, a)`.
	 *  * It must be symmetric: for all objects `a` and `b` if
	 *    `equal_to(a, b)` then `equal_to(b, a)`.
	 *  * It must be transitive: if `equal_to(a, b)` and `equal_to(b, c)`
	 *    then `equal_to(a, c)`
	 *
	 * Note: The relationship //must not// change during lifetime of the
	 *   delegate.
	 *
	 * @param a First value
	 * @param b Second value
	 * @return Whether values are equal
	 *
	 * @see Hashable
	 */
	[CCode (cheader_filename = "gee.h")]
	public delegate bool EqualDataFunc<T> (T a, T b);
	[CCode (cheader_filename = "gee.h")]
	public delegate Gee.Iterator<A> FlatMapFunc<A,G> (owned G g);
	[CCode (cheader_filename = "gee.h")]
	public delegate A FoldFunc<A,G> (owned G g, owned A a);
	[CCode (cheader_filename = "gee.h")]
	public delegate A FoldMapFunc<A,K,V> (K k, V v, owned A a);
	[CCode (cheader_filename = "gee.h")]
	public delegate bool ForallFunc<G> (owned G g);
	[CCode (cheader_filename = "gee.h")]
	public delegate bool ForallMapFunc<K,V> (K k, V v);
	/**
	 * A function producing a hash for an object. Two hashes of equal
	 * objects (as specified by corresponding {@link EqualDataFunc}) have to
	 * be equal.
	 *
	 * Note: Hash for a given object //must not// change during the lifetime
	 *   of delegate.
	 *
	 * @param v Hashed value
	 * @return Hash for given value
	 *
	 * @see Hashable
	 */
	[CCode (cheader_filename = "gee.h")]
	public delegate uint HashDataFunc<T> (T v);
	[CCode (cheader_filename = "gee.h")]
	public delegate G LazyFunc<G> ();
	[CCode (cheader_filename = "gee.h")]
	public delegate A MapFunc<A,G> (owned G g);
	[CCode (cheader_filename = "gee.h")]
	public delegate bool Predicate<G> (G g);
	[CCode (cheader_filename = "gee.h")]
	public delegate Gee.Traversable.Stream StreamFunc<G,A> (Gee.Traversable.Stream state, owned Gee.Lazy<G>? g, out Gee.Lazy<A>? lazy);
	[CCode (cheader_filename = "gee.h", scope = "async")]
	public delegate G Task<G> ();
	[CCode (cheader_filename = "gee.h")]
	public delegate Gee.Lazy<A>? UnfoldFunc<A> ();
	/**
	 * Continues the execution asynchroniously in helper thread. Internally
	 * one of threads from pool will execute the task.
	 *
	 * Note: There is limited number of threads unless environment variable
	 *   ``GEE_NUM_THREADS`` is set to -1. It is not advised to call I/O or
	 *   block inside the taks. If necessary it is possible to create a new one
	 *   by anyther call.
	 *
	 * @see task
	 * @since 0.11.0
	 */
	[CCode (cheader_filename = "gee.h")]
	public static async void async_task () throws GLib.ThreadError;
	/**
	 * Schedules a task to execute asynchroniously. Internally one
	 * of threads from pool will execute the task.
	 *
	 * Note: There is limited number of threads unless environment variable
	 *   ``GEE_NUM_THREADS`` is set to -1. It is not advised to call I/O or
	 *   block inside the taks. If necessary it is possible to create a new one
	 *   by anyther call.
	 *
	 * @param task Task to be executed
	 * @return Future value returned by task
	 * @see async_task
	 * @since 0.11.0
	 */
	[CCode (cheader_filename = "gee.h")]
	public static Gee.Future<G> task<G> (owned Gee.Task<G> task) throws GLib.ThreadError;
}
