/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.net.InetAddress;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kafka.cluster.EndPoint;
import kafka.common.KafkaException;
import kafka.metrics.KafkaMetricsGroup;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.SocketServer$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.memory.MemoryPool;
import org.apache.kafka.common.memory.SimpleMemoryPool;
import org.apache.kafka.common.metrics.CompoundStat;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.KafkaThread;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\tue\u0001B\u0001\u0003\u0001\u001d\u0011AbU8dW\u0016$8+\u001a:wKJT!a\u0001\u0003\u0002\u000f9,Go^8sW*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001Aa\u0002\u0006\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=\u0011R\"\u0001\t\u000b\u0005E!\u0011!B;uS2\u001c\u0018BA\n\u0011\u0005\u001daunZ4j]\u001e\u0004\"!\u0006\r\u000e\u0003YQ!a\u0006\u0003\u0002\u000f5,GO]5dg&\u0011\u0011D\u0006\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\b\u0002C\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\r\r|gNZ5h+\u0005i\u0002C\u0001\u0010\"\u001b\u0005y\"B\u0001\u0011\u0005\u0003\u0019\u0019XM\u001d<fe&\u0011!e\b\u0002\f\u0017\u000647.Y\"p]\u001aLw\r\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001e\u0003\u001d\u0019wN\u001c4jO\u0002B\u0001b\u0006\u0001\u0003\u0006\u0004%\tAJ\u000b\u0002OA\u0011\u0001&M\u0007\u0002S)\u0011qC\u000b\u0006\u0003W1\naaY8n[>t'BA\u0003.\u0015\tqs&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0005\u0019qN]4\n\u0005IJ#aB'fiJL7m\u001d\u0005\ti\u0001\u0011\t\u0011)A\u0005O\u0005AQ.\u001a;sS\u000e\u001c\b\u0005\u0003\u00057\u0001\t\u0015\r\u0011\"\u00018\u0003\u0011!\u0018.\\3\u0016\u0003a\u0002\"!O\u001e\u000e\u0003iR!!\u0005\u0016\n\u0005qR$\u0001\u0002+j[\u0016D\u0001B\u0010\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\u0006i&lW\r\t\u0005\t\u0001\u0002\u0011)\u0019!C\u0001\u0003\u0006\u00112M]3eK:$\u0018.\u00197Qe>4\u0018\u000eZ3s+\u0005\u0011\u0005CA\"G\u001b\u0005!%BA#\u0005\u0003!\u0019XmY;sSRL\u0018BA$E\u0005I\u0019%/\u001a3f]RL\u0017\r\u001c)s_ZLG-\u001a:\t\u0011%\u0003!\u0011!Q\u0001\n\t\u000b1c\u0019:fI\u0016tG/[1m!J|g/\u001b3fe\u0002BQa\u0013\u0001\u0005\u00021\u000ba\u0001P5oSRtD#B'P!F\u0013\u0006C\u0001(\u0001\u001b\u0005\u0011\u0001\"B\u000eK\u0001\u0004i\u0002\"B\fK\u0001\u00049\u0003\"\u0002\u001cK\u0001\u0004A\u0004\"\u0002!K\u0001\u0004\u0011\u0005b\u0002+\u0001\u0005\u0004%I!V\u0001\u0012[\u0006D\u0018+^3vK\u0012\u0014V-];fgR\u001cX#\u0001,\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016\u0001\u00027b]\u001eT\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^1\n9\u0011J\u001c;fO\u0016\u0014\bBB0\u0001A\u0003%a+\u0001\nnCb\fV/Z;fIJ+\u0017/^3tiN\u0004\u0003bB1\u0001\u0005\u0004%I!V\u0001\u0014[\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t!\u0016\u0014\u0018\n\u001d\u0005\u0007G\u0002\u0001\u000b\u0011\u0002,\u0002)5\f\u0007pQ8o]\u0016\u001cG/[8ogB+'/\u00139!\u0011\u001d)\u0007A1A\u0005\n\u0019\fA$\\1y\u0007>tg.Z2uS>t7\u000fU3s\u0013B|e/\u001a:sS\u0012,7/F\u0001h!\u0011A7.\u001c=\u000e\u0003%T!A\u001b\u0006\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002mS\n\u0019Q*\u00199\u0011\u00059,hBA8t!\t\u0001(\"D\u0001r\u0015\t\u0011h!\u0001\u0004=e>|GOP\u0005\u0003i*\ta\u0001\u0015:fI\u00164\u0017B\u0001<x\u0005\u0019\u0019FO]5oO*\u0011AO\u0003\t\u0003\u0013eL!A\u001f\u0006\u0003\u0007%sG\u000f\u0003\u0004}\u0001\u0001\u0006IaZ\u0001\u001e[\u0006D8i\u001c8oK\u000e$\u0018n\u001c8t!\u0016\u0014\u0018\n](wKJ\u0014\u0018\u000eZ3tA!9a\u0010\u0001b\u0001\n\u0013y\u0018A\u00037pO\u000e{g\u000e^3yiV\u0011\u0011\u0011\u0001\t\u0004s\u0005\r\u0011bAA\u0003u\tQAj\\4D_:$X\r\u001f;\t\u0011\u0005%\u0001\u0001)A\u0005\u0003\u0003\t1\u0002\\8h\u0007>tG/\u001a=uA!I\u0011Q\u0002\u0001C\u0002\u0013%\u0011qB\u0001\u0011[\u0016lwN]=Q_>d7+\u001a8t_J,\"!!\u0005\u0011\u0007!\n\u0019\"C\u0002\u0002\u0016%\u0012aaU3og>\u0014\b\u0002CA\r\u0001\u0001\u0006I!!\u0005\u0002#5,Wn\u001c:z!>|GnU3og>\u0014\b\u0005C\u0005\u0002\u001e\u0001\u0011\r\u0011\"\u0003\u0002 \u0005\u0019S.Z7pef\u0004vn\u001c7EKBdW\r^3e!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,WCAA\u0011!\u0011\t\u0019#!\n\u000e\u0003)J1!a\n+\u0005)iU\r\u001e:jG:\u000bW.\u001a\u0005\t\u0003W\u0001\u0001\u0015!\u0003\u0002\"\u0005!S.Z7pef\u0004vn\u001c7EKBdW\r^3e!\u0016\u00148-\u001a8u\u001b\u0016$(/[2OC6,\u0007\u0005C\u0005\u00020\u0001\u0011\r\u0011\"\u0003\u0002 \u0005\u0001S.Z7pef\u0004vn\u001c7EKBdW\r^3e)&lW-T3ue&\u001cg*Y7f\u0011!\t\u0019\u0004\u0001Q\u0001\n\u0005\u0005\u0012!I7f[>\u0014\u0018\u0010U8pY\u0012+\u0007\u000f\\3uK\u0012$\u0016.\\3NKR\u0014\u0018n\u0019(b[\u0016\u0004\u0003\"CA\u001c\u0001\t\u0007I\u0011BA\u001d\u0003)iW-\\8ssB{w\u000e\\\u000b\u0003\u0003w\u0001B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003R\u0013AB7f[>\u0014\u00180\u0003\u0003\u0002F\u0005}\"AC'f[>\u0014\u0018\u0010U8pY\"A\u0011\u0011\n\u0001!\u0002\u0013\tY$A\u0006nK6|'/\u001f)p_2\u0004\u0003\"CA'\u0001\t\u0007I\u0011AA(\u00039\u0011X-];fgR\u001c\u0005.\u00198oK2,\"!!\u0015\u0011\u00079\u000b\u0019&C\u0002\u0002V\t\u0011aBU3rk\u0016\u001cHo\u00115b]:,G\u000e\u0003\u0005\u0002Z\u0001\u0001\u000b\u0011BA)\u0003=\u0011X-];fgR\u001c\u0005.\u00198oK2\u0004\u0003\"CA/\u0001\t\u0007I\u0011BA0\u0003)\u0001(o\\2fgN|'o]\u000b\u0003\u0003C\u0002r!a\u0019\u0002na\f\t(\u0004\u0002\u0002f)!\u0011qMA5\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003WR\u0016\u0001B;uS2LA!a\u001c\u0002f\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0011\u00079\u000b\u0019(C\u0002\u0002v\t\u0011\u0011\u0002\u0015:pG\u0016\u001c8o\u001c:\t\u0011\u0005e\u0004\u0001)A\u0005\u0003C\n1\u0002\u001d:pG\u0016\u001c8o\u001c:tA!I\u0011Q\u0010\u0001A\u0002\u0013%\u0011qP\u0001\u0010]\u0016DH\u000f\u0015:pG\u0016\u001c8o\u001c:JIV\t\u0001\u0010C\u0005\u0002\u0004\u0002\u0001\r\u0011\"\u0003\u0002\u0006\u0006\u0019b.\u001a=u!J|7-Z:t_JLEm\u0018\u0013fcR!\u0011qQAG!\rI\u0011\u0011R\u0005\u0004\u0003\u0017S!\u0001B+oSRD\u0011\"a$\u0002\u0002\u0006\u0005\t\u0019\u0001=\u0002\u0007a$\u0013\u0007C\u0004\u0002\u0014\u0002\u0001\u000b\u0015\u0002=\u0002!9,\u0007\u0010\u001e)s_\u000e,7o]8s\u0013\u0012\u0004\u0003BCAL\u0001\t\u0007I\u0011\u0001\u0002\u0002\u001a\u0006I\u0011mY2faR|'o]\u000b\u0003\u00037\u0003\u0002\"a\u0019\u0002n\u0005u\u0015\u0011\u0016\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*\u0019\u00111\u0015\u0003\u0002\u000f\rdWo\u001d;fe&!\u0011qUAQ\u0005!)e\u000e\u001a)pS:$\bc\u0001(\u0002,&\u0019\u0011Q\u0016\u0002\u0003\u0011\u0005\u001b7-\u001a9u_JD\u0001\"!-\u0001A\u0003%\u00111T\u0001\u000bC\u000e\u001cW\r\u001d;peN\u0004\u0003bCA[\u0001\u0001\u0007\t\u0019!C\u0005\u0003o\u000b\u0001cY8o]\u0016\u001cG/[8o#V|G/Y:\u0016\u0005\u0005e\u0006c\u0001(\u0002<&\u0019\u0011Q\u0018\u0002\u0003!\r{gN\\3di&|g.U;pi\u0006\u001c\bbCAa\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0007\fAcY8o]\u0016\u001cG/[8o#V|G/Y:`I\u0015\fH\u0003BAD\u0003\u000bD!\"a$\u0002@\u0006\u0005\t\u0019AA]\u0011-\tI\r\u0001a\u0001\u0002\u0003\u0006K!!/\u0002#\r|gN\\3di&|g.U;pi\u0006\u001c\b\u0005C\u0005\u0002N\u0002\u0001\r\u0011\"\u0003\u0002P\u0006I2\u000f^8qa\u0016$\u0007K]8dKN\u001c\u0018N\\4SKF,Xm\u001d;t+\t\t\t\u000eE\u0002\n\u0003'L1!!6\u000b\u0005\u001d\u0011un\u001c7fC:D\u0011\"!7\u0001\u0001\u0004%I!a7\u0002;M$x\u000e\u001d9fIB\u0013xnY3tg&twMU3rk\u0016\u001cHo]0%KF$B!a\"\u0002^\"Q\u0011qRAl\u0003\u0003\u0005\r!!5\t\u0011\u0005\u0005\b\u0001)Q\u0005\u0003#\f!d\u001d;paB,G\r\u0015:pG\u0016\u001c8/\u001b8h%\u0016\fX/Z:ug\u0002Bq!!:\u0001\t\u0003\t9/A\u0004ti\u0006\u0014H/\u001e9\u0015\u0005\u0005\u001d\u0005bBAv\u0001\u0011%\u0011Q^\u0001\nK:$\u0007o\\5oiN,\"!a<\u0011\u0011\u0005E\u0018q_A}\u0003;k!!a=\u000b\u0007\u0005U\u0018.A\u0005j[6,H/\u00192mK&\u0019A.a=\u0011\t\u0005m\u0018q`\u0007\u0003\u0003{T!a\u0001\u0016\n\t\t\u0005\u0011Q \u0002\r\u0019&\u001cH/\u001a8fe:\u000bW.\u001a\u0005\b\u0005\u000b\u0001A\u0011\u0002B\u0004\u0003m\u0019'/Z1uK\u0006\u001b7-\u001a9u_J\fe\u000e\u001a)s_\u000e,7o]8sgR1\u0011q\u0011B\u0005\u0005\u001bAqAa\u0003\u0003\u0004\u0001\u0007\u00010A\u000bqe>\u001cWm]:peN\u0004VM\u001d'jgR,g.\u001a:\t\u0011\u0005-(1\u0001a\u0001\u0005\u001f\u0001R\u0001\u001bB\t\u0003;K1Aa\u0005j\u0005\r\u0019V-\u001d\u0005\b\u0005/\u0001A\u0011\u0002B\r\u00035\tG\r\u001a)s_\u000e,7o]8sgRA\u0011q\u0011B\u000e\u0005?\u0011\u0019\u0003\u0003\u0005\u0003\u001e\tU\u0001\u0019AAU\u0003!\t7mY3qi>\u0014\b\u0002\u0003B\u0011\u0005+\u0001\r!!(\u0002\u0011\u0015tG\r]8j]RDqA!\n\u0003\u0016\u0001\u0007\u00010\u0001\roK^\u0004&o\\2fgN|'o\u001d)fe2K7\u000f^3oKJDqA!\u000b\u0001\t\u0003\t9/\u0001\fti>\u0004\bK]8dKN\u001c\u0018N\\4SKF,Xm\u001d;t\u0011\u001d\u0011i\u0003\u0001C\u0001\u0005_\t\u0001C]3tSj,G\u000b\u001b:fC\u0012\u0004vn\u001c7\u0015\r\u0005\u001d%\u0011\u0007B\u001b\u0011\u001d\u0011\u0019Da\u000bA\u0002a\fAc\u001c7e\u001dVlg*\u001a;x_J\\G\u000b\u001b:fC\u0012\u001c\bb\u0002B\u001c\u0005W\u0001\r\u0001_\u0001\u0015]\u0016<h*^7OKR<xN]6UQJ,\u0017\rZ:\t\u000f\tm\u0002\u0001\"\u0001\u0002h\u0006A1\u000f[;uI><h\u000eC\u0004\u0003@\u0001!\tA!\u0011\u0002\u0013\t|WO\u001c3Q_J$Hc\u0001=\u0003D!A!Q\tB\u001f\u0001\u0004\tI0\u0001\u0007mSN$XM\\3s\u001d\u0006lW\rC\u0004\u0003J\u0001!\tAa\u0013\u0002\u0019\u0005$G\rT5ti\u0016tWM]:\u0015\t\u0005\u001d%Q\n\u0005\t\u0005\u001f\u00129\u00051\u0001\u0003\u0010\u0005qA.[:uK:,'o]!eI\u0016$\u0007b\u0002B*\u0001\u0011\u0005!QK\u0001\u0010e\u0016lwN^3MSN$XM\\3sgR!\u0011q\u0011B,\u0011!\u0011IF!\u0015A\u0002\t=\u0011\u0001\u00057jgR,g.\u001a:t%\u0016lwN^3e\u0011!\u0011i\u0006\u0001C\t\u0005\t}\u0013\u0001\u00048foB\u0013xnY3tg>\u0014H\u0003DA9\u0005C\u0012)Ga\u001a\u0003j\tm\u0004b\u0002B2\u00057\u0002\r\u0001_\u0001\u0003S\u0012D\u0001\"!.\u0003\\\u0001\u0007\u0011\u0011\u0018\u0005\t\u0005\u000b\u0012Y\u00061\u0001\u0002z\"A!1\u000eB.\u0001\u0004\u0011i'\u0001\ttK\u000e,(/\u001b;z!J|Go\\2pYB!!q\u000eB<\u001b\t\u0011\tH\u0003\u0003\u0003t\tU\u0014\u0001B1vi\"T!!\u0012\u0016\n\t\te$\u0011\u000f\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2D\u0001\"a\u000e\u0003\\\u0001\u0007\u00111\b\u0005\t\u0005\u007f\u0002A\u0011\u0001\u0002\u0003\u0002\u0006y1m\u001c8oK\u000e$\u0018n\u001c8D_VtG\u000fF\u0002y\u0005\u0007C\u0001B!\"\u0003~\u0001\u0007!qQ\u0001\bC\u0012$'/Z:t!\u0011\u0011IIa$\u000e\u0005\t-%b\u0001BG5\u0006\u0019a.\u001a;\n\t\tE%1\u0012\u0002\f\u0013:,G/\u00113ee\u0016\u001c8\u000f\u0003\u0005\u0003\u0016\u0002!\tA\u0001BL\u0003%\u0001(o\\2fgN|'\u000f\u0006\u0003\u0002r\te\u0005b\u0002BN\u0005'\u0003\r\u0001_\u0001\u0006S:$W\r\u001f")
public class SocketServer
implements KafkaMetricsGroup {
    private final KafkaConfig config;
    private final Metrics metrics;
    private final Time time;
    private final CredentialProvider credentialProvider;
    private final Integer maxQueuedRequests;
    private final Integer maxConnectionsPerIp;
    private final Map<String, Object> maxConnectionsPerIpOverrides;
    private final LogContext logContext;
    private final Sensor memoryPoolSensor;
    private final MetricName memoryPoolDepletedPercentMetricName;
    private final MetricName memoryPoolDepletedTimeMetricName;
    private final MemoryPool kafka$network$SocketServer$$memoryPool;
    private final RequestChannel requestChannel;
    private final ConcurrentHashMap<Object, Processor> kafka$network$SocketServer$$processors;
    private int nextProcessorId;
    private final ConcurrentHashMap<EndPoint, Acceptor> acceptors;
    private ConnectionQuotas connectionQuotas;
    private boolean stoppedProcessingRequests;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public com.yammer.metrics.core.MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup.metricName$(this, name, tags);
    }

    @Override
    public com.yammer.metrics.core.MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup.explicitMetricName$(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup.newGauge$(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newMeter$(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup.newHistogram$(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup.newTimer$(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup.removeMetric$(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup.newGauge$default$3$(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup.newMeter$default$4$(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup.removeMetric$default$2$(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup.newTimer$default$4$(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup.newHistogram$default$2$(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup.newHistogram$default$3$(this);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Time time() {
        return this.time;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    private Integer maxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    private Integer maxConnectionsPerIp() {
        return this.maxConnectionsPerIp;
    }

    private Map<String, Object> maxConnectionsPerIpOverrides() {
        return this.maxConnectionsPerIpOverrides;
    }

    private LogContext logContext() {
        return this.logContext;
    }

    private Sensor memoryPoolSensor() {
        return this.memoryPoolSensor;
    }

    private MetricName memoryPoolDepletedPercentMetricName() {
        return this.memoryPoolDepletedPercentMetricName;
    }

    private MetricName memoryPoolDepletedTimeMetricName() {
        return this.memoryPoolDepletedTimeMetricName;
    }

    public MemoryPool kafka$network$SocketServer$$memoryPool() {
        return this.kafka$network$SocketServer$$memoryPool;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    public ConcurrentHashMap<Object, Processor> kafka$network$SocketServer$$processors() {
        return this.kafka$network$SocketServer$$processors;
    }

    private int nextProcessorId() {
        return this.nextProcessorId;
    }

    private void nextProcessorId_$eq(int x$1) {
        this.nextProcessorId = x$1;
    }

    public ConcurrentHashMap<EndPoint, Acceptor> acceptors() {
        return this.acceptors;
    }

    private ConnectionQuotas connectionQuotas() {
        return this.connectionQuotas;
    }

    private void connectionQuotas_$eq(ConnectionQuotas x$1) {
        this.connectionQuotas = x$1;
    }

    private boolean stoppedProcessingRequests() {
        return this.stoppedProcessingRequests;
    }

    private void stoppedProcessingRequests_$eq(boolean x$1) {
        this.stoppedProcessingRequests = x$1;
    }

    public void startup() {
        SocketServer socketServer = this;
        synchronized (socketServer) {
            this.connectionQuotas_$eq(new ConnectionQuotas(Predef$.MODULE$.Integer2int(this.maxConnectionsPerIp()), this.maxConnectionsPerIpOverrides()));
            this.createAcceptorAndProcessors(Predef$.MODULE$.Integer2int(this.config().numNetworkThreads()), this.config().listeners());
        }
        this.newGauge("NetworkProcessorAvgIdlePercent", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public double value() {
                double d;
                SocketServer socketServer = this.$outer;
                synchronized (socketServer) {
                    Iterable ioWaitRatioMetricNames = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.$outer.kafka$network$SocketServer$$processors().values()).asScala()).map((Function1 & Serializable & scala.Serializable)p -> $this.$outer.metrics().metricName("io-wait-ratio", "socket-server-metrics", p.metricTags()), Iterable$.MODULE$.canBuildFrom());
                    d = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)ioWaitRatioMetricNames.map((Function1 & Serializable & scala.Serializable)metricName -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$2(this, metricName)), Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.$outer.kafka$network$SocketServer$$processors().size();
                }
                return d;
            }

            public static final /* synthetic */ double $anonfun$value$4(KafkaMetric x$1) {
                return x$1.value();
            }

            public static final /* synthetic */ double $anonfun$value$2($anon$1 $this, MetricName metricName) {
                return BoxesRunTime.unboxToDouble((Object)Option$.MODULE$.apply((Object)$this.$outer.metrics().metric(metricName)).fold((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, (Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToDouble((double)$anon$1.$anonfun$value$4(x$1))));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$value$1(kafka.network.SocketServer$$anon$1 kafka.network.Processor ), $anonfun$value$2$adapted(kafka.network.SocketServer$$anon$1 org.apache.kafka.common.MetricName ), $anonfun$value$3(), $anonfun$value$4$adapted(org.apache.kafka.common.metrics.KafkaMetric )}, serializedLambda);
            }
        }, this.newGauge$default$3());
        this.newGauge("MemoryPoolAvailable", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public long value() {
                return this.$outer.kafka$network$SocketServer$$memoryPool().availableMemory();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("MemoryPoolUsed", new Gauge<Object>(this){
            private final /* synthetic */ SocketServer $outer;

            public long value() {
                return this.$outer.kafka$network$SocketServer$$memoryPool().size() - this.$outer.kafka$network$SocketServer$$memoryPool().availableMemory();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Started " + this.acceptors().size() + " acceptor threads");
    }

    private scala.collection.immutable.Map<ListenerName, EndPoint> endpoints() {
        return ((TraversableOnce)this.config().listeners().map((Function1 & Serializable & scala.Serializable)l -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)l.listenerName()), l), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private synchronized void createAcceptorAndProcessors(int processorsPerListener, Seq<EndPoint> endpoints) {
        Integer sendBufferSize = this.config().socketSendBufferBytes();
        Integer recvBufferSize = this.config().socketReceiveBufferBytes();
        int brokerId = this.config().brokerId();
        endpoints.foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            SocketServer.$anonfun$createAcceptorAndProcessors$1(this, processorsPerListener, sendBufferSize, recvBufferSize, brokerId, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    private synchronized void addProcessors(Acceptor acceptor, EndPoint endpoint, int newProcessorsPerListener) {
        ListenerName listenerName = endpoint.listenerName();
        SecurityProtocol securityProtocol = endpoint.securityProtocol();
        ArrayBuffer listenerProcessors = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), newProcessorsPerListener).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            Processor processor = this.newProcessor(this.nextProcessorId(), this.connectionQuotas(), listenerName, securityProtocol, this.kafka$network$SocketServer$$memoryPool());
            listenerProcessors.$plus$eq((Object)processor);
            this.requestChannel().addProcessor(processor);
            this.nextProcessorId_$eq(this.nextProcessorId() + 1);
        });
        listenerProcessors.foreach((Function1 & Serializable & scala.Serializable)p -> this.kafka$network$SocketServer$$processors().put(BoxesRunTime.boxToInteger((int)p.id()), (Processor)p));
        acceptor.addProcessors((Buffer<Processor>)listenerProcessors);
    }

    public void stopProcessingRequests() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopping socket server request processors");
        SocketServer socketServer = this;
        synchronized (socketServer) {
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.acceptors()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.shutdown();
                return BoxedUnit.UNIT;
            });
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.kafka$network$SocketServer$$processors()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
                x$3.shutdown();
                return BoxedUnit.UNIT;
            });
            this.requestChannel().clear();
            this.stoppedProcessingRequests_$eq(true);
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Stopped socket server request processors");
    }

    public synchronized void resizeThreadPool(int oldNumNetworkThreads, int newNumNetworkThreads) {
        block1: {
            block0: {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Resizing network thread pool size for each listener from ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)oldNumNetworkThreads), BoxesRunTime.boxToInteger((int)newNumNetworkThreads)})));
                if (newNumNetworkThreads <= oldNumNetworkThreads) break block0;
                ((IterableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.acceptors()).asScala()).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    SocketServer.$anonfun$resizeThreadPool$2(this, oldNumNetworkThreads, newNumNetworkThreads, x0$1);
                    return BoxedUnit.UNIT;
                });
                break block1;
            }
            if (newNumNetworkThreads >= oldNumNetworkThreads) break block1;
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.acceptors()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                x$4.removeProcessors(oldNumNetworkThreads - newNumNetworkThreads, this.requestChannel());
                return BoxedUnit.UNIT;
            });
        }
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutting down socket server");
        SocketServer socketServer = this;
        synchronized (socketServer) {
            if (!this.stoppedProcessingRequests()) {
                this.stopProcessingRequests();
            }
            this.requestChannel().shutdown();
        }
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Shutdown completed");
    }

    public int boundPort(ListenerName listenerName) {
        int n;
        try {
            n = this.acceptors().get(this.endpoints().apply((Object)listenerName)).serverChannel().socket().getLocalPort();
        }
        catch (Exception e) {
            throw new KafkaException("Tried to check server's port before server was started or checked for port of non-existing protocol", e);
        }
        return n;
    }

    public synchronized void addListeners(Seq<EndPoint> listenersAdded) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding listeners for endpoints ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listenersAdded})));
        this.createAcceptorAndProcessors(Predef$.MODULE$.Integer2int(this.config().numNetworkThreads()), listenersAdded);
    }

    public synchronized void removeListeners(Seq<EndPoint> listenersRemoved) {
        this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Removing listeners for endpoints ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listenersRemoved})));
        listenersRemoved.foreach((Function1 & Serializable & scala.Serializable)endpoint -> {
            SocketServer.$anonfun$removeListeners$2(this, endpoint);
            return BoxedUnit.UNIT;
        });
    }

    public Processor newProcessor(int id, ConnectionQuotas connectionQuotas, ListenerName listenerName, SecurityProtocol securityProtocol, MemoryPool memoryPool) {
        return new Processor(id, this.time(), Predef$.MODULE$.Integer2int(this.config().socketRequestMaxBytes()), this.requestChannel(), connectionQuotas, Predef$.MODULE$.Long2long(this.config().connectionsMaxIdleMs()), listenerName, securityProtocol, this.config(), this.metrics(), this.credentialProvider(), memoryPool, this.logContext());
    }

    public int connectionCount(InetAddress address) {
        return BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.connectionQuotas()).fold((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0, (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.get(address))));
    }

    public Processor processor(int index) {
        return this.kafka$network$SocketServer$$processors().get(BoxesRunTime.boxToInteger((int)index));
    }

    public static final /* synthetic */ void $anonfun$createAcceptorAndProcessors$1(SocketServer $this, int processorsPerListener$1, Integer sendBufferSize$1, Integer recvBufferSize$1, int brokerId$1, EndPoint endpoint) {
        ListenerName listenerName = endpoint.listenerName();
        SecurityProtocol securityProtocol = endpoint.securityProtocol();
        Acceptor acceptor = new Acceptor(endpoint, Predef$.MODULE$.Integer2int(sendBufferSize$1), Predef$.MODULE$.Integer2int(recvBufferSize$1), brokerId$1, $this.connectionQuotas());
        KafkaThread.nonDaemon((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"kafka-socket-acceptor-", "-", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{listenerName, securityProtocol, BoxesRunTime.boxToInteger((int)endpoint.port())})), (Runnable)acceptor).start();
        acceptor.awaitStartup();
        $this.acceptors().put(endpoint, acceptor);
        $this.addProcessors(acceptor, endpoint, processorsPerListener$1);
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$2(SocketServer $this, int oldNumNetworkThreads$1, int newNumNetworkThreads$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        EndPoint endpoint = (EndPoint)tuple2._1();
        Acceptor acceptor = (Acceptor)tuple2._2();
        $this.addProcessors(acceptor, endpoint, newNumNetworkThreads$1 - oldNumNetworkThreads$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$removeListeners$2(SocketServer $this, EndPoint endpoint) {
        ((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter($this.acceptors()).asScala()).remove((Object)endpoint).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
    }

    public SocketServer(KafkaConfig config, Metrics metrics, Time time, CredentialProvider credentialProvider) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.credentialProvider = credentialProvider;
        Logging.$init$(this);
        KafkaMetricsGroup.$init$(this);
        this.maxQueuedRequests = config.queuedMaxRequests();
        this.maxConnectionsPerIp = config.maxConnectionsPerIp();
        this.maxConnectionsPerIpOverrides = config.maxConnectionsPerIpOverrides();
        this.logContext = new LogContext(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"[SocketServer brokerId=", "] "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)config.brokerId())})));
        this.logIdent_$eq(this.logContext().logPrefix());
        this.memoryPoolSensor = metrics.sensor("MemoryPoolUtilization");
        this.memoryPoolDepletedPercentMetricName = metrics.metricName("MemoryPoolAvgDepletedPercent", "socket-server-metrics");
        this.memoryPoolDepletedTimeMetricName = metrics.metricName("MemoryPoolDepletedTimeTotal", "socket-server-metrics");
        this.memoryPoolSensor().add((CompoundStat)new org.apache.kafka.common.metrics.stats.Meter(TimeUnit.MILLISECONDS, this.memoryPoolDepletedPercentMetricName(), this.memoryPoolDepletedTimeMetricName()));
        this.kafka$network$SocketServer$$memoryPool = Predef$.MODULE$.Long2long(config.queuedMaxBytes()) > 0L ? new SimpleMemoryPool(Predef$.MODULE$.Long2long(config.queuedMaxBytes()), Predef$.MODULE$.Integer2int(config.socketRequestMaxBytes()), false, this.memoryPoolSensor()) : MemoryPool.NONE;
        this.requestChannel = new RequestChannel(Predef$.MODULE$.Integer2int(this.maxQueuedRequests()));
        this.kafka$network$SocketServer$$processors = new ConcurrentHashMap();
        this.nextProcessorId = 0;
        this.acceptors = new ConcurrentHashMap();
        this.stoppedProcessingRequests = false;
    }
}

