/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet.namednumber;

import java.util.HashMap;
import java.util.Map;
import org.pcap4j.packet.namednumber.NamedNumber;

public final class Dot11BssMembershipSelector
extends NamedNumber<Byte, Dot11BssMembershipSelector> {
    private static final long serialVersionUID = -8967573178793261461L;
    public static final Dot11BssMembershipSelector HT_PHY = new Dot11BssMembershipSelector((byte)127, "HT PHY");
    private static final Map<Byte, Dot11BssMembershipSelector> registry = new HashMap<Byte, Dot11BssMembershipSelector>();

    public Dot11BssMembershipSelector(Byte value2, String name) {
        super(value2, name);
        if (value2 < 0) {
            throw new IllegalArgumentException("The value must be between 0 to 127 but actually is: " + value2);
        }
    }

    public static Dot11BssMembershipSelector getInstance(Byte value2) {
        if (registry.containsKey(value2)) {
            return registry.get(value2);
        }
        return new Dot11BssMembershipSelector(value2, "unknown");
    }

    public static boolean isRegistered(Byte value2) {
        return registry.containsKey(value2);
    }

    public static Dot11BssMembershipSelector register(Dot11BssMembershipSelector number) {
        return registry.put((Byte)number.value(), number);
    }

    @Override
    public int compareTo(Dot11BssMembershipSelector o) {
        return ((Byte)this.value()).compareTo((Byte)o.value());
    }

    @Override
    public String valueAsString() {
        return String.valueOf((Byte)this.value() & 0xFF);
    }

    static {
        registry.put((Byte)HT_PHY.value(), HT_PHY);
    }
}

