/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.nio.ByteOrder;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.RadiotapPacket;
import org.pcap4j.util.ByteArrays;

public final class RadiotapDataAMpduStatus
implements RadiotapPacket.RadiotapData {
    private static final long serialVersionUID = 5595179236319330489L;
    private static final int LENGTH = 8;
    private final int referenceNumber;
    private final boolean driverReportsZeroLengthSubframes;
    private final boolean zeroLengthSubframe;
    private final boolean lastSubframeKnown;
    private final boolean lastSubframe;
    private final boolean delimiterCrcError;
    private final boolean delimiterCrcValueKnown;
    private final boolean tenthMsbOfFlags;
    private final boolean ninthMsbOfFlags;
    private final boolean eighthMsbOfFlags;
    private final boolean seventhMsbOfFlags;
    private final boolean sixthMsbOfFlags;
    private final boolean fifthMsbOfFlags;
    private final boolean fourthMsbOfFlags;
    private final boolean thirdMsbOfFlags;
    private final boolean secondMsbOfFlags;
    private final boolean msbOfFlags;
    private final byte delimiterCrcValue;
    private final byte reserved;

    public static RadiotapDataAMpduStatus newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new RadiotapDataAMpduStatus(rawData, offset, length);
    }

    private RadiotapDataAMpduStatus(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        if (length < 8) {
            StringBuilder sb = new StringBuilder(200);
            sb.append("The data is too short to build a RadiotapAMpduStatus (").append(8).append(" bytes). data: ").append(ByteArrays.toHexString(rawData, " ")).append(", offset: ").append(offset).append(", length: ").append(length);
            throw new IllegalRawDataException(sb.toString());
        }
        this.referenceNumber = ByteArrays.getInt(rawData, offset, ByteOrder.LITTLE_ENDIAN);
        this.driverReportsZeroLengthSubframes = (rawData[offset + 4] & 1) != 0;
        this.zeroLengthSubframe = (rawData[offset + 4] & 2) != 0;
        this.lastSubframeKnown = (rawData[offset + 4] & 4) != 0;
        this.lastSubframe = (rawData[offset + 4] & 8) != 0;
        this.delimiterCrcError = (rawData[offset + 4] & 0x10) != 0;
        this.delimiterCrcValueKnown = (rawData[offset + 4] & 0x20) != 0;
        this.tenthMsbOfFlags = (rawData[offset + 4] & 0x40) != 0;
        this.ninthMsbOfFlags = (rawData[offset + 4] & 0x80) != 0;
        this.eighthMsbOfFlags = (rawData[offset + 5] & 1) != 0;
        this.seventhMsbOfFlags = (rawData[offset + 5] & 2) != 0;
        this.sixthMsbOfFlags = (rawData[offset + 5] & 4) != 0;
        this.fifthMsbOfFlags = (rawData[offset + 5] & 8) != 0;
        this.fourthMsbOfFlags = (rawData[offset + 5] & 0x10) != 0;
        this.thirdMsbOfFlags = (rawData[offset + 5] & 0x20) != 0;
        this.secondMsbOfFlags = (rawData[offset + 5] & 0x40) != 0;
        this.msbOfFlags = (rawData[offset + 5] & 0x80) != 0;
        this.delimiterCrcValue = rawData[offset + 6];
        this.reserved = rawData[offset + 7];
    }

    private RadiotapDataAMpduStatus(Builder builder2) {
        if (builder2 == null) {
            throw new NullPointerException("builder is null.");
        }
        this.referenceNumber = builder2.referenceNumber;
        this.driverReportsZeroLengthSubframes = builder2.driverReportsZeroLengthSubframes;
        this.zeroLengthSubframe = builder2.zeroLengthSubframe;
        this.lastSubframeKnown = builder2.lastSubframeKnown;
        this.lastSubframe = builder2.lastSubframe;
        this.delimiterCrcError = builder2.delimiterCrcError;
        this.delimiterCrcValueKnown = builder2.delimiterCrcValueKnown;
        this.tenthMsbOfFlags = builder2.tenthMsbOfFlags;
        this.ninthMsbOfFlags = builder2.ninthMsbOfFlags;
        this.eighthMsbOfFlags = builder2.eighthMsbOfFlags;
        this.seventhMsbOfFlags = builder2.seventhMsbOfFlags;
        this.sixthMsbOfFlags = builder2.sixthMsbOfFlags;
        this.fifthMsbOfFlags = builder2.fifthMsbOfFlags;
        this.fourthMsbOfFlags = builder2.fourthMsbOfFlags;
        this.thirdMsbOfFlags = builder2.thirdMsbOfFlags;
        this.secondMsbOfFlags = builder2.secondMsbOfFlags;
        this.msbOfFlags = builder2.msbOfFlags;
        this.delimiterCrcValue = builder2.delimiterCrcValue;
        this.reserved = builder2.reserved;
    }

    public int getReferenceNumber() {
        return this.referenceNumber;
    }

    public long getReferenceNumberAsLong() {
        return (long)this.referenceNumber & 0xFFFFFFFFL;
    }

    public boolean getDriverReportsZeroLengthSubframes() {
        return this.driverReportsZeroLengthSubframes;
    }

    public boolean isZeroLengthSubframe() {
        return this.zeroLengthSubframe;
    }

    public boolean isLastSubframeKnown() {
        return this.lastSubframeKnown;
    }

    public boolean isLastSubframe() {
        return this.lastSubframe;
    }

    public boolean isDelimiterCrcError() {
        return this.delimiterCrcError;
    }

    public boolean isDelimiterCrcValueKnown() {
        return this.delimiterCrcValueKnown;
    }

    public boolean getTenthMsbOfFlags() {
        return this.tenthMsbOfFlags;
    }

    public boolean getNinthMsbOfFlags() {
        return this.ninthMsbOfFlags;
    }

    public boolean getEighthMsbOfFlags() {
        return this.eighthMsbOfFlags;
    }

    public boolean getSeventhMsbOfFlags() {
        return this.seventhMsbOfFlags;
    }

    public boolean getSixthMsbOfFlags() {
        return this.sixthMsbOfFlags;
    }

    public boolean getFifthMsbOfFlags() {
        return this.fifthMsbOfFlags;
    }

    public boolean getFourthMsbOfFlags() {
        return this.fourthMsbOfFlags;
    }

    public boolean getThirdMsbOfFlags() {
        return this.thirdMsbOfFlags;
    }

    public boolean getSecondMsbOfFlags() {
        return this.secondMsbOfFlags;
    }

    public boolean getMsbOfFlags() {
        return this.msbOfFlags;
    }

    public byte getDelimiterCrcValue() {
        return this.delimiterCrcValue;
    }

    public byte getReserved() {
        return this.reserved;
    }

    @Override
    public int length() {
        return 8;
    }

    @Override
    public byte[] getRawData() {
        byte[] data = new byte[8];
        System.arraycopy(ByteArrays.toByteArray(this.referenceNumber, ByteOrder.LITTLE_ENDIAN), 0, data, 0, 4);
        if (this.driverReportsZeroLengthSubframes) {
            data[4] = (byte)(data[4] | 1);
        }
        if (this.zeroLengthSubframe) {
            data[4] = (byte)(data[4] | 2);
        }
        if (this.lastSubframeKnown) {
            data[4] = (byte)(data[4] | 4);
        }
        if (this.lastSubframe) {
            data[4] = (byte)(data[4] | 8);
        }
        if (this.delimiterCrcError) {
            data[4] = (byte)(data[4] | 0x10);
        }
        if (this.delimiterCrcValueKnown) {
            data[4] = (byte)(data[4] | 0x20);
        }
        if (this.tenthMsbOfFlags) {
            data[4] = (byte)(data[4] | 0x40);
        }
        if (this.ninthMsbOfFlags) {
            data[4] = (byte)(data[4] | 0x80);
        }
        if (this.eighthMsbOfFlags) {
            data[5] = (byte)(data[5] | 1);
        }
        if (this.seventhMsbOfFlags) {
            data[5] = (byte)(data[5] | 2);
        }
        if (this.sixthMsbOfFlags) {
            data[5] = (byte)(data[5] | 4);
        }
        if (this.fifthMsbOfFlags) {
            data[5] = (byte)(data[5] | 8);
        }
        if (this.fourthMsbOfFlags) {
            data[5] = (byte)(data[5] | 0x10);
        }
        if (this.thirdMsbOfFlags) {
            data[5] = (byte)(data[5] | 0x20);
        }
        if (this.secondMsbOfFlags) {
            data[5] = (byte)(data[5] | 0x40);
        }
        if (this.msbOfFlags) {
            data[5] = (byte)(data[5] | 0x80);
        }
        data[6] = this.delimiterCrcValue;
        data[7] = this.reserved;
        return data;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("A-MPDU status: ").append(ls).append(indent).append("  reference number: ").append(this.getReferenceNumberAsLong()).append(ls).append(indent).append("  driver reports 0-length subframes: ").append(this.driverReportsZeroLengthSubframes).append(ls).append(indent).append("  0-length subframe: ").append(this.zeroLengthSubframe).append(ls).append(indent).append("  last subframe is known: ").append(this.lastSubframeKnown).append(ls).append(indent).append("  last subframe: ").append(this.lastSubframe).append(ls).append(indent).append("  delimiter CRC error: ").append(this.delimiterCrcError).append(ls).append(indent).append("  delimiter CRC value is known: ").append(this.delimiterCrcValueKnown).append(ls).append(indent).append("  10th MSB of flags: ").append(this.tenthMsbOfFlags).append(ls).append(indent).append("  9th MSB of flags: ").append(this.ninthMsbOfFlags).append(ls).append(indent).append("  8th MSB of flags: ").append(this.eighthMsbOfFlags).append(ls).append(indent).append("  7th MSB of flags: ").append(this.seventhMsbOfFlags).append(ls).append(indent).append("  6th MSB of flags: ").append(this.sixthMsbOfFlags).append(ls).append(indent).append("  5th MSB of flags: ").append(this.fifthMsbOfFlags).append(ls).append(indent).append("  4th MSB of flags: ").append(this.fourthMsbOfFlags).append(ls).append(indent).append("  3rd MSB of flags: ").append(this.thirdMsbOfFlags).append(ls).append(indent).append("  2nd MSB of flags: ").append(this.secondMsbOfFlags).append(ls).append(indent).append("  MSB of flags: ").append(this.msbOfFlags).append(ls).append(indent).append("  delimiter CRC value: 0x").append(ByteArrays.toHexString(this.delimiterCrcValue, "")).append(ls).append(indent).append("  reserved: 0x").append(ByteArrays.toHexString(this.reserved, "")).append(ls);
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delimiterCrcError ? 1231 : 1237);
        result = 31 * result + this.delimiterCrcValue;
        result = 31 * result + (this.delimiterCrcValueKnown ? 1231 : 1237);
        result = 31 * result + (this.driverReportsZeroLengthSubframes ? 1231 : 1237);
        result = 31 * result + (this.eighthMsbOfFlags ? 1231 : 1237);
        result = 31 * result + (this.fifthMsbOfFlags ? 1231 : 1237);
        result = 31 * result + (this.fourthMsbOfFlags ? 1231 : 1237);
        result = 31 * result + (this.lastSubframe ? 1231 : 1237);
        result = 31 * result + (this.lastSubframeKnown ? 1231 : 1237);
        result = 31 * result + (this.msbOfFlags ? 1231 : 1237);
        result = 31 * result + (this.ninthMsbOfFlags ? 1231 : 1237);
        result = 31 * result + this.referenceNumber;
        result = 31 * result + this.reserved;
        result = 31 * result + (this.secondMsbOfFlags ? 1231 : 1237);
        result = 31 * result + (this.seventhMsbOfFlags ? 1231 : 1237);
        result = 31 * result + (this.sixthMsbOfFlags ? 1231 : 1237);
        result = 31 * result + (this.tenthMsbOfFlags ? 1231 : 1237);
        result = 31 * result + (this.thirdMsbOfFlags ? 1231 : 1237);
        result = 31 * result + (this.zeroLengthSubframe ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RadiotapDataAMpduStatus other = (RadiotapDataAMpduStatus)obj;
        if (this.delimiterCrcError != other.delimiterCrcError) {
            return false;
        }
        if (this.delimiterCrcValue != other.delimiterCrcValue) {
            return false;
        }
        if (this.delimiterCrcValueKnown != other.delimiterCrcValueKnown) {
            return false;
        }
        if (this.driverReportsZeroLengthSubframes != other.driverReportsZeroLengthSubframes) {
            return false;
        }
        if (this.eighthMsbOfFlags != other.eighthMsbOfFlags) {
            return false;
        }
        if (this.fifthMsbOfFlags != other.fifthMsbOfFlags) {
            return false;
        }
        if (this.fourthMsbOfFlags != other.fourthMsbOfFlags) {
            return false;
        }
        if (this.lastSubframe != other.lastSubframe) {
            return false;
        }
        if (this.lastSubframeKnown != other.lastSubframeKnown) {
            return false;
        }
        if (this.msbOfFlags != other.msbOfFlags) {
            return false;
        }
        if (this.ninthMsbOfFlags != other.ninthMsbOfFlags) {
            return false;
        }
        if (this.referenceNumber != other.referenceNumber) {
            return false;
        }
        if (this.reserved != other.reserved) {
            return false;
        }
        if (this.secondMsbOfFlags != other.secondMsbOfFlags) {
            return false;
        }
        if (this.seventhMsbOfFlags != other.seventhMsbOfFlags) {
            return false;
        }
        if (this.sixthMsbOfFlags != other.sixthMsbOfFlags) {
            return false;
        }
        if (this.tenthMsbOfFlags != other.tenthMsbOfFlags) {
            return false;
        }
        if (this.thirdMsbOfFlags != other.thirdMsbOfFlags) {
            return false;
        }
        return this.zeroLengthSubframe == other.zeroLengthSubframe;
    }

    public static final class Builder {
        private int referenceNumber;
        private boolean driverReportsZeroLengthSubframes;
        private boolean zeroLengthSubframe;
        private boolean lastSubframeKnown;
        private boolean lastSubframe;
        private boolean delimiterCrcError;
        private boolean delimiterCrcValueKnown;
        private boolean tenthMsbOfFlags;
        private boolean ninthMsbOfFlags;
        private boolean eighthMsbOfFlags;
        private boolean seventhMsbOfFlags;
        private boolean sixthMsbOfFlags;
        private boolean fifthMsbOfFlags;
        private boolean fourthMsbOfFlags;
        private boolean thirdMsbOfFlags;
        private boolean secondMsbOfFlags;
        private boolean msbOfFlags;
        private byte delimiterCrcValue;
        private byte reserved;

        public Builder() {
        }

        private Builder(RadiotapDataAMpduStatus obj) {
            this.referenceNumber = obj.referenceNumber;
            this.driverReportsZeroLengthSubframes = obj.driverReportsZeroLengthSubframes;
            this.zeroLengthSubframe = obj.zeroLengthSubframe;
            this.lastSubframeKnown = obj.lastSubframeKnown;
            this.lastSubframe = obj.lastSubframe;
            this.delimiterCrcError = obj.delimiterCrcError;
            this.delimiterCrcValueKnown = obj.delimiterCrcValueKnown;
            this.tenthMsbOfFlags = obj.tenthMsbOfFlags;
            this.ninthMsbOfFlags = obj.ninthMsbOfFlags;
            this.eighthMsbOfFlags = obj.eighthMsbOfFlags;
            this.seventhMsbOfFlags = obj.seventhMsbOfFlags;
            this.sixthMsbOfFlags = obj.sixthMsbOfFlags;
            this.fifthMsbOfFlags = obj.fifthMsbOfFlags;
            this.fourthMsbOfFlags = obj.fourthMsbOfFlags;
            this.thirdMsbOfFlags = obj.thirdMsbOfFlags;
            this.secondMsbOfFlags = obj.secondMsbOfFlags;
            this.msbOfFlags = obj.msbOfFlags;
            this.delimiterCrcValue = obj.delimiterCrcValue;
            this.reserved = obj.reserved;
        }

        public Builder referenceNumber(int referenceNumber) {
            this.referenceNumber = referenceNumber;
            return this;
        }

        public Builder driverReportsZeroLengthSubframes(boolean driverReportsZeroLengthSubframes) {
            this.driverReportsZeroLengthSubframes = driverReportsZeroLengthSubframes;
            return this;
        }

        public Builder zeroLengthSubframe(boolean zeroLengthSubframe) {
            this.zeroLengthSubframe = zeroLengthSubframe;
            return this;
        }

        public Builder lastSubframeKnown(boolean lastSubframeKnown) {
            this.lastSubframeKnown = lastSubframeKnown;
            return this;
        }

        public Builder lastSubframe(boolean lastSubframe) {
            this.lastSubframe = lastSubframe;
            return this;
        }

        public Builder delimiterCrcError(boolean delimiterCrcError) {
            this.delimiterCrcError = delimiterCrcError;
            return this;
        }

        public Builder delimiterCrcValueKnown(boolean delimiterCrcValueKnown) {
            this.delimiterCrcValueKnown = delimiterCrcValueKnown;
            return this;
        }

        public Builder tenthMsbOfFlags(boolean tenthMsbOfFlags) {
            this.tenthMsbOfFlags = tenthMsbOfFlags;
            return this;
        }

        public Builder ninthMsbOfFlags(boolean ninthMsbOfFlags) {
            this.ninthMsbOfFlags = ninthMsbOfFlags;
            return this;
        }

        public Builder eighthMsbOfFlags(boolean eighthMsbOfFlags) {
            this.eighthMsbOfFlags = eighthMsbOfFlags;
            return this;
        }

        public Builder seventhMsbOfFlags(boolean seventhMsbOfFlags) {
            this.seventhMsbOfFlags = seventhMsbOfFlags;
            return this;
        }

        public Builder sixthMsbOfFlags(boolean sixthMsbOfFlags) {
            this.sixthMsbOfFlags = sixthMsbOfFlags;
            return this;
        }

        public Builder fifthMsbOfFlags(boolean fifthMsbOfFlags) {
            this.fifthMsbOfFlags = fifthMsbOfFlags;
            return this;
        }

        public Builder fourthMsbOfFlags(boolean fourthMsbOfFlags) {
            this.fourthMsbOfFlags = fourthMsbOfFlags;
            return this;
        }

        public Builder thirdMsbOfFlags(boolean thirdMsbOfFlags) {
            this.thirdMsbOfFlags = thirdMsbOfFlags;
            return this;
        }

        public Builder secondMsbOfFlags(boolean secondMsbOfFlags) {
            this.secondMsbOfFlags = secondMsbOfFlags;
            return this;
        }

        public Builder msbOfFlags(boolean msbOfFlags) {
            this.msbOfFlags = msbOfFlags;
            return this;
        }

        public Builder delimiterCrcValue(byte delimiterCrcValue) {
            this.delimiterCrcValue = delimiterCrcValue;
            return this;
        }

        public Builder reserved(byte reserved) {
            this.reserved = reserved;
            return this;
        }

        public RadiotapDataAMpduStatus build() {
            return new RadiotapDataAMpduStatus(this);
        }
    }
}

