/*
 * Decompiled with CFR 0.152.
 */
package rocks.xmpp.precis;

import java.text.Normalizer;
import java.util.function.Function;
import rocks.xmpp.precis.PrecisProfile;

final class NicknameProfile
extends PrecisProfile {
    private static final long serialVersionUID = 8561449693996385797L;

    NicknameProfile() {
        super(false);
    }

    @Override
    public final String enforce(CharSequence input) {
        Function<CharSequence, String> rules = in -> this.prepare(this.applyNormalizationRule(this.applyAdditionalMappingRule((CharSequence)in)));
        String enforced = this.stabilize(input, rules);
        if (enforced.isEmpty()) {
            throw new IllegalArgumentException("Nickname must not be empty after applying the rules.");
        }
        return enforced;
    }

    @Override
    public final String toComparableString(CharSequence input) {
        return this.stabilize(input, x$0 -> super.enforce((CharSequence)x$0));
    }

    @Override
    protected final CharSequence applyWidthMappingRule(CharSequence input) {
        return input;
    }

    @Override
    protected final CharSequence applyAdditionalMappingRule(CharSequence input) {
        String mapped = WHITESPACE.matcher(input).replaceAll(" ");
        String trimmed = mapped.trim();
        return trimmed.replaceAll("[ ]+", " ");
    }

    @Override
    protected final CharSequence applyCaseMappingRule(CharSequence input) {
        return NicknameProfile.caseMap(input);
    }

    @Override
    protected final CharSequence applyNormalizationRule(CharSequence input) {
        return Normalizer.normalize(input, Normalizer.Form.NFKC);
    }

    @Override
    protected final CharSequence applyDirectionalityRule(CharSequence input) {
        return input;
    }
}

