#!/usr/pkg/bin/chezscheme --program

;; @generated by Idris 0.7.0-55c2cd32e, Chez backend
(import (chezscheme))
(case (machine-type)
  [(i3fb ti3fb a6fb ta6fb) #f]
  [(i3le ti3le a6le ta6le tarm64le) (load-shared-object "libc.so.6")]
  [(i3osx ti3osx a6osx ta6osx tarm64osx) (load-shared-object "libc.dylib")]
  [(i3nt ti3nt a6nt ta6nt) (load-shared-object "msvcrt.dll")]
  [else (load-shared-object "libc.so")])

(load-shared-object "libidris2_support.so")

(let ()
(define (blodwen-os)
  (case (machine-type)
    [(i3le ti3le a6le ta6le tarm64le) "unix"]  ; GNU/Linux
    [(i3ob ti3ob a6ob ta6ob tarm64ob) "unix"]  ; OpenBSD
    [(i3fb ti3fb a6fb ta6fb tarm64fb) "unix"]  ; FreeBSD
    [(i3nb ti3nb a6nb ta6nb tarm64nb) "unix"]  ; NetBSD
    [(i3osx ti3osx a6osx ta6osx tarm64osx) "darwin"]
    [(i3nt ti3nt a6nt ta6nt tarm64nt) "windows"]
    [else "unknown"]))

(define blodwen-lazy
  (lambda (f)
    (let ([evaluated #f] [res void])
      (lambda ()
        (if (not evaluated)
            (begin (set! evaluated #t)
                   (set! res (f))
                   (set! f void))
            (void))
        res))))

(define (blodwen-toSignedInt x bits)
  (if (logbit? bits x)
      (logor x (ash -1 bits))
      (logand x (sub1 (ash 1 bits)))))

(define (blodwen-toUnsignedInt x bits)
  (logand x (sub1 (ash 1 bits))))

(define (blodwen-euclidDiv a b)
  (let ((q (quotient a b))
        (r (remainder a b)))
    (if (< r 0)
      (if (> b 0) (- q 1) (+ q 1))
      q)))

(define (blodwen-euclidMod a b)
  (let ((r (remainder a b)))
    (if (< r 0)
      (if (> b 0) (+ r b) (- r b))
      r)))

; flonum constants

(define (blodwen-calcFlonumUnitRoundoff)
  (let loop [(uro 1.0)]
    (if (fl= 1.0 (fl+ 1.0 uro))
      uro
      (loop (fl/ uro 2.0)))))

(define (blodwen-calcFlonumEpsilon)
  (fl* (blodwen-calcFlonumUnitRoundoff) 2.0))

(define (blodwen-flonumNaN)
  +nan.0)

(define (blodwen-flonumInf)
  +inf.0)

; Bits

(define bu+ (lambda (x y bits) (blodwen-toUnsignedInt (+ x y) bits)))
(define bu- (lambda (x y bits) (blodwen-toUnsignedInt (- x y) bits)))
(define bu* (lambda (x y bits) (blodwen-toUnsignedInt (* x y) bits)))
(define bu/ (lambda (x y bits) (blodwen-toUnsignedInt (quotient x y) bits)))

(define bs+ (lambda (x y bits) (blodwen-toSignedInt (+ x y) bits)))
(define bs- (lambda (x y bits) (blodwen-toSignedInt (- x y) bits)))
(define bs* (lambda (x y bits) (blodwen-toSignedInt (* x y) bits)))
(define bs/ (lambda (x y bits) (blodwen-toSignedInt (blodwen-euclidDiv x y) bits)))

(define (integer->bits8 x) (logand x (sub1 (ash 1 8))))
(define (integer->bits16 x) (logand x (sub1 (ash 1 16))))
(define (integer->bits32 x) (logand x (sub1 (ash 1 32))))
(define (integer->bits64 x) (logand x (sub1 (ash 1 64))))

(define (bits16->bits8 x) (logand x (sub1 (ash 1 8))))
(define (bits32->bits8 x) (logand x (sub1 (ash 1 8))))
(define (bits64->bits8 x) (logand x (sub1 (ash 1 8))))
(define (bits32->bits16 x) (logand x (sub1 (ash 1 16))))
(define (bits64->bits16 x) (logand x (sub1 (ash 1 16))))
(define (bits64->bits32 x) (logand x (sub1 (ash 1 32))))

(define (blodwen-bits-shl-signed x y bits) (blodwen-toSignedInt (ash x y) bits))

(define (blodwen-bits-shl x y bits) (logand (ash x y) (sub1 (ash 1 bits))))

(define blodwen-shl (lambda (x y) (ash x y)))
(define blodwen-shr (lambda (x y) (ash x (- y))))
(define blodwen-and (lambda (x y) (logand x y)))
(define blodwen-or (lambda (x y) (logor x y)))
(define blodwen-xor (lambda (x y) (logxor x y)))

(define cast-num
  (lambda (x)
    (if (number? x) x 0)))
(define destroy-prefix
  (lambda (x)
    (cond
      ((equal? x "") "")
      ((equal? (string-ref x 0) #\#) "")
      (else x))))

(define exact-floor
  (lambda (x)
    (inexact->exact (floor x))))

(define exact-truncate
  (lambda (x)
    (inexact->exact (truncate x))))

(define exact-truncate-boundedInt
  (lambda (x y)
    (blodwen-toSignedInt (exact-truncate x) y)))

(define exact-truncate-boundedUInt
  (lambda (x y)
    (blodwen-toUnsignedInt (exact-truncate x) y)))

(define cast-char-boundedInt
  (lambda (x y)
    (blodwen-toSignedInt (char->integer x) y)))

(define cast-char-boundedUInt
  (lambda (x y)
    (blodwen-toUnsignedInt (char->integer x) y)))

(define cast-string-int
  (lambda (x)
    (exact-truncate (cast-num (string->number (destroy-prefix x))))))

(define cast-string-boundedInt
  (lambda (x y)
    (blodwen-toSignedInt (cast-string-int x) y)))

(define cast-string-boundedUInt
  (lambda (x y)
    (blodwen-toUnsignedInt (cast-string-int x) y)))

(define cast-int-char
  (lambda (x)
    (if (or
          (and (>= x 0) (<= x #xd7ff))
          (and (>= x #xe000) (<= x #x10ffff)))
        (integer->char x)
        (integer->char 0))))

(define cast-string-double
  (lambda (x)
    (exact->inexact (cast-num (string->number (destroy-prefix x))))))


(define (string-concat xs) (apply string-append xs))
(define (string-unpack s) (string->list s))
(define (string-pack xs) (list->string xs))

(define string-cons (lambda (x y) (string-append (string x) y)))
(define string-reverse (lambda (x)
  (list->string (reverse (string->list x)))))
(define (string-substr off len s)
    (let* ((l (string-length s))
          (b (max 0 off))
          (x (max 0 len))
          (end (min l (+ b x))))
          (if (> b l)
              ""
              (substring s b end))))

(define (blodwen-string-iterator-new s)
  0)

(define (blodwen-string-iterator-to-string _ s ofs f)
  (f (substring s ofs (string-length s))))

(define (blodwen-string-iterator-next s ofs)
  (if (>= ofs (string-length s))
      '() ; EOF
      (cons (string-ref s ofs) (+ ofs 1))))

(define either-left
  (lambda (x)
    (vector 0 x)))

(define either-right
  (lambda (x)
    (vector 1 x)))

(define blodwen-error-quit
  (lambda (msg)
    (display msg)
    (newline)
    (exit 1)))

(define (blodwen-get-line p)
    (if (port? p)
        (let ((str (get-line p)))
            (if (eof-object? str)
                ""
                str))
        void))

(define (blodwen-get-char p)
    (if (port? p)
        (let ((chr (get-char p)))
            (if (eof-object? chr)
                #\nul
                chr))
        void))

;; Buffers

(define (blodwen-new-buffer size)
  (make-bytevector size 0))

(define (blodwen-buffer-size buf)
  (bytevector-length buf))

(define (blodwen-buffer-setbyte buf loc val)
  (bytevector-u8-set! buf loc val))

(define (blodwen-buffer-getbyte buf loc)
  (bytevector-u8-ref buf loc))

(define (blodwen-buffer-setbits16 buf loc val)
  (bytevector-u16-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getbits16 buf loc)
  (bytevector-u16-ref buf loc (native-endianness)))

(define (blodwen-buffer-setbits32 buf loc val)
  (bytevector-u32-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getbits32 buf loc)
  (bytevector-u32-ref buf loc (native-endianness)))

(define (blodwen-buffer-setbits64 buf loc val)
  (bytevector-u64-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getbits64 buf loc)
  (bytevector-u64-ref buf loc (native-endianness)))

(define (blodwen-buffer-setint8 buf loc val)
  (bytevector-s8-set! buf loc val))

(define (blodwen-buffer-getint8 buf loc)
  (bytevector-s8-ref buf loc))

(define (blodwen-buffer-setint16 buf loc val)
  (bytevector-s16-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getint16 buf loc)
  (bytevector-s16-ref buf loc (native-endianness)))

(define (blodwen-buffer-setint32 buf loc val)
  (bytevector-s32-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getint32 buf loc)
  (bytevector-s32-ref buf loc (native-endianness)))

(define (blodwen-buffer-setint buf loc val)
  (bytevector-s64-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getint buf loc)
  (bytevector-s64-ref buf loc (native-endianness)))

(define (blodwen-buffer-setint64 buf loc val)
  (bytevector-s64-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getint64 buf loc)
  (bytevector-s64-ref buf loc (native-endianness)))

(define (blodwen-buffer-setdouble buf loc val)
  (bytevector-ieee-double-set! buf loc val (native-endianness)))

(define (blodwen-buffer-getdouble buf loc)
  (bytevector-ieee-double-ref buf loc (native-endianness)))

(define (blodwen-stringbytelen str)
  (bytevector-length (string->utf8 str)))

(define (blodwen-buffer-setstring buf loc val)
  (let* [(strvec (string->utf8 val))
         (len (bytevector-length strvec))]
    (bytevector-copy! strvec 0 buf loc len)))

(define (blodwen-buffer-getstring buf loc len)
  (let [(newvec (make-bytevector len))]
    (bytevector-copy! buf loc newvec 0 len)
    (utf8->string newvec)))

(define (blodwen-buffer-copydata buf start len dest loc)
  (bytevector-copy! buf start dest loc len))

;; Threads

(define-record thread-handle (semaphore))

(define (blodwen-thread proc)
  (let [(sema (blodwen-make-semaphore 0))]
    (fork-thread (lambda () (proc (vector 0)) (blodwen-semaphore-post sema)))
    (make-thread-handle sema)
    ))

(define (blodwen-thread-wait handle)
  (blodwen-semaphore-wait (thread-handle-semaphore handle)))

;; Thread mailboxes

(define blodwen-thread-data
  (make-thread-parameter #f))

(define (blodwen-get-thread-data ty)
  (blodwen-thread-data))

(define (blodwen-set-thread-data ty a)
  (blodwen-thread-data a))

;; Semaphore

(define-record semaphore (box mutex condition))

(define (blodwen-make-semaphore init)
  (make-semaphore (box init) (make-mutex) (make-condition)))

(define (blodwen-semaphore-post sema)
  (with-mutex (semaphore-mutex sema)
    (let [(sema-box (semaphore-box sema))]
      (set-box! sema-box (+ (unbox sema-box) 1))
      (condition-signal (semaphore-condition sema))
    )))

(define (blodwen-semaphore-wait sema)
  (with-mutex (semaphore-mutex sema)
    (let [(sema-box (semaphore-box sema))]
      (when (= (unbox sema-box) 0)
        (condition-wait (semaphore-condition sema) (semaphore-mutex sema)))
      (set-box! sema-box (- (unbox sema-box) 1))
      )))

;; Barrier

(define-record barrier (count-box num-threads mutex cond))

(define (blodwen-make-barrier num-threads)
  (make-barrier (box 0) num-threads (make-mutex) (make-condition)))

(define (blodwen-barrier-wait barrier)
  (let [(count-box (barrier-count-box barrier))
        (num-threads (barrier-num-threads barrier))
        (mutex (barrier-mutex barrier))
        (condition (barrier-cond barrier))]
    (with-mutex mutex
    (let* [(count-old (unbox count-box))
           (count-new (+ count-old 1))]
      (set-box! count-box count-new)
      (if (= count-new num-threads)
          (condition-broadcast condition)
          (condition-wait condition mutex))
      ))))

;; Channel
; With thanks to Alain Zscheile (@zseri) for help with understanding condition
; variables, and figuring out where the problems were and how to solve them.

(define-record channel (read-mut read-cv read-box val-cv val-box))

(define (blodwen-make-channel ty)
  (make-channel
    (make-mutex)
    (make-condition)
    (box #t)
    (make-condition)
    (box '())
    ))

; block on the read status using read-cv until the value has been read
(define (channel-put-while-helper chan)
  (let ([read-mut (channel-read-mut chan)]
        [read-box (channel-read-box chan)]
        [read-cv  (channel-read-cv  chan)]
        )
    (if (unbox read-box)
      (void)    ; val has been read, so everything is fine
      (begin    ; otherwise, block/spin with cv
        (condition-wait read-cv read-mut)
        (channel-put-while-helper chan)
        )
      )))

(define (blodwen-channel-put ty chan val)
  (with-mutex (channel-read-mut chan)
    (channel-put-while-helper chan)
    (let ([read-box (channel-read-box chan)]
          [val-box  (channel-val-box  chan)]
          )
      (set-box! val-box val)
      (set-box! read-box #f)
      ))
  (condition-signal (channel-val-cv chan))
  )

; block on the value until it has been set
(define (channel-get-while-helper chan)
  (let ([read-mut (channel-read-mut chan)]
        [read-box (channel-read-box chan)]
        [val-cv   (channel-val-cv   chan)]
        )
    (if (unbox read-box)
      (begin
        (condition-wait val-cv read-mut)
        (channel-get-while-helper chan)
        )
      (void)
      )))

(define (blodwen-channel-get ty chan)
  (mutex-acquire (channel-read-mut chan))
  (channel-get-while-helper chan)
  (let* ([val-box  (channel-val-box  chan)]
         [read-box (channel-read-box chan)]
         [read-cv  (channel-read-cv  chan)]
         [the-val  (unbox val-box)]
         )
    (set-box! val-box '())
    (set-box! read-box #t)
    (mutex-release (channel-read-mut chan))
    (condition-signal read-cv)
    the-val))

;; Mutex

(define (blodwen-make-mutex)
  (make-mutex))
(define (blodwen-mutex-acquire mutex)
  (mutex-acquire mutex))
(define (blodwen-mutex-release mutex)
  (mutex-release mutex))

;; Condition variable

(define (blodwen-make-condition)
  (make-condition))
(define (blodwen-condition-wait condition mutex)
  (condition-wait condition mutex))
(define (blodwen-condition-wait-timeout condition mutex timeout)
  (let* [(sec (div timeout 1000000))
         (micro (mod timeout 1000000))]
    (condition-wait condition mutex (make-time 'time-duration (* 1000 micro) sec))))
(define (blodwen-condition-signal condition)
  (condition-signal condition))
(define (blodwen-condition-broadcast condition)
  (condition-broadcast condition))

;; Future

(define-record future-internal (result ready mutex signal))
(define (blodwen-make-future work)
  (let ([future (make-future-internal #f #f (make-mutex) (make-condition))])
    (fork-thread (lambda ()
      (let ([result (work)])
        (with-mutex (future-internal-mutex future)
          (set-future-internal-result! future result)
          (set-future-internal-ready! future #t)
          (condition-broadcast (future-internal-signal future))))))
    future))
(define (blodwen-await-future ty future)
  (let ([mutex (future-internal-mutex future)])
    (with-mutex mutex
      (if (not (future-internal-ready future))
          (condition-wait (future-internal-signal future) mutex))
      (future-internal-result future))))

(define (blodwen-sleep s) (sleep (make-time 'time-duration 0 s)))
(define (blodwen-usleep s)
  (let ((sec (div s 1000000))
        (micro (mod s 1000000)))
       (sleep (make-time 'time-duration (* 1000 micro) sec))))

(define (blodwen-clock-time-utc) (current-time 'time-utc))
(define (blodwen-clock-time-monotonic) (current-time 'time-monotonic))
(define (blodwen-clock-time-duration) (current-time 'time-duration))
(define (blodwen-clock-time-process) (current-time 'time-process))
(define (blodwen-clock-time-thread) (current-time 'time-thread))
(define (blodwen-clock-time-gccpu) (current-time 'time-collector-cpu))
(define (blodwen-clock-time-gcreal) (current-time 'time-collector-real))
(define (blodwen-is-time? clk) (if (time? clk) 1 0))
(define (blodwen-clock-second time) (time-second time))
(define (blodwen-clock-nanosecond time) (time-nanosecond time))


(define (blodwen-arg-count)
  (length (command-line)))

(define (blodwen-arg n)
  (if (< n (length (command-line))) (list-ref (command-line) n) ""))

(define (blodwen-hasenv var)
  (if (eq? (getenv var) #f) 0 1))

;; Randoms
(define random-seed-register 0)
(define (initialize-random-seed-once)
  (if (= (virtual-register random-seed-register) 0)
      (let ([seed (time-nanosecond (current-time))])
        (set-virtual-register! random-seed-register seed)
        (random-seed seed))))

(define (blodwen-random-seed seed)
  (set-virtual-register! random-seed-register seed)
  (random-seed seed))
(define blodwen-random
  (case-lambda
    ;; no argument, pick a real value from [0, 1.0)
    [() (begin
          (initialize-random-seed-once)
          (random 1.0))]
    ;; single argument k, pick an integral value from [0, k)
    [(k)
      (begin
        (initialize-random-seed-once)
        (if (> k 0)
              (random k)
              (assertion-violationf 'blodwen-random "invalid range argument ~a" k)))]))

;; For finalisers

(define blodwen-finaliser (make-guardian))
(define (blodwen-register-object obj proc)
  (let [(x (cons obj proc))]
       (blodwen-finaliser x)
       x))
(define blodwen-run-finalisers
  (lambda ()
    (let run ()
      (let ([x (blodwen-finaliser)])
        (when x
          (((cdr x) (car x)) 'erased)
          (run))))))

;; For creating and reading back scheme objects

; read a scheme string and evaluate it, returning 'Just result' on success
; TODO: catch exception!
(define (blodwen-eval-scheme str)
  (guard
     (x [#t '()]) ; Nothing on failure
     (box (eval (read (open-input-string str)))))
  ); box == Just

(define (blodwen-eval-okay obj)
  (if (null? obj)
      0
      1))

(define (blodwen-get-eval-result obj)
  (unbox obj))

(define (blodwen-debug-scheme obj)
  (display obj) (newline))

(define (blodwen-is-number obj)
  (if (number? obj) 1 0))

(define (blodwen-is-integer obj)
  (if (and (number? obj) (exact? obj)) 1 0))

(define (blodwen-is-float obj)
  (if (flonum? obj) 1 0))

(define (blodwen-is-char obj)
  (if (char? obj) 1 0))

(define (blodwen-is-string obj)
  (if (string? obj) 1 0))

(define (blodwen-is-procedure obj)
  (if (procedure? obj) 1 0))

(define (blodwen-is-symbol obj)
  (if (symbol? obj) 1 0))

(define (blodwen-is-vector obj)
  (if (vector? obj) 1 0))

(define (blodwen-is-nil obj)
  (if (null? obj) 1 0))

(define (blodwen-is-pair obj)
  (if (pair? obj) 1 0))

(define (blodwen-is-box obj)
  (if (box? obj) 1 0))

(define (blodwen-make-symbol str)
  (string->symbol str))

; The below rely on checking that the objects are the right type first.

(define (blodwen-vector-ref obj i)
  (vector-ref obj i))

(define (blodwen-vector-length obj)
  (vector-length obj))

(define (blodwen-vector-list obj)
  (vector->list obj))

(define (blodwen-unbox obj)
  (unbox obj))

(define (blodwen-apply obj arg)
  (obj arg))

(define (blodwen-force obj)
  (obj))

(define (blodwen-read-symbol sym)
  (symbol->string sym))

(define (blodwen-id x) x)
(define PreludeC-45Types-fastUnpack (lambda (farg-0) (string-unpack farg-0)))
(define PreludeC-45Types-fastPack (lambda (farg-0) (string-pack farg-0)))
(define PreludeC-45Types-fastConcat (lambda (farg-0) (string-concat farg-0)))
(define PreludeC-45IO-prim__putStr (lambda (farg-0 farg-1) ((foreign-procedure "idris2_putStr" (string) void) farg-0)))
(define PreludeC-45IO-prim__putChar (lambda (farg-0 farg-1) ((foreign-procedure "putchar" (char) void) farg-0)))
(define PreludeC-45IO-prim__getString (lambda (farg-0) ((foreign-procedure "idris2_getString" (void*) string) farg-0)))
(define PreludeC-45IO-prim__getStr (lambda (farg-0) ((foreign-procedure "idris2_getStr" () string) )))
(define PreludeC-45IO-prim__getChar (lambda (farg-0) ((foreign-procedure "getchar" () char) )))
(define PrimIO-prim__nullAnyPtr (lambda (farg-0) ((foreign-procedure "idris2_isNull" (void*) int) farg-0)))
(define SystemC-45Directory-prim__openDir (lambda (farg-0 farg-1) ((foreign-procedure "idris2_openDir" (string) void*) farg-0)))
(define SystemC-45Directory-prim__dirEntry (lambda (farg-0 farg-1) ((foreign-procedure "idris2_nextDirEntry" (void*) void*) farg-0)))
(define SystemC-45Directory-prim__currentDir (lambda (farg-0) ((foreign-procedure "idris2_currentDirectory" () void*) )))
(define SystemC-45Directory-prim__createDir (lambda (farg-0 farg-1) ((foreign-procedure "idris2_createDir" (string) int) farg-0)))
(define SystemC-45Directory-prim__closeDir (lambda (farg-0 farg-1) ((foreign-procedure "idris2_closeDir" (void*) void) farg-0)))
(define SystemC-45Directory-prim__changeDir (lambda (farg-0 farg-1) ((foreign-procedure "idris2_changeDir" (string) int) farg-0)))
(define SystemC-45FFI-prim__free (lambda (farg-0 farg-1) ((foreign-procedure "idris2_free" (void*) void) farg-0)))
(define SystemC-45FileC-45Virtual-prim__stdout (lambda () ((foreign-procedure "idris2_stdout" () void*) )))
(define SystemC-45FileC-45Virtual-prim__stdin (lambda () ((foreign-procedure "idris2_stdin" () void*) )))
(define SystemC-45FileC-45ReadWrite-prim__writeLine (lambda (farg-0 farg-1 farg-2) ((foreign-procedure "idris2_writeLine" (void* string) int) farg-0 farg-1)))
(define SystemC-45FileC-45ReadWrite-prim__seekLine (lambda (farg-0 farg-1) ((foreign-procedure "idris2_seekLine" (void*) int) farg-0)))
(define SystemC-45FileC-45ReadWrite-prim__removeFile (lambda (farg-0 farg-1) ((foreign-procedure "idris2_removeFile" (string) int) farg-0)))
(define SystemC-45FileC-45ReadWrite-prim__readLine (lambda (farg-0 farg-1) ((foreign-procedure "idris2_readLine" (void*) void*) farg-0)))
(define SystemC-45FileC-45ReadWrite-prim__readChar (lambda (farg-0 farg-1) ((foreign-procedure "fgetc" (void*) int) farg-0)))
(define SystemC-45FileC-45ReadWrite-prim__eof (lambda (farg-0 farg-1) ((foreign-procedure "idris2_eof" (void*) int) farg-0)))
(define SystemC-45FileC-45Error-prim__fileErrno (lambda (farg-0) ((foreign-procedure "idris2_fileErrno" () int) )))
(define SystemC-45FileC-45Error-prim__error (lambda (farg-0 farg-1) ((foreign-procedure "idris2_fileError" (void*) int) farg-0)))
(define SystemC-45Errno-prim__strerror (lambda (farg-0 farg-1) ((foreign-procedure "idris2_strerror" (int) string) farg-0)))
(define SystemC-45Errno-prim__getErrno (lambda (farg-0) ((foreign-procedure "idris2_getErrno" () int) )))
(define SystemC-45FileC-45Handle-prim__open (lambda (farg-0 farg-1 farg-2) ((foreign-procedure "idris2_openFile" (string string) void*) farg-0 farg-1)))
(define SystemC-45FileC-45Handle-prim__close (lambda (farg-0 farg-1) ((foreign-procedure "idris2_closeFile" (void*) void) farg-0)))
(define SystemC-45FileC-45Process-prim__popen (lambda (farg-0 farg-1 farg-2) ((foreign-procedure "idris2_popen" (string string) void*) farg-0 farg-1)))
(define SystemC-45FileC-45Process-prim__pclose (lambda (farg-0 farg-1) ((foreign-procedure "idris2_pclose" (void*) int) farg-0)))
(define SystemC-45FileC-45Process-prim__flush (lambda (farg-0 farg-1) ((foreign-procedure "fflush" (void*) int) farg-0)))
(define SystemC-45FileC-45Permissions-prim__chmod (lambda (farg-0 farg-1 farg-2) ((foreign-procedure "idris2_chmod" (string int) int) farg-0 farg-1)))
(define SystemC-45FileC-45Meta-prim__fileSize (lambda (farg-0 farg-1) ((foreign-procedure "idris2_fileSize" (void*) int) farg-0)))
(define SystemC-45FileC-45Meta-prim__fileIsTTY (lambda (farg-0 farg-1) ((foreign-procedure "idris2_fileIsTTY" (void*) int) farg-0)))
(define SystemC-45FileC-45Buffer-prim__writeBufferData (lambda (farg-0 farg-1 farg-2 farg-3 farg-4) ((foreign-procedure "idris2_writeBufferData" (void* u8* int int) int) farg-0 farg-1 farg-2 farg-3)))
(define SystemC-45FileC-45Buffer-prim__readBufferData (lambda (farg-0 farg-1 farg-2 farg-3 farg-4) ((foreign-procedure "idris2_readBufferData" (void* u8* int int) int) farg-0 farg-1 farg-2 farg-3)))
(define DataC-45Buffer-stringByteLength (lambda (farg-0) (blodwen-stringbytelen farg-0)))
(define DataC-45Buffer-prim__setString (lambda (farg-0 farg-1 farg-2 farg-3) (blodwen-buffer-setstring farg-0 farg-1 farg-2)))
(define DataC-45Buffer-prim__setInt (lambda (farg-0 farg-1 farg-2 farg-3) (blodwen-buffer-setint farg-0 farg-1 farg-2)))
(define DataC-45Buffer-prim__setDouble (lambda (farg-0 farg-1 farg-2 farg-3) (blodwen-buffer-setdouble farg-0 farg-1 farg-2)))
(define DataC-45Buffer-prim__setBits8 (lambda (farg-0 farg-1 farg-2 farg-3) (blodwen-buffer-setbyte farg-0 farg-1 farg-2)))
(define DataC-45Buffer-prim__newBuffer (lambda (farg-0 farg-1) (blodwen-new-buffer farg-0)))
(define DataC-45Buffer-prim__getString (lambda (farg-0 farg-1 farg-2 farg-3) (blodwen-buffer-getstring farg-0 farg-1 farg-2)))
(define DataC-45Buffer-prim__getInt (lambda (farg-0 farg-1 farg-2) (blodwen-buffer-getint farg-0 farg-1)))
(define DataC-45Buffer-prim__getDouble (lambda (farg-0 farg-1 farg-2) (blodwen-buffer-getdouble farg-0 farg-1)))
(define DataC-45Buffer-prim__getBits8 (lambda (farg-0 farg-1 farg-2) (blodwen-buffer-getbyte farg-0 farg-1)))
(define DataC-45Buffer-prim__copyData (lambda (farg-0 farg-1 farg-2 farg-3 farg-4 farg-5) (blodwen-buffer-copydata farg-0 farg-1 farg-2 farg-3 farg-4)))
(define DataC-45Buffer-prim__bufferSize (lambda (farg-0) (blodwen-buffer-size farg-0)))
(define System-prim__system (lambda (farg-0 farg-1) ((foreign-procedure "idris2_system" (string) int) farg-0)))
(define System-prim__getEnv (lambda (farg-0 farg-1) ((foreign-procedure "getenv" (string) void*) farg-0)))
(define System-prim__getArgCount (lambda (farg-0) (blodwen-arg-count )))
(define System-prim__getArg (lambda (farg-0 farg-1) (blodwen-arg farg-0)))
(define System-prim__exit (lambda (farg-0 farg-1) ((foreign-procedure "exit" (int) void) farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeVectorToList (lambda (farg-0) (blodwen-vector-list farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeVectorRef (lambda (farg-0 farg-1) (blodwen-vector-ref farg-0 farg-1)))
(define LibrariesC-45UtilsC-45Scheme-unsafeVectorLength (lambda (farg-0) (blodwen-vector-length farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeUnbox (lambda (farg-0) (blodwen-unbox farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeSnd (lambda (farg-0) (cdr farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeReadSymbol (lambda (farg-0) (blodwen-read-symbol farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeGetString (lambda (farg-0) (blodwen-id farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeGetInteger (lambda (farg-0) (blodwen-id farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeGetFloat (lambda (farg-0) (blodwen-id farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeGetChar (lambda (farg-0) (blodwen-id farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeFst (lambda (farg-0) (car farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeForce (lambda (farg-0) (blodwen-force farg-0)))
(define LibrariesC-45UtilsC-45Scheme-unsafeApply (lambda (farg-0 farg-1) (blodwen-apply farg-0 farg-1)))
(define LibrariesC-45UtilsC-45Scheme-prim_isVector (lambda (farg-0) (blodwen-is-vector farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isSymbol (lambda (farg-0) (blodwen-is-symbol farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isString (lambda (farg-0) (blodwen-is-string farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isProcedure (lambda (farg-0) (blodwen-is-procedure farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isPair (lambda (farg-0) (blodwen-is-pair farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isInteger (lambda (farg-0) (blodwen-is-integer farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isFloat (lambda (farg-0) (blodwen-is-float farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isChar (lambda (farg-0) (blodwen-is-char farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim_isBox (lambda (farg-0) (blodwen-is-box farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim__evalScheme (lambda (farg-0) (blodwen-eval-scheme farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim__evalResult (lambda (farg-0) (blodwen-get-eval-result farg-0)))
(define LibrariesC-45UtilsC-45Scheme-prim__evalOkay (lambda (farg-0) (blodwen-eval-okay farg-0)))
(define LibrariesC-45SystemC-45FileC-45Buffer-prim__writeBufferData (lambda (farg-0 farg-1 farg-2 farg-3 farg-4) ((foreign-procedure "idris2_writeBufferData" (void* u8* int int) int) farg-0 farg-1 farg-2 farg-3)))
(define LibrariesC-45SystemC-45FileC-45Buffer-prim__readBufferData (lambda (farg-0 farg-1 farg-2 farg-3 farg-4) ((foreign-procedure "idris2_readBufferData" (void* u8* int int) int) farg-0 farg-1 farg-2 farg-3)))
(define SystemC-45Clock-prim__osClockValid (lambda (farg-0 farg-1) (blodwen-is-time? farg-0)))
(define SystemC-45Clock-prim__osClockSecond (lambda (farg-0 farg-1) (blodwen-clock-second farg-0)))
(define SystemC-45Clock-prim__osClockNanosecond (lambda (farg-0 farg-1) (blodwen-clock-nanosecond farg-0)))
(define SystemC-45Clock-prim__clockTimeUtc (lambda (farg-0) (blodwen-clock-time-utc )))
(define SystemC-45Clock-prim__clockTimeThread (lambda (farg-0) (blodwen-clock-time-thread )))
(define SystemC-45Clock-prim__clockTimeProcess (lambda (farg-0) (blodwen-clock-time-process )))
(define SystemC-45Clock-prim__clockTimeMonotonic (lambda (farg-0) (blodwen-clock-time-monotonic )))
(define SystemC-45Clock-prim__clockTimeGcReal (lambda (farg-0) (blodwen-clock-time-gcreal )))
(define SystemC-45Clock-prim__clockTimeGcCpu (lambda (farg-0) (blodwen-clock-time-gccpu )))
(define LibrariesC-45DataC-45StringC-45Iterator-uncons (lambda (farg-0 farg-1) (blodwen-string-iterator-next farg-0 farg-1)))
(define LibrariesC-45DataC-45StringC-45Iterator-fromString (lambda (farg-0) (blodwen-string-iterator-new farg-0)))
(define LibrariesC-45SystemC-45FileC-45Meta-prim__filetimeStatusTimeSec (lambda (farg-0 farg-1) ((foreign-procedure "idris2_filetimeStatusTimeSec" (void*) int) farg-0)))
(define LibrariesC-45SystemC-45FileC-45Meta-prim__filetimeStatusTimeNsec (lambda (farg-0 farg-1) ((foreign-procedure "idris2_filetimeStatusTimeNsec" (void*) int) farg-0)))
(define LibrariesC-45SystemC-45FileC-45Meta-prim__filetimeModifiedTimeSec (lambda (farg-0 farg-1) ((foreign-procedure "idris2_filetimeModifiedTimeSec" (void*) int) farg-0)))
(define LibrariesC-45SystemC-45FileC-45Meta-prim__filetimeModifiedTimeNsec (lambda (farg-0 farg-1) ((foreign-procedure "idris2_filetimeModifiedTimeNsec" (void*) int) farg-0)))
(define LibrariesC-45SystemC-45FileC-45Meta-prim__filetimeAccessTimeSec (lambda (farg-0 farg-1) ((foreign-procedure "idris2_filetimeAccessTimeSec" (void*) int) farg-0)))
(define LibrariesC-45SystemC-45FileC-45Meta-prim__filetimeAccessTimeNsec (lambda (farg-0 farg-1) ((foreign-procedure "idris2_filetimeAccessTimeNsec" (void*) int) farg-0)))
(define LibrariesC-45SystemC-45FileC-45Meta-prim__fileTime (lambda (farg-0 farg-1) ((foreign-procedure "idris2_fileTime" (void*) void*) farg-0)))
(define LibrariesC-45UtilsC-45Term-prim__setupTerm (lambda (farg-0) ((foreign-procedure "idris2_setupTerm" () void) )))
(define LibrariesC-45UtilsC-45Term-prim__getTermCols (lambda (farg-0) ((foreign-procedure "idris2_getTermCols" () int) )))
(define NetworkC-45FFI-prim__idrnet_socket (lambda (farg-0 farg-1 farg-2 farg-3) ((foreign-procedure "idrnet_socket" (int int int) int) farg-0 farg-1 farg-2)))
(define NetworkC-45FFI-prim__idrnet_sockaddr_unix (lambda (farg-0 farg-1) ((foreign-procedure "idrnet_sockaddr_unix" (void*) string) farg-0)))
(define NetworkC-45FFI-prim__idrnet_sockaddr_port (lambda (farg-0 farg-1) ((foreign-procedure "idrnet_sockaddr_port" (int) int) farg-0)))
(define NetworkC-45FFI-prim__idrnet_sockaddr_ipv4 (lambda (farg-0 farg-1) ((foreign-procedure "idrnet_sockaddr_ipv4" (void*) string) farg-0)))
(define NetworkC-45FFI-prim__idrnet_sockaddr_family (lambda (farg-0 farg-1) ((foreign-procedure "idrnet_sockaddr_family" (void*) int) farg-0)))
(define NetworkC-45FFI-prim__idrnet_listen (lambda (farg-0 farg-1 farg-2) ((foreign-procedure "idrnet_listen" (int int) int) farg-0 farg-1)))
(define NetworkC-45FFI-prim__idrnet_fdopen (lambda (farg-0 farg-1 farg-2) ((foreign-procedure "idrnet_fdopen" (int string) void*) farg-0 farg-1)))
(define NetworkC-45FFI-prim__idrnet_create_sockaddr (lambda (farg-0) ((foreign-procedure "idrnet_create_sockaddr" () void*) )))
(define NetworkC-45FFI-prim__idrnet_bind (lambda (farg-0 farg-1 farg-2 farg-3 farg-4 farg-5) ((foreign-procedure "idrnet_bind" (int int int string int) int) farg-0 farg-1 farg-2 farg-3 farg-4)))
(define NetworkC-45FFI-prim__idrnet_accept (lambda (farg-0 farg-1 farg-2) ((foreign-procedure __collect_safe "idrnet_accept" (int void*) int) farg-0 farg-1)))
(define NetworkC-45SocketC-45Data-prim__idrnet_errno (lambda (farg-0) ((foreign-procedure "idrnet_errno" () int) )))
(define NetworkC-45SocketC-45Data-prim__idrnet_af_unspec (lambda (farg-0) ((foreign-procedure "idrnet_af_unspec" () int) )))
(define NetworkC-45SocketC-45Data-prim__idrnet_af_unix (lambda (farg-0) ((foreign-procedure "idrnet_af_unix" () int) )))
(define NetworkC-45SocketC-45Data-prim__idrnet_af_inet6 (lambda (farg-0) ((foreign-procedure "idrnet_af_inet6" () int) )))
(define NetworkC-45SocketC-45Data-prim__idrnet_af_inet (lambda (farg-0) ((foreign-procedure "idrnet_af_inet" () int) )))
(define PreludeC-45Types-u--foldl_Foldable_List (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) arg-3 (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (PreludeC-45Types-u--foldl_Foldable_List arg-2 ((arg-2 arg-3) e-2) e-3))))))
(define PreludeC-45Types-u--foldMap_Foldable_List (lambda (arg-2 arg-3 ext-0) (PreludeC-45Types-u--foldl_Foldable_List (lambda (u--acc) (lambda (u--elem) (let ((e-1 (car arg-2))) ((e-1 u--acc) (arg-3 u--elem))))) (let ((e-2 (cdr arg-2))) e-2) ext-0)))
(define PreludeC-45Basics-flip (lambda (arg-3 ext-0 ext-1) ((arg-3 ext-1) ext-0)))
(define PreludeC-45Types-u--foldlM_Foldable_List (lambda (arg-3 arg-4 arg-5 ext-0) (PreludeC-45Types-u--foldl_Foldable_List (lambda (u--ma) (lambda (u--b) (let ((e-2 (vector-ref arg-3 1))) ((((e-2 'erased) 'erased) u--ma) (lambda (eta-0) (PreludeC-45Basics-flip arg-4 u--b eta-0)))))) (let ((e-1 (vector-ref arg-3 0))) (let ((e-5 (vector-ref e-1 1))) ((e-5 'erased) arg-5))) ext-0)))
(define PreludeC-45Types-u--foldr_Foldable_List (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) arg-3 (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) ((arg-2 e-2) (PreludeC-45Types-u--foldr_Foldable_List arg-2 arg-3 e-3)))))))
(define PreludeC-45Types-u--null_Foldable_List (lambda (arg-1) (if (null? arg-1) 1 0)))
(define csegen-14 (vector (lambda (u--acc) (lambda (u--elem) (lambda (u--func) (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldr_Foldable_List u--func u--init u--input)))))) (lambda (u--elem) (lambda (u--acc) (lambda (u--func) (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldl_Foldable_List u--func u--init u--input)))))) (lambda (u--elem) (lambda (arg-10911) (PreludeC-45Types-u--null_Foldable_List arg-10911))) (lambda (u--elem) (lambda (u--acc) (lambda (u--m) (lambda (i_con-0) (lambda (u--funcM) (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldlM_Foldable_List i_con-0 u--funcM u--init u--input)))))))) (lambda (u--elem) (lambda (arg-10940) arg-10940)) (lambda (u--a) (lambda (u--m) (lambda (i_con-0) (lambda (u--f) (lambda (arg-10954) (PreludeC-45Types-u--foldMap_Foldable_List i_con-0 u--f arg-10954))))))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Char (lambda (arg-0 arg-1) (let ((sc0 (or (and (char=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_Char (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-17 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_Char arg-686 arg-689)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_String (lambda (arg-0 arg-1) (let ((sc0 (or (and (string=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_String (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_String arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-22 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_String arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_String arg-686 arg-689)))))
(define csegen-23 (lambda (arg-0) (PreludeC-45EqOrd-u--C-47C-61_Eq_Char arg-0 #\:)))
(define csegen-26 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (vector 1 (vector 0 ))))))
(define AlgebraC-45ZeroOneOmega-rigMult (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) 0)(else (cond ((equal? arg-1 0) 0)(else (cond ((equal? arg-0 1) arg-1)(else (cond ((equal? arg-1 1) arg-0)(else 2))))))))))
(define AlgebraC-45ZeroOneOmega-rigPlus (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) arg-1)(else (cond ((equal? arg-1 0) arg-0)(else 2))))))
(define csegen-29 (vector (lambda (arg-823) (lambda (arg-826) (AlgebraC-45ZeroOneOmega-rigPlus arg-823 arg-826))) 0 (lambda (arg-835) (lambda (arg-838) (AlgebraC-45ZeroOneOmega-rigMult arg-835 arg-838))) 1))
(define AlgebraC-45Semiring-erased (lambda (arg-1) (let ((e-2 (vector-ref arg-1 1))) e-2)))
(define csegen-30 (AlgebraC-45Semiring-erased csegen-29))
(define DataC-45List1-forget (lambda (arg-1) (let ((e-1 (car arg-1))) (let ((e-2 (cdr arg-1))) (cons e-1 e-2)))))
(define DataC-45List1-reverseOnto (lambda (arg-1 arg-2) (if (null? arg-2) arg-1 (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (DataC-45List1-reverseOnto (cons e-2 (DataC-45List1-forget arg-1)) e-3))))))
(define DataC-45List1-singleton (lambda (arg-1) (cons arg-1 '())))
(define DataC-45List1-reverse (lambda (arg-1) (let ((e-1 (car arg-1))) (let ((e-2 (cdr arg-1))) (DataC-45List1-reverseOnto (DataC-45List1-singleton e-1) e-2)))))
(define DataC-45List-span (lambda (arg-1 arg-2) (if (null? arg-2) (cons '() '()) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (let ((sc1 (arg-1 e-2))) (cond ((equal? sc1 1) (let ((sc2 (DataC-45List-span arg-1 e-3))) (let ((e-5 (car sc2))) (let ((e-4 (cdr sc2))) (cons (cons e-2 e-5) e-4))))) (else (cons '() (cons e-2 e-3))))))))))
(define DataC-45List-break (lambda (arg-1 arg-2) (DataC-45List-span (lambda (eta-0) (let ((sc0 (arg-1 eta-0))) (cond ((equal? sc0 1) 0) (else 1)))) arg-2)))
(define DataC-45List-split (lambda (arg-1 arg-2) (let ((sc0 (DataC-45List-break arg-1 arg-2))) (let ((e-2 (car sc0))) (let ((e-3 (cdr sc0))) (if (null? e-3) (DataC-45List1-singleton e-2) (let ((e-7 (cdr e-3))) (cons e-2 (DataC-45List1-forget (DataC-45List-split arg-1 e-7))))))))))
(define PreludeC-45TypesC-45SnocList-C-60C-62C-62 (lambda (arg-1 arg-2) (if (null? arg-1) arg-2 (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (PreludeC-45TypesC-45SnocList-C-60C-62C-62 e-2 (cons e-3 arg-2)))))))
(define PreludeC-45TypesC-45List-mapAppend (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) (PreludeC-45TypesC-45SnocList-C-60C-62C-62 arg-2 '()) (let ((e-1 (car arg-4))) (let ((e-2 (cdr arg-4))) (PreludeC-45TypesC-45List-mapAppend (cons arg-2 (arg-3 e-1)) arg-3 e-2))))))
(define DataC-45List1-u--map_Functor_List1 (lambda (arg-2 arg-3) (let ((e-1 (car arg-3))) (let ((e-2 (cdr arg-3))) (cons (arg-2 e-1) (PreludeC-45TypesC-45List-mapAppend '() arg-2 e-2))))))
(define DataC-45String-split (lambda (arg-0 arg-1) (DataC-45List1-u--map_Functor_List1 (lambda (eta-0) (PreludeC-45Types-fastPack eta-0)) (DataC-45List-split arg-0 (PreludeC-45Types-fastUnpack arg-1)))))
(define csegen-520 (lambda (arg-0) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 #\.)))
(define CoreC-45NameC-45Namespace-mkNamespacedIdent (lambda (arg-0) (let ((u--nns (DataC-45List1-reverse (DataC-45String-split csegen-520 arg-0)))) (let ((u--name (let ((e-1 (car u--nns))) e-1))) (let ((u--ns (let ((e-2 (cdr u--nns))) e-2))) (if (null? u--ns) (cons '() u--name) (cons (box u--ns) u--name)))))))
(define PreludeC-45Basics-uncurry (lambda (arg-3 arg-4) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) ((arg-3 e-2) e-3)))))
(define CoreC-45NameC-45Namespace-mkNestedNamespace (lambda (arg-0 arg-1) (if (null? arg-0) (cons arg-1 '()) (let ((e-2 (unbox arg-0))) (cons arg-1 e-2)))))
(define csegen-521 (lambda (eta-0) (lambda (eta-1) (CoreC-45NameC-45Namespace-mkNestedNamespace eta-0 eta-1))))
(define CoreC-45NameC-45Namespace-mkNamespace (lambda (arg-0) (cond ((equal? arg-0 "") '())(else (PreludeC-45Basics-uncurry csegen-521 (CoreC-45NameC-45Namespace-mkNamespacedIdent arg-0))))))
(define CoreC-45NameC-45Namespace-typesNS (CoreC-45NameC-45Namespace-mkNamespace "Prelude.Types"))
(define csegen-31 (vector 0 CoreC-45NameC-45Namespace-typesNS (vector 1 (vector 0 "prim__integerToNat"))))
(define CoreC-45NameC-45Namespace-eqOrdNS (CoreC-45NameC-45Namespace-mkNamespace "Prelude.EqOrd"))
(define csegen-32 (vector 0 CoreC-45NameC-45Namespace-eqOrdNS (vector 1 (vector 0 "compareInteger"))))
(define CoreC-45Core-coreFail (lambda (arg-1 ext-0) (vector 0 arg-1)))
(define CoreC-45Core-u--throw_Catchable_Core_Error (lambda (ext-1 ext-0) (CoreC-45Core-coreFail ext-1 ext-0)))
(define CoreC-45BinaryC-45Prims-corrupt (lambda (arg-1 ext-0) (CoreC-45Core-u--throw_Catchable_Core_Error (vector 50 (vector 2 arg-1)) ext-0)))
(define LibrariesC-45UtilsC-45Binary-incLoc (lambda (arg-0 arg-1) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (vector e-0 (+ e-1 arg-0) e-2 e-3)))))))
(define LibrariesC-45UtilsC-45Binary-toRead (lambda (arg-0) (- (let ((e-3 (vector-ref arg-0 3))) e-3) (let ((e-1 (vector-ref arg-0 1))) e-1))))
(define PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (or (and (>= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define CoreC-45BinaryC-45Prims-getTag (lambda (arg-0 ext-0) (let ((act-1 (let ((act-1 (unbox arg-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (let ((sc1 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-toRead e-5) 1))) (cond ((equal? sc1 1) (let ((act-2 (let ((act-2 (DataC-45Buffer-prim__getBits8 (let ((e-0 (vector-ref e-5 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-5 1))) e-1) 63) clam-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (let ((act-3 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-incLoc 1 e-5)))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (vector 1 e-6))))))) eff-0) clam-0)))))) (else (CoreC-45Core-u--throw_Catchable_Core_Error (vector 50 (vector 1 "Bits8")) clam-0))))))) eff-0) ext-0)))))))
(define CoreC-45TTC-getName (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (if (null? arg-1) '() (let ((e-3 (car arg-1))) (box e-3))))(else (let ((e-1 (- arg-0 1))) (if (null? arg-1) '() (let ((e-7 (cdr arg-1))) (CoreC-45TTC-getName e-1 e-7))))))))
(define DataC-45Vect-reverseOnto (lambda (arg-3 arg-4) (if (null? arg-4) arg-3 (let ((e-3 (car arg-4))) (let ((e-4 (cdr arg-4))) (DataC-45Vect-reverseOnto (cons e-3 arg-3) e-4))))))
(define DataC-45Vect-reverse (lambda (ext-0) (DataC-45Vect-reverseOnto '() ext-0)))
(define CoreC-45BinaryC-45Prims-n--11095-8298-u--readElems (lambda (arg-1 arg-2 arg-3 arg-5 arg-6) (cond ((equal? arg-6 0) (lambda (eta-0) (vector 1 (DataC-45Vect-reverse arg-5))))(else (let ((e-0 (- arg-6 1))) (lambda (eta-0) (let ((act-1 (let ((e-2 (cdr arg-1))) ((e-2 arg-2) eta-0)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (CoreC-45BinaryC-45Prims-n--11095-8298-u--readElems arg-1 arg-2 arg-3 (cons e-5 arg-5) e-0))) eff-0) eta-0)))))))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (CoreC-45BinaryC-45Prims-n--11095-8298-u--readElems arg-2 arg-3 arg-1 '() arg-1)))
(define PreludeC-45TypesC-45List-reverseOnto (lambda (arg-1 arg-2) (if (null? arg-2) arg-1 (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (PreludeC-45TypesC-45List-reverseOnto (cons e-2 arg-1) e-3))))))
(define PreludeC-45TypesC-45List-reverse (lambda (ext-0) (PreludeC-45TypesC-45List-reverseOnto '() ext-0)))
(define PreludeC-45TypesC-45List-tailRecAppend (lambda (arg-1 arg-2) (PreludeC-45TypesC-45List-reverseOnto arg-2 (PreludeC-45TypesC-45List-reverse arg-1))))
(define PreludeC-45Types-prim__integerToNat (lambda (arg-0) (let ((sc0 (or (and (<= 0 arg-0) 1) 0))) (cond ((equal? sc0 0) 0)(else arg-0)))))
(define Builtin-fst (lambda (arg-2) (let ((e-2 (car arg-2))) e-2)))
(define Builtin-snd (lambda (arg-2) (let ((e-3 (cdr arg-2))) e-3)))
(define PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (string-append "(" (string-append (let ((sc1 (Builtin-fst arg-2))) (let ((e-1 (car sc1))) (e-1 e-2))) (string-append ", " (string-append (let ((sc1 (Builtin-snd arg-2))) (let ((e-1 (car sc1))) (e-1 e-3))) ")"))))))))
(define PreludeC-45Show-firstCharIs (lambda (arg-0 arg-1) (cond ((equal? arg-1 "") 0)(else (arg-0 (string-ref arg-1 0))))))
(define PreludeC-45Show-showParens (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) arg-1) (else (string-append "(" (string-append arg-1 ")"))))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else 0))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define PreludeC-45Show-precCon (lambda (arg-0) (case (vector-ref arg-0 0) ((0) 0) ((1) 1) ((2) 2) ((3) 3) ((4) 4) ((5) 5) (else 6))))
(define PreludeC-45EqOrd-u--C-60_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Integer (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Integer arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45Show-u--compare_Ord_Prec (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((4) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((4) (let ((e-1 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Integer e-0 e-1)))(else (PreludeC-45EqOrd-u--compare_Ord_Integer (PreludeC-45Show-precCon arg-0) (PreludeC-45Show-precCon arg-1))))))(else (PreludeC-45EqOrd-u--compare_Ord_Integer (PreludeC-45Show-precCon arg-0) (PreludeC-45Show-precCon arg-1))))))
(define PreludeC-45Show-u--C-62C-61_Ord_Prec (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (PreludeC-45Show-u--compare_Ord_Prec arg-0 arg-1) 0)))
(define csegen-147 (lambda (arg-0) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 #\-)))
(define PreludeC-45Show-primNumShow (lambda (arg-1 arg-2 arg-3) (let ((u--str (arg-1 arg-3))) (PreludeC-45Show-showParens (let ((sc0 (PreludeC-45Show-u--C-62C-61_Ord_Prec arg-2 (vector 5 )))) (cond ((equal? sc0 1) (PreludeC-45Show-firstCharIs csegen-147 u--str)) (else 0))) u--str))))
(define PreludeC-45Show-u--showPrec_Show_Integer (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Integer (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Integer (vector 0 ) arg-0)))
(define csegen-1054 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_Integer u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_Integer u--d u--x)))))
(define csegen-1608 (cons csegen-1054 csegen-1054))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 255) (let ((act-2 (let ((act-2 (unbox arg-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (clam-1) (let ((sc3 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-toRead e-6) 8))) (cond ((equal? sc3 1) (let ((act-3 (let ((act-3 (DataC-45Buffer-prim__getInt (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63) clam-1))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-4 (let ((act-4 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-incLoc 8 e-6)))) (vector 1 act-4)))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (vector 1 e-7))))))) eff-0) clam-1)))))) (else (CoreC-45Core-u--throw_Catchable_Core_Error (vector 50 (vector 1 (string-append "Int " (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1608 (cons (let ((e-1 (vector-ref e-6 1))) e-1) (let ((e-2 (vector-ref e-6 2))) e-2)))))) clam-1))))))) eff-0) clam-0))))))(else (vector 1 (bs- e-5 (blodwen-toSignedInt 127 63) 63))))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-n--10851-8068-u--readElems (lambda (arg-1 arg-2 arg-3 arg-4) (cond ((equal? arg-4 0) (lambda (eta-0) (vector 1 (PreludeC-45TypesC-45List-reverse arg-3))))(else (let ((e-0 (- arg-4 1))) (lambda (eta-0) (let ((act-1 (let ((e-2 (cdr arg-1))) ((e-2 arg-2) eta-0)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (CoreC-45BinaryC-45Prims-n--10851-8068-u--readElems arg-1 arg-2 (cons e-5 arg-3) e-0))) eff-0) eta-0)))))))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (CoreC-45BinaryC-45Prims-n--10851-8068-u--readElems arg-1 arg-2 '() (PreludeC-45Types-prim__integerToNat e-5)))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 '())) ((equal? e-5 1) (let ((act-2 (let ((e-2 (cdr arg-1))) ((e-2 arg-2) clam-0)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (box e-6))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "Maybe" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-fromLimbs (lambda (arg-0) (if (null? arg-0) 0 (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (+ e-2 (blodwen-shl (CoreC-45BinaryC-45Prims-fromLimbs e-3) 32)))))))
(define LibrariesC-45UtilsC-45Binary-appended (lambda (arg-0 arg-1) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (vector e-0 (+ e-1 arg-0) e-2 (+ e-3 arg-0))))))))
(define LibrariesC-45UtilsC-45Binary-avail (lambda (arg-0) (- (- (let ((e-2 (vector-ref arg-0 2))) e-2) (let ((e-1 (vector-ref arg-0 1))) e-1)) 1)))
(define DataC-45Buffer-copyData (lambda (arg-1 arg-2 arg-3 arg-4 arg-5 arg-6) (let ((e-2 (cdr arg-1))) ((e-2 'erased) (lambda (eta-0) (DataC-45Buffer-prim__copyData arg-2 arg-3 arg-4 arg-5 arg-6 eta-0))))))
(define PreludeC-45EqOrd-u--C-62C-61_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (or (and (>= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define DataC-45Buffer-newBuffer (lambda (arg-1 arg-2) (let ((sc0 (PreludeC-45EqOrd-u--C-62C-61_Ord_Int arg-2 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc0 1) (let ((e-1 (car arg-1))) (let ((e-4 (vector-ref e-1 1))) ((((e-4 'erased) 'erased) (let ((e-6 (cdr arg-1))) ((e-6 'erased) (lambda (eta-0) (DataC-45Buffer-prim__newBuffer arg-2 eta-0))))) (lambda (u--buf) (let ((e-7 (car arg-1))) (let ((e-10 (vector-ref e-7 0))) (let ((e-12 (vector-ref e-10 1))) ((e-12 'erased) (box u--buf)))))))))) (else (let ((e-1 (car arg-1))) (let ((e-5 (vector-ref e-1 0))) (let ((e-7 (vector-ref e-5 1))) ((e-7 'erased) '())))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define DataC-45Buffer-resizeBuffer (lambda (arg-1 arg-2 arg-3) (let ((e-1 (car arg-1))) (let ((e-4 (vector-ref e-1 1))) ((((e-4 'erased) 'erased) (DataC-45Buffer-newBuffer arg-1 arg-3)) (lambda (_-0) (if (null? _-0) (let ((e-7 (car arg-1))) (let ((e-10 (vector-ref e-7 0))) (let ((e-12 (vector-ref e-10 1))) ((e-12 'erased) '())))) (let ((e-6 (unbox _-0))) (let ((e-8 (car arg-1))) (let ((e-10 (vector-ref e-8 1))) ((((e-10 'erased) 'erased) (let ((e-13 (car arg-1))) (let ((e-16 (vector-ref e-13 0))) (let ((e-18 (vector-ref e-16 1))) ((e-18 'erased) (DataC-45Buffer-prim__bufferSize arg-2)))))) (lambda (u--oldsize) (let ((u--len (let ((sc3 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-3 u--oldsize))) (cond ((equal? sc3 1) arg-3) (else u--oldsize))))) (let ((e-13 (car arg-1))) (let ((e-15 (vector-ref e-13 1))) ((((e-15 'erased) 'erased) (DataC-45Buffer-copyData arg-1 arg-2 0 u--len e-6 0)) (lambda (_-10649) (let ((e-18 (car arg-1))) (let ((e-21 (vector-ref e-18 0))) (let ((e-23 (vector-ref e-21 1))) ((e-23 'erased) (box e-6))))))))))))))))))))))
(define PreludeC-45IO-u--map_Functor_IO (lambda (arg-2 arg-3 ext-0) (let ((act-2 (arg-3 ext-0))) (arg-2 act-2))))
(define csegen-75 (vector (lambda (u--b) (lambda (u--a) (lambda (u--func) (lambda (arg-8885) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO u--func arg-8885 eta-0)))))) (lambda (u--a) (lambda (arg-9931) (lambda (eta-0) arg-9931))) (lambda (u--b) (lambda (u--a) (lambda (arg-9937) (lambda (arg-9944) (lambda (world-4) (let ((act-5 (arg-9937 world-4))) (let ((act-3 (arg-9944 world-4))) (act-5 act-3))))))))))
(define csegen-81 (vector csegen-75 (lambda (u--b) (lambda (u--a) (lambda (arg-10411) (lambda (arg-10414) (lambda (world-0) (let ((act-1 (arg-10411 world-0))) ((arg-10414 act-1) world-0))))))) (lambda (u--a) (lambda (arg-10425) (lambda (world-0) (let ((act-1 (arg-10425 world-0))) (act-1 world-0)))))))
(define csegen-82 (cons csegen-81 (lambda (u--a) (lambda (arg-13095) arg-13095))))
(define CoreC-45BinaryC-45Prims-extendBinary (lambda (arg-0 arg-1) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((u--newsize (* e-2 2))) (let ((u--sC-39 (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Integer (- u--newsize e-1) arg-0))) (cond ((equal? sc0 1) (+ u--newsize arg-0)) (else u--newsize))))) (lambda (eta-0) (let ((act-1 (let ((act-1 ((DataC-45Buffer-resizeBuffer csegen-82 e-0 (blodwen-toSignedInt u--sC-39 63)) eta-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (if (null? e-5) (CoreC-45Core-u--throw_Catchable_Core_Error (vector 61 "Buffer expansion failed") clam-0) (let ((e-4 (unbox e-5))) (vector 1 (vector e-4 e-1 u--sC-39 e-3))))))) eff-0) eta-0))))))))))))))
(define CoreC-45BinaryC-45Prims-tag (lambda (arg-0 arg-1 ext-0) (let ((act-1 (let ((act-1 (unbox arg-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (let ((sc1 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-avail e-5) 1))) (cond ((equal? sc1 1) (let ((act-2 (let ((act-2 (DataC-45Buffer-prim__setBits8 (let ((e-0 (vector-ref e-5 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-5 1))) e-1) 63) (blodwen-toUnsignedInt arg-1 8) clam-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended 1 e-5)))) (vector 1 act-3)))))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-extendBinary 1 e-5) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (let ((act-3 (DataC-45Buffer-prim__setBits8 (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63) (blodwen-toUnsignedInt arg-1 8) eta-0))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended 1 e-6)))) (vector 1 act-4)))))))) eff-0) clam-0))))))))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int (lambda (arg-0 arg-1) (lambda (clam-0) (let ((sc0 (let ((sc1 (PreludeC-45EqOrd-u--C-62C-61_Ord_Int arg-1 (blodwen-toSignedInt -127 63)))) (cond ((equal? sc1 1) (PreludeC-45EqOrd-u--C-60_Ord_Int arg-1 (blodwen-toSignedInt 128 63))) (else 0))))) (cond ((equal? sc0 1) (CoreC-45BinaryC-45Prims-tag arg-0 (bs+ arg-1 (blodwen-toSignedInt 127 63) 63) clam-0)) (else (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 (blodwen-toSignedInt 255 63) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (let ((act-2 (unbox arg-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (clam-1) (let ((sc3 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-avail e-6) 8))) (cond ((equal? sc3 1) (let ((act-3 (let ((act-3 (DataC-45Buffer-prim__setInt (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63) arg-1 clam-1))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended 8 e-6)))) (vector 1 act-4)))))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-extendBinary 8 e-6) clam-1))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-4 (let ((act-4 (DataC-45Buffer-prim__setInt (let ((e-0 (vector-ref e-7 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-7 1))) e-1) 63) arg-1 eta-0))) (vector 1 act-4)))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((act-5 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended 8 e-7)))) (vector 1 act-5)))))))) eff-0) clam-1))))))))))) eff-0) clam-0))))))))))))))
(define csegen-1562 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-5542 eta-0)))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1562 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (- 0 (CoreC-45BinaryC-45Prims-fromLimbs e-6)))))) eff-0) clam-0)))))) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1562 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (CoreC-45BinaryC-45Prims-fromLimbs e-6))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "Integer" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (PreludeC-45Types-prim__integerToNat e-5))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_ConInfo (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (vector 1 (vector 1 ))) ((equal? e-5 2) (vector 1 (vector 2 ))) ((equal? e-5 3) (vector 1 (vector 3 ))) ((equal? e-5 4) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 4 e-6))))) eff-0) clam-0)))))) ((equal? e-5 5) (vector 1 (vector 5 ))) ((equal? e-5 6) (vector 1 (vector 6 ))) ((equal? e-5 7) (vector 1 (vector 7 ))) ((equal? e-5 8) (vector 1 (vector 8 ))) ((equal? e-5 9) (vector 1 (vector 9 ))) ((equal? e-5 10) (vector 1 (vector 10 )))(else (CoreC-45BinaryC-45Prims-corrupt "ConInfo" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 ext-0) (let ((act-1 (let ((sc0 (Builtin-fst arg-2))) (let ((e-2 (cdr sc0))) ((e-2 arg-3) ext-0))))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (let ((sc1 (Builtin-snd arg-2))) (let ((e-2 (cdr sc1))) ((e-2 arg-3) eta-0))))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (let ((act-2 (unbox arg-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (let ((u--len e-5)) (lambda (eta-1) (let ((act-3 (let ((sc2 (PreludeC-45EqOrd-u--C-60_Ord_Integer u--len 0))) (cond ((equal? sc2 1) (CoreC-45BinaryC-45Prims-corrupt "String" eta-1)) (else (vector 1 (vector 0 ))))))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((sc3 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-toRead e-6) u--len))) (cond ((equal? sc3 1) (let ((act-4 (let ((act-4 (DataC-45Buffer-prim__getString (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63) e-5 eta-1))) (vector 1 act-4)))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-5 (let ((act-5 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-incLoc u--len e-6)))) (vector 1 act-5)))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (vector 1 e-8))))))) eff-0) eta-1)))))) (else (CoreC-45Core-u--throw_Catchable_Core_Error (vector 50 (vector 1 (string-append "String length " (string-append (PreludeC-45Show-u--show_Show_Integer u--len) (string-append " at " (PreludeC-45Show-u--show_Show_Integer (let ((e-1 (vector-ref e-6 1))) e-1))))))) eta-1))))))))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_String (lambda (arg-0 arg-1) (let ((u--ireq (DataC-45Buffer-stringByteLength arg-1))) (let ((u--req u--ireq)) (lambda (eta-0) (let ((act-1 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 u--ireq) eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (let ((act-2 (unbox arg-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (clam-0) (let ((sc2 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-avail e-6) u--req))) (cond ((equal? sc2 1) (let ((act-3 (let ((act-3 (DataC-45Buffer-prim__setString (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63) arg-1 clam-0))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended u--req e-6)))) (vector 1 act-4)))))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-extendBinary u--req e-6) clam-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (let ((act-4 (DataC-45Buffer-prim__setString (let ((e-0 (vector-ref e-7 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-7 1))) e-1) 63) arg-1 eta-1))) (vector 1 act-4)))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((act-5 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended u--req e-7)))) (vector 1 act-5)))))))) eff-0) clam-0))))))))))) eff-0) eta-0)))))))))))))
(define csegen-1559 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-5542 eta-0)))))
(define csegen-1603 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 e-5))))))
(define CoreC-45TTC-u--fromBuf_TTC_Namespace (lambda (ext-0 ext-1) (PreludeC-45IO-u--map_Functor_IO csegen-1603 (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1559 ext-0 eta-0)) ext-1)))
(define csegen-1563 (cons csegen-1562 csegen-1562))
(define CoreC-45TTC-u--fromBuf_TTC_Name (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Namespace arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 0 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 (vector 0 e-6)))))) eff-0) clam-0)))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 2 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 3 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 4) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 4 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 5) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 (vector 1 e-6)))))) eff-0) clam-0)))))) ((equal? e-5 6) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1563 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 5 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 7) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 6 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 8) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 7 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 9) (vector 1 (vector 1 (vector 2 ))))(else (CoreC-45BinaryC-45Prims-corrupt "Name" clam-0)))))) eff-0) ext-0)))))))
(define PreludeC-45Show-u--showPrec_Show_Int (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Int (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Int (vector 0 ) arg-0)))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 ext-0) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((act-1 (let ((sc1 (Builtin-fst arg-2))) (let ((e-1 (car sc1))) (((e-1 arg-3) e-2) ext-0))))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((sc2 (Builtin-snd arg-2))) (let ((e-1 (car sc2))) (((e-1 arg-3) e-3) ext-0))))))))))
(define CoreC-45Core-traverse_ (lambda (arg-2 arg-3) (if (null? arg-3) (lambda (eta-0) (vector 1 (vector 0 ))) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (let ((eff-0 (let ((eff-0 (arg-2 e-2))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-26 eff-0 eta-0))))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else ((let ((eff-1 (CoreC-45Core-traverse_ arg-2 e-3))) eff-1) world-0)))))))))))
(define CoreC-45BinaryC-45Prims-n--10833-8023-u--length_aux (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (if (null? arg-4) arg-5 (let ((e-3 (cdr arg-4))) (CoreC-45BinaryC-45Prims-n--10833-8023-u--length_aux arg-1 arg-2 arg-3 e-3 (bs+ arg-5 1 63))))))
(define CoreC-45BinaryC-45Prims-n--10833-8022-u--TailRec_length (lambda (arg-1 arg-2 arg-3 arg-4) (CoreC-45BinaryC-45Prims-n--10833-8023-u--length_aux arg-1 arg-2 arg-3 arg-4 0)))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3 ext-0) (let ((act-1 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-2 (CoreC-45BinaryC-45Prims-n--10833-8022-u--TailRec_length arg-1 arg-3 arg-2 arg-3)) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45Core-traverse_ (lambda (clam-0) (let ((e-1 (car arg-1))) ((e-1 arg-2) clam-0))) arg-3) ext-0))))))
(define CoreC-45TTC-u--toBuf_TTC_Namespace (lambda (arg-0 ext-0 ext-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1559 arg-0 ext-0 ext-1)))
(define CoreC-45TTC-u--toBuf_TTC_Name (lambda (arg-0 arg-1) (lambda (clam-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 0 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_Namespace arg-0 e-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 e-1) clam-0)))))))))) ((1) (let ((e-2 (vector-ref arg-1 1))) (case (vector-ref e-2 0) ((0) (let ((e-16 (vector-ref e-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 1 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-16) clam-0)))))) ((1) (let ((e-17 (vector-ref e-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 5 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-17) clam-0)))))) (else (CoreC-45BinaryC-45Prims-tag arg-0 9 clam-0))))) ((2) (let ((e-3 (vector-ref arg-1 1))) (let ((e-4 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 2 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-3) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-4) clam-0)))))))))) ((3) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 3 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 e-5) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-6) clam-0)))))))))) ((4) (let ((e-7 (vector-ref arg-1 1))) (let ((e-8 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 4 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-7) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 e-8) clam-0)))))))))) ((5) (let ((e-9 (vector-ref arg-1 1))) (let ((e-10 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 6 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1563 arg-0 e-9 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 e-10) clam-0)))))))))) ((6) (let ((e-11 (vector-ref arg-1 1))) (let ((e-12 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 7 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-11) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-12) clam-0)))))))))) ((7) (let ((e-13 (vector-ref arg-1 1))) (let ((e-14 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 8 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-13) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-14) clam-0)))))))))) (else (let ((e-15 (vector-ref arg-1 1))) (CoreC-45Core-u--throw_Catchable_Core_Error (vector 61 (string-append "Can't write resolved name " (PreludeC-45Show-u--show_Show_Int e-15))) clam-0)))))))
(define csegen-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_Name arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_Name arg-5542 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40CConAltC-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_ConInfo arg-1 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1562 arg-1 eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-1 eta-2))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-3) (let ((act-5 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 (PreludeC-45TypesC-45List-tailRecAppend e-8 arg-0) arg-1 eta-3))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) ((let ((eff-0 (lambda (eta-4) (vector 1 (vector e-5 e-6 e-7 e-8 e-9))))) eff-0) eta-3)))))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits16 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toUnsignedInt e-5 16)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits32 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toUnsignedInt e-5 32)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits64 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toUnsignedInt e-5 64)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits8 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toUnsignedInt e-5 8)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Char (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (cast-int-char e-5))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Double (lambda (arg-0 ext-0) (let ((act-1 (let ((act-1 (unbox arg-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (let ((sc1 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-toRead e-5) 8))) (cond ((equal? sc1 1) (let ((act-2 (let ((act-2 (DataC-45Buffer-prim__getDouble (let ((e-0 (vector-ref e-5 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-5 1))) e-1) 63) clam-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (let ((act-3 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-incLoc 8 e-5)))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (vector 1 e-6))))))) eff-0) clam-0)))))) (else (CoreC-45Core-u--throw_Catchable_Core_Error (vector 50 (vector 1 "Double")) clam-0))))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int16 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toSignedInt e-5 15)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int32 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toSignedInt e-5 31)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int64 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toSignedInt e-5 63)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 eta-0)) ext-0)))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int8 (lambda (arg-0 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (blodwen-toSignedInt e-5 7)))))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 eta-0)) ext-0)))
(define CoreC-45TTC-u--fromBuf_TTC_PrimType (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1)) ((equal? e-5 2) (vector 1 2)) ((equal? e-5 3) (vector 1 3)) ((equal? e-5 4) (vector 1 4)) ((equal? e-5 5) (vector 1 5)) ((equal? e-5 6) (vector 1 6)) ((equal? e-5 7) (vector 1 7)) ((equal? e-5 8) (vector 1 8)) ((equal? e-5 9) (vector 1 9)) ((equal? e-5 10) (vector 1 10)) ((equal? e-5 11) (vector 1 11)) ((equal? e-5 12) (vector 1 12)) ((equal? e-5 13) (vector 1 13))(else (CoreC-45BinaryC-45Prims-corrupt "PrimType" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_Constant (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 0 e-6))))) eff-0) clam-0)))))) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int8 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-6))))) eff-0) clam-0)))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int16 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-6))))) eff-0) clam-0)))))) ((equal? e-5 3) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int32 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 3 e-6))))) eff-0) clam-0)))))) ((equal? e-5 4) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int64 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 4 e-6))))) eff-0) clam-0)))))) ((equal? e-5 5) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 5 e-6))))) eff-0) clam-0)))))) ((equal? e-5 6) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits8 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 6 e-6))))) eff-0) clam-0)))))) ((equal? e-5 7) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits16 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 7 e-6))))) eff-0) clam-0)))))) ((equal? e-5 8) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits32 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 8 e-6))))) eff-0) clam-0)))))) ((equal? e-5 9) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bits64 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 9 e-6))))) eff-0) clam-0)))))) ((equal? e-5 10) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 10 e-6))))) eff-0) clam-0)))))) ((equal? e-5 11) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Char arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 11 e-6))))) eff-0) clam-0)))))) ((equal? e-5 12) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Double arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 12 e-6))))) eff-0) clam-0)))))) ((equal? e-5 13) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 13 e-6))))) eff-0) clam-0)))))) ((equal? e-5 14) (vector 1 (vector 14 )))(else (CoreC-45BinaryC-45Prims-corrupt "Constant" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40CConstAltC-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_Constant arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45TTC-n--14837-8227-u--fromBuf1 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 5) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 5 e-6))))) eff-0) clam-0)))))) ((equal? e-5 11) (vector 1 (vector 16 ))) ((equal? e-5 12) (vector 1 (vector 17 ))) ((equal? e-5 13) (vector 1 (vector 18 ))) ((equal? e-5 17) (vector 1 (vector 22 ))) ((equal? e-5 19) (vector 1 (vector 24 ))) ((equal? e-5 20) (vector 1 (vector 25 ))) ((equal? e-5 22) (vector 1 (vector 27 ))) ((equal? e-5 23) (vector 1 (vector 28 ))) ((equal? e-5 24) (vector 1 (vector 29 ))) ((equal? e-5 25) (vector 1 (vector 30 ))) ((equal? e-5 26) (vector 1 (vector 31 ))) ((equal? e-5 27) (vector 1 (vector 32 ))) ((equal? e-5 32) (vector 1 (vector 33 ))) ((equal? e-5 33) (vector 1 (vector 34 ))) ((equal? e-5 34) (vector 1 (vector 35 ))) ((equal? e-5 99) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 36 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "PrimFn 1" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-n--14837-8228-u--fromBuf2 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 0 e-6))))) eff-0) clam-0)))))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-6))))) eff-0) clam-0)))))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-6))))) eff-0) clam-0)))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 3 e-6))))) eff-0) clam-0)))))) ((equal? e-5 4) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 4 e-6))))) eff-0) clam-0)))))) ((equal? e-5 6) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 11 e-6))))) eff-0) clam-0)))))) ((equal? e-5 7) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 12 e-6))))) eff-0) clam-0)))))) ((equal? e-5 8) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 13 e-6))))) eff-0) clam-0)))))) ((equal? e-5 9) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 14 e-6))))) eff-0) clam-0)))))) ((equal? e-5 10) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 15 e-6))))) eff-0) clam-0)))))) ((equal? e-5 14) (vector 1 (vector 19 ))) ((equal? e-5 15) (vector 1 (vector 20 ))) ((equal? e-5 16) (vector 1 (vector 21 ))) ((equal? e-5 21) (vector 1 (vector 26 ))) ((equal? e-5 35) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 6 e-6))))) eff-0) clam-0)))))) ((equal? e-5 36) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 7 e-6))))) eff-0) clam-0)))))) ((equal? e-5 37) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 8 e-6))))) eff-0) clam-0)))))) ((equal? e-5 38) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 9 e-6))))) eff-0) clam-0)))))) ((equal? e-5 39) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PrimType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 10 e-6))))) eff-0) clam-0)))))) ((equal? e-5 101) (vector 1 (vector 38 )))(else (CoreC-45BinaryC-45Prims-corrupt "PrimFn 2" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-n--14837-8229-u--fromBuf3 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 18) (vector 1 (vector 23 ))) ((equal? e-5 100) (vector 1 (vector 37 )))(else (CoreC-45BinaryC-45Prims-corrupt "PrimFn 3" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40PrimFnC-32C-36nC-41 (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (lambda (eta-0) (CoreC-45BinaryC-45Prims-corrupt "PrimFn" eta-0)))(else (let ((e-0 (- arg-0 1))) (cond ((equal? e-0 0) (lambda (eta-0) (CoreC-45TTC-n--14837-8227-u--fromBuf1 arg-1 arg-0 eta-0)))(else (let ((e-1 (- e-0 1))) (cond ((equal? e-1 0) (lambda (eta-0) (CoreC-45TTC-n--14837-8228-u--fromBuf2 arg-1 arg-0 eta-0)))(else (let ((e-2 (- e-1 1))) (lambda (clam-0) (cond ((equal? e-2 0) (CoreC-45TTC-n--14837-8229-u--fromBuf3 arg-1 arg-0 clam-0))(else (CoreC-45BinaryC-45Prims-corrupt "PrimFn" clam-0)))))))))))))))
(define CoreC-45Core-C-60C-42C-62 (lambda (arg-2 arg-3 ext-0) (let ((act-5 (let ((act-5 (lambda (eta-0) (lambda (eta-1) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (case (vector-ref eta-1 0) ((1) (let ((e-8 (vector-ref eta-1 1))) (vector 1 (e-5 e-8)))) (else (let ((e-11 (vector-ref eta-1 1))) (vector 0 e-11))))))))))) (let ((act-3 (arg-2 ext-0))) (act-5 act-3))))) (let ((act-3 (arg-3 ext-0))) (act-5 act-3)))))
(define CoreC-45TTC-u--fromBuf_TTC_ModuleIdent (lambda (ext-0 ext-1) (PreludeC-45IO-u--map_Functor_IO csegen-1603 (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1559 ext-0 eta-0)) ext-1)))
(define CoreC-45TTC-u--fromBuf_TTC_VirtualIdent (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 (vector 0 )))(else (CoreC-45BinaryC-45Prims-corrupt "VirtualIdent" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_OriginDesc (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (vector 1 (lambda (eta-1) (vector 0 eta-1)))) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_ModuleIdent arg-0 eta-0)) clam-0)) ((equal? e-5 1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (vector 1 (lambda (eta-1) (vector 1 eta-1)))) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 eta-0)) clam-0)) ((equal? e-5 2) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (vector 1 (lambda (eta-1) (vector 2 eta-1)))) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_VirtualIdent arg-0 eta-0)) clam-0))(else (CoreC-45BinaryC-45Prims-corrupt "OriginDesc" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_FC (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_OriginDesc arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1563 arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1563 arg-0 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 0 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 1) (vector 1 (vector 2 ))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_OriginDesc arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1563 arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1563 arg-0 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 1 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "FC" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1))(else (CoreC-45BinaryC-45Prims-corrupt "Bool" clam-0)))))) eff-0) ext-0)))))))
(define csegen-1604 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (cond ((equal? e-5 1) 0) (else 1))))))))
(define CoreC-45TTC-u--fromBuf_TTC_InlineOk (lambda (ext-0 ext-1) (PreludeC-45IO-u--map_Functor_IO csegen-1604 (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool ext-0 eta-0)) ext-1)))
(define CoreC-45TTC-u--fromBuf_TTC_LazyReason (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1)) ((equal? e-5 2) (vector 1 2))(else (CoreC-45BinaryC-45Prims-corrupt "LazyReason" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-n--11074-8266-u--writeAll (lambda (arg-1 arg-2 arg-3 arg-4 arg-6 ext-0) (if (null? arg-6) (vector 1 (vector 0 )) (let ((e-3 (car arg-6))) (let ((e-4 (cdr arg-6))) (let ((act-1 (let ((e-1 (car arg-2))) (((e-1 arg-4) e-3) ext-0)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-n--11074-8266-u--writeAll arg-1 arg-2 arg-3 arg-4 e-4 ext-0)))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3 arg-4) (lambda (eta-0) (CoreC-45BinaryC-45Prims-n--11074-8266-u--writeAll arg-1 arg-2 arg-4 arg-3 arg-4 eta-0))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits16 (lambda (arg-0 arg-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 arg-1)))
(define CoreC-45BinaryC-45Prims-toLimbs (lambda (arg-0) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-0 0))) (cond ((equal? sc0 1) '()) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-0 -1))) (cond ((equal? sc1 1) (cons -1 '())) (else (cons (blodwen-toSignedInt (blodwen-and arg-0 4294967295) 63) (CoreC-45BinaryC-45Prims-toLimbs (blodwen-shr arg-0 32)))))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer (lambda (arg-0 arg-1 ext-0) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Integer arg-1 0))) (cond ((equal? sc0 1) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1562 arg-0 (CoreC-45BinaryC-45Prims-toLimbs (- 0 arg-1)) ext-0))))) (else (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1562 arg-0 (CoreC-45BinaryC-45Prims-toLimbs arg-1) ext-0)))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits32 (lambda (arg-0 arg-1) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer arg-0 arg-1 eta-0))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits64 (lambda (arg-0 arg-1) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer arg-0 arg-1 eta-0))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits8 (lambda (arg-0 arg-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 arg-1)))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Char (lambda (arg-0 arg-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 (cast-char-boundedInt arg-1 63))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Double (lambda (arg-0 arg-1 ext-0) (let ((act-1 (let ((act-1 (unbox arg-0))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (let ((sc1 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-avail e-5) 8))) (cond ((equal? sc1 1) (let ((act-2 (let ((act-2 (DataC-45Buffer-prim__setDouble (let ((e-0 (vector-ref e-5 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-5 1))) e-1) 63) arg-1 clam-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended 8 e-5)))) (vector 1 act-3)))))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-extendBinary 8 e-5) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (let ((act-3 (DataC-45Buffer-prim__setDouble (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63) arg-1 eta-0))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended 8 e-6)))) (vector 1 act-4)))))))) eff-0) clam-0))))))))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int16 (lambda (arg-0 arg-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 arg-1)))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int32 (lambda (arg-0 arg-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 arg-1)))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int64 (lambda (arg-0 arg-1) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer arg-0 arg-1 eta-0))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int8 (lambda (arg-0 arg-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 arg-1)))
(define CoreC-45TTC-u--toBuf_TTC_PrimType (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((equal? arg-1 1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) ((equal? arg-1 2) (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)) ((equal? arg-1 3) (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0)) ((equal? arg-1 4) (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0)) ((equal? arg-1 5) (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0)) ((equal? arg-1 6) (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0)) ((equal? arg-1 7) (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0)) ((equal? arg-1 8) (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0)) ((equal? arg-1 9) (CoreC-45BinaryC-45Prims-tag arg-0 9 ext-0)) ((equal? arg-1 10) (CoreC-45BinaryC-45Prims-tag arg-0 10 ext-0)) ((equal? arg-1 11) (CoreC-45BinaryC-45Prims-tag arg-0 11 ext-0)) ((equal? arg-1 12) (CoreC-45BinaryC-45Prims-tag arg-0 12 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 13 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_Constant (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-0) ext-0)))))) ((1) (let ((e-1 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int8 arg-0 e-1) ext-0)))))) ((2) (let ((e-2 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int16 arg-0 e-2) ext-0)))))) ((3) (let ((e-3 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int32 arg-0 e-3) ext-0)))))) ((4) (let ((e-4 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int64 arg-0 e-4) ext-0)))))) ((5) (let ((e-5 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer arg-0 e-5 ext-0)))))) ((6) (let ((e-6 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits8 arg-0 e-6) ext-0)))))) ((7) (let ((e-7 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits16 arg-0 e-7) ext-0)))))) ((8) (let ((e-8 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits32 arg-0 e-8) ext-0)))))) ((9) (let ((e-9 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 9 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bits64 arg-0 e-9) ext-0)))))) ((10) (let ((e-10 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 10 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-10) ext-0)))))) ((11) (let ((e-11 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Char arg-0 e-11) ext-0)))))) ((12) (let ((e-12 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 12 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Double arg-0 e-12 ext-0)))))) ((13) (let ((e-13 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 13 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-0 e-13 ext-0)))))) (else (CoreC-45BinaryC-45Prims-tag arg-0 14 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_C-40CConstAltC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2 ext-0) (let ((e-1 (car arg-2))) (let ((e-2 (cdr arg-2))) (let ((act-1 (CoreC-45TTC-u--toBuf_TTC_Constant arg-1 e-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-2 ext-0))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (lambda (clam-0) (if (null? arg-3) (CoreC-45BinaryC-45Prims-tag arg-2 0 clam-0) (let ((e-2 (unbox arg-3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-2 1 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-1 (car arg-1))) (((e-1 arg-2) e-2) clam-0))))))))))
(define CoreC-45TTC-u--toBuf_TTC_C-40PrimFnC-32C-36nC-41 (lambda (arg-0 arg-1 arg-2) (cond ((equal? arg-0 0) (blodwen-error-quit "Nat case not covered"))(else (let ((e-0 (- arg-0 1))) (cond ((equal? e-0 0) (lambda (clam-0) (case (vector-ref arg-2 0) ((5) (let ((e-18 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 5 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-18 clam-0)))))) ((16) (CoreC-45BinaryC-45Prims-tag arg-1 11 clam-0)) ((17) (CoreC-45BinaryC-45Prims-tag arg-1 12 clam-0)) ((18) (CoreC-45BinaryC-45Prims-tag arg-1 13 clam-0)) ((22) (CoreC-45BinaryC-45Prims-tag arg-1 17 clam-0)) ((24) (CoreC-45BinaryC-45Prims-tag arg-1 19 clam-0)) ((25) (CoreC-45BinaryC-45Prims-tag arg-1 20 clam-0)) ((27) (CoreC-45BinaryC-45Prims-tag arg-1 22 clam-0)) ((28) (CoreC-45BinaryC-45Prims-tag arg-1 23 clam-0)) ((29) (CoreC-45BinaryC-45Prims-tag arg-1 24 clam-0)) ((30) (CoreC-45BinaryC-45Prims-tag arg-1 25 clam-0)) ((31) (CoreC-45BinaryC-45Prims-tag arg-1 26 clam-0)) ((32) (CoreC-45BinaryC-45Prims-tag arg-1 27 clam-0)) ((33) (CoreC-45BinaryC-45Prims-tag arg-1 32 clam-0)) ((34) (CoreC-45BinaryC-45Prims-tag arg-1 33 clam-0)) ((35) (CoreC-45BinaryC-45Prims-tag arg-1 34 clam-0)) (else (let ((e-19 (vector-ref arg-2 1))) (let ((e-20 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 99 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-19 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-20 clam-0)))))))))))))(else (let ((e-1 (- e-0 1))) (cond ((equal? e-1 0) (lambda (clam-1) (case (vector-ref arg-2 0) ((0) (let ((e-3 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 0 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-3 clam-1)))))) ((1) (let ((e-4 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 1 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-4 clam-1)))))) ((2) (let ((e-5 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 2 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-5 clam-1)))))) ((3) (let ((e-6 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 3 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-6 clam-1)))))) ((4) (let ((e-7 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 4 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-7 clam-1)))))) ((6) (let ((e-8 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 35 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-8 clam-1)))))) ((7) (let ((e-9 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 36 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-9 clam-1)))))) ((8) (let ((e-10 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 37 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-10 clam-1)))))) ((9) (let ((e-11 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 38 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-11 clam-1)))))) ((10) (let ((e-12 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 39 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-12 clam-1)))))) ((11) (let ((e-13 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 6 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-13 clam-1)))))) ((12) (let ((e-14 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 7 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-14 clam-1)))))) ((13) (let ((e-15 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 8 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-15 clam-1)))))) ((14) (let ((e-16 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 9 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-16 clam-1)))))) ((15) (let ((e-17 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 10 clam-1))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_PrimType arg-1 e-17 clam-1)))))) ((19) (CoreC-45BinaryC-45Prims-tag arg-1 14 clam-1)) ((20) (CoreC-45BinaryC-45Prims-tag arg-1 15 clam-1)) ((21) (CoreC-45BinaryC-45Prims-tag arg-1 16 clam-1)) ((26) (CoreC-45BinaryC-45Prims-tag arg-1 21 clam-1)) (else (CoreC-45BinaryC-45Prims-tag arg-1 (blodwen-toSignedInt 101 63) clam-1)))))(else (let ((e-2 (- e-1 1))) (cond ((equal? e-2 0) (lambda (clam-2) (case (vector-ref arg-2 0) ((23) (CoreC-45BinaryC-45Prims-tag arg-1 18 clam-2)) (else (CoreC-45BinaryC-45Prims-tag arg-1 (blodwen-toSignedInt 100 63) clam-2)))))(else (blodwen-error-quit "Nat case not covered"))))))))))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat (lambda (arg-0 arg-1) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Integer arg-0 arg-1 eta-0))))
(define CoreC-45TTC-u--toBuf_TTC_ConInfo (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) ((2) (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)) ((3) (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0)) ((4) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-0 e-0) ext-0)))))) ((5) (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0)) ((6) (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0)) ((7) (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0)) ((8) (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0)) ((9) (CoreC-45BinaryC-45Prims-tag arg-0 9 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 10 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_ModuleIdent (lambda (arg-0 ext-0 ext-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1559 arg-0 ext-0 ext-1)))
(define CoreC-45TTC-u--toBuf_TTC_VirtualIdent (lambda (arg-0 arg-1 ext-0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)))
(define CoreC-45TTC-u--toBuf_TTC_OriginDesc (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_ModuleIdent arg-0 e-0 ext-0)))))) ((1) (let ((e-1 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-1) ext-0)))))) (else (let ((e-2 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (CoreC-45TTC-u--toBuf_TTC_VirtualIdent arg-0 e-2 ext-0)))))))))
(define CoreC-45TTC-u--toBuf_TTC_FC (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((e-2 (vector-ref arg-1 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_OriginDesc arg-0 e-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((act-3 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1563 arg-0 e-1 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-3 (vector-ref act-3 1))) (vector 0 e-3))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1563 arg-0 e-2 ext-0)))))))))))))) ((1) (let ((e-3 (vector-ref arg-1 1))) (let ((e-4 (vector-ref arg-1 2))) (let ((e-5 (vector-ref arg-1 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_OriginDesc arg-0 e-3 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1563 arg-0 e-4 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1563 arg-0 e-5 ext-0)))))))))))))) (else (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)))))
(define CoreC-45CompileExpr-u--C-61C-61_Eq_InlineOk (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0)))(else 0))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bool (lambda (arg-0 arg-1) (lambda (clam-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 clam-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 1 clam-0))))))
(define CoreC-45TTC-u--toBuf_TTC_InlineOk (lambda (arg-0 ext-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bool arg-0 (CoreC-45CompileExpr-u--C-61C-61_Eq_InlineOk 0 ext-0))))
(define CoreC-45TTC-u--toBuf_TTC_LazyReason (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((equal? arg-1 1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 1))) (let ((e-3 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-3 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-1 e-2) ext-0)))))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-6 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-7) ext-0)))))))))) ((2) (let ((e-9 (vector-ref arg-2 1))) (let ((e-10 (vector-ref arg-2 2))) (let ((e-11 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-9 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-10) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 (cons e-10 arg-0) arg-1 e-11 ext-0)))))))))))))) ((3) (let ((e-13 (vector-ref arg-2 1))) (let ((e-14 (vector-ref arg-2 2))) (let ((e-15 (vector-ref arg-2 3))) (let ((e-16 (vector-ref arg-2 4))) (let ((e-17 (vector-ref arg-2 5))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-13 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-14) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 ((CoreC-45TTC-u--toBuf_TTC_InlineOk arg-1 e-15) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((act-5 (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-16 ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 (cons e-14 arg-0) arg-1 e-17 ext-0)))))))))))))))))))))) ((4) (let ((e-19 (vector-ref arg-2 1))) (let ((e-20 (vector-ref arg-2 2))) (let ((e-21 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-19 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-20 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-21 ext-0)))))))))))))) ((5) (let ((e-23 (vector-ref arg-2 1))) (let ((e-24 (vector-ref arg-2 2))) (let ((e-25 (vector-ref arg-2 3))) (let ((e-26 (vector-ref arg-2 4))) (let ((e-27 (vector-ref arg-2 5))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 5 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-23 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-24) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (CoreC-45TTC-u--toBuf_TTC_ConInfo arg-1 e-25 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((act-5 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1562 arg-1 e-26) ext-0))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-27 ext-0)))))))))))))))))))))) ((6) (let ((e-29 (vector-ref arg-2 1))) (let ((e-30 (vector-ref arg-2 2))) (let ((e-31 (vector-ref arg-2 3))) (let ((e-32 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 6 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-30 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-1 e-29) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 ((CoreC-45TTC-u--toBuf_TTC_C-40PrimFnC-32C-36nC-41 e-29 arg-1 e-31) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 e-29 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-32) ext-0)))))))))))))))))) ((7) (let ((e-34 (vector-ref arg-2 1))) (let ((e-35 (vector-ref arg-2 2))) (let ((e-36 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 7 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-34 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-35) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-36 ext-0)))))))))))))) ((8) (let ((e-38 (vector-ref arg-2 1))) (let ((e-39 (vector-ref arg-2 2))) (let ((e-40 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 8 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-38 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_LazyReason arg-1 e-39 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-40 ext-0)))))))))))))) ((9) (let ((e-42 (vector-ref arg-2 1))) (let ((e-43 (vector-ref arg-2 2))) (let ((e-44 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 9 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-42 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_LazyReason arg-1 e-43 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-44 ext-0)))))))))))))) ((10) (let ((e-46 (vector-ref arg-2 1))) (let ((e-47 (vector-ref arg-2 2))) (let ((e-48 (vector-ref arg-2 3))) (let ((e-49 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 10 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-46 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-47 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CConAltC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CConAltC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-48 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-49) ext-0)))))))))))))))))) ((11) (let ((e-51 (vector-ref arg-2 1))) (let ((e-52 (vector-ref arg-2 2))) (let ((e-53 (vector-ref arg-2 3))) (let ((e-54 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-51 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 e-52 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CConstAltC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CConstAltC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-53 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-54) ext-0)))))))))))))))))) ((12) (let ((e-56 (vector-ref arg-2 1))) (let ((e-57 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 12 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-56 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_Constant arg-1 e-57 ext-0)))))))))) ((13) (let ((e-59 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 13 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-59 ext-0)))))) (else (let ((e-61 (vector-ref arg-2 1))) (let ((e-62 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 14 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_FC arg-1 e-61 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-1 e-62) ext-0)))))))))))))
(define CoreC-45TTC-u--toBuf_TTC_C-40CConAltC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2 ext-0) (let ((e-1 (vector-ref arg-2 0))) (let ((e-2 (vector-ref arg-2 1))) (let ((e-3 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-1) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-6 (vector-ref act-1 1))) (vector 0 e-6))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_ConInfo arg-1 e-2 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-7 (vector-ref act-2 1))) (vector 0 e-7))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1562 arg-1 e-3) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-8 (vector-ref act-3 1))) (vector 0 e-8))) (else (let ((act-4 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-1 e-4 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-9 (vector-ref act-4 1))) (vector 0 e-9))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 (PreludeC-45TypesC-45List-tailRecAppend e-4 arg-0) arg-1 e-5 ext-0))))))))))))))))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (clam-1) (let ((sc4 (CoreC-45TTC-getName e-7 arg-0))) (if (null? sc4) (CoreC-45BinaryC-45Prims-corrupt "CExp" clam-1) (vector 1 (vector 0 e-7 e-6))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 1 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 (cons e-7 arg-0) arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 2 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_InlineOk arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-5 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 eta-2))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) ((let ((eff-0 (lambda (eta-3) (let ((act-6 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 (cons e-7 arg-0) arg-1 eta-3))) (case (vector-ref act-6 0) ((0) (let ((e-2 (vector-ref act-6 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-6 1))) ((let ((eff-0 (lambda (eta-4) (vector 1 (vector 3 e-6 e-7 e-8 e-9 e-10))))) eff-0) eta-3)))))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 4) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-2) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-2)))) (lambda (arg-5542) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5542 eta-2)))) arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 4 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 5) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_ConInfo arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-5 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1562 arg-1 eta-2))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) ((let ((eff-0 (lambda (eta-3) (let ((act-6 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-4) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-4)))) (lambda (arg-5542) (lambda (eta-4) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5542 eta-4)))) arg-1 eta-3))) (case (vector-ref act-6 0) ((0) (let ((e-2 (vector-ref act-6 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-6 1))) ((let ((eff-0 (lambda (eta-4) (vector 1 (vector 5 e-6 e-7 e-8 e-9 e-10))))) eff-0) eta-3)))))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 6) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 ((CoreC-45TTC-u--fromBuf_TTC_C-40PrimFnC-32C-36nC-41 e-7 arg-1) eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-5 ((CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 e-7 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-3) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-3)))) (lambda (arg-5542) (lambda (eta-3) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5542 eta-3)))) arg-1) eta-2))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) ((let ((eff-0 (lambda (eta-3) (vector 1 (vector 6 e-7 e-6 e-8 e-9))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 7) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-2) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-2)))) (lambda (arg-5542) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5542 eta-2)))) arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 7 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 8) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_LazyReason arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 8 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 9) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_LazyReason arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 9 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 10) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-2) (CoreC-45TTC-u--toBuf_TTC_C-40CConAltC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-2)))) (lambda (arg-5542) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40CConAltC-32C-36varsC-41 arg-0 arg-5542 eta-2)))) arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-5 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-3) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-3)))) (lambda (arg-5542) (lambda (eta-3) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5542 eta-3)))) arg-1 eta-2))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) ((let ((eff-0 (lambda (eta-3) (vector 1 (vector 10 e-6 e-7 e-8 e-9))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 11) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-2) (CoreC-45TTC-u--toBuf_TTC_C-40CConstAltC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-2)))) (lambda (arg-5542) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40CConstAltC-32C-36varsC-41 arg-0 arg-5542 eta-2)))) arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-5 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-3) (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-3)))) (lambda (arg-5542) (lambda (eta-3) (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 arg-0 arg-5542 eta-3)))) arg-1 eta-2))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) ((let ((eff-0 (lambda (eta-3) (vector 1 (vector 11 e-6 e-7 e-8 e-9))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 12) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Constant arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 12 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 13) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 13 e-6))))) eff-0) clam-0)))))) ((equal? e-5 14) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_FC arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 14 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "CExp" clam-0)))))) eff-0) ext-0)))))))
(define csegen-1594 (lambda () (cons csegen-1559 (csegen-1593))))
(define csegen-1597 (lambda () (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1594) arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1594) arg-5542 eta-0))))))
(define CoreC-45TTC-u--toBuf_TTC_CFType (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) ((7) (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)) ((8) (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0)) ((9) (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0)) ((10) (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0)) ((11) (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0)) ((12) (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0)) ((13) (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0)) ((14) (CoreC-45BinaryC-45Prims-tag arg-0 9 ext-0)) ((18) (CoreC-45BinaryC-45Prims-tag arg-0 10 ext-0)) ((19) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_CFType arg-0 e-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_CFType arg-0 e-1 ext-0)))))))))) ((20) (let ((e-2 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 12 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (CoreC-45TTC-u--toBuf_TTC_CFType arg-0 e-2 ext-0)))))) ((21) (let ((e-3 (vector-ref arg-1 1))) (let ((e-4 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 13 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-3) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (csegen-1597) arg-0 e-4 ext-0)))))))))) ((22) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 14 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 e-5) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (csegen-1593) arg-0 e-6 ext-0)))))))))) ((15) (CoreC-45BinaryC-45Prims-tag arg-0 15 ext-0)) ((16) (CoreC-45BinaryC-45Prims-tag arg-0 16 ext-0)) ((3) (CoreC-45BinaryC-45Prims-tag arg-0 17 ext-0)) ((4) (CoreC-45BinaryC-45Prims-tag arg-0 18 ext-0)) ((5) (CoreC-45BinaryC-45Prims-tag arg-0 19 ext-0)) ((6) (CoreC-45BinaryC-45Prims-tag arg-0 20 ext-0)) ((17) (CoreC-45BinaryC-45Prims-tag arg-0 21 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 22 ext-0)))))
(define csegen-1593 (lambda () (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_CFType arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_CFType arg-5542 eta-0))))))
(define CoreC-45TTC-u--fromBuf_TTC_CFType (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (vector 1 (vector 1 ))) ((equal? e-5 2) (vector 1 (vector 7 ))) ((equal? e-5 3) (vector 1 (vector 8 ))) ((equal? e-5 4) (vector 1 (vector 9 ))) ((equal? e-5 5) (vector 1 (vector 10 ))) ((equal? e-5 6) (vector 1 (vector 11 ))) ((equal? e-5 7) (vector 1 (vector 12 ))) ((equal? e-5 8) (vector 1 (vector 13 ))) ((equal? e-5 9) (vector 1 (vector 14 ))) ((equal? e-5 10) (vector 1 (vector 18 ))) ((equal? e-5 11) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_CFType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_CFType arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 19 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 12) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_CFType arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 20 e-6))))) eff-0) clam-0)))))) ((equal? e-5 13) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (csegen-1597) arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 21 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 14) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (csegen-1593) arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 22 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 15) (vector 1 (vector 15 ))) ((equal? e-5 16) (vector 1 (vector 16 ))) ((equal? e-5 17) (vector 1 (vector 3 ))) ((equal? e-5 18) (vector 1 (vector 4 ))) ((equal? e-5 19) (vector 1 (vector 5 ))) ((equal? e-5 20) (vector 1 (vector 6 ))) ((equal? e-5 21) (vector 1 (vector 17 ))) ((equal? e-5 22) (vector 1 (vector 2 )))(else (CoreC-45BinaryC-45Prims-corrupt "CFType" clam-0)))))) eff-0) ext-0)))))))
(define csegen-1535 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-5542 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_CDef (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 e-6 arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 0 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1562 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1535 arg-0 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 1 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1559 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (csegen-1593) arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_CFType arg-0 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 2 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40CExpC-32C-36varsC-41 '() arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 3 e-6))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "CDef" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--toBuf_TTC_CDef (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-0 e-0 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 e-0 arg-0 e-1 ext-0)))))))))) ((1) (let ((e-2 (vector-ref arg-1 1))) (let ((e-3 (vector-ref arg-1 2))) (let ((e-4 (vector-ref arg-1 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1562 arg-0 e-2) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-0 e-3) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1535 arg-0 e-4) ext-0)))))))))))))) ((2) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (let ((e-7 (vector-ref arg-1 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1559 arg-0 e-5 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (csegen-1593) arg-0 e-6 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_CFType arg-0 e-7 ext-0)))))))))))))) (else (let ((e-8 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CExpC-32C-36varsC-41 '() arg-0 e-8 ext-0)))))))))
(define csegen-38 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_CDef arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_CDef arg-5542 eta-0)))))
(define csegen-44 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Bool arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-5542 eta-0)))))
(define csegen-45 (cons csegen-41 csegen-44))
(define csegen-48 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-45 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-45 arg-5542 eta-0)))))
(define csegen-51 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-48 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-48 arg-5542 eta-0)))))
(define PreludeC-45EqOrd-u--C-60C-61_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (or (and (<= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Int (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define LibrariesC-45DataC-45IntMap-treeLookup (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (let ((e-1 (vector-ref arg-3 1))) (let ((e-2 (vector-ref arg-3 2))) (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-2 e-1))) (cond ((equal? sc1 1) (box e-2)) (else '())))))) ((1) (let ((e-5 (vector-ref arg-3 1))) (let ((e-6 (vector-ref arg-3 2))) (let ((e-7 (vector-ref arg-3 3))) (let ((sc1 (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-2 e-6))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45IntMap-treeLookup arg-2 e-5)) (else (LibrariesC-45DataC-45IntMap-treeLookup arg-2 e-7)))))))) (else (let ((e-10 (vector-ref arg-3 1))) (let ((e-11 (vector-ref arg-3 2))) (let ((e-12 (vector-ref arg-3 3))) (let ((e-13 (vector-ref arg-3 4))) (let ((e-14 (vector-ref arg-3 5))) (let ((sc1 (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-2 e-11))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45IntMap-treeLookup arg-2 e-10)) (else (let ((sc2 (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-2 e-13))) (cond ((equal? sc2 1) (LibrariesC-45DataC-45IntMap-treeLookup arg-2 e-12)) (else (LibrariesC-45DataC-45IntMap-treeLookup arg-2 e-14))))))))))))))))
(define LibrariesC-45DataC-45IntMap-lookup (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-3 (cdr arg-2))) (LibrariesC-45DataC-45IntMap-treeLookup arg-1 e-3)))))
(define CoreC-45Context-getContent (lambda (ext-0) (let ((e-4 (vector-ref ext-0 4))) e-4)))
(define DataC-45IORef-newIORef (lambda (arg-2 arg-3) (let ((e-1 (car arg-2))) (let ((e-4 (vector-ref e-1 1))) ((((e-4 'erased) 'erased) (let ((e-6 (cdr arg-2))) ((e-6 'erased) (lambda (eta-0) (box arg-3))))) (lambda (u--m) (let ((e-7 (car arg-2))) (let ((e-10 (vector-ref e-7 0))) (let ((e-12 (vector-ref e-10 1))) ((e-12 'erased) u--m))))))))))
(define CoreC-45Core-newRef (lambda (arg-2 arg-3) (let ((eff-0 (lambda (world-0) (let ((act-1 ((DataC-45IORef-newIORef csegen-82 arg-3) world-0))) (vector 1 act-1))))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (lambda (eta-0) (vector 1 e-5)))) eff-1) world-0)))))))))
(define LibrariesC-45DataC-45IOArray-max (lambda (ext-0) (let ((e-1 (car ext-0))) e-1)))
(define LibrariesC-45DataC-45IOArray-writeArray (lambda (arg-2 arg-3 arg-4 arg-5) (let ((sc0 (let ((sc1 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-4 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc1 1) 1) (else (PreludeC-45EqOrd-u--C-62C-61_Ord_Int arg-4 (LibrariesC-45DataC-45IOArray-max arg-3))))))) (cond ((equal? sc0 1) (let ((e-1 (car arg-2))) (let ((e-5 (vector-ref e-1 0))) (let ((e-7 (vector-ref e-5 1))) ((e-7 'erased) (vector 0 )))))) (else (let ((e-2 (cdr arg-2))) ((e-2 'erased) (lambda (eta-0) (vector-set! (let ((e-3 (cdr arg-3))) e-3) arg-4 (box arg-5))))))))))
(define LibrariesC-45DataC-45NameMap-empty '())
(define CoreC-45Name-nameTag (lambda (arg-0) (case (vector-ref arg-0 0) ((0) 0) ((1) 1) ((2) 2) ((3) 3) ((4) 4) ((5) 6) ((6) 7) ((7) 8) (else 9))))
(define PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((e-6 (car arg-5))) (let ((e-7 (cdr arg-5))) (let ((sc2 (let ((e-1 (vector-ref arg-2 0))) (let ((e-13 (cdr e-1))) ((e-13 e-2) e-6))))) (cond ((equal? sc2 1) (let ((e-12 (vector-ref arg-2 1))) ((e-12 e-2) e-6))) (else (let ((e-12 (vector-ref arg-3 1))) ((e-12 e-3) e-7)))))))))))
(define PreludeC-45EqOrd-u--compare_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45Types-case--compare-6807 (lambda (arg-1 arg-2 arg-3 arg-4 arg-5 arg-6) (cond ((equal? arg-6 1) (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 arg-1 arg-3 arg-5))(else arg-6))))
(define PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-2) (if (null? arg-3) 1 0) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (if (null? arg-3) 2 (let ((e-10 (car arg-3))) (let ((e-11 (cdr arg-3))) (PreludeC-45Types-case--compare-6807 arg-1 e-2 e-3 e-10 e-11 (let ((e-12 (vector-ref arg-1 1))) ((e-12 e-2) e-10)))))))))))
(define PreludeC-45EqOrd-u--C-60C-61_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (or (and (string<=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-60_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (or (and (string<? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-62C-61_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (or (and (string>=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-62_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (or (and (string>? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_String arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_String arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--max_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-62_Ord_String arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define PreludeC-45EqOrd-u--min_Ord_String (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_String arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-519 (vector csegen-22 (lambda (arg-1566) (lambda (arg-1569) (PreludeC-45EqOrd-u--compare_Ord_String arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (PreludeC-45EqOrd-u--C-60_Ord_String arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (PreludeC-45EqOrd-u--C-62_Ord_String arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (PreludeC-45EqOrd-u--C-60C-61_Ord_String arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (PreludeC-45EqOrd-u--C-62C-61_Ord_String arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (PreludeC-45EqOrd-u--max_Ord_String arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (PreludeC-45EqOrd-u--min_Ord_String arg-1626 arg-1629)))))
(define CoreC-45NameC-45Namespace-u--compare_Ord_Namespace (lambda (arg-0 arg-1) (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 csegen-519 arg-0 arg-1)))
(define CoreC-45Name-usernameTag (lambda (arg-0) (case (vector-ref arg-0 0) ((0) 0) ((1) 2) (else 3))))
(define CoreC-45Name-u--compare_Ord_UserName (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-2 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_String e-0 e-2)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-usernameTag arg-0) (CoreC-45Name-usernameTag arg-1)))))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-3 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_String e-1 e-3)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-usernameTag arg-0) (CoreC-45Name-usernameTag arg-1)))))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-usernameTag arg-0) (CoreC-45Name-usernameTag arg-1)))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-usernameTag arg-0) (CoreC-45Name-usernameTag arg-1))))))
(define PreludeC-45EqOrd-u--C-62_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (or (and (> arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--max_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-62_Ord_Int arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define PreludeC-45EqOrd-u--min_Ord_Int (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_Int (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-223 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_Int arg-686 arg-689)))))
(define csegen-231 (vector csegen-223 (lambda (arg-1566) (lambda (arg-1569) (PreludeC-45EqOrd-u--compare_Ord_Int arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (PreludeC-45EqOrd-u--C-60_Ord_Int arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (PreludeC-45EqOrd-u--C-62_Ord_Int arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (PreludeC-45EqOrd-u--C-62C-61_Ord_Int arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (PreludeC-45EqOrd-u--max_Ord_Int arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (PreludeC-45EqOrd-u--min_Ord_Int arg-1626 arg-1629)))))
(define CoreC-45Name-u--compare_Ord_Name (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((0) (let ((e-16 (vector-ref arg-1 1))) (let ((e-17 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45Name-u--compare_Ord_Name e-1 e-17))) (cond ((equal? sc2 1) (CoreC-45NameC-45Namespace-u--compare_Ord_Namespace e-0 e-16)) ((equal? sc2 2) 2) (else 0))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))) ((1) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-18 (vector-ref arg-1 1))) (CoreC-45Name-u--compare_Ord_UserName e-2 e-18)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1)))))) ((2) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((2) (let ((e-19 (vector-ref arg-1 1))) (let ((e-20 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--compare_Ord_Int e-4 e-20))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--compare_Ord_String e-3 e-19)) ((equal? sc2 2) 2) (else 0))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))) ((3) (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((3) (let ((e-21 (vector-ref arg-1 1))) (let ((e-22 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--compare_Ord_Int e-6 e-22))) (cond ((equal? sc2 1) (CoreC-45Name-u--compare_Ord_Name e-5 e-21)) ((equal? sc2 2) 2) (else 0))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))) ((4) (let ((e-8 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((4) (let ((e-24 (vector-ref arg-1 2))) (CoreC-45Name-u--compare_Ord_Name e-8 e-24)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1)))))) ((5) (let ((e-9 (vector-ref arg-0 1))) (let ((e-10 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((5) (let ((e-25 (vector-ref arg-1 1))) (let ((e-26 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45Name-u--compare_Ord_Name e-10 e-26))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-231 csegen-231 e-9 e-25)) ((equal? sc2 2) 2) (else 0))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))) ((6) (let ((e-11 (vector-ref arg-0 1))) (let ((e-12 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((6) (let ((e-27 (vector-ref arg-1 1))) (let ((e-28 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--compare_Ord_Int e-12 e-28))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--compare_Ord_String e-11 e-27)) ((equal? sc2 2) 2) (else 0))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))) ((7) (let ((e-13 (vector-ref arg-0 1))) (let ((e-14 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((7) (let ((e-29 (vector-ref arg-1 1))) (let ((e-30 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--compare_Ord_Int e-14 e-30))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--compare_Ord_String e-13 e-29)) ((equal? sc2 2) 2) (else 0))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))) ((8) (let ((e-15 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-31 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Int e-15 e-31)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Name-nameTag arg-0) (CoreC-45Name-nameTag arg-1))))))
(define CoreC-45Name-u--C-60C-61_Ord_Name (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Name-u--compare_Ord_Name arg-0 arg-1) 2)))
(define LibrariesC-45DataC-45NameMap-treeInsertC-39 (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) (let ((e-2 (vector-ref arg-4 2))) (let ((sc1 (CoreC-45Name-u--compare_Ord_Name arg-2 e-1))) (cond ((equal? sc1 0) (vector 1 (cons (vector 0 arg-2 arg-3) (cons arg-2 (vector 0 e-1 e-2))))) ((equal? sc1 1) (vector 0 (vector 0 arg-2 arg-3))) (else (vector 1 (cons (vector 0 e-1 e-2) (cons e-1 (vector 0 arg-2 arg-3)))))))))) ((1) (let ((e-5 (vector-ref arg-4 1))) (let ((e-6 (vector-ref arg-4 2))) (let ((e-7 (vector-ref arg-4 3))) (let ((sc1 (CoreC-45Name-u--C-60C-61_Ord_Name arg-2 e-6))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45NameMap-treeInsertC-39 arg-2 arg-3 e-5))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-2 e-6 e-7)))) (else (let ((e-8 (vector-ref sc2 1))) (let ((e-10 (car e-8))) (let ((e-9 (cdr e-8))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 0 (vector 2 e-10 e-12 e-13 e-6 e-7))))))))))) (else (let ((sc2 (LibrariesC-45DataC-45NameMap-treeInsertC-39 arg-2 arg-3 e-7))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-5 e-6 e-2)))) (else (let ((e-8 (vector-ref sc2 1))) (let ((e-10 (car e-8))) (let ((e-9 (cdr e-8))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 0 (vector 2 e-5 e-6 e-10 e-12 e-13))))))))))))))))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-11 (vector-ref arg-4 2))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-13 (vector-ref arg-4 4))) (let ((e-14 (vector-ref arg-4 5))) (let ((sc1 (CoreC-45Name-u--C-60C-61_Ord_Name arg-2 e-11))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45NameMap-treeInsertC-39 arg-2 arg-3 e-10))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 2 e-2 e-11 e-12 e-13 e-14)))) (else (let ((e-5 (vector-ref sc2 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-8 e-16 e-15) (cons e-11 (vector 1 e-12 e-13 e-14))))))))))))) (else (let ((sc2 (CoreC-45Name-u--C-60C-61_Ord_Name arg-2 e-13))) (cond ((equal? sc2 1) (let ((sc3 (LibrariesC-45DataC-45NameMap-treeInsertC-39 arg-2 arg-3 e-12))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-10 e-11 e-2 e-13 e-14)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-10 e-11 e-8) (cons e-16 (vector 1 e-15 e-13 e-14))))))))))))) (else (let ((sc3 (LibrariesC-45DataC-45NameMap-treeInsertC-39 arg-2 arg-3 e-14))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-10 e-11 e-12 e-13 e-2)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-10 e-11 e-12) (cons e-13 (vector 1 e-8 e-16 e-15)))))))))))))))))))))))))))
(define LibrariesC-45DataC-45NameMap-treeInsert (lambda (arg-2 arg-3 arg-4) (let ((sc0 (LibrariesC-45DataC-45NameMap-treeInsertC-39 arg-2 arg-3 arg-4))) (case (vector-ref sc0 0) ((0) (let ((e-2 (vector-ref sc0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref sc0 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (vector 1 e-8 e-12 e-13))))))))))))
(define LibrariesC-45DataC-45NameMap-insert (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) (cons 0 (vector 0 arg-1 arg-2)) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (let ((sc1 (LibrariesC-45DataC-45NameMap-treeInsert arg-1 arg-2 e-3))) (case (vector-ref sc1 0) ((0) (let ((e-4 (vector-ref sc1 1))) (cons e-2 e-4))) (else (let ((e-5 (vector-ref sc1 1))) (cons (+ e-2 1) e-5))))))))))
(define csegen-793 (lambda (eta-0) (lambda (eta-1) (PreludeC-45Basics-flip (lambda (eta-2) (PreludeC-45Basics-uncurry (lambda (eta-3) (lambda (eta-4) (lambda (eta-5) (LibrariesC-45DataC-45NameMap-insert eta-3 eta-4 eta-5)))) eta-2)) eta-0 eta-1))))
(define LibrariesC-45DataC-45NameMap-fromList (lambda (arg-1) (PreludeC-45Types-u--foldl_Foldable_List csegen-793 LibrariesC-45DataC-45NameMap-empty arg-1)))
(define CoreC-45Name-isUserName (lambda (arg-0) (case (vector-ref arg-0 0) ((3) 0) ((2) 0) ((0) (let ((e-5 (vector-ref arg-0 2))) (CoreC-45Name-isUserName e-5))) ((4) (let ((e-7 (vector-ref arg-0 2))) (CoreC-45Name-isUserName e-7)))(else 1))))
(define LibrariesC-45DataC-45WithDefault-specified (lambda (ext-0) (box ext-0)))
(define CoreC-45TT-unchecked (cons (vector 0 ) (vector 0 )))
(define LibrariesC-45DataC-45WithDefault-defaulted '())
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-40WithDefaultC-32C-36aC-41C-32C-36defC-41 (lambda (arg-2 arg-3 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 LibrariesC-45DataC-45WithDefault-defaulted)) ((equal? e-5 1) (let ((act-2 (let ((e-2 (cdr arg-2))) ((e-2 arg-3) clam-0)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (LibrariesC-45DataC-45WithDefault-specified e-6))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "WithDefault" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-45Term-apply (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) arg-2 (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (CoreC-45TTC-45Term-apply arg-1 (vector 4 arg-1 arg-2 e-2) e-3))))))
(define CoreC-45FC-emptyFC (vector 2 ))
(define PreludeC-45Types-maybe (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) (arg-2) (let ((e-2 (unbox arg-4))) ((arg-3) e-2)))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40PiInfoC-32C-36tC-41 (lambda (arg-1 arg-2 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (vector 1 (vector 1 ))) ((equal? e-5 2) (vector 1 (vector 2 ))) ((equal? e-5 3) (let ((act-2 (let ((e-2 (cdr arg-1))) ((e-2 arg-2) clam-0)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 3 e-6))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "PiInfo" clam-0)))))) eff-0) ext-0)))))))
(define AlgebraC-45ZeroOneOmega-u--top_Top_ZeroOneOmega 2)
(define csegen-1598 (vector 1 csegen-30))
(define AlgebraC-45Semiring-linear (lambda (arg-1) (let ((e-4 (vector-ref arg-1 3))) e-4)))
(define csegen-1416 (AlgebraC-45Semiring-linear csegen-29))
(define csegen-1599 (vector 1 csegen-1416))
(define CoreC-45TTC-u--fromBuf_TTC_RigCount (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) csegen-1598) ((equal? e-5 1) csegen-1599) ((equal? e-5 2) (vector 1 AlgebraC-45ZeroOneOmega-u--top_Top_ZeroOneOmega))(else (CoreC-45BinaryC-45Prims-corrupt "RigCount" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-45Term-n--6581-4652-u--getFA (lambda (arg-1 arg-2 arg-3) (case (vector-ref arg-3 0) ((4) (let ((e-2 (vector-ref arg-3 2))) (let ((e-3 (vector-ref arg-3 3))) (CoreC-45TTC-45Term-n--6581-4652-u--getFA arg-1 (cons e-3 arg-2) e-2))))(else (cons arg-3 arg-2)))))
(define CoreC-45TTC-45Term-getFnArgs (lambda (arg-1) (CoreC-45TTC-45Term-n--6581-4652-u--getFA arg-1 '() arg-1)))
(define PreludeC-45Types-u--C-60_Ord_Nat (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_Integer arg-0 arg-1) 0)))
(define CoreC-45TTC-u--toBuf_TTC_C-40PiInfoC-32C-36tC-41 (lambda (arg-1 arg-2 arg-3 ext-0) (case (vector-ref arg-3 0) ((0) (CoreC-45BinaryC-45Prims-tag arg-2 0 ext-0)) ((1) (CoreC-45BinaryC-45Prims-tag arg-2 1 ext-0)) ((2) (CoreC-45BinaryC-45Prims-tag arg-2 2 ext-0)) (else (let ((e-4 (vector-ref arg-3 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-2 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-1 (car arg-1))) (((e-1 arg-2) e-4) ext-0))))))))))
(define AlgebraC-45Semiring-elimSemi (lambda (arg-2 arg-3 arg-4 arg-5 arg-6) (let ((sc0 (let ((sc1 (Builtin-snd arg-2))) (let ((e-1 (car sc1))) ((e-1 arg-6) (let ((sc2 (Builtin-fst arg-2))) (let ((e-5 (vector-ref sc2 1))) e-5))))))) (cond ((equal? sc0 1) arg-3) (else (let ((sc1 (let ((sc2 (Builtin-snd arg-2))) (let ((e-1 (car sc2))) ((e-1 arg-6) (let ((sc3 (Builtin-fst arg-2))) (let ((e-4 (vector-ref sc3 3))) e-4))))))) (cond ((equal? sc1 1) arg-4) (else (arg-5 arg-6)))))))))
(define AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else 0))))
(define AlgebraC-45ZeroOneOmega-u--C-47C-61_Eq_ZeroOneOmega (lambda (arg-0 arg-1) (let ((sc0 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-930 (cons (lambda (arg-676) (lambda (arg-679) (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (AlgebraC-45ZeroOneOmega-u--C-47C-61_Eq_ZeroOneOmega arg-686 arg-689)))))
(define csegen-931 (cons csegen-29 csegen-930))
(define CoreC-45TTC-u--toBuf_TTC_RigCount (lambda (arg-0 ext-0) (AlgebraC-45Semiring-elimSemi csegen-931 (lambda (eta-0) (CoreC-45BinaryC-45Prims-tag arg-0 0 eta-0)) (lambda (eta-0) (CoreC-45BinaryC-45Prims-tag arg-0 1 eta-0)) (lambda (eta-0) (lambda (eta-1) (CoreC-45BinaryC-45Prims-tag arg-0 2 eta-1))) ext-0)))
(define CoreC-45TTC-u--toBuf_TTC_C-40BinderC-32C-40TermC-32C-36varsC-41C-41 (lambda (arg-0 arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_RigCount arg-1 e-2) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40PiInfoC-32C-36tC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-3 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-4) ext-0)))))))))))))) ((1) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_RigCount arg-1 e-7) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-8) ext-0)))))))))) ((2) (let ((e-12 (vector-ref arg-2 2))) (let ((e-13 (vector-ref arg-2 3))) (let ((e-14 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_RigCount arg-1 e-12) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40PiInfoC-32C-36tC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-13 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-14) ext-0)))))))))))))) ((3) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_RigCount arg-1 e-17) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40PiInfoC-32C-36tC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-18 ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-19) ext-0)))))))))))))) ((4) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_RigCount arg-1 e-22) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-23) ext-0)))))))))) (else (let ((e-27 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 5 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_RigCount arg-1 e-27) ext-0)))))))))
(define CoreC-45TTC-u--toBuf_TTC_NameType (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) ((2) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-0) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-0 e-1) ext-0)))))))))) (else (let ((e-2 (vector-ref arg-1 1))) (let ((e-3 (vector-ref arg-1 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 e-2) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-0 e-3) ext-0)))))))))))))
(define CoreC-45TTC-u--toBuf_TTC_UseSide (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-3 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (lambda (clam-0) (let ((sc1 (PreludeC-45Types-u--C-60_Ord_Nat e-4 243))) (cond ((equal? sc1 1) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 (bs+ (blodwen-toSignedInt e-4 63) 13 63) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-44 arg-1 e-3) clam-0))))) (else (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 0 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-44 arg-1 e-3) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-1 e-4) clam-0)))))))))))))) ((1) (let ((e-8 (vector-ref arg-2 2))) (let ((e-9 (vector-ref arg-2 3))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 1 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_NameType arg-1 e-8 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-9) eta-0))))))))))) ((2) (let ((e-12 (vector-ref arg-2 2))) (let ((e-14 (vector-ref arg-2 4))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 2 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-12) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-1) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5542 eta-1)))) arg-1 e-14 eta-0))))))))))) ((3) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 3 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-17) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_C-40BinderC-32C-40TermC-32C-36varsC-41C-41 arg-0 arg-1 e-18 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 (cons e-17 arg-0) arg-1 e-19) eta-0))))))))))))))) ((4) (let ((e-21 (vector-ref arg-2 1))) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (let ((sc1 (CoreC-45TTC-45Term-getFnArgs (vector 4 e-21 e-22 e-23)))) (let ((e-2 (car sc1))) (let ((e-3 (cdr sc1))) (lambda (clam-0) (if (null? e-3) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 12 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-2) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-3 clam-0))))))) (let ((e-1 (car e-3))) (let ((e-4 (cdr e-3))) (if (null? e-4) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 4 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-2) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-1) clam-0))))))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 12 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-2) clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-3 clam-0))))))))))))))))))) ((5) (let ((e-26 (vector-ref arg-2 2))) (let ((e-27 (vector-ref arg-2 3))) (let ((e-28 (vector-ref arg-2 4))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 5 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-27) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 (CoreC-45TTC-u--toBuf_TTC_UseSide arg-1 e-26 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-28) eta-0))))))))))))))) ((6) (let ((e-31 (vector-ref arg-2 2))) (let ((e-32 (vector-ref arg-2 3))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 6 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_LazyReason arg-1 e-31 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-32) eta-0))))))))))) ((7) (let ((e-35 (vector-ref arg-2 2))) (let ((e-36 (vector-ref arg-2 3))) (let ((e-37 (vector-ref arg-2 4))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 7 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_LazyReason arg-1 e-35 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-36) eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-37) eta-0))))))))))))))) ((8) (let ((e-40 (vector-ref arg-2 2))) (let ((e-41 (vector-ref arg-2 3))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 8 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_LazyReason arg-1 e-40 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-41) eta-0))))))))))) ((9) (let ((e-44 (vector-ref arg-2 2))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 9 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_Constant arg-1 e-44 eta-0))))))) ((10) (lambda (eta-0) (CoreC-45BinaryC-45Prims-tag arg-1 10 eta-0))) (else (let ((e-50 (vector-ref arg-2 2))) (lambda (eta-0) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 11 eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-50) eta-0))))))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40BinderC-32C-40TermC-32C-36varsC-41C-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40PiInfoC-32C-36tC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-1) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5542 eta-1)))) arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 0 CoreC-45FC-emptyFC e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 1 CoreC-45FC-emptyFC e-6 e-7 (vector 10 CoreC-45FC-emptyFC (vector 0 ))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40PiInfoC-32C-36tC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-1) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5542 eta-1)))) arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 2 CoreC-45FC-emptyFC e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40PiInfoC-32C-36tC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-1) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5542 eta-1)))) arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 3 CoreC-45FC-emptyFC e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 4) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 4 CoreC-45FC-emptyFC e-6 e-7 (vector 10 CoreC-45FC-emptyFC (vector 0 ))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 5) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 5 CoreC-45FC-emptyFC e-6 (vector 10 CoreC-45FC-emptyFC (vector 0 ))))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "Binder" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_NameType (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (vector 1 (vector 1 ))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 2 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 3) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 3 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "NameType" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_UseSide (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1))(else (CoreC-45BinaryC-45Prims-corrupt "UseSide" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-44 arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 ((PreludeC-45Types-maybe (lambda () (lambda (eta-2) (CoreC-45BinaryC-45Prims-corrupt "Term" eta-2))) (lambda () (lambda (eta-2) (lambda (eta-3) (vector 1 eta-2)))) (CoreC-45TTC-getName e-7 arg-0)) eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 0 CoreC-45FC-emptyFC e-6 e-7))))) eff-0) eta-1))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_NameType arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 1 CoreC-45FC-emptyFC e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-1) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5542 eta-1)))) arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 2 CoreC-45FC-emptyFC e-6 0 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40BinderC-32C-40TermC-32C-36varsC-41C-41 arg-0 arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 (cons e-6 arg-0) arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 3 CoreC-45FC-emptyFC e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 4) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 4 CoreC-45FC-emptyFC e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 5) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_UseSide arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 5 CoreC-45FC-emptyFC e-7 e-6 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 6) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_LazyReason arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 6 CoreC-45FC-emptyFC e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 7) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_LazyReason arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 7 CoreC-45FC-emptyFC e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 8) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_LazyReason arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 8 CoreC-45FC-emptyFC e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 9) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Constant arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 9 CoreC-45FC-emptyFC e-6))))) eff-0) clam-0)))))) ((equal? e-5 10) (vector 1 (vector 10 CoreC-45FC-emptyFC (vector 0 )))) ((equal? e-5 11) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 11 CoreC-45FC-emptyFC e-6))))) eff-0) clam-0)))))) ((equal? e-5 12) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-1) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-5542 eta-1)))) arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (CoreC-45TTC-45Term-apply CoreC-45FC-emptyFC e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0))))))(else (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-44 arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (let ((u--idx (PreludeC-45Types-prim__integerToNat (bs- e-5 13 63)))) (lambda (clam-1) (let ((sc2 (CoreC-45TTC-getName u--idx arg-0))) (if (null? sc2) (CoreC-45BinaryC-45Prims-corrupt "Term" clam-1) (vector 1 (vector 0 CoreC-45FC-emptyFC e-6 u--idx)))))))) eff-0) clam-0)))))))))) eff-0) ext-0)))))))
(define CoreC-45ContextC-45Context-holeInit (lambda (arg-0) (cons arg-0 0)))
(define CoreC-45TTC-u--fromBuf_TTC_C-40CaseAltC-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-5 (CoreC-45TTC-u--fromBuf_TTC_C-40CaseTreeC-32C-36varsC-41 (PreludeC-45TypesC-45List-tailRecAppend e-8 arg-0) arg-1 eta-2))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) ((let ((eff-0 (lambda (eta-3) (vector 1 (vector 0 e-6 e-7 e-8 e-9))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40CaseTreeC-32C-36varsC-41 (cons e-6 (cons e-7 arg-0)) arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 1 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Constant arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40CaseTreeC-32C-36varsC-41 arg-0 arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 2 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 3) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40CaseTreeC-32C-36varsC-41 arg-0 arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 3 e-6))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "CaseAlt" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--toBuf_TTC_C-40CaseTreeC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-5 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-1) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-1 e-2) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-3 (vector-ref act-3 1))) (vector 0 e-3))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_C-40CaseAltC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40CaseAltC-32C-36varsC-41 arg-0 arg-5542 eta-0)))) arg-1 e-5 ext-0)))))))))))))) ((1) (let ((e-8 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 e-8) ext-0)))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-1 e-10) ext-0)))))) (else (CoreC-45BinaryC-45Prims-tag arg-1 3 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_C-40CaseAltC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-1) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-1 e-2) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((act-4 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-1 e-3 ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-8 (vector-ref act-4 1))) (vector 0 e-8))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CaseTreeC-32C-36varsC-41 (PreludeC-45TypesC-45List-tailRecAppend e-3 arg-0) arg-1 e-4 ext-0)))))))))))))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-6) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_Name arg-1 e-7) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CaseTreeC-32C-36varsC-41 (cons e-6 (cons e-7 arg-0)) arg-1 e-8 ext-0)))))))))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45TTC-u--toBuf_TTC_Constant arg-1 e-10 ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CaseTreeC-32C-36varsC-41 arg-0 arg-1 e-11 ext-0)))))))))) (else (let ((e-13 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-1 3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_C-40CaseTreeC-32C-36varsC-41 arg-0 arg-1 e-13 ext-0)))))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40CaseTreeC-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-1 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-2) (CoreC-45TTC-u--toBuf_TTC_C-40CaseAltC-32C-36varsC-41 arg-0 arg-5529 arg-5534 eta-2)))) (lambda (arg-5542) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40CaseAltC-32C-36varsC-41 arg-0 arg-5542 eta-2)))) arg-1 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 0 e-6 e-7 (vector 10 CoreC-45FC-emptyFC (vector 0 )) e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 arg-0 arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 0 e-6))))) eff-0) clam-0)))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-1 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-6))))) eff-0) clam-0)))))) ((equal? e-5 3) (vector 1 (vector 3 )))(else (CoreC-45BinaryC-45Prims-corrupt "CaseTree" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_HoleInfo (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 '())) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (box e-6))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "HoleInfo" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_PMDefInfo (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_HoleInfo arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector e-5 e-6 e-7))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_TypeFlags (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-40DPairC-32C-36aC-41C-32C-36pC-41 (lambda (arg-2 arg-3 ext-0) (let ((act-1 (let ((sc0 (Builtin-fst arg-2))) (let ((e-2 (cdr sc0))) ((e-2 arg-3) ext-0))))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (let ((sc1 ((Builtin-snd arg-2) e-5))) (let ((e-2 (cdr sc1))) ((e-2 arg-3) eta-0))))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-40DPairC-32C-36aC-41C-32C-36pC-41 (lambda (arg-2 arg-3 arg-4 ext-0) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((act-1 (let ((sc1 (Builtin-fst arg-2))) (let ((e-1 (car sc1))) (((e-1 arg-3) e-2) ext-0))))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((sc2 ((Builtin-snd arg-2) e-2))) (let ((e-1 (car sc2))) (((e-1 arg-3) e-3) ext-0))))))))))
(define CoreC-45TTC-u--fromBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 (lambda (arg-0 arg-1 ext-0) (if (null? arg-0) (vector 1 '()) (let ((e-3 (cdr arg-0))) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_C-40BinderC-32C-40TermC-32C-36varsC-41C-41 e-3 arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-3 arg-1 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))))
(define CoreC-45TTC-u--toBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2) (lambda (clam-0) (if (null? arg-0) (vector 1 (vector 0 )) (let ((e-3 (cdr arg-0))) (let ((e-8 (car arg-2))) (let ((e-9 (cdr arg-2))) (let ((act-1 (CoreC-45TTC-u--toBuf_TTC_C-40BinderC-32C-40TermC-32C-36varsC-41C-41 e-3 arg-1 e-8 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-3 arg-1 e-9) clam-0)))))))))))
(define csegen-1577 (cons (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-5542 eta-0)))) (lambda (u--y) (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (arg-5530) (lambda (arg-5535) (CoreC-45TTC-u--toBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 u--y arg-5530 arg-5535))) (lambda (arg-5542) (lambda (eta-1) (CoreC-45TTC-u--fromBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 u--y arg-5542 eta-1)))) (cons (lambda (arg-5530) (lambda (arg-5535) (lambda (eta-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (arg-5531) (lambda (arg-5536) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5531 arg-5536))) (lambda (arg-5542) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5542 eta-2)))) (cons (lambda (arg-5531) (lambda (arg-5536) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5531 arg-5536))) (lambda (arg-5542) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5542 eta-2))))) arg-5530 arg-5535 eta-1)))) (lambda (arg-5542) (lambda (eta-1) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (arg-5530) (lambda (arg-5535) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5530 arg-5535))) (lambda (arg-5543) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5543 eta-2)))) (cons (lambda (arg-5530) (lambda (arg-5535) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5530 arg-5535))) (lambda (arg-5543) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5543 eta-2))))) arg-5542 eta-1))))) arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 u--y arg-5529 arg-5534))) (lambda (arg-5543) (lambda (eta-1) (CoreC-45TTC-u--fromBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 u--y arg-5543 eta-1)))) (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-1) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (arg-5530) (lambda (arg-5535) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5530 arg-5535))) (lambda (arg-5543) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5543 eta-2)))) (cons (lambda (arg-5530) (lambda (arg-5535) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5530 arg-5535))) (lambda (arg-5543) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5543 eta-2))))) arg-5529 arg-5534 eta-1)))) (lambda (arg-5543) (lambda (eta-1) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5529 arg-5534))) (lambda (arg-5544) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5544 eta-2)))) (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5529 arg-5534))) (lambda (arg-5544) (lambda (eta-2) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 u--y arg-5544 eta-2))))) arg-5543 eta-1))))) arg-5542 eta-0)))))))
(define csegen-1580 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-40DPairC-32C-36aC-41C-32C-36pC-41 csegen-1577 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-40DPairC-32C-36aC-41C-32C-36pC-41 csegen-1577 arg-5542 eta-0)))))
(define csegen-1581 (cons csegen-44 csegen-1535))
(define csegen-1584 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1581 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1581 arg-5542 eta-0)))))
(define csegen-1587 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1535 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1535 arg-5542 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_Def (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PMDefInfo arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40CaseTreeC-32C-36varsC-41 e-7 arg-0 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-5 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1580 arg-0 eta-2))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) ((let ((eff-0 (lambda (eta-3) (vector 1 (vector 1 e-6 e-7 e-8 (vector 2 "") e-9))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-6))))) eff-0) clam-0)))))) ((equal? e-5 3) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1559 arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 3 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 4) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1584 arg-0 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 5 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 5) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1535 arg-0 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-5 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1535 arg-0 eta-2))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) ((let ((eff-0 (lambda (eta-3) (let ((act-6 (CoreC-45TTC-u--fromBuf_TTC_TypeFlags arg-0 eta-3))) (case (vector-ref act-6 0) ((0) (let ((e-2 (vector-ref act-6 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-6 1))) ((let ((eff-0 (lambda (eta-4) (let ((act-7 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-0 eta-4))) (case (vector-ref act-7 0) ((0) (let ((e-2 (vector-ref act-7 1))) (vector 0 e-2))) (else (let ((e-11 (vector-ref act-7 1))) ((let ((eff-0 (lambda (eta-5) (let ((act-8 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-0 eta-5))) (case (vector-ref act-8 0) ((0) (let ((e-2 (vector-ref act-8 1))) (vector 0 e-2))) (else (let ((e-12 (vector-ref act-8 1))) ((let ((eff-0 (lambda (eta-6) (let ((act-9 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-1587 arg-0 eta-6))) (case (vector-ref act-9 0) ((0) (let ((e-2 (vector-ref act-9 1))) (vector 0 e-2))) (else (let ((e-13 (vector-ref act-9 1))) ((let ((eff-0 (lambda (eta-7) (vector 1 (vector 6 e-6 e-7 e-8 e-9 e-10 e-11 e-12 e-13))))) eff-0) eta-6)))))))) eff-0) eta-5)))))))) eff-0) eta-4)))))))) eff-0) eta-3)))))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 6) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 7 e-6 (CoreC-45ContextC-45Context-holeInit e-7)))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 7) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 8 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 8) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 '() arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1562 arg-0 eta-1))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 9 e-6 e-7 e-8))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 9) (vector 1 (vector 10 ))) ((equal? e-5 10) (vector 1 (vector 12 ))) ((equal? e-5 11) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Integer arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 11 e-6))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "Def" clam-0)))))) eff-0) ext-0)))))))
(define csegen-1590 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 '() arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 '() arg-5542 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_Covering (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1590 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-6))))) eff-0) clam-0)))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-6))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "Covering" clam-0)))))) eff-0) ext-0)))))))
(define csegen-1553 (cons (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_FC arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_FC arg-5542 eta-0)))) csegen-41))
(define csegen-1556 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1553 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1553 arg-5542 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_PartialReason (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-6))))) eff-0) clam-0)))))) ((equal? e-5 2) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1556 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 eta-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 2 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) clam-0)))))) ((equal? e-5 3) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1556 arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 3 e-6))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "PartialReason" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_Terminating (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (vector 1 (vector 1 ))) ((equal? e-5 2) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_PartialReason arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-6))))) eff-0) clam-0))))))(else (CoreC-45BinaryC-45Prims-corrupt "Terminating" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_Totality (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_Terminating arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Covering arg-0 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define PreludeC-45Types-u--map_Functor_Maybe (lambda (arg-2 arg-3) (if (null? arg-3) '() (let ((e-1 (unbox arg-3))) (box (arg-2 e-1))))))
(define CoreC-45TTC-u--fromBuf_TTC_Visibility (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1)) ((equal? e-5 2) (vector 1 2))(else (CoreC-45BinaryC-45Prims-corrupt "Visibility" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--toBuf_TTC_Visibility (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((equal? arg-1 1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)))))
(define csegen-1566 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_Visibility arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_Visibility arg-5542 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_TotalReq (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1)) ((equal? e-5 2) (vector 1 2))(else (CoreC-45BinaryC-45Prims-corrupt "TotalReq" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--fromBuf_TTC_DefFlag (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 2) (vector 1 (vector 0 ))) ((equal? e-5 3) (vector 1 (vector 3 ))) ((equal? e-5 4) (vector 1 (vector 4 ))) ((equal? e-5 5) (vector 1 (vector 5 ))) ((equal? e-5 6) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_TotalReq arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 6 e-6))))) eff-0) clam-0)))))) ((equal? e-5 7) (vector 1 (vector 7 ))) ((equal? e-5 8) (vector 1 (vector 8 ))) ((equal? e-5 9) (vector 1 (vector 9 '()))) ((equal? e-5 10) (vector 1 (vector 10 ))) ((equal? e-5 11) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_ConInfo arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 11 e-6))))) eff-0) clam-0)))))) ((equal? e-5 12) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Nat arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 12 e-6))))) eff-0) clam-0)))))) ((equal? e-5 13) (vector 1 (vector 1 ))) ((equal? e-5 15) (vector 1 (vector 2 )))(else (CoreC-45BinaryC-45Prims-corrupt "DefFlag" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--toBuf_TTC_TotalReq (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((equal? arg-1 1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)))))
(define CoreC-45TTC-u--toBuf_TTC_DefFlag (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)) ((1) (CoreC-45BinaryC-45Prims-tag arg-0 13 ext-0)) ((2) (CoreC-45BinaryC-45Prims-tag arg-0 15 ext-0)) ((3) (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0)) ((4) (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0)) ((5) (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0)) ((6) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_TotalReq arg-0 e-0 ext-0)))))) ((7) (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0)) ((8) (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0)) ((9) (CoreC-45BinaryC-45Prims-tag arg-0 9 ext-0)) ((10) (CoreC-45BinaryC-45Prims-tag arg-0 10 ext-0)) ((11) (let ((e-2 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (CoreC-45TTC-u--toBuf_TTC_ConInfo arg-0 e-2 ext-0)))))) (else (let ((e-3 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 12 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Nat arg-0 e-3) ext-0)))))))))
(define csegen-1569 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_DefFlag arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_DefFlag arg-5542 eta-0)))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 ext-0) (let ((act-1 (let ((e-2 (cdr arg-1))) ((e-2 arg-2) ext-0)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 arg-1 arg-2 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3 ext-0) (let ((act-1 (let ((e-1 (car arg-1))) (((e-1 arg-2) (let ((e-4 (car arg-3))) e-4)) ext-0)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 arg-1 arg-2 (let ((e-2 (cdr arg-3))) e-2) ext-0))))))
(define CoreC-45TTC-u--fromBuf_TTC_SizeChange (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 0)) ((equal? e-5 1) (vector 1 1)) ((equal? e-5 2) (vector 1 2))(else (CoreC-45BinaryC-45Prims-corrupt "SizeChange" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--toBuf_TTC_SizeChange (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((equal? arg-1 1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)))))
(define csegen-1539 (cons csegen-1535 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_SizeChange arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_SizeChange arg-5542 eta-0))))))
(define csegen-1542 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1539 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1539 arg-5542 eta-0)))))
(define csegen-1546 (cons csegen-1535 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40List1C-32C-36aC-41 csegen-1542 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40List1C-32C-36aC-41 csegen-1542 arg-5542 eta-0))))))
(define csegen-1549 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1546 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1546 arg-5542 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_SCCall (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1549 arg-0 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_FC arg-0 eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector e-5 e-6 e-7))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--toBuf_TTC_SCCall (lambda (arg-0 arg-1 ext-0) (let ((act-1 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 (let ((e-0 (vector-ref arg-1 0))) e-0)) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1549 arg-0 (let ((e-1 (vector-ref arg-1 1))) e-1) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (CoreC-45TTC-u--toBuf_TTC_FC arg-0 (let ((e-2 (vector-ref arg-1 2))) e-2) ext-0)))))))))
(define csegen-1572 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_SCCall arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_SCCall arg-5542 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_GlobalDef (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-38 arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-51 arg-0 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (let ((u--refsR (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-1) (LibrariesC-45DataC-45NameMap-fromList eta-1)) e-6))) (lambda (eta-1) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_FC arg-0 eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_RigCount arg-0 eta-2))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-3) (let ((act-5 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 eta-3))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) ((let ((eff-0 (lambda (eta-4) (let ((act-6 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-51 arg-0 eta-4))) (case (vector-ref act-6 0) ((0) (let ((e-2 (vector-ref act-6 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-6 1))) ((let ((eff-0 (let ((u--refs (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-5) (LibrariesC-45DataC-45NameMap-fromList eta-5)) e-10))) (lambda (eta-5) (let ((act-7 (CoreC-45TTC-u--fromBuf_TTC_Def arg-0 eta-5))) (case (vector-ref act-7 0) ((0) (let ((e-2 (vector-ref act-7 1))) (vector 0 e-2))) (else (let ((e-11 (vector-ref act-7 1))) ((let ((eff-0 (lambda (clam-0) (let ((sc7 (CoreC-45Name-isUserName e-9))) (cond ((equal? sc7 1) (let ((act-8 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 '() arg-0 clam-0))) (case (vector-ref act-8 0) ((0) (let ((e-2 (vector-ref act-8 1))) (vector 0 e-2))) (else (let ((e-12 (vector-ref act-8 1))) ((let ((eff-0 (lambda (eta-6) (let ((act-9 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1535 arg-0 eta-6))) (case (vector-ref act-9 0) ((0) (let ((e-2 (vector-ref act-9 1))) (vector 0 e-2))) (else (let ((e-13 (vector-ref act-9 1))) ((let ((eff-0 (lambda (eta-7) (let ((act-10 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1535 arg-0 eta-7))) (case (vector-ref act-10 0) ((0) (let ((e-2 (vector-ref act-10 1))) (vector 0 e-2))) (else (let ((e-14 (vector-ref act-10 1))) ((let ((eff-0 (lambda (eta-8) (let ((act-11 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1535 arg-0 eta-8))) (case (vector-ref act-11 0) ((0) (let ((e-2 (vector-ref act-11 1))) (vector 0 e-2))) (else (let ((e-15 (vector-ref act-11 1))) ((let ((eff-0 (lambda (eta-9) (let ((act-12 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1535 arg-0 eta-9))) (case (vector-ref act-12 0) ((0) (let ((e-2 (vector-ref act-12 1))) (vector 0 e-2))) (else (let ((e-16 (vector-ref act-12 1))) ((let ((eff-0 (lambda (eta-10) (let ((act-13 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-0 eta-10))) (case (vector-ref act-13 0) ((0) (let ((e-2 (vector-ref act-13 1))) (vector 0 e-2))) (else (let ((e-17 (vector-ref act-13 1))) ((let ((eff-0 (lambda (eta-11) (let ((act-14 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-40WithDefaultC-32C-36aC-41C-32C-36defC-41 csegen-1566 arg-0 eta-11))) (case (vector-ref act-14 0) ((0) (let ((e-2 (vector-ref act-14 1))) (vector 0 e-2))) (else (let ((e-18 (vector-ref act-14 1))) ((let ((eff-0 (lambda (eta-12) (let ((act-15 (CoreC-45TTC-u--fromBuf_TTC_Totality arg-0 eta-12))) (case (vector-ref act-15 0) ((0) (let ((e-2 (vector-ref act-15 1))) (vector 0 e-2))) (else (let ((e-19 (vector-ref act-15 1))) ((let ((eff-0 (lambda (eta-13) (let ((act-16 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 eta-13))) (case (vector-ref act-16 0) ((0) (let ((e-2 (vector-ref act-16 1))) (vector 0 e-2))) (else (let ((e-20 (vector-ref act-16 1))) ((let ((eff-0 (lambda (eta-14) (let ((act-17 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1569 arg-0 eta-14))) (case (vector-ref act-17 0) ((0) (let ((e-2 (vector-ref act-17 1))) (vector 0 e-2))) (else (let ((e-21 (vector-ref act-17 1))) ((let ((eff-0 (lambda (eta-15) (let ((act-18 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 eta-15))) (case (vector-ref act-18 0) ((0) (let ((e-2 (vector-ref act-18 1))) (vector 0 e-2))) (else (let ((e-22 (vector-ref act-18 1))) ((let ((eff-0 (lambda (eta-16) (let ((act-19 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Bool arg-0 eta-16))) (case (vector-ref act-19 0) ((0) (let ((e-2 (vector-ref act-19 1))) (vector 0 e-2))) (else (let ((e-23 (vector-ref act-19 1))) ((let ((eff-0 (lambda (eta-17) (let ((act-20 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1572 arg-0 eta-17))) (case (vector-ref act-20 0) ((0) (let ((e-2 (vector-ref act-20 1))) (vector 0 e-2))) (else (let ((e-24 (vector-ref act-20 1))) ((let ((eff-0 (lambda (eta-18) (vector 1 (vector e-7 e-9 e-12 e-13 e-14 e-15 e-16 e-8 e-17 e-18 e-19 e-20 e-21 u--refs u--refsR e-22 e-23 1 e-11 e-5 '() e-24 '()))))) eff-0) eta-17)))))))) eff-0) eta-16)))))))) eff-0) eta-15)))))))) eff-0) eta-14)))))))) eff-0) eta-13)))))))) eff-0) eta-12)))))))) eff-0) eta-11)))))))) eff-0) eta-10)))))))) eff-0) eta-9)))))))) eff-0) eta-8)))))))) eff-0) eta-7)))))))) eff-0) eta-6)))))))) eff-0) clam-0)))))) (else (vector 1 (vector e-7 e-9 (vector 10 e-7 (vector 0 )) '() '() '() '() e-8 '() (LibrariesC-45DataC-45WithDefault-specified 2) CoreC-45TT-unchecked 0 '() u--refs u--refsR 0 0 1 e-11 e-5 '() '() '())))))))) eff-0) eta-5))))))))) eff-0) eta-4)))))))) eff-0) eta-3)))))))) eff-0) eta-2)))))))) eff-0) eta-1))))))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45Core-traverseC-39 (lambda (arg-2 arg-3 arg-4) (if (null? arg-3) (lambda (eta-0) (vector 1 (PreludeC-45TypesC-45List-reverse arg-4))) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (let ((eff-0 (arg-2 e-2))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (CoreC-45Core-traverseC-39 arg-2 e-3 (cons e-5 arg-4)))) eff-1) world-0))))))))))))
(define CoreC-45Context-u--resolved_HasNames_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3 ext-0) (if (null? arg-3) (vector 1 '()) (let ((e-2 (unbox arg-3))) (let ((act-1 (let ((e-3 (cdr arg-1))) (((e-3 arg-2) e-2) ext-0)))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (box e-5))))) eff-0) ext-0)))))))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((e-6 (car arg-5))) (let ((e-7 (cdr arg-5))) (let ((sc2 (let ((e-1 (car arg-2))) ((e-1 e-2) e-6)))) (cond ((equal? sc2 1) (let ((e-1 (car arg-3))) ((e-1 e-3) e-7))) (else 0)))))))))
(define PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-2) (if (null? arg-3) 1 0) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (if (null? arg-3) 0 (let ((e-6 (car arg-3))) (let ((e-7 (cdr arg-3))) (let ((sc2 (let ((e-1 (car arg-1))) ((e-1 e-2) e-6)))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 arg-1 e-3 e-7)) (else 0)))))))))))
(define CoreC-45NameC-45Namespace-u--C-61C-61_Eq_Namespace (lambda (arg-0 arg-1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-22 arg-0 arg-1)))
(define CoreC-45Name-u--C-61C-61_Eq_UserName (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-2 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-0 e-2)))(else 0)))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-3 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-1 e-3)))(else 0)))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0)))(else 0))))
(define CoreC-45Name-u--C-61C-61_Eq_Name (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((0) (let ((e-16 (vector-ref arg-1 1))) (let ((e-17 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45Name-u--C-61C-61_Eq_Name e-1 e-17))) (cond ((equal? sc2 1) (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_Namespace e-0 e-16)) (else 0))))))(else 0))))) ((1) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-18 (vector-ref arg-1 1))) (CoreC-45Name-u--C-61C-61_Eq_UserName e-2 e-18)))(else 0)))) ((2) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((2) (let ((e-19 (vector-ref arg-1 1))) (let ((e-20 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-4 e-20))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-3 e-19)) (else 0))))))(else 0))))) ((3) (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((3) (let ((e-21 (vector-ref arg-1 1))) (let ((e-22 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45Name-u--C-61C-61_Eq_Name e-5 e-21))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-6 e-22)) (else 0))))))(else 0))))) ((4) (let ((e-8 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((4) (let ((e-24 (vector-ref arg-1 2))) (CoreC-45Name-u--C-61C-61_Eq_Name e-8 e-24)))(else 0)))) ((5) (let ((e-9 (vector-ref arg-0 1))) (let ((e-10 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((5) (let ((e-25 (vector-ref arg-1 1))) (let ((e-26 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-223 csegen-223 e-9 e-25))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-10 e-26)) (else 0))))))(else 0))))) ((6) (let ((e-11 (vector-ref arg-0 1))) (let ((e-12 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((6) (let ((e-27 (vector-ref arg-1 1))) (let ((e-28 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-12 e-28))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-11 e-27)) (else 0))))))(else 0))))) ((7) (let ((e-13 (vector-ref arg-0 1))) (let ((e-14 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((7) (let ((e-29 (vector-ref arg-1 1))) (let ((e-30 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-14 e-30))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-13 e-29)) (else 0))))))(else 0))))) ((8) (let ((e-15 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-31 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-15 e-31)))(else 0))))(else 0))))
(define LibrariesC-45DataC-45NameMap-treeLookup (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (let ((e-1 (vector-ref arg-3 1))) (let ((e-2 (vector-ref arg-3 2))) (let ((sc1 (CoreC-45Name-u--C-61C-61_Eq_Name arg-2 e-1))) (cond ((equal? sc1 1) (box e-2)) (else '())))))) ((1) (let ((e-5 (vector-ref arg-3 1))) (let ((e-6 (vector-ref arg-3 2))) (let ((e-7 (vector-ref arg-3 3))) (let ((sc1 (CoreC-45Name-u--C-60C-61_Ord_Name arg-2 e-6))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45NameMap-treeLookup arg-2 e-5)) (else (LibrariesC-45DataC-45NameMap-treeLookup arg-2 e-7)))))))) (else (let ((e-10 (vector-ref arg-3 1))) (let ((e-11 (vector-ref arg-3 2))) (let ((e-12 (vector-ref arg-3 3))) (let ((e-13 (vector-ref arg-3 4))) (let ((e-14 (vector-ref arg-3 5))) (let ((sc1 (CoreC-45Name-u--C-60C-61_Ord_Name arg-2 e-11))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45NameMap-treeLookup arg-2 e-10)) (else (let ((sc2 (CoreC-45Name-u--C-60C-61_Ord_Name arg-2 e-13))) (cond ((equal? sc2 1) (LibrariesC-45DataC-45NameMap-treeLookup arg-2 e-12)) (else (LibrariesC-45DataC-45NameMap-treeLookup arg-2 e-14))))))))))))))))
(define LibrariesC-45DataC-45NameMap-lookup (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-3 (cdr arg-2))) (LibrariesC-45DataC-45NameMap-treeLookup arg-1 e-3)))))
(define CoreC-45Context-getNameID (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((8) (let ((e-0 (vector-ref arg-0 1))) (box e-0)))(else (LibrariesC-45DataC-45NameMap-lookup arg-0 (let ((e-2 (vector-ref arg-1 2))) e-2))))))
(define CoreC-45CoreC-45PiInfo-traverse (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((1) (lambda (eta-0) (vector 1 (vector 1 )))) ((0) (lambda (eta-0) (vector 1 (vector 0 )))) ((2) (lambda (eta-0) (vector 1 (vector 2 )))) (else (let ((e-4 (vector-ref arg-3 1))) (let ((eff-0 (arg-2 e-4))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (lambda (eta-0) (vector 1 (vector 3 e-5))))) eff-1) world-0))))))))))))
(define CoreC-45CoreC-45Binder-traverse (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (let ((e-1 (vector-ref arg-3 1))) (let ((e-2 (vector-ref arg-3 2))) (let ((e-3 (vector-ref arg-3 3))) (let ((e-4 (vector-ref arg-3 4))) (let ((eff-0 (CoreC-45CoreC-45PiInfo-traverse arg-2 e-3))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (let ((eff-1 (arg-2 e-4))) (lambda (world-1) (let ((act-2 (eff-1 world-1))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-2 (lambda (eta-0) (vector 1 (vector 0 e-1 e-2 e-5 e-6))))) eff-2) world-1))))))))) eff-1) world-0)))))))))))) ((1) (let ((e-6 (vector-ref arg-3 1))) (let ((e-7 (vector-ref arg-3 2))) (let ((e-8 (vector-ref arg-3 3))) (let ((e-9 (vector-ref arg-3 4))) (let ((eff-0 (arg-2 e-8))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (let ((eff-1 (arg-2 e-9))) (lambda (world-1) (let ((act-2 (eff-1 world-1))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-2 1))) ((let ((eff-2 (lambda (eta-0) (vector 1 (vector 1 e-6 e-7 e-5 e-10))))) eff-2) world-1))))))))) eff-1) world-0)))))))))))) ((2) (let ((e-11 (vector-ref arg-3 1))) (let ((e-12 (vector-ref arg-3 2))) (let ((e-13 (vector-ref arg-3 3))) (let ((e-14 (vector-ref arg-3 4))) (let ((eff-0 (CoreC-45CoreC-45PiInfo-traverse arg-2 e-13))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (let ((eff-1 (arg-2 e-14))) (lambda (world-1) (let ((act-2 (eff-1 world-1))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-2 (lambda (eta-0) (vector 1 (vector 2 e-11 e-12 e-5 e-6))))) eff-2) world-1))))))))) eff-1) world-0)))))))))))) ((3) (let ((e-16 (vector-ref arg-3 1))) (let ((e-17 (vector-ref arg-3 2))) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (let ((eff-0 (CoreC-45CoreC-45PiInfo-traverse arg-2 e-18))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (let ((eff-1 (arg-2 e-19))) (lambda (world-1) (let ((act-2 (eff-1 world-1))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-2 (lambda (eta-0) (vector 1 (vector 3 e-16 e-17 e-5 e-6))))) eff-2) world-1))))))))) eff-1) world-0)))))))))))) ((4) (let ((e-21 (vector-ref arg-3 1))) (let ((e-22 (vector-ref arg-3 2))) (let ((e-23 (vector-ref arg-3 3))) (let ((e-24 (vector-ref arg-3 4))) (let ((eff-0 (arg-2 e-23))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (let ((eff-1 (arg-2 e-24))) (lambda (world-1) (let ((act-2 (eff-1 world-1))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-2 (lambda (eta-0) (vector 1 (vector 4 e-21 e-22 e-5 e-6))))) eff-2) world-1))))))))) eff-1) world-0)))))))))))) (else (let ((e-26 (vector-ref arg-3 1))) (let ((e-27 (vector-ref arg-3 2))) (let ((e-28 (vector-ref arg-3 3))) (let ((eff-0 (arg-2 e-28))) (lambda (world-0) (let ((act-1 (eff-0 world-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-1 (lambda (eta-0) (vector 1 (vector 5 e-26 e-27 e-5))))) eff-1) world-0))))))))))))))
(define CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 (lambda (arg-1 arg-2) (lambda (clam-0) (case (vector-ref arg-2 0) ((1) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((sc1 (CoreC-45Context-getNameID e-3 arg-1))) (if (null? sc1) (vector 1 (vector 1 e-1 e-2 e-3)) (let ((e-4 (unbox sc1))) (vector 1 (vector 1 e-1 e-2 (vector 8 e-4)))))))))) ((2) (let ((e-5 (vector-ref arg-2 1))) (let ((e-6 (vector-ref arg-2 2))) (let ((e-7 (vector-ref arg-2 3))) (let ((e-8 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (arg-3) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 arg-3)) e-8 '()) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-1) (let ((sc2 (CoreC-45Context-getNameID e-6 arg-1))) (if (null? sc2) (vector 1 (vector 2 e-5 e-6 e-7 e-9)) (let ((e-1 (unbox sc2))) (vector 1 (vector 2 e-5 e-6 e-1 e-9)))))))) eff-0) clam-0)))))))))) ((3) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45CoreC-45Binder-traverse (lambda (arg-3) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 arg-3)) e-12) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-13) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 3 e-10 e-11 e-5 e-6))))) eff-0) eta-0)))))))) eff-0) clam-0)))))))))) ((4) (let ((e-15 (vector-ref arg-2 1))) (let ((e-16 (vector-ref arg-2 2))) (let ((e-17 (vector-ref arg-2 3))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-16) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-17) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 4 e-15 e-5 e-6))))) eff-0) eta-0)))))))) eff-0) clam-0))))))))) ((5) (let ((e-19 (vector-ref arg-2 1))) (let ((e-20 (vector-ref arg-2 2))) (let ((e-21 (vector-ref arg-2 3))) (let ((e-22 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-21) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-22) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 5 e-19 e-20 e-5 e-6))))) eff-0) eta-0)))))))) eff-0) clam-0)))))))))) ((6) (let ((e-24 (vector-ref arg-2 1))) (let ((e-25 (vector-ref arg-2 2))) (let ((e-26 (vector-ref arg-2 3))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-26) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 6 e-24 e-25 e-5))))) eff-0) clam-0))))))))) ((7) (let ((e-28 (vector-ref arg-2 1))) (let ((e-29 (vector-ref arg-2 2))) (let ((e-30 (vector-ref arg-2 3))) (let ((e-31 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-30) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-31) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 7 e-28 e-29 e-5 e-6))))) eff-0) eta-0)))))))) eff-0) clam-0)))))))))) ((8) (let ((e-33 (vector-ref arg-2 1))) (let ((e-34 (vector-ref arg-2 2))) (let ((e-35 (vector-ref arg-2 3))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-35) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 8 e-33 e-34 e-5))))) eff-0) clam-0))))))))) ((11) (let ((e-37 (vector-ref arg-2 1))) (let ((e-38 (vector-ref arg-2 2))) (let ((sc1 (CoreC-45Context-getNameID e-38 arg-1))) (if (null? sc1) (vector 1 (vector 11 e-37 e-38)) (let ((e-1 (unbox sc1))) (vector 1 (vector 11 e-37 (vector 8 e-1)))))))))(else (vector 1 arg-2))))))
(define CoreC-45Context-u--resolved_HasNames_C-40CaseAltC-32C-36varsC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-1) (let ((sc2 (CoreC-45Context-getNameID e-1 arg-1))) (if (null? sc2) (vector 1 (vector 0 e-1 e-2 e-3 e-5)) (let ((e-6 (unbox sc2))) (vector 1 (vector 0 (vector 8 e-6) e-2 e-3 e-5)))))))) eff-0) ext-0)))))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-8 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-6 e-7 e-5))))) eff-0) ext-0))))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-10 e-5))))) eff-0) ext-0)))))))) (else (let ((e-13 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-13 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 3 e-5))))) eff-0) ext-0))))))))))
(define CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-4) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-6 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Core-traverseC-39 (lambda (arg-3) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40CaseAltC-32C-36varsC-41 arg-1 arg-3 eta-1))) e-5 '()) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((e-7 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 0 e-1 e-2 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))))) ((1) (let ((e-7 (vector-ref arg-2 1))) (let ((e-8 (vector-ref arg-2 2))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-8) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-7 e-5))))) eff-0) ext-0))))))))(else (vector 1 arg-2)))))
(define CoreC-45Context-u--resolved_HasNames_Name (lambda (arg-0 arg-1) (lambda (clam-0) (case (vector-ref arg-1 0) ((8) (let ((e-0 (vector-ref arg-1 1))) (vector 1 (vector 8 e-0))))(else (let ((sc0 (CoreC-45Context-getNameID arg-1 arg-0))) (if (null? sc0) (vector 1 arg-1) (let ((e-1 (unbox sc0))) (vector 1 (vector 8 e-1))))))))))
(define CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 (lambda (arg-1 arg-2 ext-0) (if (null? arg-2) (vector 1 '()) (let ((e-4 (car arg-2))) (let ((e-5 (cdr arg-2))) (let ((act-1 ((CoreC-45CoreC-45Binder-traverse (lambda (arg-3) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-1 arg-3)) e-4) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-1 e-5 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-6 e-7))))) eff-0) eta-0)))))))) eff-0) ext-0))))))))))
(define CoreC-45Context-n--13902-9841-u--resolvedNamesPat (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 arg-6) (let ((e-2 (car arg-6))) (let ((e-3 (cdr arg-6))) (lambda (clam-0) (let ((e-6 (car e-3))) (let ((e-7 (cdr e-3))) (let ((e-10 (car e-7))) (let ((e-11 (cdr e-7))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-5 e-6 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-5 e-10) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-8 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-3 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-5 e-11) eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-4 (vector-ref act-3 1))) (vector 0 e-4))) (else (let ((e-9 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (cons e-2 (cons e-5 (cons e-8 e-9))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0))))))))))))))
(define CoreC-45Context-u--resolved_HasNames_Def (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((e-2 (vector-ref arg-1 3))) (let ((e-3 (vector-ref arg-1 4))) (let ((e-4 (vector-ref arg-1 5))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-0 e-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Context-u--resolved_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-0 e-3 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-3 ((CoreC-45Core-traverseC-39 (lambda (eta-2) (CoreC-45Context-n--13902-9841-u--resolvedNamesPat e-4 e-1 e-3 e-2 e-0 arg-0 eta-2)) e-4 '()) eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 1 e-0 e-1 e-5 e-6 e-7))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) ext-0))))))))))) ((6) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (let ((e-7 (vector-ref arg-1 3))) (let ((e-8 (vector-ref arg-1 4))) (let ((e-9 (vector-ref arg-1 5))) (let ((e-10 (vector-ref arg-1 6))) (let ((e-11 (vector-ref arg-1 7))) (let ((e-12 (vector-ref arg-1 8))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-0)) e-10 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-13 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Core-traverseC-39 (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-1)) e-11 '()) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-14 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 6 e-5 e-6 e-7 e-8 e-9 e-13 e-14 e-12))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))))))))) ((8) (let ((e-13 (vector-ref arg-1 1))) (let ((e-14 (vector-ref arg-1 2))) (let ((e-15 (vector-ref arg-1 3))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-0 e-15) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 8 e-13 e-14 e-5))))) eff-0) ext-0))))))))) ((9) (let ((e-16 (vector-ref arg-1 1))) (let ((e-17 (vector-ref arg-1 2))) (let ((e-18 (vector-ref arg-1 3))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-16) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 9 e-5 e-17 e-18))))) eff-0) ext-0)))))))))(else (vector 1 arg-1)))))
(define CoreC-45Context-u--resolved_HasNames_SCCall (lambda (arg-0 arg-1 ext-0) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-0 (let ((e-0 (vector-ref arg-1 0))) e-0)) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (vector e-5 e-1 e-2))))))) eff-0) ext-0)))))))
(define CoreC-45Context-u--resolved_HasNames_Covering (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (vector 1 (vector 0 ))) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 eta-0)) e-0 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-5))))) eff-0) ext-0))))))) (else (let ((e-1 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-0)) e-1 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-5))))) eff-0) ext-0))))))))))
(define CoreC-45Core-traversePair (lambda (arg-3 arg-4) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((eff-0 (arg-3 e-3))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-4 (vector-ref eta-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (cons e-2 e-5)))))) eff-0 eta-0)))))))
(define CoreC-45Context-u--resolved_HasNames_PartialReason (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (vector 1 (vector 0 ))) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-0)) e-0 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-5))))) eff-0) ext-0))))))) ((2) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-1)) eta-0)) e-1 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_Name arg-0 e-2) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 2 e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))) (else (let ((e-3 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-1)) eta-0)) e-3 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 3 e-5))))) eff-0) ext-0))))))))))
(define CoreC-45Context-u--resolved_HasNames_Terminating (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((2) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_PartialReason arg-0 e-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-5))))) eff-0) ext-0)))))))(else (vector 1 arg-1)))))
(define CoreC-45Context-u--resolved_HasNames_Totality (lambda (arg-0 arg-1 ext-0) (let ((e-0 (car arg-1))) (let ((e-1 (cdr arg-1))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_Terminating arg-0 e-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Context-u--resolved_HasNames_Covering arg-0 e-1 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))))
(define LibrariesC-45DataC-45NameMap-n--5790-11773-u--treeToListC-39 (lambda (arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) (let ((e-2 (vector-ref arg-4 2))) (cons (cons e-1 e-2) arg-3)))) ((1) (let ((e-5 (vector-ref arg-4 1))) (let ((e-7 (vector-ref arg-4 3))) (LibrariesC-45DataC-45NameMap-n--5790-11773-u--treeToListC-39 (LibrariesC-45DataC-45NameMap-n--5790-11773-u--treeToListC-39 arg-3 e-7) e-5)))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-14 (vector-ref arg-4 5))) (LibrariesC-45DataC-45NameMap-n--5790-11773-u--treeToListC-39 (LibrariesC-45DataC-45NameMap-n--5790-11773-u--treeToListC-39 (LibrariesC-45DataC-45NameMap-n--5790-11773-u--treeToListC-39 arg-3 e-14) e-12) e-10))))))))
(define LibrariesC-45DataC-45NameMap-treeToList (lambda (ext-0) (LibrariesC-45DataC-45NameMap-n--5790-11773-u--treeToListC-39 '() ext-0)))
(define LibrariesC-45DataC-45NameMap-toList (lambda (arg-1) (if (null? arg-1) '() (let ((e-3 (cdr arg-1))) (LibrariesC-45DataC-45NameMap-treeToList e-3)))))
(define CoreC-45Context-n--14542-10294-u--insertAll (lambda (arg-1 arg-2 arg-3 arg-4) (lambda (clam-0) (if (null? arg-4) (vector 1 arg-3) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((e-6 (car e-2))) (let ((e-7 (cdr e-2))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-2 e-6 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (CoreC-45Context-n--14542-10294-u--insertAll arg-1 arg-2 (LibrariesC-45DataC-45NameMap-insert e-5 e-7 arg-3) e-3))) eff-0) clam-0)))))))))))))
(define CoreC-45Context-u--full_HasNames_C-40NameMapC-32C-36aC-41 (lambda (arg-1 arg-2) (CoreC-45Context-n--14542-10294-u--insertAll arg-2 arg-1 LibrariesC-45DataC-45NameMap-empty (LibrariesC-45DataC-45NameMap-toList arg-2))))
(define CoreC-45Context-n--14554-10334-u--insertAll (lambda (arg-1 arg-2 arg-3 arg-4) (lambda (clam-0) (if (null? arg-4) (vector 1 arg-3) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((e-6 (car e-2))) (let ((e-7 (cdr e-2))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-2 e-6) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (CoreC-45Context-n--14554-10334-u--insertAll arg-1 arg-2 (LibrariesC-45DataC-45NameMap-insert e-5 e-7 arg-3) e-3))) eff-0) clam-0)))))))))))))
(define CoreC-45Context-u--resolved_HasNames_C-40NameMapC-32C-36aC-41 (lambda (arg-1 arg-2) (CoreC-45Context-n--14554-10334-u--insertAll arg-2 arg-1 LibrariesC-45DataC-45NameMap-empty (LibrariesC-45DataC-45NameMap-toList arg-2))))
(define csegen-1293 (lambda () (cons (lambda (arg-7719) (lambda (arg-7722) (CoreC-45Context-u--full_HasNames_C-40NameMapC-32C-36aC-41 arg-7719 arg-7722))) (lambda (arg-7729) (lambda (arg-7732) (CoreC-45Context-u--resolved_HasNames_C-40NameMapC-32C-36aC-41 arg-7729 arg-7732))))))
(define CoreC-45Context-u--resolved_HasNames_GlobalDef (lambda (arg-0 arg-1 ext-0) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 (let ((e-2 (vector-ref arg-1 2))) e-2)) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Context-u--resolved_HasNames_Def arg-0 (let ((e-18 (vector-ref arg-1 18))) e-18) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-3 (CoreC-45Context-u--resolved_HasNames_Totality arg-0 (let ((e-10 (vector-ref arg-1 10))) e-10) eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-4 (CoreC-45Context-u--resolved_HasNames_C-40MaybeC-32C-36aC-41 (csegen-1293) arg-0 (let ((e-13 (vector-ref arg-1 13))) e-13) eta-2))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-3) (let ((act-5 (CoreC-45Context-u--resolved_HasNames_C-40MaybeC-32C-36aC-41 (csegen-1293) arg-0 (let ((e-14 (vector-ref arg-1 14))) e-14) eta-3))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) ((let ((eff-0 (lambda (eta-4) (let ((act-6 ((CoreC-45Core-traverseC-39 (lambda (eta-5) (lambda (eta-6) (CoreC-45Context-u--resolved_HasNames_SCCall arg-0 eta-5 eta-6))) (let ((e-21 (vector-ref arg-1 21))) e-21) '()) eta-4))) (case (vector-ref act-6 0) ((0) (let ((e-2 (vector-ref act-6 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-6 1))) ((let ((eff-0 (lambda (eta-5) (vector 1 (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((e-28 (vector-ref arg-1 5))) (let ((e-27 (vector-ref arg-1 6))) (let ((e-26 (vector-ref arg-1 7))) (let ((e-25 (vector-ref arg-1 8))) (let ((e-24 (vector-ref arg-1 9))) (let ((e-11 (vector-ref arg-1 11))) (let ((e-12 (vector-ref arg-1 12))) (let ((e-15 (vector-ref arg-1 15))) (let ((e-16 (vector-ref arg-1 16))) (let ((e-17 (vector-ref arg-1 17))) (let ((e-19 (vector-ref arg-1 19))) (let ((e-20 (vector-ref arg-1 20))) (let ((e-22 (vector-ref arg-1 22))) (vector e-0 e-1 e-5 e-3 e-4 e-28 e-27 e-26 e-25 e-24 e-7 e-11 e-12 e-8 e-9 e-15 e-16 e-17 e-6 e-19 e-20 e-10 e-22)))))))))))))))))))))) eff-0) eta-4)))))))) eff-0) eta-3)))))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (vector 0 e-1 e-2 e-3 (CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseTreeC-32C-36varsC-41 arg-1 e-4))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (vector 1 e-6 e-7 (CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseTreeC-32C-36varsC-41 arg-1 e-8)))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (vector 2 e-10 (CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseTreeC-32C-36varsC-41 arg-1 e-11))))) (else (let ((e-13 (vector-ref arg-2 1))) (vector 3 (CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseTreeC-32C-36varsC-41 arg-1 e-13)))))))
(define CoreC-45TTC-45Binder-u--map_Functor_PiInfo (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((1) (vector 1 )) ((0) (vector 0 )) ((2) (vector 2 )) (else (let ((e-4 (vector-ref arg-3 1))) (vector 3 (arg-2 e-4)))))))
(define CoreC-45TTC-45Binder-u--map_Functor_Binder (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (let ((e-1 (vector-ref arg-3 1))) (let ((e-2 (vector-ref arg-3 2))) (let ((e-3 (vector-ref arg-3 3))) (let ((e-4 (vector-ref arg-3 4))) (vector 0 e-1 e-2 (CoreC-45TTC-45Binder-u--map_Functor_PiInfo arg-2 e-3) (arg-2 e-4))))))) ((1) (let ((e-6 (vector-ref arg-3 1))) (let ((e-7 (vector-ref arg-3 2))) (let ((e-8 (vector-ref arg-3 3))) (let ((e-9 (vector-ref arg-3 4))) (vector 1 e-6 e-7 (arg-2 e-8) (arg-2 e-9))))))) ((2) (let ((e-11 (vector-ref arg-3 1))) (let ((e-12 (vector-ref arg-3 2))) (let ((e-13 (vector-ref arg-3 3))) (let ((e-14 (vector-ref arg-3 4))) (vector 2 e-11 e-12 (CoreC-45TTC-45Binder-u--map_Functor_PiInfo arg-2 e-13) (arg-2 e-14))))))) ((3) (let ((e-16 (vector-ref arg-3 1))) (let ((e-17 (vector-ref arg-3 2))) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (vector 3 e-16 e-17 (CoreC-45TTC-45Binder-u--map_Functor_PiInfo arg-2 e-18) (arg-2 e-19))))))) ((4) (let ((e-21 (vector-ref arg-3 1))) (let ((e-22 (vector-ref arg-3 2))) (let ((e-23 (vector-ref arg-3 3))) (let ((e-24 (vector-ref arg-3 4))) (vector 4 e-21 e-22 (arg-2 e-23) (arg-2 e-24))))))) (else (let ((e-26 (vector-ref arg-3 1))) (let ((e-27 (vector-ref arg-3 2))) (let ((e-28 (vector-ref arg-3 3))) (vector 5 e-26 e-27 (arg-2 e-28)))))))))
(define DataC-45List-isNil (lambda (arg-1) (if (null? arg-1) 1 0)))
(define CoreC-45TTC-45Term-u--restoreNS_StripNamespace_Name (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((u--nm (vector 0 e-0 e-1))) (let ((sc1 (DataC-45List-isNil e-0))) (cond ((equal? sc1 1) (vector 0 arg-0 e-1)) (else u--nm)))))))(else arg-1))))
(define CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((1) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (vector 1 e-1 e-2 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_Name arg-1 e-3)))))) ((2) (let ((e-5 (vector-ref arg-2 1))) (let ((e-6 (vector-ref arg-2 2))) (let ((e-7 (vector-ref arg-2 3))) (let ((e-8 (vector-ref arg-2 4))) (vector 2 e-5 e-6 e-7 (PreludeC-45TypesC-45List-mapAppend '() (lambda (arg-3) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 arg-3)) e-8))))))) ((3) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (vector 3 e-10 e-11 (CoreC-45TTC-45Binder-u--map_Functor_Binder (lambda (arg-3) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 arg-3)) e-12) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-13))))))) ((4) (let ((e-15 (vector-ref arg-2 1))) (let ((e-16 (vector-ref arg-2 2))) (let ((e-17 (vector-ref arg-2 3))) (vector 4 e-15 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-16) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-17)))))) ((5) (let ((e-19 (vector-ref arg-2 1))) (let ((e-20 (vector-ref arg-2 2))) (let ((e-21 (vector-ref arg-2 3))) (let ((e-22 (vector-ref arg-2 4))) (vector 5 e-19 e-20 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-21) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-22))))))) ((6) (let ((e-24 (vector-ref arg-2 1))) (let ((e-25 (vector-ref arg-2 2))) (let ((e-26 (vector-ref arg-2 3))) (vector 6 e-24 e-25 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-26)))))) ((7) (let ((e-28 (vector-ref arg-2 1))) (let ((e-29 (vector-ref arg-2 2))) (let ((e-30 (vector-ref arg-2 3))) (let ((e-31 (vector-ref arg-2 4))) (vector 7 e-28 e-29 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-30) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-31))))))) ((8) (let ((e-33 (vector-ref arg-2 1))) (let ((e-34 (vector-ref arg-2 2))) (let ((e-35 (vector-ref arg-2 3))) (vector 8 e-33 e-34 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-35))))))(else arg-2))))
(define CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseTreeC-32C-36varsC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 4))) (vector 0 e-1 e-2 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-4) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseAltC-32C-36varsC-41 arg-1 eta-0)) e-5))))))) ((1) (let ((e-7 (vector-ref arg-2 1))) (let ((e-8 (vector-ref arg-2 2))) (vector 1 e-7 (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-1 e-8)))))(else arg-2))))
(define CoreC-45Context-n--14279-10090-u--restoreNSpat (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 arg-6) (let ((e-2 (car arg-6))) (let ((e-3 (cdr arg-6))) (let ((e-6 (car e-3))) (let ((e-7 (cdr e-3))) (let ((e-10 (car e-7))) (let ((e-11 (cdr e-7))) (cons e-2 (cons e-6 (cons (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-5 e-10) (CoreC-45TTC-45Term-u--restoreNS_StripNamespace_C-40TermC-32C-36varsC-41 arg-5 e-11))))))))))))
(define CoreC-45Context-u--restoreNS_StripNamespace_Def (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((e-2 (vector-ref arg-1 3))) (let ((e-3 (vector-ref arg-1 4))) (let ((e-4 (vector-ref arg-1 5))) (vector 1 e-0 e-1 (CoreC-45CaseC-45CaseTree-u--restoreNS_StripNamespace_C-40CaseTreeC-32C-36varsC-41 arg-0 e-2) e-3 (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45Context-n--14279-10090-u--restoreNSpat e-4 e-1 e-3 e-2 e-0 arg-0 eta-0)) e-4))))))))(else arg-1))))
(define CoreC-45Context-u--restoreNS_StripNamespace_GlobalDef (lambda (arg-0 arg-1) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((e-5 (vector-ref arg-1 5))) (let ((e-6 (vector-ref arg-1 6))) (let ((e-7 (vector-ref arg-1 7))) (let ((e-8 (vector-ref arg-1 8))) (let ((e-9 (vector-ref arg-1 9))) (let ((e-10 (vector-ref arg-1 10))) (let ((e-11 (vector-ref arg-1 11))) (let ((e-12 (vector-ref arg-1 12))) (let ((e-13 (vector-ref arg-1 13))) (let ((e-14 (vector-ref arg-1 14))) (let ((e-15 (vector-ref arg-1 15))) (let ((e-16 (vector-ref arg-1 16))) (let ((e-17 (vector-ref arg-1 17))) (let ((e-18 (vector-ref arg-1 18))) (let ((e-19 (vector-ref arg-1 19))) (let ((e-20 (vector-ref arg-1 20))) (let ((e-21 (vector-ref arg-1 21))) (let ((e-22 (vector-ref arg-1 22))) (vector e-0 e-1 e-2 e-3 e-4 e-5 e-6 e-7 e-8 e-9 e-10 e-11 e-12 e-13 e-14 e-15 e-16 e-17 (CoreC-45Context-u--restoreNS_StripNamespace_Def arg-0 e-18) e-19 e-20 e-21 e-22))))))))))))))))))))))))))
(define CoreC-45Context-decode (lambda (ext-4 ext-1 ext-2 ext-3 ext-0) (case (vector-ref ext-3 0) ((0) (let ((e-0 (vector-ref ext-3 1))) (let ((e-1 (vector-ref ext-3 2))) (let ((act-1 ((CoreC-45Core-newRef (vector "Core.Binary.Prims.Bin" ) e-1) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_GlobalDef e-5 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (let ((u--a (CoreC-45Context-getContent ext-4))) (lambda (eta-1) (let ((act-3 (let ((act-3 (unbox u--a))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-4 (CoreC-45Context-u--resolved_HasNames_GlobalDef ext-4 (CoreC-45Context-u--restoreNS_StripNamespace_GlobalDef e-0 e-6) eta-2))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-3) (let ((act-5 (cond ((equal? ext-2 1) (let ((act-5 ((LibrariesC-45DataC-45IOArray-writeArray csegen-82 e-7 ext-1 (vector 1 e-8)) eta-3))) (vector 1 act-5))) (else (vector 1 (vector 0 )))))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (vector 1 e-8))))))) eff-0) eta-2)))))))) eff-0) eta-1))))))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))) (else (let ((e-2 (vector-ref ext-3 1))) (vector 1 e-2))))))
(define LibrariesC-45DataC-45IOArray-readArray (lambda (arg-2 arg-3 arg-4) (let ((sc0 (let ((sc1 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-4 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc1 1) 1) (else (PreludeC-45EqOrd-u--C-62C-61_Ord_Int arg-4 (LibrariesC-45DataC-45IOArray-max arg-3))))))) (cond ((equal? sc0 1) (let ((e-1 (car arg-2))) (let ((e-5 (vector-ref e-1 0))) (let ((e-7 (vector-ref e-5 1))) ((e-7 'erased) '()))))) (else (let ((e-2 (cdr arg-2))) ((e-2 'erased) (lambda (eta-0) (vector-ref (let ((e-3 (cdr arg-3))) e-3) arg-4)))))))))
(define CoreC-45Context-case--returnDef-6301 (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((1) (let ((e-0 (vector-ref arg-2 1))) (let ((sc1 (let ((e-6 (vector-ref e-0 1))) e-6))) (cond ((equal? sc1 1) (box (cons arg-1 arg-0))) (else '())))))(else '()))))
(define CoreC-45Context-returnDef (lambda (arg-0 arg-1 arg-2) (cond ((equal? arg-0 0) (box (cons arg-1 arg-2))) (else (CoreC-45Context-case--returnDef-6301 arg-2 arg-1 (let ((e-18 (vector-ref arg-2 18))) e-18))))))
(define CoreC-45Context-lookupCtxtExactI (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((8) (let ((e-0 (vector-ref arg-0 1))) (lambda (clam-0) (let ((sc1 (LibrariesC-45DataC-45IntMap-lookup e-0 (let ((e-6 (vector-ref arg-1 6))) e-6)))) (if (null? sc1) (let ((act-1 (let ((act-1 (unbox (let ((e-4 (vector-ref arg-1 4))) e-4)))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (let ((act-2 ((LibrariesC-45DataC-45IOArray-readArray csegen-82 e-5 e-0) eta-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (clam-1) (if (null? e-6) (vector 1 '()) (let ((e-1 (unbox e-6))) (let ((act-3 (CoreC-45Context-decode arg-1 e-0 1 e-1 clam-1))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (CoreC-45Context-returnDef (let ((e-9 (vector-ref arg-1 9))) e-9) e-0 e-7))))) eff-0) clam-1)))))))))) eff-0) eta-0)))))))) eff-0) clam-0))))) (let ((e-1 (unbox sc1))) (let ((act-1 (CoreC-45Context-decode arg-1 e-0 1 e-1 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (CoreC-45Context-returnDef (let ((e-9 (vector-ref arg-1 9))) e-9) e-0 e-5))))) eff-0) clam-0)))))))))))(else (let ((sc0 (LibrariesC-45DataC-45NameMap-lookup arg-0 (let ((e-2 (vector-ref arg-1 2))) e-2)))) (if (null? sc0) (lambda (eta-0) (vector 1 '())) (let ((e-1 (unbox sc0))) (CoreC-45Context-lookupCtxtExactI (vector 8 e-1) arg-1))))))))
(define csegen-1274 (lambda (lamc-0) (let ((e-3 (cdr lamc-0))) e-3)))
(define CoreC-45Context-case--lookupCtxtExact-6496 (lambda (arg-0 arg-1 arg-2 ext-0) (if (null? arg-2) (let ((act-1 (let ((act-1 (unbox (let ((e-4 (vector-ref arg-1 4))) e-4)))) (vector 1 act-1)))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (let ((act-2 ((LibrariesC-45DataC-45IOArray-readArray csegen-82 e-5 arg-0) eta-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (clam-1) (if (null? e-6) (vector 1 '()) (let ((e-1 (unbox e-6))) (let ((act-3 (CoreC-45Context-decode arg-1 arg-0 1 e-1 clam-1))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (PreludeC-45Types-u--map_Functor_Maybe csegen-1274 (CoreC-45Context-returnDef (let ((e-9 (vector-ref arg-1 9))) e-9) arg-0 e-7)))))) eff-0) clam-1)))))))))) eff-0) eta-0)))))))) eff-0) ext-0))))) (let ((e-1 (unbox arg-2))) (let ((act-1 (CoreC-45Context-decode arg-1 arg-0 1 e-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (PreludeC-45Types-u--map_Functor_Maybe csegen-1274 (CoreC-45Context-returnDef (let ((e-9 (vector-ref arg-1 9))) e-9) arg-0 e-5)))))) eff-0) ext-0)))))))))
(define CoreC-45Context-lookupCtxtExact (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((8) (let ((e-0 (vector-ref arg-0 1))) (lambda (eta-0) (CoreC-45Context-case--lookupCtxtExact-6496 e-0 arg-1 (LibrariesC-45DataC-45IntMap-lookup e-0 (let ((e-6 (vector-ref arg-1 6))) e-6)) eta-0))))(else (lambda (eta-0) (let ((act-1 ((CoreC-45Context-lookupCtxtExactI arg-0 arg-1) eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (if (null? e-5) (vector 1 '()) (let ((e-1 (unbox e-5))) (let ((e-6 (cdr e-1))) (vector 1 (box e-6)))))))) eff-0) eta-0))))))))))
(define CoreC-45Context-u--full_HasNames_Name (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((8) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Context-lookupCtxtExact (vector 8 e-0) arg-0) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-1) (if (null? e-5) (vector 1 (vector 8 e-0)) (let ((e-1 (unbox e-5))) (vector 1 (let ((e-24 (vector-ref e-1 1))) e-24))))))) eff-0) ext-0)))))))(else (vector 1 arg-1)))))
(define csegen-54 (cons (lambda (arg-7719) (lambda (arg-7722) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-7719 arg-7722 eta-0)))) (lambda (arg-7729) (lambda (arg-7732) (CoreC-45Context-u--resolved_HasNames_Name arg-7729 arg-7732)))))
(define PreludeC-45TypesC-45List-mapMaybeAppend (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) (PreludeC-45TypesC-45SnocList-C-60C-62C-62 arg-2 '()) (let ((e-1 (car arg-4))) (let ((e-2 (cdr arg-4))) (let ((sc1 (arg-3 e-1))) (if (null? sc1) (PreludeC-45TypesC-45List-mapMaybeAppend arg-2 arg-3 e-2) (let ((e-3 (unbox sc1))) (PreludeC-45TypesC-45List-mapMaybeAppend (cons arg-2 e-3) arg-3 e-2)))))))))
(define DataC-45List-catMaybes (lambda (ext-0) (PreludeC-45TypesC-45List-mapMaybeAppend '() (lambda (eta-0) eta-0) ext-0)))
(define csegen-55 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (DataC-45List-catMaybes e-5)))))))
(define csegen-57 (cons (lambda (arg-8474) (lambda (arg-8477) (PreludeC-45TypesC-45List-tailRecAppend arg-8474 arg-8477))) '()))
(define csegen-59 (cons (lambda (arg-8474) (lambda (arg-8477) (string-append arg-8474 arg-8477))) ""))
(define csegen-63 (lambda (eta-0) (lambda (eta-1) (CoreC-45Core-traverse_ eta-0 eta-1))))
(define PreludeC-45InterfacesC-45BoolC-45Semigroup-u--C-60C-43C-62_Semigroup_AnyBool (lambda (arg-0 arg-1) (cond ((equal? arg-0 1) 1) (else arg-1))))
(define csegen-107 (cons (lambda (arg-8474) (lambda (arg-8477) (PreludeC-45InterfacesC-45BoolC-45Semigroup-u--C-60C-43C-62_Semigroup_AnyBool arg-8474 arg-8477))) 0))
(define PreludeC-45Types-elemBy (lambda (arg-2 arg-3 arg-4 ext-0) (let ((e-6 (vector-ref arg-2 5))) (((((e-6 'erased) 'erased) csegen-107) (arg-3 arg-4)) ext-0))))
(define PreludeC-45Types-elem (lambda (arg-2 arg-3 ext-1 ext-0) (PreludeC-45Types-elemBy arg-2 (lambda (eta-0) (lambda (eta-1) (let ((e-1 (car arg-3))) ((e-1 eta-0) eta-1)))) ext-1 ext-0)))
(define CoreC-45Name-isOpChar (lambda (arg-0) (PreludeC-45Types-elem csegen-14 csegen-17 arg-0 (PreludeC-45Types-fastUnpack ":!#$%&*+./<=>?@\\^|-~"))))
(define PreludeC-45TypesC-45String-length (lambda (arg-0) (PreludeC-45Types-prim__integerToNat (string-length arg-0))))
(define PreludeC-45Types-substr (lambda (arg-0 arg-1 arg-2) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Integer arg-0 (PreludeC-45TypesC-45String-length arg-2)))) (cond ((equal? sc0 1) (string-substr (blodwen-toSignedInt arg-0 63) (blodwen-toSignedInt arg-1 63) arg-2)) (else "")))))
(define LibrariesC-45DataC-45StringC-45Extra-drop (lambda (arg-0 arg-1) (PreludeC-45Types-substr arg-0 (PreludeC-45TypesC-45String-length arg-1) arg-1)))
(define LibrariesC-45DataC-45StringC-45Extra-join (lambda (arg-1 arg-2 arg-3) (LibrariesC-45DataC-45StringC-45Extra-drop (PreludeC-45TypesC-45String-length arg-1) (let ((e-2 (vector-ref arg-2 1))) (((((e-2 'erased) 'erased) (lambda (u--acc) (lambda (u--x) (string-append u--acc (string-append arg-1 u--x))))) "") arg-3)))))
(define CoreC-45NameC-45Namespace-showSep (lambda (arg-0 ext-0) (LibrariesC-45DataC-45StringC-45Extra-join arg-0 csegen-14 ext-0)))
(define CoreC-45NameC-45Namespace-showNSWithSep (lambda (arg-0 arg-1) (CoreC-45NameC-45Namespace-showSep arg-0 (PreludeC-45TypesC-45List-reverse arg-1))))
(define CoreC-45NameC-45Namespace-u--show_Show_Namespace (lambda (ext-0) (CoreC-45NameC-45Namespace-showNSWithSep "." ext-0)))
(define CoreC-45Name-u--show_Show_UserName (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) e-0)) ((1) (let ((e-1 (vector-ref arg-0 1))) (string-append "." e-1))) (else "_"))))
(define CoreC-45Name-u--show_Show_Name (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (case (vector-ref e-1 0) ((1) (let ((e-16 (vector-ref e-1 1))) (case (vector-ref e-16 0) ((1) (string-append (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-0) (string-append ".(" (string-append (CoreC-45Name-u--show_Show_Name e-1) ")")))) ((0) (let ((e-18 (vector-ref e-16 1))) (let ((sc3 (PreludeC-45Types-u--foldMap_Foldable_List csegen-107 (lambda (eta-0) (CoreC-45Name-isOpChar eta-0)) (PreludeC-45Types-fastUnpack e-18)))) (cond ((equal? sc3 1) (PreludeC-45Types-u--foldMap_Foldable_List csegen-59 (lambda (eta-0) eta-0) (cons (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-0) (cons ".(" (cons e-18 (cons ")" '())))))) (else (PreludeC-45Types-u--foldMap_Foldable_List csegen-59 (lambda (eta-0) eta-0) (cons (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-0) (cons "." (cons e-18 '())))))))))(else (PreludeC-45Types-u--foldMap_Foldable_List csegen-59 (lambda (eta-0) eta-0) (cons (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-0) (cons "." (cons (CoreC-45Name-u--show_Show_Name e-1) '()))))))))(else (PreludeC-45Types-u--foldMap_Foldable_List csegen-59 (lambda (eta-0) eta-0) (cons (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-0) (cons "." (cons (CoreC-45Name-u--show_Show_Name e-1) '()))))))))) ((1) (let ((e-2 (vector-ref arg-0 1))) (CoreC-45Name-u--show_Show_UserName e-2))) ((2) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (string-append "{" (string-append e-3 (string-append ":" (string-append (PreludeC-45Show-u--show_Show_Int e-4) "}"))))))) ((3) (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (string-append "{P:" (string-append (CoreC-45Name-u--show_Show_Name e-5) (string-append ":" (string-append (PreludeC-45Show-u--show_Show_Int e-6) "}"))))))) ((4) (let ((e-7 (vector-ref arg-0 1))) e-7)) ((5) (let ((e-9 (vector-ref arg-0 1))) (let ((e-10 (vector-ref arg-0 2))) (let ((e-21 (car e-9))) (let ((e-22 (cdr e-9))) (string-append (PreludeC-45Show-u--show_Show_Int e-21) (string-append ":" (string-append (PreludeC-45Show-u--show_Show_Int e-22) (string-append ":" (CoreC-45Name-u--show_Show_Name e-10)))))))))) ((6) (let ((e-11 (vector-ref arg-0 1))) (string-append "case block in " e-11))) ((7) (let ((e-13 (vector-ref arg-0 1))) (string-append "with block in " e-13))) (else (let ((e-15 (vector-ref arg-0 1))) (string-append "$resolved" (PreludeC-45Show-u--show_Show_Int e-15)))))))
(define CoreC-45Name-u--showPrec_Show_Name (lambda (arg-0 arg-1) (CoreC-45Name-u--show_Show_Name arg-1)))
(define csegen-65 (cons (lambda (u--x) (CoreC-45Name-u--show_Show_Name u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45Name-u--showPrec_Show_Name u--d u--x)))))
(define CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 (lambda (arg-1 arg-2) (lambda (clam-0) (case (vector-ref arg-2 0) ((1) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (case (vector-ref e-3 0) ((8) (let ((e-39 (vector-ref e-3 1))) (let ((act-1 ((CoreC-45Context-lookupCtxtExact (vector 8 e-39) arg-1) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-1) (if (null? e-5) (vector 1 (vector 1 e-1 e-2 (vector 8 e-39))) (let ((e-4 (unbox e-5))) (vector 1 (vector 1 e-1 e-2 (let ((e-27 (vector-ref e-4 1))) e-27)))))))) eff-0) clam-0)))))))(else (vector 1 arg-2))))))) ((2) (let ((e-5 (vector-ref arg-2 1))) (let ((e-6 (vector-ref arg-2 2))) (let ((e-7 (vector-ref arg-2 3))) (let ((e-8 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (arg-3) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 arg-3)) e-8 '()) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-lookupCtxtExact (vector 8 e-7) arg-1) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-10 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (if (null? e-10) (vector 2 e-5 e-6 e-7 e-9) (let ((e-2 (unbox e-10))) (vector 2 e-5 (let ((e-1 (vector-ref e-2 1))) e-1) e-7 e-9))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))))))) ((3) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45CoreC-45Binder-traverse (lambda (arg-3) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 arg-3)) e-12) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-13) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 3 e-10 e-11 e-5 e-6))))) eff-0) eta-0)))))))) eff-0) clam-0)))))))))) ((4) (let ((e-15 (vector-ref arg-2 1))) (let ((e-16 (vector-ref arg-2 2))) (let ((e-17 (vector-ref arg-2 3))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-16) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-17) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 4 e-15 e-5 e-6))))) eff-0) eta-0)))))))) eff-0) clam-0))))))))) ((5) (let ((e-19 (vector-ref arg-2 1))) (let ((e-20 (vector-ref arg-2 2))) (let ((e-21 (vector-ref arg-2 3))) (let ((e-22 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-21) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-22) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 5 e-19 e-20 e-5 e-6))))) eff-0) eta-0)))))))) eff-0) clam-0)))))))))) ((6) (let ((e-24 (vector-ref arg-2 1))) (let ((e-25 (vector-ref arg-2 2))) (let ((e-26 (vector-ref arg-2 3))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-26) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 6 e-24 e-25 e-5))))) eff-0) clam-0))))))))) ((7) (let ((e-28 (vector-ref arg-2 1))) (let ((e-29 (vector-ref arg-2 2))) (let ((e-30 (vector-ref arg-2 3))) (let ((e-31 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-30) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-31) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 7 e-28 e-29 e-5 e-6))))) eff-0) eta-0)))))))) eff-0) clam-0)))))))))) ((8) (let ((e-33 (vector-ref arg-2 1))) (let ((e-34 (vector-ref arg-2 2))) (let ((e-35 (vector-ref arg-2 3))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-35) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 8 e-33 e-34 e-5))))) eff-0) clam-0))))))))) ((11) (let ((e-37 (vector-ref arg-2 1))) (let ((e-38 (vector-ref arg-2 2))) (case (vector-ref e-38 0) ((8) (let ((e-40 (vector-ref e-38 1))) (let ((act-1 ((CoreC-45Context-lookupCtxtExact (vector 8 e-40) arg-1) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-3) (if (null? e-5) (vector 1 (vector 11 e-37 (vector 8 e-40))) (let ((e-1 (unbox e-5))) (vector 1 (vector 11 e-37 (let ((e-24 (vector-ref e-1 1))) e-24)))))))) eff-0) clam-0)))))))(else (vector 1 arg-2))))))(else (vector 1 arg-2))))))
(define csegen-68 (cons (lambda (arg-7719) (lambda (arg-7722) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-7719 arg-7722))) (lambda (arg-7729) (lambda (arg-7732) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-7729 arg-7732)))))
(define csegen-84 (cons csegen-65 csegen-65))
(define SystemC-45Info-os (blodwen-os))
(define csegen-96 (PreludeC-45Types-elem csegen-14 csegen-22 SystemC-45Info-os (cons "windows" (cons "mingw32" (cons "cygwin32" '())))))
(define csegen-103 (lambda (eta-0) (lambda (eta-1) (cons eta-0 eta-1))))
(define csegen-108 (lambda (arg-5904) (lambda (arg-5907) (+ arg-5904 arg-5907))))
(define csegen-109 (lambda (arg-5914) (lambda (arg-5917) (* arg-5914 arg-5917))))
(define csegen-110 (vector csegen-108 csegen-109 (lambda (arg-5924) (PreludeC-45Types-prim__integerToNat arg-5924))))
(define PreludeC-45Types-u--C-62C-62C-61_Monad_C-40EitherC-32C-36eC-41 (lambda (arg-3 arg-4) (case (vector-ref arg-3 0) ((0) (let ((e-2 (vector-ref arg-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref arg-3 1))) (arg-4 e-5))))))
(define csegen-150 (lambda (u--b) (lambda (u--a) (lambda (arg-10411) (lambda (arg-10414) (PreludeC-45Types-u--C-62C-62C-61_Monad_C-40EitherC-32C-36eC-41 arg-10411 arg-10414))))))
(define PreludeC-45Types-u--join_Monad_C-40EitherC-32C-36eC-41 (lambda (arg-2) (PreludeC-45Types-u--C-62C-62C-61_Monad_C-40EitherC-32C-36eC-41 arg-2 (lambda (eta-0) eta-0))))
(define csegen-151 (lambda (u--a) (lambda (arg-10425) (PreludeC-45Types-u--join_Monad_C-40EitherC-32C-36eC-41 arg-10425))))
(define PreludeC-45Types-u--foldr_Foldable_C-40EitherC-32C-36eC-41 (lambda (arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) arg-4) (else (let ((e-5 (vector-ref arg-5 1))) ((arg-3 e-5) arg-4))))))
(define PreludeC-45Types-u--foldMap_Foldable_C-40EitherC-32C-36eC-41 (lambda (arg-3 arg-4 ext-0) (PreludeC-45Types-u--foldr_Foldable_C-40EitherC-32C-36eC-41 (lambda (eta-0) (lambda (eta-1) (let ((e-1 (car arg-3))) ((e-1 (arg-4 eta-0)) eta-1)))) (let ((e-2 (cdr arg-3))) e-2) ext-0)))
(define PreludeC-45Types-u--foldl_Foldable_C-40EitherC-32C-36eC-41 (lambda (arg-3 arg-4 arg-5) ((PreludeC-45Types-u--foldr_Foldable_C-40EitherC-32C-36eC-41 (lambda (eta-0) (lambda (eta-1) (PreludeC-45Basics-flip (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (eta-2 (eta-3 eta-4))))) (lambda (eta-2) (PreludeC-45Basics-flip arg-3 eta-0 eta-2)) eta-1))) (lambda (eta-0) eta-0) arg-5) arg-4)))
(define PreludeC-45Types-u--foldlM_Foldable_C-40EitherC-32C-36eC-41 (lambda (arg-4 arg-5 arg-6 ext-0) (PreludeC-45Types-u--foldl_Foldable_C-40EitherC-32C-36eC-41 (lambda (u--ma) (lambda (u--b) (let ((e-2 (vector-ref arg-4 1))) ((((e-2 'erased) 'erased) u--ma) (lambda (eta-0) (PreludeC-45Basics-flip arg-5 u--b eta-0)))))) (let ((e-1 (vector-ref arg-4 0))) (let ((e-5 (vector-ref e-1 1))) ((e-5 'erased) arg-6))) ext-0)))
(define PreludeC-45Types-u--null_Foldable_C-40EitherC-32C-36eC-41 (lambda (arg-2) (case (vector-ref arg-2 0) ((0) 1) (else 0))))
(define PreludeC-45Types-u--toList_Foldable_C-40EitherC-32C-36eC-41 (lambda (ext-0) (PreludeC-45Types-u--foldr_Foldable_C-40EitherC-32C-36eC-41 csegen-103 '() ext-0)))
(define csegen-167 (vector (lambda (u--acc) (lambda (u--elem) (lambda (u--func) (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldr_Foldable_C-40EitherC-32C-36eC-41 u--func u--init u--input)))))) (lambda (u--elem) (lambda (u--acc) (lambda (u--func) (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldl_Foldable_C-40EitherC-32C-36eC-41 u--func u--init u--input)))))) (lambda (u--elem) (lambda (arg-10911) (PreludeC-45Types-u--null_Foldable_C-40EitherC-32C-36eC-41 arg-10911))) (lambda (u--elem) (lambda (u--acc) (lambda (u--m) (lambda (i_con-0) (lambda (u--funcM) (lambda (u--init) (lambda (u--input) (PreludeC-45Types-u--foldlM_Foldable_C-40EitherC-32C-36eC-41 i_con-0 u--funcM u--init u--input)))))))) (lambda (u--elem) (lambda (arg-10940) (PreludeC-45Types-u--toList_Foldable_C-40EitherC-32C-36eC-41 arg-10940))) (lambda (u--a) (lambda (u--m) (lambda (i_con-0) (lambda (u--f) (lambda (arg-10954) (PreludeC-45Types-u--foldMap_Foldable_C-40EitherC-32C-36eC-41 i_con-0 u--f arg-10954))))))))
(define PreludeC-45Types-u--traverse_Traversable_C-40EitherC-32C-36eC-41 (lambda (arg-4 arg-5 arg-6) (case (vector-ref arg-6 0) ((0) (let ((e-2 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-4 1))) ((e-4 'erased) (vector 0 e-2))))) (else (let ((e-5 (vector-ref arg-6 1))) (let ((e-1 (vector-ref arg-4 0))) ((((e-1 'erased) 'erased) (lambda (eta-0) (vector 1 eta-0))) (arg-5 e-5))))))))
(define csegen-171 (lambda (u--b) (lambda (u--a) (lambda (u--f) (lambda (i_con-0) (lambda (arg-14093) (lambda (arg-14100) (PreludeC-45Types-u--traverse_Traversable_C-40EitherC-32C-36eC-41 i_con-0 arg-14093 arg-14100))))))))
(define csegen-181 (lambda (eta-0) (lambda (eta-1) (cons eta-0 eta-1))))
(define csegen-182 (lambda (__leftTupleSection-0) (lambda (__infixTupleSection-0) (cons __leftTupleSection-0 __infixTupleSection-0))))
(define PreludeC-45InterfacesC-45BoolC-45Semigroup-u--C-60C-43C-62_Semigroup_AllBool (lambda (arg-0 arg-1) (cond ((equal? arg-0 1) arg-1) (else 0))))
(define csegen-186 (cons (lambda (arg-8474) (lambda (arg-8477) (PreludeC-45InterfacesC-45BoolC-45Semigroup-u--C-60C-43C-62_Semigroup_AllBool arg-8474 arg-8477))) 1))
(define csegen-189 (vector (lambda (arg-5904) (lambda (arg-5907) (bs+ arg-5904 arg-5907 63))) (lambda (arg-5914) (lambda (arg-5917) (bs* arg-5914 arg-5917 63))) (lambda (arg-5924) (blodwen-toSignedInt arg-5924 63))))
(define PreludeC-45Num-u--div_Integral_Int (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-1 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc0 0) (bs/ arg-0 arg-1 63))(else (blodwen-error-quit (string-append "ERROR: " "Unhandled input for Prelude.Num.case block in div at Prelude.Num:128:3--130:40")))))))
(define PreludeC-45Num-u--mod_Integral_Int (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int arg-1 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc0 0) (blodwen-euclidMod arg-0 arg-1))(else (blodwen-error-quit (string-append "ERROR: " "Unhandled input for Prelude.Num.case block in mod at Prelude.Num:131:3--133:40")))))))
(define csegen-235 (cons (vector csegen-189 (lambda (arg-6312) (lambda (arg-6315) (PreludeC-45Num-u--div_Integral_Int arg-6312 arg-6315))) (lambda (arg-6322) (lambda (arg-6325) (PreludeC-45Num-u--mod_Integral_Int arg-6322 arg-6325)))) (cons csegen-231 (vector csegen-189 (lambda (arg-6023) (bs- 0 arg-6023 63)) (lambda (arg-6029) (lambda (arg-6032) (bs- arg-6029 arg-6032 63)))))))
(define csegen-237 (vector (vector 2 ) 1 3 10))
(define PreludeC-45Types-u--C-60C-42C-62_Applicative_Maybe (lambda (arg-2 arg-3) (if (null? arg-2) '() (let ((e-1 (unbox arg-2))) (if (null? arg-3) '() (let ((e-3 (unbox arg-3))) (box (e-1 e-3))))))))
(define csegen-255 (vector (lambda (u--b) (lambda (u--a) (lambda (u--func) (lambda (arg-8885) (PreludeC-45Types-u--map_Functor_Maybe u--func arg-8885))))) (lambda (u--a) (lambda (arg-9931) (box arg-9931))) (lambda (u--b) (lambda (u--a) (lambda (arg-9937) (lambda (arg-9944) (PreludeC-45Types-u--C-60C-42C-62_Applicative_Maybe arg-9937 arg-9944)))))))
(define PreludeC-45Types-u--C-60C-124C-62_Alternative_Maybe (lambda (arg-1 arg-2) (if (null? arg-1) (arg-2) (let ((e-1 (unbox arg-1))) (box e-1)))))
(define csegen-258 (vector csegen-255 (lambda (u--a) '()) (lambda (u--a) (lambda (arg-10313) (lambda (arg-10316) (PreludeC-45Types-u--C-60C-124C-62_Alternative_Maybe arg-10313 arg-10316))))))
(define csegen-259 (lambda (eta-0) (let ((e-2 (vector-ref eta-0 2))) e-2)))
(define IdrisC-45Syntax-u--full_HasNames_IFaceInfo (lambda (arg-0 arg-1 ext-0) (vector 1 arg-1)))
(define IdrisC-45Syntax-u--resolved_HasNames_IFaceInfo (lambda (arg-0 arg-1 ext-0) (vector 1 arg-1)))
(define csegen-262 (cons (lambda (arg-7719) (lambda (arg-7722) (lambda (eta-0) (IdrisC-45Syntax-u--full_HasNames_IFaceInfo arg-7719 arg-7722 eta-0)))) (lambda (arg-7729) (lambda (arg-7732) (lambda (eta-0) (IdrisC-45Syntax-u--resolved_HasNames_IFaceInfo arg-7729 arg-7732 eta-0))))))
(define CoreC-45FC-showPos (lambda (arg-0) (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (string-append (PreludeC-45Show-u--show_Show_Int (bs+ e-2 1 63)) (string-append ":" (PreludeC-45Show-u--show_Show_Int (bs+ e-3 1 63))))))))
(define CoreC-45NameC-45Namespace-u--show_Show_ModuleIdent (lambda (ext-0) (CoreC-45NameC-45Namespace-showNSWithSep "." ext-0)))
(define PreludeC-45Types-getAt (lambda (arg-1 arg-2) (cond ((equal? arg-1 0) (if (null? arg-2) '() (let ((e-3 (car arg-2))) (box e-3))))(else (let ((e-1 (- arg-1 1))) (if (null? arg-2) '() (let ((e-7 (cdr arg-2))) (PreludeC-45Types-getAt e-1 e-7))))))))
(define PreludeC-45EqOrd-u--C-60C-61_Ord_Char (lambda (arg-0 arg-1) (let ((sc0 (or (and (char<=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-62C-61_Ord_Char (lambda (arg-0 arg-1) (let ((sc0 (or (and (char>=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45Types-isDigit (lambda (arg-0) (let ((sc0 (PreludeC-45EqOrd-u--C-62C-61_Ord_Char arg-0 #\0))) (cond ((equal? sc0 1) (PreludeC-45EqOrd-u--C-60C-61_Ord_Char arg-0 #\9)) (else 0)))))
(define PreludeC-45Show-protectEsc (lambda (arg-0 arg-1 arg-2) (string-append arg-1 (string-append (let ((sc0 (PreludeC-45Show-firstCharIs arg-0 arg-2))) (cond ((equal? sc0 1) "\\&") (else ""))) arg-2))))
(define PreludeC-45EqOrd-u--C-62_Ord_Char (lambda (arg-0 arg-1) (let ((sc0 (or (and (char>? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45Show-n--2439-11931-u--asciiTab (lambda (arg-0) (cons "NUL" (cons "SOH" (cons "STX" (cons "ETX" (cons "EOT" (cons "ENQ" (cons "ACK" (cons "BEL" (cons "BS" (cons "HT" (cons "LF" (cons "VT" (cons "FF" (cons "CR" (cons "SO" (cons "SI" (cons "DLE" (cons "DC1" (cons "DC2" (cons "DC3" (cons "DC4" (cons "NAK" (cons "SYN" (cons "ETB" (cons "CAN" (cons "EM" (cons "SUB" (cons "ESC" (cons "FS" (cons "GS" (cons "RS" (cons "US" '()))))))))))))))))))))))))))))))))))
(define PreludeC-45Show-showLitChar (lambda (arg-0) (cond ((equal? arg-0 (integer->char 7)) (lambda (arg-1) (string-append "\\a" arg-1))) ((equal? arg-0 (integer->char 8)) (lambda (arg-1) (string-append "\\b" arg-1))) ((equal? arg-0 (integer->char 12)) (lambda (arg-1) (string-append "\\f" arg-1))) ((equal? arg-0 (integer->char 10)) (lambda (arg-1) (string-append "\\n" arg-1))) ((equal? arg-0 (integer->char 13)) (lambda (arg-1) (string-append "\\r" arg-1))) ((equal? arg-0 (integer->char 9)) (lambda (arg-1) (string-append "\\t" arg-1))) ((equal? arg-0 (integer->char 11)) (lambda (arg-1) (string-append "\\v" arg-1))) ((equal? arg-0 (integer->char 14)) (lambda (eta-0) (PreludeC-45Show-protectEsc (lambda (arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-1 #\H)) "\\SO" eta-0))) ((equal? arg-0 (integer->char 127)) (lambda (arg-1) (string-append "\\DEL" arg-1))) ((equal? arg-0 #\\) (lambda (arg-1) (string-append "\\\\" arg-1)))(else (lambda (clam-0) (let ((sc0 (PreludeC-45Types-getAt (PreludeC-45Types-prim__integerToNat (char->integer arg-0)) (PreludeC-45Show-n--2439-11931-u--asciiTab arg-0)))) (if (null? sc0) (let ((sc1 (PreludeC-45EqOrd-u--C-62_Ord_Char arg-0 (integer->char 127)))) (cond ((equal? sc1 1) (string-cons #\\ (PreludeC-45Show-protectEsc (lambda (eta-0) (PreludeC-45Types-isDigit eta-0)) (PreludeC-45Show-u--show_Show_Int (cast-char-boundedInt arg-0 63)) clam-0))) (else (string-cons arg-0 clam-0)))) (let ((e-1 (unbox sc0))) (string-cons #\\ (string-append e-1 clam-0))))))))))
(define PreludeC-45Show-showLitString (lambda (arg-0) (lambda (clam-0) (if (null? arg-0) clam-0 (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (cond ((equal? e-2 #\") (string-append "\\\"" ((PreludeC-45Show-showLitString e-3) clam-0)))(else ((PreludeC-45Show-showLitChar e-2) ((PreludeC-45Show-showLitString e-3) clam-0))))))))))
(define PreludeC-45Show-u--show_Show_String (lambda (arg-0) (string-cons #\" ((PreludeC-45Show-showLitString (PreludeC-45Types-fastUnpack arg-0)) "\""))))
(define CoreC-45FC-u--show_Show_VirtualIdent (lambda (arg-0) "(Interactive)"))
(define CoreC-45FC-u--show_Show_OriginDesc (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (CoreC-45NameC-45Namespace-u--show_Show_ModuleIdent e-0))) ((1) (let ((e-1 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_String e-1))) (else (let ((e-2 (vector-ref arg-0 1))) (CoreC-45FC-u--show_Show_VirtualIdent e-2))))))
(define CoreC-45FC-u--show_Show_FC (lambda (arg-0) (case (vector-ref arg-0 0) ((2) "EmptyFC") ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_OriginDesc e-0) (string-append ":" (string-append (CoreC-45FC-showPos e-1) (string-append "--" (CoreC-45FC-showPos e-2))))))))) (else (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (let ((e-5 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_OriginDesc e-3) (string-append ":" (string-append (CoreC-45FC-showPos e-4) (string-append "--" (CoreC-45FC-showPos e-5))))))))))))
(define CoreC-45FC-u--showPrec_Show_FC (lambda (arg-0 arg-1) (CoreC-45FC-u--show_Show_FC arg-1)))
(define csegen-264 (cons (lambda (u--x) (CoreC-45FC-u--show_Show_FC u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45FC-u--showPrec_Show_FC u--d u--x)))))
(define csegen-265 (cons csegen-264 csegen-65))
(define csegen-266 (lambda (u--n) (string-append "." (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-265 u--n))))
(define PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-4)))
(define csegen-269 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-265 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-265 u--d u--x)))))
(define IdrisC-45Syntax-u--C-61C-61_Eq_Fixity (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0))) ((equal? arg-0 3) (cond ((equal? arg-1 3) 1)(else 0)))(else 0))))
(define csegen-273 (lambda (eta-0) (IdrisC-45Syntax-u--C-61C-61_Eq_Fixity (let ((sc0 (Builtin-snd eta-0))) (let ((e-2 (vector-ref sc0 2))) e-2)) 3)))
(define CoreC-45NameC-45Namespace-u--C-61C-61_Eq_ModuleIdent (lambda (arg-0 arg-1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-22 arg-0 arg-1)))
(define CoreC-45NameC-45Namespace-u--C-47C-61_Eq_ModuleIdent (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_ModuleIdent arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-276 (cons (lambda (arg-676) (lambda (arg-679) (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_ModuleIdent arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (CoreC-45NameC-45Namespace-u--C-47C-61_Eq_ModuleIdent arg-686 arg-689)))))
(define CoreC-45NameC-45Namespace-u--compare_Ord_ModuleIdent (lambda (arg-0 arg-1) (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 csegen-519 arg-0 arg-1)))
(define CoreC-45NameC-45Namespace-u--C-60C-61_Ord_ModuleIdent (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45NameC-45Namespace-u--compare_Ord_ModuleIdent arg-0 arg-1) 2)))
(define CoreC-45NameC-45Namespace-u--C-60_Ord_ModuleIdent (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45NameC-45Namespace-u--compare_Ord_ModuleIdent arg-0 arg-1) 0)))
(define CoreC-45NameC-45Namespace-u--C-62C-61_Ord_ModuleIdent (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45NameC-45Namespace-u--compare_Ord_ModuleIdent arg-0 arg-1) 0)))
(define CoreC-45NameC-45Namespace-u--C-62_Ord_ModuleIdent (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45NameC-45Namespace-u--compare_Ord_ModuleIdent arg-0 arg-1) 2)))
(define CoreC-45NameC-45Namespace-u--max_Ord_ModuleIdent (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45NameC-45Namespace-u--C-62_Ord_ModuleIdent arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define CoreC-45NameC-45Namespace-u--min_Ord_ModuleIdent (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45NameC-45Namespace-u--C-60_Ord_ModuleIdent arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-284 (vector csegen-276 (lambda (arg-1566) (lambda (arg-1569) (CoreC-45NameC-45Namespace-u--compare_Ord_ModuleIdent arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (CoreC-45NameC-45Namespace-u--C-60_Ord_ModuleIdent arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (CoreC-45NameC-45Namespace-u--C-62_Ord_ModuleIdent arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (CoreC-45NameC-45Namespace-u--C-60C-61_Ord_ModuleIdent arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (CoreC-45NameC-45Namespace-u--C-62C-61_Ord_ModuleIdent arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (CoreC-45NameC-45Namespace-u--max_Ord_ModuleIdent arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (CoreC-45NameC-45Namespace-u--min_Ord_ModuleIdent arg-1626 arg-1629)))))
(define LibrariesC-45DataC-45SortedMap-empty (lambda (arg-2) (vector 0 arg-2)))
(define csegen-285 (LibrariesC-45DataC-45SortedMap-empty csegen-284))
(define LibrariesC-45TextC-45LexerC-45Core-pred (lambda (ext-0) (vector 4 ext-0)))
(define LibrariesC-45TextC-45Lexer-is (lambda (arg-0) (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-1 arg-0)))))
(define LibrariesC-45TextC-45LexerC-45Core-C-60C-124C-62 (lambda (ext-0 ext-1) (vector 8 ext-0 ext-1)))
(define LibrariesC-45TextC-45LexerC-45Core-empty (vector 0 ))
(define LibrariesC-45TextC-45Lexer-opt (lambda (arg-0) (LibrariesC-45TextC-45LexerC-45Core-C-60C-124C-62 arg-0 LibrariesC-45TextC-45LexerC-45Core-empty)))
(define LibrariesC-45TextC-45Lexer-some (lambda (arg-0) (vector 5 arg-0 (lambda () (LibrariesC-45TextC-45Lexer-many arg-0)))))
(define LibrariesC-45TextC-45Lexer-many (lambda (arg-0) (LibrariesC-45TextC-45Lexer-opt (LibrariesC-45TextC-45Lexer-some arg-0))))
(define csegen-303 (LibrariesC-45TextC-45Lexer-many (LibrariesC-45TextC-45Lexer-is #\#)))
(define csegen-305 (LibrariesC-45TextC-45Lexer-many (LibrariesC-45TextC-45Lexer-is #\-)))
(define PreludeC-45Types-isLower (lambda (arg-0) (let ((sc0 (PreludeC-45EqOrd-u--C-62C-61_Ord_Char arg-0 #\a))) (cond ((equal? sc0 1) (PreludeC-45EqOrd-u--C-60C-61_Ord_Char arg-0 #\z)) (else 0)))))
(define PreludeC-45Types-isUpper (lambda (arg-0) (let ((sc0 (PreludeC-45EqOrd-u--C-62C-61_Ord_Char arg-0 #\A))) (cond ((equal? sc0 1) (PreludeC-45EqOrd-u--C-60C-61_Ord_Char arg-0 #\Z)) (else 0)))))
(define PreludeC-45Types-isAlpha (lambda (arg-0) (let ((sc0 (PreludeC-45Types-isUpper arg-0))) (cond ((equal? sc0 1) 1) (else (PreludeC-45Types-isLower arg-0))))))
(define ParserC-45LexerC-45Common-isIdentStart (lambda (arg-0 arg-1) (cond ((equal? arg-1 #\_) 1)(else (cond ((equal? arg-0 1) (let ((sc1 (PreludeC-45Types-isUpper arg-1))) (cond ((equal? sc1 1) 1) (else (PreludeC-45EqOrd-u--C-62_Ord_Char arg-1 (cast-int-char (blodwen-toSignedInt 160 63)))))))(else (let ((sc0 (PreludeC-45Types-isAlpha arg-1))) (cond ((equal? sc0 1) 1) (else (PreludeC-45EqOrd-u--C-62_Ord_Char arg-1 (cast-int-char (blodwen-toSignedInt 160 63))))))))))))
(define PreludeC-45Types-isAlphaNum (lambda (arg-0) (let ((sc0 (PreludeC-45Types-isDigit arg-0))) (cond ((equal? sc0 1) 1) (else (PreludeC-45Types-isAlpha arg-0))))))
(define ParserC-45LexerC-45Common-isIdentTrailing (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 #\-) 1)(else (cond ((equal? arg-1 #\') 1) ((equal? arg-1 #\_) 1)(else (let ((sc1 (PreludeC-45Types-isAlphaNum arg-1))) (cond ((equal? sc1 1) 1) (else (PreludeC-45EqOrd-u--C-62_Ord_Char arg-1 (cast-int-char (blodwen-toSignedInt 160 63)))))))))))(else (cond ((equal? arg-1 #\') 1) ((equal? arg-1 #\_) 1)(else (let ((sc0 (PreludeC-45Types-isAlphaNum arg-1))) (cond ((equal? sc0 1) 1) (else (PreludeC-45EqOrd-u--C-62_Ord_Char arg-1 (cast-int-char (blodwen-toSignedInt 160 63))))))))))))
(define csegen-771 (lambda (eta-0) (ParserC-45LexerC-45Common-isIdentTrailing 2 eta-0)))
(define ParserC-45LexerC-45Common-identNormal (vector 5 (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (eta-0) (ParserC-45LexerC-45Common-isIdentStart 2 eta-0))) (lambda () (LibrariesC-45TextC-45Lexer-many (LibrariesC-45TextC-45LexerC-45Core-pred csegen-771)))))
(define csegen-436 (vector 5 (LibrariesC-45TextC-45Lexer-is #\?) (lambda () ParserC-45LexerC-45Common-identNormal)))
(define LibrariesC-45TextC-45Lexer-isNot (lambda (arg-0) (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Char arg-1 arg-0)))))
(define csegen-459 (LibrariesC-45TextC-45Lexer-many (LibrariesC-45TextC-45Lexer-isNot (integer->char 10))))
(define csegen-460 (vector 5 (LibrariesC-45TextC-45Lexer-is #\.) (lambda () ParserC-45LexerC-45Common-identNormal)))
(define csegen-469 (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (eta-0) (PreludeC-45Types-isAlphaNum eta-0))))
(define CoreC-45NameC-45Namespace-u--showPrec_Show_Namespace (lambda (arg-0 arg-1) (CoreC-45NameC-45Namespace-u--show_Show_Namespace arg-1)))
(define csegen-487 (cons (lambda (u--x) (CoreC-45NameC-45Namespace-u--show_Show_Namespace u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45NameC-45Namespace-u--showPrec_Show_Namespace u--d u--x)))))
(define PreludeC-45Show-showArg (lambda (arg-1 arg-2) (string-append " " (let ((e-2 (cdr arg-1))) ((e-2 (vector 6 )) arg-2)))))
(define PreludeC-45Show-showCon (lambda (arg-0 arg-1 arg-2) (PreludeC-45Show-showParens (PreludeC-45Show-u--C-62C-61_Ord_Prec arg-0 (vector 6 )) (string-append arg-1 arg-2))))
(define CoreC-45Name-u--showPrec_Show_RawUNUserName (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (PreludeC-45Show-showCon arg-0 "Basic " e-0))) ((1) (let ((e-1 (vector-ref arg-1 1))) (PreludeC-45Show-showCon arg-0 "Field " e-1))) (else "Underscore"))))
(define CoreC-45Name-u--show_Show_RawUNUserName (lambda (arg-0) (CoreC-45Name-u--showPrec_Show_RawUNUserName (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_String (lambda (arg-0 arg-1) (PreludeC-45Show-u--show_Show_String arg-1)))
(define csegen-493 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_String u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_String u--d u--x)))))
(define csegen-495 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_Int u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_Int u--d u--x)))))
(define csegen-496 (cons csegen-495 csegen-495))
(define csegen-499 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-496 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-496 u--d u--x)))))
(define CoreC-45Name-u--showPrec_Show_RawName (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "NS" (string-append (PreludeC-45Show-showArg csegen-487 e-0) (PreludeC-45Show-showArg (csegen-489) e-1)))))) ((1) (let ((e-2 (vector-ref arg-1 1))) (PreludeC-45Show-showCon arg-0 "UN" (PreludeC-45Show-showArg (cons (lambda (u--x) (CoreC-45Name-u--show_Show_RawUNUserName u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45Name-u--showPrec_Show_RawUNUserName u--d u--x)))) e-2)))) ((2) (let ((e-3 (vector-ref arg-1 1))) (let ((e-4 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "MN" (string-append (PreludeC-45Show-showArg csegen-493 e-3) (PreludeC-45Show-showArg csegen-495 e-4)))))) ((3) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "PV" (string-append (PreludeC-45Show-showArg (csegen-489) e-5) (PreludeC-45Show-showArg csegen-495 e-6)))))) ((4) (let ((e-7 (vector-ref arg-1 1))) (let ((e-8 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "DN" (string-append (PreludeC-45Show-showArg csegen-493 e-7) (PreludeC-45Show-showArg (csegen-489) e-8)))))) ((5) (let ((e-9 (vector-ref arg-1 1))) (let ((e-10 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "Nested" (string-append (PreludeC-45Show-showArg csegen-499 e-9) (PreludeC-45Show-showArg (csegen-489) e-10)))))) ((6) (let ((e-11 (vector-ref arg-1 1))) (let ((e-12 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "CaseBlock" (string-append (PreludeC-45Show-showArg csegen-493 e-11) (PreludeC-45Show-showArg csegen-495 e-12)))))) ((7) (let ((e-13 (vector-ref arg-1 1))) (let ((e-14 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "WithBlock" (string-append (PreludeC-45Show-showArg csegen-493 e-13) (PreludeC-45Show-showArg csegen-495 e-14)))))) (else (let ((e-15 (vector-ref arg-1 1))) (PreludeC-45Show-showCon arg-0 "Resolved" (PreludeC-45Show-showArg csegen-495 e-15)))))))
(define CoreC-45Name-u--show_Show_RawName (lambda (arg-0) (CoreC-45Name-u--showPrec_Show_RawName (vector 0 ) arg-0)))
(define csegen-489 (lambda () (cons (lambda (u--x) (CoreC-45Name-u--show_Show_RawName u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45Name-u--showPrec_Show_RawName u--d u--x))))))
(define csegen-500 (lambda (arg-0) (lambda (arg-1) (let ((sc0 (or (and (char=? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1))))))
(define LibrariesC-45DataC-45StringC-45Extra-dropLast (lambda (arg-0 arg-1) (string-reverse (LibrariesC-45DataC-45StringC-45Extra-drop arg-0 (string-reverse arg-1)))))
(define DataC-45List-isPrefixOfBy (lambda (arg-2 arg-3 arg-4) (if (null? arg-3) 1 (if (null? arg-4) 0 (let ((e-1 (car arg-3))) (let ((e-2 (cdr arg-3))) (let ((e-4 (car arg-4))) (let ((e-5 (cdr arg-4))) (let ((sc4 ((arg-2 e-1) e-4))) (cond ((equal? sc4 1) (DataC-45List-isPrefixOfBy arg-2 e-2 e-5)) (else 0)))))))))))
(define DataC-45String-strM (lambda (arg-0) (cond ((equal? arg-0 "") '())(else (cons (string-ref arg-0 0) (substring arg-0 1 (string-length arg-0)))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-case--unsafeTextWithoutNewLines-10735 (lambda (arg-1 arg-2) (cond ((equal? arg-1 "") (if (null? arg-2) (vector 0 ) (let ((e-0 (car arg-2))) (let ((e-1 (cdr arg-2))) (let ((u--str (string-cons e-0 e-1))) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-1 ""))) (cond ((equal? sc3 1) (vector 1 e-0)) (else (vector 2 (blodwen-toSignedInt (PreludeC-45TypesC-45String-length u--str) 63) u--str)))))))))(else (let ((e-0 (car arg-2))) (let ((e-1 (cdr arg-2))) (let ((u--str (string-cons e-0 e-1))) (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-1 ""))) (cond ((equal? sc1 1) (vector 1 e-0)) (else (vector 2 (blodwen-toSignedInt (PreludeC-45TypesC-45String-length u--str) 63) u--str)))))))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-unsafeTextWithoutNewLines (lambda (arg-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-case--unsafeTextWithoutNewLines-10735 arg-1 (DataC-45String-strM arg-1))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--neutral_Monoid_C-40DocC-32C-36annC-41 (vector 0 ))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-concatWith (lambda (arg-1 arg-2) (if (null? arg-2) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--neutral_Monoid_C-40DocC-32C-36annC-41 (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (PreludeC-45Types-u--foldl_Foldable_List arg-1 e-2 e-3))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-line (vector 4 (lambda () (vector 3 )) (lambda () (vector 1 #\ ))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (lambda (ext-0 ext-1) (vector 5 ext-0 ext-1)))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-vsep (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-concatWith (lambda (u--x) (lambda (u--y) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 u--x LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-line) u--y))) ext-0)))
(define DataC-45String-n--3979-9380-u--linesHelp (lambda (arg-0 arg-1 arg-2) (if (null? arg-1) (if (null? arg-2) '() (if (null? arg-2) (cons (PreludeC-45TypesC-45List-reverse arg-1) '()) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (cond ((equal? e-2 (integer->char 10)) (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3979-9380-u--linesHelp arg-0 '() e-3))) ((equal? e-2 (integer->char 13)) (if (null? e-3) (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3979-9380-u--linesHelp arg-0 '() e-3)) (let ((e-5 (car e-3))) (let ((e-6 (cdr e-3))) (cond ((equal? e-5 (integer->char 10)) (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3979-9380-u--linesHelp arg-0 '() e-6)))(else (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3979-9380-u--linesHelp arg-0 '() e-3))))))))(else (DataC-45String-n--3979-9380-u--linesHelp arg-0 (cons e-2 arg-1) e-3))))))) (if (null? arg-2) (cons (PreludeC-45TypesC-45List-reverse arg-1) '()) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (cond ((equal? e-2 (integer->char 10)) (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3979-9380-u--linesHelp arg-0 '() e-3))) ((equal? e-2 (integer->char 13)) (if (null? e-3) (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3979-9380-u--linesHelp arg-0 '() e-3)) (let ((e-5 (car e-3))) (let ((e-6 (cdr e-3))) (cond ((equal? e-5 (integer->char 10)) (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3979-9380-u--linesHelp arg-0 '() e-6)))(else (cons (PreludeC-45TypesC-45List-reverse arg-1) (DataC-45String-n--3979-9380-u--linesHelp arg-0 '() e-3))))))))(else (DataC-45String-n--3979-9380-u--linesHelp arg-0 (cons e-2 arg-1) e-3)))))))))
(define PreludeC-45Types-n--10194-9458-u--unpackC-39 (lambda (arg-0 arg-1 arg-2 arg-3) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-1 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc0 1) arg-3) (else (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-0 (bs- arg-1 1 63) arg-2 (cons (string-ref arg-2 arg-1) arg-3)))))))
(define csegen-504 (cons (lambda (arg-11067) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-vsep (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-unsafeTextWithoutNewLines eta-0)) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Types-fastPack eta-0)) (DataC-45String-n--3979-9380-u--linesHelp (let ((sc0 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11067 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 1 63) arg-11067 (cons (string-ref arg-11067 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11067)) (else arg-11067))))) 63) 1 63) 0) 1) 0))) (cond ((equal? sc0 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11067 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 1 63) arg-11067 (cons (string-ref arg-11067 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11067)) (else arg-11067))) (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11067 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 1 63) arg-11067 (cons (string-ref arg-11067 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11067)) (else arg-11067))))) 63) 1 63) 1 63) (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11067 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 1 63) arg-11067 (cons (string-ref arg-11067 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11067)) (else arg-11067))) (cons (string-ref (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11067 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 1 63) arg-11067 (cons (string-ref arg-11067 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11067)) (else arg-11067))) (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11067 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 1 63) arg-11067 (cons (string-ref arg-11067 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11067)) (else arg-11067))))) 63) 1 63)) '())))(else '()))) '() (let ((sc0 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11067 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 1 63) arg-11067 (cons (string-ref arg-11067 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11067)) (else arg-11067))))) 63) 1 63) 0) 1) 0))) (cond ((equal? sc0 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11067 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 1 63) arg-11067 (cons (string-ref arg-11067 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11067)) (else arg-11067))) (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11067 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 1 63) arg-11067 (cons (string-ref arg-11067 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11067)) (else arg-11067))))) 63) 1 63) 1 63) (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11067 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 1 63) arg-11067 (cons (string-ref arg-11067 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11067)) (else arg-11067))) (cons (string-ref (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11067 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 1 63) arg-11067 (cons (string-ref arg-11067 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11067)) (else arg-11067))) (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11067 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63) 1 63) arg-11067 (cons (string-ref arg-11067 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11067)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11067)) (else arg-11067))))) 63) 1 63)) '())))(else '())))))))) (lambda (arg-11073) (lambda (arg-11076) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-vsep (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-unsafeTextWithoutNewLines eta-0)) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Types-fastPack eta-0)) (DataC-45String-n--3979-9380-u--linesHelp (let ((sc0 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11076 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 1 63) arg-11076 (cons (string-ref arg-11076 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11076)) (else arg-11076))))) 63) 1 63) 0) 1) 0))) (cond ((equal? sc0 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11076 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 1 63) arg-11076 (cons (string-ref arg-11076 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11076)) (else arg-11076))) (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11076 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 1 63) arg-11076 (cons (string-ref arg-11076 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11076)) (else arg-11076))))) 63) 1 63) 1 63) (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11076 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 1 63) arg-11076 (cons (string-ref arg-11076 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11076)) (else arg-11076))) (cons (string-ref (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11076 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 1 63) arg-11076 (cons (string-ref arg-11076 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11076)) (else arg-11076))) (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11076 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 1 63) arg-11076 (cons (string-ref arg-11076 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11076)) (else arg-11076))))) 63) 1 63)) '())))(else '()))) '() (let ((sc0 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11076 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 1 63) arg-11076 (cons (string-ref arg-11076 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11076)) (else arg-11076))))) 63) 1 63) 0) 1) 0))) (cond ((equal? sc0 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11076 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 1 63) arg-11076 (cons (string-ref arg-11076 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11076)) (else arg-11076))) (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11076 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 1 63) arg-11076 (cons (string-ref arg-11076 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11076)) (else arg-11076))))) 63) 1 63) 1 63) (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11076 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 1 63) arg-11076 (cons (string-ref arg-11076 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11076)) (else arg-11076))) (cons (string-ref (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11076 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 1 63) arg-11076 (cons (string-ref arg-11076 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11076)) (else arg-11076))) (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length (let ((sc1 (DataC-45List-isPrefixOfBy csegen-500 (cons (integer->char 10) '()) (PreludeC-45TypesC-45List-reverseOnto '() (let ((sc2 (or (and (< (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 0) 1) 0))) (cond ((equal? sc2 0) (PreludeC-45Types-n--10194-9458-u--unpackC-39 arg-11076 (bs- (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63) 1 63) arg-11076 (cons (string-ref arg-11076 (bs- (blodwen-toSignedInt (PreludeC-45Types-prim__integerToNat (string-length arg-11076)) 63) 1 63)) '())))(else '()))))))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-11076)) (else arg-11076))))) 63) 1 63)) '())))(else '())))))))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 (lambda (arg-2 arg-3) (let ((e-2 (car arg-2))) (e-2 arg-3))))
(define csegen-505 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "_"))
(define DecidableC-45Equality-u--decEq_DecEq_FromEqC-36a (lambda (arg-1 arg-2 arg-3) (let ((sc0 (let ((e-1 (car arg-1))) ((e-1 arg-2) arg-3)))) (cond ((equal? sc0 1) (vector 0 (vector 0 ))) (else (vector 1 (lambda (eta-0) (vector 0 ))))))))
(define DecidableC-45Equality-u--decEq_DecEq_Int (lambda (ext-0 ext-1) (DecidableC-45Equality-u--decEq_DecEq_FromEqC-36a csegen-223 ext-0 ext-1)))
(define csegen-507 (lambda (eta-0) (lambda (eta-1) (DecidableC-45Equality-u--decEq_DecEq_Int eta-0 eta-1))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_Char (lambda (arg-0) (cond ((equal? arg-0 (integer->char 10)) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-line)(else (vector 1 arg-0)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--prettyPrec_Pretty_Void_Char (lambda (arg-0 arg-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_Char arg-1)))
(define csegen-681 (cons (lambda (arg-11067) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_Char arg-11067)) (lambda (arg-11073) (lambda (arg-11076) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--prettyPrec_Pretty_Void_Char arg-11073 arg-11076)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-dot (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-681 #\.))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-surround (lambda (arg-1 arg-2 arg-3) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 arg-2 arg-1) arg-3)))
(define csegen-510 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-surround LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-dot eta-0 eta-1))))
(define DecidableC-45Equality-u--decEq_DecEq_String (lambda (ext-0 ext-1) (DecidableC-45Equality-u--decEq_DecEq_FromEqC-36a csegen-22 ext-0 ext-1)))
(define csegen-511 (lambda (eta-0) (lambda (eta-1) (DecidableC-45Equality-u--decEq_DecEq_String eta-0 eta-1))))
(define LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_Volume (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-3 (vector-ref arg-1 1))) (let ((e-4 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-0 e-3))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-3 e-4)) (else 0))))))(else 0)))) ((1) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-5 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char e-2 e-5)))(else 0))))(else 0))))
(define LibrariesC-45UtilsC-45Path-u--C-47C-61_Eq_Volume (lambda (arg-0 arg-1) (let ((sc0 (LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_Volume arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-524 (cons (lambda (arg-676) (lambda (arg-679) (LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_Volume arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (LibrariesC-45UtilsC-45Path-u--C-47C-61_Eq_Volume arg-686 arg-689)))))
(define LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_Body (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (case (vector-ref arg-1 0) ((0) 1)(else 0))) ((1) (case (vector-ref arg-1 0) ((1) 1)(else 0))) ((2) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((2) (let ((e-1 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-0 e-1)))(else 0))))(else 0))))
(define LibrariesC-45UtilsC-45Path-u--C-47C-61_Eq_Body (lambda (arg-0 arg-1) (let ((sc0 (LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_Body arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-527 (cons (lambda (arg-676) (lambda (arg-679) (LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_Body arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (LibrariesC-45UtilsC-45Path-u--C-47C-61_Eq_Body arg-686 arg-689)))))
(define LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_PathTokenKind (lambda (arg-0 arg-1) (if (null? arg-0) (if (null? arg-1) 1 0) (let ((e-0 (unbox arg-0))) (if (null? arg-1) 0 (let ((e-1 (unbox arg-1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char e-0 e-1)))))))
(define LibrariesC-45UtilsC-45Path-u--C-47C-61_Eq_PathTokenKind (lambda (arg-0 arg-1) (let ((sc0 (LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_PathTokenKind arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define LibrariesC-45UtilsC-45Path-u--TokType_TokenKind_PathTokenKind (lambda (arg-0) (if (null? arg-0) (vector "String" ) (vector "Builtin.Unit" ))))
(define LibrariesC-45UtilsC-45Path-u--tokValue_TokenKind_PathTokenKind (lambda (arg-0 arg-1) (if (null? arg-0) arg-1 (vector 0 ))))
(define csegen-533 (cons (cons (lambda (arg-676) (lambda (arg-679) (LibrariesC-45UtilsC-45Path-u--C-61C-61_Eq_PathTokenKind arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (LibrariesC-45UtilsC-45Path-u--C-47C-61_Eq_PathTokenKind arg-686 arg-689)))) (cons (lambda (arg-823) (LibrariesC-45UtilsC-45Path-u--TokType_TokenKind_PathTokenKind arg-823)) (lambda (u--kind) (lambda (arg-832) (LibrariesC-45UtilsC-45Path-u--tokValue_TokenKind_PathTokenKind u--kind arg-832))))))
(define LibrariesC-45TextC-45Parser-match (lambda (arg-2 arg-3) (vector 1 "Unrecognised input" (lambda (u--t) (let ((sc0 (let ((sc1 (Builtin-fst arg-2))) (let ((e-1 (car sc1))) ((e-1 (let ((e-4 (car u--t))) e-4)) arg-3))))) (cond ((equal? sc0 1) (box (let ((sc1 (Builtin-snd arg-2))) (let ((e-2 (cdr sc1))) ((e-2 arg-3) (let ((e-3 (cdr u--t))) e-3)))))) (else '())))))))
(define csegen-534 (LibrariesC-45TextC-45Parser-match csegen-533 '()))
(define csegen-542 (LibrariesC-45TextC-45Parser-match csegen-533 (box #\\)))
(define LibrariesC-45UtilsC-45Path-bodySeparator (vector 13 1 1 csegen-542 (lambda () (LibrariesC-45TextC-45Parser-match csegen-533 (box #\/)))))
(define csegen-536 (vector 9 1 csegen-534 (lambda () (lambda (u--server) (vector 11 1 LibrariesC-45UtilsC-45Path-bodySeparator (lambda () (vector 9 0 csegen-534 (lambda () (lambda (u--share) (vector 0 (vector 0 u--server u--share)))))))))))
(define LibrariesC-45TextC-45Quantity-exactly (lambda (arg-0) (cons arg-0 (box arg-0))))
(define DataC-45Nat-isSucc (lambda (arg-0) (cond ((equal? arg-0 0) 0)(else 1))))
(define csegen-541 (DataC-45Nat-isSucc (let ((sc0 (LibrariesC-45TextC-45Quantity-exactly 2))) (let ((e-0 (car sc0))) e-0))))
(define LibrariesC-45TextC-45Quantity-atLeast (lambda (arg-0) (cons arg-0 '())))
(define LibrariesC-45TextC-45Quantity-atMost (lambda (arg-0) (cons 0 (box arg-0))))
(define LibrariesC-45TextC-45Quantity-between (lambda (arg-0 arg-1) (cons arg-0 (box arg-1))))
(define LibrariesC-45TextC-45Parser-count1 (lambda (arg-3 arg-4) (vector 9 (let ((sc0 (DataC-45Nat-isSucc (let ((e-0 (car arg-3))) e-0)))) (cond ((equal? sc0 1) 1) (else 0))) arg-4 (lambda () (lambda (u--x) (vector 10 (DataC-45Nat-isSucc (let ((e-0 (car arg-3))) e-0)) 0 (LibrariesC-45TextC-45Parser-count arg-3 arg-4) (lambda (u--xs) (vector 0 (cons u--x u--xs)))))))))
(define LibrariesC-45TextC-45Parser-option (lambda (arg-3 arg-4 arg-5) (cond ((equal? arg-3 0) (vector 13 0 0 arg-5 (lambda () (vector 0 arg-4)))) (else (vector 13 1 0 arg-5 (lambda () (vector 0 arg-4)))))))
(define LibrariesC-45TextC-45Parser-some (lambda (arg-3) (vector 9 0 arg-3 (lambda () (lambda (bind-0) (vector 10 0 0 (LibrariesC-45TextC-45Parser-many arg-3) (lambda (bind-1) (vector 0 (cons bind-0 bind-1)))))))))
(define LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 (lambda (arg-4 arg-5 arg-6) (cond ((equal? arg-4 0) (case (vector-ref arg-6 0) ((0) (let ((e-65 (vector-ref arg-6 1))) (vector 0 (arg-5 e-65))))(else (case (vector-ref arg-6 0) ((4) (let ((e-49 (vector-ref arg-6 1))) (let ((e-50 (vector-ref arg-6 2))) (let ((e-51 (vector-ref arg-6 3))) (vector 4 e-49 e-50 e-51))))) ((6) (let ((e-56 (vector-ref arg-6 1))) (vector 6 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 arg-4 arg-5 e-56)))) ((8) (let ((e-61 (vector-ref arg-6 1))) (vector 8 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 arg-4 arg-5 e-61))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((1) (let ((e-43 (vector-ref arg-6 1))) (let ((e-44 (vector-ref arg-6 2))) (vector 1 e-43 (lambda (eta-0) (PreludeC-45Types-u--map_Functor_Maybe arg-5 (e-44 eta-0)))))))(else (case (vector-ref arg-6 0) ((13) (let ((e-36 (vector-ref arg-6 1))) (let ((e-37 (vector-ref arg-6 2))) (let ((e-38 (vector-ref arg-6 3))) (let ((e-39 (vector-ref arg-6 4))) (vector 13 e-36 e-37 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-36 arg-5 e-38) (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-37 arg-5 (e-39)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((9) (let ((e-30 (vector-ref arg-6 1))) (let ((e-31 (vector-ref arg-6 2))) (let ((e-32 (vector-ref arg-6 3))) (vector 9 e-30 e-31 (lambda () (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-30 arg-5 ((e-32) u--val)))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))))))(else (case (vector-ref arg-6 0) ((13) (let ((e-36 (vector-ref arg-6 1))) (let ((e-37 (vector-ref arg-6 2))) (let ((e-38 (vector-ref arg-6 3))) (let ((e-39 (vector-ref arg-6 4))) (vector 13 e-36 e-37 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-36 arg-5 e-38) (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-37 arg-5 (e-39)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((9) (let ((e-30 (vector-ref arg-6 1))) (let ((e-31 (vector-ref arg-6 2))) (let ((e-32 (vector-ref arg-6 3))) (vector 9 e-30 e-31 (lambda () (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-30 arg-5 ((e-32) u--val)))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))))))))))(else (case (vector-ref arg-6 0) ((4) (let ((e-49 (vector-ref arg-6 1))) (let ((e-50 (vector-ref arg-6 2))) (let ((e-51 (vector-ref arg-6 3))) (vector 4 e-49 e-50 e-51))))) ((6) (let ((e-56 (vector-ref arg-6 1))) (vector 6 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 arg-4 arg-5 e-56)))) ((8) (let ((e-61 (vector-ref arg-6 1))) (vector 8 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 arg-4 arg-5 e-61))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((1) (let ((e-43 (vector-ref arg-6 1))) (let ((e-44 (vector-ref arg-6 2))) (vector 1 e-43 (lambda (eta-0) (PreludeC-45Types-u--map_Functor_Maybe arg-5 (e-44 eta-0)))))))(else (case (vector-ref arg-6 0) ((13) (let ((e-36 (vector-ref arg-6 1))) (let ((e-37 (vector-ref arg-6 2))) (let ((e-38 (vector-ref arg-6 3))) (let ((e-39 (vector-ref arg-6 4))) (vector 13 e-36 e-37 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-36 arg-5 e-38) (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-37 arg-5 (e-39)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((9) (let ((e-30 (vector-ref arg-6 1))) (let ((e-31 (vector-ref arg-6 2))) (let ((e-32 (vector-ref arg-6 3))) (vector 9 e-30 e-31 (lambda () (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-30 arg-5 ((e-32) u--val)))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))))))(else (case (vector-ref arg-6 0) ((13) (let ((e-36 (vector-ref arg-6 1))) (let ((e-37 (vector-ref arg-6 2))) (let ((e-38 (vector-ref arg-6 3))) (let ((e-39 (vector-ref arg-6 4))) (vector 13 e-36 e-37 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-36 arg-5 e-38) (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-37 arg-5 (e-39)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((9) (let ((e-30 (vector-ref arg-6 1))) (let ((e-31 (vector-ref arg-6 2))) (let ((e-32 (vector-ref arg-6 3))) (vector 9 e-30 e-31 (lambda () (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-30 arg-5 ((e-32) u--val)))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))))))(else (case (vector-ref arg-6 0) ((10) (let ((e-22 (vector-ref arg-6 1))) (let ((e-23 (vector-ref arg-6 2))) (let ((e-24 (vector-ref arg-6 3))) (let ((e-25 (vector-ref arg-6 4))) (vector 10 e-22 e-23 e-24 (lambda (u--val) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-23 arg-5 (e-25 u--val)))))))))(else (cond ((equal? arg-4 1) (case (vector-ref arg-6 0) ((11) (let ((e-15 (vector-ref arg-6 1))) (let ((e-16 (vector-ref arg-6 2))) (let ((e-17 (vector-ref arg-6 3))) (vector 11 e-15 e-16 (lambda () (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-15 arg-5 (e-17))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0)))))))))))(else (case (vector-ref arg-6 0) ((12) (let ((e-3 (vector-ref arg-6 1))) (let ((e-4 (vector-ref arg-6 2))) (let ((e-5 (vector-ref arg-6 3))) (let ((e-6 (vector-ref arg-6 4))) (vector 12 e-3 e-4 e-5 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 e-4 arg-5 e-6))))))) ((14) (let ((e-11 (vector-ref arg-6 1))) (vector 10 arg-4 0 (vector 14 e-11) (lambda (eta-0) (vector 0 (arg-5 eta-0))))))(else (cond (else (vector 10 0 0 arg-6 (lambda (eta-0) (vector 0 (arg-5 eta-0))))))))))))))))))))))))
(define LibrariesC-45TextC-45Parser-many (lambda (arg-3) (LibrariesC-45TextC-45Parser-option 1 '() (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 1 (lambda (eta-0) (DataC-45List1-forget eta-0)) (LibrariesC-45TextC-45Parser-some arg-3)))))
(define LibrariesC-45TextC-45Parser-count (lambda (arg-3 arg-4) (let ((e-0 (car arg-3))) (let ((e-1 (cdr arg-3))) (cond ((equal? e-0 0) (if (null? e-1) (LibrariesC-45TextC-45Parser-many arg-4) (let ((e-5 (unbox e-1))) (cond ((equal? e-5 0) (vector 0 '()))(else (let ((e-6 (- e-5 1))) (LibrariesC-45TextC-45Parser-option 1 '() (LibrariesC-45TextC-45Parser-count1 (LibrariesC-45TextC-45Quantity-atMost e-6) arg-4))))))))(else (let ((e-2 (- e-0 1))) (if (null? e-1) (LibrariesC-45TextC-45Parser-count1 (LibrariesC-45TextC-45Quantity-atLeast e-2) arg-4) (let ((e-9 (unbox e-1))) (cond ((equal? e-9 0) (vector 4 '() 0 "Quantity out of order"))(else (let ((e-10 (- e-9 1))) (LibrariesC-45TextC-45Parser-count1 (LibrariesC-45TextC-45Quantity-between (+ e-2 1) e-10) arg-4)))))))))))))
(define csegen-544 (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 csegen-541 (lambda (eta-0) (vector 0 )) (LibrariesC-45TextC-45Parser-count (LibrariesC-45TextC-45Quantity-exactly 2) csegen-542)))
(define csegen-547 (vector 11 1 (LibrariesC-45TextC-45Parser-match csegen-533 (box #\?)) (lambda () (vector 11 0 csegen-542 (lambda () (vector 0 (vector 0 )))))))
(define SystemC-45Info-isWindows csegen-96)
(define LibrariesC-45UtilsC-45Path-pathSeparator (let ((sc0 SystemC-45Info-isWindows)) (cond ((equal? sc0 1) #\;) (else #\:))))
(define csegen-574 (lambda (arg-0) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 LibrariesC-45UtilsC-45Path-pathSeparator)))
(define LibrariesC-45TextC-45Parser-optional (lambda (arg-3 arg-4) (LibrariesC-45TextC-45Parser-option arg-3 '() (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 arg-3 (lambda (eta-0) (box eta-0)) arg-4))))
(define csegen-579 (LibrariesC-45TextC-45Parser-optional 1 (LibrariesC-45TextC-45Parser-some LibrariesC-45UtilsC-45Path-bodySeparator)))
(define PreludeC-45Types-isSpace (lambda (arg-0) (cond ((equal? arg-0 #\ ) 1) ((equal? arg-0 (integer->char 9)) 1) ((equal? arg-0 (integer->char 13)) 1) ((equal? arg-0 (integer->char 10)) 1) ((equal? arg-0 (integer->char 12)) 1) ((equal? arg-0 (integer->char 11)) 1) ((equal? arg-0 (integer->char 160)) 1)(else 0))))
(define csegen-597 (lambda (u--char) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Char u--char #\.))) (cond ((equal? sc0 1) 1) (else (PreludeC-45Types-isSpace u--char))))))
(define csegen-602 (cons (cons "End of input" '()) '()))
(define LibrariesC-45TextC-45Lexer-any (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (eta-0) 1)))
(define LibrariesC-45TextC-45Lexer-escape (lambda (arg-0 arg-1) (vector 5 arg-0 (lambda () arg-1))))
(define csegen-647 (LibrariesC-45TextC-45LexerC-45Core-C-60C-124C-62 (LibrariesC-45TextC-45Lexer-escape (LibrariesC-45TextC-45Lexer-is #\\) LibrariesC-45TextC-45Lexer-any) LibrariesC-45TextC-45Lexer-any))
(define csegen-649 (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (eta-0) (PreludeC-45Types-isSpace eta-0))))
(define csegen-678 (lambda (arg-0) (PreludeC-45EqOrd-u--C-47C-61_Eq_Char arg-0 (integer->char 10))))
(define csegen-679 (lambda (arg-0) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 (integer->char 10))))
(define DataC-45List-isSuffixOfBy (lambda (arg-2 arg-3 arg-4) (DataC-45List-isPrefixOfBy arg-2 (PreludeC-45TypesC-45List-reverse arg-3) (PreludeC-45TypesC-45List-reverse arg-4))))
(define DataC-45List-isSuffixOf (lambda (arg-1 ext-0 ext-1) (DataC-45List-isSuffixOfBy (lambda (eta-0) (lambda (eta-1) (let ((e-1 (car arg-1))) ((e-1 eta-0) eta-1)))) ext-0 ext-1)))
(define DataC-45String-isSuffixOf (lambda (arg-0 arg-1) (DataC-45List-isSuffixOf csegen-17 (PreludeC-45Types-fastUnpack arg-0) (PreludeC-45Types-fastUnpack arg-1))))
(define DataC-45String-linesC-39 (lambda (arg-0) (DataC-45String-n--3979-9380-u--linesHelp arg-0 '() arg-0)))
(define DataC-45String-lines (lambda (arg-0) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Types-fastPack eta-0)) (DataC-45String-linesC-39 (PreludeC-45Types-fastUnpack arg-0)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String (lambda (arg-0) (let ((u--strC-39 (let ((sc0 (DataC-45String-isSuffixOf "\xa;" arg-0))) (cond ((equal? sc0 1) (LibrariesC-45DataC-45StringC-45Extra-dropLast 1 arg-0)) (else arg-0))))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-vsep (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-unsafeTextWithoutNewLines eta-0)) (DataC-45String-lines u--strC-39))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--prettyPrec_Pretty_Void_String (lambda (arg-0 arg-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String arg-1)))
(define csegen-702 (cons (lambda (arg-11067) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String arg-11067)) (lambda (arg-11073) (lambda (arg-11076) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--prettyPrec_Pretty_Void_String arg-11073 arg-11076)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 (lambda (arg-1 arg-2) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 arg-1 (vector 1 #\ )) arg-2)))
(define csegen-716 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 eta-0 eta-1))))
(define csegen-717 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 eta-0 eta-1))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_Integer (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-722 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_Integer arg-686 arg-689)))))
(define csegen-753 (lambda (eta-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-702 eta-0)))
(define csegen-755 (lambda (eta-0) (lambda (eta-1) (cons eta-0 eta-1))))
(define csegen-765 (vector 5 (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (eta-0) (ParserC-45LexerC-45Common-isIdentStart 1 eta-0))) (lambda () (LibrariesC-45TextC-45Lexer-many (LibrariesC-45TextC-45LexerC-45Core-pred (lambda (eta-0) (ParserC-45LexerC-45Common-isIdentTrailing 1 eta-0)))))))
(define csegen-779 (lambda (eta-0) (ParserC-45LexerC-45Common-isIdentTrailing 0 eta-0)))
(define LibrariesC-45DataC-45SortedMap-treeInsertC-39 (lambda (arg-4 arg-5 arg-6 arg-7) (case (vector-ref arg-7 0) ((0) (let ((e-3 (vector-ref arg-7 1))) (let ((e-4 (vector-ref arg-7 2))) (let ((sc1 (let ((e-2 (vector-ref arg-4 1))) ((e-2 arg-5) e-3)))) (cond ((equal? sc1 0) (vector 1 (cons (vector 0 arg-5 arg-6) (cons arg-5 (vector 0 e-3 e-4))))) ((equal? sc1 1) (vector 0 (vector 0 arg-5 arg-6))) (else (vector 1 (cons (vector 0 e-3 e-4) (cons e-3 (vector 0 arg-5 arg-6)))))))))) ((1) (let ((e-9 (vector-ref arg-7 1))) (let ((e-10 (vector-ref arg-7 2))) (let ((e-11 (vector-ref arg-7 3))) (let ((sc1 (let ((e-5 (vector-ref arg-4 4))) ((e-5 arg-5) e-10)))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45SortedMap-treeInsertC-39 arg-4 arg-5 arg-6 e-9))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-2 e-10 e-11)))) (else (let ((e-5 (vector-ref sc2 1))) (let ((e-8 (car e-5))) (let ((e-12 (cdr e-5))) (let ((e-14 (car e-12))) (let ((e-13 (cdr e-12))) (vector 0 (vector 2 e-8 e-14 e-13 e-10 e-11))))))))))) (else (let ((sc2 (LibrariesC-45DataC-45SortedMap-treeInsertC-39 arg-4 arg-5 arg-6 e-11))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-9 e-10 e-2)))) (else (let ((e-5 (vector-ref sc2 1))) (let ((e-8 (car e-5))) (let ((e-12 (cdr e-5))) (let ((e-14 (car e-12))) (let ((e-13 (cdr e-12))) (vector 0 (vector 2 e-9 e-10 e-8 e-14 e-13))))))))))))))))) (else (let ((e-16 (vector-ref arg-7 1))) (let ((e-17 (vector-ref arg-7 2))) (let ((e-18 (vector-ref arg-7 3))) (let ((e-19 (vector-ref arg-7 4))) (let ((e-20 (vector-ref arg-7 5))) (let ((sc1 (let ((e-5 (vector-ref arg-4 4))) ((e-5 arg-5) e-17)))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45SortedMap-treeInsertC-39 arg-4 arg-5 arg-6 e-16))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 2 e-2 e-17 e-18 e-19 e-20)))) (else (let ((e-5 (vector-ref sc2 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (cons (vector 1 e-8 e-12 e-13) (cons e-17 (vector 1 e-18 e-19 e-20))))))))))))) (else (let ((sc2 (let ((e-5 (vector-ref arg-4 4))) ((e-5 arg-5) e-19)))) (cond ((equal? sc2 1) (let ((sc3 (LibrariesC-45DataC-45SortedMap-treeInsertC-39 arg-4 arg-5 arg-6 e-18))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-16 e-17 e-2 e-19 e-20)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (cons (vector 1 e-16 e-17 e-8) (cons e-12 (vector 1 e-13 e-19 e-20))))))))))))) (else (let ((sc3 (LibrariesC-45DataC-45SortedMap-treeInsertC-39 arg-4 arg-5 arg-6 e-20))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-16 e-17 e-18 e-19 e-2)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (cons (vector 1 e-16 e-17 e-18) (cons e-19 (vector 1 e-8 e-12 e-13)))))))))))))))))))))))))))
(define LibrariesC-45DataC-45SortedMap-treeInsert (lambda (arg-4 arg-5 arg-6 arg-7) (let ((sc0 (LibrariesC-45DataC-45SortedMap-treeInsertC-39 arg-4 arg-5 arg-6 arg-7))) (case (vector-ref sc0 0) ((0) (let ((e-2 (vector-ref sc0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref sc0 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (vector 1 e-8 e-12 e-13))))))))))))
(define LibrariesC-45DataC-45SortedMap-insert (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-2 (vector-ref arg-4 1))) (vector 1 e-2 0 (vector 0 arg-2 arg-3)))) (else (let ((e-5 (vector-ref arg-4 1))) (let ((e-6 (vector-ref arg-4 2))) (let ((e-7 (vector-ref arg-4 3))) (let ((sc1 (LibrariesC-45DataC-45SortedMap-treeInsert e-5 arg-2 arg-3 e-7))) (case (vector-ref sc1 0) ((0) (let ((e-2 (vector-ref sc1 1))) (vector 1 e-5 e-6 e-2))) (else (let ((e-8 (vector-ref sc1 1))) (vector 1 e-5 (+ e-6 1) e-8))))))))))))
(define csegen-790 (lambda (eta-0) (lambda (eta-1) (PreludeC-45Basics-flip (lambda (eta-2) (PreludeC-45Basics-uncurry (lambda (eta-3) (lambda (eta-4) (lambda (eta-5) (LibrariesC-45DataC-45SortedMap-insert eta-3 eta-4 eta-5)))) eta-2)) eta-0 eta-1))))
(define csegen-829 (cons 0 (cons 1 '())))
(define IdrisC-45SyntaxC-45Pragmas-allLangExts csegen-829)
(define IdrisC-45SyntaxC-45Pragmas-u--show_Show_LangExt (lambda (arg-0) (cond ((equal? arg-0 0) "ElabReflection") (else "Borrowing"))))
(define csegen-800 (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (IdrisC-45SyntaxC-45Pragmas-u--show_Show_LangExt eta-0)) IdrisC-45SyntaxC-45Pragmas-allLangExts))
(define CoreC-45Name-u--C-47C-61_Eq_Name (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45Name-u--C-61C-61_Eq_Name arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-832 (cons (lambda (arg-676) (lambda (arg-679) (CoreC-45Name-u--C-61C-61_Eq_Name arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (CoreC-45Name-u--C-47C-61_Eq_Name arg-686 arg-689)))))
(define PreludeC-45Show-n--3221-12652-u--showC-39 (lambda (arg-1 arg-2 arg-3 arg-4) (if (null? arg-4) arg-3 (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (if (null? e-3) (string-append arg-3 (let ((e-1 (car arg-1))) (e-1 e-2))) (PreludeC-45Show-n--3221-12652-u--showC-39 arg-1 arg-2 (string-append arg-3 (string-append (let ((e-1 (car arg-1))) (e-1 e-2)) ", ")) e-3)))))))
(define PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2) (string-append "[" (string-append (PreludeC-45Show-n--3221-12652-u--showC-39 arg-1 arg-2 "" arg-2) "]"))))
(define AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega (lambda (arg-0) (cond ((equal? arg-0 0) "Rig0") ((equal? arg-0 1) "Rig1") (else "RigW"))))
(define csegen-851 (lambda (u--nm) (string-append " proof " (CoreC-45Name-u--show_Show_Name u--nm))))
(define TTImpC-45TTImp-u--show_Show_C-40ImpClauseC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-2) (string-append " = " (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-3)))))) ((1) (let ((e-6 (vector-ref arg-2 2))) (let ((e-7 (vector-ref arg-2 3))) (let ((e-8 (vector-ref arg-2 4))) (let ((e-9 (vector-ref arg-2 5))) (let ((e-11 (vector-ref arg-2 7))) (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-6) (string-append " with (" (string-append (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega e-7) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-8) (string-append ")" (string-append (PreludeC-45Types-maybe (lambda () "") (lambda () csegen-851) e-9) (string-append "\xa;\x9;" (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-11))))))))))))))) (else (let ((e-14 (vector-ref arg-2 2))) (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-14) " impossible"))))))
(define TTImpC-45TTImp-u--showPrec_Show_C-40ImpClauseC-39C-32C-36nmC-41 (lambda (arg-1 arg-2 arg-3) (TTImpC-45TTImp-u--show_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 arg-3)))
(define DataC-45List-mergeReplicate (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (cons arg-1 (cons e-2 (DataC-45List-mergeReplicate arg-1 e-3))))))))
(define DataC-45List-intersperse (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (cons e-2 (DataC-45List-mergeReplicate arg-1 e-3)))))))
(define PreludeC-45Show-u--show_Show_Bool (lambda (arg-0) (cond ((equal? arg-0 1) "True") (else "False"))))
(define TTImpC-45TTImp-u--show_Show_C-40FnOptC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) "%unsafe") ((1) "%inline") ((2) "%noinline") ((3) "%deprecate") ((4) "%tcinline") ((5) (let ((e-6 (vector-ref arg-2 1))) (string-append "%hint " (PreludeC-45Show-u--show_Show_Bool e-6)))) ((6) (let ((e-8 (vector-ref arg-2 1))) (string-append "%globalhint " (PreludeC-45Show-u--show_Show_Bool e-8)))) ((7) "%extern") ((8) (let ((e-11 (vector-ref arg-2 1))) (string-append "%foreign " (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 eta-0)) e-11))))) ((9) (let ((e-13 (vector-ref arg-2 1))) (string-append "%export " (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 eta-0)) e-13))))) ((10) "%invertible") ((11) (let ((e-16 (vector-ref arg-2 1))) (cond ((equal? e-16 0) "total") ((equal? e-16 1) "covering") (else "partial")))) ((12) "%macro") (else (let ((e-19 (vector-ref arg-2 1))) (string-append "%spec " (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45Name-u--show_Show_Name eta-0)) e-19))))))))
(define TTImpC-45TTImp-u--showPrec_Show_C-40FnOptC-39C-32C-36nmC-41 (lambda (arg-1 arg-2 arg-3) (TTImpC-45TTImp-u--show_Show_C-40FnOptC-39C-32C-36nmC-41 arg-1 arg-3)))
(define CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) "Implicit") ((1) "Explicit") ((2) "AutoImplicit") (else (let ((e-4 (vector-ref arg-2 1))) (string-append "DefImplicit " (let ((e-1 (car arg-1))) (e-1 e-4))))))))
(define CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (lambda (arg-1 arg-2 arg-3) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 arg-1 arg-3)))
(define TTImpC-45TTImp-u--show_Show_C-40ImpTyC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (let ((e-3 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (string-append "(%claim " (string-append (CoreC-45Name-u--show_Show_Name e-3) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-4) ")"))))))))
(define TTImpC-45TTImp-u--showPrec_Show_C-40ImpTyC-39C-32C-36nmC-41 (lambda (arg-1 arg-2 arg-3) (TTImpC-45TTImp-u--show_Show_C-40ImpTyC-39C-32C-36nmC-41 arg-1 arg-3)))
(define TTImpC-45TTImp-u--show_Show_C-40ImpDataC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 5))) (if (null? e-3) (string-append "(%data " (string-append (CoreC-45Name-u--show_Show_Name e-2) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpTyC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpTyC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-5) ")")))) (let ((e-11 (unbox e-3))) (string-append "(%data " (string-append (CoreC-45Name-u--show_Show_Name e-2) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-11) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpTyC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpTyC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-5) ")")))))))))))) (else (let ((e-8 (vector-ref arg-2 2))) (let ((e-9 (vector-ref arg-2 3))) (string-append "(%datadecl " (string-append (CoreC-45Name-u--show_Show_Name e-8) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-9) ")"))))))))))
(define TTImpC-45TTImp-u--show_Show_C-40IFieldC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (let ((e-3 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 4))) (case (vector-ref e-3 0) ((1) (string-append (CoreC-45Name-u--show_Show_Name e-4) (string-append " : " (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-5))))(else (string-append "{" (string-append (CoreC-45Name-u--show_Show_Name e-4) (string-append " : " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-5) "}")))))))))))
(define AlgebraC-45ZeroOneOmega-u--showPrec_Show_ZeroOneOmega (lambda (arg-0 arg-1) (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega arg-1)))
(define csegen-849 (cons (lambda (u--x) (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega u--x)) (lambda (u--d) (lambda (u--x) (AlgebraC-45ZeroOneOmega-u--showPrec_Show_ZeroOneOmega u--d u--x)))))
(define TTImpC-45TTImp-u--show_Show_C-40ImpRecordC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (let ((e-2 (vector-ref arg-2 1))) (let ((e-3 (vector-ref arg-2 2))) (let ((e-5 (vector-ref arg-2 4))) (let ((e-6 (vector-ref arg-2 5))) (string-append "record " (string-append (CoreC-45Name-u--show_Show_Name e-2) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-65 (cons (lambda (x-0) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-849 (cons (lambda (x-1) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (u--d) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--d x-3)))) x-2)) (lambda (u--d) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-0) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-3)))) u--d x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (u--d) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--d x-2))))) x-1)) (lambda (u--d) (lambda (x-1) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-0) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-3)))) x-2)) (lambda (d-0) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-1) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-3)))) d-0 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-0) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-2))))) u--d x-1))))) x-0)) (lambda (u--d) (lambda (x-0) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-849 (cons (lambda (x-1) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-0) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-3)))) x-2)) (lambda (d-0) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-1) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-3)))) d-0 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-0) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-2))))) x-1)) (lambda (d-0) (lambda (x-1) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-1) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-3)))) x-2)) (lambda (d-1) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-2) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-2 x-3)))) d-1 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-1) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-2))))) d-0 x-1))))) u--d x-0))))) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-65 (cons (lambda (x-0) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-849 (cons (lambda (x-1) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-0) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-3)))) x-2)) (lambda (d-0) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-1) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-3)))) d-0 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-0) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-2))))) x-1)) (lambda (d-0) (lambda (x-1) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-1) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-3)))) x-2)) (lambda (d-1) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-2) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-2 x-3)))) d-1 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-1) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-2))))) d-0 x-1))))) x-0)) (lambda (d-0) (lambda (x-0) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-849 (cons (lambda (x-1) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-1) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-3)))) x-2)) (lambda (d-1) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-2) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-2 x-3)))) d-1 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-1) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-2))))) x-1)) (lambda (d-1) (lambda (x-1) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-2) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-2 x-3)))) x-2)) (lambda (d-2) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-3) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-3 x-3)))) d-2 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-2) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-2 x-2))))) d-1 x-1))))) d-0 x-0))))) u--d u--x)))) e-3) (string-append " " (string-append (CoreC-45Name-u--show_Show_Name e-5) (string-append "\xa;\x9;" (string-append (CoreC-45NameC-45Namespace-showSep "\xa;\x9;" (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (TTImpC-45TTImp-u--show_Show_C-40IFieldC-39C-32C-36nmC-41 arg-1 eta-0)) e-6)) "\xa;"))))))))))))))
(define CoreC-45Context-u--show_Show_BuiltinType (lambda (arg-0) (cond ((equal? arg-0 0) "Natural") ((equal? arg-0 1) "NaturalToInteger") (else "IntegerToNatural"))))
(define PreludeC-45Show-u--show_Show_Nat (lambda (arg-0) (PreludeC-45Show-u--show_Show_Integer arg-0)))
(define TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 4))) (let ((e-5 (vector-ref arg-2 5))) (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40FnOptC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40FnOptC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-4) (string-append " " (string-append (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega e-2) (string-append " " (TTImpC-45TTImp-u--show_Show_C-40ImpTyC-39C-32C-36nmC-41 arg-1 e-5))))))))) ((1) (let ((e-10 (vector-ref arg-2 4))) (TTImpC-45TTImp-u--show_Show_C-40ImpDataC-39C-32C-36nmC-41 arg-1 e-10))) ((2) (let ((e-13 (vector-ref arg-2 2))) (let ((e-14 (vector-ref arg-2 3))) (string-append "(%def " (string-append (CoreC-45Name-u--show_Show_Name e-13) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-14) ")"))))))) ((3) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (string-append "parameters " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-65 (cons (lambda (x-0) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-849 (cons (lambda (x-1) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (u--d) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--d x-3)))) x-2)) (lambda (u--d) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-0) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-3)))) u--d x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (u--d) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--d x-2))))) x-1)) (lambda (u--d) (lambda (x-1) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-0) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-3)))) x-2)) (lambda (d-0) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-1) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-3)))) d-0 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-0) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-2))))) u--d x-1))))) x-0)) (lambda (u--d) (lambda (x-0) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-849 (cons (lambda (x-1) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-0) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-3)))) x-2)) (lambda (d-0) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-1) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-3)))) d-0 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-0) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-2))))) x-1)) (lambda (d-0) (lambda (x-1) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-1) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-3)))) x-2)) (lambda (d-1) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-2) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-2 x-3)))) d-1 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-1) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-2))))) d-0 x-1))))) u--d x-0))))) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-65 (cons (lambda (x-0) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-849 (cons (lambda (x-1) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-0) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-3)))) x-2)) (lambda (d-0) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-1) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-3)))) d-0 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-0) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-0 x-2))))) x-1)) (lambda (d-0) (lambda (x-1) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-1) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-3)))) x-2)) (lambda (d-1) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-2) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-2 x-3)))) d-1 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-1) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-2))))) d-0 x-1))))) x-0)) (lambda (d-0) (lambda (x-0) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-849 (cons (lambda (x-1) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-1) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-3)))) x-2)) (lambda (d-1) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-2) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-2 x-3)))) d-1 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-1) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-1 x-2))))) x-1)) (lambda (d-1) (lambda (x-1) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons (cons (lambda (x-2) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-2) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-2 x-3)))) x-2)) (lambda (d-2) (lambda (x-2) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (x-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-3)) (lambda (d-3) (lambda (x-3) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-3 x-3)))) d-2 x-2)))) (cons (lambda (x-2) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 x-2)) (lambda (d-2) (lambda (x-2) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 d-2 x-2))))) d-1 x-1))))) d-0 x-0))))) u--d u--x)))) e-17) (string-append "\xa;\x9;" (CoreC-45NameC-45Namespace-showSep "\xa;\x9;" (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 eta-0)) e-18)))))))) ((4) (let ((e-24 (vector-ref arg-2 5))) (TTImpC-45TTImp-u--show_Show_C-40ImpRecordC-39C-32C-36nmC-41 arg-1 e-24))) ((5) (let ((e-27 (vector-ref arg-2 2))) (let ((e-28 (vector-ref arg-2 3))) (string-append "fail" (string-append (PreludeC-45Types-maybe (lambda () "") (lambda () (lambda (eta-0) (string-append " " (PreludeC-45Show-u--show_Show_String eta-0)))) e-27) (string-append "\xa;" (CoreC-45NameC-45Namespace-showSep "\xa;" (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (string-append "  " (TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 eta-0))) e-28)))))))) ((6) (let ((e-31 (vector-ref arg-2 2))) (let ((e-32 (vector-ref arg-2 3))) (string-append "namespace " (string-append (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-31) (CoreC-45NameC-45Namespace-showSep "\xa;" (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 eta-0)) e-32))))))) ((7) (let ((e-35 (vector-ref arg-2 2))) (let ((e-36 (vector-ref arg-2 3))) (let ((e-37 (vector-ref arg-2 4))) (string-append "%transform " (string-append (CoreC-45Name-u--show_Show_Name e-35) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-36) (string-append " ==> " (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-37)))))))))) ((8) (let ((e-40 (vector-ref arg-2 2))) (string-append "%runElab " (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-40)))) ((9) "[externally defined pragma]") ((10) (let ((e-46 (vector-ref arg-2 1))) (if (null? e-46) "%logging off" (let ((e-53 (unbox e-46))) (let ((e-56 (car e-53))) (let ((e-57 (cdr e-53))) (string-append "%logging " (if (null? e-56) (PreludeC-45Show-u--show_Show_Nat e-57) (string-append (PreludeC-45Types-u--foldMap_Foldable_List csegen-59 (lambda (eta-0) eta-0) (DataC-45List-intersperse "." e-56)) (string-append " " (PreludeC-45Show-u--show_Show_Nat e-57))))))))))) (else (let ((e-49 (vector-ref arg-2 2))) (let ((e-50 (vector-ref arg-2 3))) (string-append "%builtin " (string-append (CoreC-45Context-u--show_Show_BuiltinType e-49) (string-append " " (CoreC-45Name-u--show_Show_Name e-50))))))))))
(define TTImpC-45TTImp-u--showPrec_Show_C-40ImpDeclC-39C-32C-36nmC-41 (lambda (arg-1 arg-2 arg-3) (TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 arg-3)))
(define PreludeC-45Show-u--showPrec_Show_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) "Nothing" (let ((e-2 (unbox arg-3))) (PreludeC-45Show-showCon arg-2 "Just" (PreludeC-45Show-showArg arg-1 e-2))))))
(define TTImpC-45TTImp-u--show_Show_C-40IFieldUpdateC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (string-append (CoreC-45NameC-45Namespace-showSep "->" e-1) (string-append " = " (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-2)))))) (else (let ((e-4 (vector-ref arg-2 1))) (let ((e-5 (vector-ref arg-2 2))) (string-append (CoreC-45NameC-45Namespace-showSep "->" e-4) (string-append " $= " (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-5)))))))))
(define PreludeC-45Show-u--showPrec_Show_Bits16 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Bits16 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Bits16 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Bits32 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Bits32 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Bits32 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Bits64 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Bits64 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Bits64 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Bits8 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Bits8 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Bits8 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--show_Show_Char (lambda (arg-0) (cond ((equal? arg-0 #\') "'\\''")(else (string-cons #\' ((PreludeC-45Show-showLitChar arg-0) "'"))))))
(define PreludeC-45Show-u--showPrec_Show_Double (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Double (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Double (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Int16 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Int16 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Int16 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Int32 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Int32 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Int32 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Int64 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Int64 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Int64 (vector 0 ) arg-0)))
(define PreludeC-45Show-u--showPrec_Show_Int8 (lambda (ext-0 ext-1) (PreludeC-45Show-primNumShow (lambda (eta-0) (number->string eta-0)) ext-0 ext-1)))
(define PreludeC-45Show-u--show_Show_Int8 (lambda (arg-0) (PreludeC-45Show-u--showPrec_Show_Int8 (vector 0 ) arg-0)))
(define CoreC-45TTC-45Primitive-u--show_Show_PrimType (lambda (arg-0) (cond ((equal? arg-0 0) "Int") ((equal? arg-0 1) "Int8") ((equal? arg-0 2) "Int16") ((equal? arg-0 3) "Int32") ((equal? arg-0 4) "Int64") ((equal? arg-0 5) "Integer") ((equal? arg-0 6) "Bits8") ((equal? arg-0 7) "Bits16") ((equal? arg-0 8) "Bits32") ((equal? arg-0 9) "Bits64") ((equal? arg-0 10) "String") ((equal? arg-0 11) "Char") ((equal? arg-0 12) "Double") (else "%World"))))
(define CoreC-45TTC-45Primitive-u--show_Show_Constant (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Int e-0))) ((1) (let ((e-1 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Int8 e-1))) ((2) (let ((e-2 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Int16 e-2))) ((3) (let ((e-3 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Int32 e-3))) ((4) (let ((e-4 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Int64 e-4))) ((5) (let ((e-5 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Integer e-5))) ((6) (let ((e-6 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Bits8 e-6))) ((7) (let ((e-7 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Bits16 e-7))) ((8) (let ((e-8 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Bits32 e-8))) ((9) (let ((e-9 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Bits64 e-9))) ((10) (let ((e-10 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_String e-10))) ((11) (let ((e-11 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Char e-11))) ((12) (let ((e-12 (vector-ref arg-0 1))) (PreludeC-45Show-u--show_Show_Double e-12))) ((13) (let ((e-13 (vector-ref arg-0 1))) (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-13))) (else "%MkWorld"))))
(define CoreC-45OptionsC-45Log-u--show_Show_LogLevel (lambda (arg-0) (let ((e-0 (car arg-0))) (let ((e-1 (cdr arg-0))) (if (null? e-0) (PreludeC-45Show-u--show_Show_Nat e-1) (string-append (PreludeC-45Types-fastConcat (DataC-45List-intersperse "." e-0)) (string-append ":" (PreludeC-45Show-u--show_Show_Nat e-1))))))))
(define TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 2))) (let ((e-4 (car arg-1))) (e-4 e-2)))) ((1) (let ((e-5 (vector-ref arg-2 2))) (let ((e-6 (vector-ref arg-2 3))) (let ((e-7 (vector-ref arg-2 4))) (let ((e-8 (vector-ref arg-2 5))) (let ((e-9 (vector-ref arg-2 6))) (string-append "(%pi " (string-append (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega e-5) (string-append " " (string-append (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-6) (string-append " " (string-append (PreludeC-45Show-u--showPrec_Show_C-40MaybeC-32C-36aC-41 csegen-65 (vector 6 ) e-7) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-8) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-9) ")")))))))))))))))) ((2) (let ((e-12 (vector-ref arg-2 2))) (let ((e-13 (vector-ref arg-2 3))) (let ((e-14 (vector-ref arg-2 4))) (let ((e-15 (vector-ref arg-2 5))) (let ((e-16 (vector-ref arg-2 6))) (string-append "(%lam " (string-append (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega e-12) (string-append " " (string-append (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-13) (string-append " " (string-append (PreludeC-45Show-u--showPrec_Show_C-40MaybeC-32C-36aC-41 csegen-65 (vector 6 ) e-14) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-15) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-16) ")")))))))))))))))) ((3) (let ((e-20 (vector-ref arg-2 3))) (let ((e-21 (vector-ref arg-2 4))) (let ((e-22 (vector-ref arg-2 5))) (let ((e-23 (vector-ref arg-2 6))) (let ((e-24 (vector-ref arg-2 7))) (string-append "(%let " (string-append (AlgebraC-45ZeroOneOmega-u--show_Show_ZeroOneOmega e-20) (string-append " " (string-append " " (string-append (CoreC-45Name-u--show_Show_Name e-21) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-22) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-23) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-24) ")"))))))))))))))))) ((4) (let ((e-28 (vector-ref arg-2 3))) (let ((e-29 (vector-ref arg-2 4))) (let ((e-30 (vector-ref arg-2 5))) (string-append "(%case (" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-28) (string-append " : " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-29) (string-append ") " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpClauseC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-30) ")")))))))))) ((5) (let ((e-33 (vector-ref arg-2 2))) (let ((e-34 (vector-ref arg-2 3))) (string-append "(%local (" (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-33) (string-append ") " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-34) ")"))))))) ((6) (let ((e-37 (vector-ref arg-2 2))) (let ((e-38 (vector-ref arg-2 3))) (let ((e-39 (vector-ref arg-2 4))) (let ((e-40 (vector-ref arg-2 5))) (string-append "(%caselocal (" (string-append (CoreC-45Name-u--show_Show_Name e-37) (string-append " " (string-append (CoreC-45Name-u--show_Show_Name e-38) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-65 e-39) (string-append ") " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-40) ")"))))))))))))) ((7) (let ((e-43 (vector-ref arg-2 2))) (let ((e-44 (vector-ref arg-2 3))) (string-append "(%record " (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (TTImpC-45TTImp-u--show_Show_C-40IFieldUpdateC-39C-32C-36nmC-41 arg-1 eta-0)) e-43)) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-44) ")"))))))) ((8) (let ((e-47 (vector-ref arg-2 2))) (let ((e-48 (vector-ref arg-2 3))) (string-append "(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-47) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-48) ")"))))))) ((10) (let ((e-51 (vector-ref arg-2 2))) (let ((e-52 (vector-ref arg-2 3))) (let ((e-53 (vector-ref arg-2 4))) (string-append "(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-51) (string-append " [" (string-append (CoreC-45Name-u--show_Show_Name e-52) (string-append " = " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-53) "])")))))))))) ((9) (let ((e-56 (vector-ref arg-2 2))) (let ((e-57 (vector-ref arg-2 3))) (string-append "(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-56) (string-append " [" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-57) "])"))))))) ((11) (let ((e-60 (vector-ref arg-2 2))) (let ((e-61 (vector-ref arg-2 3))) (string-append "(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-60) (string-append " | " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-61) ")"))))))) ((12) "%search") ((13) (let ((e-68 (vector-ref arg-2 3))) (string-append "(|" (string-append (CoreC-45NameC-45Namespace-showSep "," (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 eta-0)) e-68)) "|)")))) ((14) (let ((e-71 (vector-ref arg-2 2))) (let ((e-72 (vector-ref arg-2 3))) (string-append "(%rewrite (" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-71) (string-append ") (" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-72) "))"))))))) ((15) (let ((e-75 (vector-ref arg-2 2))) (string-append "(%coerced " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-75) ")")))) ((16) (let ((e-79 (vector-ref arg-2 3))) (string-append "(%bindhere " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-79) ")")))) ((17) (let ((e-82 (vector-ref arg-2 2))) (string-append "$" e-82))) ((18) (let ((e-87 (vector-ref arg-2 4))) (let ((e-88 (vector-ref arg-2 5))) (string-append (CoreC-45Name-u--show_Show_Name e-87) (string-append "@(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-88) ")")))))) ((19) (let ((e-92 (vector-ref arg-2 3))) (string-append ".(" (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-92) ")")))) ((20) (let ((e-96 (vector-ref arg-2 3))) (string-append "(%delayed " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-96) ")")))) ((21) (let ((e-99 (vector-ref arg-2 2))) (string-append "(%delay " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-99) ")")))) ((22) (let ((e-102 (vector-ref arg-2 2))) (string-append "(%force " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-102) ")")))) ((23) (let ((e-105 (vector-ref arg-2 2))) (string-append "(%quote " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-105) ")")))) ((24) (let ((e-108 (vector-ref arg-2 2))) (string-append "(%quotename " (string-append (CoreC-45Name-u--show_Show_Name e-108) ")")))) ((25) (let ((e-111 (vector-ref arg-2 2))) (string-append "(%quotedecl " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpDeclC-39C-32C-36nmC-41 arg-1 u--d u--x)))) e-111) ")")))) ((26) (let ((e-114 (vector-ref arg-2 2))) (string-append "(%unquote " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-114) ")")))) ((27) (let ((e-118 (vector-ref arg-2 3))) (string-append "(%runelab " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-118) ")")))) ((28) (let ((e-121 (vector-ref arg-2 2))) (CoreC-45TTC-45Primitive-u--show_Show_Constant e-121))) ((30) (let ((e-124 (vector-ref arg-2 2))) (string-append "?" e-124))) ((31) (let ((e-127 (vector-ref arg-2 2))) (let ((e-128 (vector-ref arg-2 3))) (string-append "(%logging " (string-append (CoreC-45OptionsC-45Log-u--show_Show_LogLevel e-127) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-128) ")"))))))) ((29) "%type") ((32) (let ((e-133 (vector-ref arg-2 2))) (cond ((equal? e-133 1) "_") (else "?")))) (else (let ((e-136 (vector-ref arg-2 2))) (let ((e-137 (vector-ref arg-2 3))) (string-append "(%with " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-269 e-136) (string-append " " (string-append (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 e-137) ")"))))))))))
(define TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 (lambda (arg-1 arg-2 arg-3) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 arg-1 arg-3)))
(define csegen-835 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40RawImpC-39C-32C-36nmC-41 csegen-65 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40RawImpC-39C-32C-36nmC-41 csegen-65 u--d u--x)))))
(define csegen-838 (cons (lambda (u--x) (CoreC-45TTC-45Binder-u--show_Show_C-40PiInfoC-32C-36tC-41 csegen-835 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Binder-u--showPrec_Show_C-40PiInfoC-32C-36tC-41 csegen-835 u--d u--x)))))
(define csegen-839 (cons csegen-65 csegen-838))
(define PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-2) (if (null? arg-3) 1 0) (let ((e-2 (unbox arg-2))) (if (null? arg-3) 0 (let ((e-8 (unbox arg-3))) (let ((e-1 (car arg-1))) ((e-1 e-2) e-8))))))))
(define PreludeC-45Types-u--C-47C-61_Eq_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (let ((sc0 (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 arg-1 arg-2 arg-3))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-845 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 csegen-832 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45Types-u--C-47C-61_Eq_C-40MaybeC-32C-36aC-41 csegen-832 arg-686 arg-689)))))
(define LibrariesC-45DataC-45SortedSet-insert (lambda (arg-1 arg-2) (LibrariesC-45DataC-45SortedMap-insert arg-1 (vector 0 ) arg-2)))
(define csegen-846 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45DataC-45SortedSet-insert eta-0 eta-1))))
(define csegen-847 (lambda (eta-0) (lambda (eta-1) (PreludeC-45Basics-flip csegen-846 eta-0 eta-1))))
(define CoreC-45Name-u--C-60_Ord_Name (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Name-u--compare_Ord_Name arg-0 arg-1) 0)))
(define CoreC-45Name-u--C-62C-61_Ord_Name (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Name-u--compare_Ord_Name arg-0 arg-1) 0)))
(define CoreC-45Name-u--C-62_Ord_Name (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Name-u--compare_Ord_Name arg-0 arg-1) 2)))
(define CoreC-45Name-u--max_Ord_Name (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45Name-u--C-62_Ord_Name arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define CoreC-45Name-u--min_Ord_Name (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45Name-u--C-60_Ord_Name arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-861 (vector csegen-832 (lambda (arg-1566) (lambda (arg-1569) (CoreC-45Name-u--compare_Ord_Name arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (CoreC-45Name-u--C-60_Ord_Name arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (CoreC-45Name-u--C-62_Ord_Name arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (CoreC-45Name-u--C-60C-61_Ord_Name arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (CoreC-45Name-u--C-62C-61_Ord_Name arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (CoreC-45Name-u--max_Ord_Name arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (CoreC-45Name-u--min_Ord_Name arg-1626 arg-1629)))))
(define LibrariesC-45DataC-45SortedSet-empty (lambda (arg-1) (LibrariesC-45DataC-45SortedMap-empty arg-1)))
(define csegen-862 (LibrariesC-45DataC-45SortedSet-empty csegen-861))
(define CoreC-45Value-u--show_Show_C-40ClosureC-32C-36freeC-41 (lambda (arg-1) "[closure]"))
(define CoreC-45Value-u--showPrec_Show_C-40ClosureC-32C-36freeC-41 (lambda (arg-1 arg-2) (CoreC-45Value-u--show_Show_C-40ClosureC-32C-36freeC-41 arg-2)))
(define csegen-864 (cons (lambda (u--x) (CoreC-45Value-u--show_Show_C-40ClosureC-32C-36freeC-41 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45Value-u--showPrec_Show_C-40ClosureC-32C-36freeC-41 u--d u--x)))))
(define csegen-870 (lambda (eta-0) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-265 eta-0)))
(define PreludeC-45Show-u--showPrec_Show_Nat (lambda (arg-0 arg-1) (PreludeC-45Show-u--show_Show_Nat arg-1)))
(define csegen-895 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_Nat u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_Nat u--d u--x)))))
(define CoreC-45TTC-45Term-u--showPrec_Show_NameType (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) "Bound") ((1) "Func") ((2) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "DataCon" (string-append (PreludeC-45Show-showArg csegen-495 e-0) (PreludeC-45Show-showArg csegen-895 e-1)))))) (else (let ((e-2 (vector-ref arg-1 1))) (let ((e-3 (vector-ref arg-1 2))) (PreludeC-45Show-showCon arg-0 "TyCon" (string-append (PreludeC-45Show-showArg csegen-495 e-2) (PreludeC-45Show-showArg csegen-895 e-3)))))))))
(define CoreC-45TTC-45Term-u--show_Show_NameType (lambda (arg-0) (CoreC-45TTC-45Term-u--showPrec_Show_NameType (vector 0 ) arg-0)))
(define csegen-873 (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_NameType u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_NameType u--d u--x)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-comma (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-681 #\,))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-space (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-681 #\ ))
(define csegen-879 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-surround (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-comma LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-space) eta-0 eta-1))))
(define csegen-880 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-surround (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String " -> ") eta-0 eta-1))))
(define CoreC-45TTC-45Binder-n--2822-4445-u--go (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-3 0) ((0) (case (vector-ref arg-4 0) ((0) 1)(else 0))) ((1) (case (vector-ref arg-4 0) ((1) 1)(else 0))) ((2) (case (vector-ref arg-4 0) ((2) 1)(else 0))) ((3) (let ((e-4 (vector-ref arg-3 1))) (case (vector-ref arg-4 0) ((3) (let ((e-9 (vector-ref arg-4 1))) ((arg-2 e-4) e-9)))(else 0))))(else 0))))
(define CoreC-45TTC-45Binder-eqPiInfoBy (lambda (arg-2 ext-0 ext-1) (CoreC-45TTC-45Binder-n--2822-4445-u--go arg-2 ext-0 ext-1)))
(define CoreC-45TTC-45Binder-n--4944-6634-u--go (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-3 0) ((0) (let ((e-2 (vector-ref arg-3 2))) (let ((e-3 (vector-ref arg-3 3))) (let ((e-4 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((0) (let ((e-31 (vector-ref arg-4 2))) (let ((e-32 (vector-ref arg-4 3))) (let ((e-33 (vector-ref arg-4 4))) (let ((sc2 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-2 e-31))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45TTC-45Binder-eqPiInfoBy arg-2 e-3 e-32))) (cond ((equal? sc3 1) ((arg-2 e-4) e-33)) (else 0)))) (else 0)))))))(else 0)))))) ((1) (let ((e-7 (vector-ref arg-3 2))) (let ((e-8 (vector-ref arg-3 3))) (let ((e-9 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((1) (let ((e-36 (vector-ref arg-4 2))) (let ((e-37 (vector-ref arg-4 3))) (let ((e-38 (vector-ref arg-4 4))) (let ((sc2 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-7 e-36))) (cond ((equal? sc2 1) (let ((sc3 ((arg-2 e-8) e-37))) (cond ((equal? sc3 1) ((arg-2 e-9) e-38)) (else 0)))) (else 0)))))))(else 0)))))) ((2) (let ((e-12 (vector-ref arg-3 2))) (let ((e-13 (vector-ref arg-3 3))) (let ((e-14 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((2) (let ((e-41 (vector-ref arg-4 2))) (let ((e-42 (vector-ref arg-4 3))) (let ((e-43 (vector-ref arg-4 4))) (let ((sc2 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-12 e-41))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45TTC-45Binder-eqPiInfoBy arg-2 e-13 e-42))) (cond ((equal? sc3 1) ((arg-2 e-14) e-43)) (else 0)))) (else 0)))))))(else 0)))))) ((3) (let ((e-17 (vector-ref arg-3 2))) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((3) (let ((e-46 (vector-ref arg-4 2))) (let ((e-47 (vector-ref arg-4 3))) (let ((e-48 (vector-ref arg-4 4))) (let ((sc2 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-17 e-46))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45TTC-45Binder-eqPiInfoBy arg-2 e-18 e-47))) (cond ((equal? sc3 1) ((arg-2 e-19) e-48)) (else 0)))) (else 0)))))))(else 0)))))) ((4) (let ((e-22 (vector-ref arg-3 2))) (let ((e-23 (vector-ref arg-3 3))) (let ((e-24 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((4) (let ((e-51 (vector-ref arg-4 2))) (let ((e-52 (vector-ref arg-4 3))) (let ((e-53 (vector-ref arg-4 4))) (let ((sc2 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-22 e-51))) (cond ((equal? sc2 1) (let ((sc3 ((arg-2 e-23) e-52))) (cond ((equal? sc3 1) ((arg-2 e-24) e-53)) (else 0)))) (else 0)))))))(else 0)))))) ((5) (let ((e-27 (vector-ref arg-3 2))) (let ((e-28 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((5) (let ((e-56 (vector-ref arg-4 2))) (let ((e-57 (vector-ref arg-4 3))) (let ((sc2 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-27 e-56))) (cond ((equal? sc2 1) ((arg-2 e-28) e-57)) (else 0))))))(else 0)))))(else 0))))
(define CoreC-45TTC-45Binder-eqBinderBy (lambda (arg-2 ext-0 ext-1) (CoreC-45TTC-45Binder-n--4944-6634-u--go arg-2 ext-0 ext-1)))
(define CoreC-45TTC-45Term-eqWhyErasedBy (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-3 0) ((1) (case (vector-ref arg-4 0) ((1) 1)(else 0))) ((0) (case (vector-ref arg-4 0) ((0) 1)(else 0))) ((2) (let ((e-3 (vector-ref arg-3 1))) (case (vector-ref arg-4 0) ((2) (let ((e-7 (vector-ref arg-4 1))) ((arg-2 e-3) e-7)))(else 0))))(else 0))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Bits16 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Bits32 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Bits64 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Bits8 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Double (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Int16 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Int32 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Int64 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Int8 (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0))) ((equal? arg-0 3) (cond ((equal? arg-1 3) 1)(else 0))) ((equal? arg-0 4) (cond ((equal? arg-1 4) 1)(else 0))) ((equal? arg-0 5) (cond ((equal? arg-1 5) 1)(else 0))) ((equal? arg-0 6) (cond ((equal? arg-1 6) 1)(else 0))) ((equal? arg-0 7) (cond ((equal? arg-1 7) 1)(else 0))) ((equal? arg-0 8) (cond ((equal? arg-1 8) 1)(else 0))) ((equal? arg-0 9) (cond ((equal? arg-1 9) 1)(else 0))) ((equal? arg-0 10) (cond ((equal? arg-1 10) 1)(else 0))) ((equal? arg-0 11) (cond ((equal? arg-1 11) 1)(else 0))) ((equal? arg-0 12) (cond ((equal? arg-1 12) 1)(else 0))) ((equal? arg-0 13) (cond ((equal? arg-1 13) 1)(else 0)))(else 0))))
(define CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-14 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-0 e-14)))(else 0)))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-15 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int8 e-1 e-15)))(else 0)))) ((2) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((2) (let ((e-16 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int16 e-2 e-16)))(else 0)))) ((3) (let ((e-3 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((3) (let ((e-17 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int32 e-3 e-17)))(else 0)))) ((4) (let ((e-4 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((4) (let ((e-18 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int64 e-4 e-18)))(else 0)))) ((5) (let ((e-5 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((5) (let ((e-19 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer e-5 e-19)))(else 0)))) ((6) (let ((e-6 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((6) (let ((e-20 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits8 e-6 e-20)))(else 0)))) ((7) (let ((e-7 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((7) (let ((e-21 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits16 e-7 e-21)))(else 0)))) ((8) (let ((e-8 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-22 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits32 e-8 e-22)))(else 0)))) ((9) (let ((e-9 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((9) (let ((e-23 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits64 e-9 e-23)))(else 0)))) ((10) (let ((e-10 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((10) (let ((e-24 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-10 e-24)))(else 0)))) ((11) (let ((e-11 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((11) (let ((e-25 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char e-11 e-25)))(else 0)))) ((12) (let ((e-12 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((12) (let ((e-26 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Double e-12 e-26)))(else 0)))) ((13) (let ((e-13 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((13) (let ((e-27 (vector-ref arg-1 1))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-13 e-27)))(else 0)))) ((14) (case (vector-ref arg-1 0) ((14) 1)(else 0)))(else 0))))
(define DataC-45List-u--zipWith_Zippable_List (lambda (arg-3 arg-4 arg-5) (if (null? arg-4) '() (if (null? arg-5) '() (let ((e-1 (car arg-4))) (let ((e-2 (cdr arg-4))) (let ((e-4 (car arg-5))) (let ((e-5 (cdr arg-5))) (cons ((arg-3 e-1) e-4) (DataC-45List-u--zipWith_Zippable_List arg-3 e-2 e-5))))))))))
(define DataC-45List-u--zip_Zippable_List (lambda (ext-0 ext-1) (DataC-45List-u--zipWith_Zippable_List csegen-182 ext-0 ext-1)))
(define CoreC-45TTC-45Term-eqTerm (lambda (arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (let ((e-4 (vector-ref arg-2 3))) (case (vector-ref arg-3 0) ((0) (let ((e-55 (vector-ref arg-3 3))) (or (and (= e-4 e-55) 1) 0)))(else 0)))) ((1) (let ((e-9 (vector-ref arg-2 3))) (case (vector-ref arg-3 0) ((1) (let ((e-60 (vector-ref arg-3 3))) (CoreC-45Name-u--C-61C-61_Eq_Name e-9 e-60)))(else 0)))) ((2) (let ((e-13 (vector-ref arg-2 3))) (let ((e-14 (vector-ref arg-2 4))) (case (vector-ref arg-3 0) ((2) (let ((e-64 (vector-ref arg-3 3))) (let ((e-65 (vector-ref arg-3 4))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-13 e-64))) (cond ((equal? sc2 1) (PreludeC-45Types-u--foldMap_Foldable_List csegen-186 (lambda (eta-0) (PreludeC-45Basics-uncurry (csegen-896) eta-0)) (DataC-45List-u--zip_Zippable_List e-14 e-65))) (else 0))))))(else 0))))) ((3) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (case (vector-ref arg-3 0) ((3) (let ((e-69 (vector-ref arg-3 3))) (let ((e-70 (vector-ref arg-3 4))) (let ((sc2 (CoreC-45TTC-45Binder-eqBinderBy (csegen-896) e-18 e-69))) (cond ((equal? sc2 1) (CoreC-45TTC-45Term-eqTerm e-19 e-70)) (else 0))))))(else 0))))) ((4) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (case (vector-ref arg-3 0) ((4) (let ((e-73 (vector-ref arg-3 2))) (let ((e-74 (vector-ref arg-3 3))) (let ((sc2 (CoreC-45TTC-45Term-eqTerm e-22 e-73))) (cond ((equal? sc2 1) (CoreC-45TTC-45Term-eqTerm e-23 e-74)) (else 0))))))(else 0))))) ((5) (let ((e-27 (vector-ref arg-2 3))) (let ((e-28 (vector-ref arg-2 4))) (case (vector-ref arg-3 0) ((5) (let ((e-78 (vector-ref arg-3 3))) (let ((e-79 (vector-ref arg-3 4))) (let ((sc2 (CoreC-45TTC-45Term-eqTerm e-27 e-78))) (cond ((equal? sc2 1) (CoreC-45TTC-45Term-eqTerm e-28 e-79)) (else 0))))))(else 0))))) ((6) (let ((e-32 (vector-ref arg-2 3))) (case (vector-ref arg-3 0) ((6) (let ((e-83 (vector-ref arg-3 3))) (CoreC-45TTC-45Term-eqTerm e-32 e-83)))(else 0)))) ((7) (let ((e-36 (vector-ref arg-2 3))) (let ((e-37 (vector-ref arg-2 4))) (case (vector-ref arg-3 0) ((7) (let ((e-87 (vector-ref arg-3 3))) (let ((e-88 (vector-ref arg-3 4))) (let ((sc2 (CoreC-45TTC-45Term-eqTerm e-36 e-87))) (cond ((equal? sc2 1) (CoreC-45TTC-45Term-eqTerm e-37 e-88)) (else 0))))))(else 0))))) ((8) (let ((e-41 (vector-ref arg-2 3))) (case (vector-ref arg-3 0) ((8) (let ((e-92 (vector-ref arg-3 3))) (CoreC-45TTC-45Term-eqTerm e-41 e-92)))(else 0)))) ((9) (let ((e-44 (vector-ref arg-2 2))) (case (vector-ref arg-3 0) ((9) (let ((e-95 (vector-ref arg-3 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-44 e-95)))(else 0)))) ((10) (let ((e-47 (vector-ref arg-2 2))) (case (vector-ref arg-3 0) ((10) (let ((e-98 (vector-ref arg-3 2))) (CoreC-45TTC-45Term-eqWhyErasedBy (csegen-896) e-47 e-98)))(else 0)))) ((11) (case (vector-ref arg-3 0) ((11) 1)(else 0)))(else 0))))
(define csegen-896 (lambda () (lambda (eta-0) (lambda (eta-1) (CoreC-45TTC-45Term-eqTerm eta-0 eta-1)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-annotate (lambda (ext-0 ext-1) (vector 11 ext-0 ext-1)))
(define IdrisC-45PrettyC-45Annotations-keyword (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-annotate (vector 5 ) ext-0)))
(define csegen-921 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 ";")))
(define csegen-927 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "}")))
(define csegen-934 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-681 #\0)) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-space))
(define csegen-937 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-681 #\1)) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-space))
(define csegen-943 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "{")))
(define csegen-960 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "->")))
(define CoreC-45FC-u--showPrec_Show_OriginDesc (lambda (arg-0 arg-1) (CoreC-45FC-u--show_Show_OriginDesc arg-1)))
(define csegen-962 (cons (lambda (u--x) (CoreC-45FC-u--show_Show_OriginDesc u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45FC-u--showPrec_Show_OriginDesc u--d u--x)))))
(define csegen-965 (lambda (_-0) (box (+ _-0 1))))
(define CoreC-45TTC-45Var-nameAt (lambda (arg-2 arg-3) (let ((e-1 (car arg-2))) (let ((e-2 (cdr arg-2))) (cond ((equal? arg-3 0) e-1)(else (let ((e-3 (- arg-3 1))) (CoreC-45TTC-45Var-nameAt e-2 e-3))))))))
(define Algebra-showCount (lambda (ext-0) (AlgebraC-45Semiring-elimSemi csegen-931 "0 " "1 " (lambda (eta-0) "") ext-0)))
(define CoreC-45TTC-45Term-withPiInfo (lambda (arg-1 arg-2 arg-3) (case (vector-ref arg-2 0) ((1) (string-append "(" (string-append arg-3 ")"))) ((0) (string-append "{" (string-append arg-3 "}"))) ((2) (string-append "{auto " (string-append arg-3 "}"))) (else (let ((e-4 (vector-ref arg-2 1))) (string-append "{default " (string-append (let ((e-1 (car arg-1))) (e-1 e-4)) (string-append " " (string-append arg-3 "}")))))))))
(define CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 (lambda (arg-0 arg-1 arg-2) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-0 arg-2)))
(define CoreC-45TTC-45Term-n--8014-6017-u--showApp (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-3 0) ((0) (let ((e-5 (vector-ref arg-3 3))) (if (null? arg-4) (string-append (CoreC-45Name-u--show_Show_Name (CoreC-45TTC-45Var-nameAt arg-2 e-5)) (string-append "[" (string-append (PreludeC-45Show-u--show_Show_Nat e-5) "]"))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))) ((1) (let ((e-10 (vector-ref arg-3 3))) (if (null? arg-4) (CoreC-45Name-u--show_Show_Name e-10) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))) ((2) (let ((e-13 (vector-ref arg-3 2))) (let ((e-15 (vector-ref arg-3 4))) (if (null? arg-4) (string-append "?" (string-append (CoreC-45Name-u--show_Show_Name e-13) (string-append "_" (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 arg-2 u--d u--x)))) e-15)))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")"))))))))) ((3) (let ((e-18 (vector-ref arg-3 2))) (let ((e-19 (vector-ref arg-3 3))) (let ((e-20 (vector-ref arg-3 4))) (case (vector-ref e-19 0) ((0) (let ((e-57 (vector-ref e-19 2))) (let ((e-58 (vector-ref e-19 3))) (let ((e-59 (vector-ref e-19 4))) (if (null? arg-4) (string-append "\\" (string-append (CoreC-45TTC-45Term-withPiInfo (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 arg-2 u--d u--x)))) e-58 (string-append (Algebra-showCount e-57) (string-append (CoreC-45Name-u--show_Show_Name e-18) (string-append " : " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-59))))) (string-append " => " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (cons e-18 arg-2) e-20)))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))))) ((1) (let ((e-62 (vector-ref e-19 2))) (let ((e-63 (vector-ref e-19 3))) (let ((e-64 (vector-ref e-19 4))) (if (null? arg-4) (string-append "let " (string-append (Algebra-showCount e-62) (string-append (CoreC-45Name-u--show_Show_Name e-18) (string-append " : " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-64) (string-append " = " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-63) (string-append " in " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (cons e-18 arg-2) e-20))))))))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))))) ((2) (let ((e-67 (vector-ref e-19 2))) (let ((e-68 (vector-ref e-19 3))) (let ((e-69 (vector-ref e-19 4))) (if (null? arg-4) (string-append (CoreC-45TTC-45Term-withPiInfo (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 arg-2 u--d u--x)))) e-68 (string-append (Algebra-showCount e-67) (string-append (CoreC-45Name-u--show_Show_Name e-18) (string-append " : " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-69))))) (string-append " -> " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (cons e-18 arg-2) e-20))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))))) ((3) (let ((e-72 (vector-ref e-19 2))) (let ((e-73 (vector-ref e-19 3))) (let ((e-74 (vector-ref e-19 4))) (if (null? arg-4) (string-append (CoreC-45TTC-45Term-withPiInfo (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 arg-2 u--d u--x)))) e-73 (string-append "pat " (string-append (Algebra-showCount e-72) (string-append (CoreC-45Name-u--show_Show_Name e-18) (string-append " : " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-74)))))) (string-append " => " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (cons e-18 arg-2) e-20))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))))) ((4) (let ((e-77 (vector-ref e-19 2))) (let ((e-78 (vector-ref e-19 3))) (let ((e-79 (vector-ref e-19 4))) (if (null? arg-4) (string-append "plet " (string-append (Algebra-showCount e-77) (string-append (CoreC-45Name-u--show_Show_Name e-18) (string-append " : " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-79) (string-append " = " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-78) (string-append " in " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (cons e-18 arg-2) e-20))))))))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))))) ((5) (let ((e-82 (vector-ref e-19 2))) (let ((e-83 (vector-ref e-19 3))) (if (null? arg-4) (string-append "pty " (string-append (Algebra-showCount e-82) (string-append (CoreC-45Name-u--show_Show_Name e-18) (string-append " : " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-83) (string-append " => " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (cons e-18 arg-2) e-20))))))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))))(else (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")"))))))))))) ((4) (if (null? arg-4) "[can't happen]" (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")"))))))) ((5) (let ((e-28 (vector-ref arg-3 3))) (let ((e-29 (vector-ref arg-3 4))) (if (null? arg-4) (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-28) (string-append "@" (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-29))) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")"))))))))) ((6) (let ((e-33 (vector-ref arg-3 3))) (if (null? arg-4) (string-append "%Delayed " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-33)) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))) ((7) (let ((e-38 (vector-ref arg-3 4))) (if (null? arg-4) (string-append "%Delay " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-38)) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))) ((8) (let ((e-42 (vector-ref arg-3 3))) (if (null? arg-4) (string-append "%Force " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-42)) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))) ((9) (let ((e-45 (vector-ref arg-3 2))) (if (null? arg-4) (CoreC-45TTC-45Primitive-u--show_Show_Constant e-45) (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))) ((10) (let ((e-48 (vector-ref arg-3 2))) (case (vector-ref e-48 0) ((2) (let ((e-98 (vector-ref e-48 1))) (if (null? arg-4) (string-append ".(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 e-98) ")")) (if (null? arg-4) "[__]" (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))))(else (if (null? arg-4) "[__]" (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))))) ((11) (if (null? arg-4) "Type" (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))(else (if (null? arg-4) "???" (string-append "(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 arg-3) (string-append " " (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-2 eta-0)) arg-4)) ")")))))))))
(define CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45TTC-45Term-getFnArgs arg-1))) (let ((e-2 (car sc0))) (let ((e-3 (cdr sc0))) (CoreC-45TTC-45Term-n--8014-6017-u--showApp arg-0 arg-1 arg-0 e-2 e-3))))))
(define csegen-969 (lambda (eta-0) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 '() eta-0)))
(define PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2) (PreludeC-45Show-u--showPrec_Show_C-40MaybeC-32C-36aC-41 arg-1 (vector 0 ) arg-2)))
(define csegen-972 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 csegen-65 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40MaybeC-32C-36aC-41 csegen-65 u--d u--x)))))
(define CoreC-45Name-displayUserName (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) e-0)) ((1) (let ((e-1 (vector-ref arg-0 1))) e-1)) (else "_"))))
(define CoreC-45Name-nameRoot (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-1 (vector-ref arg-0 2))) (CoreC-45Name-nameRoot e-1))) ((1) (let ((e-2 (vector-ref arg-0 1))) (CoreC-45Name-displayUserName e-2))) ((2) (let ((e-3 (vector-ref arg-0 1))) e-3)) ((3) (let ((e-5 (vector-ref arg-0 1))) (CoreC-45Name-nameRoot e-5))) ((4) (let ((e-8 (vector-ref arg-0 2))) (CoreC-45Name-nameRoot e-8))) ((5) (let ((e-10 (vector-ref arg-0 2))) (CoreC-45Name-nameRoot e-10))) ((6) (let ((e-11 (vector-ref arg-0 1))) (string-append "$" (PreludeC-45Show-u--show_Show_String e-11)))) ((7) (let ((e-13 (vector-ref arg-0 1))) (string-append "$" (PreludeC-45Show-u--show_Show_String e-13)))) (else (let ((e-15 (vector-ref arg-0 1))) (string-append "$" (PreludeC-45Show-u--show_Show_Int e-15)))))))
(define DataC-45List1-u--show_Show_C-40List1C-32C-36aC-41 (lambda (arg-1 ext-0) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 arg-1 (DataC-45List1-forget ext-0))))
(define CoreC-45Core-u--show_Show_DotReason (lambda (arg-0) (cond ((equal? arg-0 0) "Non linear pattern variable") ((equal? arg-0 1) "Variable applied to arguments") ((equal? arg-0 2) "Not a constructor application or primitive") ((equal? arg-0 3) "Erased argument") ((equal? arg-0 4) "User dotted") ((equal? arg-0 5) "Unknown reason") (else "Under-applied constructor"))))
(define PrimIO-unsafeCreateWorld (lambda (arg-1) (arg-1 #f)))
(define PrimIO-unsafePerformIO (lambda (arg-1) (PrimIO-unsafeCreateWorld (lambda (u--w) (let ((eff-0 (arg-1 u--w))) eff-0)))))
(define SystemC-45Errno-strerror (lambda (arg-0) (PrimIO-unsafePerformIO (lambda (eta-0) (SystemC-45Errno-prim__strerror arg-0 eta-0)))))
(define SystemC-45FileC-45Error-u--show_Show_FileError (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (SystemC-45Errno-strerror e-0))) ((1) "File Read Error") ((2) "File Write Error") ((3) "File Not Found") ((4) "Permission Denied") (else "File Exists"))))
(define CoreC-45Core-u--show_Show_TTCErrorMsg (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (let ((u--age (let ((sc1 (PreludeC-45EqOrd-u--C-60_Ord_Int e-1 e-2))) (cond ((equal? sc1 1) "older") (else "newer"))))) (string-append "TTC data is in an " (string-append u--age (string-append " format, file: " (string-append e-0 (string-append ", expected version: " (string-append (PreludeC-45Show-u--show_Show_Int e-2) (string-append ", actual version: " (PreludeC-45Show-u--show_Show_Int e-1))))))))))))) ((1) (let ((e-3 (vector-ref arg-0 1))) (string-append "End of buffer when reading " e-3))) (else (let ((e-4 (vector-ref arg-0 1))) (string-append "Corrupt TTC data for " e-4))))))
(define CoreC-45TT-u--show_Show_Visibility (lambda (arg-0) (cond ((equal? arg-0 0) "private") ((equal? arg-0 1) "export") (else "public export"))))
(define CoreC-45Core-u--show_Show_Warning (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-0) e-1)))) ((1) (let ((e-3 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-3) ":Unreachable clause"))) ((2) (let ((e-6 (vector-ref arg-0 1))) (string-append (CoreC-45FC-u--show_Show_FC e-6) ":Shadowing names"))) ((3) (let ((e-8 (vector-ref arg-0 1))) (string-append (CoreC-45FC-u--show_Show_FC e-8) ":Incompatible Visibility"))) ((4) (let ((e-12 (vector-ref arg-0 1))) (string-append (CoreC-45FC-u--show_Show_FC e-12) ":Shadowing names"))) ((5) (let ((e-14 (vector-ref arg-0 1))) (let ((e-15 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-14) (string-append ":Deprecated " e-15))))) (else (let ((e-17 (vector-ref arg-0 1))) (let ((e-18 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-17) e-18)))))))
(define CoreC-45Core-n--8799-7358-u--showRel (lambda (arg-0 arg-1 arg-2 arg-3 ext-0) (AlgebraC-45Semiring-elimSemi csegen-931 "irrelevant" "relevant" (lambda (eta-0) "non-linear") ext-0)))
(define CoreC-45Core-n--8799-7359-u--showRig (lambda (arg-0 arg-1 arg-2 arg-3 ext-0) (AlgebraC-45Semiring-elimSemi csegen-931 "irrelevant" "linear" (lambda (eta-0) "unrestricted") ext-0)))
(define csegen-975 (lambda () (cons csegen-972 (csegen-974))))
(define PreludeC-45Show-u--showPrec_Show_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 arg-1 arg-3)))
(define csegen-981 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-493 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40ListC-32C-36aC-41 csegen-493 u--d u--x)))))
(define csegen-982 (cons csegen-264 csegen-493))
(define CoreC-45Core-u--show_Show_Error (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (CoreC-45Core-u--show_Show_Error e-0))) ((1) (let ((e-1 (vector-ref arg-0 1))) (let ((e-2 (vector-ref arg-0 2))) (let ((e-5 (vector-ref arg-0 5))) (let ((e-6 (vector-ref arg-0 6))) (string-append (CoreC-45FC-u--show_Show_FC e-2) (string-append ":Type mismatch: " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-1 e-5) (string-append " and " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-1 e-6)))))))))) ((2) (let ((e-7 (vector-ref arg-0 1))) (let ((e-8 (vector-ref arg-0 2))) (let ((e-11 (vector-ref arg-0 5))) (let ((e-12 (vector-ref arg-0 6))) (string-append (CoreC-45FC-u--show_Show_FC e-8) (string-append ":" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-7 e-11) (string-append " and " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-7 e-12) " are not equal")))))))))) ((3) (let ((e-13 (vector-ref arg-0 1))) (let ((e-14 (vector-ref arg-0 2))) (let ((e-17 (vector-ref arg-0 5))) (let ((e-18 (vector-ref arg-0 6))) (string-append (CoreC-45FC-u--show_Show_FC e-14) (string-append ":Pattern variable " (string-append (CoreC-45Name-u--show_Show_Name e-17) (string-append " unifies with " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-13 e-18)))))))))) ((4) (let ((e-19 (vector-ref arg-0 1))) (let ((e-20 (vector-ref arg-0 2))) (let ((e-22 (vector-ref arg-0 4))) (let ((e-23 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-20) (string-append ":Cycle detected in metavariable solution " (string-append (CoreC-45Name-u--show_Show_Name e-22) (string-append " = " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-19 e-23)))))))))) ((5) (let ((e-24 (vector-ref arg-0 1))) (let ((e-25 (vector-ref arg-0 2))) (let ((e-28 (vector-ref arg-0 5))) (let ((e-29 (vector-ref arg-0 6))) (let ((e-30 (vector-ref arg-0 7))) (string-append (CoreC-45FC-u--show_Show_FC e-25) (string-append ":When unifying: " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-24 e-28) (string-append " and " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-24 e-29) (string-append "\xa;\x9;" (CoreC-45Core-u--show_Show_Error e-30))))))))))))) ((6) (let ((e-31 (vector-ref arg-0 1))) (let ((e-32 (vector-ref arg-0 2))) (let ((e-34 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-32) (string-append ":" (case (vector-ref e-34 0) ((0) (let ((e-2 (vector-ref e-34 1))) (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-31 e-2) " is not a valid impossible pattern because it typechecks"))) (else (let ((e-5 (vector-ref e-34 1))) (string-append "Not a valid impossible pattern:\xa;\x9;" (CoreC-45Core-u--show_Show_Error e-5))))))))))) ((7) (let ((e-35 (vector-ref arg-0 1))) (let ((e-36 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-35) (string-append ":Undefined name " (CoreC-45Name-u--show_Show_Name e-36)))))) ((8) (let ((e-37 (vector-ref arg-0 1))) (let ((e-38 (vector-ref arg-0 2))) (let ((e-39 (vector-ref arg-0 3))) (if (null? e-39) (string-append (CoreC-45FC-u--show_Show_FC e-37) (string-append ":Name " (string-append (CoreC-45Name-u--show_Show_Name e-38) " is private"))) (let ((e-221 (unbox e-39))) (string-append (CoreC-45FC-u--show_Show_FC e-37) (string-append ":Name " (string-append (CoreC-45Name-u--show_Show_Name e-38) (string-append " is inaccessible since " (string-append (CoreC-45NameC-45Namespace-u--show_Show_Namespace e-221) " is not explicitly imported"))))))))))) ((9) (let ((e-40 (vector-ref arg-0 1))) (let ((e-41 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-40) (string-append ":Return type of " (string-append (CoreC-45Name-u--show_Show_Name e-41) " must be Type")))))) ((10) (let ((e-42 (vector-ref arg-0 1))) (let ((e-43 (vector-ref arg-0 2))) (let ((e-44 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-42) (string-append ":Return type of " (string-append (CoreC-45Name-u--show_Show_Name e-43) (string-append " must be in " (CoreC-45Name-u--show_Show_Name e-44))))))))) ((11) (let ((e-45 (vector-ref arg-0 1))) (let ((e-46 (vector-ref arg-0 2))) (let ((e-47 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-45) (string-append ":" (string-append (CoreC-45Name-u--show_Show_Name e-46) (string-append " is not covering:\xa;\x9;" (case (vector-ref e-47 0) ((0) "Oh yes it is (Internal error!)") ((1) (let ((e-0 (vector-ref e-47 1))) (string-append "Missing cases:\xa;\x9;" (CoreC-45NameC-45Namespace-showSep "\xa;\x9;" (PreludeC-45TypesC-45List-mapAppend '() csegen-969 e-0))))) (else (let ((e-1 (vector-ref e-47 1))) (string-append "Calls non covering function" (if (null? e-1) (string-append "s: " (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45Name-u--show_Show_Name eta-0)) e-1))) (let ((e-3 (car e-1))) (let ((e-2 (cdr e-1))) (if (null? e-2) (string-append " " (CoreC-45Name-u--show_Show_Name e-3)) (string-append "s: " (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45Name-u--show_Show_Name eta-0)) e-1))))))))))))))))))) ((12) (let ((e-48 (vector-ref arg-0 1))) (let ((e-49 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-48) (string-append ":" (string-append (CoreC-45Name-u--show_Show_Name e-49) " is not total")))))) ((13) (let ((e-51 (vector-ref arg-0 1))) (let ((e-52 (vector-ref arg-0 2))) (let ((e-53 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-51) (string-append ":There are " (string-append (PreludeC-45Show-u--show_Show_Nat e-52) (string-append " uses of linear name " (CoreC-45Name-u--show_Show_Name e-53))))))))) ((14) (let ((e-54 (vector-ref arg-0 1))) (let ((e-55 (vector-ref arg-0 2))) (let ((e-56 (vector-ref arg-0 3))) (let ((e-57 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-54) (string-append ":Trying to use " (string-append (CoreC-45Core-n--8799-7359-u--showRig e-57 e-56 e-55 e-54 e-56) (string-append " name " (string-append (CoreC-45Name-u--show_Show_Name e-55) (string-append " in " (string-append (CoreC-45Core-n--8799-7358-u--showRel e-57 e-56 e-55 e-54 e-57) " context")))))))))))) ((15) (let ((e-58 (vector-ref arg-0 1))) (let ((e-59 (vector-ref arg-0 2))) (let ((e-61 (vector-ref arg-0 4))) (let ((e-62 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-59) (string-append ":" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-58 e-61) (string-append " borrows argument " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-58 e-62) " so must be fully applied")))))))))) ((16) (let ((e-63 (vector-ref arg-0 1))) (let ((e-64 (vector-ref arg-0 2))) (let ((e-66 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-64) (string-append ":" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-63 e-66) " borrows, so must return a concrete type"))))))) ((17) (let ((e-67 (vector-ref arg-0 1))) (let ((e-68 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-67) (string-append ":Ambiguous name " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-65 e-68)))))) ((18) (let ((e-69 (vector-ref arg-0 1))) (let ((e-70 (vector-ref arg-0 2))) (let ((e-72 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-70) (string-append ":Ambiguous elaboration " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-69 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 e-69 u--d u--x)))) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (Builtin-snd eta-0)) e-72)))))))) ((19) (let ((e-73 (vector-ref arg-0 1))) (let ((e-74 (vector-ref arg-0 2))) (let ((e-77 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-74) (string-append ":Ambiguous search " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-73 u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 e-73 u--d u--x)))) e-77))))))) ((20) (let ((e-78 (vector-ref arg-0 1))) (let ((e-79 (vector-ref arg-0 2))) (let ((e-80 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-78) (string-append ":Ambiguity too deep in " (string-append (CoreC-45Name-u--show_Show_Name e-79) (string-append " " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-65 e-80))))))))) ((21) (let ((e-81 (vector-ref arg-0 1))) (string-append "No successful elaboration: " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-975) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-975) u--d u--x)))) e-81)))) ((22) (let ((e-83 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-83) ":Can't infer type of record to update"))) ((23) (let ((e-85 (vector-ref arg-0 1))) (let ((e-86 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-85) (string-append ":Duplicated record update paths: " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-981 e-86)))))) ((24) (let ((e-87 (vector-ref arg-0 1))) (let ((e-88 (vector-ref arg-0 2))) (let ((e-89 (vector-ref arg-0 3))) (if (null? e-89) (string-append (CoreC-45FC-u--show_Show_FC e-87) (string-append ":" (string-append e-88 " is not part of a record type"))) (let ((e-224 (unbox e-89))) (string-append (CoreC-45FC-u--show_Show_FC e-87) (string-append ":Record type " (string-append (CoreC-45Name-u--show_Show_Name e-224) (string-append " has no field " e-88)))))))))) ((25) (let ((e-90 (vector-ref arg-0 1))) (let ((e-91 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-90) (string-append ":" (string-append (CoreC-45Name-u--show_Show_Name e-91) " is not a record type")))))) ((26) (let ((e-92 (vector-ref arg-0 1))) (let ((e-93 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-92) (string-append ":Field update " (string-append (CoreC-45NameC-45Namespace-showSep "->" e-93) " not compatible with other updates")))))) ((27) (let ((e-94 (vector-ref arg-0 1))) (let ((e-95 (vector-ref arg-0 2))) (let ((e-97 (vector-ref arg-0 4))) (let ((e-98 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-95) (string-append ":" (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-65 e-97) (string-append " are not valid arguments in " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-94 e-98)))))))))) ((28) (let ((e-99 (vector-ref arg-0 1))) (let ((e-100 (vector-ref arg-0 2))) (let ((e-102 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-100) (string-append ":Need to bind implicits " (string-append (CoreC-45NameC-45Namespace-showSep "," (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--x) (string-append (CoreC-45Name-u--show_Show_Name (Builtin-fst u--x)) (string-append " : " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-99 (Builtin-snd u--x))))) e-102)) "\xa;(The front end should probably have done this for you. Please report!)"))))))) ((29) (let ((e-103 (vector-ref arg-0 1))) (let ((e-104 (vector-ref arg-0 2))) (let ((e-106 (vector-ref arg-0 4))) (let ((e-107 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-104) (string-append ":Can't bind name " (string-append (CoreC-45Name-nameRoot e-106) (string-append " with type " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-103 e-107)))))))))) ((30) (let ((e-108 (vector-ref arg-0 1))) (let ((e-109 (vector-ref arg-0 2))) (let ((e-112 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-109) (string-append ":Can't solve goal " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-108 e-112))))))) ((31) (let ((e-114 (vector-ref arg-0 1))) (let ((e-115 (vector-ref arg-0 2))) (let ((e-116 (vector-ref arg-0 3))) (let ((e-119 (vector-ref arg-0 6))) (string-append (CoreC-45FC-u--show_Show_FC e-115) (string-append ":Can't solve goal " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-114 e-119) (string-append " since argument " (string-append (CoreC-45Name-u--show_Show_Name e-116) " can't be inferred")))))))))) ((32) (let ((e-120 (vector-ref arg-0 1))) (string-append "Unsolved holes " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-269 e-120)))) ((33) (let ((e-121 (vector-ref arg-0 1))) (let ((e-122 (vector-ref arg-0 2))) (let ((e-124 (vector-ref arg-0 4))) (let ((e-125 (vector-ref arg-0 5))) (let ((e-126 (vector-ref arg-0 6))) (string-append (CoreC-45FC-u--show_Show_FC e-122) (string-append ":Can't infer type for " (string-append (CoreC-45Name-u--show_Show_Name e-124) (string-append " (got " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-121 e-126) (string-append " with hole " (string-append (CoreC-45Name-u--show_Show_Name e-125) ")"))))))))))))) ((34) (let ((e-128 (vector-ref arg-0 2))) (let ((e-130 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-128) (string-append ":Named hole " (string-append (CoreC-45Name-u--show_Show_Name e-130) " is solved by unification")))))) ((35) (let ((e-132 (vector-ref arg-0 1))) (let ((e-133 (vector-ref arg-0 2))) (let ((e-134 (vector-ref arg-0 3))) (let ((e-135 (vector-ref arg-0 4))) (let ((e-136 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-132) (string-append ":" (string-append (CoreC-45TT-u--show_Show_Visibility e-133) (string-append " " (string-append (CoreC-45Name-u--show_Show_Name e-134) (string-append " cannot refer to " (string-append (CoreC-45TT-u--show_Show_Visibility e-135) (string-append " " (CoreC-45Name-u--show_Show_Name e-136))))))))))))))) ((36) (let ((e-137 (vector-ref arg-0 1))) (let ((e-138 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-137) (string-append ":Non linear pattern variable " (CoreC-45Name-u--show_Show_Name e-138)))))) ((37) (let ((e-139 (vector-ref arg-0 1))) (let ((e-140 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-139) (string-append ":Pattern not allowed here: " (CoreC-45Name-u--show_Show_Name e-140)))))) ((38) (let ((e-141 (vector-ref arg-0 1))) (let ((e-142 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-141) (string-append ":No type declaration for " (CoreC-45Name-u--show_Show_Name e-142)))))) ((39) (let ((e-143 (vector-ref arg-0 1))) (let ((e-144 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-143) (string-append ":" (string-append (CoreC-45Name-u--show_Show_Name e-144) " is already defined")))))) ((40) (let ((e-145 (vector-ref arg-0 1))) (let ((e-146 (vector-ref arg-0 2))) (let ((e-148 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-146) (string-append ":Not a function type: " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-145 e-148))))))) ((41) (let ((e-149 (vector-ref arg-0 1))) (let ((e-150 (vector-ref arg-0 2))) (let ((e-152 (vector-ref arg-0 4))) (let ((e-153 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-150) (string-append ":Rewriting by " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-149 e-152) (string-append " did not change type " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-149 e-153)))))))))) ((42) (let ((e-154 (vector-ref arg-0 1))) (let ((e-155 (vector-ref arg-0 2))) (let ((e-157 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-155) (string-append ":" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-154 e-157) " is not a rewrite rule type"))))))) ((43) (let ((e-158 (vector-ref arg-0 1))) (let ((e-159 (vector-ref arg-0 2))) (let ((e-160 (vector-ref arg-0 3))) (case (vector-ref e-160 0) ((0) (string-append (CoreC-45FC-u--show_Show_FC e-158) (string-append ":Patterns for " (string-append (CoreC-45Name-u--show_Show_Name e-159) " have different numbers of arguments")))) ((1) (string-append (CoreC-45FC-u--show_Show_FC e-158) (string-append ":Patterns for " (string-append (CoreC-45Name-u--show_Show_Name e-159) " require matching on different types")))) ((4) (string-append (CoreC-45FC-u--show_Show_FC e-158) (string-append ":Can't infer type to match in " (CoreC-45Name-u--show_Show_Name e-159)))) ((2) (let ((e-225 (vector-ref e-160 1))) (let ((e-229 (car e-225))) (let ((e-230 (cdr e-225))) (let ((e-234 (cdr e-230))) (string-append (CoreC-45FC-u--show_Show_FC e-158) (string-append ":Attempt to match on erased argument " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-229 e-234) (string-append " in " (CoreC-45Name-u--show_Show_Name e-159)))))))))) (else (let ((e-226 (vector-ref e-160 1))) (string-append (CoreC-45FC-u--show_Show_FC e-158) (string-append ":Constructor " (string-append (CoreC-45Name-u--show_Show_Name e-226) " is not fully applied")))))))))) ((44) (let ((e-161 (vector-ref arg-0 1))) (let ((e-162 (vector-ref arg-0 2))) (let ((e-164 (vector-ref arg-0 4))) (string-append (CoreC-45FC-u--show_Show_FC e-162) (string-append ":Can't match on " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-161 e-164) " as it is has a polymorphic type"))))))) ((45) (let ((e-165 (vector-ref arg-0 1))) (let ((e-166 (vector-ref arg-0 2))) (let ((e-168 (vector-ref arg-0 4))) (let ((e-169 (vector-ref arg-0 5))) (let ((e-170 (vector-ref arg-0 6))) (string-append (CoreC-45FC-u--show_Show_FC e-166) (string-append ":Can't match on " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-165 e-169) (string-append " (" (string-append (CoreC-45Core-u--show_Show_DotReason e-168) (string-append ")" (string-append " - it elaborates to " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-165 e-170)))))))))))))) ((46) (let ((e-171 (vector-ref arg-0 1))) (let ((e-172 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-171) (string-append ":" (string-append e-172 " can't be bound here")))))) ((47) (let ((e-173 (vector-ref arg-0 1))) (let ((e-174 (vector-ref arg-0 2))) (let ((e-176 (vector-ref arg-0 4))) (let ((e-177 (vector-ref arg-0 5))) (string-append (CoreC-45FC-u--show_Show_FC e-174) (string-append ":Bad elaborator script " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 e-173 e-176) (string-append " (" (string-append e-177 ")")))))))))) ((48) (let ((e-178 (vector-ref arg-0 1))) (string-append "Error during reflection: " (CoreC-45Core-u--show_Show_Error e-178)))) ((49) (let ((e-179 (vector-ref arg-0 1))) (let ((e-180 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-179) (string-append ":" e-180))))) ((50) (let ((e-181 (vector-ref arg-0 1))) (string-append "Error in TTC file: " (CoreC-45Core-u--show_Show_TTCErrorMsg e-181)))) ((51) (let ((e-182 (vector-ref arg-0 1))) (let ((e-183 (vector-ref arg-0 2))) (string-append "File error (" (string-append e-182 (string-append "): " (SystemC-45FileC-45Error-u--show_Show_FileError e-183))))))) ((52) (let ((e-184 (vector-ref arg-0 1))) (string-append "Can't find package " e-184))) ((53) "Implicit lazy functions are not yet supported") ((54) "Defining lazy functions via pattern matching is not yet supported") ((55) (let ((e-187 (vector-ref arg-0 1))) (string-append (CoreC-45FC-u--show_Show_FC e-187) ":Can't parse literate"))) ((56) (let ((e-188 (vector-ref arg-0 1))) (let ((e-189 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-188) (string-append ":Lexer error (" (string-append (PreludeC-45Show-u--show_Show_String e-189) ")")))))) ((57) (let ((e-190 (vector-ref arg-0 1))) (string-append "Parse errors (" (string-append (DataC-45List1-u--show_Show_C-40List1C-32C-36aC-41 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-982 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-982 u--d u--x)))) e-190) ")")))) ((58) (let ((e-191 (vector-ref arg-0 1))) (let ((e-192 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-191) (string-append ":" (string-append (CoreC-45NameC-45Namespace-u--show_Show_ModuleIdent e-192) " not found")))))) ((59) (let ((e-193 (vector-ref arg-0 1))) (string-append "Module imports form a cycle: " (CoreC-45NameC-45Namespace-showSep " -> " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45NameC-45Namespace-u--show_Show_ModuleIdent eta-0)) e-193))))) ((60) "Internal error when resolving implicit laziness") ((61) (let ((e-194 (vector-ref arg-0 1))) (string-append "INTERNAL ERROR: " e-194))) ((62) (let ((e-195 (vector-ref arg-0 1))) (string-append "Error: " e-195))) ((63) (let ((e-196 (vector-ref arg-0 1))) (let ((e-197 (vector-ref arg-0 2))) (string-append (CoreC-45FC-u--show_Show_FC e-196) (string-append ":The given specifier " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-493 e-197) " was not accepted by any available backend.")))))) ((64) (let ((e-199 (vector-ref arg-0 2))) (string-append "Invalid multiline string: " e-199))) ((65) (let ((e-200 (vector-ref arg-0 1))) (string-append "Timeout in " e-200))) ((66) "Failing block did not fail") ((67) (let ((e-202 (vector-ref arg-0 1))) (let ((e-203 (vector-ref arg-0 2))) (let ((e-204 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-202) (string-append ":Failing block failed with the wrong error:\xa;" (string-append "Expected: " (string-append e-203 (string-append "\xa;" (string-append "but got: " (DataC-45List1-u--show_Show_C-40List1C-32C-36aC-41 (csegen-974) e-204))))))))))) ((68) (let ((e-205 (vector-ref arg-0 1))) (let ((e-206 (vector-ref arg-0 2))) (let ((e-207 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-205) (string-append ":When elaborating type of " (string-append (CoreC-45Name-u--show_Show_Name e-206) (string-append ":\xa;" (CoreC-45Core-u--show_Show_Error e-207))))))))) ((69) (let ((e-208 (vector-ref arg-0 1))) (let ((e-209 (vector-ref arg-0 2))) (let ((e-210 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-208) (string-append ":When elaborating type of constructor " (string-append (CoreC-45Name-u--show_Show_Name e-209) (string-append ":\xa;" (CoreC-45Core-u--show_Show_Error e-210))))))))) ((70) (let ((e-211 (vector-ref arg-0 1))) (let ((e-212 (vector-ref arg-0 2))) (let ((e-213 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-211) (string-append ":When elaborating left hand side of " (string-append (CoreC-45Name-u--show_Show_Name e-212) (string-append ":\xa;" (CoreC-45Core-u--show_Show_Error e-213))))))))) ((71) (let ((e-214 (vector-ref arg-0 1))) (let ((e-215 (vector-ref arg-0 2))) (let ((e-216 (vector-ref arg-0 3))) (string-append (CoreC-45FC-u--show_Show_FC e-214) (string-append ":When elaborating right hand side of " (string-append (CoreC-45Name-u--show_Show_Name e-215) (string-append ":\xa;" (CoreC-45Core-u--show_Show_Error e-216))))))))) ((72) (let ((e-217 (vector-ref arg-0 1))) (let ((e-218 (vector-ref arg-0 2))) (string-append (CoreC-45Core-u--show_Show_Error e-217) (string-append "\xa;Did you mean" (if (null? e-218) (string-append " any of: " (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Show-u--show_Show_String eta-0)) (DataC-45List1-forget e-218))) "?")) (let ((e-1 (car e-218))) (let ((e-2 (cdr e-218))) (if (null? e-2) (string-append ": " (string-append e-1 "?")) (string-append " any of: " (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Show-u--show_Show_String eta-0)) (DataC-45List1-forget e-218))) "?"))))))))))) (else (let ((e-219 (vector-ref arg-0 1))) (CoreC-45Core-u--show_Show_Warning e-219))))))
(define CoreC-45Core-u--showPrec_Show_Error (lambda (arg-0 arg-1) (CoreC-45Core-u--show_Show_Error arg-1)))
(define csegen-974 (lambda () (cons (lambda (u--x) (CoreC-45Core-u--show_Show_Error u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45Core-u--showPrec_Show_Error u--d u--x))))))
(define csegen-988 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (lambda (eta-1) (cons e-5 eta-1))))))))
(define CoreC-45CoreC-45Functor-u--map_Functor_CORECore (lambda (ext-2 ext-1 ext-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (ext-2 e-5)))))) ext-1 ext-0)))
(define csegen-993 (lambda (u--b) (lambda (u--a) (lambda (u--func) (lambda (arg-8885) (lambda (eta-0) (CoreC-45CoreC-45Functor-u--map_Functor_CORECore u--func arg-8885 eta-0)))))))
(define CoreC-45CoreC-45Applicative-u--C-60C-42C-62_Applicative_CORECore (lambda (ext-2 ext-1 ext-0) (CoreC-45Core-C-60C-42C-62 ext-2 ext-1 ext-0)))
(define CoreC-45CoreC-45Applicative-u--pure_Applicative_CORECore (lambda (ext-0 ext-1) (vector 1 ext-0)))
(define csegen-999 (vector csegen-993 (lambda (u--a) (lambda (arg-9931) (lambda (eta-0) (CoreC-45CoreC-45Applicative-u--pure_Applicative_CORECore arg-9931 eta-0)))) (lambda (u--b) (lambda (u--a) (lambda (arg-9937) (lambda (arg-9944) (lambda (eta-0) (CoreC-45CoreC-45Applicative-u--C-60C-42C-62_Applicative_CORECore arg-9937 arg-9944 eta-0))))))))
(define CoreC-45CoreC-45Monad-u--C-62C-62C-61_Monad_CORECore (lambda (ext-2 ext-1 ext-0) (let ((act-1 (ext-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (ext-1 e-5))) eff-0) ext-0)))))))
(define CoreC-45CoreC-45Monad-u--join_Monad_CORECore (lambda (arg-1 ext-0) (let ((act-1 (arg-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) (e-5 ext-0)))))))
(define csegen-1005 (vector csegen-999 (lambda (u--b) (lambda (u--a) (lambda (arg-10411) (lambda (arg-10414) (lambda (eta-0) (CoreC-45CoreC-45Monad-u--C-62C-62C-61_Monad_CORECore arg-10411 arg-10414 eta-0)))))) (lambda (u--a) (lambda (arg-10425) (lambda (eta-0) (CoreC-45CoreC-45Monad-u--join_Monad_CORECore arg-10425 eta-0))))))
(define csegen-1007 (lambda (eta-0) (cons CoreC-45FC-emptyFC (Builtin-snd eta-0))))
(define AlgebraC-45SizeChange-u--show_Show_SizeChange (lambda (arg-0) (cond ((equal? arg-0 0) "Smaller") ((equal? arg-0 1) "Same") (else "Unknown"))))
(define AlgebraC-45SizeChange-u--showPrec_Show_SizeChange (lambda (arg-0 arg-1) (AlgebraC-45SizeChange-u--show_Show_SizeChange arg-1)))
(define csegen-1012 (cons csegen-895 (cons (lambda (u--x) (AlgebraC-45SizeChange-u--show_Show_SizeChange u--x)) (lambda (u--d) (lambda (u--x) (AlgebraC-45SizeChange-u--showPrec_Show_SizeChange u--d u--x))))))
(define csegen-1015 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1012 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1012 u--d u--x)))))
(define DataC-45List1-u--showPrec_Show_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (DataC-45List1-u--show_Show_C-40List1C-32C-36aC-41 arg-1 arg-3)))
(define csegen-1019 (cons csegen-895 (cons (lambda (u--x) (DataC-45List1-u--show_Show_C-40List1C-32C-36aC-41 csegen-1015 u--x)) (lambda (u--d) (lambda (u--x) (DataC-45List1-u--showPrec_Show_C-40List1C-32C-36aC-41 csegen-1015 u--d u--x))))))
(define PreludeC-45Show-u--showPrec_Show_Bool (lambda (arg-0 arg-1) (PreludeC-45Show-u--show_Show_Bool arg-1)))
(define csegen-1024 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_Bool u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_Bool u--d u--x)))))
(define csegen-1025 (cons csegen-1024 csegen-895))
(define csegen-1029 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-895 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40ListC-32C-36aC-41 csegen-895 u--d u--x)))))
(define PreludeC-45Types-u--C-47C-61_Eq_Nat (lambda (arg-0 arg-1) (let ((sc0 (or (and (= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1032 (cons (lambda (arg-676) (lambda (arg-679) (or (and (= arg-676 arg-679) 1) 0))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45Types-u--C-47C-61_Eq_Nat arg-686 arg-689)))))
(define AlgebraC-45SizeChange-u--C-61C-61_Eq_SizeChange (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else 0))))
(define AlgebraC-45SizeChange-u--C-47C-61_Eq_SizeChange (lambda (arg-0 arg-1) (let ((sc0 (AlgebraC-45SizeChange-u--C-61C-61_Eq_SizeChange arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1035 (cons (lambda (arg-676) (lambda (arg-679) (AlgebraC-45SizeChange-u--C-61C-61_Eq_SizeChange arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (AlgebraC-45SizeChange-u--C-47C-61_Eq_SizeChange arg-686 arg-689)))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1038 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1032 csegen-1035 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1032 csegen-1035 arg-686 arg-689)))))
(define DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (let ((e-1 (car arg-2))) (let ((e-2 (cdr arg-2))) (let ((e-4 (car arg-3))) (let ((e-5 (cdr arg-3))) (let ((sc2 (let ((e-6 (car arg-1))) ((e-6 e-1) e-4)))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 arg-1 e-2 e-5)) (else 0)))))))))
(define DataC-45List1-u--C-47C-61_Eq_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (let ((sc0 (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 arg-1 arg-2 arg-3))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1041 (cons (lambda (arg-676) (lambda (arg-679) (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 csegen-1038 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (DataC-45List1-u--C-47C-61_Eq_C-40List1C-32C-36aC-41 csegen-1038 arg-686 arg-689)))))
(define csegen-1044 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1032 csegen-1041 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1032 csegen-1041 arg-686 arg-689)))))
(define csegen-1048 (lambda (eta-0) (PreludeC-45TypesC-45String-length (PreludeC-45Show-u--show_Show_Nat eta-0))))
(define PreludeC-45Types-u--C-62_Ord_Nat (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_Integer arg-0 arg-1) 2)))
(define PreludeC-45Types-u--max_Ord_Nat (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45Types-u--C-62_Ord_Nat arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-1049 (lambda (eta-0) (lambda (eta-1) (PreludeC-45Types-u--max_Ord_Nat eta-0 eta-1))))
(define csegen-1055 (vector csegen-108 csegen-109 (lambda (arg-5924) arg-5924)))
(define csegen-1059 (lambda (arg-1566) (lambda (arg-1569) (PreludeC-45EqOrd-u--compare_Ord_Integer arg-1566 arg-1569))))
(define PreludeC-45EqOrd-u--C-60C-61_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (or (and (<= arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--C-62_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (or (and (> arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--max_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-62_Ord_Integer arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define PreludeC-45EqOrd-u--min_Ord_Integer (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Integer arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-1066 (vector csegen-722 csegen-1059 (lambda (arg-1576) (lambda (arg-1579) (PreludeC-45EqOrd-u--C-60_Ord_Integer arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (PreludeC-45EqOrd-u--C-62_Ord_Integer arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (PreludeC-45EqOrd-u--C-60C-61_Ord_Integer arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (PreludeC-45EqOrd-u--max_Ord_Integer arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (PreludeC-45EqOrd-u--min_Ord_Integer arg-1626 arg-1629)))))
(define csegen-1068 (vector csegen-1055 (lambda (arg-6023) (- 0 arg-6023)) (lambda (arg-6029) (lambda (arg-6032) (- arg-6029 arg-6032)))))
(define PreludeC-45Num-u--div_Integral_Integer (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-1 0))) (cond ((equal? sc0 0) (blodwen-euclidDiv arg-0 arg-1))(else (blodwen-error-quit (string-append "ERROR: " "Unhandled input for Prelude.Num.case block in div at Prelude.Num:91:3--93:44")))))))
(define PreludeC-45Num-u--mod_Integral_Integer (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Integer arg-1 0))) (cond ((equal? sc0 0) (blodwen-euclidMod arg-0 arg-1))(else (blodwen-error-quit (string-append "ERROR: " "Unhandled input for Prelude.Num.case block in mod at Prelude.Num:94:3--96:44")))))))
(define csegen-1070 (cons (vector csegen-1055 (lambda (arg-6312) (lambda (arg-6315) (PreludeC-45Num-u--div_Integral_Integer arg-6312 arg-6315))) (lambda (arg-6322) (lambda (arg-6325) (PreludeC-45Num-u--mod_Integral_Integer arg-6322 arg-6325)))) (cons csegen-1066 csegen-1068)))
(define csegen-1079 (lambda (arg-0) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 #\:)))
(define csegen-1240 (lambda (u--n) (string-append " (newtype by " (string-append (PreludeC-45Show-u--show_Show_Nat u--n) ")"))))
(define CoreC-45CompileExpr-u--show_Show_CFType (lambda (arg-0) (case (vector-ref arg-0 0) ((0) "Unit") ((1) "Int") ((2) "Integer") ((3) "Int_8") ((4) "Int_16") ((5) "Int_32") ((6) "Int_64") ((7) "Bits_8") ((8) "Bits_16") ((9) "Bits_32") ((10) "Bits_64") ((11) "String") ((12) "Double") ((13) "Char") ((14) "Ptr") ((15) "GCPtr") ((16) "Buffer") ((17) "ForeignObj") ((18) "%World") ((19) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (string-append (CoreC-45CompileExpr-u--show_Show_CFType e-0) (string-append " -> " (CoreC-45CompileExpr-u--show_Show_CFType e-1)))))) ((20) (let ((e-2 (vector-ref arg-0 1))) (string-append "IORes " (CoreC-45CompileExpr-u--show_Show_CFType e-2)))) ((21) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (string-append "struct " (string-append (PreludeC-45Show-u--show_Show_String e-3) (string-append " " (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-493 (csegen-1242)) eta-0)) e-4)))))))) (else (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (string-append (CoreC-45Name-u--show_Show_Name e-5) (string-append " " (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45CompileExpr-u--show_Show_CFType eta-0)) e-6))))))))))
(define CoreC-45CompileExpr-u--showPrec_Show_CFType (lambda (arg-0 arg-1) (CoreC-45CompileExpr-u--show_Show_CFType arg-1)))
(define csegen-1242 (lambda () (cons (lambda (u--x) (CoreC-45CompileExpr-u--show_Show_CFType u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45CompileExpr-u--showPrec_Show_CFType u--d u--x))))))
(define CoreC-45CompileExpr-u--show_Show_ConInfo (lambda (arg-0) (case (vector-ref arg-0 0) ((0) "[datacon]") ((1) "[tycon]") ((2) "[nil]") ((3) "[cons]") ((4) (let ((e-0 (vector-ref arg-0 1))) (string-append "[enum " (string-append (PreludeC-45Show-u--show_Show_Nat e-0) "]")))) ((5) "[nothing]") ((6) "[just]") ((7) "[record]") ((8) "[zero]") ((9) "[succ]") (else "[unit]"))))
(define CoreC-45CompileExpr-n--7229-4894-u--showFlag (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) "")(else (string-append (CoreC-45CompileExpr-u--show_Show_ConInfo arg-5) " ")))))
(define CoreC-45CompileExpr-u--show_Show_NamedConAlt (lambda (arg-0) (let ((e-0 (vector-ref arg-0 0))) (let ((e-1 (vector-ref arg-0 1))) (let ((e-2 (vector-ref arg-0 2))) (let ((e-3 (vector-ref arg-0 3))) (let ((e-4 (vector-ref arg-0 4))) (string-append "(%concase " (string-append (CoreC-45CompileExpr-n--7229-4894-u--showFlag e-4 e-3 e-2 e-1 e-0 e-1) (string-append (CoreC-45Name-u--show_Show_Name e-0) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 csegen-495 e-2) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-65 e-3) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-4) ")"))))))))))))))))
(define CoreC-45CompileExpr-u--showPrec_Show_NamedConAlt (lambda (arg-0 arg-1) (CoreC-45CompileExpr-u--show_Show_NamedConAlt arg-1)))
(define CoreC-45CompileExpr-u--show_Show_NamedConstAlt (lambda (arg-0) (let ((e-0 (car arg-0))) (let ((e-1 (cdr arg-0))) (string-append "(%constcase " (string-append (CoreC-45TTC-45Primitive-u--show_Show_Constant e-0) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-1) ")"))))))))
(define CoreC-45CompileExpr-u--showPrec_Show_NamedConstAlt (lambda (arg-0 arg-1) (CoreC-45CompileExpr-u--show_Show_NamedConstAlt arg-1)))
(define DataC-45Vect-foldrImpl (lambda (arg-3 arg-4 arg-5 arg-6) (if (null? arg-6) (arg-5 arg-4) (let ((e-3 (car arg-6))) (let ((e-4 (cdr arg-6))) (DataC-45Vect-foldrImpl arg-3 arg-4 (lambda (eta-0) (arg-5 ((arg-3 e-3) eta-0))) e-4))))))
(define DataC-45Vect-u--foldr_Foldable_C-40VectC-32C-36nC-41 (lambda (arg-3 arg-4 arg-5) (DataC-45Vect-foldrImpl arg-3 arg-4 (lambda (eta-0) eta-0) arg-5)))
(define DataC-45Vect-u--toList_Foldable_C-40VectC-32C-36nC-41 (lambda (ext-0) (DataC-45Vect-u--foldr_Foldable_C-40VectC-32C-36nC-41 csegen-103 '() ext-0)))
(define DataC-45Vect-u--show_Show_C-40C-40VectC-32C-36lenC-41C-32C-36elemC-41 (lambda (arg-2 ext-0) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 arg-2 (DataC-45Vect-u--toList_Foldable_C-40VectC-32C-36nC-41 ext-0))))
(define CoreC-45TTC-45Primitive-u--show_Show_C-40PrimFnC-32C-36arityC-41 (lambda (arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (string-append "+" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-0)))) ((1) (let ((e-1 (vector-ref arg-1 1))) (string-append "-" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-1)))) ((2) (let ((e-2 (vector-ref arg-1 1))) (string-append "*" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-2)))) ((3) (let ((e-3 (vector-ref arg-1 1))) (string-append "/" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-3)))) ((4) (let ((e-4 (vector-ref arg-1 1))) (string-append "%" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-4)))) ((5) (let ((e-5 (vector-ref arg-1 1))) (string-append "neg " (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-5)))) ((6) (let ((e-6 (vector-ref arg-1 1))) (string-append "shl " (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-6)))) ((7) (let ((e-7 (vector-ref arg-1 1))) (string-append "shr " (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-7)))) ((8) (let ((e-8 (vector-ref arg-1 1))) (string-append "and " (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-8)))) ((9) (let ((e-9 (vector-ref arg-1 1))) (string-append "or " (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-9)))) ((10) (let ((e-10 (vector-ref arg-1 1))) (string-append "xor " (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-10)))) ((11) (let ((e-11 (vector-ref arg-1 1))) (string-append "<" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-11)))) ((12) (let ((e-12 (vector-ref arg-1 1))) (string-append "<=" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-12)))) ((13) (let ((e-13 (vector-ref arg-1 1))) (string-append "==" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-13)))) ((14) (let ((e-14 (vector-ref arg-1 1))) (string-append ">=" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-14)))) ((15) (let ((e-15 (vector-ref arg-1 1))) (string-append ">" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-15)))) ((16) "op_strlen") ((17) "op_strhead") ((18) "op_strtail") ((19) "op_strindex") ((20) "op_strcons") ((21) "++") ((22) "op_strrev") ((23) "op_strsubstr") ((24) "op_doubleExp") ((25) "op_doubleLog") ((26) "op_doublePow") ((27) "op_doubleSin") ((28) "op_doubleCos") ((29) "op_doubleTan") ((30) "op_doubleASin") ((31) "op_doubleACos") ((32) "op_doubleATan") ((33) "op_doubleSqrt") ((34) "op_doubleFloor") ((35) "op_doubleCeiling") ((36) (let ((e-16 (vector-ref arg-1 1))) (let ((e-17 (vector-ref arg-1 2))) (string-append "cast-" (string-append (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-16) (string-append "-" (CoreC-45TTC-45Primitive-u--show_Show_PrimType e-17))))))) ((37) "believe_me") (else "crash"))))
(define CoreC-45TTC-45Term-u--show_Show_LazyReason (lambda (arg-0) (cond ((equal? arg-0 0) "Inf") ((equal? arg-0 1) "Lazy") (else "Unkown"))))
(define CoreC-45CompileExpr-n--6901-4660-u--showFlag (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) "")(else (string-append (CoreC-45CompileExpr-u--show_Show_ConInfo arg-5) " ")))))
(define CoreC-45CompileExpr-u--show_Show_NamedCExp (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-1 (vector-ref arg-0 2))) (string-append "!" (CoreC-45Name-u--show_Show_Name e-1)))) ((1) (let ((e-3 (vector-ref arg-0 2))) (CoreC-45Name-u--show_Show_Name e-3))) ((2) (let ((e-5 (vector-ref arg-0 2))) (let ((e-6 (vector-ref arg-0 3))) (string-append "(%lam " (string-append (CoreC-45Name-u--show_Show_Name e-5) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-6) ")"))))))) ((3) (let ((e-8 (vector-ref arg-0 2))) (let ((e-9 (vector-ref arg-0 3))) (let ((e-10 (vector-ref arg-0 4))) (string-append "(%let " (string-append (CoreC-45Name-u--show_Show_Name e-8) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-9) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-10) ")")))))))))) ((4) (let ((e-12 (vector-ref arg-0 2))) (let ((e-13 (vector-ref arg-0 3))) (string-append "(" (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-12) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (csegen-1244) e-13) ")"))))))) ((5) (let ((e-14 (vector-ref arg-0 1))) (let ((e-15 (vector-ref arg-0 2))) (let ((e-16 (vector-ref arg-0 3))) (let ((e-17 (vector-ref arg-0 4))) (let ((e-18 (vector-ref arg-0 5))) (string-append "(%con " (string-append (CoreC-45CompileExpr-n--6901-4660-u--showFlag e-14 e-18 e-17 e-16 e-15 e-16) (string-append (CoreC-45Name-u--show_Show_Name e-15) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 csegen-495 e-17) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (csegen-1244) e-18) ")"))))))))))))) ((6) (let ((e-21 (vector-ref arg-0 3))) (let ((e-22 (vector-ref arg-0 4))) (string-append "(" (string-append (CoreC-45TTC-45Primitive-u--show_Show_C-40PrimFnC-32C-36arityC-41 e-21) (string-append " " (string-append (DataC-45Vect-u--show_Show_C-40C-40VectC-32C-36lenC-41C-32C-36elemC-41 (csegen-1244) e-22) ")"))))))) ((7) (let ((e-24 (vector-ref arg-0 2))) (let ((e-25 (vector-ref arg-0 3))) (string-append "(%extern " (string-append (CoreC-45Name-u--show_Show_Name e-24) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (csegen-1244) e-25) ")"))))))) ((8) (let ((e-27 (vector-ref arg-0 2))) (let ((e-28 (vector-ref arg-0 3))) (string-append "(%force " (string-append (CoreC-45TTC-45Term-u--show_Show_LazyReason e-27) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-28) ")"))))))) ((9) (let ((e-30 (vector-ref arg-0 2))) (let ((e-31 (vector-ref arg-0 3))) (string-append "(%delay " (string-append (CoreC-45TTC-45Term-u--show_Show_LazyReason e-30) (string-append " " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-31) ")"))))))) ((10) (let ((e-33 (vector-ref arg-0 2))) (let ((e-34 (vector-ref arg-0 3))) (let ((e-35 (vector-ref arg-0 4))) (string-append "(%case " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-33) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (CoreC-45CompileExpr-u--show_Show_NamedConAlt u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45CompileExpr-u--showPrec_Show_NamedConAlt u--d u--x)))) e-34) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (csegen-1244) e-35) ")")))))))))) ((11) (let ((e-37 (vector-ref arg-0 2))) (let ((e-38 (vector-ref arg-0 3))) (let ((e-39 (vector-ref arg-0 4))) (string-append "(%case " (string-append (CoreC-45CompileExpr-u--show_Show_NamedCExp e-37) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (CoreC-45CompileExpr-u--show_Show_NamedConstAlt u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45CompileExpr-u--showPrec_Show_NamedConstAlt u--d u--x)))) e-38) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (csegen-1244) e-39) ")")))))))))) ((12) (let ((e-41 (vector-ref arg-0 2))) (CoreC-45TTC-45Primitive-u--show_Show_Constant e-41))) ((13) "___") (else (let ((e-44 (vector-ref arg-0 2))) (string-append "(CRASH " (string-append (PreludeC-45Show-u--show_Show_String e-44) ")")))))))
(define CoreC-45CompileExpr-u--showPrec_Show_NamedCExp (lambda (arg-0 arg-1) (CoreC-45CompileExpr-u--show_Show_NamedCExp arg-1)))
(define csegen-1244 (lambda () (cons (lambda (u--x) (CoreC-45CompileExpr-u--show_Show_NamedCExp u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45CompileExpr-u--showPrec_Show_NamedCExp u--d u--x))))))
(define CoreC-45CaseC-45CaseTree-u--show_Show_Pat (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (string-append (CoreC-45Name-u--show_Show_Name e-1) (string-append "@(" (string-append (CoreC-45CaseC-45CaseTree-u--show_Show_Pat e-2) ")")))))) ((1) (let ((e-4 (vector-ref arg-0 2))) (let ((e-5 (vector-ref arg-0 3))) (let ((e-7 (vector-ref arg-0 5))) (string-append (CoreC-45Name-u--show_Show_Name e-4) (string-append " " (string-append (PreludeC-45Show-u--show_Show_Int e-5) (string-append " " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (csegen-1258) e-7))))))))) ((2) (let ((e-9 (vector-ref arg-0 2))) (let ((e-11 (vector-ref arg-0 4))) (string-append "<TyCon>" (string-append (CoreC-45Name-u--show_Show_Name e-9) (string-append " " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (csegen-1258) e-11))))))) ((3) (let ((e-13 (vector-ref arg-0 2))) (CoreC-45TTC-45Primitive-u--show_Show_Constant e-13))) ((4) (let ((e-16 (vector-ref arg-0 3))) (let ((e-17 (vector-ref arg-0 4))) (string-append "(" (string-append (CoreC-45CaseC-45CaseTree-u--show_Show_Pat e-16) (string-append " -> " (string-append (CoreC-45CaseC-45CaseTree-u--show_Show_Pat e-17) ")"))))))) ((5) (let ((e-21 (vector-ref arg-0 4))) (string-append "(Delay " (string-append (CoreC-45CaseC-45CaseTree-u--show_Show_Pat e-21) ")")))) ((6) (let ((e-23 (vector-ref arg-0 2))) (CoreC-45Name-u--show_Show_Name e-23))) (else (let ((e-25 (vector-ref arg-0 2))) (string-append ".(" (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 '() e-25) ")")))))))
(define CoreC-45CaseC-45CaseTree-u--showPrec_Show_Pat (lambda (arg-0 arg-1) (CoreC-45CaseC-45CaseTree-u--show_Show_Pat arg-1)))
(define csegen-1258 (lambda () (cons (lambda (u--x) (CoreC-45CaseC-45CaseTree-u--show_Show_Pat u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45CaseC-45CaseTree-u--showPrec_Show_Pat u--d u--x))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-enclose (lambda (arg-1 arg-2 arg-3) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 arg-1 arg-3) arg-2)))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-lbrace (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-681 #\{))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-rbrace (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-681 #\}))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-braces (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-enclose LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-lbrace LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-rbrace ext-0)))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-byShow (lambda (arg-2 ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-702 (let ((e-1 (car arg-2))) (e-1 ext-0)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-colon (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-681 #\:))
(define DataC-45Maybe-fromMaybe (lambda (arg-1 arg-2) (if (null? arg-2) (arg-1) (let ((e-2 (unbox arg-2))) e-2))))
(define PreludeC-45Interfaces-guard (lambda (arg-1 arg-2) (cond ((equal? arg-2 1) (let ((e-1 (vector-ref arg-1 0))) (let ((e-5 (vector-ref e-1 1))) ((e-5 'erased) (vector 0 ))))) (else (let ((e-2 (vector-ref arg-1 1))) (e-2 'erased))))))
(define PreludeC-45Types-strUncons (lambda (arg-0) (cond ((equal? arg-0 "") '())(else (box (cons (string-ref arg-0 0) (substring arg-0 1 (string-length arg-0))))))))
(define PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (lambda (arg-2 arg-3) (if (null? arg-2) '() (let ((e-2 (unbox arg-2))) (arg-3 e-2)))))
(define CoreC-45Name-isOpUserName (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (DataC-45Maybe-fromMaybe (lambda () 0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (Builtin-fst eta-0)) (PreludeC-45Types-strUncons e-0)) (lambda (u--c) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (PreludeC-45Interfaces-guard csegen-258 (CoreC-45Name-isOpChar u--c)) (lambda (_-10649) (box 1)))))))) ((1) 0) (else 0))))
(define CoreC-45Name-isPrettyOp (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((1) (let ((e-0 (vector-ref arg-1 1))) (case (vector-ref e-0 0) ((1) arg-0) ((0) (CoreC-45Name-isOpUserName e-0))(else 0)))) ((4) (let ((e-1 (vector-ref arg-1 1))) (CoreC-45Name-isOpUserName (vector 0 e-1))))(else 0))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-lparen (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-681 #\())
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-rparen (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-681 #\)))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parens (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-enclose LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-lparen LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-rparen ext-0)))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parenthesise (lambda (arg-1 ext-0) (cond ((equal? arg-1 1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parens ext-0)) (else ext-0))))
(define CoreC-45Name-prettyOp (lambda (arg-0 arg-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parenthesise (CoreC-45Name-isPrettyOp arg-0 arg-1) (CoreC-45Name-u--pretty_Pretty_Void_Name arg-1))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-softline (vector 7 (lambda () (vector 1 #\ )) (lambda () (vector 3 ))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-fillSep (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-concatWith (lambda (u--x) (lambda (u--y) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 u--x LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-softline) u--y))) ext-0)))
(define DataC-45List-dropWhile (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (let ((sc1 (arg-1 e-2))) (cond ((equal? sc1 1) (DataC-45List-dropWhile arg-1 e-3)) (else (cons e-2 e-3)))))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-case--wordsC-44helper-5200 (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) '() (let ((sc1 (DataC-45List-break (lambda (eta-0) (PreludeC-45Types-isSpace eta-0)) arg-3))) (let ((e-2 (car sc1))) (let ((e-3 (cdr sc1))) (cons e-2 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-n--3788-5188-u--helper arg-1 e-3))))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-n--3788-5188-u--helper (lambda (arg-1 arg-2) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-case--wordsC-44helper-5200 arg-1 arg-2 (DataC-45List-dropWhile (lambda (eta-0) (PreludeC-45Types-isSpace eta-0)) arg-2))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-words (lambda (arg-1) (PreludeC-45TypesC-45List-mapAppend '() csegen-753 (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Types-fastPack eta-0)) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-n--3788-5188-u--helper arg-1 (PreludeC-45Types-fastUnpack arg-1))))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-reflow (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-fillSep (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-words ext-0))))
(define CoreC-45NameC-45Namespace-u--pretty_Pretty_Void_Namespace (lambda (arg-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-concatWith csegen-510 (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String eta-0)) (PreludeC-45TypesC-45List-reverse arg-0)))))
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--fromString_FromString_C-40DocC-32C-36annC-41 (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-702 ext-0)))
(define CoreC-45Name-u--pretty_Pretty_Void_UserName (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String e-0))) ((1) (let ((e-1 (vector-ref arg-0 1))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--fromString_FromString_C-40DocC-32C-36annC-41 ".") (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String e-1)))) (else csegen-505))))
(define CoreC-45Name-u--pretty_Pretty_Void_Name (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (CoreC-45NameC-45Namespace-u--pretty_Pretty_Void_Namespace e-0) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-dot) (CoreC-45Name-prettyOp 1 e-1))))) ((1) (let ((e-2 (vector-ref arg-0 1))) (CoreC-45Name-u--pretty_Pretty_Void_UserName e-2))) ((2) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-braces (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String e-3) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-colon) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-byShow csegen-495 e-4)))))) ((3) (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-braces (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_Char #\P) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-colon) (CoreC-45Name-u--pretty_Pretty_Void_Name e-5)) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-colon) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-byShow csegen-495 e-6)))))) ((4) (let ((e-7 (vector-ref arg-0 1))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String e-7))) ((5) (let ((e-9 (vector-ref arg-0 1))) (let ((e-10 (vector-ref arg-0 2))) (let ((e-18 (car e-9))) (let ((e-19 (cdr e-9))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-byShow csegen-495 e-18) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-colon) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-byShow csegen-495 e-19)) LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-colon) (CoreC-45Name-u--pretty_Pretty_Void_Name e-10))))))) ((6) (let ((e-11 (vector-ref arg-0 1))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-reflow "case block in") (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String e-11)))) ((7) (let ((e-13 (vector-ref arg-0 1))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Util-reflow "with block in") (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String e-13)))) (else (let ((e-15 (vector-ref arg-0 1))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String "$resolved") (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--pretty_Pretty_Void_String (PreludeC-45Show-u--show_Show_Int e-15))))))))
(define CoreC-45Name-u--prettyPrec_Pretty_Void_Name (lambda (arg-0 arg-1) (CoreC-45Name-u--pretty_Pretty_Void_Name arg-1)))
(define csegen-1260 (cons (lambda (arg-11067) (CoreC-45Name-u--pretty_Pretty_Void_Name arg-11067)) (lambda (arg-11073) (lambda (arg-11076) (CoreC-45Name-u--prettyPrec_Pretty_Void_Name arg-11073 arg-11076)))))
(define IdrisC-45PrettyC-45Annotations-arrow csegen-960)
(define LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-hsep (lambda (ext-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-concatWith csegen-716 ext-0)))
(define PreludeC-45Show-u--C-62_Ord_Prec (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (PreludeC-45Show-u--compare_Ord_Prec arg-0 arg-1) 2)))
(define CoreC-45TTC-45Primitive-u--pretty_Pretty_IdrisSyntax_PrimType (lambda (arg-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-annotate (vector 1 '()) (cond ((equal? arg-0 0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "Int")) ((equal? arg-0 1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "Int8")) ((equal? arg-0 2) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "Int16")) ((equal? arg-0 3) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "Int32")) ((equal? arg-0 4) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "Int64")) ((equal? arg-0 5) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "Integer")) ((equal? arg-0 6) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "Bits8")) ((equal? arg-0 7) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "Bits16")) ((equal? arg-0 8) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "Bits32")) ((equal? arg-0 9) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "Bits64")) ((equal? arg-0 10) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "String")) ((equal? arg-0 11) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "Char")) ((equal? arg-0 12) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "Double")) (else (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "%World"))))))
(define CoreC-45TTC-45Primitive-u--pretty_Pretty_IdrisSyntax_Constant (lambda (arg-0) (case (vector-ref arg-0 0) ((13) (let ((e-0 (vector-ref arg-0 1))) (CoreC-45TTC-45Primitive-u--pretty_Pretty_IdrisSyntax_PrimType e-0)))(else (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-annotate (vector 2 '()) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-702 (CoreC-45TTC-45Primitive-u--show_Show_Constant arg-0)))))))
(define CoreC-45CaseC-45CaseTree-u--pretty_Pretty_IdrisSyntax_Pat (lambda (arg-0) (CoreC-45CaseC-45CaseTree-u--prettyPrec_Pretty_IdrisSyntax_Pat (vector 0 ) arg-0)))
(define csegen-1268 (cons (lambda (u--x) (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 '() u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Term-u--showPrec_Show_C-40TermC-32C-36varsC-41 '() u--d u--x)))))
(define CoreC-45CaseC-45CaseTree-u--prettyPrec_Pretty_IdrisSyntax_Pat (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-1 (vector-ref arg-1 2))) (let ((e-2 (vector-ref arg-1 3))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-1260 e-1) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 "@")) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parens (CoreC-45CaseC-45CaseTree-u--pretty_Pretty_IdrisSyntax_Pat e-2))))))) ((1) (let ((e-4 (vector-ref arg-1 2))) (let ((e-7 (vector-ref arg-1 5))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parenthesise (PreludeC-45Show-u--C-62_Ord_Prec arg-0 (vector 0 )) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-hsep (cons (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-1260 e-4) (PreludeC-45TypesC-45List-mapAppend '() (csegen-1263) e-7))))))) ((2) (let ((e-9 (vector-ref arg-1 2))) (let ((e-11 (vector-ref arg-1 4))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parenthesise (PreludeC-45Show-u--C-62_Ord_Prec arg-0 (vector 0 )) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-hsep (cons (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-1260 e-9) (PreludeC-45TypesC-45List-mapAppend '() (csegen-1263) e-11))))))) ((3) (let ((e-13 (vector-ref arg-1 2))) (CoreC-45TTC-45Primitive-u--pretty_Pretty_IdrisSyntax_Constant e-13))) ((4) (let ((e-16 (vector-ref arg-1 3))) (let ((e-17 (vector-ref arg-1 4))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parenthesise (PreludeC-45Show-u--C-62_Ord_Prec arg-0 (vector 0 )) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 (CoreC-45CaseC-45CaseTree-u--pretty_Pretty_IdrisSyntax_Pat e-16) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 IdrisC-45PrettyC-45Annotations-arrow (CoreC-45CaseC-45CaseTree-u--pretty_Pretty_IdrisSyntax_Pat e-17))))))) ((5) (let ((e-21 (vector-ref arg-1 4))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parens (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-C-60C-43C-43C-62 (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--fromString_FromString_C-40DocC-32C-36annC-41 "Delay") (CoreC-45CaseC-45CaseTree-u--pretty_Pretty_IdrisSyntax_Pat e-21))))) ((6) (let ((e-23 (vector-ref arg-1 2))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-1260 e-23))) (else (let ((e-25 (vector-ref arg-1 2))) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-u--C-60C-43C-62_Semigroup_C-40DocC-32C-36annC-41 (IdrisC-45PrettyC-45Annotations-keyword (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-504 ".")) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Symbols-parens (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-byShow csegen-1268 e-25))))))))
(define csegen-1263 (lambda () (lambda (eta-0) (CoreC-45CaseC-45CaseTree-u--prettyPrec_Pretty_IdrisSyntax_Pat (vector 6 ) eta-0))))
(define CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 (lambda (arg-1 arg-2 ext-0) (if (null? arg-2) (vector 1 '()) (let ((e-4 (car arg-2))) (let ((e-5 (cdr arg-2))) (let ((act-1 ((CoreC-45CoreC-45Binder-traverse (lambda (arg-3) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 arg-3)) e-4) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-1 e-5 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-6 e-7))))) eff-0) eta-0)))))))) eff-0) ext-0))))))))))
(define CoreC-45Context-u--full_HasNames_Transform (lambda (arg-0 arg-1 ext-0) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-0 e-1 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-2 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-3 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-3) eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-4 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-4) eta-2))) (case (vector-ref act-4 0) ((0) (let ((e-8 (vector-ref act-4 1))) (vector 0 e-8))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-3) (vector 1 (vector e-0 e-5 e-6 e-7 e-8))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) ext-0))))))))))))
(define CoreC-45Context-u--resolved_HasNames_Transform (lambda (arg-0 arg-1 ext-0) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-0 e-1) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-2 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-3 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-3) eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-4 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-4) eta-2))) (case (vector-ref act-4 0) ((0) (let ((e-8 (vector-ref act-4 1))) (vector 0 e-8))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-3) (vector 1 (vector e-0 e-5 e-6 e-7 e-8))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) ext-0))))))))))))
(define csegen-1273 (cons (lambda (arg-7719) (lambda (arg-7722) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Transform arg-7719 arg-7722 eta-0)))) (lambda (arg-7729) (lambda (arg-7732) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Transform arg-7729 arg-7732 eta-0))))))
(define csegen-1275 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (box e-5)))))))
(define csegen-1278 (lambda (eta-0) (vector 1 (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (vector 0 eta-1 eta-2 eta-3)))))))
(define csegen-1281 (lambda (eta-0) (vector 1 (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (lambda (eta-5) (vector 1 eta-1 eta-2 eta-3 eta-4 eta-5)))))))))
(define csegen-1284 (lambda (eta-0) (vector 1 (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (vector 2 eta-1 eta-2 eta-3 eta-4))))))))
(define csegen-1287 (lambda (eta-0) (vector 1 (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (vector 4 eta-1 eta-2 eta-3 eta-4))))))))
(define csegen-1290 (lambda (eta-0) (vector 1 (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (vector 5 eta-1 eta-2 eta-3 eta-4))))))))
(define csegen-1294 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 0 e-5)))))))
(define csegen-1295 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 0 e-5)))))))
(define csegen-1296 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 1 e-5)))))))
(define csegen-1297 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 21 e-5)))))))
(define csegen-1298 (lambda (eta-0) (lambda (eta-1) (CoreC-45Core-traverseC-39 eta-0 eta-1 '()))))
(define csegen-1299 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (lambda (__infixTupleSection-0) (cons e-5 __infixTupleSection-0))))))))
(define csegen-1300 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 32 e-5)))))))
(define csegen-1301 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 48 e-5)))))))
(define csegen-1302 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (lambda (eta-1) (vector 72 e-5 eta-1))))))))
(define csegen-1303 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 73 e-5)))))))
(define csegen-1304 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 3 e-5)))))))
(define SystemC-45FFI-free (lambda (arg-1 arg-2) (let ((e-2 (cdr arg-1))) ((e-2 'erased) (lambda (eta-0) (SystemC-45FFI-prim__free arg-2 eta-0))))))
(define SystemC-45Directory-currentDir (lambda (arg-1) (let ((e-1 (car arg-1))) (let ((e-4 (vector-ref e-1 1))) ((((e-4 'erased) 'erased) (let ((e-6 (cdr arg-1))) ((e-6 'erased) (lambda (eta-0) (SystemC-45Directory-prim__currentDir eta-0))))) (lambda (u--res) (let ((sc1 (PreludeC-45EqOrd-u--C-47C-61_Eq_Int (PrimIO-prim__nullAnyPtr u--res) (blodwen-toSignedInt 0 63)))) (cond ((equal? sc1 1) (let ((e-7 (car arg-1))) (let ((e-10 (vector-ref e-7 0))) (let ((e-12 (vector-ref e-10 1))) ((e-12 'erased) '()))))) (else (let ((u--s (PreludeC-45IO-prim__getString u--res))) (let ((e-7 (car arg-1))) (let ((e-9 (vector-ref e-7 1))) ((((e-9 'erased) 'erased) (SystemC-45FFI-free arg-1 u--res)) (lambda (_-10649) (let ((e-12 (car arg-1))) (let ((e-15 (vector-ref e-12 0))) (let ((e-17 (vector-ref e-15 1))) ((e-17 'erased) (box u--s)))))))))))))))))))
(define csegen-1310 (SystemC-45Directory-currentDir csegen-82))
(define csegen-1311 (lambda (eta-0) (CoreC-45Core-u--throw_Catchable_Core_Error (vector 61 "Can't get current directory") eta-0)))
(define csegen-1313 (lambda (eta-0) (let ((e-2 (vector-ref eta-0 2))) e-2)))
(define csegen-1314 (lambda (u--g) (cons (let ((e-18 (vector-ref u--g 18))) e-18) (let ((e-2 (vector-ref u--g 2))) e-2))))
(define csegen-1315 (lambda (eta-0) (let ((e-18 (vector-ref eta-0 18))) e-18)))
(define CoreC-45CompileExpr-u--C-61C-61_Eq_ConInfo (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (case (vector-ref arg-1 0) ((0) 1)(else 0))) ((1) (case (vector-ref arg-1 0) ((1) 1)(else 0))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0))) ((3) (case (vector-ref arg-1 0) ((3) 1)(else 0))) ((4) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((4) (let ((e-1 (vector-ref arg-1 1))) (or (and (= e-0 e-1) 1) 0)))(else 0)))) ((5) (case (vector-ref arg-1 0) ((5) 1)(else 0))) ((6) (case (vector-ref arg-1 0) ((6) 1)(else 0))) ((7) (case (vector-ref arg-1 0) ((7) 1)(else 0))) ((8) (case (vector-ref arg-1 0) ((8) 1)(else 0))) ((9) (case (vector-ref arg-1 0) ((9) 1)(else 0))) ((10) (case (vector-ref arg-1 0) ((10) 1)(else 0)))(else 0))))
(define CoreC-45TT-u--C-61C-61_Eq_TotalReq (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else 0))))
(define CoreC-45ContextC-45Context-u--C-61C-61_Eq_DefFlag (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (case (vector-ref arg-1 0) ((0) 1)(else 0))) ((1) (case (vector-ref arg-1 0) ((1) 1)(else 0))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0))) ((3) (case (vector-ref arg-1 0) ((3) 1)(else 0))) ((4) (case (vector-ref arg-1 0) ((4) 1)(else 0))) ((5) (case (vector-ref arg-1 0) ((5) 1)(else 0))) ((6) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((6) (let ((e-4 (vector-ref arg-1 1))) (CoreC-45TT-u--C-61C-61_Eq_TotalReq e-0 e-4)))(else 0)))) ((7) (case (vector-ref arg-1 0) ((7) 1)(else 0))) ((8) (case (vector-ref arg-1 0) ((8) 1)(else 0))) ((9) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((9) (let ((e-5 (vector-ref arg-1 1))) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-832 csegen-1032 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-832 csegen-1032 arg-686 arg-689)))) e-1 e-5)))(else 0)))) ((10) (case (vector-ref arg-1 0) ((10) 1)(else 0))) ((11) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((11) (let ((e-6 (vector-ref arg-1 1))) (CoreC-45CompileExpr-u--C-61C-61_Eq_ConInfo e-2 e-6)))(else 0)))) ((12) (let ((e-3 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((12) (let ((e-7 (vector-ref arg-1 1))) (or (and (= e-3 e-7) 1) 0)))(else 0))))(else 0))))
(define CoreC-45ContextC-45Context-u--C-47C-61_Eq_DefFlag (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45ContextC-45Context-u--C-61C-61_Eq_DefFlag arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1319 (cons (lambda (arg-676) (lambda (arg-679) (CoreC-45ContextC-45Context-u--C-61C-61_Eq_DefFlag arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (CoreC-45ContextC-45Context-u--C-47C-61_Eq_DefFlag arg-686 arg-689)))))
(define csegen-1325 (lambda (eta-0) (vector 1 (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (lambda (eta-7) (vector eta-1 eta-2 eta-3 eta-4 eta-5 eta-6 eta-7)))))))))))
(define CoreC-45Options-u--C-61C-61_Eq_CG (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (case (vector-ref arg-1 0) ((0) 1)(else 0))) ((1) (case (vector-ref arg-1 0) ((1) 1)(else 0))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0))) ((3) (case (vector-ref arg-1 0) ((3) 1)(else 0))) ((4) (case (vector-ref arg-1 0) ((4) 1)(else 0))) ((5) (case (vector-ref arg-1 0) ((5) 1)(else 0))) ((6) (case (vector-ref arg-1 0) ((6) 1)(else 0))) ((7) (case (vector-ref arg-1 0) ((7) 1)(else 0))) ((8) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-1 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-0 e-1)))(else 0))))(else 0))))
(define CoreC-45Options-u--C-47C-61_Eq_CG (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45Options-u--C-61C-61_Eq_CG arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1331 (cons (lambda (arg-676) (lambda (arg-679) (CoreC-45Options-u--C-61C-61_Eq_CG arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (CoreC-45Options-u--C-47C-61_Eq_CG arg-686 arg-689)))))
(define csegen-1333 (lambda (eta-0) (PreludeC-45Types-prim__integerToNat eta-0)))
(define csegen-1338 (vector '() '() '() '() '() '() '()))
(define LibrariesC-45DataC-45StringC-45Iterator-withString (lambda (arg-1 arg-2) (arg-2 (LibrariesC-45DataC-45StringC-45Iterator-fromString arg-1))))
(define LibrariesC-45DataC-45StringC-45Iterator-n--2779-2205-u--loop (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (let ((sc0 (LibrariesC-45DataC-45StringC-45Iterator-uncons arg-1 arg-5))) (if (null? sc0) arg-4 (let ((e-2 (car sc0))) (let ((e-3 (cdr sc0))) (LibrariesC-45DataC-45StringC-45Iterator-n--2779-2205-u--loop arg-1 arg-2 arg-3 ((arg-3 arg-4) e-2) e-3)))))))
(define LibrariesC-45DataC-45StringC-45Iterator-foldl (lambda (arg-1 arg-2 arg-3) (LibrariesC-45DataC-45StringC-45Iterator-withString arg-3 (lambda (eta-0) (LibrariesC-45DataC-45StringC-45Iterator-n--2779-2205-u--loop arg-3 arg-2 arg-1 arg-2 eta-0)))))
(define CoreC-45Hash-u--hash_Hashable_Char (lambda (ext-0) (cast-char-boundedInt ext-0 63)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Char (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Char arg-1) 63)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_String (lambda (arg-0 ext-0) (LibrariesC-45DataC-45StringC-45Iterator-foldl (lambda (eta-0) (lambda (eta-1) (CoreC-45Hash-u--hashWithSalt_Hashable_Char eta-0 eta-1))) arg-0 ext-0)))
(define CoreC-45Hash-u--hash_Hashable_String (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_String (blodwen-toSignedInt 5381 63) ext-0)))
(define csegen-1355 (cons (lambda (arg-4535) (CoreC-45Hash-u--hash_Hashable_String arg-4535)) (lambda (arg-4541) (lambda (arg-4544) (CoreC-45Hash-u--hashWithSalt_Hashable_String arg-4541 arg-4544)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Int (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) arg-1 63)))
(define PreludeC-45Num-u--abs_Abs_Int (lambda (arg-0) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int arg-0 (blodwen-toSignedInt 0 63)))) (cond ((equal? sc0 1) (bs- 0 arg-0 63)) (else arg-0)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) (PreludeC-45Num-u--abs_Abs_Int arg-2) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 arg-1 (bs+ (bs* arg-2 33 63) (let ((e-1 (car arg-1))) (e-1 e-2)) 63) e-3))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Namespace (lambda (arg-0 arg-1) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 csegen-1355 arg-0 arg-1)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Name (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((2) (let ((e-0 (vector-ref arg-1 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_String arg-0 e-0))) ((4) (let ((e-3 (vector-ref arg-1 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_Name arg-0 e-3))) ((0) (let ((e-4 (vector-ref arg-1 1))) (let ((e-5 (vector-ref arg-1 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Namespace arg-0 e-4) e-5)))) ((8) (let ((e-6 (vector-ref arg-1 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Int arg-0 e-6)))(else (CoreC-45Hash-u--hashWithSalt_Hashable_String arg-0 (CoreC-45Name-u--show_Show_Name arg-1))))))
(define CoreC-45Hash-u--hash_Hashable_Name (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (blodwen-toSignedInt 5381 63) ext-0)))
(define csegen-1357 (cons (lambda (arg-4535) (CoreC-45Hash-u--hash_Hashable_Name arg-4535)) (lambda (arg-4541) (lambda (arg-4544) (CoreC-45Hash-u--hashWithSalt_Hashable_Name arg-4541 arg-4544)))))
(define CoreC-45Hash-u--hash_Hashable_Nat (lambda (ext-0) (blodwen-toSignedInt ext-0 63)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Nat (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Nat arg-1) 63)))
(define csegen-1359 (cons (lambda (arg-4535) (CoreC-45Hash-u--hash_Hashable_Nat arg-4535)) (lambda (arg-4541) (lambda (arg-4544) (CoreC-45Hash-u--hashWithSalt_Hashable_Nat arg-4541 arg-4544)))))
(define csegen-1361 (cons (lambda (arg-4535) arg-4535) (lambda (arg-4541) (lambda (arg-4544) (CoreC-45Hash-u--hashWithSalt_Hashable_Int arg-4541 arg-4544)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((e-2 (car arg-5))) (let ((e-3 (cdr arg-5))) (let ((e-4 (cdr arg-3))) ((e-4 (let ((e-5 (cdr arg-2))) ((e-5 arg-4) e-2))) e-3))))))
(define CoreC-45Hash-u--hash_Hashable_Integer (lambda (ext-0) (blodwen-toSignedInt ext-0 63)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Integer (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Integer arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 (blodwen-toSignedInt 5381 63) ext-0)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_CFType (lambda (arg-0 ext-0) (case (vector-ref ext-0 0) ((0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 0)) ((1) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1)) ((7) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2)) ((8) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 3)) ((9) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 4)) ((10) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 5)) ((11) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 6)) ((12) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 7)) ((13) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 8)) ((14) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 9)) ((15) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 10)) ((16) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 11)) ((18) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 12)) ((19) (let ((e-0 (vector-ref ext-0 1))) (let ((e-1 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_CFType (CoreC-45Hash-u--hashWithSalt_Hashable_CFType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 13) e-0) e-1)))) ((20) (let ((e-2 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_CFType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 14) e-2))) ((21) (let ((e-3 (vector-ref ext-0 1))) (let ((e-4 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (cons (lambda (arg-4535) (CoreC-45Hash-u--hash_Hashable_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1355 (csegen-1363) arg-4535)) (lambda (arg-4541) (lambda (arg-4544) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1355 (csegen-1363) arg-4541 arg-4544)))) (CoreC-45Hash-u--hashWithSalt_Hashable_String (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 15) e-3) e-4)))) ((22) (let ((e-5 (vector-ref ext-0 1))) (let ((e-6 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (csegen-1363) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 16) e-5) e-6)))) ((3) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 17)) ((4) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 18)) ((5) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 19)) ((6) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 20)) ((17) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 21)) (else (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 22)))))
(define CoreC-45Hash-u--hash_Hashable_CFType (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_CFType (blodwen-toSignedInt 5381 63) ext-0)))
(define csegen-1363 (lambda () (cons (lambda (arg-4535) (CoreC-45Hash-u--hash_Hashable_CFType arg-4535)) (lambda (arg-4541) (lambda (arg-4544) (CoreC-45Hash-u--hashWithSalt_Hashable_CFType arg-4541 arg-4544))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) (PreludeC-45Num-u--abs_Abs_Int arg-3) (let ((e-3 (car arg-4))) (let ((e-4 (cdr arg-4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 arg-2 (bs+ (bs* arg-3 33 63) (let ((e-1 (car arg-2))) (e-1 e-3)) 63) e-4))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) (PreludeC-45Num-u--abs_Abs_Int arg-2) (let ((e-2 (unbox arg-3))) (let ((e-3 (cdr arg-1))) ((e-3 arg-2) e-2))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (lambda (arg-0 ext-0) (cond ((equal? ext-0 0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1)) ((equal? ext-0 1) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2)) ((equal? ext-0 2) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 3)) ((equal? ext-0 3) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 4)) ((equal? ext-0 4) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 5)) ((equal? ext-0 5) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 6)) ((equal? ext-0 6) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 7)) ((equal? ext-0 7) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 8)) ((equal? ext-0 8) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 9)) ((equal? ext-0 9) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 10)) ((equal? ext-0 10) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 11)) ((equal? ext-0 11) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 12)) ((equal? ext-0 12) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 13)) (else (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 14)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40PrimFnC-32C-36arityC-41 (lambda (arg-1 ext-0) (case (vector-ref ext-0 0) ((0) (let ((e-0 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 0) e-0))) ((1) (let ((e-1 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 1) e-1))) ((2) (let ((e-2 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 2) e-2))) ((3) (let ((e-3 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 3) e-3))) ((4) (let ((e-4 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 4) e-4))) ((5) (let ((e-5 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 5) e-5))) ((6) (let ((e-6 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 6) e-6))) ((7) (let ((e-7 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 7) e-7))) ((8) (let ((e-8 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 8) e-8))) ((9) (let ((e-9 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 9) e-9))) ((10) (let ((e-10 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 10) e-10))) ((11) (let ((e-11 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 11) e-11))) ((12) (let ((e-12 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 12) e-12))) ((13) (let ((e-13 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 13) e-13))) ((14) (let ((e-14 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 14) e-14))) ((15) (let ((e-15 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 15) e-15))) ((16) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 16)) ((17) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 17)) ((18) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 18)) ((19) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 19)) ((20) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 20)) ((21) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 21)) ((22) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 22)) ((23) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 23)) ((24) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 24)) ((25) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 25)) ((27) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 26)) ((28) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 27)) ((29) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 28)) ((30) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 29)) ((31) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 30)) ((32) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 31)) ((33) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 32)) ((34) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 33)) ((35) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 34)) ((36) (let ((e-16 (vector-ref ext-0 1))) (let ((e-17 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 35) e-16) e-17)))) ((37) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 36)) ((38) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 37)) (else (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 38)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_ConInfo (lambda (arg-0 ext-0) (case (vector-ref ext-0 0) ((0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 0)) ((1) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1)) ((2) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2)) ((3) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 3)) ((4) (let ((e-0 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Nat (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 4) e-0))) ((5) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 5)) ((6) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 6)) ((7) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 7)) ((8) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 8)) ((9) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 9)) (else (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 10)))))
(define CoreC-45Hash-u--hash_Hashable_Bits16 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Bits16 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Bits16 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Bits32 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Bits32 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Bits32 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Bits64 (lambda (ext-0) (blodwen-toSignedInt ext-0 63)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Bits64 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Bits64 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Bits8 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Bits8 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Bits8 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Double (lambda (ext-0) (CoreC-45Hash-u--hash_Hashable_String (PreludeC-45Show-u--show_Show_Double ext-0))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Double (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Double arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Int16 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Int16 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Int16 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Int32 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Int32 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Int32 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Int64 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Int64 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Int64 arg-1) 63)))
(define CoreC-45Hash-u--hash_Hashable_Int8 (lambda (ext-0) ext-0))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Int8 (lambda (arg-0 arg-1) (bs+ (bs* arg-0 33 63) (CoreC-45Hash-u--hash_Hashable_Int8 arg-1) 63)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_Constant (lambda (arg-0 ext-0) (case (vector-ref ext-0 0) ((0) (let ((e-0 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Int (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 0) e-0))) ((1) (let ((e-1 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Int8 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1) e-1))) ((2) (let ((e-2 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Int16 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2) e-2))) ((3) (let ((e-3 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Int32 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 3) e-3))) ((4) (let ((e-4 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Int64 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 4) e-4))) ((5) (let ((e-5 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 5) e-5))) ((6) (let ((e-6 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Bits8 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 6) e-6))) ((7) (let ((e-7 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Bits16 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 7) e-7))) ((8) (let ((e-8 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Bits32 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 8) e-8))) ((9) (let ((e-9 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Bits64 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 9) e-9))) ((10) (let ((e-10 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_String (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 10) e-10))) ((11) (let ((e-11 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Char (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 11) e-11))) ((12) (let ((e-12 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_Double (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 12) e-12))) ((13) (let ((e-13 (vector-ref ext-0 1))) (CoreC-45Hash-u--hashWithSalt_Hashable_PrimType (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 13) e-13))) (else (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 14)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_LazyReason (lambda (arg-0 ext-0) (cond ((equal? ext-0 0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 0)) ((equal? ext-0 1) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1)) (else (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2)))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_NamedConAlt (lambda (arg-0 arg-1) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 csegen-1357 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40MaybeC-32C-36aC-41 csegen-1361 (CoreC-45Hash-u--hashWithSalt_Hashable_ConInfo (CoreC-45Hash-u--hashWithSalt_Hashable_Name arg-0 e-0) e-1) e-2) e-3) e-4))))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_NamedConstAlt (lambda (arg-0 arg-1) (let ((e-0 (car arg-1))) (let ((e-1 (cdr arg-1))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_Constant arg-0 e-0) e-1)))))
(define CoreC-45Hash-u--hash_Hashable_NamedConAlt (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedConAlt (blodwen-toSignedInt 5381 63) ext-0)))
(define CoreC-45Hash-u--hash_Hashable_NamedConstAlt (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedConstAlt (blodwen-toSignedInt 5381 63) ext-0)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (lambda (arg-0 ext-0) (case (vector-ref ext-0 0) ((0) (let ((e-1 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 0) e-1))) ((1) (let ((e-3 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1) e-3))) ((2) (let ((e-5 (vector-ref ext-0 2))) (let ((e-6 (vector-ref ext-0 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2) e-5) e-6)))) ((3) (let ((e-8 (vector-ref ext-0 2))) (let ((e-9 (vector-ref ext-0 3))) (let ((e-10 (vector-ref ext-0 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 3) e-8) e-9) e-10))))) ((4) (let ((e-12 (vector-ref ext-0 2))) (let ((e-13 (vector-ref ext-0 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (csegen-1365) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 4) e-12) e-13)))) ((5) (let ((e-15 (vector-ref ext-0 2))) (let ((e-16 (vector-ref ext-0 3))) (let ((e-17 (vector-ref ext-0 4))) (let ((e-18 (vector-ref ext-0 5))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (csegen-1365) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40MaybeC-32C-36aC-41 csegen-1361 (CoreC-45Hash-u--hashWithSalt_Hashable_ConInfo (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 5) e-15) e-16) e-17) e-18)))))) ((6) (let ((e-21 (vector-ref ext-0 3))) (let ((e-22 (vector-ref ext-0 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 (csegen-1365) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40PrimFnC-32C-36arityC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 6) e-21) e-22)))) ((7) (let ((e-24 (vector-ref ext-0 2))) (let ((e-25 (vector-ref ext-0 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (csegen-1365) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 7) e-24) e-25)))) ((8) (let ((e-27 (vector-ref ext-0 2))) (let ((e-28 (vector-ref ext-0 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_LazyReason (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 8) e-27) e-28)))) ((9) (let ((e-30 (vector-ref ext-0 2))) (let ((e-31 (vector-ref ext-0 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_LazyReason (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 9) e-30) e-31)))) ((10) (let ((e-33 (vector-ref ext-0 2))) (let ((e-34 (vector-ref ext-0 3))) (let ((e-35 (vector-ref ext-0 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40MaybeC-32C-36aC-41 (csegen-1365) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (cons (lambda (arg-4535) (CoreC-45Hash-u--hash_Hashable_NamedConAlt arg-4535)) (lambda (arg-4541) (lambda (arg-4544) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedConAlt arg-4541 arg-4544)))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 10) e-33) e-34) e-35))))) ((11) (let ((e-37 (vector-ref ext-0 2))) (let ((e-38 (vector-ref ext-0 3))) (let ((e-39 (vector-ref ext-0 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40MaybeC-32C-36aC-41 (csegen-1365) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (cons (lambda (arg-4535) (CoreC-45Hash-u--hash_Hashable_NamedConstAlt arg-4535)) (lambda (arg-4541) (lambda (arg-4544) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedConstAlt arg-4541 arg-4544)))) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 11) e-37) e-38) e-39))))) ((12) (let ((e-41 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_Constant (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 12) e-41))) ((13) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 13)) (else (let ((e-44 (vector-ref ext-0 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_String (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 14) e-44))))))
(define CoreC-45Hash-u--hash_Hashable_NamedCExp (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp (blodwen-toSignedInt 5381 63) ext-0)))
(define csegen-1365 (lambda () (cons (lambda (arg-4535) (CoreC-45Hash-u--hash_Hashable_NamedCExp arg-4535)) (lambda (arg-4541) (lambda (arg-4544) (CoreC-45Hash-u--hashWithSalt_Hashable_NamedCExp arg-4541 arg-4544))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40PiInfoC-32C-36tC-41 (lambda (arg-1 arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 0)) ((1) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 1)) ((2) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 2)) (else (let ((e-4 (vector-ref arg-3 1))) (let ((e-2 (cdr arg-1))) ((e-2 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 3)) e-4)))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (lambda (arg-0 ext-0) (AlgebraC-45Semiring-elimSemi csegen-931 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 1) (lambda (eta-0) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-0 2)) ext-0)))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40BinderC-32C-36tyC-41 (lambda (arg-1 arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (let ((e-2 (vector-ref arg-3 2))) (let ((e-3 (vector-ref arg-3 3))) (let ((e-4 (vector-ref arg-3 4))) (let ((e-5 (cdr arg-1))) ((e-5 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40PiInfoC-32C-36tC-41 arg-1 (CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 0) e-2) e-3)) e-4)))))) ((1) (let ((e-7 (vector-ref arg-3 2))) (let ((e-8 (vector-ref arg-3 3))) (let ((e-9 (vector-ref arg-3 4))) (let ((e-2 (cdr arg-1))) ((e-2 (let ((e-3 (cdr arg-1))) ((e-3 (CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 1) e-7)) e-8))) e-9)))))) ((2) (let ((e-12 (vector-ref arg-3 2))) (let ((e-13 (vector-ref arg-3 3))) (let ((e-14 (vector-ref arg-3 4))) (let ((e-2 (cdr arg-1))) ((e-2 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40PiInfoC-32C-36tC-41 arg-1 (CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 2) e-12) e-13)) e-14)))))) ((3) (let ((e-17 (vector-ref arg-3 2))) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (let ((e-2 (cdr arg-1))) ((e-2 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40PiInfoC-32C-36tC-41 arg-1 (CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 3) e-17) e-18)) e-19)))))) ((4) (let ((e-22 (vector-ref arg-3 2))) (let ((e-23 (vector-ref arg-3 3))) (let ((e-24 (vector-ref arg-3 4))) (let ((e-2 (cdr arg-1))) ((e-2 (let ((e-3 (cdr arg-1))) ((e-3 (CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 4) e-22)) e-23))) e-24)))))) (else (let ((e-27 (vector-ref arg-3 2))) (let ((e-28 (vector-ref arg-3 3))) (let ((e-2 (cdr arg-1))) ((e-2 (CoreC-45Hash-u--hashWithSalt_Hashable_RigCount (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-2 5) e-27)) e-28))))))))
(define CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-4 (vector-ref arg-2 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_Nat (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 0) e-4))) ((1) (let ((e-9 (vector-ref arg-2 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 1) e-9))) ((2) (let ((e-13 (vector-ref arg-2 3))) (let ((e-14 (vector-ref arg-2 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40ListC-32C-36aC-41 (csegen-1374) (CoreC-45Hash-u--hashWithSalt_Hashable_Int (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 2) e-13) e-14)))) ((3) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40BinderC-32C-36tyC-41 (csegen-1374) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 3) e-18) e-19)))) ((4) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 4) e-22) e-23)))) ((5) (let ((e-27 (vector-ref arg-2 3))) (let ((e-28 (vector-ref arg-2 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 5) e-27) e-28)))) ((6) (let ((e-32 (vector-ref arg-2 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 6) e-32))) ((7) (let ((e-36 (vector-ref arg-2 3))) (let ((e-37 (vector-ref arg-2 4))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 7) e-36) e-37)))) ((8) (let ((e-41 (vector-ref arg-2 3))) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 8) e-41))) ((9) (let ((e-44 (vector-ref arg-2 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_String (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 9) (CoreC-45TTC-45Primitive-u--show_Show_Constant e-44)))) ((10) (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 10)) (else (let ((e-50 (vector-ref arg-2 2))) (CoreC-45Hash-u--hashWithSalt_Hashable_Name (CoreC-45Hash-u--hashWithSalt_Hashable_Integer arg-1 11) e-50))))))
(define CoreC-45Hash-u--hash_Hashable_C-40TermC-32C-36varsC-41 (lambda (ext-0) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 (blodwen-toSignedInt 5381 63) ext-0)))
(define csegen-1374 (lambda () (cons (lambda (arg-4535) (CoreC-45Hash-u--hash_Hashable_C-40TermC-32C-36varsC-41 arg-4535)) (lambda (arg-4541) (lambda (arg-4544) (CoreC-45Hash-u--hashWithSalt_Hashable_C-40TermC-32C-36varsC-41 arg-4541 arg-4544))))))
(define csegen-1375 (CoreC-45Core-newRef (vector "Core.Normalise.Quote.QVar" ) (blodwen-toSignedInt 0 63)))
(define CoreC-45Value-u--full_HasNames_C-40NHeadC-32C-36freeC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((1) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-3 (vector-ref eta-0 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 1 e-1 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-1 e-2 eta-0)) ext-0))))(else (vector 1 arg-2)))))
(define CoreC-45Value-u--full_HasNames_C-40NFC-32C-36freeC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (vector 1 (vector 0 e-1 e-2 e-3 e-4))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45Value-u--full_HasNames_C-40NHeadC-32C-36freeC-41 arg-1 e-7 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-6 e-5 e-8))))) eff-0) ext-0))))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (let ((e-14 (vector-ref arg-2 5))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-1 e-11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-10 e-5 e-12 e-13 e-14))))) eff-0) ext-0))))))))))) ((3) (let ((e-16 (vector-ref arg-2 1))) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (let ((e-20 (vector-ref arg-2 5))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-1 e-17 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 3 e-16 e-5 e-18 e-19 e-20))))) eff-0) ext-0))))))))))) ((4) (let ((e-22 (vector-ref arg-2 1))) (let ((e-23 (vector-ref arg-2 2))) (let ((e-24 (vector-ref arg-2 3))) (let ((e-25 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Value-u--full_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-24 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Value-u--full_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-25 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 4 e-22 e-23 e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))))) ((5) (let ((e-27 (vector-ref arg-2 1))) (let ((e-28 (vector-ref arg-2 2))) (let ((e-29 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45Value-u--full_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-29 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 5 e-27 e-28 e-5))))) eff-0) ext-0))))))))) ((6) (let ((e-31 (vector-ref arg-2 1))) (let ((e-32 (vector-ref arg-2 2))) (let ((e-33 (vector-ref arg-2 3))) (let ((e-34 (vector-ref arg-2 4))) (vector 1 (vector 6 e-31 e-32 e-33 e-34))))))) ((7) (let ((e-36 (vector-ref arg-2 1))) (let ((e-37 (vector-ref arg-2 2))) (let ((e-38 (vector-ref arg-2 3))) (let ((e-39 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Value-u--full_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-38 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 7 e-36 e-37 e-5 e-39))))) eff-0) ext-0)))))))))) ((8) (let ((e-41 (vector-ref arg-2 1))) (let ((e-42 (vector-ref arg-2 2))) (vector 1 (vector 8 e-41 e-42))))) ((9) (let ((e-44 (vector-ref arg-2 1))) (let ((e-45 (vector-ref arg-2 2))) (vector 1 (vector 9 e-44 e-45))))) (else (let ((e-47 (vector-ref arg-2 1))) (let ((e-48 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-1 e-48 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 10 e-47 e-5))))) eff-0) ext-0)))))))))))
(define CoreC-45Value-u--resolved_HasNames_C-40NHeadC-32C-36freeC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((1) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-3 (vector-ref eta-0 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 1 e-1 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-1 e-2) ext-0))))(else (vector 1 arg-2)))))
(define CoreC-45Value-u--resolved_HasNames_C-40NFC-32C-36freeC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (vector 1 (vector 0 e-1 e-2 e-3 e-4))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45Value-u--resolved_HasNames_C-40NHeadC-32C-36freeC-41 arg-1 e-7 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-6 e-5 e-8))))) eff-0) ext-0))))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (let ((e-14 (vector-ref arg-2 5))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-1 e-11) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-10 e-5 e-12 e-13 e-14))))) eff-0) ext-0))))))))))) ((3) (let ((e-16 (vector-ref arg-2 1))) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (let ((e-20 (vector-ref arg-2 5))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-1 e-17) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 3 e-16 e-5 e-18 e-19 e-20))))) eff-0) ext-0))))))))))) ((4) (let ((e-22 (vector-ref arg-2 1))) (let ((e-23 (vector-ref arg-2 2))) (let ((e-24 (vector-ref arg-2 3))) (let ((e-25 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Value-u--resolved_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-24 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Value-u--resolved_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-25 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 4 e-22 e-23 e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))))) ((5) (let ((e-27 (vector-ref arg-2 1))) (let ((e-28 (vector-ref arg-2 2))) (let ((e-29 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45Value-u--resolved_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-29 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 5 e-27 e-28 e-5))))) eff-0) ext-0))))))))) ((6) (let ((e-31 (vector-ref arg-2 1))) (let ((e-32 (vector-ref arg-2 2))) (let ((e-33 (vector-ref arg-2 3))) (let ((e-34 (vector-ref arg-2 4))) (vector 1 (vector 6 e-31 e-32 e-33 e-34))))))) ((7) (let ((e-36 (vector-ref arg-2 1))) (let ((e-37 (vector-ref arg-2 2))) (let ((e-38 (vector-ref arg-2 3))) (let ((e-39 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Value-u--resolved_HasNames_C-40NFC-32C-36freeC-41 arg-1 e-38 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 7 e-36 e-37 e-5 e-39))))) eff-0) ext-0)))))))))) ((8) (let ((e-41 (vector-ref arg-2 1))) (let ((e-42 (vector-ref arg-2 2))) (vector 1 (vector 8 e-41 e-42))))) ((9) (let ((e-44 (vector-ref arg-2 1))) (let ((e-45 (vector-ref arg-2 2))) (vector 1 (vector 9 e-44 e-45))))) (else (let ((e-47 (vector-ref arg-2 1))) (let ((e-48 (vector-ref arg-2 2))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-1 e-48) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 10 e-47 e-5))))) eff-0) ext-0)))))))))))
(define csegen-1378 (cons (lambda (arg-7719) (lambda (arg-7722) (lambda (eta-0) (CoreC-45Value-u--full_HasNames_C-40NFC-32C-36freeC-41 arg-7719 arg-7722 eta-0)))) (lambda (arg-7729) (lambda (arg-7732) (lambda (eta-0) (CoreC-45Value-u--resolved_HasNames_C-40NFC-32C-36freeC-41 arg-7729 arg-7732 eta-0))))))
(define LibrariesC-45DataC-45ListC-45SizeOf-suc (lambda (arg-3) (+ arg-3 1)))
(define CoreC-45NameC-45Scoped-GenWeakenWeakens (lambda (arg-1) (cons (lambda (nm-4459) (lambda (vars-4460) (((((arg-1 'erased) 'erased) 'erased) 0) (LibrariesC-45DataC-45ListC-45SizeOf-suc 0)))) (lambda (vars-4478) (lambda (ns-4479) ((((arg-1 'erased) 'erased) 'erased) 0))))))
(define LibrariesC-45DataC-45ListC-45SizeOf-C-43 (lambda (arg-3 arg-4) (+ arg-3 arg-4)))
(define DataC-45So-choose (lambda (arg-0) (cond ((equal? arg-0 1) (vector 0 (vector 0 ))) (else (vector 1 (vector 0 ))))))
(define CoreC-45TTC-45Var-locateIsVar (lambda (arg-4 arg-5) (let ((sc0 (DataC-45So-choose (PreludeC-45Types-u--C-60_Ord_Nat arg-4 arg-5)))) (case (vector-ref sc0 0) ((0) (vector 0 (vector 0 ))) (else (vector 1 (vector 0 )))))))
(define CoreC-45TTC-45Var-locateNVar (lambda (arg-4 arg-5) (let ((sc0 (CoreC-45TTC-45Var-locateIsVar arg-5 arg-4))) (case (vector-ref sc0 0) ((0) (vector 0 arg-5)) (else (vector 1 (PreludeC-45Types-prim__integerToNat (- arg-5 arg-4))))))))
(define CoreC-45TTC-45Var-weakenNVar (lambda (arg-4 arg-5) (+ arg-4 arg-5)))
(define CoreC-45TTC-45Var-insertNVarNames (lambda (arg-4 arg-5 arg-6) (let ((sc0 (CoreC-45TTC-45Var-locateNVar arg-4 arg-6))) (case (vector-ref sc0 0) ((0) (let ((e-2 (vector-ref sc0 1))) e-2)) (else (let ((e-5 (vector-ref sc0 1))) (CoreC-45TTC-45Var-weakenNVar (LibrariesC-45DataC-45ListC-45SizeOf-C-43 arg-4 arg-5) e-5)))))))
(define CoreC-45TTC-45Term-insertNames (lambda (arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) (let ((e-2 (vector-ref arg-5 1))) (let ((e-3 (vector-ref arg-5 2))) (let ((e-4 (vector-ref arg-5 3))) (let ((eff-0 (CoreC-45TTC-45Var-insertNVarNames arg-3 arg-4 e-4))) (vector 0 e-2 e-3 eff-0)))))) ((1) (let ((e-7 (vector-ref arg-5 1))) (let ((e-8 (vector-ref arg-5 2))) (let ((e-9 (vector-ref arg-5 3))) (vector 1 e-7 e-8 e-9))))) ((2) (let ((e-11 (vector-ref arg-5 1))) (let ((e-12 (vector-ref arg-5 2))) (let ((e-13 (vector-ref arg-5 3))) (let ((e-14 (vector-ref arg-5 4))) (vector 2 e-11 e-12 e-13 (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45TTC-45Term-insertNames arg-3 arg-4 eta-0)) e-14))))))) ((3) (let ((e-16 (vector-ref arg-5 1))) (let ((e-17 (vector-ref arg-5 2))) (let ((e-18 (vector-ref arg-5 3))) (let ((e-19 (vector-ref arg-5 4))) (vector 3 e-16 e-17 (CoreC-45TTC-45Binder-u--map_Functor_Binder (lambda (eta-0) (CoreC-45TTC-45Term-insertNames arg-3 arg-4 eta-0)) e-18) (CoreC-45TTC-45Term-insertNames (LibrariesC-45DataC-45ListC-45SizeOf-suc arg-3) arg-4 e-19))))))) ((4) (let ((e-21 (vector-ref arg-5 1))) (let ((e-22 (vector-ref arg-5 2))) (let ((e-23 (vector-ref arg-5 3))) (vector 4 e-21 (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-22) (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-23)))))) ((5) (let ((e-25 (vector-ref arg-5 1))) (let ((e-26 (vector-ref arg-5 2))) (let ((e-27 (vector-ref arg-5 3))) (let ((e-28 (vector-ref arg-5 4))) (vector 5 e-25 e-26 (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-27) (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-28))))))) ((6) (let ((e-30 (vector-ref arg-5 1))) (let ((e-31 (vector-ref arg-5 2))) (let ((e-32 (vector-ref arg-5 3))) (vector 6 e-30 e-31 (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-32)))))) ((7) (let ((e-34 (vector-ref arg-5 1))) (let ((e-35 (vector-ref arg-5 2))) (let ((e-36 (vector-ref arg-5 3))) (let ((e-37 (vector-ref arg-5 4))) (vector 7 e-34 e-35 (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-36) (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-37))))))) ((8) (let ((e-39 (vector-ref arg-5 1))) (let ((e-40 (vector-ref arg-5 2))) (let ((e-41 (vector-ref arg-5 3))) (vector 8 e-39 e-40 (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-41)))))) ((9) (let ((e-43 (vector-ref arg-5 1))) (let ((e-44 (vector-ref arg-5 2))) (vector 9 e-43 e-44)))) ((10) (let ((e-46 (vector-ref arg-5 1))) (let ((e-47 (vector-ref arg-5 2))) (case (vector-ref e-47 0) ((1) (vector 10 e-46 (vector 1 ))) ((0) (vector 10 e-46 (vector 0 ))) (else (let ((e-54 (vector-ref e-47 1))) (vector 10 e-46 (vector 2 (CoreC-45TTC-45Term-insertNames arg-3 arg-4 e-54))))))))) (else (let ((e-49 (vector-ref arg-5 1))) (let ((e-50 (vector-ref arg-5 2))) (vector 11 e-49 e-50)))))))
(define CoreC-45TTC-45Term-u--genWeakenNs_GenWeaken_Term (lambda (ext-0 ext-1 ext-2) (CoreC-45TTC-45Term-insertNames ext-0 ext-1 ext-2)))
(define CoreC-45TTC-45Term-WeakenTerm (CoreC-45NameC-45Scoped-GenWeakenWeakens (lambda (outer-4316) (lambda (ns-4317) (lambda (local-4318) (lambda (eta-0) (lambda (eta-1) (lambda (eta-2) (CoreC-45TTC-45Term-u--genWeakenNs_GenWeaken_Term eta-0 eta-1 eta-2)))))))))
(define CoreC-45TTC-45Term-fnType (lambda (arg-0 arg-1 arg-2 arg-3) (vector 3 CoreC-45FC-emptyFC (vector 2 "_" 0) (vector 2 arg-1 AlgebraC-45ZeroOneOmega-u--top_Top_ZeroOneOmega (vector 1 ) arg-2) (let ((sc0 CoreC-45TTC-45Term-WeakenTerm)) (let ((e-1 (car sc0))) (((e-1 'erased) 'erased) arg-3))))))
(define csegen-1385 (lambda (eta-0) (lambda (eta-1) (CoreC-45TTC-45Term-fnType '() CoreC-45FC-emptyFC eta-0 eta-1))))
(define csegen-1411 (vector 11 CoreC-45FC-emptyFC (vector 2 "top" 0)))
(define csegen-1413 (vector 0 CoreC-45FC-emptyFC '() 1))
(define csegen-1501 (lambda (u--b) (lambda (u--a) (lambda (u--func) (lambda (arg-8885) (PreludeC-45TypesC-45List-mapAppend '() u--func arg-8885))))))
(define PreludeC-45Types-listBindOnto (lambda (arg-2 arg-3 arg-4) (if (null? arg-4) (PreludeC-45TypesC-45List-reverse arg-3) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (PreludeC-45Types-listBindOnto arg-2 (PreludeC-45TypesC-45List-reverseOnto arg-3 (arg-2 e-2)) e-3))))))
(define PreludeC-45Types-listBind (lambda (arg-2 arg-3) (PreludeC-45Types-listBindOnto arg-3 '() arg-2)))
(define PreludeC-45Types-u--C-60C-42C-62_Applicative_List (lambda (arg-2 arg-3) (PreludeC-45Types-listBind arg-2 (lambda (u--f) (PreludeC-45TypesC-45List-mapAppend '() u--f arg-3)))))
(define PreludeC-45Types-u--pure_Applicative_List (lambda (arg-1) (cons arg-1 '())))
(define csegen-1509 (vector (vector csegen-1501 (lambda (u--a) (lambda (arg-9931) (PreludeC-45Types-u--pure_Applicative_List arg-9931))) (lambda (u--b) (lambda (u--a) (lambda (arg-9937) (lambda (arg-9944) (PreludeC-45Types-u--C-60C-42C-62_Applicative_List arg-9937 arg-9944)))))) (lambda (u--a) '()) (lambda (u--a) (lambda (arg-10313) (lambda (arg-10316) (PreludeC-45TypesC-45List-tailRecAppend arg-10313 (arg-10316)))))))
(define CoreC-45TTC-45Primitive-u--C-47C-61_Eq_PrimType (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1512 (cons (lambda (arg-676) (lambda (arg-679) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (CoreC-45TTC-45Primitive-u--C-47C-61_Eq_PrimType arg-686 arg-689)))))
(define csegen-1617 (lambda (eta-0) (CoreC-45Core-u--throw_Catchable_Core_Error (vector 61 "Buffer creation failed") eta-0)))
(define csegen-1622 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-223 csegen-223 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-223 csegen-223 arg-686 arg-689)))))
(define PreludeC-45EqOrd-u--C-60C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5) 2)))
(define PreludeC-45EqOrd-u--C-60_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5) 0)))
(define PreludeC-45EqOrd-u--C-62C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5) 0)))
(define PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5) 2)))
(define PreludeC-45EqOrd-u--max_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((sc0 (PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5))) (cond ((equal? sc0 1) arg-4) (else arg-5)))))
(define PreludeC-45EqOrd-u--min_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4 arg-5) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 arg-2 arg-3 arg-4 arg-5))) (cond ((equal? sc0 1) arg-4) (else arg-5)))))
(define csegen-1630 (vector csegen-1622 (lambda (arg-1566) (lambda (arg-1569) (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-231 csegen-231 arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (PreludeC-45EqOrd-u--C-60_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-231 csegen-231 arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-231 csegen-231 arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (PreludeC-45EqOrd-u--C-60C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-231 csegen-231 arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (PreludeC-45EqOrd-u--C-62C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-231 csegen-231 arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (PreludeC-45EqOrd-u--max_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-231 csegen-231 arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (PreludeC-45EqOrd-u--min_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-231 csegen-231 arg-1626 arg-1629)))))
(define csegen-1631 (lambda (eta-0) (lambda (eta-1) (PreludeC-45TypesC-45List-mapMaybeAppend '() eta-0 eta-1))))
(define LibrariesC-45DataC-45Version-n--4336-3065-u--showTag (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (if (null? arg-3) "" (let ((e-2 (unbox arg-3))) (string-append "-" e-2)))))
(define LibrariesC-45DataC-45Version-showVersion (lambda (arg-0 arg-1) (let ((e-0 (car arg-1))) (let ((e-1 (cdr arg-1))) (let ((e-4 (car e-0))) (let ((e-5 (cdr e-0))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (string-append (PreludeC-45Types-u--foldMap_Foldable_List csegen-59 (lambda (eta-0) eta-0) (DataC-45List-intersperse "." (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (PreludeC-45Show-u--show_Show_Nat eta-0)) (cons e-4 (cons e-8 (cons e-9 '())))))) (cond ((equal? arg-0 1) (LibrariesC-45DataC-45Version-n--4336-3065-u--showTag e-4 e-8 e-9 e-1 arg-0)) (else "")))))))))))
(define IdrisPaths-idrisVersion (cons (cons 0 (cons 7 0)) ""))
(define IdrisC-45Version-with--version-3796 (lambda (arg-0) (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (cond ((equal? e-3 "") (cons e-2 '()))(else (cons e-2 (box e-3))))))))
(define IdrisC-45Version-version (IdrisC-45Version-with--version-3796 IdrisPaths-idrisVersion))
(define csegen-1634 (LibrariesC-45DataC-45Version-showVersion 0 IdrisC-45Version-version))
(define PreludeC-45Types-u--C-60C-61_Ord_Nat (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_Integer arg-0 arg-1) 2)))
(define PreludeC-45Types-u--C-62C-61_Ord_Nat (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (PreludeC-45EqOrd-u--compare_Ord_Integer arg-0 arg-1) 0)))
(define PreludeC-45Types-u--min_Ord_Nat (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45Types-u--C-60_Ord_Nat arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-1647 (vector csegen-1032 csegen-1059 (lambda (arg-1576) (lambda (arg-1579) (PreludeC-45Types-u--C-60_Ord_Nat arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (PreludeC-45Types-u--C-62_Ord_Nat arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (PreludeC-45Types-u--C-60C-61_Ord_Nat arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (PreludeC-45Types-u--C-62C-61_Ord_Nat arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (PreludeC-45Types-u--max_Ord_Nat arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (PreludeC-45Types-u--min_Ord_Nat arg-1626 arg-1629)))))
(define LibrariesC-45DataC-45Version-u--C-61C-61_Eq_VersionTokenKind (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0))) ((equal? arg-0 3) (cond ((equal? arg-1 3) 1)(else 0)))(else 0))))
(define LibrariesC-45DataC-45Version-u--C-47C-61_Eq_VersionTokenKind (lambda (arg-0 arg-1) (let ((sc0 (LibrariesC-45DataC-45Version-u--C-61C-61_Eq_VersionTokenKind arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define LibrariesC-45DataC-45Version-u--TokType_TokenKind_VersionTokenKind (lambda (arg-0) (cond ((equal? arg-0 0) (vector "String" )) ((equal? arg-0 2) (vector "Builtin.Unit" )) ((equal? arg-0 3) (vector "Builtin.Unit" )) (else (vector "Prelude.Types.Nat" )))))
(define DataC-45String-stringToNatOrZ (lambda (ext-0) (PreludeC-45Types-prim__integerToNat (cast-string-int ext-0))))
(define LibrariesC-45DataC-45Version-u--tokValue_TokenKind_VersionTokenKind (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) arg-1) ((equal? arg-0 2) (vector 0 )) ((equal? arg-0 3) (vector 0 )) (else (DataC-45String-stringToNatOrZ arg-1)))))
(define csegen-1672 (cons (cons (lambda (arg-676) (lambda (arg-679) (LibrariesC-45DataC-45Version-u--C-61C-61_Eq_VersionTokenKind arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (LibrariesC-45DataC-45Version-u--C-47C-61_Eq_VersionTokenKind arg-686 arg-689)))) (cons (lambda (arg-823) (LibrariesC-45DataC-45Version-u--TokType_TokenKind_VersionTokenKind arg-823)) (lambda (u--kind) (lambda (arg-832) (LibrariesC-45DataC-45Version-u--tokValue_TokenKind_VersionTokenKind u--kind arg-832))))))
(define csegen-1673 (LibrariesC-45TextC-45Parser-match csegen-1672 1))
(define csegen-1674 (LibrariesC-45TextC-45Parser-match csegen-1672 2))
(define csegen-1713 (lambda (arg-0) (PreludeC-45EqOrd-u--C-61C-61_Eq_Char #\. arg-0)))
(define CoreC-45Binary-u--full_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-124C-41 (lambda (arg-1 arg-2 ext-0) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-1 e-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (cons e-5 e-3))))) eff-0) ext-0)))))))))
(define CoreC-45Binary-u--resolved_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-124C-41 (lambda (arg-1 arg-2 ext-0) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-1 e-2) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (cons e-5 e-3))))) eff-0) ext-0)))))))))
(define csegen-1728 (cons (lambda (arg-7719) (lambda (arg-7722) (lambda (eta-0) (CoreC-45Binary-u--full_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-124C-41 arg-7719 arg-7722 eta-0)))) (lambda (arg-7729) (lambda (arg-7732) (lambda (eta-0) (CoreC-45Binary-u--resolved_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32C-40ListC-32C-36aC-41C-41C-124C-41 arg-7729 arg-7732 eta-0))))))
(define CoreC-45Binary-u--full_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32TransformC-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32TransformC-41C-124C-41 (lambda (arg-0 arg-1 ext-0) (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-0 e-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Context-u--full_HasNames_Transform arg-0 e-3 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))))
(define CoreC-45Binary-u--resolved_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32TransformC-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32TransformC-41C-124C-41 (lambda (arg-0 arg-1 ext-0) (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (let ((act-1 ((CoreC-45Context-u--resolved_HasNames_Name arg-0 e-2) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Context-u--resolved_HasNames_Transform arg-0 e-3 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))))
(define csegen-1731 (cons (lambda (arg-7719) (lambda (arg-7722) (lambda (eta-0) (CoreC-45Binary-u--full_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32TransformC-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32TransformC-41C-124C-41 arg-7719 arg-7722 eta-0)))) (lambda (arg-7729) (lambda (arg-7732) (lambda (eta-0) (CoreC-45Binary-u--resolved_HasNames_C-40C-124C-40C-40BuiltinC-46PairC-32NameC-41C-32TransformC-41C-44C-40C-40BuiltinC-46MkPairC-32NameC-41C-32TransformC-41C-124C-41 arg-7729 arg-7732 eta-0))))))
(define csegen-1734 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_Namespace arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_Namespace arg-5542 eta-0)))))
(define csegen-1735 (cons csegen-1734 csegen-1562))
(define csegen-1738 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1735 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1735 arg-5542 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_CG (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 (vector 0 ))) ((equal? e-5 1) (vector 1 (vector 1 ))) ((equal? e-5 2) (vector 1 (vector 2 ))) ((equal? e-5 3) (vector 1 (vector 3 ))) ((equal? e-5 4) (let ((act-2 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_String arg-0 clam-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 8 e-6))))) eff-0) clam-0)))))) ((equal? e-5 5) (vector 1 (vector 4 ))) ((equal? e-5 6) (vector 1 (vector 5 ))) ((equal? e-5 7) (vector 1 (vector 6 ))) ((equal? e-5 8) (vector 1 (vector 7 )))(else (CoreC-45BinaryC-45Prims-corrupt "CG" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--toBuf_TTC_CG (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((1) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) ((2) (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)) ((3) (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0)) ((8) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_String arg-0 e-0) ext-0)))))) ((4) (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0)) ((5) (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0)) ((6) (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0)))))
(define csegen-1741 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_CG arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_CG arg-5542 eta-0)))))
(define csegen-1744 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1559 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1559 arg-5542 eta-0)))))
(define csegen-1745 (cons csegen-1559 csegen-1744))
(define csegen-1749 (cons csegen-1741 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1745 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1745 arg-5542 eta-0))))))
(define csegen-1752 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1749 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1749 arg-5542 eta-0)))))
(define csegen-1755 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_ModuleIdent arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_ModuleIdent arg-5542 eta-0)))))
(define csegen-1756 (cons csegen-44 csegen-1734))
(define csegen-1760 (cons csegen-1755 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1756 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1756 arg-5542 eta-0))))))
(define csegen-1763 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1760 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1760 arg-5542 eta-0)))))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Binary (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Int arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (let ((u--len e-5)) (lambda (eta-0) (let ((act-2 (let ((act-2 (unbox arg-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (clam-0) (let ((sc2 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-toRead e-6) u--len))) (cond ((equal? sc2 1) (let ((act-3 (let ((act-3 ((DataC-45Buffer-newBuffer csegen-82 e-5) clam-0))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (clam-1) (if (null? e-7) (CoreC-45BinaryC-45Prims-corrupt "Binary" clam-1) (let ((e-1 (unbox e-7))) (let ((act-4 (let ((act-4 ((DataC-45Buffer-copyData csegen-82 (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-4 (vector-ref e-6 1))) e-4) 63) e-5 e-1 0) clam-1))) (vector 1 act-4)))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((act-5 (let ((act-5 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-incLoc u--len e-6)))) (vector 1 act-5)))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (vector 1 (vector e-1 0 u--len u--len))))))))))))) eff-0) clam-0)))))) (else (CoreC-45Core-u--throw_Catchable_Core_Error (vector 50 (vector 1 "Binary")) clam-0))))))) eff-0) eta-0))))))))) eff-0) ext-0)))))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_Binary (lambda (arg-0 arg-1) (let ((u--len (let ((e-3 (vector-ref arg-1 3))) e-3))) (let ((u--ilen (blodwen-toSignedInt u--len 63))) (lambda (eta-0) (let ((act-1 ((CoreC-45BinaryC-45Prims-u--toBuf_TTC_Int arg-0 u--ilen) eta-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 (let ((act-2 (unbox arg-0))) (vector 1 act-2)))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (clam-0) (let ((sc2 (PreludeC-45EqOrd-u--C-62C-61_Ord_Integer (LibrariesC-45UtilsC-45Binary-avail e-6) u--len))) (cond ((equal? sc2 1) (let ((act-3 (let ((act-3 ((DataC-45Buffer-copyData csegen-82 (let ((e-0 (vector-ref arg-1 0))) e-0) 0 u--ilen (let ((e-0 (vector-ref e-6 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-6 1))) e-1) 63)) clam-0))) (vector 1 act-3)))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((act-4 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended u--len e-6)))) (vector 1 act-4)))))) (else (let ((act-3 ((CoreC-45BinaryC-45Prims-extendBinary u--len e-6) clam-0))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-4 (let ((act-4 ((DataC-45Buffer-copyData csegen-82 (let ((e-0 (vector-ref arg-1 0))) e-0) 0 u--ilen (let ((e-0 (vector-ref e-7 0))) e-0) (blodwen-toSignedInt (let ((e-1 (vector-ref e-7 1))) e-1) 63)) eta-1))) (vector 1 act-4)))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((act-5 (set-box! arg-0 (LibrariesC-45UtilsC-45Binary-appended u--len e-7)))) (vector 1 act-5)))))))) eff-0) clam-0))))))))))) eff-0) eta-0)))))))))))))
(define csegen-1767 (cons csegen-41 (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_Binary arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_Binary arg-5542 eta-0))))))
(define csegen-1770 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1767 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1767 arg-5542 eta-0)))))
(define csegen-1771 (cons csegen-41 csegen-48))
(define csegen-1774 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1771 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1771 arg-5542 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_PairNames (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector e-5 e-6 e-7))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--toBuf_TTC_PairNames (lambda (arg-0 arg-1 ext-0) (let ((act-1 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 (let ((e-0 (vector-ref arg-1 0))) e-0)) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 (let ((e-1 (vector-ref arg-1 1))) e-1)) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 (let ((e-2 (vector-ref arg-1 2))) e-2)) ext-0)))))))))
(define csegen-1777 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_PairNames arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_PairNames arg-5542 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_RewriteNames (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (cons e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--toBuf_TTC_RewriteNames (lambda (arg-0 arg-1 ext-0) (let ((act-1 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 (let ((e-0 (car arg-1))) e-0)) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 (let ((e-1 (cdr arg-1))) e-1)) ext-0))))))
(define csegen-1780 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_RewriteNames arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_RewriteNames arg-5542 eta-0)))))
(define csegen-1781 (cons csegen-41 csegen-1744))
(define csegen-1784 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1781 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1781 arg-5542 eta-0)))))
(define csegen-1785 (cons csegen-1741 csegen-1559))
(define csegen-1788 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1785 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1785 arg-5542 eta-0)))))
(define CoreC-45TTC-u--fromBuf_TTC_Transform (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45TTC-u--fromBuf_TTC_Name arg-0 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-3 (CoreC-45TTC-u--fromBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-5 arg-0 eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-2 (vector-ref act-3 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (let ((act-4 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 e-5 arg-0 eta-2))) (case (vector-ref act-4 0) ((0) (let ((e-2 (vector-ref act-4 1))) (vector 0 e-2))) (else (let ((e-8 (vector-ref act-4 1))) ((let ((eff-0 (lambda (eta-3) (let ((act-5 (CoreC-45TTC-u--fromBuf_TTC_C-40TermC-32C-36varsC-41 e-5 arg-0 eta-3))) (case (vector-ref act-5 0) ((0) (let ((e-2 (vector-ref act-5 1))) (vector 0 e-2))) (else (let ((e-9 (vector-ref act-5 1))) ((let ((eff-0 (lambda (eta-4) (vector 1 (vector e-5 e-6 e-7 e-8 e-9))))) eff-0) eta-3)))))))) eff-0) eta-2)))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))
(define CoreC-45TTC-u--toBuf_TTC_Transform (lambda (arg-0 arg-1 ext-0) (let ((e-0 (vector-ref arg-1 0))) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((act-1 (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-41 arg-0 e-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((act-2 ((CoreC-45TTC-u--toBuf_TTC_Name arg-0 e-1) ext-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((act-3 ((CoreC-45TTC-u--toBuf_TTC_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-0 arg-0 e-2) ext-0))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((act-4 ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 e-0 arg-0 e-3) ext-0))) (case (vector-ref act-4 0) ((0) (let ((e-8 (vector-ref act-4 1))) (vector 0 e-8))) (else ((CoreC-45TTC-u--toBuf_TTC_C-40TermC-32C-36varsC-41 e-0 arg-0 e-4) ext-0))))))))))))))))))))
(define csegen-1792 (cons csegen-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_Transform arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_Transform arg-5542 eta-0))))))
(define csegen-1795 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1792 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1792 arg-5542 eta-0)))))
(define csegen-1796 (cons csegen-1559 csegen-1559))
(define csegen-1799 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1796 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1796 arg-5542 eta-0)))))
(define csegen-1803 (cons csegen-41 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40ListC-32C-36aC-41 csegen-1799 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40ListC-32C-36aC-41 csegen-1799 arg-5542 eta-0))))))
(define csegen-1806 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1803 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1803 arg-5542 eta-0)))))
(define PreludeC-45EqOrd-u--C-61C-61_Eq_Bool (lambda (arg-0 arg-1) (cond ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0)))(else 0))))
(define PreludeC-45EqOrd-u--C-47C-61_Eq_Bool (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-61C-61_Eq_Bool arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1814 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_Bool arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_Bool arg-686 arg-689)))))
(define CoreC-45NameC-45Namespace-u--C-47C-61_Eq_Namespace (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_Namespace arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1817 (cons (lambda (arg-676) (lambda (arg-679) (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_Namespace arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (CoreC-45NameC-45Namespace-u--C-47C-61_Eq_Namespace arg-686 arg-689)))))
(define csegen-1820 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1814 csegen-1817 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1814 csegen-1817 arg-686 arg-689)))))
(define csegen-1823 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-276 csegen-1820 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-276 csegen-1820 arg-686 arg-689)))))
(define PreludeC-45Types-either (lambda (arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) (let ((e-2 (vector-ref arg-5 1))) ((arg-3) e-2))) (else (let ((e-5 (vector-ref arg-5 1))) ((arg-4) e-5))))))
(define CoreC-45Core-traverseList1 (lambda (arg-2 arg-3) (let ((u--x (let ((e-1 (car arg-3))) e-1))) (let ((u--xs (let ((e-2 (cdr arg-3))) e-2))) (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (vector 1 csegen-181)) (arg-2 u--x) eta-1)) (CoreC-45Core-traverseC-39 arg-2 u--xs '()) eta-0))))))
(define CoreC-45Context-u--full_HasNames_CaseError (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) (lambda (eta-0) (vector 1 (vector 0 )))) ((1) (lambda (eta-0) (vector 1 (vector 1 )))) ((2) (let ((e-0 (vector-ref arg-1 1))) (lambda (clam-0) (let ((e-4 (car e-0))) (let ((e-5 (cdr e-0))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-8 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-9) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 2 (cons e-4 (cons e-6 e-7))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))))))))) ((3) (let ((e-1 (vector-ref arg-1 1))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1304 (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-1 eta-1)) eta-0)))) (else (lambda (eta-0) (vector 1 (vector 4 )))))))
(define CoreC-45Context-u--full_HasNames_Covering (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (vector 1 (vector 0 ))) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 eta-0)) e-0 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-5))))) eff-0) ext-0))))))) (else (let ((e-1 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-1 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-5))))) eff-0) ext-0))))))))))
(define CoreC-45Context-u--full_HasNames_PartialReason (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (vector 1 (vector 0 ))) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-0 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-5))))) eff-0) ext-0))))))) ((2) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-1 eta-2))) eta-0)) e-1 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Context-u--full_HasNames_Name arg-0 e-2 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 2 e-5 e-6))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))) (else (let ((e-3 (vector-ref arg-1 1))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-1 eta-2))) eta-0)) e-3 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 3 e-5))))) eff-0) ext-0))))))))))
(define CoreC-45Context-u--full_HasNames_Warning (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (vector 1 (vector 0 e-0 e-1))))) ((1) (let ((e-2 (vector-ref arg-1 1))) (let ((e-3 (vector-ref arg-1 2))) (let ((e-4 (vector-ref arg-1 3))) (let ((e-5 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-6 (vector-ref eta-1 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 1 e-2 e-3 e-6 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-4 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-5) ext-0)))))) ((2) (let ((e-6 (vector-ref arg-1 1))) (let ((e-7 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 2 e-6 e-5)))))) (CoreC-45Core-traverseList1 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (CoreC-45Core-traverseList1 (lambda (eta-2) (lambda (eta-3) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-2 eta-3))) eta-1)) eta-0)) e-7) ext-0)))) ((3) (let ((e-8 (vector-ref arg-1 1))) (let ((e-9 (vector-ref arg-1 2))) (let ((e-10 (vector-ref arg-1 3))) (let ((e-11 (vector-ref arg-1 4))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 3 e-8 e-9 e-10 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-11 eta-0)) ext-0)))))) ((4) (vector 1 arg-1)) ((5) (let ((e-14 (vector-ref arg-1 1))) (let ((e-15 (vector-ref arg-1 2))) (let ((e-16 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 5 e-14 e-15 e-5)))))) (if (null? e-16) (lambda (eta-0) (vector 1 '())) (let ((e-2 (unbox e-16))) (let ((eff-0 (CoreC-45Core-traversePair (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-2))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1275 eff-0 eta-0))))) ext-0))))) (else (let ((e-17 (vector-ref arg-1 1))) (let ((e-18 (vector-ref arg-1 2))) (vector 1 (vector 6 e-17 e-18))))))))
(define CoreC-45Context-u--full_HasNames_Error (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1294 (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Error arg-0 e-0 eta-0)) ext-0))) ((1) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((e-5 (vector-ref arg-1 5))) (let ((e-6 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-7 (vector-ref eta-2 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 1 e-1 e-2 e-3 e-7 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-3 e-4 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-3 e-5) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-3 e-6) ext-0)))))))) ((2) (let ((e-7 (vector-ref arg-1 1))) (let ((e-8 (vector-ref arg-1 2))) (let ((e-9 (vector-ref arg-1 3))) (let ((e-10 (vector-ref arg-1 4))) (let ((e-11 (vector-ref arg-1 5))) (let ((e-12 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 2 e-7 e-8 e-9 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-9 e-10 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-9 e-11) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-9 e-12) ext-0)))))))) ((3) (let ((e-13 (vector-ref arg-1 1))) (let ((e-14 (vector-ref arg-1 2))) (let ((e-15 (vector-ref arg-1 3))) (let ((e-16 (vector-ref arg-1 4))) (let ((e-17 (vector-ref arg-1 5))) (let ((e-18 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 3 e-13 e-14 e-15 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-16 eta-2)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-17 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-18) ext-0)))))))) ((4) (let ((e-19 (vector-ref arg-1 1))) (let ((e-20 (vector-ref arg-1 2))) (let ((e-21 (vector-ref arg-1 3))) (let ((e-22 (vector-ref arg-1 4))) (let ((e-23 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 4 e-19 e-20 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-21 eta-2)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-22 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-23) ext-0))))))) ((5) (let ((e-24 (vector-ref arg-1 1))) (let ((e-25 (vector-ref arg-1 2))) (let ((e-26 (vector-ref arg-1 3))) (let ((e-27 (vector-ref arg-1 4))) (let ((e-28 (vector-ref arg-1 5))) (let ((e-29 (vector-ref arg-1 6))) (let ((e-30 (vector-ref arg-1 7))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 5 e-24 e-25 e-26 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-26 e-27 eta-3)) eta-2)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-26 e-28) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-26 e-29) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Error e-26 e-30 eta-0)) ext-0))))))))) ((6) (let ((e-31 (vector-ref arg-1 1))) (let ((e-32 (vector-ref arg-1 2))) (let ((e-33 (vector-ref arg-1 3))) (let ((e-34 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 6 e-31 e-32 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-33 eta-1)) eta-0)) (PreludeC-45Types-either (lambda () (lambda (eta-0) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO csegen-1295 (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 eta-0) eta-1)))) (lambda () (lambda (eta-0) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO csegen-1296 (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Error arg-0 eta-0 eta-2)) eta-1)))) e-34) ext-0)))))) ((7) (let ((e-35 (vector-ref arg-1 1))) (let ((e-36 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 7 e-35 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-36 eta-0)) ext-0)))) ((8) (let ((e-37 (vector-ref arg-1 1))) (let ((e-38 (vector-ref arg-1 2))) (let ((e-39 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 8 e-37 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-38 eta-1)) eta-0)) (lambda (eta-0) (vector 1 e-39)) ext-0))))) ((9) (let ((e-40 (vector-ref arg-1 1))) (let ((e-41 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 9 e-40 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-41 eta-0)) ext-0)))) ((10) (let ((e-42 (vector-ref arg-1 1))) (let ((e-43 (vector-ref arg-1 2))) (let ((e-44 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 10 e-42 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-43 eta-1)) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-44 eta-0)) ext-0))))) ((11) (let ((e-45 (vector-ref arg-1 1))) (let ((e-46 (vector-ref arg-1 2))) (let ((e-47 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 11 e-45 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-46 eta-1)) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Covering arg-0 e-47 eta-0)) ext-0))))) ((12) (let ((e-48 (vector-ref arg-1 1))) (let ((e-49 (vector-ref arg-1 2))) (let ((e-50 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 12 e-48 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-49 eta-1)) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_PartialReason arg-0 e-50 eta-0)) ext-0))))) ((13) (let ((e-51 (vector-ref arg-1 1))) (let ((e-52 (vector-ref arg-1 2))) (let ((e-53 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 13 e-51 e-52 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-53 eta-0)) ext-0))))) ((14) (let ((e-54 (vector-ref arg-1 1))) (let ((e-55 (vector-ref arg-1 2))) (let ((e-56 (vector-ref arg-1 3))) (let ((e-57 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 14 e-54 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 e-55 eta-2)) eta-1)) (lambda (eta-1) (vector 1 e-56)) eta-0)) (lambda (eta-0) (vector 1 e-57)) ext-0)))))) ((15) (let ((e-58 (vector-ref arg-1 1))) (let ((e-59 (vector-ref arg-1 2))) (let ((e-60 (vector-ref arg-1 3))) (let ((e-61 (vector-ref arg-1 4))) (let ((e-62 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 15 e-58 e-59 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-60 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-61) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-62) ext-0))))))) ((16) (let ((e-63 (vector-ref arg-1 1))) (let ((e-64 (vector-ref arg-1 2))) (let ((e-65 (vector-ref arg-1 3))) (let ((e-66 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 16 e-63 e-64 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-65 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-66) ext-0)))))) ((17) (let ((e-67 (vector-ref arg-1 1))) (let ((e-68 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 17 e-67 e-5)))))) (CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-68 '()) ext-0)))) ((18) (let ((e-69 (vector-ref arg-1 1))) (let ((e-70 (vector-ref arg-1 2))) (let ((e-71 (vector-ref arg-1 3))) (let ((e-72 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 18 e-69 e-70 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-71 eta-1)) eta-0)) (CoreC-45Core-traverseC-39 (lambda (lamc-0) (lambda (clam-1) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-4 (vector-ref eta-0 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (cons e-2 e-5)))))) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-2 e-3) clam-1))))) e-72 '()) ext-0)))))) ((19) (let ((e-73 (vector-ref arg-1 1))) (let ((e-74 (vector-ref arg-1 2))) (let ((e-75 (vector-ref arg-1 3))) (let ((e-76 (vector-ref arg-1 4))) (let ((e-77 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 19 e-73 e-74 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-75 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-76) eta-0)) (CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 eta-0)) e-77 '()) ext-0))))))) ((20) (let ((e-78 (vector-ref arg-1 1))) (let ((e-79 (vector-ref arg-1 2))) (let ((e-80 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 20 e-78 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-79 eta-1)) eta-0)) (CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-80 '()) ext-0))))) ((21) (let ((e-81 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1297 (PreludeC-45Basics-flip csegen-1298 e-81 (lambda (lamc-0) (lambda (clam-2) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1299 (if (null? e-2) (lambda (eta-1) (vector 1 '())) (let ((e-4 (unbox e-2))) (let ((eff-0 (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-4 eta-1)))) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO csegen-1275 eff-0 eta-1))))) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Error arg-0 e-3 eta-0)) clam-2)))))) ext-0))) ((22) (let ((e-82 (vector-ref arg-1 1))) (let ((e-83 (vector-ref arg-1 2))) (let ((e-84 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 22 e-82 e-83 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-84 eta-0)) ext-0))))) ((23) (let ((e-85 (vector-ref arg-1 1))) (let ((e-86 (vector-ref arg-1 2))) (vector 1 (vector 23 e-85 e-86))))) ((24) (let ((e-87 (vector-ref arg-1 1))) (let ((e-88 (vector-ref arg-1 2))) (let ((e-89 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 24 e-87 e-88 e-5)))))) (if (null? e-89) (lambda (eta-0) (vector 1 '())) (let ((e-2 (unbox e-89))) (let ((eff-0 (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-2 eta-0)))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1275 eff-0 eta-0))))) ext-0))))) ((25) (let ((e-90 (vector-ref arg-1 1))) (let ((e-91 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 25 e-90 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-91 eta-0)) ext-0)))) ((26) (let ((e-92 (vector-ref arg-1 1))) (let ((e-93 (vector-ref arg-1 2))) (vector 1 (vector 26 e-92 e-93))))) ((27) (let ((e-94 (vector-ref arg-1 1))) (let ((e-95 (vector-ref arg-1 2))) (let ((e-96 (vector-ref arg-1 3))) (let ((e-97 (vector-ref arg-1 4))) (let ((e-98 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 27 e-94 e-95 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-96 eta-2)) eta-1)) (CoreC-45Core-traverseC-39 (lambda (eta-1) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-1 eta-2))) e-97 '()) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-98) ext-0))))))) ((28) (let ((e-99 (vector-ref arg-1 1))) (let ((e-100 (vector-ref arg-1 2))) (let ((e-101 (vector-ref arg-1 3))) (let ((e-102 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 28 e-99 e-100 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-101 eta-1)) eta-0)) (PreludeC-45Basics-flip csegen-1298 e-102 (lambda (lamc-0) (lambda (clam-3) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1299 (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-2 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-3) clam-3)))))) ext-0)))))) ((29) (let ((e-103 (vector-ref arg-1 1))) (let ((e-104 (vector-ref arg-1 2))) (let ((e-105 (vector-ref arg-1 3))) (let ((e-106 (vector-ref arg-1 4))) (let ((e-107 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 29 e-103 e-104 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-105 eta-2)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-106 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-107) ext-0))))))) ((30) (let ((e-108 (vector-ref arg-1 1))) (let ((e-109 (vector-ref arg-1 2))) (let ((e-110 (vector-ref arg-1 3))) (let ((e-111 (vector-ref arg-1 4))) (let ((e-112 (vector-ref arg-1 5))) (let ((e-113 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 30 e-108 e-109 e-110 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-110 e-111 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 e-110 e-112) eta-0)) (if (null? e-113) (lambda (eta-0) (vector 1 '())) (let ((e-2 (unbox e-113))) (let ((eff-0 (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Error e-110 e-2 eta-0)))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1275 eff-0 eta-0))))) ext-0)))))))) ((31) (let ((e-114 (vector-ref arg-1 1))) (let ((e-115 (vector-ref arg-1 2))) (let ((e-116 (vector-ref arg-1 3))) (let ((e-117 (vector-ref arg-1 4))) (let ((e-118 (vector-ref arg-1 5))) (let ((e-119 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 31 e-114 e-115 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--full_HasNames_Name arg-0 e-116 eta-3)) eta-2)) (lambda (eta-2) (vector 1 e-117)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-118 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-119) ext-0)))))))) ((32) (let ((e-120 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1300 (CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-1 eta-2))) eta-0)) e-120 '()) ext-0))) ((33) (let ((e-121 (vector-ref arg-1 1))) (let ((e-122 (vector-ref arg-1 2))) (let ((e-123 (vector-ref arg-1 3))) (let ((e-124 (vector-ref arg-1 4))) (let ((e-125 (vector-ref arg-1 5))) (let ((e-126 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 33 e-121 e-122 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-123 eta-3)) eta-2)) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 e-124 eta-2)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-125 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-126) ext-0)))))))) ((34) (let ((e-127 (vector-ref arg-1 1))) (let ((e-128 (vector-ref arg-1 2))) (let ((e-129 (vector-ref arg-1 3))) (let ((e-130 (vector-ref arg-1 4))) (let ((e-131 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 34 e-127 e-128 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-129 eta-2)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-130 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-131) ext-0))))))) ((35) (let ((e-132 (vector-ref arg-1 1))) (let ((e-133 (vector-ref arg-1 2))) (let ((e-134 (vector-ref arg-1 3))) (let ((e-135 (vector-ref arg-1 4))) (let ((e-136 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 35 e-132 e-133 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 e-134 eta-2)) eta-1)) (lambda (eta-1) (vector 1 e-135)) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-136 eta-0)) ext-0))))))) ((36) (let ((e-137 (vector-ref arg-1 1))) (let ((e-138 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 36 e-137 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-138 eta-0)) ext-0)))) ((37) (let ((e-139 (vector-ref arg-1 1))) (let ((e-140 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 37 e-139 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-140 eta-0)) ext-0)))) ((38) (let ((e-141 (vector-ref arg-1 1))) (let ((e-142 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 38 e-141 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-142 eta-0)) ext-0)))) ((39) (let ((e-143 (vector-ref arg-1 1))) (let ((e-144 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 39 e-143 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Name arg-0 e-144 eta-0)) ext-0)))) ((40) (let ((e-145 (vector-ref arg-1 1))) (let ((e-146 (vector-ref arg-1 2))) (let ((e-147 (vector-ref arg-1 3))) (let ((e-148 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 40 e-145 e-146 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-147 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-148) ext-0)))))) ((41) (let ((e-149 (vector-ref arg-1 1))) (let ((e-150 (vector-ref arg-1 2))) (let ((e-151 (vector-ref arg-1 3))) (let ((e-152 (vector-ref arg-1 4))) (let ((e-153 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 41 e-149 e-150 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-151 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-152) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-153) ext-0))))))) ((42) (let ((e-154 (vector-ref arg-1 1))) (let ((e-155 (vector-ref arg-1 2))) (let ((e-156 (vector-ref arg-1 3))) (let ((e-157 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 42 e-154 e-155 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-156 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-157) ext-0)))))) ((43) (let ((e-158 (vector-ref arg-1 1))) (let ((e-159 (vector-ref arg-1 2))) (let ((e-160 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 43 e-158 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-159 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_CaseError arg-0 e-160) ext-0))))) ((44) (let ((e-161 (vector-ref arg-1 1))) (let ((e-162 (vector-ref arg-1 2))) (let ((e-163 (vector-ref arg-1 3))) (let ((e-164 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 44 e-161 e-162 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-163 eta-1)) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-164) ext-0)))))) ((45) (let ((e-165 (vector-ref arg-1 1))) (let ((e-166 (vector-ref arg-1 2))) (let ((e-167 (vector-ref arg-1 3))) (let ((e-168 (vector-ref arg-1 4))) (let ((e-169 (vector-ref arg-1 5))) (let ((e-170 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 45 e-165 e-166 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-167 eta-3)) eta-2)) (lambda (eta-2) (vector 1 e-168)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-169) eta-0)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-170) ext-0)))))))) ((46) (let ((e-171 (vector-ref arg-1 1))) (let ((e-172 (vector-ref arg-1 2))) (vector 1 (vector 46 e-171 e-172))))) ((47) (let ((e-173 (vector-ref arg-1 1))) (let ((e-174 (vector-ref arg-1 2))) (let ((e-175 (vector-ref arg-1 3))) (let ((e-176 (vector-ref arg-1 4))) (let ((e-177 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 47 e-173 e-174 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-175 eta-2)) eta-1)) (CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-176) eta-0)) (lambda (eta-0) (vector 1 e-177)) ext-0))))))) ((48) (let ((e-178 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1301 (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Error arg-0 e-178 eta-0)) ext-0))) ((49) (let ((e-179 (vector-ref arg-1 1))) (let ((e-180 (vector-ref arg-1 2))) (vector 1 (vector 49 e-179 e-180))))) ((50) (let ((e-181 (vector-ref arg-1 1))) (vector 1 (vector 50 e-181)))) ((51) (let ((e-182 (vector-ref arg-1 1))) (let ((e-183 (vector-ref arg-1 2))) (vector 1 (vector 51 e-182 e-183))))) ((52) (let ((e-184 (vector-ref arg-1 1))) (vector 1 (vector 52 e-184)))) ((53) (let ((e-185 (vector-ref arg-1 1))) (vector 1 (vector 53 e-185)))) ((54) (let ((e-186 (vector-ref arg-1 1))) (vector 1 (vector 54 e-186)))) ((55) (let ((e-187 (vector-ref arg-1 1))) (vector 1 (vector 55 e-187)))) ((56) (let ((e-188 (vector-ref arg-1 1))) (let ((e-189 (vector-ref arg-1 2))) (vector 1 (vector 56 e-188 e-189))))) ((57) (let ((e-190 (vector-ref arg-1 1))) (vector 1 (vector 57 e-190)))) ((58) (let ((e-191 (vector-ref arg-1 1))) (let ((e-192 (vector-ref arg-1 2))) (vector 1 (vector 58 e-191 e-192))))) ((59) (let ((e-193 (vector-ref arg-1 1))) (vector 1 (vector 59 e-193)))) ((60) (vector 1 (vector 60 ))) ((61) (let ((e-194 (vector-ref arg-1 1))) (vector 1 (vector 61 e-194)))) ((62) (let ((e-195 (vector-ref arg-1 1))) (vector 1 (vector 62 e-195)))) ((63) (let ((e-196 (vector-ref arg-1 1))) (let ((e-197 (vector-ref arg-1 2))) (vector 1 (vector 63 e-196 e-197))))) ((64) (let ((e-198 (vector-ref arg-1 1))) (let ((e-199 (vector-ref arg-1 2))) (vector 1 (vector 64 e-198 e-199))))) ((65) (let ((e-200 (vector-ref arg-1 1))) (vector 1 (vector 65 e-200)))) ((66) (let ((e-201 (vector-ref arg-1 1))) (vector 1 (vector 66 e-201)))) ((67) (let ((e-202 (vector-ref arg-1 1))) (let ((e-203 (vector-ref arg-1 2))) (let ((e-204 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 67 e-202 e-203 e-5)))))) (CoreC-45Core-traverseList1 (lambda (arg-2) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Error arg-0 arg-2 eta-0))) e-204) ext-0))))) ((68) (let ((e-205 (vector-ref arg-1 1))) (let ((e-206 (vector-ref arg-1 2))) (let ((e-207 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 68 e-205 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-206 eta-1)) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Error arg-0 e-207 eta-0)) ext-0))))) ((69) (let ((e-208 (vector-ref arg-1 1))) (let ((e-209 (vector-ref arg-1 2))) (let ((e-210 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 69 e-208 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-209 eta-1)) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Error arg-0 e-210 eta-0)) ext-0))))) ((70) (let ((e-211 (vector-ref arg-1 1))) (let ((e-212 (vector-ref arg-1 2))) (let ((e-213 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 70 e-211 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-212 eta-1)) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Error arg-0 e-213 eta-0)) ext-0))))) ((71) (let ((e-214 (vector-ref arg-1 1))) (let ((e-215 (vector-ref arg-1 2))) (let ((e-216 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 71 e-214 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 e-215 eta-1)) eta-0)) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Error arg-0 e-216 eta-0)) ext-0))))) ((72) (let ((e-217 (vector-ref arg-1 1))) (let ((e-218 (vector-ref arg-1 2))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1302 (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Error arg-0 e-217 eta-1)) eta-0)) (lambda (eta-0) (vector 1 e-218)) ext-0)))) (else (let ((e-219 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1303 (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Warning arg-0 e-219 eta-0)) ext-0))))))
(define CoreC-45Context-u--resolved_HasNames_CaseError (lambda (arg-0 arg-1) (case (vector-ref arg-1 0) ((0) (lambda (eta-0) (vector 1 (vector 0 )))) ((1) (lambda (eta-0) (vector 1 (vector 1 )))) ((2) (let ((e-0 (vector-ref arg-1 1))) (lambda (clam-0) (let ((e-4 (car e-0))) (let ((e-5 (cdr e-0))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((act-1 (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-8 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-9) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-7 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 2 (cons e-4 (cons e-6 e-7))))))) eff-0) eta-0)))))))) eff-0) clam-0)))))))))))) ((3) (let ((e-1 (vector-ref arg-1 1))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1304 (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-1) eta-0)))) (else (lambda (eta-0) (vector 1 (vector 4 )))))))
(define CoreC-45Context-u--resolved_HasNames_Warning (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (vector 1 (vector 0 e-0 e-1))))) ((1) (let ((e-2 (vector-ref arg-1 1))) (let ((e-3 (vector-ref arg-1 2))) (let ((e-4 (vector-ref arg-1 3))) (let ((e-5 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-6 (vector-ref eta-1 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 1 e-2 e-3 e-6 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-4 eta-1)) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-5) ext-0)))))) ((2) (let ((e-6 (vector-ref arg-1 1))) (let ((e-7 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 2 e-6 e-5)))))) (CoreC-45Core-traverseList1 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (CoreC-45Core-traverseList1 (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-2)) eta-1)) eta-0)) e-7) ext-0)))) ((3) (let ((e-8 (vector-ref arg-1 1))) (let ((e-9 (vector-ref arg-1 2))) (let ((e-10 (vector-ref arg-1 3))) (let ((e-11 (vector-ref arg-1 4))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 3 e-8 e-9 e-10 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-11) ext-0)))))) ((4) (vector 1 arg-1)) ((5) (let ((e-14 (vector-ref arg-1 1))) (let ((e-15 (vector-ref arg-1 2))) (let ((e-16 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 5 e-14 e-15 e-5)))))) (if (null? e-16) (lambda (eta-0) (vector 1 '())) (let ((e-2 (unbox e-16))) (let ((eff-0 (CoreC-45Core-traversePair (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-0)) e-2))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1275 eff-0 eta-0))))) ext-0))))) (else (let ((e-17 (vector-ref arg-1 1))) (let ((e-18 (vector-ref arg-1 2))) (vector 1 (vector 6 e-17 e-18))))))))
(define CoreC-45Context-u--resolved_HasNames_Error (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((0) (let ((e-0 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1294 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-0 eta-0)) ext-0))) ((1) (let ((e-1 (vector-ref arg-1 1))) (let ((e-2 (vector-ref arg-1 2))) (let ((e-3 (vector-ref arg-1 3))) (let ((e-4 (vector-ref arg-1 4))) (let ((e-5 (vector-ref arg-1 5))) (let ((e-6 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-7 (vector-ref eta-2 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 1 e-1 e-2 e-3 e-7 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-3 e-4 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-3 e-5) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-3 e-6) ext-0)))))))) ((2) (let ((e-7 (vector-ref arg-1 1))) (let ((e-8 (vector-ref arg-1 2))) (let ((e-9 (vector-ref arg-1 3))) (let ((e-10 (vector-ref arg-1 4))) (let ((e-11 (vector-ref arg-1 5))) (let ((e-12 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 2 e-7 e-8 e-9 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-9 e-10 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-9 e-11) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-9 e-12) ext-0)))))))) ((3) (let ((e-13 (vector-ref arg-1 1))) (let ((e-14 (vector-ref arg-1 2))) (let ((e-15 (vector-ref arg-1 3))) (let ((e-16 (vector-ref arg-1 4))) (let ((e-17 (vector-ref arg-1 5))) (let ((e-18 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 3 e-13 e-14 e-15 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-16 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-17) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-18) ext-0)))))))) ((4) (let ((e-19 (vector-ref arg-1 1))) (let ((e-20 (vector-ref arg-1 2))) (let ((e-21 (vector-ref arg-1 3))) (let ((e-22 (vector-ref arg-1 4))) (let ((e-23 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 4 e-19 e-20 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-21 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-22) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-23) ext-0))))))) ((5) (let ((e-24 (vector-ref arg-1 1))) (let ((e-25 (vector-ref arg-1 2))) (let ((e-26 (vector-ref arg-1 3))) (let ((e-27 (vector-ref arg-1 4))) (let ((e-28 (vector-ref arg-1 5))) (let ((e-29 (vector-ref arg-1 6))) (let ((e-30 (vector-ref arg-1 7))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 5 e-24 e-25 e-26 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-26 e-27 eta-3)) eta-2)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-26 e-28) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-26 e-29) eta-0)) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Error e-26 e-30 eta-0)) ext-0))))))))) ((6) (let ((e-31 (vector-ref arg-1 1))) (let ((e-32 (vector-ref arg-1 2))) (let ((e-33 (vector-ref arg-1 3))) (let ((e-34 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 6 e-31 e-32 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-33 eta-1)) eta-0)) (PreludeC-45Types-either (lambda () (lambda (eta-0) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO csegen-1295 (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 eta-0) eta-1)))) (lambda () (lambda (eta-0) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO csegen-1296 (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_Error arg-0 eta-0 eta-2)) eta-1)))) e-34) ext-0)))))) ((7) (let ((e-35 (vector-ref arg-1 1))) (let ((e-36 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 7 e-35 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-36) ext-0)))) ((8) (let ((e-37 (vector-ref arg-1 1))) (let ((e-38 (vector-ref arg-1 2))) (let ((e-39 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 8 e-37 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-38) eta-0)) (lambda (eta-0) (vector 1 e-39)) ext-0))))) ((9) (let ((e-40 (vector-ref arg-1 1))) (let ((e-41 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 9 e-40 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-41) ext-0)))) ((10) (let ((e-42 (vector-ref arg-1 1))) (let ((e-43 (vector-ref arg-1 2))) (let ((e-44 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 10 e-42 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-43) eta-0)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-44) ext-0))))) ((11) (let ((e-45 (vector-ref arg-1 1))) (let ((e-46 (vector-ref arg-1 2))) (let ((e-47 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 11 e-45 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-46) eta-0)) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Covering arg-0 e-47 eta-0)) ext-0))))) ((12) (let ((e-48 (vector-ref arg-1 1))) (let ((e-49 (vector-ref arg-1 2))) (let ((e-50 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 12 e-48 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-49) eta-0)) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_PartialReason arg-0 e-50 eta-0)) ext-0))))) ((13) (let ((e-51 (vector-ref arg-1 1))) (let ((e-52 (vector-ref arg-1 2))) (let ((e-53 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 13 e-51 e-52 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-53) ext-0))))) ((14) (let ((e-54 (vector-ref arg-1 1))) (let ((e-55 (vector-ref arg-1 2))) (let ((e-56 (vector-ref arg-1 3))) (let ((e-57 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 14 e-54 e-5 eta-3 eta-4)))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-55) eta-1)) (lambda (eta-1) (vector 1 e-56)) eta-0)) (lambda (eta-0) (vector 1 e-57)) ext-0)))))) ((15) (let ((e-58 (vector-ref arg-1 1))) (let ((e-59 (vector-ref arg-1 2))) (let ((e-60 (vector-ref arg-1 3))) (let ((e-61 (vector-ref arg-1 4))) (let ((e-62 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 15 e-58 e-59 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-60 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-61) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-62) ext-0))))))) ((16) (let ((e-63 (vector-ref arg-1 1))) (let ((e-64 (vector-ref arg-1 2))) (let ((e-65 (vector-ref arg-1 3))) (let ((e-66 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 16 e-63 e-64 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-65 eta-1)) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-66) ext-0)))))) ((17) (let ((e-67 (vector-ref arg-1 1))) (let ((e-68 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 17 e-67 e-5)))))) (CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-0)) e-68 '()) ext-0)))) ((18) (let ((e-69 (vector-ref arg-1 1))) (let ((e-70 (vector-ref arg-1 2))) (let ((e-71 (vector-ref arg-1 3))) (let ((e-72 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 18 e-69 e-70 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-71 eta-1)) eta-0)) (CoreC-45Core-traverseC-39 (lambda (lamc-0) (lambda (clam-1) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-4 (vector-ref eta-0 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (cons e-2 e-5)))))) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-2 e-3) clam-1))))) e-72 '()) ext-0)))))) ((19) (let ((e-73 (vector-ref arg-1 1))) (let ((e-74 (vector-ref arg-1 2))) (let ((e-75 (vector-ref arg-1 3))) (let ((e-76 (vector-ref arg-1 4))) (let ((e-77 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 19 e-73 e-74 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-75 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-76) eta-0)) (CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 eta-0)) e-77 '()) ext-0))))))) ((20) (let ((e-78 (vector-ref arg-1 1))) (let ((e-79 (vector-ref arg-1 2))) (let ((e-80 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 20 e-78 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-79) eta-0)) (CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-0)) e-80 '()) ext-0))))) ((21) (let ((e-81 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1297 (PreludeC-45Basics-flip csegen-1298 e-81 (lambda (lamc-0) (lambda (clam-2) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1299 (if (null? e-2) (lambda (eta-1) (vector 1 '())) (let ((e-4 (unbox e-2))) (let ((eff-0 (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-4))) (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO csegen-1275 eff-0 eta-1))))) eta-0)) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-3 eta-0)) clam-2)))))) ext-0))) ((22) (let ((e-82 (vector-ref arg-1 1))) (let ((e-83 (vector-ref arg-1 2))) (let ((e-84 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 22 e-82 e-83 e-5)))))) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-84 eta-0)) ext-0))))) ((23) (let ((e-85 (vector-ref arg-1 1))) (let ((e-86 (vector-ref arg-1 2))) (vector 1 (vector 23 e-85 e-86))))) ((24) (let ((e-87 (vector-ref arg-1 1))) (let ((e-88 (vector-ref arg-1 2))) (let ((e-89 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 24 e-87 e-88 e-5)))))) (if (null? e-89) (lambda (eta-0) (vector 1 '())) (let ((e-2 (unbox e-89))) (let ((eff-0 (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-2))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1275 eff-0 eta-0))))) ext-0))))) ((25) (let ((e-90 (vector-ref arg-1 1))) (let ((e-91 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 25 e-90 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-91) ext-0)))) ((26) (let ((e-92 (vector-ref arg-1 1))) (let ((e-93 (vector-ref arg-1 2))) (vector 1 (vector 26 e-92 e-93))))) ((27) (let ((e-94 (vector-ref arg-1 1))) (let ((e-95 (vector-ref arg-1 2))) (let ((e-96 (vector-ref arg-1 3))) (let ((e-97 (vector-ref arg-1 4))) (let ((e-98 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 27 e-94 e-95 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-96 eta-2)) eta-1)) (CoreC-45Core-traverseC-39 (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-1)) e-97 '()) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-98) ext-0))))))) ((28) (let ((e-99 (vector-ref arg-1 1))) (let ((e-100 (vector-ref arg-1 2))) (let ((e-101 (vector-ref arg-1 3))) (let ((e-102 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 28 e-99 e-100 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-101 eta-1)) eta-0)) (PreludeC-45Basics-flip csegen-1298 e-102 (lambda (lamc-0) (lambda (clam-3) (let ((e-2 (car lamc-0))) (let ((e-3 (cdr lamc-0))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1299 (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-2) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-3) clam-3)))))) ext-0)))))) ((29) (let ((e-103 (vector-ref arg-1 1))) (let ((e-104 (vector-ref arg-1 2))) (let ((e-105 (vector-ref arg-1 3))) (let ((e-106 (vector-ref arg-1 4))) (let ((e-107 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 29 e-103 e-104 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-105 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-106) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-107) ext-0))))))) ((30) (let ((e-108 (vector-ref arg-1 1))) (let ((e-109 (vector-ref arg-1 2))) (let ((e-110 (vector-ref arg-1 3))) (let ((e-111 (vector-ref arg-1 4))) (let ((e-112 (vector-ref arg-1 5))) (let ((e-113 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 30 e-108 e-109 e-110 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 e-110 e-111 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 e-110 e-112) eta-0)) (if (null? e-113) (lambda (eta-0) (vector 1 '())) (let ((e-2 (unbox e-113))) (let ((eff-0 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Error e-110 e-2 eta-0)))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1275 eff-0 eta-0))))) ext-0)))))))) ((31) (let ((e-114 (vector-ref arg-1 1))) (let ((e-115 (vector-ref arg-1 2))) (let ((e-116 (vector-ref arg-1 3))) (let ((e-117 (vector-ref arg-1 4))) (let ((e-118 (vector-ref arg-1 5))) (let ((e-119 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 31 e-114 e-115 e-5 eta-4 eta-5 eta-6))))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-116) eta-2)) (lambda (eta-2) (vector 1 e-117)) eta-1)) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-118 eta-1)) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-119) ext-0)))))))) ((32) (let ((e-120 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1300 (CoreC-45Core-traverseC-39 (lambda (eta-0) (CoreC-45Core-traversePair (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_Name arg-0 eta-1)) eta-0)) e-120 '()) ext-0))) ((33) (let ((e-121 (vector-ref arg-1 1))) (let ((e-122 (vector-ref arg-1 2))) (let ((e-123 (vector-ref arg-1 3))) (let ((e-124 (vector-ref arg-1 4))) (let ((e-125 (vector-ref arg-1 5))) (let ((e-126 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 33 e-121 e-122 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-123 eta-3)) eta-2)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-124) eta-1)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-125) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-126) ext-0)))))))) ((34) (let ((e-127 (vector-ref arg-1 1))) (let ((e-128 (vector-ref arg-1 2))) (let ((e-129 (vector-ref arg-1 3))) (let ((e-130 (vector-ref arg-1 4))) (let ((e-131 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 34 e-127 e-128 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-129 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-130) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-131) ext-0))))))) ((35) (let ((e-132 (vector-ref arg-1 1))) (let ((e-133 (vector-ref arg-1 2))) (let ((e-134 (vector-ref arg-1 3))) (let ((e-135 (vector-ref arg-1 4))) (let ((e-136 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 35 e-132 e-133 e-5 eta-3 eta-4)))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-134) eta-1)) (lambda (eta-1) (vector 1 e-135)) eta-0)) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-136) ext-0))))))) ((36) (let ((e-137 (vector-ref arg-1 1))) (let ((e-138 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 36 e-137 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-138) ext-0)))) ((37) (let ((e-139 (vector-ref arg-1 1))) (let ((e-140 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 37 e-139 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-140) ext-0)))) ((38) (let ((e-141 (vector-ref arg-1 1))) (let ((e-142 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 38 e-141 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-142) ext-0)))) ((39) (let ((e-143 (vector-ref arg-1 1))) (let ((e-144 (vector-ref arg-1 2))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 39 e-143 e-5)))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-144) ext-0)))) ((40) (let ((e-145 (vector-ref arg-1 1))) (let ((e-146 (vector-ref arg-1 2))) (let ((e-147 (vector-ref arg-1 3))) (let ((e-148 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 40 e-145 e-146 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-147 eta-1)) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-148) ext-0)))))) ((41) (let ((e-149 (vector-ref arg-1 1))) (let ((e-150 (vector-ref arg-1 2))) (let ((e-151 (vector-ref arg-1 3))) (let ((e-152 (vector-ref arg-1 4))) (let ((e-153 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 41 e-149 e-150 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-151 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-152) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-153) ext-0))))))) ((42) (let ((e-154 (vector-ref arg-1 1))) (let ((e-155 (vector-ref arg-1 2))) (let ((e-156 (vector-ref arg-1 3))) (let ((e-157 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 42 e-154 e-155 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-156 eta-1)) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-157) ext-0)))))) ((43) (let ((e-158 (vector-ref arg-1 1))) (let ((e-159 (vector-ref arg-1 2))) (let ((e-160 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 43 e-158 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-159) eta-0)) (CoreC-45Context-u--resolved_HasNames_CaseError arg-0 e-160) ext-0))))) ((44) (let ((e-161 (vector-ref arg-1 1))) (let ((e-162 (vector-ref arg-1 2))) (let ((e-163 (vector-ref arg-1 3))) (let ((e-164 (vector-ref arg-1 4))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 44 e-161 e-162 e-5 eta-2))))))) (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-163 eta-1)) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-164) ext-0)))))) ((45) (let ((e-165 (vector-ref arg-1 1))) (let ((e-166 (vector-ref arg-1 2))) (let ((e-167 (vector-ref arg-1 3))) (let ((e-168 (vector-ref arg-1 4))) (let ((e-169 (vector-ref arg-1 5))) (let ((e-170 (vector-ref arg-1 6))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (CoreC-45Core-C-60C-42C-62 (lambda (eta-2) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-3) (case (vector-ref eta-3 0) ((0) (let ((e-2 (vector-ref eta-3 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-3 1))) (vector 1 (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (vector 45 e-165 e-166 e-5 eta-4 eta-5 eta-6))))))))) (lambda (eta-3) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-167 eta-3)) eta-2)) (lambda (eta-2) (vector 1 e-168)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-169) eta-0)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-170) ext-0)))))))) ((46) (let ((e-171 (vector-ref arg-1 1))) (let ((e-172 (vector-ref arg-1 2))) (vector 1 (vector 46 e-171 e-172))))) ((47) (let ((e-173 (vector-ref arg-1 1))) (let ((e-174 (vector-ref arg-1 2))) (let ((e-175 (vector-ref arg-1 3))) (let ((e-176 (vector-ref arg-1 4))) (let ((e-177 (vector-ref arg-1 5))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (CoreC-45Core-C-60C-42C-62 (lambda (eta-1) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-2) (case (vector-ref eta-2 0) ((0) (let ((e-2 (vector-ref eta-2 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-2 1))) (vector 1 (lambda (eta-3) (lambda (eta-4) (vector 47 e-173 e-174 e-5 eta-3 eta-4)))))))) (lambda (eta-2) (CoreC-45Context-u--resolved_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-0 e-175 eta-2)) eta-1)) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-176) eta-0)) (lambda (eta-0) (vector 1 e-177)) ext-0))))))) ((48) (let ((e-178 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1301 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-178 eta-0)) ext-0))) ((49) (let ((e-179 (vector-ref arg-1 1))) (let ((e-180 (vector-ref arg-1 2))) (vector 1 (vector 49 e-179 e-180))))) ((50) (let ((e-181 (vector-ref arg-1 1))) (vector 1 (vector 50 e-181)))) ((51) (let ((e-182 (vector-ref arg-1 1))) (let ((e-183 (vector-ref arg-1 2))) (vector 1 (vector 51 e-182 e-183))))) ((52) (let ((e-184 (vector-ref arg-1 1))) (vector 1 (vector 52 e-184)))) ((53) (let ((e-185 (vector-ref arg-1 1))) (vector 1 (vector 53 e-185)))) ((54) (let ((e-186 (vector-ref arg-1 1))) (vector 1 (vector 54 e-186)))) ((55) (let ((e-187 (vector-ref arg-1 1))) (vector 1 (vector 55 e-187)))) ((56) (let ((e-188 (vector-ref arg-1 1))) (let ((e-189 (vector-ref arg-1 2))) (vector 1 (vector 56 e-188 e-189))))) ((57) (let ((e-190 (vector-ref arg-1 1))) (vector 1 (vector 57 e-190)))) ((58) (let ((e-191 (vector-ref arg-1 1))) (let ((e-192 (vector-ref arg-1 2))) (vector 1 (vector 58 e-191 e-192))))) ((59) (let ((e-193 (vector-ref arg-1 1))) (vector 1 (vector 59 e-193)))) ((60) (vector 1 (vector 60 ))) ((61) (let ((e-194 (vector-ref arg-1 1))) (vector 1 (vector 61 e-194)))) ((62) (let ((e-195 (vector-ref arg-1 1))) (vector 1 (vector 62 e-195)))) ((63) (let ((e-196 (vector-ref arg-1 1))) (let ((e-197 (vector-ref arg-1 2))) (vector 1 (vector 63 e-196 e-197))))) ((64) (let ((e-198 (vector-ref arg-1 1))) (let ((e-199 (vector-ref arg-1 2))) (vector 1 (vector 64 e-198 e-199))))) ((65) (let ((e-200 (vector-ref arg-1 1))) (vector 1 (vector 65 e-200)))) ((66) (let ((e-201 (vector-ref arg-1 1))) (vector 1 (vector 66 e-201)))) ((67) (let ((e-202 (vector-ref arg-1 1))) (let ((e-203 (vector-ref arg-1 2))) (let ((e-204 (vector-ref arg-1 3))) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (vector 67 e-202 e-203 e-5)))))) (CoreC-45Core-traverseList1 (lambda (arg-2) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Error arg-0 arg-2 eta-0))) e-204) ext-0))))) ((68) (let ((e-205 (vector-ref arg-1 1))) (let ((e-206 (vector-ref arg-1 2))) (let ((e-207 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 68 e-205 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-206) eta-0)) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-207 eta-0)) ext-0))))) ((69) (let ((e-208 (vector-ref arg-1 1))) (let ((e-209 (vector-ref arg-1 2))) (let ((e-210 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 69 e-208 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-209) eta-0)) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-210 eta-0)) ext-0))))) ((70) (let ((e-211 (vector-ref arg-1 1))) (let ((e-212 (vector-ref arg-1 2))) (let ((e-213 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 70 e-211 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-212) eta-0)) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-213 eta-0)) ext-0))))) ((71) (let ((e-214 (vector-ref arg-1 1))) (let ((e-215 (vector-ref arg-1 2))) (let ((e-216 (vector-ref arg-1 3))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO (lambda (eta-1) (case (vector-ref eta-1 0) ((0) (let ((e-2 (vector-ref eta-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-1 1))) (vector 1 (lambda (eta-2) (vector 71 e-214 e-5 eta-2))))))) (CoreC-45Context-u--resolved_HasNames_Name arg-0 e-215) eta-0)) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-216 eta-0)) ext-0))))) ((72) (let ((e-217 (vector-ref arg-1 1))) (let ((e-218 (vector-ref arg-1 2))) (CoreC-45Core-C-60C-42C-62 (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-1302 (lambda (eta-1) (CoreC-45Context-u--resolved_HasNames_Error arg-0 e-217 eta-1)) eta-0)) (lambda (eta-0) (vector 1 e-218)) ext-0)))) (else (let ((e-219 (vector-ref arg-1 1))) (PreludeC-45IO-u--map_Functor_IO csegen-1303 (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Warning arg-0 e-219 eta-0)) ext-0))))))
(define csegen-1827 (cons (lambda (arg-7719) (lambda (arg-7722) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Error arg-7719 arg-7722 eta-0)))) (lambda (arg-7729) (lambda (arg-7732) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Error arg-7729 arg-7732 eta-0))))))
(define csegen-1828 (cons csegen-264 csegen-849))
(define csegen-1832 (cons csegen-65 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1828 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1828 u--d u--x))))))
(define csegen-1833 (cons csegen-65 csegen-495))
(define csegen-1838 (cons csegen-495 csegen-269))
(define csegen-1842 (lambda (eta-0) (Builtin-snd (Builtin-snd eta-0))))
(define LibrariesC-45DataC-45IntMap-treeInsertC-39 (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) (let ((e-2 (vector-ref arg-4 2))) (let ((sc1 (PreludeC-45EqOrd-u--compare_Ord_Int arg-2 e-1))) (cond ((equal? sc1 0) (vector 1 (cons (vector 0 arg-2 arg-3) (cons arg-2 (vector 0 e-1 e-2))))) ((equal? sc1 1) (vector 0 (vector 0 arg-2 arg-3))) (else (vector 1 (cons (vector 0 e-1 e-2) (cons e-1 (vector 0 arg-2 arg-3)))))))))) ((1) (let ((e-5 (vector-ref arg-4 1))) (let ((e-6 (vector-ref arg-4 2))) (let ((e-7 (vector-ref arg-4 3))) (let ((sc1 (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-2 e-6))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45IntMap-treeInsertC-39 arg-2 arg-3 e-5))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-2 e-6 e-7)))) (else (let ((e-8 (vector-ref sc2 1))) (let ((e-10 (car e-8))) (let ((e-9 (cdr e-8))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 0 (vector 2 e-10 e-12 e-13 e-6 e-7))))))))))) (else (let ((sc2 (LibrariesC-45DataC-45IntMap-treeInsertC-39 arg-2 arg-3 e-7))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-5 e-6 e-2)))) (else (let ((e-8 (vector-ref sc2 1))) (let ((e-10 (car e-8))) (let ((e-9 (cdr e-8))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 0 (vector 2 e-5 e-6 e-10 e-12 e-13))))))))))))))))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-11 (vector-ref arg-4 2))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-13 (vector-ref arg-4 4))) (let ((e-14 (vector-ref arg-4 5))) (let ((sc1 (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-2 e-11))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45IntMap-treeInsertC-39 arg-2 arg-3 e-10))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 2 e-2 e-11 e-12 e-13 e-14)))) (else (let ((e-5 (vector-ref sc2 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-8 e-16 e-15) (cons e-11 (vector 1 e-12 e-13 e-14))))))))))))) (else (let ((sc2 (PreludeC-45EqOrd-u--C-60C-61_Ord_Int arg-2 e-13))) (cond ((equal? sc2 1) (let ((sc3 (LibrariesC-45DataC-45IntMap-treeInsertC-39 arg-2 arg-3 e-12))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-10 e-11 e-2 e-13 e-14)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-10 e-11 e-8) (cons e-16 (vector 1 e-15 e-13 e-14))))))))))))) (else (let ((sc3 (LibrariesC-45DataC-45IntMap-treeInsertC-39 arg-2 arg-3 e-14))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-10 e-11 e-12 e-13 e-2)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-10 e-11 e-12) (cons e-13 (vector 1 e-8 e-16 e-15)))))))))))))))))))))))))))
(define LibrariesC-45DataC-45IntMap-treeInsert (lambda (arg-2 arg-3 arg-4) (let ((sc0 (LibrariesC-45DataC-45IntMap-treeInsertC-39 arg-2 arg-3 arg-4))) (case (vector-ref sc0 0) ((0) (let ((e-2 (vector-ref sc0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref sc0 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (vector 1 e-8 e-12 e-13))))))))))))
(define LibrariesC-45DataC-45IntMap-insert (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) (cons 0 (vector 0 arg-1 arg-2)) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (let ((sc1 (LibrariesC-45DataC-45IntMap-treeInsert arg-1 arg-2 e-3))) (case (vector-ref sc1 0) ((0) (let ((e-4 (vector-ref sc1 1))) (cons e-2 e-4))) (else (let ((e-5 (vector-ref sc1 1))) (cons (+ e-2 1) e-5))))))))))
(define LibrariesC-45DataC-45IntMap-insertFrom (lambda (ext-0 ext-1) (PreludeC-45Basics-flip (lambda (eta-0) (lambda (clam-0) (PreludeC-45Types-u--foldl_Foldable_List (lambda (eta-1) (lambda (eta-2) (PreludeC-45Basics-flip (lambda (eta-3) (PreludeC-45Basics-uncurry (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (LibrariesC-45DataC-45IntMap-insert eta-4 eta-5 eta-6)))) eta-3)) eta-1 eta-2))) eta-0 clam-0))) ext-0 ext-1)))
(define LibrariesC-45DataC-45IntMap-n--5358-3210-u--treeToListC-39 (lambda (arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) (let ((e-2 (vector-ref arg-4 2))) (cons (cons e-1 e-2) arg-3)))) ((1) (let ((e-5 (vector-ref arg-4 1))) (let ((e-7 (vector-ref arg-4 3))) (LibrariesC-45DataC-45IntMap-n--5358-3210-u--treeToListC-39 (LibrariesC-45DataC-45IntMap-n--5358-3210-u--treeToListC-39 arg-3 e-7) e-5)))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-14 (vector-ref arg-4 5))) (LibrariesC-45DataC-45IntMap-n--5358-3210-u--treeToListC-39 (LibrariesC-45DataC-45IntMap-n--5358-3210-u--treeToListC-39 (LibrariesC-45DataC-45IntMap-n--5358-3210-u--treeToListC-39 arg-3 e-14) e-12) e-10))))))))
(define LibrariesC-45DataC-45IntMap-treeToList (lambda (ext-0) (LibrariesC-45DataC-45IntMap-n--5358-3210-u--treeToListC-39 '() ext-0)))
(define LibrariesC-45DataC-45IntMap-toList (lambda (arg-1) (if (null? arg-1) '() (let ((e-3 (cdr arg-1))) (LibrariesC-45DataC-45IntMap-treeToList e-3)))))
(define LibrariesC-45DataC-45IntMap-n--5911-3767-u--inserted (lambda (arg-1 arg-2 arg-3) (PreludeC-45Types-listBind (LibrariesC-45DataC-45IntMap-toList arg-1) (lambda (_-0) (let ((e-2 (car _-0))) (let ((e-3 (cdr _-0))) (let ((u--vC-39 ((PreludeC-45Types-maybe (lambda () (lambda (eta-0) eta-0)) (lambda () arg-3) (LibrariesC-45DataC-45IntMap-lookup e-2 arg-2)) e-3))) (PreludeC-45Types-u--pure_Applicative_List (cons e-2 u--vC-39)))))))))
(define LibrariesC-45DataC-45IntMap-mergeWith (lambda (arg-1 arg-2 arg-3) (LibrariesC-45DataC-45IntMap-insertFrom (LibrariesC-45DataC-45IntMap-n--5911-3767-u--inserted arg-3 arg-2 arg-1) arg-2)))
(define LibrariesC-45DataC-45IntMap-merge (lambda (arg-1 ext-0 ext-1) (LibrariesC-45DataC-45IntMap-mergeWith (lambda (eta-0) (lambda (eta-1) ((arg-1 eta-0) eta-1))) ext-0 ext-1)))
(define LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (arg-1 ext-0 ext-1) (LibrariesC-45DataC-45IntMap-merge arg-1 ext-0 ext-1)))
(define LibrariesC-45DataC-45IntMap-empty '())
(define LibrariesC-45DataC-45IntMap-u--neutral_Monoid_C-40IntMapC-32C-36vC-41 (lambda (arg-1) LibrariesC-45DataC-45IntMap-empty))
(define csegen-1845 (cons (lambda (arg-8474) (lambda (arg-8477) (LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) (vector 0 ))) arg-8474 arg-8477))) (LibrariesC-45DataC-45IntMap-u--neutral_Monoid_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) (vector 0 ))))))
(define csegen-1846 (cons csegen-495 csegen-65))
(define PreludeC-45Show-u--showPrec_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-2 (vector-ref arg-4 1))) (PreludeC-45Show-showCon arg-3 "Left" (PreludeC-45Show-showArg (Builtin-fst arg-2) e-2)))) (else (let ((e-5 (vector-ref arg-4 1))) (PreludeC-45Show-showCon arg-3 "Right" (PreludeC-45Show-showArg (Builtin-snd arg-2) e-5)))))))
(define PreludeC-45Show-u--show_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 (lambda (arg-2 arg-3) (PreludeC-45Show-u--showPrec_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 arg-2 (vector 0 ) arg-3)))
(define CompilerC-45VMCode-u--show_Show_Reg (lambda (arg-0) (case (vector-ref arg-0 0) ((0) "RVAL") ((1) (let ((e-0 (vector-ref arg-0 1))) (string-append "v" (PreludeC-45Show-u--show_Show_Int e-0)))) (else "DISCARD"))))
(define csegen-1854 (lambda () (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (csegen-1851) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40ListC-32C-36aC-41 (csegen-1851) u--d u--x))))))
(define csegen-1855 (lambda () (cons (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 csegen-1846 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 csegen-1846 u--d u--x)))) (csegen-1854))))
(define CoreC-45TTC-45Primitive-u--showPrec_Show_Constant (lambda (arg-0 arg-1) (CoreC-45TTC-45Primitive-u--show_Show_Constant arg-1)))
(define csegen-1860 (cons (lambda (u--x) (CoreC-45TTC-45Primitive-u--show_Show_Constant u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TTC-45Primitive-u--showPrec_Show_Constant u--d u--x)))))
(define csegen-1861 (lambda () (cons csegen-1860 (csegen-1854))))
(define CompilerC-45VMCode-u--show_Show_VMInst (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (string-append "DECLARE " (CompilerC-45VMCode-u--show_Show_Reg e-0)))) ((1) "START") ((2) (let ((e-1 (vector-ref arg-0 1))) (let ((e-2 (vector-ref arg-0 2))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-1) (string-append " := " (CompilerC-45VMCode-u--show_Show_Reg e-2)))))) ((3) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (let ((e-5 (vector-ref arg-0 3))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-3) (string-append " := MKCON " (string-append (PreludeC-45Show-u--show_Show_C-40C-40EitherC-32C-36aC-41C-32C-36bC-41 csegen-1846 e-4) (string-append " (" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45VMCode-u--show_Show_Reg eta-0)) e-5)) ")"))))))))) ((4) (let ((e-6 (vector-ref arg-0 1))) (let ((e-7 (vector-ref arg-0 2))) (let ((e-8 (vector-ref arg-0 3))) (let ((e-9 (vector-ref arg-0 4))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-6) (string-append " := MKCLOSURE " (string-append (CoreC-45Name-u--show_Show_Name e-7) (string-append " " (string-append (PreludeC-45Show-u--show_Show_Nat e-8) (string-append " (" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45VMCode-u--show_Show_Reg eta-0)) e-9)) ")")))))))))))) ((5) (let ((e-10 (vector-ref arg-0 1))) (let ((e-11 (vector-ref arg-0 2))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-10) (string-append " := MKCONSTANT " (CoreC-45TTC-45Primitive-u--show_Show_Constant e-11)))))) ((6) (let ((e-12 (vector-ref arg-0 1))) (let ((e-13 (vector-ref arg-0 2))) (let ((e-14 (vector-ref arg-0 3))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-12) (string-append " := " (string-append (CompilerC-45VMCode-u--show_Show_Reg e-13) (string-append " @ " (CompilerC-45VMCode-u--show_Show_Reg e-14))))))))) ((7) (let ((e-15 (vector-ref arg-0 1))) (let ((e-16 (vector-ref arg-0 2))) (let ((e-17 (vector-ref arg-0 3))) (let ((e-18 (vector-ref arg-0 4))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-15) (string-append " := " (string-append (cond ((equal? e-16 1) "TAILCALL ") (else "CALL ")) (string-append (CoreC-45Name-u--show_Show_Name e-17) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45VMCode-u--show_Show_Reg eta-0)) e-18)) ")"))))))))))) ((8) (let ((e-20 (vector-ref arg-0 1))) (let ((e-21 (vector-ref arg-0 2))) (let ((e-22 (vector-ref arg-0 3))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-20) (string-append " := " (string-append "OP " (string-append (CoreC-45TTC-45Primitive-u--show_Show_C-40PrimFnC-32C-36arityC-41 e-21) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45VMCode-u--show_Show_Reg eta-0)) (DataC-45Vect-u--toList_Foldable_C-40VectC-32C-36nC-41 e-22))) ")")))))))))) ((9) (let ((e-23 (vector-ref arg-0 1))) (let ((e-24 (vector-ref arg-0 2))) (let ((e-25 (vector-ref arg-0 3))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-23) (string-append " := " (string-append "EXTPRIM " (string-append (CoreC-45Name-u--show_Show_Name e-24) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45VMCode-u--show_Show_Reg eta-0)) e-25)) ")")))))))))) ((10) (let ((e-26 (vector-ref arg-0 1))) (let ((e-27 (vector-ref arg-0 2))) (let ((e-28 (vector-ref arg-0 3))) (string-append "CASE " (string-append (CompilerC-45VMCode-u--show_Show_Reg e-26) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1855) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1855) u--d u--x)))) e-27) (string-append " {default: " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (csegen-1854) e-28) "}")))))))))) ((11) (let ((e-29 (vector-ref arg-0 1))) (let ((e-30 (vector-ref arg-0 2))) (let ((e-31 (vector-ref arg-0 3))) (string-append "CASE " (string-append (CompilerC-45VMCode-u--show_Show_Reg e-29) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1861) u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (csegen-1861) u--d u--x)))) e-30) (string-append " {default: " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (csegen-1854) e-31) "}")))))))))) ((12) (let ((e-32 (vector-ref arg-0 1))) (let ((e-33 (vector-ref arg-0 2))) (let ((e-34 (vector-ref arg-0 3))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-32) (string-append " := PROJECT(" (string-append (CompilerC-45VMCode-u--show_Show_Reg e-33) (string-append ", " (string-append (PreludeC-45Show-u--show_Show_Int e-34) ")"))))))))) ((13) (let ((e-35 (vector-ref arg-0 1))) (string-append (CompilerC-45VMCode-u--show_Show_Reg e-35) " := NULL"))) (else (let ((e-36 (vector-ref arg-0 1))) (string-append "ERROR " (PreludeC-45Show-u--show_Show_String e-36)))))))
(define CompilerC-45VMCode-u--showPrec_Show_VMInst (lambda (arg-0 arg-1) (CompilerC-45VMCode-u--show_Show_VMInst arg-1)))
(define csegen-1851 (lambda () (cons (lambda (u--x) (CompilerC-45VMCode-u--show_Show_VMInst u--x)) (lambda (u--d) (lambda (u--x) (CompilerC-45VMCode-u--showPrec_Show_VMInst u--d u--x))))))
(define CompilerC-45VMCode-n--9645-3815-u--findConstVarAlt (lambda (arg-0 arg-1 arg-2 arg-3) (let ((e-3 (cdr arg-3))) (PreludeC-45Types-u--foldMap_Foldable_List csegen-57 (lambda (eta-0) (CompilerC-45VMCode-findVars eta-0)) e-3))))
(define CompilerC-45VMCode-n--9645-3769-u--findVarAlt (lambda (arg-0 arg-1 arg-2 arg-3) (let ((e-3 (cdr arg-3))) (PreludeC-45Types-u--foldMap_Foldable_List csegen-57 (lambda (eta-0) (CompilerC-45VMCode-findVars eta-0)) e-3))))
(define CompilerC-45VMCode-findVars (lambda (arg-0) (case (vector-ref arg-0 0) ((2) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref e-0 0) ((1) (let ((e-34 (vector-ref e-0 1))) (cons e-34 '())))(else '())))) ((3) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref e-2 0) ((1) (let ((e-35 (vector-ref e-2 1))) (cons e-35 '())))(else '())))) ((4) (let ((e-5 (vector-ref arg-0 1))) (case (vector-ref e-5 0) ((1) (let ((e-36 (vector-ref e-5 1))) (cons e-36 '())))(else '())))) ((5) (let ((e-9 (vector-ref arg-0 1))) (case (vector-ref e-9 0) ((1) (let ((e-37 (vector-ref e-9 1))) (cons e-37 '())))(else '())))) ((6) (let ((e-11 (vector-ref arg-0 1))) (case (vector-ref e-11 0) ((1) (let ((e-38 (vector-ref e-11 1))) (cons e-38 '())))(else '())))) ((7) (let ((e-14 (vector-ref arg-0 1))) (case (vector-ref e-14 0) ((1) (let ((e-39 (vector-ref e-14 1))) (cons e-39 '())))(else '())))) ((8) (let ((e-19 (vector-ref arg-0 1))) (case (vector-ref e-19 0) ((1) (let ((e-40 (vector-ref e-19 1))) (cons e-40 '())))(else '())))) ((9) (let ((e-22 (vector-ref arg-0 1))) (case (vector-ref e-22 0) ((1) (let ((e-41 (vector-ref e-22 1))) (cons e-41 '())))(else '())))) ((10) (let ((e-25 (vector-ref arg-0 1))) (let ((e-26 (vector-ref arg-0 2))) (let ((e-27 (vector-ref arg-0 3))) (PreludeC-45TypesC-45List-tailRecAppend (PreludeC-45Types-u--foldMap_Foldable_List csegen-57 (lambda (eta-0) (CompilerC-45VMCode-n--9645-3769-u--findVarAlt e-25 e-27 e-26 eta-0)) e-26) (DataC-45Maybe-fromMaybe (lambda () '()) (PreludeC-45Types-u--map_Functor_Maybe (csegen-1865) e-27))))))) ((11) (let ((e-28 (vector-ref arg-0 1))) (let ((e-29 (vector-ref arg-0 2))) (let ((e-30 (vector-ref arg-0 3))) (PreludeC-45TypesC-45List-tailRecAppend (PreludeC-45Types-u--foldMap_Foldable_List csegen-57 (lambda (eta-0) (CompilerC-45VMCode-n--9645-3815-u--findConstVarAlt e-28 e-30 e-29 eta-0)) e-29) (DataC-45Maybe-fromMaybe (lambda () '()) (PreludeC-45Types-u--map_Functor_Maybe (csegen-1865) e-30))))))) ((12) (let ((e-31 (vector-ref arg-0 1))) (case (vector-ref e-31 0) ((1) (let ((e-42 (vector-ref e-31 1))) (cons e-42 '())))(else '()))))(else '()))))
(define csegen-1865 (lambda () (lambda (eta-0) (PreludeC-45Types-u--foldMap_Foldable_List csegen-57 (lambda (eta-1) (CompilerC-45VMCode-findVars eta-1)) eta-0))))
(define LibrariesC-45DataC-45IntMap-singleton (lambda (arg-1 arg-2) (LibrariesC-45DataC-45IntMap-insert arg-1 arg-2 LibrariesC-45DataC-45IntMap-empty)))
(define CompilerC-45VMCode-collectReg (lambda (arg-0) (case (vector-ref arg-0 0) ((1) (let ((e-0 (vector-ref arg-0 1))) (LibrariesC-45DataC-45IntMap-singleton e-0 (vector 0 ))))(else LibrariesC-45DataC-45IntMap-empty))))
(define DataC-45Vect-u--foldl_Foldable_C-40VectC-32C-36nC-41 (lambda (arg-3 arg-4 arg-5) (if (null? arg-5) arg-4 (let ((e-3 (car arg-5))) (let ((e-4 (cdr arg-5))) (DataC-45Vect-u--foldl_Foldable_C-40VectC-32C-36nC-41 arg-3 ((arg-3 arg-4) e-3) e-4))))))
(define DataC-45Vect-u--foldMap_Foldable_C-40VectC-32C-36nC-41 (lambda (arg-3 arg-4 ext-0) (DataC-45Vect-u--foldl_Foldable_C-40VectC-32C-36nC-41 (lambda (u--acc) (lambda (u--elem) (let ((e-1 (car arg-3))) ((e-1 u--acc) (arg-4 u--elem))))) (let ((e-2 (cdr arg-3))) e-2) ext-0)))
(define csegen-1867 (lambda () (lambda (eta-0) (PreludeC-45Types-u--foldMap_Foldable_List csegen-1845 (lambda (eta-1) (CompilerC-45VMCode-collectUsed eta-1)) eta-0))))
(define CompilerC-45VMCode-collectUsed (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (CompilerC-45VMCode-collectReg e-0))) ((1) LibrariesC-45DataC-45IntMap-empty) ((2) (let ((e-2 (vector-ref arg-0 2))) (CompilerC-45VMCode-collectReg e-2))) ((3) (let ((e-5 (vector-ref arg-0 3))) (PreludeC-45Types-u--foldMap_Foldable_List csegen-1845 (lambda (eta-0) (CompilerC-45VMCode-collectReg eta-0)) e-5))) ((4) (let ((e-9 (vector-ref arg-0 4))) (PreludeC-45Types-u--foldMap_Foldable_List csegen-1845 (lambda (eta-0) (CompilerC-45VMCode-collectReg eta-0)) e-9))) ((5) LibrariesC-45DataC-45IntMap-empty) ((6) (let ((e-13 (vector-ref arg-0 2))) (let ((e-14 (vector-ref arg-0 3))) (LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) (vector 0 ))) (CompilerC-45VMCode-collectReg e-13) (CompilerC-45VMCode-collectReg e-14))))) ((7) (let ((e-18 (vector-ref arg-0 4))) (PreludeC-45Types-u--foldMap_Foldable_List csegen-1845 (lambda (eta-0) (CompilerC-45VMCode-collectReg eta-0)) e-18))) ((8) (let ((e-22 (vector-ref arg-0 3))) (DataC-45Vect-u--foldMap_Foldable_C-40VectC-32C-36nC-41 csegen-1845 (lambda (eta-0) (CompilerC-45VMCode-collectReg eta-0)) e-22))) ((9) (let ((e-25 (vector-ref arg-0 3))) (PreludeC-45Types-u--foldMap_Foldable_List csegen-1845 (lambda (eta-0) (CompilerC-45VMCode-collectReg eta-0)) e-25))) ((10) (let ((e-26 (vector-ref arg-0 1))) (let ((e-27 (vector-ref arg-0 2))) (let ((e-28 (vector-ref arg-0 3))) (LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) (vector 0 ))) (LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) (vector 0 ))) (CompilerC-45VMCode-collectReg e-26) (PreludeC-45Types-u--foldMap_Foldable_List csegen-1845 (csegen-1866) e-27)) (PreludeC-45Types-maybe (lambda () LibrariesC-45DataC-45IntMap-empty) (lambda () (csegen-1867)) e-28)))))) ((11) (let ((e-29 (vector-ref arg-0 1))) (let ((e-30 (vector-ref arg-0 2))) (let ((e-31 (vector-ref arg-0 3))) (LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) (vector 0 ))) (LibrariesC-45DataC-45IntMap-u--C-60C-43C-62_Semigroup_C-40IntMapC-32C-36vC-41 (lambda (eta-0) (lambda (eta-1) (vector 0 ))) (CompilerC-45VMCode-collectReg e-29) (PreludeC-45Types-u--foldMap_Foldable_List csegen-1845 (csegen-1866) e-30)) (PreludeC-45Types-maybe (lambda () LibrariesC-45DataC-45IntMap-empty) (lambda () (csegen-1867)) e-31)))))) ((12) (let ((e-33 (vector-ref arg-0 2))) (CompilerC-45VMCode-collectReg e-33))) ((13) LibrariesC-45DataC-45IntMap-empty) (else LibrariesC-45DataC-45IntMap-empty))))
(define csegen-1866 (lambda () (lambda (eta-0) (PreludeC-45Types-u--foldMap_Foldable_List csegen-1845 (lambda (eta-1) (CompilerC-45VMCode-collectUsed eta-1)) (Builtin-snd eta-0)))))
(define csegen-1871 (lambda (eta-0) (string-append " " (CoreC-45TTC-45Term-u--show_Show_LazyReason eta-0))))
(define CompilerC-45ANF-showLazy (lambda (ext-0) (PreludeC-45Types-maybe (lambda () "") (lambda () csegen-1871) ext-0)))
(define DataC-45Vect-u--map_Functor_C-40VectC-32C-36nC-41 (lambda (arg-3 arg-4) (if (null? arg-4) '() (let ((e-3 (car arg-4))) (let ((e-4 (cdr arg-4))) (cons (arg-3 e-3) (DataC-45Vect-u--map_Functor_C-40VectC-32C-36nC-41 arg-3 e-4)))))))
(define CompilerC-45ANF-n--9025-3102-u--showArg (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5) (string-append "v" (PreludeC-45Show-u--show_Show_Int arg-5))))
(define CompilerC-45ANF-u--show_Show_AConAlt (lambda (arg-0) (let ((e-0 (vector-ref arg-0 0))) (let ((e-1 (vector-ref arg-0 1))) (let ((e-2 (vector-ref arg-0 2))) (let ((e-3 (vector-ref arg-0 3))) (let ((e-4 (vector-ref arg-0 4))) (string-append "%conalt " (string-append (CoreC-45Name-u--show_Show_Name e-0) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45ANF-n--9025-3102-u--showArg e-1 e-4 e-3 e-2 e-0 eta-0)) e-3)) (string-append ") => " (CompilerC-45ANF-u--show_Show_ANF e-4)))))))))))))
(define CompilerC-45ANF-u--show_Show_AConstAlt (lambda (arg-0) (let ((e-0 (car arg-0))) (let ((e-1 (cdr arg-0))) (string-append "%constalt(" (string-append (CoreC-45TTC-45Primitive-u--show_Show_Constant e-0) (string-append ") => " (CompilerC-45ANF-u--show_Show_ANF e-1))))))))
(define CompilerC-45ANF-u--show_Show_AVar (lambda (arg-0) (if (null? arg-0) "[__]" (let ((e-0 (unbox arg-0))) (string-append "v" (PreludeC-45Show-u--show_Show_Int e-0))))))
(define CompilerC-45ANF-u--show_Show_ANF (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-1 (vector-ref arg-0 2))) (CompilerC-45ANF-u--show_Show_AVar e-1))) ((1) (let ((e-3 (vector-ref arg-0 2))) (let ((e-4 (vector-ref arg-0 3))) (let ((e-5 (vector-ref arg-0 4))) (string-append (CoreC-45Name-u--show_Show_Name e-4) (string-append (CompilerC-45ANF-showLazy e-3) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45ANF-u--show_Show_AVar eta-0)) e-5)) ")")))))))) ((2) (let ((e-7 (vector-ref arg-0 2))) (let ((e-8 (vector-ref arg-0 3))) (let ((e-9 (vector-ref arg-0 4))) (string-append "<" (string-append (CoreC-45Name-u--show_Show_Name e-7) (string-append " underapp " (string-append (PreludeC-45Show-u--show_Show_Nat e-8) (string-append ">(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45ANF-u--show_Show_AVar eta-0)) e-9)) ")")))))))))) ((3) (let ((e-11 (vector-ref arg-0 2))) (let ((e-12 (vector-ref arg-0 3))) (let ((e-13 (vector-ref arg-0 4))) (string-append (CompilerC-45ANF-u--show_Show_AVar e-12) (string-append (CompilerC-45ANF-showLazy e-11) (string-append " @ (" (string-append (CompilerC-45ANF-u--show_Show_AVar e-13) ")")))))))) ((4) (let ((e-15 (vector-ref arg-0 2))) (let ((e-16 (vector-ref arg-0 3))) (let ((e-17 (vector-ref arg-0 4))) (string-append "%let v" (string-append (PreludeC-45Show-u--show_Show_Int e-15) (string-append " = (" (string-append (CompilerC-45ANF-u--show_Show_ANF e-16) (string-append ") in (" (string-append (CompilerC-45ANF-u--show_Show_ANF e-17) ")")))))))))) ((5) (let ((e-19 (vector-ref arg-0 2))) (let ((e-22 (vector-ref arg-0 5))) (string-append "%con " (string-append (CoreC-45Name-u--show_Show_Name e-19) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45ANF-u--show_Show_AVar eta-0)) e-22)) ")"))))))) ((6) (let ((e-25 (vector-ref arg-0 2))) (let ((e-26 (vector-ref arg-0 3))) (let ((e-27 (vector-ref arg-0 4))) (string-append "%op " (string-append (CoreC-45TTC-45Primitive-u--show_Show_C-40PrimFnC-32C-36arityC-41 e-26) (string-append (CompilerC-45ANF-showLazy e-25) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (DataC-45Vect-u--toList_Foldable_C-40VectC-32C-36nC-41 (DataC-45Vect-u--map_Functor_C-40VectC-32C-36nC-41 (lambda (eta-0) (CompilerC-45ANF-u--show_Show_AVar eta-0)) e-27))) ")"))))))))) ((7) (let ((e-29 (vector-ref arg-0 2))) (let ((e-30 (vector-ref arg-0 3))) (let ((e-31 (vector-ref arg-0 4))) (string-append "%extprim " (string-append (CoreC-45Name-u--show_Show_Name e-30) (string-append (CompilerC-45ANF-showLazy e-29) (string-append "(" (string-append (CoreC-45NameC-45Namespace-showSep ", " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45ANF-u--show_Show_AVar eta-0)) e-31)) ")"))))))))) ((8) (let ((e-33 (vector-ref arg-0 2))) (let ((e-34 (vector-ref arg-0 3))) (let ((e-35 (vector-ref arg-0 4))) (string-append "%case " (string-append (CompilerC-45ANF-u--show_Show_AVar e-33) (string-append " of { " (string-append (CoreC-45NameC-45Namespace-showSep "| " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45ANF-u--show_Show_AConAlt eta-0)) e-34)) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (csegen-1870) e-35) " }")))))))))) ((9) (let ((e-37 (vector-ref arg-0 2))) (let ((e-38 (vector-ref arg-0 3))) (let ((e-39 (vector-ref arg-0 4))) (string-append "%case " (string-append (CompilerC-45ANF-u--show_Show_AVar e-37) (string-append " of { " (string-append (CoreC-45NameC-45Namespace-showSep "| " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CompilerC-45ANF-u--show_Show_AConstAlt eta-0)) e-38)) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 (csegen-1870) e-39) " }")))))))))) ((10) (let ((e-41 (vector-ref arg-0 2))) (CoreC-45TTC-45Primitive-u--show_Show_Constant e-41))) ((11) "___") (else (let ((e-44 (vector-ref arg-0 2))) (string-append "%CRASH(" (string-append (PreludeC-45Show-u--show_Show_String e-44) ")")))))))
(define CompilerC-45ANF-u--showPrec_Show_ANF (lambda (arg-0 arg-1) (CompilerC-45ANF-u--show_Show_ANF arg-1)))
(define csegen-1870 (lambda () (cons (lambda (u--x) (CompilerC-45ANF-u--show_Show_ANF u--x)) (lambda (u--d) (lambda (u--x) (CompilerC-45ANF-u--showPrec_Show_ANF u--d u--x))))))
(define CoreC-45Name-with--userNameEq-11468 (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (box (vector 0 ))) (else '()))))
(define CoreC-45Name-with--userNameEq-11493 (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (box (vector 0 ))) (else '()))))
(define CoreC-45Name-userNameEq (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-2 (vector-ref arg-1 1))) (CoreC-45Name-with--userNameEq-11468 e-0 e-2 (DecidableC-45Equality-u--decEq_DecEq_String e-0 e-2))))(else '())))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-3 (vector-ref arg-1 1))) (CoreC-45Name-with--userNameEq-11493 e-1 e-3 (DecidableC-45Equality-u--decEq_DecEq_String e-1 e-3))))(else '())))) ((2) (case (vector-ref arg-1 0) ((2) (box (vector 0 )))(else '())))(else '()))))
(define PreludeC-45Basics-irrelevantEq (vector 0 ))
(define ControlC-45Function-biinj (cons PreludeC-45Basics-irrelevantEq PreludeC-45Basics-irrelevantEq))
(define DecidableC-45EqualityC-45Core-decEqCong (lambda (arg-6) (case (vector-ref arg-6 0) ((0) (vector 0 (vector 0 ))) (else (let ((e-3 (vector-ref arg-6 1))) (vector 1 (lambda (u--c) (e-3 PreludeC-45Basics-irrelevantEq))))))))
(define DecidableC-45EqualityC-45Core-decEqCong2 (lambda (arg-9 arg-10) (case (vector-ref arg-9 0) ((0) (DecidableC-45EqualityC-45Core-decEqCong (arg-10))) (else (let ((e-3 (vector-ref arg-9 1))) (vector 1 (lambda (u--c) (let ((sc1 ControlC-45Function-biinj)) (e-3 (vector 0 ))))))))))
(define DecidableC-45Equality-u--decEq_DecEq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (lambda (arg-2 arg-3 arg-4) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (let ((e-6 (car arg-4))) (let ((e-7 (cdr arg-4))) (DecidableC-45EqualityC-45Core-decEqCong2 (((Builtin-fst arg-2) e-2) e-6) (lambda () (((Builtin-snd arg-2) e-3) e-7)))))))))
(define PreludeC-45Uninhabited-void (lambda (ext-0) (display "Error: Executed 'void'")))
(define PreludeC-45Uninhabited-absurd (lambda (arg-2 arg-3) (PreludeC-45Uninhabited-void 'erased)))
(define DataC-45List-u--uninhabited_Uninhabited_C-40C-124C-40C-40BuiltinC-46C-40C-61C-61C-61C-41C-32C-40C-40C-58C-58C-32C-36xC-41C-32C-36xsC-41C-41C-32NilC-41C-44C-40C-40BuiltinC-46C-40C-126C-61C-126C-41C-32C-40C-40C-58C-58C-32C-36xC-41C-32C-36xsC-41C-41C-32NilC-41C-124C-41 (lambda (arg-0) (blodwen-error-quit "No clauses")))
(define DataC-45List-u--uninhabited_Uninhabited_C-40C-124C-40C-40BuiltinC-46C-40C-61C-61C-61C-41C-32NilC-41C-32C-40C-40C-58C-58C-32C-36xC-41C-32C-36xsC-41C-41C-44C-40C-40BuiltinC-46C-40C-126C-61C-126C-41C-32NilC-41C-32C-40C-40C-58C-58C-32C-36xC-41C-32C-36xsC-41C-41C-124C-41 (lambda (arg-0) (blodwen-error-quit "No clauses")))
(define DecidableC-45Equality-u--decEq_DecEq_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-2) (if (null? arg-3) (vector 0 (vector 0 )) (vector 1 (lambda (eta-0) (PreludeC-45Uninhabited-absurd (lambda (eta-1) (DataC-45List-u--uninhabited_Uninhabited_C-40C-124C-40C-40BuiltinC-46C-40C-61C-61C-61C-41C-32NilC-41C-32C-40C-40C-58C-58C-32C-36xC-41C-32C-36xsC-41C-41C-44C-40C-40BuiltinC-46C-40C-126C-61C-126C-41C-32NilC-41C-32C-40C-40C-58C-58C-32C-36xC-41C-32C-36xsC-41C-41C-124C-41 eta-1)) eta-0)))) (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (if (null? arg-3) (vector 1 (lambda (eta-0) (PreludeC-45Uninhabited-absurd (lambda (eta-1) (DataC-45List-u--uninhabited_Uninhabited_C-40C-124C-40C-40BuiltinC-46C-40C-61C-61C-61C-41C-32C-40C-40C-58C-58C-32C-36xC-41C-32C-36xsC-41C-41C-32NilC-41C-44C-40C-40BuiltinC-46C-40C-126C-61C-126C-41C-32C-40C-40C-58C-58C-32C-36xC-41C-32C-36xsC-41C-41C-32NilC-41C-124C-41 eta-1)) eta-0))) (let ((e-10 (car arg-3))) (let ((e-11 (cdr arg-3))) (DecidableC-45EqualityC-45Core-decEqCong2 ((arg-1 e-2) e-10) (lambda () (DecidableC-45Equality-u--decEq_DecEq_C-40ListC-32C-36aC-41 arg-1 e-3 e-11)))))))))))
(define CoreC-45NameC-45Namespace-mkNSInjective (lambda (arg-2) (vector 0 )))
(define CoreC-45NameC-45Namespace-with--decEq-8933 (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((1) (let ((e-1 (vector-ref arg-2 1))) (vector 1 (lambda (eta-0) (e-1 (CoreC-45NameC-45Namespace-mkNSInjective eta-0)))))) (else (vector 0 (vector 0 ))))))
(define CoreC-45NameC-45Namespace-u--decEq_DecEq_Namespace (lambda (arg-0 arg-1) (CoreC-45NameC-45Namespace-with--decEq-8933 arg-0 arg-1 (DecidableC-45Equality-u--decEq_DecEq_C-40ListC-32C-36aC-41 csegen-511 arg-0 arg-1))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11551 (lambda (arg-0 arg-1 arg-2 arg-3) (if (null? arg-2) '() (box (vector 0 )))))
(define CoreC-45Name-with--nameEq-11540 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-2 0) ((0) (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11551 arg-4 arg-3 (CoreC-45Name-nameEq arg-3 arg-4) arg-0)) (else '()))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11605 (lambda (arg-0 arg-1 arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (box (vector 0 ))) (else '()))))
(define CoreC-45Name-with--nameEq-11590 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-2 0) ((0) (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11605 arg-4 arg-3 (DecidableC-45Equality-u--decEq_DecEq_Int arg-3 arg-4) arg-0)) (else '()))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11641 (lambda (arg-0 arg-1 arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (box (vector 0 ))) (else '()))))
(define CoreC-45Name-with--nameEq-11630 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (if (null? arg-2) '() (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11641 arg-4 arg-3 (DecidableC-45Equality-u--decEq_DecEq_Int arg-3 arg-4) arg-0))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11680 (lambda (arg-0 arg-1 arg-2 arg-3) (if (null? arg-2) '() (box (vector 0 )))))
(define CoreC-45Name-with--nameEq-11669 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-2 0) ((0) (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11680 arg-4 arg-3 (CoreC-45Name-nameEq arg-3 arg-4) arg-0)) (else '()))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11733 (lambda (arg-0 arg-1 arg-2 arg-3) (if (null? arg-2) '() (box (vector 0 )))))
(define CoreC-45Name-with--nameEq-11711 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-2 0) ((1) '()) (else (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11733 arg-4 arg-3 (CoreC-45Name-nameEq arg-3 arg-4) arg-0)))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11772 (lambda (arg-0 arg-1 arg-2 arg-3) (case (vector-ref arg-2 0) ((1) '()) (else (box (vector 0 ))))))
(define CoreC-45Name-with--nameEq-11753 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-2 0) ((1) '()) (else (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11772 arg-4 arg-3 (DecidableC-45Equality-u--decEq_DecEq_Int arg-3 arg-4) arg-0)))))
(define CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11816 (lambda (arg-0 arg-1 arg-2 arg-3) (case (vector-ref arg-2 0) ((1) '()) (else (box (vector 0 ))))))
(define CoreC-45Name-with--nameEq-11797 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (case (vector-ref arg-2 0) ((1) '()) (else (CoreC-45Name-with--withC-32blockC-32inC-32nameEq-11816 arg-4 arg-3 (DecidableC-45Equality-u--decEq_DecEq_Int arg-3 arg-4) arg-0)))))
(define CoreC-45Name-with--nameEq-11841 (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (box (vector 0 ))) (else '()))))
(define CoreC-45Name-nameEq (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((0) (let ((e-16 (vector-ref arg-1 1))) (let ((e-17 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11540 e-0 e-16 (CoreC-45NameC-45Namespace-u--decEq_DecEq_Namespace e-0 e-16) e-1 e-17))))(else '()))))) ((1) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-18 (vector-ref arg-1 1))) (PreludeC-45Types-u--map_Functor_Maybe (lambda (u--xy) (vector 0 )) (CoreC-45Name-userNameEq e-2 e-18))))(else '())))) ((2) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((2) (let ((e-19 (vector-ref arg-1 1))) (let ((e-20 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11590 e-3 e-19 (DecidableC-45Equality-u--decEq_DecEq_String e-3 e-19) e-4 e-20))))(else '()))))) ((3) (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((3) (let ((e-21 (vector-ref arg-1 1))) (let ((e-22 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11630 e-5 e-21 (CoreC-45Name-nameEq e-5 e-21) e-6 e-22))))(else '()))))) ((4) (let ((e-7 (vector-ref arg-0 1))) (let ((e-8 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((4) (let ((e-23 (vector-ref arg-1 1))) (let ((e-24 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11669 e-7 e-23 (DecidableC-45Equality-u--decEq_DecEq_String e-7 e-23) e-8 e-24))))(else '()))))) ((5) (let ((e-9 (vector-ref arg-0 1))) (let ((e-10 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((5) (let ((e-25 (vector-ref arg-1 1))) (let ((e-26 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11711 e-9 e-25 (DecidableC-45Equality-u--decEq_DecEq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 (cons csegen-507 csegen-507) e-9 e-25) e-10 e-26))))(else '()))))) ((6) (let ((e-11 (vector-ref arg-0 1))) (let ((e-12 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((6) (let ((e-27 (vector-ref arg-1 1))) (let ((e-28 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11753 e-11 e-27 (DecidableC-45Equality-u--decEq_DecEq_String e-11 e-27) e-12 e-28))))(else '()))))) ((7) (let ((e-13 (vector-ref arg-0 1))) (let ((e-14 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((7) (let ((e-29 (vector-ref arg-1 1))) (let ((e-30 (vector-ref arg-1 2))) (CoreC-45Name-with--nameEq-11797 e-13 e-29 (DecidableC-45Equality-u--decEq_DecEq_String e-13 e-29) e-14 e-30))))(else '()))))) ((8) (let ((e-15 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-31 (vector-ref arg-1 1))) (CoreC-45Name-with--nameEq-11841 e-15 e-31 (DecidableC-45Equality-u--decEq_DecEq_Int e-15 e-31))))(else '()))))(else '()))))
(define CoreC-45TTC-45Primitive-primFnEq (lambda (arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (let ((e-0 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((0) (let ((e-18 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-0 e-18))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((1) (let ((e-1 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((1) (let ((e-19 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-1 e-19))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((2) (let ((e-2 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((2) (let ((e-20 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-2 e-20))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((3) (let ((e-3 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((3) (let ((e-21 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-3 e-21))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((4) (let ((e-4 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((4) (let ((e-22 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-4 e-22))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((5) (let ((e-5 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((5) (let ((e-23 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-5 e-23))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((6) (let ((e-6 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((6) (let ((e-24 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-6 e-24))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((7) (let ((e-7 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((7) (let ((e-25 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-7 e-25))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((8) (let ((e-8 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((8) (let ((e-26 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-8 e-26))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((9) (let ((e-9 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((9) (let ((e-27 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-9 e-27))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((10) (let ((e-10 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((10) (let ((e-28 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-10 e-28))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((11) (let ((e-11 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((11) (let ((e-29 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-11 e-29))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((12) (let ((e-12 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((12) (let ((e-30 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-12 e-30))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((13) (let ((e-13 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((13) (let ((e-31 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-13 e-31))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((14) (let ((e-14 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((14) (let ((e-32 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-14 e-32))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((15) (let ((e-15 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((15) (let ((e-33 (vector-ref arg-3 1))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-15 e-33))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '())))))(else '())))) ((16) (case (vector-ref arg-3 0) ((16) (box (vector 0 )))(else '()))) ((17) (case (vector-ref arg-3 0) ((17) (box (vector 0 )))(else '()))) ((18) (case (vector-ref arg-3 0) ((18) (box (vector 0 )))(else '()))) ((19) (case (vector-ref arg-3 0) ((19) (box (vector 0 )))(else '()))) ((20) (case (vector-ref arg-3 0) ((20) (box (vector 0 )))(else '()))) ((21) (case (vector-ref arg-3 0) ((21) (box (vector 0 )))(else '()))) ((22) (case (vector-ref arg-3 0) ((22) (box (vector 0 )))(else '()))) ((23) (case (vector-ref arg-3 0) ((23) (box (vector 0 )))(else '()))) ((24) (case (vector-ref arg-3 0) ((24) (box (vector 0 )))(else '()))) ((25) (case (vector-ref arg-3 0) ((25) (box (vector 0 )))(else '()))) ((26) (case (vector-ref arg-3 0) ((26) (box (vector 0 )))(else '()))) ((27) (case (vector-ref arg-3 0) ((27) (box (vector 0 )))(else '()))) ((28) (case (vector-ref arg-3 0) ((28) (box (vector 0 )))(else '()))) ((29) (case (vector-ref arg-3 0) ((29) (box (vector 0 )))(else '()))) ((30) (case (vector-ref arg-3 0) ((30) (box (vector 0 )))(else '()))) ((31) (case (vector-ref arg-3 0) ((31) (box (vector 0 )))(else '()))) ((32) (case (vector-ref arg-3 0) ((32) (box (vector 0 )))(else '()))) ((33) (case (vector-ref arg-3 0) ((33) (box (vector 0 )))(else '()))) ((34) (case (vector-ref arg-3 0) ((34) (box (vector 0 )))(else '()))) ((35) (case (vector-ref arg-3 0) ((35) (box (vector 0 )))(else '()))) ((36) (let ((e-16 (vector-ref arg-2 1))) (let ((e-17 (vector-ref arg-2 2))) (case (vector-ref arg-3 0) ((36) (let ((e-34 (vector-ref arg-3 1))) (let ((e-35 (vector-ref arg-3 2))) (let ((sc2 (let ((sc3 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-16 e-34))) (cond ((equal? sc3 1) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_PrimType e-17 e-35)) (else 0))))) (cond ((equal? sc2 1) (box (vector 0 ))) (else '()))))))(else '()))))) ((37) (case (vector-ref arg-3 0) ((37) (box (vector 0 )))(else '()))) ((38) (case (vector-ref arg-3 0) ((38) (box (vector 0 )))(else '())))(else '()))))
(define DataC-45Vect-u--C-61C-61_Eq_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 (lambda (arg-2 arg-3 arg-4) (if (null? arg-3) 1 (let ((e-3 (car arg-3))) (let ((e-4 (cdr arg-3))) (let ((e-8 (car arg-4))) (let ((e-9 (cdr arg-4))) (let ((sc2 (let ((e-1 (car arg-2))) ((e-1 e-3) e-8)))) (cond ((equal? sc2 1) (DataC-45Vect-u--C-61C-61_Eq_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 arg-2 e-4 e-9)) (else 0))))))))))
(define CoreC-45TTC-45Term-u--C-61C-61_Eq_LazyReason (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else 0))))
(define CoreC-45Name-namesEq (lambda (arg-0 arg-1) (if (null? arg-0) (if (null? arg-1) (box (vector 0 )) '()) (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (if (null? arg-1) '() (let ((e-6 (car arg-1))) (let ((e-7 (cdr arg-1))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45Name-nameEq e-2 e-6) (lambda (u--p) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45Name-namesEq e-3 e-7) (lambda (u--ps) (box (vector 0 ))))))))))))))
(define CoreC-45Ord-u--C-61C-61_Eq_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((e-1 (vector-ref arg-1 0))) (let ((e-3 (vector-ref arg-1 2))) (let ((e-4 (vector-ref arg-1 3))) (let ((e-5 (vector-ref arg-1 4))) (let ((e-7 (vector-ref arg-2 0))) (let ((e-9 (vector-ref arg-2 2))) (let ((e-10 (vector-ref arg-2 3))) (let ((e-11 (vector-ref arg-2 4))) (let ((sc0 (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 csegen-223 e-3 e-9))) (cond ((equal? sc0 1) (let ((sc1 (CoreC-45Name-u--C-61C-61_Eq_Name e-1 e-7))) (cond ((equal? sc1 1) ((let ((sc2 (CoreC-45Name-namesEq e-4 e-10))) (if (null? sc2) (lambda () 0) (lambda () (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-5 e-11)))))) (else 0)))) (else 0)))))))))))))
(define CoreC-45Ord-u--C-47C-61_Eq_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-61C-61_Eq_C-40CConAltC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1919 (lambda () (cons (lambda (arg-676) (lambda (arg-679) (CoreC-45Ord-u--C-61C-61_Eq_C-40CConAltC-32C-36varsC-41 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (CoreC-45Ord-u--C-47C-61_Eq_C-40CConAltC-32C-36varsC-41 arg-686 arg-689))))))
(define CoreC-45Ord-u--C-61C-61_Eq_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((e-1 (car arg-1))) (let ((e-2 (cdr arg-1))) (let ((e-4 (car arg-2))) (let ((e-5 (cdr arg-2))) (let ((sc2 (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-1 e-4))) (cond ((equal? sc2 1) (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-2 e-5)) (else 0)))))))))
(define CoreC-45Ord-u--C-47C-61_Eq_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-61C-61_Eq_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1930 (lambda () (cons (lambda (arg-676) (lambda (arg-679) (CoreC-45Ord-u--C-61C-61_Eq_C-40CConstAltC-32C-36varsC-41 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (CoreC-45Ord-u--C-47C-61_Eq_C-40CConstAltC-32C-36varsC-41 arg-686 arg-689))))))
(define CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-1 0) ((0) (let ((e-2 (vector-ref arg-1 1))) (case (vector-ref arg-2 0) ((0) (let ((e-65 (vector-ref arg-2 1))) (or (and (= e-2 e-65) 1) 0)))(else 0)))) ((1) (let ((e-7 (vector-ref arg-1 2))) (case (vector-ref arg-2 0) ((1) (let ((e-70 (vector-ref arg-2 2))) (CoreC-45Name-u--C-61C-61_Eq_Name e-7 e-70)))(else 0)))) ((2) (let ((e-10 (vector-ref arg-1 2))) (let ((e-11 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((2) (let ((e-73 (vector-ref arg-2 2))) (let ((e-74 (vector-ref arg-2 3))) (let ((sc2 (CoreC-45Name-nameEq e-10 e-73))) (if (null? sc2) 0 (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-11 e-74))))))(else 0))))) ((3) (let ((e-14 (vector-ref arg-1 2))) (let ((e-16 (vector-ref arg-1 4))) (let ((e-17 (vector-ref arg-1 5))) (case (vector-ref arg-2 0) ((3) (let ((e-77 (vector-ref arg-2 2))) (let ((e-79 (vector-ref arg-2 4))) (let ((e-80 (vector-ref arg-2 5))) (let ((sc2 (CoreC-45Name-nameEq e-14 e-77))) (if (null? sc2) 0 (let ((sc3 (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-16 e-79))) (cond ((equal? sc3 1) (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-17 e-80)) (else 0)))))))))(else 0)))))) ((4) (let ((e-20 (vector-ref arg-1 2))) (let ((e-21 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((4) (let ((e-83 (vector-ref arg-2 2))) (let ((e-84 (vector-ref arg-2 3))) (let ((sc2 (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-20 e-83))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (csegen-1875) e-21 e-84)) (else 0))))))(else 0))))) ((5) (let ((e-24 (vector-ref arg-1 2))) (let ((e-26 (vector-ref arg-1 4))) (let ((e-27 (vector-ref arg-1 5))) (case (vector-ref arg-2 0) ((5) (let ((e-87 (vector-ref arg-2 2))) (let ((e-89 (vector-ref arg-2 4))) (let ((e-90 (vector-ref arg-2 5))) (let ((sc2 (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 csegen-223 e-26 e-89))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-24 e-87))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (csegen-1875) e-27 e-90)) (else 0)))) (else 0)))))))(else 0)))))) ((6) (let ((e-31 (vector-ref arg-1 3))) (let ((e-32 (vector-ref arg-1 4))) (case (vector-ref arg-2 0) ((6) (let ((e-94 (vector-ref arg-2 3))) (let ((e-95 (vector-ref arg-2 4))) (let ((sc2 (CoreC-45TTC-45Primitive-primFnEq e-31 e-94))) (if (null? sc2) 0 (DataC-45Vect-u--C-61C-61_Eq_C-40C-40VectC-32C-36nC-41C-32C-36aC-41 (csegen-1875) e-32 e-95))))))(else 0))))) ((7) (let ((e-35 (vector-ref arg-1 2))) (let ((e-36 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((7) (let ((e-98 (vector-ref arg-2 2))) (let ((e-99 (vector-ref arg-2 3))) (let ((sc2 (CoreC-45Name-u--C-61C-61_Eq_Name e-35 e-98))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (csegen-1875) e-36 e-99)) (else 0))))))(else 0))))) ((8) (let ((e-39 (vector-ref arg-1 2))) (let ((e-40 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((8) (let ((e-102 (vector-ref arg-2 2))) (let ((e-103 (vector-ref arg-2 3))) (let ((sc2 (CoreC-45TTC-45Term-u--C-61C-61_Eq_LazyReason e-39 e-102))) (cond ((equal? sc2 1) (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-40 e-103)) (else 0))))))(else 0))))) ((9) (let ((e-43 (vector-ref arg-1 2))) (let ((e-44 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((9) (let ((e-106 (vector-ref arg-2 2))) (let ((e-107 (vector-ref arg-2 3))) (let ((sc2 (CoreC-45TTC-45Term-u--C-61C-61_Eq_LazyReason e-43 e-106))) (cond ((equal? sc2 1) (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-44 e-107)) (else 0))))))(else 0))))) ((10) (let ((e-47 (vector-ref arg-1 2))) (let ((e-48 (vector-ref arg-1 3))) (let ((e-49 (vector-ref arg-1 4))) (case (vector-ref arg-2 0) ((10) (let ((e-110 (vector-ref arg-2 2))) (let ((e-111 (vector-ref arg-2 3))) (let ((e-112 (vector-ref arg-2 4))) (let ((sc2 (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-47 e-110))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (csegen-1919) e-48 e-111))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 (csegen-1875) e-49 e-112)) (else 0)))) (else 0)))))))(else 0)))))) ((11) (let ((e-52 (vector-ref arg-1 2))) (let ((e-53 (vector-ref arg-1 3))) (let ((e-54 (vector-ref arg-1 4))) (case (vector-ref arg-2 0) ((11) (let ((e-115 (vector-ref arg-2 2))) (let ((e-116 (vector-ref arg-2 3))) (let ((e-117 (vector-ref arg-2 4))) (let ((sc2 (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 e-52 e-115))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (csegen-1930) e-53 e-116))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 (csegen-1875) e-54 e-117)) (else 0)))) (else 0)))))))(else 0)))))) ((12) (let ((e-57 (vector-ref arg-1 2))) (case (vector-ref arg-2 0) ((12) (let ((e-120 (vector-ref arg-2 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-57 e-120)))(else 0)))) ((13) (case (vector-ref arg-2 0) ((13) 1)(else 0))) ((14) (let ((e-62 (vector-ref arg-1 2))) (case (vector-ref arg-2 0) ((14) (let ((e-125 (vector-ref arg-2 2))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-62 e-125)))(else 0))))(else 0))))
(define CoreC-45Ord-u--C-47C-61_Eq_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-1875 (lambda () (cons (lambda (arg-676) (lambda (arg-679) (CoreC-45Ord-u--C-61C-61_Eq_C-40CExpC-32C-36varsC-41 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (CoreC-45Ord-u--C-47C-61_Eq_C-40CExpC-32C-36varsC-41 arg-686 arg-689))))))
(define LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) 0) ((equal? arg-0 1) (arg-1)) (else 2))))
(define PreludeC-45Basics-on (lambda (arg-3 arg-4 ext-0 ext-1) ((arg-3 (arg-4 ext-0)) (arg-4 ext-1))))
(define CoreC-45TTC-45Primitive-n--7113-6401-u--tag (lambda (arg-0) (cond ((equal? arg-0 0) 1) ((equal? arg-0 1) 2) ((equal? arg-0 2) 3) ((equal? arg-0 3) 4) ((equal? arg-0 4) 5) ((equal? arg-0 5) 6) ((equal? arg-0 6) 7) ((equal? arg-0 7) 8) ((equal? arg-0 8) 9) ((equal? arg-0 9) 10) ((equal? arg-0 10) 11) ((equal? arg-0 11) 12) ((equal? arg-0 12) 13) (else 14))))
(define CoreC-45TTC-45Primitive-u--compare_Ord_PrimType (lambda (ext-0 ext-1) (PreludeC-45Basics-on (lambda (eta-0) (lambda (eta-1) (PreludeC-45EqOrd-u--compare_Ord_Int eta-0 eta-1))) (lambda (eta-0) (CoreC-45TTC-45Primitive-n--7113-6401-u--tag eta-0)) ext-0 ext-1)))
(define CoreC-45TTC-45Primitive-n--10405-9559-u--tag (lambda (arg-2 arg-3 arg-5) (case (vector-ref arg-5 0) ((0) 0) ((1) 1) ((2) 2) ((3) 3) ((4) 4) ((5) 5) ((6) 6) ((7) 7) ((8) 8) ((9) 9) ((10) 10) ((11) 11) ((12) 12) ((13) 13) ((14) 14) ((15) 15) ((16) 16) ((17) 17) ((18) 18) ((19) 19) ((20) 20) ((21) 21) ((22) 22) ((23) 23) ((24) 24) ((25) 25) ((26) 26) ((27) 27) ((28) 28) ((29) 29) ((30) 30) ((31) 31) ((32) 32) ((33) 33) ((34) 34) ((35) 35) ((36) 36) ((37) 37) (else 38))))
(define CoreC-45TTC-45Primitive-primFnCmp (lambda (arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (let ((e-0 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((0) (let ((e-18 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-0 e-18)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((1) (let ((e-1 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((1) (let ((e-19 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-1 e-19)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((2) (let ((e-2 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((2) (let ((e-20 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-2 e-20)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((3) (let ((e-3 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((3) (let ((e-21 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-3 e-21)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((4) (let ((e-4 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((4) (let ((e-22 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-4 e-22)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((5) (let ((e-5 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((5) (let ((e-23 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-5 e-23)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((6) (let ((e-6 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((6) (let ((e-24 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-6 e-24)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((7) (let ((e-7 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((7) (let ((e-25 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-7 e-25)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((8) (let ((e-8 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((8) (let ((e-26 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-8 e-26)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((9) (let ((e-9 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((9) (let ((e-27 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-9 e-27)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((10) (let ((e-10 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((10) (let ((e-28 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-10 e-28)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((11) (let ((e-11 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((11) (let ((e-29 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-11 e-29)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((12) (let ((e-12 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((12) (let ((e-30 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-12 e-30)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((13) (let ((e-13 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((13) (let ((e-31 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-13 e-31)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((14) (let ((e-14 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((14) (let ((e-32 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-14 e-32)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((15) (let ((e-15 (vector-ref arg-2 1))) (case (vector-ref arg-3 0) ((15) (let ((e-33 (vector-ref arg-3 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-15 e-33)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))) ((36) (let ((e-16 (vector-ref arg-2 1))) (let ((e-17 (vector-ref arg-2 2))) (case (vector-ref arg-3 0) ((36) (let ((e-34 (vector-ref arg-3 1))) (let ((e-35 (vector-ref arg-3 2))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-16 e-34) (lambda () (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-17 e-35))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3)))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-2) (CoreC-45TTC-45Primitive-n--10405-9559-u--tag arg-3 arg-2 arg-3))))))
(define PreludeC-45Types-u--compare_Ord_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (if (null? arg-2) (if (null? arg-3) 1 0) (let ((e-2 (unbox arg-2))) (if (null? arg-3) 2 (let ((e-8 (unbox arg-3))) (let ((e-10 (vector-ref arg-1 1))) ((e-10 e-2) e-8))))))))
(define CoreC-45Ord-u--compare_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((e-1 (vector-ref arg-1 0))) (let ((e-3 (vector-ref arg-1 2))) (let ((e-4 (vector-ref arg-1 3))) (let ((e-5 (vector-ref arg-1 4))) (let ((e-7 (vector-ref arg-2 0))) (let ((e-9 (vector-ref arg-2 2))) (let ((e-10 (vector-ref arg-2 3))) (let ((e-11 (vector-ref arg-2 4))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (PreludeC-45Types-u--compare_Ord_C-40MaybeC-32C-36aC-41 csegen-231 e-3 e-9) (lambda () (CoreC-45Name-u--compare_Ord_Name e-1 e-7))) (let ((sc0 (CoreC-45Name-namesEq e-4 e-10))) (if (null? sc0) (lambda () (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 csegen-861 e-4 e-10)) (lambda () (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-5 e-11)))))))))))))))
(define CoreC-45Ord-u--C-60C-61_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConAltC-32C-36varsC-41 arg-1 arg-2) 2)))
(define PreludeC-45EqOrd-u--C-60_Ord_Bits16 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Bits16 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Bits16 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits16 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Bits32 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Bits32 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Bits32 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits32 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Bits64 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Bits64 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Bits64 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits64 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Bits8 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Bits8 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Bits8 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Bits8 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Char (lambda (arg-0 arg-1) (let ((sc0 (or (and (char<? arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Char (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Char arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Char arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Double (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Double (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Double arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Double arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Int16 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Int16 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int16 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int16 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Int32 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Int32 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int32 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int32 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Int64 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Int64 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int64 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int64 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define PreludeC-45EqOrd-u--C-60_Ord_Int8 (lambda (arg-0 arg-1) (let ((sc0 (or (and (< arg-0 arg-1) 1) 0))) (cond ((equal? sc0 0) 0)(else 1)))))
(define PreludeC-45EqOrd-u--compare_Ord_Int8 (lambda (arg-0 arg-1) (let ((sc0 (PreludeC-45EqOrd-u--C-60_Ord_Int8 arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else (let ((sc1 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int8 arg-0 arg-1))) (cond ((equal? sc1 1) 1) (else 2))))))))
(define CoreC-45TTC-45Primitive-n--7345-6714-u--tag (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) 0) ((1) 1) ((2) 2) ((3) 3) ((4) 4) ((5) 5) ((6) 6) ((7) 7) ((8) 8) ((9) 9) ((10) 10) ((11) 11) ((12) 12) ((13) 13) (else 14))))
(define CoreC-45TTC-45Primitive-u--compare_Ord_Constant (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-14 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Int e-0 e-14)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-15 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Int8 e-1 e-15)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((2) (let ((e-2 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((2) (let ((e-16 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Int16 e-2 e-16)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((3) (let ((e-3 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((3) (let ((e-17 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Int32 e-3 e-17)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((4) (let ((e-4 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((4) (let ((e-18 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Int64 e-4 e-18)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((5) (let ((e-5 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((5) (let ((e-19 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Integer e-5 e-19)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((6) (let ((e-6 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((6) (let ((e-20 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Bits8 e-6 e-20)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((7) (let ((e-7 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((7) (let ((e-21 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Bits16 e-7 e-21)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((8) (let ((e-8 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((8) (let ((e-22 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Bits32 e-8 e-22)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((9) (let ((e-9 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((9) (let ((e-23 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Bits64 e-9 e-23)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((10) (let ((e-10 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((10) (let ((e-24 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_String e-10 e-24)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((11) (let ((e-11 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((11) (let ((e-25 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Char e-11 e-25)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((12) (let ((e-12 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((12) (let ((e-26 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--compare_Ord_Double e-12 e-26)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1)))))) ((13) (let ((e-13 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((13) (let ((e-27 (vector-ref arg-1 1))) (CoreC-45TTC-45Primitive-u--compare_Ord_PrimType e-13 e-27)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-0) (CoreC-45TTC-45Primitive-n--7345-6714-u--tag arg-1 arg-0 arg-1))))))
(define CoreC-45Ord-u--compare_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((e-1 (car arg-1))) (let ((e-2 (cdr arg-1))) (let ((e-4 (car arg-2))) (let ((e-5 (cdr arg-2))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45TTC-45Primitive-u--compare_Ord_Constant e-1 e-4) (lambda () (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-2 e-5)))))))))
(define CoreC-45Ord-u--C-60C-61_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2) 2)))
(define CoreC-45Ord-u--C-60_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConAltC-32C-36varsC-41 arg-1 arg-2) 0)))
(define CoreC-45Ord-u--C-60_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2) 0)))
(define CoreC-45Ord-u--C-62C-61_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConAltC-32C-36varsC-41 arg-1 arg-2) 0)))
(define CoreC-45Ord-u--C-62C-61_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2) 0)))
(define CoreC-45Ord-u--C-62_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConAltC-32C-36varsC-41 arg-1 arg-2) 2)))
(define CoreC-45Ord-u--C-62_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2) 2)))
(define DataC-45Vect-case--compare-3292 (lambda (arg-1 arg-3 arg-4 arg-5 arg-6 arg-8) (cond ((equal? arg-8 1) (DataC-45Vect-u--compare_Ord_C-40C-40VectC-32C-36lenC-41C-32C-36elemC-41 arg-1 arg-4 arg-6))(else arg-8))))
(define DataC-45Vect-u--compare_Ord_C-40C-40VectC-32C-36lenC-41C-32C-36elemC-41 (lambda (arg-2 arg-3 arg-4) (if (null? arg-3) 1 (let ((e-3 (car arg-3))) (let ((e-4 (cdr arg-3))) (let ((e-8 (car arg-4))) (let ((e-9 (cdr arg-4))) (DataC-45Vect-case--compare-3292 arg-2 e-3 e-4 e-8 e-9 (let ((e-2 (vector-ref arg-2 1))) ((e-2 e-3) e-8))))))))))
(define CoreC-45Ord-lrTag (lambda (arg-0) (cond ((equal? arg-0 0) 0) ((equal? arg-0 1) 1) (else 2))))
(define CoreC-45Ord-u--compare_Ord_LazyReason (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-lrTag arg-0) (CoreC-45Ord-lrTag arg-1))))
(define CoreC-45Ord-u--max_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-62_Ord_C-40CConAltC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) arg-1) (else arg-2)))))
(define CoreC-45Ord-u--max_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-62_Ord_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) arg-1) (else arg-2)))))
(define CoreC-45Ord-u--min_Ord_C-40CConAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-60_Ord_C-40CConAltC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) arg-1) (else arg-2)))))
(define CoreC-45Ord-u--min_Ord_C-40CConstAltC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-60_Ord_C-40CConstAltC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) arg-1) (else arg-2)))))
(define CoreC-45Ord-n--7062-2400-u--tag (lambda (arg-1 arg-2 arg-4) (case (vector-ref arg-4 0) ((0) 0) ((1) 1) ((2) 2) ((3) 3) ((4) 4) ((5) 5) ((6) 6) ((7) 7) ((8) 8) ((9) 9) ((10) 10) ((11) 11) ((12) 12) ((13) 13) (else 14))))
(define CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-1 0) ((0) (let ((e-2 (vector-ref arg-1 1))) (case (vector-ref arg-2 0) ((0) (let ((e-65 (vector-ref arg-2 1))) (PreludeC-45EqOrd-u--compare_Ord_Integer e-2 e-65)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2)))))) ((1) (let ((e-7 (vector-ref arg-1 2))) (case (vector-ref arg-2 0) ((1) (let ((e-70 (vector-ref arg-2 2))) (CoreC-45Name-u--compare_Ord_Name e-7 e-70)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2)))))) ((2) (let ((e-10 (vector-ref arg-1 2))) (let ((e-11 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((2) (let ((e-73 (vector-ref arg-2 2))) (let ((e-74 (vector-ref arg-2 3))) (let ((sc2 (CoreC-45Name-nameEq e-10 e-73))) (if (null? sc2) (CoreC-45Name-u--compare_Ord_Name e-10 e-73) (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-11 e-74))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2))))))) ((3) (let ((e-14 (vector-ref arg-1 2))) (let ((e-16 (vector-ref arg-1 4))) (let ((e-17 (vector-ref arg-1 5))) (case (vector-ref arg-2 0) ((3) (let ((e-77 (vector-ref arg-2 2))) (let ((e-79 (vector-ref arg-2 4))) (let ((e-80 (vector-ref arg-2 5))) (let ((sc2 (CoreC-45Name-nameEq e-14 e-77))) (if (null? sc2) (CoreC-45Name-u--compare_Ord_Name e-14 e-77) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-16 e-79) (lambda () (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-17 e-80)))))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2)))))))) ((4) (let ((e-20 (vector-ref arg-1 2))) (let ((e-21 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((4) (let ((e-83 (vector-ref arg-2 2))) (let ((e-84 (vector-ref arg-2 3))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-20 e-83) (lambda () (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (csegen-1886) e-21 e-84))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2))))))) ((5) (let ((e-24 (vector-ref arg-1 2))) (let ((e-26 (vector-ref arg-1 4))) (let ((e-27 (vector-ref arg-1 5))) (case (vector-ref arg-2 0) ((5) (let ((e-87 (vector-ref arg-2 2))) (let ((e-89 (vector-ref arg-2 4))) (let ((e-90 (vector-ref arg-2 5))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (PreludeC-45Types-u--compare_Ord_C-40MaybeC-32C-36aC-41 csegen-231 e-26 e-89) (lambda () (CoreC-45Name-u--compare_Ord_Name e-24 e-87))) (lambda () (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (csegen-1886) e-27 e-90)))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2)))))))) ((6) (let ((e-31 (vector-ref arg-1 3))) (let ((e-32 (vector-ref arg-1 4))) (case (vector-ref arg-2 0) ((6) (let ((e-94 (vector-ref arg-2 3))) (let ((e-95 (vector-ref arg-2 4))) (let ((sc2 (CoreC-45TTC-45Primitive-primFnEq e-31 e-94))) (if (null? sc2) (CoreC-45TTC-45Primitive-primFnCmp e-31 e-94) (DataC-45Vect-u--compare_Ord_C-40C-40VectC-32C-36lenC-41C-32C-36elemC-41 (csegen-1886) e-32 e-95))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2))))))) ((7) (let ((e-35 (vector-ref arg-1 2))) (let ((e-36 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((7) (let ((e-98 (vector-ref arg-2 2))) (let ((e-99 (vector-ref arg-2 3))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Name-u--compare_Ord_Name e-35 e-98) (lambda () (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (csegen-1886) e-36 e-99))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2))))))) ((8) (let ((e-39 (vector-ref arg-1 2))) (let ((e-40 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((8) (let ((e-102 (vector-ref arg-2 2))) (let ((e-103 (vector-ref arg-2 3))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Ord-u--compare_Ord_LazyReason e-39 e-102) (lambda () (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-40 e-103))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2))))))) ((9) (let ((e-43 (vector-ref arg-1 2))) (let ((e-44 (vector-ref arg-1 3))) (case (vector-ref arg-2 0) ((9) (let ((e-106 (vector-ref arg-2 2))) (let ((e-107 (vector-ref arg-2 3))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Ord-u--compare_Ord_LazyReason e-43 e-106) (lambda () (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-44 e-107))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2))))))) ((10) (let ((e-47 (vector-ref arg-1 2))) (let ((e-48 (vector-ref arg-1 3))) (let ((e-49 (vector-ref arg-1 4))) (case (vector-ref arg-2 0) ((10) (let ((e-110 (vector-ref arg-2 2))) (let ((e-111 (vector-ref arg-2 3))) (let ((e-112 (vector-ref arg-2 4))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-47 e-110) (lambda () (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (vector (csegen-1919) (lambda (arg-1566) (lambda (arg-1569) (CoreC-45Ord-u--compare_Ord_C-40CConAltC-32C-36varsC-41 arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (CoreC-45Ord-u--C-60_Ord_C-40CConAltC-32C-36varsC-41 arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (CoreC-45Ord-u--C-62_Ord_C-40CConAltC-32C-36varsC-41 arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (CoreC-45Ord-u--C-60C-61_Ord_C-40CConAltC-32C-36varsC-41 arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (CoreC-45Ord-u--C-62C-61_Ord_C-40CConAltC-32C-36varsC-41 arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (CoreC-45Ord-u--max_Ord_C-40CConAltC-32C-36varsC-41 arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (CoreC-45Ord-u--min_Ord_C-40CConAltC-32C-36varsC-41 arg-1626 arg-1629)))) e-48 e-111))) (lambda () (PreludeC-45Types-u--compare_Ord_C-40MaybeC-32C-36aC-41 (csegen-1886) e-49 e-112)))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2)))))))) ((11) (let ((e-52 (vector-ref arg-1 2))) (let ((e-53 (vector-ref arg-1 3))) (let ((e-54 (vector-ref arg-1 4))) (case (vector-ref arg-2 0) ((11) (let ((e-115 (vector-ref arg-2 2))) (let ((e-116 (vector-ref arg-2 3))) (let ((e-117 (vector-ref arg-2 4))) (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (LibrariesC-45DataC-45OrderingC-45Extra-thenCmp (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 e-52 e-115) (lambda () (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (vector (csegen-1930) (lambda (arg-1566) (lambda (arg-1569) (CoreC-45Ord-u--compare_Ord_C-40CConstAltC-32C-36varsC-41 arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (CoreC-45Ord-u--C-60_Ord_C-40CConstAltC-32C-36varsC-41 arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (CoreC-45Ord-u--C-62_Ord_C-40CConstAltC-32C-36varsC-41 arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (CoreC-45Ord-u--C-60C-61_Ord_C-40CConstAltC-32C-36varsC-41 arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (CoreC-45Ord-u--C-62C-61_Ord_C-40CConstAltC-32C-36varsC-41 arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (CoreC-45Ord-u--max_Ord_C-40CConstAltC-32C-36varsC-41 arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (CoreC-45Ord-u--min_Ord_C-40CConstAltC-32C-36varsC-41 arg-1626 arg-1629)))) e-53 e-116))) (lambda () (PreludeC-45Types-u--compare_Ord_C-40MaybeC-32C-36aC-41 (csegen-1886) e-54 e-117)))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2)))))))) ((12) (let ((e-57 (vector-ref arg-1 2))) (case (vector-ref arg-2 0) ((12) (let ((e-120 (vector-ref arg-2 2))) (CoreC-45TTC-45Primitive-u--compare_Ord_Constant e-57 e-120)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2)))))) ((13) (case (vector-ref arg-2 0) ((13) 1)(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2))))) ((14) (let ((e-62 (vector-ref arg-1 2))) (case (vector-ref arg-2 0) ((14) (let ((e-125 (vector-ref arg-2 2))) (PreludeC-45EqOrd-u--compare_Ord_String e-62 e-125)))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2))))))(else (PreludeC-45EqOrd-u--compare_Ord_Int (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-1) (CoreC-45Ord-n--7062-2400-u--tag arg-2 arg-1 arg-2))))))
(define CoreC-45Ord-u--C-60C-61_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 arg-1 arg-2) 2)))
(define CoreC-45Ord-u--C-60_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 arg-1 arg-2) 0)))
(define CoreC-45Ord-u--C-62C-61_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 arg-1 arg-2) 0)))
(define CoreC-45Ord-u--C-62_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 arg-1 arg-2) 2)))
(define CoreC-45Ord-u--max_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-62_Ord_C-40CExpC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) arg-1) (else arg-2)))))
(define CoreC-45Ord-u--min_Ord_C-40CExpC-32C-36varsC-41 (lambda (arg-1 arg-2) (let ((sc0 (CoreC-45Ord-u--C-60_Ord_C-40CExpC-32C-36varsC-41 arg-1 arg-2))) (cond ((equal? sc0 1) arg-1) (else arg-2)))))
(define csegen-1886 (lambda () (vector (csegen-1875) (lambda (arg-1566) (lambda (arg-1569) (CoreC-45Ord-u--compare_Ord_C-40CExpC-32C-36varsC-41 arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (CoreC-45Ord-u--C-60_Ord_C-40CExpC-32C-36varsC-41 arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (CoreC-45Ord-u--C-62_Ord_C-40CExpC-32C-36varsC-41 arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (CoreC-45Ord-u--C-60C-61_Ord_C-40CExpC-32C-36varsC-41 arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (CoreC-45Ord-u--C-62C-61_Ord_C-40CExpC-32C-36varsC-41 arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (CoreC-45Ord-u--max_Ord_C-40CExpC-32C-36varsC-41 arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (CoreC-45Ord-u--min_Ord_C-40CExpC-32C-36varsC-41 arg-1626 arg-1629))))))
(define DataC-45Vect-u--foldlM_Foldable_C-40VectC-32C-36nC-41 (lambda (arg-4 arg-5 arg-6 ext-0) (DataC-45Vect-u--foldl_Foldable_C-40VectC-32C-36nC-41 (lambda (u--ma) (lambda (u--b) (let ((e-2 (vector-ref arg-4 1))) ((((e-2 'erased) 'erased) u--ma) (lambda (eta-0) (PreludeC-45Basics-flip arg-5 u--b eta-0)))))) (let ((e-1 (vector-ref arg-4 0))) (let ((e-5 (vector-ref e-1 1))) ((e-5 'erased) arg-6))) ext-0)))
(define DataC-45Vect-u--null_Foldable_C-40VectC-32C-36nC-41 (lambda (arg-2) (if (null? arg-2) 1 0)))
(define csegen-1914 (vector (lambda (u--acc) (lambda (u--elem) (lambda (u--func) (lambda (u--init) (lambda (u--input) (DataC-45Vect-u--foldr_Foldable_C-40VectC-32C-36nC-41 u--func u--init u--input)))))) (lambda (u--elem) (lambda (u--acc) (lambda (u--func) (lambda (u--init) (lambda (u--input) (DataC-45Vect-u--foldl_Foldable_C-40VectC-32C-36nC-41 u--func u--init u--input)))))) (lambda (u--elem) (lambda (arg-10911) (DataC-45Vect-u--null_Foldable_C-40VectC-32C-36nC-41 arg-10911))) (lambda (u--elem) (lambda (u--acc) (lambda (u--m) (lambda (i_con-0) (lambda (u--funcM) (lambda (u--init) (lambda (u--input) (DataC-45Vect-u--foldlM_Foldable_C-40VectC-32C-36nC-41 i_con-0 u--funcM u--init u--input)))))))) (lambda (u--elem) (lambda (arg-10940) (DataC-45Vect-u--toList_Foldable_C-40VectC-32C-36nC-41 arg-10940))) (lambda (u--a) (lambda (u--m) (lambda (i_con-0) (lambda (u--f) (lambda (arg-10954) (DataC-45Vect-u--foldMap_Foldable_C-40VectC-32C-36nC-41 i_con-0 u--f arg-10954))))))))
(define DataC-45List-u--unzipWith_Zippable_List (lambda (arg-3 arg-4) (if (null? arg-4) (cons '() '()) (let ((e-2 (car arg-4))) (let ((e-3 (cdr arg-4))) (let ((sc1 (arg-3 e-2))) (let ((e-5 (car sc1))) (let ((e-4 (cdr sc1))) (let ((sc2 (DataC-45List-u--unzipWith_Zippable_List arg-3 e-3))) (let ((e-7 (car sc2))) (let ((e-6 (cdr sc2))) (cons (cons e-5 e-7) (cons e-4 e-6)))))))))))))
(define DataC-45List-u--unzip_Zippable_List (lambda (ext-0) (DataC-45List-u--unzipWith_Zippable_List (lambda (eta-0) eta-0) ext-0)))
(define csegen-1915 (lambda (eta-0) (case (vector-ref eta-0 0) ((0) (let ((e-2 (vector-ref eta-0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref eta-0 1))) (vector 1 (DataC-45List-u--unzip_Zippable_List e-5)))))))
(define csegen-1939 (lambda (eta-0) (lambda (eta-1) (bs+ eta-0 eta-1 63))))
(define CoreC-45NameC-45Namespace-primIONS (CoreC-45NameC-45Namespace-mkNamespace "PrimIO"))
(define csegen-1940 (vector 0 CoreC-45NameC-45Namespace-primIONS (vector 1 (vector 0 "io_bind"))))
(define DataC-45String-n--3846-9250-u--unlinesC-39 (lambda (arg-0) (if (null? arg-0) '() (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (cons e-2 (cons "\xa;" (DataC-45String-n--3846-9250-u--unlinesC-39 e-3))))))))
(define DataC-45String-fastUnlines (lambda (ext-0) (PreludeC-45Types-fastConcat (DataC-45String-n--3846-9250-u--unlinesC-39 ext-0))))
(define CoreC-45CaseC-45CaseTree-showCA (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (string-append (CoreC-45NameC-45Namespace-showSep " " (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45Name-u--show_Show_Name eta-0)) (cons e-1 e-3))) (string-append " => " (CoreC-45CaseC-45CaseTree-showCT (PreludeC-45TypesC-45List-tailRecAppend e-3 arg-0) arg-1 e-4))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (string-append "Delay " (string-append (CoreC-45Name-u--show_Show_Name e-7) (string-append " => " (CoreC-45CaseC-45CaseTree-showCT (cons e-6 (cons e-7 arg-0)) arg-1 e-8)))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (string-append "Constant " (string-append (CoreC-45TTC-45Primitive-u--show_Show_Constant e-10) (string-append " => " (CoreC-45CaseC-45CaseTree-showCT arg-0 arg-1 e-11))))))) (else (let ((e-13 (vector-ref arg-2 1))) (string-append "_ => " (CoreC-45CaseC-45CaseTree-showCT arg-0 arg-1 e-13)))))))
(define CoreC-45CaseC-45CaseTree-showCT (lambda (arg-0 arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 4))) (string-append "case " (string-append (CoreC-45Name-u--show_Show_Name e-1) (string-append "[" (string-append (PreludeC-45Show-u--show_Show_Nat e-2) (string-append "] : " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-0 e-4) (string-append " of" (string-append "\xa;" (string-append arg-1 (string-append " { " (string-append (CoreC-45NameC-45Namespace-showSep (string-append "\xa;" (string-append arg-1 " | ")) (PreludeC-45TypesC-45List-mapAppend '() (lambda (eta-0) (CoreC-45CaseC-45CaseTree-showCA arg-0 (string-append "  " arg-1) eta-0)) e-5)) (string-append "\xa;" (string-append arg-1 " }")))))))))))))))))) ((1) (let ((e-7 (vector-ref arg-2 1))) (let ((e-8 (vector-ref arg-2 2))) (string-append "[" (string-append (PreludeC-45Show-u--show_Show_Int e-7) (string-append "] " (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 arg-0 e-8))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (string-append "Error: " (PreludeC-45Show-u--show_Show_String e-10)))) (else "Impossible"))))
(define CoreC-45CaseC-45CaseTree-u--show_Show_C-40CaseTreeC-32C-36varsC-41 (lambda (arg-0 ext-0) (CoreC-45CaseC-45CaseTree-showCT arg-0 "" ext-0)))
(define CoreC-45ContextC-45Context-u--show_Show_Def (lambda (arg-0) (case (vector-ref arg-0 0) ((0) "undefined") ((1) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (let ((e-3 (vector-ref arg-0 4))) (DataC-45String-fastUnlines (cons (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-65 e-1) ";") (cons (string-append "Compile time tree: " (CoreC-45CaseC-45CaseTree-u--show_Show_C-40CaseTreeC-32C-36varsC-41 e-1 e-2)) (cons (string-append "Run time tree: " (CoreC-45CaseC-45CaseTree-u--show_Show_C-40CaseTreeC-32C-36varsC-41 e-1 e-3)) '())))))))) ((5) (let ((e-5 (vector-ref arg-0 1))) (let ((e-6 (vector-ref arg-0 2))) (let ((e-7 (vector-ref arg-0 3))) (string-append "DataCon " (string-append (PreludeC-45Show-u--show_Show_Int e-5) (string-append " " (string-append (PreludeC-45Show-u--show_Show_Nat e-6) (PreludeC-45Types-maybe (lambda () "") (lambda () (lambda (u--n) (string-append " (newtype by " (string-append (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1025 u--n) ")")))) e-7))))))))) ((6) (let ((e-8 (vector-ref arg-0 1))) (let ((e-9 (vector-ref arg-0 2))) (let ((e-10 (vector-ref arg-0 3))) (let ((e-13 (vector-ref arg-0 6))) (let ((e-14 (vector-ref arg-0 7))) (let ((e-15 (vector-ref arg-0 8))) (string-append "TyCon " (string-append (PreludeC-45Show-u--show_Show_Int e-8) (string-append " " (string-append (PreludeC-45Show-u--show_Show_Nat e-9) (string-append " params: " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-895 e-10) (string-append " constructors: " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-65 e-14) (string-append " mutual with: " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-65 e-13) (string-append " detaggable by: " (PreludeC-45Show-u--show_Show_C-40MaybeC-32C-36aC-41 csegen-1029 e-15))))))))))))))))))) ((2) (let ((e-16 (vector-ref arg-0 1))) (string-append "<external def with arity " (string-append (PreludeC-45Show-u--show_Show_Nat e-16) ">")))) ((3) (let ((e-17 (vector-ref arg-0 1))) (let ((e-18 (vector-ref arg-0 2))) (string-append "<foreign def with arity " (string-append (PreludeC-45Show-u--show_Show_Nat e-17) (string-append " " (string-append (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-493 e-18) ">"))))))) ((4) (let ((e-19 (vector-ref arg-0 1))) (string-append "<builtin with arith " (string-append (PreludeC-45Show-u--show_Show_Nat e-19) ">")))) ((7) (let ((e-22 (vector-ref arg-0 2))) (string-append "Hole" (let ((sc1 (let ((e-0 (car e-22))) e-0))) (cond ((equal? sc1 1) " [impl]") (else "")))))) ((8) (let ((e-25 (vector-ref arg-0 3))) (string-append "Search in " (CoreC-45Name-u--show_Show_Name e-25)))) ((9) (let ((e-26 (vector-ref arg-0 1))) (let ((e-28 (vector-ref arg-0 3))) (string-append "Guess " (string-append (CoreC-45TTC-45Term-u--show_Show_C-40TermC-32C-36varsC-41 '() e-26) (string-append " when " (PreludeC-45Show-u--show_Show_C-40ListC-32C-36aC-41 csegen-495 e-28))))))) ((11) (let ((e-29 (vector-ref arg-0 1))) (string-append "Universe level #" (PreludeC-45Show-u--show_Show_Integer e-29)))) ((10) "Bound name") (else "Delayed"))))
(define CoreC-45ContextC-45Context-u--showPrec_Show_Def (lambda (arg-0 arg-1) (CoreC-45ContextC-45Context-u--show_Show_Def arg-1)))
(define csegen-1947 (cons (lambda (u--x) (CoreC-45ContextC-45Context-u--show_Show_Def u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45ContextC-45Context-u--showPrec_Show_Def u--d u--x)))))
(define csegen-1950 (vector 1 (vector 22 (vector 1 (vector 0 "Type")) '())))
(define csegen-1952 (vector 1 (vector 22 (vector 1 (vector 0 "__")) '())))
(define CoreC-45Context-u--full_HasNames_C-40CaseAltC-32C-36varsC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (let ((e-4 (vector-ref arg-2 4))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-4 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-lookupCtxtExact e-1 arg-1) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (clam-1) (if (null? e-6) (vector 1 (vector 0 e-1 e-2 e-3 e-5)) (let ((e-7 (unbox e-6))) (vector 1 (vector 0 (let ((e-29 (vector-ref e-7 1))) e-29) e-2 e-3 e-5))))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))))) ((1) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-8 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-6 e-7 e-5))))) eff-0) ext-0))))))))) ((2) (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-11 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-10 e-5))))) eff-0) ext-0)))))))) (else (let ((e-13 (vector-ref arg-2 1))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-1 e-13 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 3 e-5))))) eff-0) ext-0))))))))))
(define CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 (lambda (arg-1 arg-2 ext-0) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (let ((e-2 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((e-5 (vector-ref arg-2 4))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-4) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-6 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Core-traverseC-39 (lambda (arg-3) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_C-40CaseAltC-32C-36varsC-41 arg-1 arg-3 eta-1))) e-5 '()) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-3 (vector-ref act-2 1))) (vector 0 e-3))) (else (let ((e-7 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 0 e-1 e-2 e-6 e-7))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))))) ((1) (let ((e-7 (vector-ref arg-2 1))) (let ((e-8 (vector-ref arg-2 2))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-1 e-8) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 1 e-7 e-5))))) eff-0) ext-0))))))))(else (vector 1 arg-2)))))
(define CoreC-45Context-n--13894-9685-u--fullNamesPat (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 arg-6) (let ((e-2 (car arg-6))) (let ((e-3 (cdr arg-6))) (lambda (clam-0) (let ((e-6 (car e-3))) (let ((e-7 (cdr e-3))) (let ((e-10 (car e-7))) (let ((e-11 (cdr e-7))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40C-40EnvC-32TermC-41C-32C-36varsC-41 arg-5 e-6 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-5 e-10) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-8 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-3 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-5 e-11) eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-4 (vector-ref act-3 1))) (vector 0 e-4))) (else (let ((e-9 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (cons e-2 (cons e-5 (cons e-8 e-9))))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) clam-0))))))))))))))
(define CoreC-45Context-u--full_HasNames_Def (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((1) (let ((e-0 (vector-ref arg-1 1))) (let ((e-1 (vector-ref arg-1 2))) (let ((e-2 (vector-ref arg-1 3))) (let ((e-3 (vector-ref arg-1 4))) (let ((e-4 (vector-ref arg-1 5))) (let ((act-1 (CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-0 e-2 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-5 (vector-ref act-1 1))) (vector 0 e-5))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (CoreC-45Context-u--full_HasNames_C-40CaseTreeC-32C-36varsC-41 arg-0 e-3 eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-6 (vector-ref act-2 1))) (vector 0 e-6))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (let ((act-3 ((CoreC-45Core-traverseC-39 (lambda (eta-2) (CoreC-45Context-n--13894-9685-u--fullNamesPat e-4 e-1 e-3 e-2 e-0 arg-0 eta-2)) e-4 '()) eta-1))) (case (vector-ref act-3 0) ((0) (let ((e-7 (vector-ref act-3 1))) (vector 0 e-7))) (else (let ((e-7 (vector-ref act-3 1))) ((let ((eff-0 (lambda (eta-2) (vector 1 (vector 1 e-0 e-1 e-5 e-6 e-7))))) eff-0) eta-1)))))))) eff-0) eta-0)))))))) eff-0) ext-0))))))))))) ((6) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (let ((e-7 (vector-ref arg-1 3))) (let ((e-8 (vector-ref arg-1 4))) (let ((e-9 (vector-ref arg-1 5))) (let ((e-10 (vector-ref arg-1 6))) (let ((e-11 (vector-ref arg-1 7))) (let ((e-12 (vector-ref arg-1 8))) (let ((act-1 ((CoreC-45Core-traverseC-39 (lambda (eta-0) (lambda (eta-1) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-0 eta-1))) e-10 '()) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-13 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 ((CoreC-45Core-traverseC-39 (lambda (eta-1) (lambda (eta-2) (CoreC-45Context-u--full_HasNames_Name arg-0 eta-1 eta-2))) e-11 '()) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-2 (vector-ref act-2 1))) (vector 0 e-2))) (else (let ((e-14 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (vector 1 (vector 6 e-5 e-6 e-7 e-8 e-9 e-13 e-14 e-12))))) eff-0) eta-0)))))))) eff-0) ext-0)))))))))))))) ((8) (let ((e-13 (vector-ref arg-1 1))) (let ((e-14 (vector-ref arg-1 2))) (let ((e-15 (vector-ref arg-1 3))) (let ((act-1 (CoreC-45Context-u--full_HasNames_Name arg-0 e-15 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 8 e-13 e-14 e-5))))) eff-0) ext-0))))))))) ((9) (let ((e-16 (vector-ref arg-1 1))) (let ((e-17 (vector-ref arg-1 2))) (let ((e-18 (vector-ref arg-1 3))) (let ((act-1 ((CoreC-45Context-u--full_HasNames_C-40TermC-32C-36varsC-41 arg-0 e-16) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 9 e-5 e-17 e-18))))) eff-0) ext-0)))))))))(else (vector 1 arg-1)))))
(define csegen-1966 (cons (lambda (arg-7719) (lambda (arg-7722) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Def arg-7719 arg-7722 eta-0)))) (lambda (arg-7729) (lambda (arg-7732) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Def arg-7729 arg-7732 eta-0))))))
(define System-exitWith (lambda (arg-2 arg-3) (if (null? arg-3) (let ((e-2 (cdr arg-2))) ((e-2 'erased) (lambda (eta-0) (System-prim__exit 0 eta-0)))) (let ((e-0 (car arg-3))) (let ((e-2 (cdr arg-2))) ((e-2 'erased) (lambda (eta-0) (System-prim__exit e-0 eta-0))))))))
(define csegen-1969 (System-exitWith csegen-82 (cons 1 (vector 0 ))))
(define LibrariesC-45DataC-45UserNameMap-empty '())
(define LibrariesC-45DataC-45ANameMap-empty (cons LibrariesC-45DataC-45NameMap-empty LibrariesC-45DataC-45UserNameMap-empty))
(define IdrisC-45Syntax-n--17143-7692-u--initDocStrings LibrariesC-45DataC-45ANameMap-empty)
(define CoreC-45Name-userNameRoot (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-1 (vector-ref arg-0 2))) (CoreC-45Name-userNameRoot e-1))) ((1) (let ((e-2 (vector-ref arg-0 1))) (box e-2))) ((4) (let ((e-4 (vector-ref arg-0 2))) (CoreC-45Name-userNameRoot e-4)))(else '()))))
(define CoreC-45Name-u--C-60C-61_Ord_UserName (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45Name-u--compare_Ord_UserName arg-0 arg-1) 2)))
(define LibrariesC-45DataC-45UserNameMap-treeInsertC-39 (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) (let ((e-2 (vector-ref arg-4 2))) (let ((sc1 (CoreC-45Name-u--compare_Ord_UserName arg-2 e-1))) (cond ((equal? sc1 0) (vector 1 (cons (vector 0 arg-2 arg-3) (cons arg-2 (vector 0 e-1 e-2))))) ((equal? sc1 1) (vector 0 (vector 0 arg-2 arg-3))) (else (vector 1 (cons (vector 0 e-1 e-2) (cons e-1 (vector 0 arg-2 arg-3)))))))))) ((1) (let ((e-5 (vector-ref arg-4 1))) (let ((e-6 (vector-ref arg-4 2))) (let ((e-7 (vector-ref arg-4 3))) (let ((sc1 (CoreC-45Name-u--C-60C-61_Ord_UserName arg-2 e-6))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45UserNameMap-treeInsertC-39 arg-2 arg-3 e-5))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-2 e-6 e-7)))) (else (let ((e-8 (vector-ref sc2 1))) (let ((e-10 (car e-8))) (let ((e-9 (cdr e-8))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 0 (vector 2 e-10 e-12 e-13 e-6 e-7))))))))))) (else (let ((sc2 (LibrariesC-45DataC-45UserNameMap-treeInsertC-39 arg-2 arg-3 e-7))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 1 e-5 e-6 e-2)))) (else (let ((e-8 (vector-ref sc2 1))) (let ((e-10 (car e-8))) (let ((e-9 (cdr e-8))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 0 (vector 2 e-5 e-6 e-10 e-12 e-13))))))))))))))))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-11 (vector-ref arg-4 2))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-13 (vector-ref arg-4 4))) (let ((e-14 (vector-ref arg-4 5))) (let ((sc1 (CoreC-45Name-u--C-60C-61_Ord_UserName arg-2 e-11))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45UserNameMap-treeInsertC-39 arg-2 arg-3 e-10))) (case (vector-ref sc2 0) ((0) (let ((e-2 (vector-ref sc2 1))) (vector 0 (vector 2 e-2 e-11 e-12 e-13 e-14)))) (else (let ((e-5 (vector-ref sc2 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-8 e-16 e-15) (cons e-11 (vector 1 e-12 e-13 e-14))))))))))))) (else (let ((sc2 (CoreC-45Name-u--C-60C-61_Ord_UserName arg-2 e-13))) (cond ((equal? sc2 1) (let ((sc3 (LibrariesC-45DataC-45UserNameMap-treeInsertC-39 arg-2 arg-3 e-12))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-10 e-11 e-2 e-13 e-14)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-10 e-11 e-8) (cons e-16 (vector 1 e-15 e-13 e-14))))))))))))) (else (let ((sc3 (LibrariesC-45DataC-45UserNameMap-treeInsertC-39 arg-2 arg-3 e-14))) (case (vector-ref sc3 0) ((0) (let ((e-2 (vector-ref sc3 1))) (vector 0 (vector 2 e-10 e-11 e-12 e-13 e-2)))) (else (let ((e-5 (vector-ref sc3 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-16 (car e-9))) (let ((e-15 (cdr e-9))) (vector 1 (cons (vector 1 e-10 e-11 e-12) (cons e-13 (vector 1 e-8 e-16 e-15)))))))))))))))))))))))))))
(define LibrariesC-45DataC-45UserNameMap-treeInsert (lambda (arg-2 arg-3 arg-4) (let ((sc0 (LibrariesC-45DataC-45UserNameMap-treeInsertC-39 arg-2 arg-3 arg-4))) (case (vector-ref sc0 0) ((0) (let ((e-2 (vector-ref sc0 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref sc0 1))) (let ((e-8 (car e-5))) (let ((e-9 (cdr e-5))) (let ((e-12 (car e-9))) (let ((e-13 (cdr e-9))) (vector 1 (vector 1 e-8 e-12 e-13))))))))))))
(define LibrariesC-45DataC-45UserNameMap-insert (lambda (arg-1 arg-2 arg-3) (if (null? arg-3) (cons 0 (vector 0 arg-1 arg-2)) (let ((e-2 (car arg-3))) (let ((e-3 (cdr arg-3))) (let ((sc1 (LibrariesC-45DataC-45UserNameMap-treeInsert arg-1 arg-2 e-3))) (case (vector-ref sc1 0) ((0) (let ((e-4 (vector-ref sc1 1))) (cons e-2 e-4))) (else (let ((e-5 (vector-ref sc1 1))) (cons (+ e-2 1) e-5))))))))))
(define LibrariesC-45DataC-45UserNameMap-treeLookup (lambda (arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (let ((e-1 (vector-ref arg-3 1))) (let ((e-2 (vector-ref arg-3 2))) (let ((sc1 (CoreC-45Name-u--C-61C-61_Eq_UserName arg-2 e-1))) (cond ((equal? sc1 1) (box e-2)) (else '())))))) ((1) (let ((e-5 (vector-ref arg-3 1))) (let ((e-6 (vector-ref arg-3 2))) (let ((e-7 (vector-ref arg-3 3))) (let ((sc1 (CoreC-45Name-u--C-60C-61_Ord_UserName arg-2 e-6))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45UserNameMap-treeLookup arg-2 e-5)) (else (LibrariesC-45DataC-45UserNameMap-treeLookup arg-2 e-7)))))))) (else (let ((e-10 (vector-ref arg-3 1))) (let ((e-11 (vector-ref arg-3 2))) (let ((e-12 (vector-ref arg-3 3))) (let ((e-13 (vector-ref arg-3 4))) (let ((e-14 (vector-ref arg-3 5))) (let ((sc1 (CoreC-45Name-u--C-60C-61_Ord_UserName arg-2 e-11))) (cond ((equal? sc1 1) (LibrariesC-45DataC-45UserNameMap-treeLookup arg-2 e-10)) (else (let ((sc2 (CoreC-45Name-u--C-60C-61_Ord_UserName arg-2 e-13))) (cond ((equal? sc2 1) (LibrariesC-45DataC-45UserNameMap-treeLookup arg-2 e-12)) (else (LibrariesC-45DataC-45UserNameMap-treeLookup arg-2 e-14))))))))))))))))
(define LibrariesC-45DataC-45UserNameMap-lookup (lambda (arg-1 arg-2) (if (null? arg-2) '() (let ((e-3 (cdr arg-2))) (LibrariesC-45DataC-45UserNameMap-treeLookup arg-1 e-3)))))
(define LibrariesC-45DataC-45ANameMap-n--3984-12729-u--update (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (if (null? arg-5) (cons (cons arg-3 arg-4) '()) (let ((e-2 (car arg-5))) (let ((e-3 (cdr arg-5))) (let ((sc1 (CoreC-45Name-u--C-61C-61_Eq_Name arg-3 (Builtin-fst e-2)))) (cond ((equal? sc1 1) (cons (cons arg-3 arg-4) e-3)) (else (cons e-2 (LibrariesC-45DataC-45ANameMap-n--3984-12729-u--update arg-1 arg-2 arg-3 arg-4 e-3))))))))))
(define LibrariesC-45DataC-45ANameMap-case--addToHier-12810 (lambda (arg-1 arg-2 arg-3 arg-4) (if (null? arg-4) arg-2 (let ((e-2 (unbox arg-4))) (let ((sc1 (LibrariesC-45DataC-45UserNameMap-lookup e-2 arg-2))) (if (null? sc1) (LibrariesC-45DataC-45UserNameMap-insert e-2 (cons (cons arg-3 arg-1) '()) arg-2) (let ((e-3 (unbox sc1))) (LibrariesC-45DataC-45UserNameMap-insert e-2 (LibrariesC-45DataC-45ANameMap-n--3984-12729-u--update arg-1 arg-2 arg-3 arg-1 e-3) arg-2))))))))
(define LibrariesC-45DataC-45ANameMap-addToHier (lambda (arg-1 arg-2 arg-3) (LibrariesC-45DataC-45ANameMap-case--addToHier-12810 arg-2 arg-3 arg-1 (CoreC-45Name-userNameRoot arg-1))))
(define LibrariesC-45DataC-45ANameMap-addName (lambda (arg-1 arg-2 arg-3) (let ((e-1 (car arg-3))) (let ((e-2 (cdr arg-3))) (let ((u--dictC-39 (LibrariesC-45DataC-45NameMap-insert arg-1 arg-2 e-1))) (let ((u--hierC-39 (LibrariesC-45DataC-45ANameMap-addToHier arg-1 arg-2 e-2))) (cons u--dictC-39 u--hierC-39)))))))
(define LibrariesC-45DataC-45ANameMap-n--4326-13032-u--fromListC-39 (lambda (arg-1 arg-2) (if (null? arg-2) arg-1 (let ((e-2 (car arg-2))) (let ((e-3 (cdr arg-2))) (let ((e-6 (car e-2))) (let ((e-7 (cdr e-2))) (LibrariesC-45DataC-45ANameMap-n--4326-13032-u--fromListC-39 (LibrariesC-45DataC-45ANameMap-addName e-6 e-7 arg-1) e-3))))))))
(define LibrariesC-45DataC-45ANameMap-fromList (lambda (ext-0) (LibrariesC-45DataC-45ANameMap-n--4326-13032-u--fromListC-39 LibrariesC-45DataC-45ANameMap-empty ext-0)))
(define IdrisC-45Syntax-n--17143-7693-u--initFixities (LibrariesC-45DataC-45ANameMap-fromList (cons (cons (vector 1 (vector 0 "-")) csegen-237) (cons (cons (vector 1 (vector 0 "negate")) csegen-237) (cons (cons (vector 1 (vector 0 "=")) (vector (vector 2 ) 1 2 0)) '())))))
(define IdrisC-45Syntax-n--17143-7694-u--initSaveDocStrings LibrariesC-45DataC-45NameMap-empty)
(define IdrisC-45Syntax-initSyntax (vector IdrisC-45Syntax-n--17143-7693-u--initFixities '() csegen-285 csegen-285 '() LibrariesC-45DataC-45ANameMap-empty IdrisC-45Syntax-n--17143-7694-u--initSaveDocStrings IdrisC-45Syntax-n--17143-7692-u--initDocStrings '() '() (vector 0 (vector 2 ) (vector 1 (vector 0 "main"))) '()))
(define csegen-1981 (CoreC-45Core-newRef (vector "Idris.Syntax.Syn" ) IdrisC-45Syntax-initSyntax))
(define SystemC-45FileC-45Virtual-stdin (SystemC-45FileC-45Virtual-prim__stdin))
(define SystemC-45FileC-45Virtual-stdout (SystemC-45FileC-45Virtual-prim__stdout))
(define csegen-1983 (vector 0 0 SystemC-45FileC-45Virtual-stdin SystemC-45FileC-45Virtual-stdout))
(define CoreC-45UnifyState-initUState (vector LibrariesC-45DataC-45IntMap-empty LibrariesC-45DataC-45IntMap-empty LibrariesC-45DataC-45IntMap-empty LibrariesC-45DataC-45IntMap-empty LibrariesC-45DataC-45IntMap-empty LibrariesC-45DataC-45IntMap-empty '() '() 0 0 '() 0))
(define csegen-1985 (CoreC-45Core-newRef (vector "Core.UnifyState.UST" ) CoreC-45UnifyState-initUState))
(define csegen-1987 (lambda (eta-0) (LibrariesC-45TextC-45PrettyPrintC-45PrettyprinterC-45Doc-pretty0 csegen-702 (Builtin-fst eta-0))))
(define csegen-1994 (LibrariesC-45DataC-45Version-showVersion 1 IdrisC-45Version-version))
(define CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124UnitC-44MkUnitC-124C-41 (lambda (arg-0 ext-0) (vector 1 (vector 0 ))))
(define CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124UnitC-44MkUnitC-124C-41 (lambda (arg-0 arg-1 ext-0) (vector 1 (vector 0 ))))
(define csegen-2002 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124UnitC-44MkUnitC-124C-41 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124UnitC-44MkUnitC-124C-41 arg-5542 eta-0)))))
(define csegen-2006 (let ((eff-0 (lambda (world-0) (let ((act-1 (PreludeC-45IO-prim__putStr "Processing as TTImp\xa;" world-0))) (vector 1 act-1))))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-26 eff-0 eta-0))))
(define YaffleC-45Main-u--full_HasNames_C-40C-124UnitC-44MkUnitC-124C-41 (lambda (arg-0 arg-1 ext-0) (vector 1 (vector 0 ))))
(define YaffleC-45Main-u--resolved_HasNames_C-40C-124UnitC-44MkUnitC-124C-41 (lambda (arg-0 arg-1 ext-0) (vector 1 (vector 0 ))))
(define csegen-2010 (cons (cons (lambda (arg-7719) (lambda (arg-7722) (lambda (eta-0) (YaffleC-45Main-u--full_HasNames_C-40C-124UnitC-44MkUnitC-124C-41 arg-7719 arg-7722 eta-0)))) (lambda (arg-7729) (lambda (arg-7732) (lambda (eta-0) (YaffleC-45Main-u--resolved_HasNames_C-40C-124UnitC-44MkUnitC-124C-41 arg-7729 arg-7732 eta-0))))) csegen-2002))
(define csegen-2012 (let ((eff-0 (lambda (world-0) (let ((act-1 (PreludeC-45IO-prim__putStr "Written TTC\xa;" world-0))) (vector 1 act-1))))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-26 eff-0 eta-0))))
(define YaffleC-45Main-usage "Usage: yaffle <input file> [--timing]")
(define csegen-2013 (lambda (eta-0) (PreludeC-45IO-prim__putStr (string-append YaffleC-45Main-usage "\xa;") eta-0)))
(define CoreC-45TT-u--show_Show_KindedName (lambda (ext-0) (CoreC-45Name-u--show_Show_Name (let ((e-2 (vector-ref ext-0 2))) e-2))))
(define CoreC-45TT-u--showPrec_Show_KindedName (lambda (arg-0 arg-1) (CoreC-45TT-u--show_Show_KindedName arg-1)))
(define csegen-2016 (cons (lambda (u--x) (CoreC-45TT-u--show_Show_KindedName u--x)) (lambda (u--d) (lambda (u--x) (CoreC-45TT-u--showPrec_Show_KindedName u--d u--x)))))
(define csegen-2025 (cons (lambda (u--x) (TTImpC-45TTImp-u--show_Show_C-40ImpClauseC-39C-32C-36nmC-41 csegen-65 u--x)) (lambda (u--d) (lambda (u--x) (TTImpC-45TTImp-u--showPrec_Show_C-40ImpClauseC-39C-32C-36nmC-41 csegen-65 u--d u--x)))))
(define csegen-2027 (let ((eff-0 (lambda (world-0) (let ((act-1 (PreludeC-45IO-prim__putStr "Failed\xa;" world-0))) (vector 1 act-1))))) (lambda (eta-0) (PreludeC-45IO-u--map_Functor_IO csegen-26 eff-0 eta-0))))
(define csegen-2039 (cons csegen-499 csegen-499))
(define csegen-2043 (cons csegen-962 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2039 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2039 u--d u--x))))))
(define csegen-2046 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2043 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2043 u--d u--x)))))
(define ProtocolC-45IDEC-45Decoration-u--show_Show_Decoration (lambda (arg-0) (cond ((equal? arg-0 0) "comment") ((equal? arg-0 1) "type") ((equal? arg-0 2) "function") ((equal? arg-0 3) "data") ((equal? arg-0 4) "keyword") ((equal? arg-0 5) "bound") ((equal? arg-0 6) "namespace") ((equal? arg-0 7) "postulate") (else "module"))))
(define csegen-2049 (cons (cons (lambda (u--x) (ProtocolC-45IDEC-45Decoration-u--show_Show_Decoration u--x)) (lambda (u--d) (lambda (u--x) (ProtocolC-45IDEC-45Decoration-u--show_Show_Decoration u--x)))) csegen-972))
(define csegen-2053 (cons csegen-2046 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2049 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2049 u--d u--x))))))
(define csegen-2056 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2053 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2053 u--d u--x)))))
(define csegen-2062 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1563 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1563 arg-5542 eta-0)))))
(define csegen-2063 (cons csegen-2062 csegen-2062))
(define csegen-2067 (cons (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45TTC-u--toBuf_TTC_OriginDesc arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45TTC-u--fromBuf_TTC_OriginDesc arg-5542 eta-0)))) (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2063 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2063 arg-5542 eta-0))))))
(define csegen-2070 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2067 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2067 arg-5542 eta-0)))))
(define csegen-2071 (cons csegen-1535 csegen-1590))
(define csegen-2074 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2071 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2071 arg-5542 eta-0)))))
(define csegen-2075 (cons csegen-2070 csegen-2074))
(define csegen-2078 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2075 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2075 arg-5542 eta-0)))))
(define csegen-2079 (cons csegen-41 csegen-2074))
(define csegen-2083 (cons csegen-2070 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2079 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2079 arg-5542 eta-0))))))
(define csegen-2086 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2083 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2083 arg-5542 eta-0)))))
(define csegen-2087 (cons csegen-41 csegen-1590))
(define csegen-2090 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2087 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2087 arg-5542 eta-0)))))
(define csegen-2091 (cons csegen-2070 csegen-41))
(define LibrariesC-45DataC-45PosMap-u--measure_Measure_C-40C-124C-40C-40BuiltinC-46PairC-32NonEmptyFCC-41C-32C-36aC-41C-44C-40C-40BuiltinC-46MkPairC-32NonEmptyFCC-41C-32C-36aC-41C-124C-41 (lambda (ext-0) ((let ((eff-0 (lambda (arg-2895) (Builtin-snd arg-2895)))) (lambda (arg-0) (eff-0 arg-0))) (Builtin-fst ext-0))))
(define csegen-2095 (cons (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2091 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2091 arg-5542 eta-0)))) (lambda (eta-0) (LibrariesC-45DataC-45PosMap-u--measure_Measure_C-40C-124C-40C-40BuiltinC-46PairC-32NonEmptyFCC-41C-32C-36aC-41C-44C-40C-40BuiltinC-46MkPairC-32NonEmptyFCC-41C-32C-36aC-41C-124C-41 eta-0))))
(define CoreC-45Metadata-u--fromBuf_TTC_Decoration (lambda (arg-0 ext-0) (let ((act-1 (CoreC-45BinaryC-45Prims-getTag arg-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (cond ((equal? e-5 0) (vector 1 1)) ((equal? e-5 1) (vector 1 2)) ((equal? e-5 2) (vector 1 3)) ((equal? e-5 3) (vector 1 4)) ((equal? e-5 4) (vector 1 5)) ((equal? e-5 5) (vector 1 6)) ((equal? e-5 6) (vector 1 7)) ((equal? e-5 7) (vector 1 8)) ((equal? e-5 8) (vector 1 0))(else (CoreC-45BinaryC-45Prims-corrupt "Decoration" clam-0)))))) eff-0) ext-0)))))))
(define CoreC-45Metadata-u--toBuf_TTC_Decoration (lambda (arg-0 arg-1 ext-0) (cond ((equal? arg-1 1) (CoreC-45BinaryC-45Prims-tag arg-0 0 ext-0)) ((equal? arg-1 2) (CoreC-45BinaryC-45Prims-tag arg-0 1 ext-0)) ((equal? arg-1 3) (CoreC-45BinaryC-45Prims-tag arg-0 2 ext-0)) ((equal? arg-1 4) (CoreC-45BinaryC-45Prims-tag arg-0 3 ext-0)) ((equal? arg-1 5) (CoreC-45BinaryC-45Prims-tag arg-0 4 ext-0)) ((equal? arg-1 6) (CoreC-45BinaryC-45Prims-tag arg-0 5 ext-0)) ((equal? arg-1 7) (CoreC-45BinaryC-45Prims-tag arg-0 6 ext-0)) ((equal? arg-1 8) (CoreC-45BinaryC-45Prims-tag arg-0 7 ext-0)) (else (CoreC-45BinaryC-45Prims-tag arg-0 8 ext-0)))))
(define csegen-2102 (cons (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45Metadata-u--toBuf_TTC_Decoration arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45Metadata-u--fromBuf_TTC_Decoration arg-5542 eta-0)))) (cons (lambda (arg-5529) (lambda (arg-5534) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-41 arg-5529 arg-5534))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40MaybeC-32C-36aC-41 csegen-41 arg-5542 eta-0))))))
(define csegen-2106 (cons csegen-2070 (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2102 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2102 arg-5542 eta-0))))))
(define csegen-2110 (cons (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2106 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2106 arg-5542 eta-0)))) (lambda (eta-0) (LibrariesC-45DataC-45PosMap-u--measure_Measure_C-40C-124C-40C-40BuiltinC-46PairC-32NonEmptyFCC-41C-32C-36aC-41C-44C-40C-40BuiltinC-46MkPairC-32NonEmptyFCC-41C-32C-36aC-41C-124C-41 eta-0))))
(define csegen-2111 (cons csegen-2070 csegen-2070))
(define csegen-2115 (cons (cons (lambda (arg-5529) (lambda (arg-5534) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--toBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2111 arg-5529 arg-5534 eta-0)))) (lambda (arg-5542) (lambda (eta-0) (CoreC-45BinaryC-45Prims-u--fromBuf_TTC_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2111 arg-5542 eta-0)))) (lambda (eta-0) (LibrariesC-45DataC-45PosMap-u--measure_Measure_C-40C-124C-40C-40BuiltinC-46PairC-32NonEmptyFCC-41C-32C-36aC-41C-44C-40C-40BuiltinC-46MkPairC-32NonEmptyFCC-41C-32C-36aC-41C-124C-41 eta-0))))
(define csegen-2116 (cons csegen-895 csegen-1268))
(define csegen-2119 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2116 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2116 u--d u--x)))))
(define csegen-2120 (cons csegen-2046 csegen-2119))
(define csegen-2124 (cons csegen-65 csegen-2119))
(define csegen-2128 (cons csegen-2046 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2124 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2124 u--d u--x))))))
(define csegen-2131 (cons (lambda (u--x) (PreludeC-45Show-u--show_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2128 u--x)) (lambda (u--d) (lambda (u--x) (PreludeC-45Show-u--showPrec_Show_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-2128 u--d u--x)))))
(define csegen-2132 (cons csegen-65 csegen-1268))
(define csegen-2136 (cons csegen-2046 csegen-65))
(define csegen-2140 (cons csegen-2046 csegen-2046))
(define CoreC-45Name-dropNS (lambda (arg-0) (case (vector-ref arg-0 0) ((0) (let ((e-1 (vector-ref arg-0 2))) e-1))(else arg-0))))
(define csegen-2144 (lambda (u--x) (lambda (u--y) (CoreC-45Name-u--C-61C-61_Eq_Name (CoreC-45Name-dropNS u--x) (CoreC-45Name-dropNS u--y)))))
(define LibrariesC-45DataC-45PosMap-u--foldr_Foldable_Digit (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) ((arg-2 e-1) arg-3))) ((1) (let ((e-3 (vector-ref arg-4 1))) (let ((e-4 (vector-ref arg-4 2))) ((arg-2 e-3) ((arg-2 e-4) arg-3))))) ((2) (let ((e-6 (vector-ref arg-4 1))) (let ((e-7 (vector-ref arg-4 2))) (let ((e-8 (vector-ref arg-4 3))) ((arg-2 e-6) ((arg-2 e-7) ((arg-2 e-8) arg-3))))))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-11 (vector-ref arg-4 2))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-13 (vector-ref arg-4 4))) ((arg-2 e-10) ((arg-2 e-11) ((arg-2 e-12) ((arg-2 e-13) arg-3))))))))))))
(define LibrariesC-45DataC-45PosMap-u--foldr_Foldable_Node (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) (let ((e-2 (vector-ref arg-4 2))) (let ((e-3 (vector-ref arg-4 3))) ((arg-2 e-2) ((arg-2 e-3) arg-3))))) (else (let ((e-6 (vector-ref arg-4 2))) (let ((e-7 (vector-ref arg-4 3))) (let ((e-8 (vector-ref arg-4 4))) ((arg-2 e-6) ((arg-2 e-7) ((arg-2 e-8) arg-3))))))))))
(define LibrariesC-45DataC-45PosMap-u--foldr_Foldable_PosMap (lambda (arg-2 arg-3 arg-4) (case (vector-ref arg-4 0) ((0) arg-3) ((1) (let ((e-2 (vector-ref arg-4 1))) ((arg-2 e-2) arg-3))) (else (let ((e-5 (vector-ref arg-4 2))) (let ((e-6 (vector-ref arg-4 3))) (let ((e-7 (vector-ref arg-4 4))) (LibrariesC-45DataC-45PosMap-u--foldr_Foldable_Digit arg-2 (LibrariesC-45DataC-45PosMap-u--foldr_Foldable_PosMap (lambda (eta-0) (lambda (eta-1) (PreludeC-45Basics-flip (lambda (eta-2) (lambda (eta-3) (LibrariesC-45DataC-45PosMap-u--foldr_Foldable_Node arg-2 eta-2 eta-3))) eta-0 eta-1))) (LibrariesC-45DataC-45PosMap-u--foldr_Foldable_Digit arg-2 arg-3 e-7) e-6) e-5))))))))
(define LibrariesC-45DataC-45PosMap-u--foldMap_Foldable_PosMap (lambda (arg-2 arg-3 ext-0) (LibrariesC-45DataC-45PosMap-u--foldr_Foldable_PosMap (lambda (eta-0) (lambda (eta-1) (let ((e-1 (car arg-2))) ((e-1 (arg-3 eta-0)) eta-1)))) (let ((e-2 (cdr arg-2))) e-2) ext-0)))
(define csegen-2145 (lambda (eta-0) (lambda (eta-1) (LibrariesC-45DataC-45PosMap-u--foldMap_Foldable_PosMap csegen-57 eta-0 eta-1))))
(define LibrariesC-45DataC-45PosMap-u--cast_Cast_FileRange_RMFileRange (lambda (arg-0) (let ((e-2 (car arg-0))) (let ((e-3 (cdr arg-0))) (cons (cons e-2 e-3) e-3)))))
(define LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-36a (lambda (arg-1 ext-0) (LibrariesC-45DataC-45PosMap-u--cast_Cast_FileRange_RMFileRange (arg-1 ext-0))))
(define csegen-2146 (lambda (eta-0) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-36a (lambda (eta-1) (LibrariesC-45DataC-45PosMap-u--measure_Measure_C-40C-124C-40C-40BuiltinC-46PairC-32NonEmptyFCC-41C-32C-36aC-41C-44C-40C-40BuiltinC-46MkPairC-32NonEmptyFCC-41C-32C-36aC-41C-124C-41 eta-1)) eta-0)))
(define LibrariesC-45DataC-45PosMap-greater (lambda (arg-0 arg-1) (if (null? arg-1) 0 (let ((e-0 (unbox arg-1))) (let ((e-1 (car e-0))) (PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-231 csegen-231 (Builtin-fst e-1) arg-0))))))
(define LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (lambda (ext-0) (box ext-0)))
(define LibrariesC-45DataC-45PosMap-u--neutral_Monoid_Interval '())
(define LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) LibrariesC-45DataC-45PosMap-u--neutral_Monoid_Interval) ((1) (let ((e-2 (vector-ref arg-2 1))) (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-2)))) (else (let ((e-4 (vector-ref arg-2 1))) (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval e-4))))))
(define LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (lambda (arg-0 arg-1) (let ((e-1 (cdr arg-0))) (let ((e-2 (car arg-1))) (let ((e-3 (cdr arg-1))) (cons e-2 (PreludeC-45EqOrd-u--max_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-231 csegen-231 e-1 e-3)))))))
(define LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (arg-1 e-1))) ((1) (let ((e-3 (vector-ref arg-2 1))) (let ((e-4 (vector-ref arg-2 2))) (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (arg-1 e-3) (arg-1 e-4))))) ((2) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (arg-1 e-6) (arg-1 e-7)) (arg-1 e-8)))))) (else (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (arg-1 e-10) (arg-1 e-11)) (arg-1 e-12)) (arg-1 e-13))))))))))
(define LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 (lambda (arg-1) (case (vector-ref arg-1 0) ((0) (let ((e-1 (vector-ref arg-1 1))) e-1)) (else (let ((e-5 (vector-ref arg-1 1))) e-5)))))
(define LibrariesC-45DataC-45PosMap-n--5633-4876-u--value (lambda (arg-1 arg-2 arg-3 arg-4) (let ((sc0 (LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2933)) arg-3))) (if (null? sc0) (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange ((let ((eff-0 (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2933)))) (lambda (arg-0) (eff-0 arg-0))) arg-4) ((let ((eff-0 (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2933)))) (lambda (arg-0) (eff-0 arg-0))) arg-2)) (let ((e-0 (unbox sc0))) (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange ((let ((eff-0 (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2933)))) (lambda (arg-0) (eff-0 arg-0))) arg-4) e-0) ((let ((eff-0 (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2933)))) (lambda (arg-0) (eff-0 arg-0))) arg-2)))))))
(define LibrariesC-45DataC-45PosMap-deep (lambda (arg-1 arg-2 arg-3 arg-4) (vector 2 (LibrariesC-45DataC-45PosMap-n--5633-4876-u--value arg-1 arg-4 arg-3 arg-2) arg-2 arg-3 arg-4)))
(define LibrariesC-45DataC-45PosMap-node3 (lambda (arg-1 arg-2 arg-3 arg-4) (vector 1 (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange (arg-1 arg-2) (arg-1 arg-3)) (arg-1 arg-4)) arg-2 arg-3 arg-4)))
(define LibrariesC-45DataC-45PosMap-C-60C-124 (lambda (arg-1 arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (vector 1 arg-2)) ((1) (let ((e-2 (vector-ref arg-3 1))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 0 arg-2) (vector 0 ) (vector 0 e-2)))) (else (let ((e-5 (vector-ref arg-3 2))) (let ((e-6 (vector-ref arg-3 3))) (let ((e-7 (vector-ref arg-3 4))) (case (vector-ref e-5 0) ((0) (let ((e-9 (vector-ref e-5 1))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 1 arg-2 e-9) e-6 e-7))) ((1) (let ((e-11 (vector-ref e-5 1))) (let ((e-12 (vector-ref e-5 2))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 2 arg-2 e-11 e-12) e-6 e-7)))) ((2) (let ((e-14 (vector-ref e-5 1))) (let ((e-15 (vector-ref e-5 2))) (let ((e-16 (vector-ref e-5 3))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 3 arg-2 e-14 e-15 e-16) e-6 e-7))))) (else (let ((e-18 (vector-ref e-5 1))) (let ((e-19 (vector-ref e-5 2))) (let ((e-20 (vector-ref e-5 3))) (let ((e-21 (vector-ref e-5 4))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 1 arg-2 e-18) (LibrariesC-45DataC-45PosMap-C-60C-124 (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2933)) (LibrariesC-45DataC-45PosMap-node3 arg-1 e-19 e-20 e-21) e-6) e-7))))))))))))))
(define LibrariesC-45DataC-45PosMap-digitToTree (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-1 (vector-ref arg-2 1))) (vector 1 e-1))) ((1) (let ((e-3 (vector-ref arg-2 1))) (let ((e-4 (vector-ref arg-2 2))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 0 e-3) (vector 0 ) (vector 0 e-4))))) ((2) (let ((e-6 (vector-ref arg-2 1))) (let ((e-7 (vector-ref arg-2 2))) (let ((e-8 (vector-ref arg-2 3))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 1 e-6 e-7) (vector 0 ) (vector 0 e-8)))))) (else (let ((e-10 (vector-ref arg-2 1))) (let ((e-11 (vector-ref arg-2 2))) (let ((e-12 (vector-ref arg-2 3))) (let ((e-13 (vector-ref arg-2 4))) (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 1 e-10 e-11) (vector 0 ) (vector 1 e-12 e-13))))))))))
(define LibrariesC-45DataC-45PosMap-nodeToDigit (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 2))) (let ((e-3 (vector-ref arg-2 3))) (vector 1 e-2 e-3)))) (else (let ((e-6 (vector-ref arg-2 2))) (let ((e-7 (vector-ref arg-2 3))) (let ((e-8 (vector-ref arg-2 4))) (vector 2 e-6 e-7 e-8))))))))
(define LibrariesC-45DataC-45PosMap-viewl (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) '()) ((1) (let ((e-2 (vector-ref arg-2 1))) (cons e-2 (vector 0 )))) (else (let ((e-5 (vector-ref arg-2 2))) (let ((e-6 (vector-ref arg-2 3))) (let ((e-7 (vector-ref arg-2 4))) (case (vector-ref e-5 0) ((0) (let ((e-9 (vector-ref e-5 1))) (cons e-9 (LibrariesC-45DataC-45PosMap-rotl arg-1 e-6 e-7)))) ((1) (let ((e-11 (vector-ref e-5 1))) (let ((e-12 (vector-ref e-5 2))) (cons e-11 (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 0 e-12) e-6 e-7))))) ((2) (let ((e-14 (vector-ref e-5 1))) (let ((e-15 (vector-ref e-5 2))) (let ((e-16 (vector-ref e-5 3))) (cons e-14 (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 1 e-15 e-16) e-6 e-7)))))) (else (let ((e-18 (vector-ref e-5 1))) (let ((e-19 (vector-ref e-5 2))) (let ((e-20 (vector-ref e-5 3))) (let ((e-21 (vector-ref e-5 4))) (cons e-18 (LibrariesC-45DataC-45PosMap-deep arg-1 (vector 2 e-19 e-20 e-21) e-6 e-7)))))))))))))))
(define LibrariesC-45DataC-45PosMap-rotl (lambda (arg-1 arg-2 arg-3) (let ((sc0 (LibrariesC-45DataC-45PosMap-viewl (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2933)) arg-2))) (if (null? sc0) (LibrariesC-45DataC-45PosMap-digitToTree arg-1 arg-3) (let ((e-2 (car sc0))) (let ((e-3 (cdr sc0))) (let ((sc1 (LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2933)) arg-2))) (if (null? sc1) (vector 2 ((let ((eff-0 (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2933)))) (lambda (arg-0) (eff-0 arg-0))) arg-3) (LibrariesC-45DataC-45PosMap-nodeToDigit arg-1 e-2) e-3 arg-3) (let ((e-0 (unbox sc1))) (vector 2 (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange e-0 ((let ((eff-0 (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2933)))) (lambda (arg-0) (eff-0 arg-0))) arg-3)) (LibrariesC-45DataC-45PosMap-nodeToDigit arg-1 e-2) e-3 arg-3))))))))))
(define LibrariesC-45DataC-45PosMap-deepl (lambda (arg-1 arg-2 arg-3 arg-4) (if (null? arg-2) (LibrariesC-45DataC-45PosMap-rotl arg-1 arg-3 arg-4) (let ((e-2 (unbox arg-2))) (LibrariesC-45DataC-45PosMap-deep arg-1 e-2 arg-3 arg-4)))))
(define LibrariesC-45DataC-45PosMap-viewr (lambda (arg-1 arg-2) (case (vector-ref arg-2 0) ((0) '()) ((1) (let ((e-2 (vector-ref arg-2 1))) (cons (vector 0 ) e-2))) (else (let ((e-5 (vector-ref arg-2 2))) (let ((e-6 (vector-ref arg-2 3))) (let ((e-7 (vector-ref arg-2 4))) (case (vector-ref e-7 0) ((0) (let ((e-9 (vector-ref e-7 1))) (cons (LibrariesC-45DataC-45PosMap-rotr arg-1 e-5 e-6) e-9))) ((1) (let ((e-11 (vector-ref e-7 1))) (let ((e-12 (vector-ref e-7 2))) (cons (LibrariesC-45DataC-45PosMap-deep arg-1 e-5 e-6 (vector 0 e-11)) e-12)))) ((2) (let ((e-14 (vector-ref e-7 1))) (let ((e-15 (vector-ref e-7 2))) (let ((e-16 (vector-ref e-7 3))) (cons (LibrariesC-45DataC-45PosMap-deep arg-1 e-5 e-6 (vector 1 e-14 e-15)) e-16))))) (else (let ((e-18 (vector-ref e-7 1))) (let ((e-19 (vector-ref e-7 2))) (let ((e-20 (vector-ref e-7 3))) (let ((e-21 (vector-ref e-7 4))) (cons (LibrariesC-45DataC-45PosMap-deep arg-1 e-5 e-6 (vector 2 e-18 e-19 e-20)) e-21))))))))))))))
(define LibrariesC-45DataC-45PosMap-rotr (lambda (arg-1 arg-2 arg-3) (let ((sc0 (LibrariesC-45DataC-45PosMap-viewr (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2933)) arg-3))) (if (null? sc0) (LibrariesC-45DataC-45PosMap-digitToTree arg-1 arg-2) (let ((e-2 (car sc0))) (let ((e-3 (cdr sc0))) (let ((sc1 (LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2933)) arg-3))) (if (null? sc1) (vector 2 ((let ((eff-0 (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2933)))) (lambda (arg-0) (eff-0 arg-0))) arg-2) arg-2 e-2 (LibrariesC-45DataC-45PosMap-nodeToDigit arg-1 e-3)) (let ((e-0 (unbox sc1))) (vector 2 (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange ((let ((eff-0 (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2933)))) (lambda (arg-0) (eff-0 arg-0))) arg-2) e-0) arg-2 e-2 (LibrariesC-45DataC-45PosMap-nodeToDigit arg-1 e-3)))))))))))
(define LibrariesC-45DataC-45PosMap-deepr (lambda (arg-1 arg-2 arg-3 arg-4) (if (null? arg-4) (LibrariesC-45DataC-45PosMap-rotr arg-1 arg-2 arg-3) (let ((e-2 (unbox arg-4))) (LibrariesC-45DataC-45PosMap-deep arg-1 arg-2 arg-3 e-2)))))
(define LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (lambda (arg-0 arg-1) (if (null? arg-0) arg-1 (if (null? arg-1) arg-0 (let ((e-0 (unbox arg-0))) (let ((e-1 (unbox arg-1))) (box (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_RMFileRange e-0 e-1))))))))
(define LibrariesC-45DataC-45PosMap-searchDigit (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (case (vector-ref arg-4 0) ((0) (let ((e-1 (vector-ref arg-4 1))) (cons '() (cons e-1 '())))) ((1) (let ((e-3 (vector-ref arg-4 1))) (let ((e-4 (vector-ref arg-4 2))) (let ((u--va (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval arg-3 (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-3))))) (let ((u--vb (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-4)) arg-5))) (let ((sc1 ((arg-2 u--va) u--vb))) (cond ((equal? sc1 1) (cons '() (cons e-3 (box (vector 0 e-4))))) (else (cons (box (vector 0 e-3)) (cons e-4 '())))))))))) ((2) (let ((e-6 (vector-ref arg-4 1))) (let ((e-7 (vector-ref arg-4 2))) (let ((e-8 (vector-ref arg-4 3))) (let ((u--va (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval arg-3 (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-6))))) (let ((u--vab (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval u--va (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-7))))) (let ((u--vc (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-8)) arg-5))) (let ((u--vbc (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-7)) u--vc))) (let ((sc1 ((arg-2 u--va) u--vbc))) (cond ((equal? sc1 1) (cons '() (cons e-6 (box (vector 1 e-7 e-8))))) (else (let ((sc2 ((arg-2 u--vab) u--vc))) (cond ((equal? sc2 1) (cons (box (vector 0 e-6)) (cons e-7 (box (vector 0 e-8))))) (else (cons (box (vector 1 e-6 e-7)) (cons e-8 '())))))))))))))))) (else (let ((e-10 (vector-ref arg-4 1))) (let ((e-11 (vector-ref arg-4 2))) (let ((e-12 (vector-ref arg-4 3))) (let ((e-13 (vector-ref arg-4 4))) (let ((u--va (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval arg-3 (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-10))))) (let ((u--vab (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval u--va (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-11))))) (let ((u--vabc (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval u--vab (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-12))))) (let ((u--vd (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-13)) arg-5))) (let ((u--vcd (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-12)) u--vd))) (let ((u--vbcd (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval (arg-1 e-11)) u--vcd))) (let ((sc1 ((arg-2 u--va) u--vbcd))) (cond ((equal? sc1 1) (cons '() (cons e-10 (box (vector 2 e-11 e-12 e-13))))) (else (let ((sc2 ((arg-2 u--vab) u--vcd))) (cond ((equal? sc2 1) (cons (box (vector 0 e-10)) (cons e-11 (box (vector 1 e-12 e-13))))) (else (let ((sc3 ((arg-2 u--vabc) u--vd))) (cond ((equal? sc3 1) (cons (box (vector 1 e-10 e-11)) (cons e-12 (box (vector 0 e-13))))) (else (cons (box (vector 2 e-10 e-11 e-12)) (cons e-13 '())))))))))))))))))))))))))
(define LibrariesC-45DataC-45PosMap-searchNode (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (LibrariesC-45DataC-45PosMap-searchDigit arg-1 arg-2 arg-3 (LibrariesC-45DataC-45PosMap-nodeToDigit arg-1 arg-4) arg-5)))
(define LibrariesC-45DataC-45PosMap-searchTree (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (case (vector-ref arg-4 0) ((0) '()) ((1) (let ((e-2 (vector-ref arg-4 1))) (box (cons (vector 0 ) (cons e-2 (vector 0 )))))) (else (let ((e-5 (vector-ref arg-4 2))) (let ((e-6 (vector-ref arg-4 3))) (let ((e-7 (vector-ref arg-4 4))) (let ((u--vm (LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2933)) e-6))) (let ((u--vsr (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval ((let ((eff-0 (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2933)))) (lambda (arg-0) (eff-0 arg-0))) e-7)) arg-5))) (let ((u--vmsr (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval u--vm u--vsr))) (let ((u--vlp (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval arg-3 (LibrariesC-45DataC-45PosMap-u--cast_Cast_RMFileRange_Interval ((let ((eff-0 (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40DigitC-32C-36aC-41 arg-1 arg-2933)))) (lambda (arg-0) (eff-0 arg-0))) e-5))))) (let ((u--vlpm (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval u--vlp u--vm))) (let ((sc1 ((arg-2 u--vlp) u--vmsr))) (cond ((equal? sc1 1) (let ((sc2 (LibrariesC-45DataC-45PosMap-searchDigit arg-1 arg-2 arg-3 e-5 u--vmsr))) (let ((e-2 (car sc2))) (let ((e-3 (cdr sc2))) (let ((e-9 (car e-3))) (let ((e-8 (cdr e-3))) (box (cons (PreludeC-45Types-maybe (lambda () (vector 0 )) (lambda () (lambda (eta-0) (LibrariesC-45DataC-45PosMap-digitToTree arg-1 eta-0))) e-2) (cons e-9 (LibrariesC-45DataC-45PosMap-deepl arg-1 e-8 e-6 e-7)))))))))) (else (let ((sc2 ((arg-2 u--vlpm) u--vsr))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (LibrariesC-45DataC-45PosMap-searchTree (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2933)) arg-2 u--vlp e-6 u--vsr) (lambda (_-0) (let ((e-2 (car _-0))) (let ((e-3 (cdr _-0))) (let ((e-9 (car e-3))) (let ((e-8 (cdr e-3))) (let ((sc5 (LibrariesC-45DataC-45PosMap-searchNode arg-1 arg-2 (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval u--vlp (LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2933)) e-2)) e-9 (LibrariesC-45DataC-45PosMap-u--C-60C-43C-62_Semigroup_Interval (LibrariesC-45DataC-45PosMap-measureTree (lambda (arg-2933) (LibrariesC-45DataC-45PosMap-u--measureRM_MeasureRM_C-40NodeC-32C-36aC-41 arg-2933)) e-8) u--vsr)))) (let ((e-11 (car sc5))) (let ((e-10 (cdr sc5))) (let ((e-13 (car e-10))) (let ((e-12 (cdr e-10))) (box (cons (LibrariesC-45DataC-45PosMap-deepr arg-1 e-5 e-2 e-11) (cons e-13 (LibrariesC-45DataC-45PosMap-deepl arg-1 e-12 e-8 e-7)))))))))))))))) (else (let ((sc3 (LibrariesC-45DataC-45PosMap-searchDigit arg-1 arg-2 u--vlpm e-7 arg-5))) (let ((e-2 (car sc3))) (let ((e-3 (cdr sc3))) (let ((e-9 (car e-3))) (let ((e-8 (cdr e-3))) (box (cons (LibrariesC-45DataC-45PosMap-deepr arg-1 e-5 e-6 e-2) (cons e-9 (PreludeC-45Types-maybe (lambda () (vector 0 )) (lambda () (lambda (eta-0) (LibrariesC-45DataC-45PosMap-digitToTree arg-1 eta-0))) e-8)))))))))))))))))))))))))))
(define LibrariesC-45DataC-45PosMap-split (lambda (arg-1 arg-2 arg-3) (case (vector-ref arg-3 0) ((0) (cons (vector 0 ) (vector 0 )))(else (let ((sc0 (LibrariesC-45DataC-45PosMap-searchTree arg-1 (lambda (u--a) (lambda (_-10811) (arg-2 u--a))) LibrariesC-45DataC-45PosMap-u--neutral_Monoid_Interval arg-3 LibrariesC-45DataC-45PosMap-u--neutral_Monoid_Interval))) (if (null? sc0) (cons arg-3 (vector 0 )) (let ((e-1 (unbox sc0))) (let ((e-5 (car e-1))) (let ((e-6 (cdr e-1))) (let ((e-9 (car e-6))) (let ((e-10 (cdr e-6))) (let ((sc3 (arg-2 (LibrariesC-45DataC-45PosMap-measureTree arg-1 arg-3)))) (cond ((equal? sc3 1) (cons e-5 (LibrariesC-45DataC-45PosMap-C-60C-124 arg-1 e-9 e-10))) (else (cons arg-3 (vector 0 ))))))))))))))))
(define LibrariesC-45DataC-45PosMap-takeUntil (lambda (arg-1 arg-2 ext-0) (Builtin-fst (LibrariesC-45DataC-45PosMap-split arg-1 arg-2 ext-0))))
(define LibrariesC-45DataC-45PosMap-atleast (lambda (arg-0 arg-1) (if (null? arg-1) 0 (let ((e-0 (unbox arg-1))) (let ((e-2 (cdr e-0))) (PreludeC-45EqOrd-u--C-60C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-231 csegen-231 arg-0 e-2))))))
(define LibrariesC-45DataC-45PosMap-dropUntil (lambda (arg-1 arg-2 ext-0) (Builtin-snd (LibrariesC-45DataC-45PosMap-split arg-1 arg-2 ext-0))))
(define LibrariesC-45DataC-45PosMap-n--12691-11681-u--matches (lambda (arg-1 arg-2 arg-3 arg-4 arg-5) (let ((sc0 (LibrariesC-45DataC-45PosMap-viewl arg-1 (LibrariesC-45DataC-45PosMap-dropUntil arg-1 (lambda (eta-0) (LibrariesC-45DataC-45PosMap-atleast arg-4 eta-0)) arg-5)))) (if (null? sc0) '() (let ((e-2 (car sc0))) (let ((e-3 (cdr sc0))) (cons e-2 (LibrariesC-45DataC-45PosMap-n--12691-11681-u--matches arg-1 arg-2 arg-3 arg-4 e-3))))))))
(define LibrariesC-45DataC-45PosMap-inRange (lambda (arg-1 arg-2 arg-3 arg-4) (LibrariesC-45DataC-45PosMap-n--12691-11681-u--matches arg-1 arg-4 arg-3 arg-2 (LibrariesC-45DataC-45PosMap-takeUntil arg-1 (lambda (eta-0) (LibrariesC-45DataC-45PosMap-greater arg-3 eta-0)) arg-4))))
(define LibrariesC-45DataC-45PosMap-exactRange (lambda (arg-1 arg-2 arg-3 arg-4) (PreludeC-45Basics-flip csegen-1631 (LibrariesC-45DataC-45PosMap-inRange arg-1 arg-2 arg-3 arg-4) (lambda (u--a) (let ((sc0 (arg-1 u--a))) (let ((e-0 (car sc0))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (PreludeC-45Interfaces-guard csegen-258 (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1622 csegen-1622 e-0 (cons arg-2 arg-3))) (lambda (_-10649) (box u--a)))))))))
(define csegen-2147 (lambda (eta-0) (lambda (eta-1) (lambda (eta-2) (LibrariesC-45DataC-45PosMap-exactRange csegen-2146 eta-0 eta-1 eta-2)))))
(define csegen-2165 (lambda (u--f) (LibrariesC-45TextC-45ParserC-45Core-u--map_Functor_C-40C-40C-40GrammarC-32C-36stateC-41C-32C-36tokC-41C-32C-36cC-41 0 u--f (vector 7 ))))
(define ParserC-45RuleC-45Source-symbol (lambda (arg-0) (vector 1 (string-append "Expected '" (string-append arg-0 "'")) (lambda (lcase-0) (case (vector-ref lcase-0 0) ((12) (let ((e-0 (vector-ref lcase-0 1))) (PreludeC-45Interfaces-guard csegen-258 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-0 arg-0))))(else '()))))))
(define csegen-2242 (lambda (u--ps) (vector 11 0 (ParserC-45RuleC-45Source-symbol "}") (lambda () (vector 0 u--ps)))))
(define CoreC-45TTC-45Binder-u--traverse_Traversable_PiInfo (lambda (arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) (let ((e-2 (vector-ref arg-3 1))) ((e-2 'erased) (vector 0 )))) ((1) (let ((e-2 (vector-ref arg-3 1))) ((e-2 'erased) (vector 1 )))) ((2) (let ((e-2 (vector-ref arg-3 1))) ((e-2 'erased) (vector 2 )))) (else (let ((e-4 (vector-ref arg-5 1))) (let ((e-1 (vector-ref arg-3 0))) ((((e-1 'erased) 'erased) (lambda (eta-0) (vector 3 eta-0))) (arg-4 e-4))))))))
(define CoreC-45TTC-45Binder-u--traverse_Traversable_Binder (lambda (arg-3 arg-4 arg-5) (case (vector-ref arg-5 0) ((0) (let ((e-1 (vector-ref arg-5 1))) (let ((e-2 (vector-ref arg-5 2))) (let ((e-3 (vector-ref arg-5 3))) (let ((e-4 (vector-ref arg-5 4))) (let ((e-5 (vector-ref arg-3 2))) ((((e-5 'erased) 'erased) (let ((e-10 (vector-ref arg-3 0))) ((((e-10 'erased) 'erased) (lambda (eta-0) (lambda (eta-1) (vector 0 e-1 e-2 eta-0 eta-1)))) (CoreC-45TTC-45Binder-u--traverse_Traversable_PiInfo arg-3 arg-4 e-3)))) (arg-4 e-4)))))))) ((1) (let ((e-6 (vector-ref arg-5 1))) (let ((e-7 (vector-ref arg-5 2))) (let ((e-8 (vector-ref arg-5 3))) (let ((e-9 (vector-ref arg-5 4))) (let ((e-3 (vector-ref arg-3 2))) ((((e-3 'erased) 'erased) (let ((e-10 (vector-ref arg-3 0))) ((((e-10 'erased) 'erased) (lambda (eta-0) (lambda (eta-1) (vector 1 e-6 e-7 eta-0 eta-1)))) (arg-4 e-8)))) (arg-4 e-9)))))))) ((2) (let ((e-11 (vector-ref arg-5 1))) (let ((e-12 (vector-ref arg-5 2))) (let ((e-13 (vector-ref arg-5 3))) (let ((e-14 (vector-ref arg-5 4))) (let ((e-3 (vector-ref arg-3 2))) ((((e-3 'erased) 'erased) (let ((e-6 (vector-ref arg-3 0))) ((((e-6 'erased) 'erased) (lambda (eta-0) (lambda (eta-1) (vector 2 e-11 e-12 eta-0 eta-1)))) (CoreC-45TTC-45Binder-u--traverse_Traversable_PiInfo arg-3 arg-4 e-13)))) (arg-4 e-14)))))))) ((3) (let ((e-16 (vector-ref arg-5 1))) (let ((e-17 (vector-ref arg-5 2))) (let ((e-18 (vector-ref arg-5 3))) (let ((e-19 (vector-ref arg-5 4))) (let ((e-3 (vector-ref arg-3 2))) ((((e-3 'erased) 'erased) (let ((e-6 (vector-ref arg-3 0))) ((((e-6 'erased) 'erased) (lambda (eta-0) (lambda (eta-1) (vector 3 e-16 e-17 eta-0 eta-1)))) (CoreC-45TTC-45Binder-u--traverse_Traversable_PiInfo arg-3 arg-4 e-18)))) (arg-4 e-19)))))))) ((4) (let ((e-21 (vector-ref arg-5 1))) (let ((e-22 (vector-ref arg-5 2))) (let ((e-23 (vector-ref arg-5 3))) (let ((e-24 (vector-ref arg-5 4))) (let ((e-3 (vector-ref arg-3 2))) ((((e-3 'erased) 'erased) (let ((e-6 (vector-ref arg-3 0))) ((((e-6 'erased) 'erased) (lambda (eta-0) (lambda (eta-1) (vector 4 e-21 e-22 eta-0 eta-1)))) (arg-4 e-23)))) (arg-4 e-24)))))))) (else (let ((e-26 (vector-ref arg-5 1))) (let ((e-27 (vector-ref arg-5 2))) (let ((e-28 (vector-ref arg-5 3))) (let ((e-1 (vector-ref arg-3 0))) ((((e-1 'erased) 'erased) (lambda (eta-0) (vector 5 e-26 e-27 eta-0))) (arg-4 e-28))))))))))
(define CoreC-45TTC-45Term-shrinkBinder (lambda (arg-2 arg-3) (CoreC-45TTC-45Binder-u--traverse_Traversable_Binder csegen-255 (lambda (u--t) (CoreC-45TTC-45Term-shrinkTerm u--t arg-3)) arg-2)))
(define CoreC-45TTC-45VarC-45Var-later (lambda (arg-3) (+ arg-3 1)))
(define CoreC-45TTC-45Var-shrinkIsVar (lambda (arg-4 arg-6) (case (vector-ref arg-6 0) ((0) (box arg-4))(else (cond ((equal? arg-4 0) (case (vector-ref arg-6 0) ((1) '()) (else (box 0))))(else (let ((e-0 (- arg-4 1))) (case (vector-ref arg-6 0) ((1) (let ((e-15 (vector-ref arg-6 1))) (CoreC-45TTC-45Var-shrinkIsVar e-0 e-15))) (else (let ((e-20 (vector-ref arg-6 1))) (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (CoreC-45TTC-45VarC-45Var-later eta-0)) (CoreC-45TTC-45Var-shrinkIsVar e-0 e-20))))))))))))
(define PreludeC-45Types-u--traverse_Traversable_List (lambda (arg-3 arg-4 arg-5) (if (null? arg-5) (let ((e-2 (vector-ref arg-3 1))) ((e-2 'erased) '())) (let ((e-2 (car arg-5))) (let ((e-3 (cdr arg-5))) (let ((e-4 (vector-ref arg-3 2))) ((((e-4 'erased) 'erased) (let ((e-6 (vector-ref arg-3 2))) ((((e-6 'erased) 'erased) (let ((e-10 (vector-ref arg-3 1))) ((e-10 'erased) csegen-103))) (arg-4 e-2)))) (PreludeC-45Types-u--traverse_Traversable_List arg-3 arg-4 e-3))))))))
(define CoreC-45TTC-45Term-shrinkTerms (lambda (arg-2 arg-3) (PreludeC-45Types-u--traverse_Traversable_List csegen-255 (lambda (u--t) (CoreC-45TTC-45Term-shrinkTerm u--t arg-3)) arg-2)))
(define CoreC-45TTC-45Term-shrinkTerm (lambda (arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 1))) (let ((e-3 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Var-shrinkIsVar e-4 arg-3) (lambda (_-0) (box (vector 0 e-2 e-3 _-0)))))))) ((1) (let ((e-7 (vector-ref arg-2 1))) (let ((e-8 (vector-ref arg-2 2))) (let ((e-9 (vector-ref arg-2 3))) (box (vector 1 e-7 e-8 e-9)))))) ((2) (let ((e-11 (vector-ref arg-2 1))) (let ((e-12 (vector-ref arg-2 2))) (let ((e-13 (vector-ref arg-2 3))) (let ((e-14 (vector-ref arg-2 4))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerms e-14 arg-3) (lambda (bind-0) (box (vector 2 e-11 e-12 e-13 bind-0))))))))) ((3) (let ((e-16 (vector-ref arg-2 1))) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkBinder e-18 arg-3) (lambda (bind-0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-19 (vector 2 arg-3)) (lambda (bind-1) (box (vector 3 e-16 e-17 bind-0 bind-1))))))))))) ((4) (let ((e-21 (vector-ref arg-2 1))) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-22 arg-3) (lambda (bind-0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-23 arg-3) (lambda (bind-1) (box (vector 4 e-21 bind-0 bind-1)))))))))) ((5) (let ((e-25 (vector-ref arg-2 1))) (let ((e-26 (vector-ref arg-2 2))) (let ((e-27 (vector-ref arg-2 3))) (let ((e-28 (vector-ref arg-2 4))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-27 arg-3) (lambda (bind-0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-28 arg-3) (lambda (bind-1) (box (vector 5 e-25 e-26 bind-0 bind-1))))))))))) ((6) (let ((e-30 (vector-ref arg-2 1))) (let ((e-31 (vector-ref arg-2 2))) (let ((e-32 (vector-ref arg-2 3))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-32 arg-3) (lambda (bind-0) (box (vector 6 e-30 e-31 bind-0)))))))) ((7) (let ((e-34 (vector-ref arg-2 1))) (let ((e-35 (vector-ref arg-2 2))) (let ((e-36 (vector-ref arg-2 3))) (let ((e-37 (vector-ref arg-2 4))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-36 arg-3) (lambda (bind-0) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-37 arg-3) (lambda (bind-1) (box (vector 7 e-34 e-35 bind-0 bind-1))))))))))) ((8) (let ((e-39 (vector-ref arg-2 1))) (let ((e-40 (vector-ref arg-2 2))) (let ((e-41 (vector-ref arg-2 3))) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe (CoreC-45TTC-45Term-shrinkTerm e-41 arg-3) (lambda (bind-0) (box (vector 8 e-39 e-40 bind-0)))))))) ((9) (let ((e-43 (vector-ref arg-2 1))) (let ((e-44 (vector-ref arg-2 2))) (box (vector 9 e-43 e-44))))) ((10) (let ((e-46 (vector-ref arg-2 1))) (let ((e-47 (vector-ref arg-2 2))) (case (vector-ref e-47 0) ((0) (box (vector 10 e-46 (vector 0 )))) ((1) (box (vector 10 e-46 (vector 1 )))) (else (let ((e-54 (vector-ref e-47 1))) (PreludeC-45Types-u--map_Functor_Maybe (lambda (eta-0) (vector 10 e-46 (vector 2 eta-0))) (CoreC-45TTC-45Term-shrinkTerm e-54 arg-3)))))))) (else (let ((e-49 (vector-ref arg-2 1))) (let ((e-50 (vector-ref arg-2 2))) (box (vector 11 e-49 e-50))))))))
(define CoreC-45TTC-45Term-u--shrink_IsScoped_Term (lambda (ext-0 ext-1) (CoreC-45TTC-45Term-shrinkTerm ext-0 ext-1)))
(define CoreC-45TTC-45Term-thinBinder (lambda (arg-2 arg-3) (CoreC-45TTC-45Binder-u--map_Functor_Binder (lambda (u--t) (CoreC-45TTC-45Term-thinTerm u--t arg-3)) arg-2)))
(define CoreC-45TTC-45Var-thinIsVar (lambda (arg-4 arg-6) (case (vector-ref arg-6 0) ((0) arg-4) ((1) (let ((e-17 (vector-ref arg-6 1))) (CoreC-45TTC-45VarC-45Var-later (CoreC-45TTC-45Var-thinIsVar arg-4 e-17))))(else (cond ((equal? arg-4 0) 0)(else (let ((e-0 (- arg-4 1))) (let ((e-10 (vector-ref arg-6 1))) (CoreC-45TTC-45VarC-45Var-later (CoreC-45TTC-45Var-thinIsVar e-0 e-10))))))))))
(define CoreC-45TTC-45Term-thinTerms (lambda (arg-2 arg-3) (PreludeC-45TypesC-45List-mapAppend '() (lambda (u--t) (CoreC-45TTC-45Term-thinTerm u--t arg-3)) arg-2)))
(define CoreC-45TTC-45Term-thinTerm (lambda (arg-2 arg-3) (case (vector-ref arg-2 0) ((0) (let ((e-2 (vector-ref arg-2 1))) (let ((e-3 (vector-ref arg-2 2))) (let ((e-4 (vector-ref arg-2 3))) (let ((eff-0 (CoreC-45TTC-45Var-thinIsVar e-4 arg-3))) (vector 0 e-2 e-3 eff-0)))))) ((1) (let ((e-7 (vector-ref arg-2 1))) (let ((e-8 (vector-ref arg-2 2))) (let ((e-9 (vector-ref arg-2 3))) (vector 1 e-7 e-8 e-9))))) ((2) (let ((e-11 (vector-ref arg-2 1))) (let ((e-12 (vector-ref arg-2 2))) (let ((e-13 (vector-ref arg-2 3))) (let ((e-14 (vector-ref arg-2 4))) (vector 2 e-11 e-12 e-13 (CoreC-45TTC-45Term-thinTerms e-14 arg-3))))))) ((3) (let ((e-16 (vector-ref arg-2 1))) (let ((e-17 (vector-ref arg-2 2))) (let ((e-18 (vector-ref arg-2 3))) (let ((e-19 (vector-ref arg-2 4))) (vector 3 e-16 e-17 (CoreC-45TTC-45Term-thinBinder e-18 arg-3) (CoreC-45TTC-45Term-thinTerm e-19 (vector 2 arg-3)))))))) ((4) (let ((e-21 (vector-ref arg-2 1))) (let ((e-22 (vector-ref arg-2 2))) (let ((e-23 (vector-ref arg-2 3))) (vector 4 e-21 (CoreC-45TTC-45Term-thinTerm e-22 arg-3) (CoreC-45TTC-45Term-thinTerm e-23 arg-3)))))) ((5) (let ((e-25 (vector-ref arg-2 1))) (let ((e-26 (vector-ref arg-2 2))) (let ((e-27 (vector-ref arg-2 3))) (let ((e-28 (vector-ref arg-2 4))) (vector 5 e-25 e-26 (CoreC-45TTC-45Term-thinTerm e-27 arg-3) (CoreC-45TTC-45Term-thinTerm e-28 arg-3))))))) ((6) (let ((e-30 (vector-ref arg-2 1))) (let ((e-31 (vector-ref arg-2 2))) (let ((e-32 (vector-ref arg-2 3))) (vector 6 e-30 e-31 (CoreC-45TTC-45Term-thinTerm e-32 arg-3)))))) ((7) (let ((e-34 (vector-ref arg-2 1))) (let ((e-35 (vector-ref arg-2 2))) (let ((e-36 (vector-ref arg-2 3))) (let ((e-37 (vector-ref arg-2 4))) (vector 7 e-34 e-35 (CoreC-45TTC-45Term-thinTerm e-36 arg-3) (CoreC-45TTC-45Term-thinTerm e-37 arg-3))))))) ((8) (let ((e-39 (vector-ref arg-2 1))) (let ((e-40 (vector-ref arg-2 2))) (let ((e-41 (vector-ref arg-2 3))) (vector 8 e-39 e-40 (CoreC-45TTC-45Term-thinTerm e-41 arg-3)))))) ((9) (let ((e-43 (vector-ref arg-2 1))) (let ((e-44 (vector-ref arg-2 2))) (vector 9 e-43 e-44)))) ((10) (let ((e-46 (vector-ref arg-2 1))) (let ((e-47 (vector-ref arg-2 2))) (case (vector-ref e-47 0) ((1) (vector 10 e-46 (vector 1 ))) ((0) (vector 10 e-46 (vector 0 ))) (else (let ((e-54 (vector-ref e-47 1))) (vector 10 e-46 (vector 2 (CoreC-45TTC-45Term-thinTerm e-54 arg-3))))))))) (else (let ((e-49 (vector-ref arg-2 1))) (let ((e-50 (vector-ref arg-2 2))) (vector 11 e-49 e-50)))))))
(define CoreC-45TTC-45Term-u--thin_IsScoped_Term (lambda (ext-0 ext-1) (CoreC-45TTC-45Term-thinTerm ext-0 ext-1)))
(define csegen-2277 (vector CoreC-45TTC-45Term-WeakenTerm (lambda (u--ys) (lambda (u--xs) (lambda (arg-4685) (lambda (arg-4689) arg-4689)))) (lambda (xs-4418) (lambda (ys-4419) (lambda (eta-0) (lambda (eta-1) (CoreC-45TTC-45Term-u--thin_IsScoped_Term eta-0 eta-1))))) (lambda (xs-4430) (lambda (ys-4431) (lambda (eta-0) (lambda (eta-1) (CoreC-45TTC-45Term-u--shrink_IsScoped_Term eta-0 eta-1)))))))
(define CoreC-45FC-u--C-61C-61_Eq_OriginDesc (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-3 (vector-ref arg-1 1))) (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_ModuleIdent e-0 e-3)))(else 0)))) ((1) (let ((e-1 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-4 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-1 e-4)))(else 0)))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0)))(else 0))))
(define CoreC-45FC-u--C-61C-61_Eq_FC (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((0) (let ((e-6 (vector-ref arg-1 1))) (let ((e-7 (vector-ref arg-1 2))) (let ((e-8 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_OriginDesc e-0 e-6))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-223 csegen-223 e-1 e-7))) (cond ((equal? sc3 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-223 csegen-223 e-2 e-8)) (else 0)))) (else 0)))))))(else 0)))))) ((1) (let ((e-3 (vector-ref arg-0 1))) (let ((e-4 (vector-ref arg-0 2))) (let ((e-5 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((1) (let ((e-9 (vector-ref arg-1 1))) (let ((e-10 (vector-ref arg-1 2))) (let ((e-11 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_OriginDesc e-3 e-9))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-223 csegen-223 e-4 e-10))) (cond ((equal? sc3 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-223 csegen-223 e-5 e-11)) (else 0)))) (else 0)))))))(else 0)))))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0)))(else 0))))
(define IdrisC-45Error-u--C-61C-61_Eq_FileError (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-1 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-0 e-1)))(else 0)))) ((1) (case (vector-ref arg-1 0) ((1) 1)(else 0))) ((2) (case (vector-ref arg-1 0) ((2) 1)(else 0))) ((3) (case (vector-ref arg-1 0) ((3) 1)(else 0))) ((4) (case (vector-ref arg-1 0) ((4) 1)(else 0))) ((5) (case (vector-ref arg-1 0) ((5) 1)(else 0)))(else 0))))
(define IdrisC-45Error-u--C-61C-61_Eq_TTCErrorMsg (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (let ((e-2 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((0) (let ((e-5 (vector-ref arg-1 1))) (let ((e-6 (vector-ref arg-1 2))) (let ((e-7 (vector-ref arg-1 3))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-0 e-5))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-1 e-6))) (cond ((equal? sc3 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-2 e-7)) (else 0)))) (else 0)))))))(else 0)))))) ((1) (let ((e-3 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((1) (let ((e-8 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-3 e-8)))(else 0)))) ((2) (let ((e-4 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((2) (let ((e-9 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-4 e-9)))(else 0))))(else 0))))
(define CoreC-45TT-u--C-61C-61_Eq_Visibility (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else 0))))
(define csegen-3018 (cons (lambda (arg-676) (lambda (arg-679) (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 csegen-832 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (DataC-45List1-u--C-47C-61_Eq_C-40List1C-32C-36aC-41 csegen-832 arg-686 arg-689)))))
(define CoreC-45FC-u--C-47C-61_Eq_FC (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45FC-u--C-61C-61_Eq_FC arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-3012 (cons (lambda (arg-676) (lambda (arg-679) (CoreC-45FC-u--C-61C-61_Eq_FC arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (CoreC-45FC-u--C-47C-61_Eq_FC arg-686 arg-689)))))
(define csegen-3024 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-3012 csegen-832 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-3012 csegen-832 arg-686 arg-689)))))
(define IdrisC-45Error-u--C-61C-61_Eq_Warning (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (let ((e-1 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((0) (let ((e-17 (vector-ref arg-1 1))) (let ((e-18 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-0 e-17))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-1 e-18)) (else 0))))))(else 0))))) ((1) (let ((e-3 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((1) (let ((e-20 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-3 e-20)))(else 0)))) ((2) (let ((e-6 (vector-ref arg-0 1))) (let ((e-7 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((2) (let ((e-23 (vector-ref arg-1 1))) (let ((e-24 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-6 e-23))) (cond ((equal? sc2 1) (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-22 csegen-3018 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-22 csegen-3018 arg-686 arg-689)))) e-7 e-24)) (else 0))))))(else 0))))) ((3) (let ((e-8 (vector-ref arg-0 1))) (let ((e-9 (vector-ref arg-0 2))) (let ((e-10 (vector-ref arg-0 3))) (let ((e-11 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((3) (let ((e-25 (vector-ref arg-1 1))) (let ((e-26 (vector-ref arg-1 2))) (let ((e-27 (vector-ref arg-1 3))) (let ((e-28 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-8 e-25))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45TT-u--C-61C-61_Eq_Visibility e-9 e-26))) (cond ((equal? sc3 1) (let ((sc4 (CoreC-45TT-u--C-61C-61_Eq_Visibility e-10 e-27))) (cond ((equal? sc4 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-11 e-28)) (else 0)))) (else 0)))) (else 0))))))))(else 0))))))) ((5) (let ((e-12 (vector-ref arg-0 1))) (let ((e-13 (vector-ref arg-0 2))) (let ((e-14 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((5) (let ((e-29 (vector-ref arg-1 1))) (let ((e-30 (vector-ref arg-1 2))) (let ((e-31 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-12 e-29))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-13 e-30))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 csegen-3024 e-14 e-31)) (else 0)))) (else 0)))))))(else 0)))))) ((6) (let ((e-15 (vector-ref arg-0 1))) (let ((e-16 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((6) (let ((e-32 (vector-ref arg-1 1))) (let ((e-33 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-15 e-32))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-16 e-33)) (else 0))))))(else 0)))))(else 0))))
(define PreludeC-45Types-u--C-47C-61_Eq_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (let ((sc0 (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 arg-1 arg-2 arg-3))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-2546 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-22 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45Types-u--C-47C-61_Eq_C-40ListC-32C-36aC-41 csegen-22 arg-686 arg-689)))))
(define csegen-3015 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-3012 csegen-22 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-3012 csegen-22 arg-686 arg-689)))))
(define IdrisC-45Error-u--C-61C-61_Eq_Error (lambda (arg-0 arg-1) (case (vector-ref arg-0 0) ((0) (let ((e-0 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((0) (let ((e-218 (vector-ref arg-1 1))) (IdrisC-45Error-u--C-61C-61_Eq_Error e-0 e-218)))(else 0)))) ((1) (let ((e-2 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((1) (let ((e-220 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-2 e-220)))(else 0)))) ((2) (let ((e-8 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((2) (let ((e-226 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-8 e-226)))(else 0)))) ((3) (let ((e-14 (vector-ref arg-0 2))) (let ((e-15 (vector-ref arg-0 3))) (let ((e-17 (vector-ref arg-0 5))) (case (vector-ref arg-1 0) ((3) (let ((e-232 (vector-ref arg-1 2))) (let ((e-233 (vector-ref arg-1 3))) (let ((e-235 (vector-ref arg-1 5))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-14 e-232))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45FC-u--C-61C-61_Eq_FC e-15 e-233))) (cond ((equal? sc3 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-17 e-235)) (else 0)))) (else 0)))))))(else 0)))))) ((4) (let ((e-20 (vector-ref arg-0 2))) (let ((e-22 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((4) (let ((e-238 (vector-ref arg-1 2))) (let ((e-240 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-20 e-238))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-22 e-240)) (else 0))))))(else 0))))) ((5) (let ((e-25 (vector-ref arg-0 2))) (let ((e-30 (vector-ref arg-0 7))) (case (vector-ref arg-1 0) ((5) (let ((e-243 (vector-ref arg-1 2))) (let ((e-248 (vector-ref arg-1 7))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-25 e-243))) (cond ((equal? sc2 1) (IdrisC-45Error-u--C-61C-61_Eq_Error e-30 e-248)) (else 0))))))(else 0))))) ((6) (let ((e-32 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((6) (let ((e-250 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-32 e-250)))(else 0)))) ((7) (let ((e-35 (vector-ref arg-0 1))) (let ((e-36 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((7) (let ((e-253 (vector-ref arg-1 1))) (let ((e-254 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-35 e-253))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-36 e-254)) (else 0))))))(else 0))))) ((8) (let ((e-37 (vector-ref arg-0 1))) (let ((e-38 (vector-ref arg-0 2))) (let ((e-39 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((8) (let ((e-255 (vector-ref arg-1 1))) (let ((e-256 (vector-ref arg-1 2))) (let ((e-257 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-37 e-255))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-38 e-256))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 csegen-1817 e-39 e-257)) (else 0)))) (else 0)))))))(else 0)))))) ((9) (let ((e-40 (vector-ref arg-0 1))) (let ((e-41 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((9) (let ((e-258 (vector-ref arg-1 1))) (let ((e-259 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-40 e-258))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-41 e-259)) (else 0))))))(else 0))))) ((10) (let ((e-42 (vector-ref arg-0 1))) (let ((e-43 (vector-ref arg-0 2))) (let ((e-44 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((10) (let ((e-260 (vector-ref arg-1 1))) (let ((e-261 (vector-ref arg-1 2))) (let ((e-262 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-42 e-260))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-43 e-261))) (cond ((equal? sc3 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-44 e-262)) (else 0)))) (else 0)))))))(else 0)))))) ((11) (let ((e-45 (vector-ref arg-0 1))) (let ((e-46 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((11) (let ((e-263 (vector-ref arg-1 1))) (let ((e-264 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-45 e-263))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-46 e-264)) (else 0))))))(else 0))))) ((12) (let ((e-48 (vector-ref arg-0 1))) (let ((e-49 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((12) (let ((e-266 (vector-ref arg-1 1))) (let ((e-267 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-48 e-266))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-49 e-267)) (else 0))))))(else 0))))) ((13) (let ((e-51 (vector-ref arg-0 1))) (let ((e-52 (vector-ref arg-0 2))) (let ((e-53 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((13) (let ((e-269 (vector-ref arg-1 1))) (let ((e-270 (vector-ref arg-1 2))) (let ((e-271 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-51 e-269))) (cond ((equal? sc2 1) (let ((sc3 (or (and (= e-52 e-270) 1) 0))) (cond ((equal? sc3 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-53 e-271)) (else 0)))) (else 0)))))))(else 0)))))) ((14) (let ((e-54 (vector-ref arg-0 1))) (let ((e-55 (vector-ref arg-0 2))) (let ((e-56 (vector-ref arg-0 3))) (let ((e-57 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((14) (let ((e-272 (vector-ref arg-1 1))) (let ((e-273 (vector-ref arg-1 2))) (let ((e-274 (vector-ref arg-1 3))) (let ((e-275 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-54 e-272))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-55 e-273))) (cond ((equal? sc3 1) (let ((sc4 (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-56 e-274))) (cond ((equal? sc4 1) (AlgebraC-45ZeroOneOmega-u--C-61C-61_Eq_ZeroOneOmega e-57 e-275)) (else 0)))) (else 0)))) (else 0))))))))(else 0))))))) ((15) (let ((e-59 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((15) (let ((e-277 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-59 e-277)))(else 0)))) ((16) (let ((e-64 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((16) (let ((e-282 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-64 e-282)))(else 0)))) ((17) (let ((e-67 (vector-ref arg-0 1))) (let ((e-68 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((17) (let ((e-285 (vector-ref arg-1 1))) (let ((e-286 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-67 e-285))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-832 e-68 e-286)) (else 0))))))(else 0))))) ((18) (let ((e-70 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((18) (let ((e-288 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-70 e-288)))(else 0)))) ((19) (let ((e-74 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((19) (let ((e-292 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-74 e-292)))(else 0)))) ((20) (let ((e-78 (vector-ref arg-0 1))) (let ((e-79 (vector-ref arg-0 2))) (let ((e-80 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((20) (let ((e-296 (vector-ref arg-1 1))) (let ((e-297 (vector-ref arg-1 2))) (let ((e-298 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-78 e-296))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-79 e-297))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-832 e-80 e-298)) (else 0)))) (else 0)))))))(else 0)))))) ((21) (let ((e-81 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((21) (let ((e-299 (vector-ref arg-1 1))) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-845 (csegen-2282) arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-845 (csegen-2282) arg-686 arg-689)))) e-81 e-299)))(else 0)))) ((22) (let ((e-83 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((22) (let ((e-301 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-83 e-301)))(else 0)))) ((23) (let ((e-85 (vector-ref arg-0 1))) (let ((e-86 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((23) (let ((e-303 (vector-ref arg-1 1))) (let ((e-304 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-85 e-303))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-2546 e-86 e-304)) (else 0))))))(else 0))))) ((24) (let ((e-87 (vector-ref arg-0 1))) (let ((e-88 (vector-ref arg-0 2))) (let ((e-89 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((24) (let ((e-305 (vector-ref arg-1 1))) (let ((e-306 (vector-ref arg-1 2))) (let ((e-307 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-87 e-305))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-88 e-306))) (cond ((equal? sc3 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40MaybeC-32C-36aC-41 csegen-832 e-89 e-307)) (else 0)))) (else 0)))))))(else 0)))))) ((25) (let ((e-90 (vector-ref arg-0 1))) (let ((e-91 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((25) (let ((e-308 (vector-ref arg-1 1))) (let ((e-309 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-90 e-308))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-91 e-309)) (else 0))))))(else 0))))) ((26) (let ((e-92 (vector-ref arg-0 1))) (let ((e-93 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((26) (let ((e-310 (vector-ref arg-1 1))) (let ((e-311 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-92 e-310))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-22 e-93 e-311)) (else 0))))))(else 0))))) ((27) (let ((e-95 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((27) (let ((e-313 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-95 e-313)))(else 0)))) ((28) (let ((e-100 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((28) (let ((e-318 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-100 e-318)))(else 0)))) ((29) (let ((e-104 (vector-ref arg-0 2))) (let ((e-106 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((29) (let ((e-322 (vector-ref arg-1 2))) (let ((e-324 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-104 e-322))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-106 e-324)) (else 0))))))(else 0))))) ((30) (let ((e-109 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((30) (let ((e-327 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-109 e-327)))(else 0)))) ((31) (let ((e-115 (vector-ref arg-0 2))) (let ((e-116 (vector-ref arg-0 3))) (let ((e-117 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((31) (let ((e-333 (vector-ref arg-1 2))) (let ((e-334 (vector-ref arg-1 3))) (let ((e-335 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-115 e-333))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-116 e-334))) (cond ((equal? sc3 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-117 e-335)) (else 0)))) (else 0)))))))(else 0)))))) ((32) (let ((e-120 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((32) (let ((e-338 (vector-ref arg-1 1))) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-3024 e-120 e-338)))(else 0)))) ((33) (let ((e-122 (vector-ref arg-0 2))) (let ((e-124 (vector-ref arg-0 4))) (let ((e-125 (vector-ref arg-0 5))) (case (vector-ref arg-1 0) ((33) (let ((e-340 (vector-ref arg-1 2))) (let ((e-342 (vector-ref arg-1 4))) (let ((e-343 (vector-ref arg-1 5))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-122 e-340))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-124 e-342))) (cond ((equal? sc3 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-125 e-343)) (else 0)))) (else 0)))))))(else 0)))))) ((34) (let ((e-128 (vector-ref arg-0 2))) (let ((e-130 (vector-ref arg-0 4))) (case (vector-ref arg-1 0) ((34) (let ((e-346 (vector-ref arg-1 2))) (let ((e-348 (vector-ref arg-1 4))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-128 e-346))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-130 e-348)) (else 0))))))(else 0))))) ((35) (let ((e-132 (vector-ref arg-0 1))) (let ((e-133 (vector-ref arg-0 2))) (let ((e-134 (vector-ref arg-0 3))) (let ((e-135 (vector-ref arg-0 4))) (let ((e-136 (vector-ref arg-0 5))) (case (vector-ref arg-1 0) ((35) (let ((e-350 (vector-ref arg-1 1))) (let ((e-351 (vector-ref arg-1 2))) (let ((e-352 (vector-ref arg-1 3))) (let ((e-353 (vector-ref arg-1 4))) (let ((e-354 (vector-ref arg-1 5))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-132 e-350))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45TT-u--C-61C-61_Eq_Visibility e-133 e-351))) (cond ((equal? sc3 1) (let ((sc4 (CoreC-45Name-u--C-61C-61_Eq_Name e-134 e-352))) (cond ((equal? sc4 1) (let ((sc5 (CoreC-45TT-u--C-61C-61_Eq_Visibility e-135 e-353))) (cond ((equal? sc5 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-136 e-354)) (else 0)))) (else 0)))) (else 0)))) (else 0)))))))))(else 0)))))))) ((36) (let ((e-137 (vector-ref arg-0 1))) (let ((e-138 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((36) (let ((e-355 (vector-ref arg-1 1))) (let ((e-356 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-137 e-355))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-138 e-356)) (else 0))))))(else 0))))) ((37) (let ((e-139 (vector-ref arg-0 1))) (let ((e-140 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((37) (let ((e-357 (vector-ref arg-1 1))) (let ((e-358 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-139 e-357))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-140 e-358)) (else 0))))))(else 0))))) ((38) (let ((e-141 (vector-ref arg-0 1))) (let ((e-142 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((38) (let ((e-359 (vector-ref arg-1 1))) (let ((e-360 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-141 e-359))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-142 e-360)) (else 0))))))(else 0))))) ((39) (let ((e-143 (vector-ref arg-0 1))) (let ((e-144 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((39) (let ((e-361 (vector-ref arg-1 1))) (let ((e-362 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-143 e-361))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-144 e-362)) (else 0))))))(else 0))))) ((40) (let ((e-146 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((40) (let ((e-364 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-146 e-364)))(else 0)))) ((41) (let ((e-150 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((41) (let ((e-368 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-150 e-368)))(else 0)))) ((42) (let ((e-155 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((42) (let ((e-373 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-155 e-373)))(else 0)))) ((43) (let ((e-158 (vector-ref arg-0 1))) (let ((e-159 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((43) (let ((e-376 (vector-ref arg-1 1))) (let ((e-377 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-158 e-376))) (cond ((equal? sc2 1) (CoreC-45Name-u--C-61C-61_Eq_Name e-159 e-377)) (else 0))))))(else 0))))) ((44) (let ((e-162 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((44) (let ((e-380 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-162 e-380)))(else 0)))) ((45) (let ((e-166 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((45) (let ((e-384 (vector-ref arg-1 2))) (CoreC-45FC-u--C-61C-61_Eq_FC e-166 e-384)))(else 0)))) ((46) (let ((e-171 (vector-ref arg-0 1))) (let ((e-172 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((46) (let ((e-389 (vector-ref arg-1 1))) (let ((e-390 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-171 e-389))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-172 e-390)) (else 0))))))(else 0))))) ((47) (let ((e-174 (vector-ref arg-0 2))) (let ((e-177 (vector-ref arg-0 5))) (case (vector-ref arg-1 0) ((47) (let ((e-392 (vector-ref arg-1 2))) (let ((e-395 (vector-ref arg-1 5))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-174 e-392))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-177 e-395)) (else 0))))))(else 0))))) ((48) (let ((e-178 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((48) (let ((e-396 (vector-ref arg-1 1))) (IdrisC-45Error-u--C-61C-61_Eq_Error e-178 e-396)))(else 0)))) ((49) (let ((e-179 (vector-ref arg-0 1))) (let ((e-180 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((49) (let ((e-397 (vector-ref arg-1 1))) (let ((e-398 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-179 e-397))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-180 e-398)) (else 0))))))(else 0))))) ((50) (let ((e-181 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((50) (let ((e-399 (vector-ref arg-1 1))) (IdrisC-45Error-u--C-61C-61_Eq_TTCErrorMsg e-181 e-399)))(else 0)))) ((51) (let ((e-182 (vector-ref arg-0 1))) (let ((e-183 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((51) (let ((e-400 (vector-ref arg-1 1))) (let ((e-401 (vector-ref arg-1 2))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-182 e-400))) (cond ((equal? sc2 1) (IdrisC-45Error-u--C-61C-61_Eq_FileError e-183 e-401)) (else 0))))))(else 0))))) ((52) (let ((e-184 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((52) (let ((e-402 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-184 e-402)))(else 0)))) ((55) (let ((e-185 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((55) (let ((e-403 (vector-ref arg-1 1))) (CoreC-45FC-u--C-61C-61_Eq_FC e-185 e-403)))(else 0)))) ((56) (let ((e-186 (vector-ref arg-0 1))) (let ((e-187 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((56) (let ((e-404 (vector-ref arg-1 1))) (let ((e-405 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-186 e-404))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-187 e-405)) (else 0))))))(else 0))))) ((57) (let ((e-188 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((57) (let ((e-406 (vector-ref arg-1 1))) (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 csegen-3015 e-188 e-406)))(else 0)))) ((58) (let ((e-189 (vector-ref arg-0 1))) (let ((e-190 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((58) (let ((e-407 (vector-ref arg-1 1))) (let ((e-408 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-189 e-407))) (cond ((equal? sc2 1) (CoreC-45NameC-45Namespace-u--C-61C-61_Eq_ModuleIdent e-190 e-408)) (else 0))))))(else 0))))) ((59) (let ((e-191 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((59) (let ((e-409 (vector-ref arg-1 1))) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-276 e-191 e-409)))(else 0)))) ((60) (case (vector-ref arg-1 0) ((60) 1)(else 0))) ((61) (let ((e-192 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((61) (let ((e-410 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-192 e-410)))(else 0)))) ((62) (let ((e-193 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((62) (let ((e-411 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-193 e-411)))(else 0)))) ((63) (let ((e-194 (vector-ref arg-0 1))) (let ((e-195 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((63) (let ((e-412 (vector-ref arg-1 1))) (let ((e-413 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-194 e-412))) (cond ((equal? sc2 1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-22 e-195 e-413)) (else 0))))))(else 0))))) ((64) (let ((e-196 (vector-ref arg-0 1))) (let ((e-197 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((64) (let ((e-414 (vector-ref arg-1 1))) (let ((e-415 (vector-ref arg-1 2))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-196 e-414))) (cond ((equal? sc2 1) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-197 e-415)) (else 0))))))(else 0))))) ((65) (let ((e-198 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((65) (let ((e-416 (vector-ref arg-1 1))) (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-198 e-416)))(else 0)))) ((66) (let ((e-199 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((66) (let ((e-417 (vector-ref arg-1 1))) (CoreC-45FC-u--C-61C-61_Eq_FC e-199 e-417)))(else 0)))) ((67) (let ((e-200 (vector-ref arg-0 1))) (let ((e-201 (vector-ref arg-0 2))) (let ((e-202 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((67) (let ((e-418 (vector-ref arg-1 1))) (let ((e-419 (vector-ref arg-1 2))) (let ((e-420 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-200 e-418))) (cond ((equal? sc2 1) (let ((sc3 (PreludeC-45EqOrd-u--C-61C-61_Eq_String e-201 e-419))) (cond ((equal? sc3 1) (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 (csegen-2282) e-202 e-420)) (else 0)))) (else 0)))))))(else 0)))))) ((68) (let ((e-203 (vector-ref arg-0 1))) (let ((e-204 (vector-ref arg-0 2))) (let ((e-205 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((68) (let ((e-421 (vector-ref arg-1 1))) (let ((e-422 (vector-ref arg-1 2))) (let ((e-423 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-203 e-421))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-204 e-422))) (cond ((equal? sc3 1) (IdrisC-45Error-u--C-61C-61_Eq_Error e-205 e-423)) (else 0)))) (else 0)))))))(else 0)))))) ((69) (let ((e-206 (vector-ref arg-0 1))) (let ((e-207 (vector-ref arg-0 2))) (let ((e-208 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((69) (let ((e-424 (vector-ref arg-1 1))) (let ((e-425 (vector-ref arg-1 2))) (let ((e-426 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-206 e-424))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-207 e-425))) (cond ((equal? sc3 1) (IdrisC-45Error-u--C-61C-61_Eq_Error e-208 e-426)) (else 0)))) (else 0)))))))(else 0)))))) ((70) (let ((e-209 (vector-ref arg-0 1))) (let ((e-210 (vector-ref arg-0 2))) (let ((e-211 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((70) (let ((e-427 (vector-ref arg-1 1))) (let ((e-428 (vector-ref arg-1 2))) (let ((e-429 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-209 e-427))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-210 e-428))) (cond ((equal? sc3 1) (IdrisC-45Error-u--C-61C-61_Eq_Error e-211 e-429)) (else 0)))) (else 0)))))))(else 0)))))) ((71) (let ((e-212 (vector-ref arg-0 1))) (let ((e-213 (vector-ref arg-0 2))) (let ((e-214 (vector-ref arg-0 3))) (case (vector-ref arg-1 0) ((71) (let ((e-430 (vector-ref arg-1 1))) (let ((e-431 (vector-ref arg-1 2))) (let ((e-432 (vector-ref arg-1 3))) (let ((sc2 (CoreC-45FC-u--C-61C-61_Eq_FC e-212 e-430))) (cond ((equal? sc2 1) (let ((sc3 (CoreC-45Name-u--C-61C-61_Eq_Name e-213 e-431))) (cond ((equal? sc3 1) (IdrisC-45Error-u--C-61C-61_Eq_Error e-214 e-432)) (else 0)))) (else 0)))))))(else 0)))))) ((72) (let ((e-215 (vector-ref arg-0 1))) (let ((e-216 (vector-ref arg-0 2))) (case (vector-ref arg-1 0) ((72) (let ((e-433 (vector-ref arg-1 1))) (let ((e-434 (vector-ref arg-1 2))) (let ((sc2 (IdrisC-45Error-u--C-61C-61_Eq_Error e-215 e-433))) (cond ((equal? sc2 1) (DataC-45List1-u--C-61C-61_Eq_C-40List1C-32C-36aC-41 csegen-22 e-216 e-434)) (else 0))))))(else 0))))) ((73) (let ((e-217 (vector-ref arg-0 1))) (case (vector-ref arg-1 0) ((73) (let ((e-435 (vector-ref arg-1 1))) (IdrisC-45Error-u--C-61C-61_Eq_Warning e-217 e-435)))(else 0))))(else 0))))
(define IdrisC-45Error-u--C-47C-61_Eq_Error (lambda (arg-0 arg-1) (let ((sc0 (IdrisC-45Error-u--C-61C-61_Eq_Error arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-2282 (lambda () (cons (lambda (arg-676) (lambda (arg-679) (IdrisC-45Error-u--C-61C-61_Eq_Error arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (IdrisC-45Error-u--C-47C-61_Eq_Error arg-686 arg-689))))))
(define csegen-2286 (lambda (clam-0) (lambda (clam-1) (PreludeC-45Types-u--C-62C-62C-61_Monad_Maybe clam-0 clam-1))))
(define csegen-2287 (lambda (eta-0) (let ((e-13 (vector-ref eta-0 13))) e-13)))
(define CoreC-45TerminationC-45SizeChange-u--C-61C-61_Eq_Graph (lambda (arg-0 arg-1) (PreludeC-45Types-u--C-61C-61_Eq_C-40ListC-32C-36aC-41 csegen-1044 (let ((e-0 (car arg-0))) e-0) (let ((e-0 (car arg-1))) e-0))))
(define CoreC-45TerminationC-45SizeChange-u--C-47C-61_Eq_Graph (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45TerminationC-45SizeChange-u--C-61C-61_Eq_Graph arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-2291 (cons (lambda (arg-676) (lambda (arg-679) (CoreC-45TerminationC-45SizeChange-u--C-61C-61_Eq_Graph arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (CoreC-45TerminationC-45SizeChange-u--C-47C-61_Eq_Graph arg-686 arg-689)))))
(define DataC-45List1-u--compare_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 arg-1 (DataC-45List1-forget arg-2) (DataC-45List1-forget arg-3))))
(define DataC-45List1-u--C-60C-61_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (DataC-45List1-u--compare_Ord_C-40List1C-32C-36aC-41 arg-1 arg-2 arg-3) 2)))
(define DataC-45List1-u--C-60_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (DataC-45List1-u--compare_Ord_C-40List1C-32C-36aC-41 arg-1 arg-2 arg-3) 0)))
(define DataC-45List1-u--C-62C-61_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (DataC-45List1-u--compare_Ord_C-40List1C-32C-36aC-41 arg-1 arg-2 arg-3) 0)))
(define DataC-45List1-u--C-62_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (DataC-45List1-u--compare_Ord_C-40List1C-32C-36aC-41 arg-1 arg-2 arg-3) 2)))
(define DataC-45List1-u--max_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (let ((sc0 (DataC-45List1-u--C-62_Ord_C-40List1C-32C-36aC-41 arg-1 arg-2 arg-3))) (cond ((equal? sc0 1) arg-2) (else arg-3)))))
(define DataC-45List1-u--min_Ord_C-40List1C-32C-36aC-41 (lambda (arg-1 arg-2 arg-3) (let ((sc0 (DataC-45List1-u--C-60_Ord_C-40List1C-32C-36aC-41 arg-1 arg-2 arg-3))) (cond ((equal? sc0 1) arg-2) (else arg-3)))))
(define AlgebraC-45SizeChange-u--compare_Ord_SizeChange (lambda (arg-0 arg-1) (cond ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0)))(else (cond ((equal? arg-1 2) 2)(else (cond ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0)))(else (cond ((equal? arg-1 1) 2)(else (cond (else (cond (else 1))))))))))))))
(define AlgebraC-45SizeChange-u--C-60C-61_Ord_SizeChange (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (AlgebraC-45SizeChange-u--compare_Ord_SizeChange arg-0 arg-1) 2)))
(define AlgebraC-45SizeChange-u--C-60_Ord_SizeChange (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (AlgebraC-45SizeChange-u--compare_Ord_SizeChange arg-0 arg-1) 0)))
(define AlgebraC-45SizeChange-u--C-62C-61_Ord_SizeChange (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (AlgebraC-45SizeChange-u--compare_Ord_SizeChange arg-0 arg-1) 0)))
(define AlgebraC-45SizeChange-u--C-62_Ord_SizeChange (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (AlgebraC-45SizeChange-u--compare_Ord_SizeChange arg-0 arg-1) 2)))
(define AlgebraC-45SizeChange-u--max_Ord_SizeChange (lambda (arg-0 arg-1) (cond ((equal? arg-0 2) arg-1) ((equal? arg-0 1) (cond ((equal? arg-1 2) 1)(else arg-1))) (else 0))))
(define AlgebraC-45SizeChange-u--min_Ord_SizeChange (lambda (arg-0 arg-1) (let ((sc0 (AlgebraC-45SizeChange-u--C-60_Ord_SizeChange arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-2307 (vector csegen-1035 (lambda (arg-1566) (lambda (arg-1569) (AlgebraC-45SizeChange-u--compare_Ord_SizeChange arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (AlgebraC-45SizeChange-u--C-60_Ord_SizeChange arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (AlgebraC-45SizeChange-u--C-62_Ord_SizeChange arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (AlgebraC-45SizeChange-u--C-60C-61_Ord_SizeChange arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (AlgebraC-45SizeChange-u--C-62C-61_Ord_SizeChange arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (AlgebraC-45SizeChange-u--max_Ord_SizeChange arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (AlgebraC-45SizeChange-u--min_Ord_SizeChange arg-1626 arg-1629)))))
(define csegen-2315 (vector csegen-1038 (lambda (arg-1566) (lambda (arg-1569) (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2307 arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (PreludeC-45EqOrd-u--C-60_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2307 arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2307 arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (PreludeC-45EqOrd-u--C-60C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2307 arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (PreludeC-45EqOrd-u--C-62C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2307 arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (PreludeC-45EqOrd-u--max_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2307 arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (PreludeC-45EqOrd-u--min_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2307 arg-1626 arg-1629)))))
(define csegen-2323 (vector csegen-1041 (lambda (arg-1566) (lambda (arg-1569) (DataC-45List1-u--compare_Ord_C-40List1C-32C-36aC-41 csegen-2315 arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (DataC-45List1-u--C-60_Ord_C-40List1C-32C-36aC-41 csegen-2315 arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (DataC-45List1-u--C-62_Ord_C-40List1C-32C-36aC-41 csegen-2315 arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (DataC-45List1-u--C-60C-61_Ord_C-40List1C-32C-36aC-41 csegen-2315 arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (DataC-45List1-u--C-62C-61_Ord_C-40List1C-32C-36aC-41 csegen-2315 arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (DataC-45List1-u--max_Ord_C-40List1C-32C-36aC-41 csegen-2315 arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (DataC-45List1-u--min_Ord_C-40List1C-32C-36aC-41 csegen-2315 arg-1626 arg-1629)))))
(define CoreC-45TerminationC-45SizeChange-u--compare_Ord_Graph (lambda (arg-0 arg-1) (PreludeC-45Types-u--compare_Ord_C-40ListC-32C-36aC-41 (vector csegen-1044 (lambda (arg-1566) (lambda (arg-1569) (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2323 arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (PreludeC-45EqOrd-u--C-60_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2323 arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2323 arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (PreludeC-45EqOrd-u--C-60C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2323 arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (PreludeC-45EqOrd-u--C-62C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2323 arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (PreludeC-45EqOrd-u--max_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2323 arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (PreludeC-45EqOrd-u--min_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-1647 csegen-2323 arg-1626 arg-1629)))) (let ((e-0 (car arg-0))) e-0) (let ((e-0 (car arg-1))) e-0))))
(define CoreC-45TerminationC-45SizeChange-u--C-60C-61_Ord_Graph (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45TerminationC-45SizeChange-u--compare_Ord_Graph arg-0 arg-1) 2)))
(define CoreC-45TerminationC-45SizeChange-u--C-60_Ord_Graph (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45TerminationC-45SizeChange-u--compare_Ord_Graph arg-0 arg-1) 0)))
(define CoreC-45TerminationC-45SizeChange-u--C-62C-61_Ord_Graph (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-47C-61_Eq_Ordering (CoreC-45TerminationC-45SizeChange-u--compare_Ord_Graph arg-0 arg-1) 0)))
(define CoreC-45TerminationC-45SizeChange-u--C-62_Ord_Graph (lambda (arg-0 arg-1) (PreludeC-45EqOrd-u--C-61C-61_Eq_Ordering (CoreC-45TerminationC-45SizeChange-u--compare_Ord_Graph arg-0 arg-1) 2)))
(define CoreC-45TerminationC-45SizeChange-u--max_Ord_Graph (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45TerminationC-45SizeChange-u--C-62_Ord_Graph arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define CoreC-45TerminationC-45SizeChange-u--min_Ord_Graph (lambda (arg-0 arg-1) (let ((sc0 (CoreC-45TerminationC-45SizeChange-u--C-60_Ord_Graph arg-0 arg-1))) (cond ((equal? sc0 1) arg-0) (else arg-1)))))
(define csegen-2299 (vector csegen-2291 (lambda (arg-1566) (lambda (arg-1569) (CoreC-45TerminationC-45SizeChange-u--compare_Ord_Graph arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (CoreC-45TerminationC-45SizeChange-u--C-60_Ord_Graph arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (CoreC-45TerminationC-45SizeChange-u--C-62_Ord_Graph arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (CoreC-45TerminationC-45SizeChange-u--C-60C-61_Ord_Graph arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (CoreC-45TerminationC-45SizeChange-u--C-62C-61_Ord_Graph arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (CoreC-45TerminationC-45SizeChange-u--max_Ord_Graph arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (CoreC-45TerminationC-45SizeChange-u--min_Ord_Graph arg-1626 arg-1629)))))
(define csegen-2334 (cons (lambda (arg-676) (lambda (arg-679) (PreludeC-45EqOrd-u--C-61C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-832 csegen-2291 arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (PreludeC-45EqOrd-u--C-47C-61_Eq_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-832 csegen-2291 arg-686 arg-689)))))
(define csegen-2345 (vector csegen-2334 (lambda (arg-1566) (lambda (arg-1569) (PreludeC-45EqOrd-u--compare_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-861 csegen-2299 arg-1566 arg-1569))) (lambda (arg-1576) (lambda (arg-1579) (PreludeC-45EqOrd-u--C-60_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-861 csegen-2299 arg-1576 arg-1579))) (lambda (arg-1586) (lambda (arg-1589) (PreludeC-45EqOrd-u--C-62_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-861 csegen-2299 arg-1586 arg-1589))) (lambda (arg-1596) (lambda (arg-1599) (PreludeC-45EqOrd-u--C-60C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-861 csegen-2299 arg-1596 arg-1599))) (lambda (arg-1606) (lambda (arg-1609) (PreludeC-45EqOrd-u--C-62C-61_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-861 csegen-2299 arg-1606 arg-1609))) (lambda (arg-1616) (lambda (arg-1619) (PreludeC-45EqOrd-u--max_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-861 csegen-2299 arg-1616 arg-1619))) (lambda (arg-1626) (lambda (arg-1629) (PreludeC-45EqOrd-u--min_Ord_C-40C-124C-40C-40BuiltinC-46PairC-32C-36aC-41C-32C-36bC-41C-44C-40C-40BuiltinC-46MkPairC-32C-36aC-41C-32C-36bC-41C-124C-41 csegen-861 csegen-2299 arg-1626 arg-1629)))))
(define AlgebraC-45SizeChange-u--plusNeutral_Semiring_SizeChange 2)
(define AlgebraC-45SizeChange-u--neutral_Monoid_SizeChange 1)
(define AlgebraC-45SizeChange-u--timesNeutral_Semiring_SizeChange AlgebraC-45SizeChange-u--neutral_Monoid_SizeChange)
(define AlgebraC-45SizeChange-u--C-60C-43C-62_Semigroup_SizeChange (lambda (arg-0 arg-1) (cond ((equal? arg-0 2) 2) ((equal? arg-0 1) arg-1)(else (cond ((equal? arg-1 2) 2)(else (cond (else 0))))))))
(define AlgebraC-45SizeChange-u--C-124C-42C-124_Semiring_SizeChange (lambda (ext-0 ext-1) (AlgebraC-45SizeChange-u--C-60C-43C-62_Semigroup_SizeChange ext-0 ext-1)))
(define AlgebraC-45SizeChange-u--C-124C-43C-124_Semiring_SizeChange (lambda (ext-0 ext-1) (AlgebraC-45SizeChange-u--max_Ord_SizeChange ext-0 ext-1)))
(define csegen-2362 (cons csegen-1035 (vector (lambda (arg-823) (lambda (arg-826) (AlgebraC-45SizeChange-u--C-124C-43C-124_Semiring_SizeChange arg-823 arg-826))) AlgebraC-45SizeChange-u--plusNeutral_Semiring_SizeChange (lambda (arg-835) (lambda (arg-838) (AlgebraC-45SizeChange-u--C-124C-42C-124_Semiring_SizeChange arg-835 arg-838))) AlgebraC-45SizeChange-u--timesNeutral_Semiring_SizeChange)))
(define CoreC-45Context-u--full_HasNames_Terminating (lambda (arg-0 arg-1 ext-0) (case (vector-ref arg-1 0) ((2) (let ((e-0 (vector-ref arg-1 1))) (let ((act-1 (CoreC-45Context-u--full_HasNames_PartialReason arg-0 e-0 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (vector 1 (vector 2 e-5))))) eff-0) ext-0)))))))(else (vector 1 arg-1)))))
(define csegen-2365 (cons (lambda (arg-7719) (lambda (arg-7722) (lambda (eta-0) (CoreC-45Context-u--full_HasNames_Terminating arg-7719 arg-7722 eta-0)))) (lambda (arg-7729) (lambda (arg-7732) (lambda (eta-0) (CoreC-45Context-u--resolved_HasNames_Terminating arg-7729 arg-7732 eta-0))))))
(define CoreC-45NameC-45Namespace-builtinNS (CoreC-45NameC-45Namespace-mkNamespace "Builtin"))
(define csegen-2366 (vector 0 CoreC-45NameC-45Namespace-builtinNS (vector 1 (vector 0 "assert_total"))))
(define CoreC-45TerminationC-45CallGraph-sizeEq (lambda (arg-3 arg-4) (case (vector-ref arg-3 0) ((0) (let ((e-52 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((0) (let ((e-81 (vector-ref arg-4 3))) (or (and (= e-52 e-81) 1) 0)))(else (case (vector-ref arg-4 0) ((5) (let ((e-46 (vector-ref arg-4 3))) (let ((e-47 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-46))) (cond ((equal? sc2 1) 1) (else (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-47)))))))(else (case (vector-ref arg-3 0) ((6) (let ((e-14 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((6) (let ((e-30 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-14 e-30)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((7) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((7) (let ((e-34 (vector-ref arg-4 3))) (let ((e-35 (vector-ref arg-4 4))) (let ((sc3 (CoreC-45TerminationC-45CallGraph-sizeEq e-18 e-34))) (cond ((equal? sc3 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-19 e-35)) (else 0))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))) ((8) (let ((e-23 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((8) (let ((e-39 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-23 e-39)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((9) (let ((e-26 (vector-ref arg-3 2))) (case (vector-ref arg-4 0) ((9) (let ((e-42 (vector-ref arg-4 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-26 e-42)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))))))) ((1) (let ((e-57 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((1) (let ((e-86 (vector-ref arg-4 3))) (CoreC-45Name-u--C-61C-61_Eq_Name e-57 e-86)))(else (case (vector-ref arg-4 0) ((5) (let ((e-46 (vector-ref arg-4 3))) (let ((e-47 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-46))) (cond ((equal? sc2 1) 1) (else (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-47)))))))(else (case (vector-ref arg-3 0) ((6) (let ((e-14 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((6) (let ((e-30 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-14 e-30)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((7) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((7) (let ((e-34 (vector-ref arg-4 3))) (let ((e-35 (vector-ref arg-4 4))) (let ((sc3 (CoreC-45TerminationC-45CallGraph-sizeEq e-18 e-34))) (cond ((equal? sc3 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-19 e-35)) (else 0))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))) ((8) (let ((e-23 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((8) (let ((e-39 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-23 e-39)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((9) (let ((e-26 (vector-ref arg-3 2))) (case (vector-ref arg-4 0) ((9) (let ((e-42 (vector-ref arg-4 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-26 e-42)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))))))) ((2) (let ((e-61 (vector-ref arg-3 3))) (let ((e-62 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((2) (let ((e-90 (vector-ref arg-4 3))) (let ((e-91 (vector-ref arg-4 4))) (let ((sc2 (PreludeC-45EqOrd-u--C-61C-61_Eq_Int e-61 e-90))) (cond ((equal? sc2 1) (PreludeC-45Types-u--foldMap_Foldable_List csegen-186 (lambda (eta-0) (PreludeC-45Basics-uncurry (csegen-2367) eta-0)) (DataC-45List-u--zip_Zippable_List e-62 e-91))) (else 0))))))(else (case (vector-ref arg-4 0) ((5) (let ((e-46 (vector-ref arg-4 3))) (let ((e-47 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-46))) (cond ((equal? sc2 1) 1) (else (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-47)))))))(else (case (vector-ref arg-3 0) ((6) (let ((e-14 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((6) (let ((e-30 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-14 e-30)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((7) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((7) (let ((e-34 (vector-ref arg-4 3))) (let ((e-35 (vector-ref arg-4 4))) (let ((sc3 (CoreC-45TerminationC-45CallGraph-sizeEq e-18 e-34))) (cond ((equal? sc3 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-19 e-35)) (else 0))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))) ((8) (let ((e-23 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((8) (let ((e-39 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-23 e-39)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((9) (let ((e-26 (vector-ref arg-3 2))) (case (vector-ref arg-4 0) ((9) (let ((e-42 (vector-ref arg-4 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-26 e-42)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))))))) ((3) (let ((e-66 (vector-ref arg-3 3))) (let ((e-67 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((3) (let ((e-95 (vector-ref arg-4 3))) (let ((e-96 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TTC-45Binder-eqBinderBy (csegen-2367) e-66 e-95))) (cond ((equal? sc2 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-67 e-96)) (else 0))))))(else (case (vector-ref arg-4 0) ((5) (let ((e-46 (vector-ref arg-4 3))) (let ((e-47 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-46))) (cond ((equal? sc2 1) 1) (else (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-47)))))))(else (case (vector-ref arg-3 0) ((6) (let ((e-14 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((6) (let ((e-30 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-14 e-30)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((7) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((7) (let ((e-34 (vector-ref arg-4 3))) (let ((e-35 (vector-ref arg-4 4))) (let ((sc3 (CoreC-45TerminationC-45CallGraph-sizeEq e-18 e-34))) (cond ((equal? sc3 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-19 e-35)) (else 0))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))) ((8) (let ((e-23 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((8) (let ((e-39 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-23 e-39)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((9) (let ((e-26 (vector-ref arg-3 2))) (case (vector-ref arg-4 0) ((9) (let ((e-42 (vector-ref arg-4 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-26 e-42)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))))))) ((4) (let ((e-70 (vector-ref arg-3 2))) (let ((e-71 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((4) (let ((e-99 (vector-ref arg-4 2))) (let ((e-100 (vector-ref arg-4 3))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq e-70 e-99))) (cond ((equal? sc2 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-71 e-100)) (else 0))))))(else (case (vector-ref arg-4 0) ((5) (let ((e-46 (vector-ref arg-4 3))) (let ((e-47 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-46))) (cond ((equal? sc2 1) 1) (else (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-47)))))))(else (case (vector-ref arg-3 0) ((6) (let ((e-14 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((6) (let ((e-30 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-14 e-30)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((7) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((7) (let ((e-34 (vector-ref arg-4 3))) (let ((e-35 (vector-ref arg-4 4))) (let ((sc3 (CoreC-45TerminationC-45CallGraph-sizeEq e-18 e-34))) (cond ((equal? sc3 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-19 e-35)) (else 0))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))) ((8) (let ((e-23 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((8) (let ((e-39 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-23 e-39)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((9) (let ((e-26 (vector-ref arg-3 2))) (case (vector-ref arg-4 0) ((9) (let ((e-42 (vector-ref arg-4 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-26 e-42)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))))))) ((5) (let ((e-76 (vector-ref arg-3 4))) (CoreC-45TerminationC-45CallGraph-sizeEq e-76 arg-4)))(else (case (vector-ref arg-4 0) ((5) (let ((e-46 (vector-ref arg-4 3))) (let ((e-47 (vector-ref arg-4 4))) (let ((sc1 (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-46))) (cond ((equal? sc1 1) 1) (else (CoreC-45TerminationC-45CallGraph-sizeEq arg-3 e-47)))))))(else (case (vector-ref arg-3 0) ((6) (let ((e-14 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((6) (let ((e-30 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-14 e-30)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((7) (let ((e-18 (vector-ref arg-3 3))) (let ((e-19 (vector-ref arg-3 4))) (case (vector-ref arg-4 0) ((7) (let ((e-34 (vector-ref arg-4 3))) (let ((e-35 (vector-ref arg-4 4))) (let ((sc2 (CoreC-45TerminationC-45CallGraph-sizeEq e-18 e-34))) (cond ((equal? sc2 1) (CoreC-45TerminationC-45CallGraph-sizeEq e-19 e-35)) (else 0))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))) ((8) (let ((e-23 (vector-ref arg-3 3))) (case (vector-ref arg-4 0) ((8) (let ((e-39 (vector-ref arg-4 3))) (CoreC-45TerminationC-45CallGraph-sizeEq e-23 e-39)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0)))))))) ((9) (let ((e-26 (vector-ref arg-3 2))) (case (vector-ref arg-4 0) ((9) (let ((e-42 (vector-ref arg-4 2))) (CoreC-45TTC-45Primitive-u--C-61C-61_Eq_Constant e-26 e-42)))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))(else (case (vector-ref arg-4 0) ((10) (let ((e-8 (vector-ref arg-4 2))) (case (vector-ref e-8 0) ((2) (let ((e-10 (vector-ref e-8 1))) (CoreC-45TTC-45Term-eqTerm arg-3 e-10)))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))(else (case (vector-ref arg-3 0) ((11) (case (vector-ref arg-4 0) ((11) 1)(else 0)))(else 0))))))))))))
(define csegen-2367 (lambda () (lambda (eta-0) (lambda (eta-1) (CoreC-45TerminationC-45CallGraph-sizeEq eta-0 eta-1)))))
(define csegen-2373 (vector 0 csegen-30))
(define TTImpC-45ElabC-45Check-u--C-61C-61_Eq_ElabOpt (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) (cond ((equal? arg-1 0) 1)(else 0))) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else 0))) ((equal? arg-0 2) (cond ((equal? arg-1 2) 1)(else 0))) ((equal? arg-0 3) (cond ((equal? arg-1 3) 1)(else 0)))(else 0))))
(define TTImpC-45ElabC-45Check-u--C-47C-61_Eq_ElabOpt (lambda (arg-0 arg-1) (let ((sc0 (TTImpC-45ElabC-45Check-u--C-61C-61_Eq_ElabOpt arg-0 arg-1))) (cond ((equal? sc0 1) 0) (else 1)))))
(define csegen-2376 (cons (lambda (arg-676) (lambda (arg-679) (TTImpC-45ElabC-45Check-u--C-61C-61_Eq_ElabOpt arg-676 arg-679))) (lambda (arg-686) (lambda (arg-689) (TTImpC-45ElabC-45Check-u--C-47C-61_Eq_ElabOpt arg-686 arg-689)))))
(define AlgebraC-45ZeroOneOmega-u--C-60C-61_Preorder_ZeroOneOmega (lambda (arg-0 arg-1) (cond ((equal? arg-0 0) 1) ((equal? arg-0 1) (cond ((equal? arg-1 1) 1)(else (cond ((equal? arg-1 2) 1)(else 0)))))(else (cond ((equal? arg-1 2) 1)(else 0))))))
(define AlgebraC-45ZeroOneOmega-u--preorderRefl_Preorder_ZeroOneOmega (lambda (arg-0) (cond ((equal? arg-0 0) (vector 0 )) ((equal? arg-0 1) (vector 0 )) (else (vector 0 )))))
(define AlgebraC-45ZeroOneOmega-u--preorderTrans_Preorder_ZeroOneOmega (lambda (arg-0 arg-1 arg-2 arg-3 arg-4) (cond ((equal? arg-0 0) (vector 0 )) ((equal? arg-0 1) (cond ((equal? arg-1 1) arg-4) (else (cond ((equal? arg-2 1) (vector 0 )) (else (vector 0 )))))) (else (cond (else arg-4))))))
(define csegen-2382 (vector (lambda (arg-823) (lambda (arg-826) (AlgebraC-45ZeroOneOmega-u--C-60C-61_Preorder_ZeroOneOmega arg-823 arg-826))) (lambda (u--x) (AlgebraC-45ZeroOneOmega-u--preorderRefl_Preorder_ZeroOneOmega u--x)) (lambda (u--x) (lambda (u--y) (lambda (u--z) (lambda (arg-847) (lambda (arg-853) (AlgebraC-45ZeroOneOmega-u--preorderTrans_Preorder_ZeroOneOmega u--x u--y u--z arg-847 arg-853))))))))
(define CoreC-45Reflect-builtin (lambda (arg-0) (vector 0 CoreC-45NameC-45Namespace-builtinNS (vector 1 (vector 0 arg-0)))))
(define CoreC-45Context-lookupExactBy (lambda (arg-1 arg-2 arg-3 ext-0) (let ((act-1 ((CoreC-45Context-lookupCtxtExact arg-2 arg-3) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (clam-0) (if (null? e-5) (vector 1 '()) (let ((e-1 (unbox e-5))) (vector 1 (box (arg-1 e-1)))))))) eff-0) ext-0)))))))
(define CoreC-45Context-lookupDefExact (lambda (ext-2 ext-1 ext-0) (CoreC-45Context-lookupExactBy csegen-1315 ext-2 ext-1 ext-0)))
(define CoreC-45Reflect-getCon (lambda (arg-0 arg-1 arg-2 arg-3 ext-0) (let ((act-1 (CoreC-45Context-lookupDefExact arg-3 (let ((e-0 (vector-ref arg-2 0))) e-0) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (if (null? e-5) (lambda (eta-0) (CoreC-45Core-u--throw_Catchable_Core_Error (vector 7 arg-1 arg-3) eta-0)) (let ((e-1 (unbox e-5))) (case (vector-ref e-1 0) ((5) (let ((e-2 (vector-ref e-1 1))) (let ((e-3 (vector-ref e-1 2))) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 (let ((e-0 (vector-ref arg-2 0))) e-0) (vector 1 arg-1 (vector 2 e-2 e-3) arg-3))))) ((6) (let ((e-13 (vector-ref e-1 1))) (let ((e-6 (vector-ref e-1 2))) (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 (let ((e-0 (vector-ref arg-2 0))) e-0) (vector 1 arg-1 (vector 3 e-13 e-6) arg-3)))))(else (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 (let ((e-0 (vector-ref arg-2 0))) e-0) (vector 1 arg-1 (vector 1 ) arg-3)))))))) eff-0) ext-0)))))))
(define CoreC-45Reflect-u--reflect_Reflect_C-40C-124UnitC-44MkUnitC-124C-41 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-builtin "MkUnit") ext-0)))
(define csegen-2384 (lambda (eta-0) (lambda (eta-1) (lambda (eta-2) (lambda (eta-3) (lambda (eta-4) (lambda (eta-5) (lambda (eta-6) (CoreC-45Reflect-u--reflect_Reflect_C-40C-124UnitC-44MkUnitC-124C-41 eta-0 eta-1 eta-2 eta-3 eta-4 eta-5 eta-6)))))))))
(define CoreC-45Reflect-appCon (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 ext-0) (let ((act-1 (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 arg-3 ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (CoreC-45Context-u--resolved_HasNames_C-40TermC-32C-36varsC-41 (let ((e-0 (vector-ref arg-2 0))) e-0) (CoreC-45TTC-45Term-apply arg-1 e-5 arg-4)))) eff-0) ext-0)))))))
(define CoreC-45NameC-45Namespace-reflectionTTImpNS (CoreC-45NameC-45Namespace-mkNamespace "Language.Reflection.TTImp"))
(define CoreC-45Reflect-reflectionttimp (lambda (arg-0) (vector 0 CoreC-45NameC-45Namespace-reflectionTTImpNS (vector 1 (vector 0 arg-0)))))
(define CoreC-45NameC-45Namespace-basicsNS (CoreC-45NameC-45Namespace-mkNamespace "Prelude.Basics"))
(define CoreC-45Reflect-basics (lambda (arg-0) (vector 0 CoreC-45NameC-45Namespace-basicsNS (vector 1 (vector 0 arg-0)))))
(define CoreC-45Reflect-u--reflect_Reflect_C-40ListC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3 arg-4 arg-5 arg-6 arg-7) (lambda (clam-0) (if (null? arg-7) (CoreC-45Reflect-appCon arg-2 arg-3 arg-4 (CoreC-45Reflect-basics "Nil") (cons (vector 10 arg-3 (vector 0 )) '()) clam-0) (let ((e-2 (car arg-7))) (let ((e-3 (cdr arg-7))) (let ((act-1 (((((((arg-1 arg-2) arg-3) arg-4) arg-5) arg-6) e-2) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-4 (vector-ref act-1 1))) (vector 0 e-4))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (let ((act-2 (((((((let ((eff-0 (lambda (u--vars) (lambda (arg-1780) (lambda (arg-1783) (lambda (u--onLHS) (lambda (arg-1788) (lambda (arg-1792) (CoreC-45Reflect-u--reflect_Reflect_C-40ListC-32C-36aC-41 arg-1 u--vars arg-1780 arg-1783 u--onLHS arg-1788 arg-1792))))))))) (lambda (arg-0) (lambda (arg-8) (lambda (arg-9) (lambda (arg-10) (lambda (arg-11) ((((((eff-0 arg-2) arg-0) arg-8) arg-9) arg-10) arg-11))))))) arg-3) arg-4) arg-5) arg-6) e-3) eta-0))) (case (vector-ref act-2 0) ((0) (let ((e-4 (vector-ref act-2 1))) (vector 0 e-4))) (else (let ((e-6 (vector-ref act-2 1))) ((let ((eff-0 (lambda (eta-1) (CoreC-45Reflect-appCon arg-2 arg-3 arg-4 (CoreC-45Reflect-basics "::") (cons (vector 10 arg-3 (vector 0 )) (cons e-5 (cons e-6 '()))) eta-1)))) eff-0) eta-0)))))))) eff-0) clam-0)))))))))))
(define CoreC-45Reflect-preludetypes (lambda (arg-0) (vector 0 CoreC-45NameC-45Namespace-typesNS (vector 1 (vector 0 arg-0)))))
(define CoreC-45Reflect-u--reflect_Reflect_C-40MaybeC-32C-36aC-41 (lambda (arg-1 arg-2 arg-3 arg-4 arg-5 arg-6 arg-7) (lambda (clam-0) (if (null? arg-7) (CoreC-45Reflect-appCon arg-2 arg-3 arg-4 (CoreC-45Reflect-preludetypes "Nothing") (cons (vector 10 arg-3 (vector 0 )) '()) clam-0) (let ((e-2 (unbox arg-7))) (let ((act-1 (((((((arg-1 arg-2) arg-3) arg-4) arg-5) arg-6) e-2) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-2 arg-3 arg-4 (CoreC-45Reflect-preludetypes "Just") (cons (vector 10 arg-3 (vector 0 )) (cons e-5 '())) eta-0)))) eff-0) clam-0))))))))))
(define CoreC-45NameC-45Namespace-reflectionTTNS (CoreC-45NameC-45Namespace-mkNamespace "Language.Reflection.TT"))
(define CoreC-45Reflect-reflectiontt (lambda (arg-0) (vector 0 CoreC-45NameC-45Namespace-reflectionTTNS (vector 1 (vector 0 arg-0)))))
(define CoreC-45Reflect-u--reflect_Reflect_C-40PiInfoC-32C-36tC-41 (lambda (arg-1 arg-2 arg-3 arg-4 arg-5 arg-6 arg-7) (lambda (clam-0) (case (vector-ref arg-7 0) ((0) (CoreC-45Reflect-appCon arg-2 arg-3 arg-4 (CoreC-45Reflect-reflectiontt "ImplicitArg") (cons (vector 10 arg-3 (vector 0 )) '()) clam-0)) ((1) (CoreC-45Reflect-appCon arg-2 arg-3 arg-4 (CoreC-45Reflect-reflectiontt "ExplicitArg") (cons (vector 10 arg-3 (vector 0 )) '()) clam-0)) ((2) (CoreC-45Reflect-appCon arg-2 arg-3 arg-4 (CoreC-45Reflect-reflectiontt "AutoImplicit") (cons (vector 10 arg-3 (vector 0 )) '()) clam-0)) (else (let ((e-4 (vector-ref arg-7 1))) (let ((act-1 (((((((arg-1 arg-2) arg-3) arg-4) arg-5) arg-6) e-4) clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-2 arg-3 arg-4 (CoreC-45Reflect-reflectiontt "DefImplicit") (cons (vector 10 arg-3 (vector 0 )) (cons e-5 '())) eta-0)))) eff-0) clam-0)))))))))))
(define TTImpC-45Reflect-u--reflect_Reflect_AltType (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (case (vector-ref arg-5 0) ((0) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectionttimp "FirstSuccess") ext-0)) ((1) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectionttimp "Unique") ext-0)) (else (let ((e-3 (vector-ref arg-5 1))) (let ((act-1 ((TTImpC-45Reflect-u--reflect_Reflect_RawImp arg-0 arg-1 arg-2 arg-3 arg-4 e-3) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectionttimp "UniqueDefault") (cons e-5 '()) eta-0)))) eff-0) ext-0))))))))))
(define CoreC-45Reflect-u--reflect_Reflect_RigCount (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5) (AlgebraC-45Semiring-elimSemi csegen-931 (lambda (eta-0) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "M0") eta-0)) (lambda (eta-0) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "M1") eta-0)) (lambda (eta-0) (lambda (eta-1) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "MW") eta-1))) arg-5)))
(define TTImpC-45Reflect-u--reflect_Reflect_BindMode (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (case (vector-ref arg-5 0) ((0) (let ((e-0 (vector-ref arg-5 1))) (let ((act-1 ((CoreC-45Reflect-u--reflect_Reflect_RigCount arg-0 arg-1 arg-2 arg-3 arg-4 e-0) ext-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectionttimp "PI") (cons e-5 '()) eta-0)))) eff-0) ext-0))))))) ((1) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectionttimp "PATTERN") ext-0)) ((2) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectionttimp "COVERAGE") ext-0)) (else (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectionttimp "NONE") ext-0)))))
(define CoreC-45Reflect-u--reflect_Reflect_Bool (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5) (lambda (clam-0) (cond ((equal? arg-5 1) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-basics "True") clam-0)) (else (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-basics "False") clam-0))))))
(define CoreC-45Reflect-u--reflect_Reflect_Bits16 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 7 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_Bits32 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 8 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_Bits64 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 9 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_Bits8 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 6 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_Char (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 11 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_Double (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 12 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_Int (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 0 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_Int16 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 2 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_Int32 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 3 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_Int64 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 4 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_Int8 (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 1 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_Integer (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 5 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_PrimType (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5) (lambda (clam-0) (cond ((equal? arg-5 0) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "IntType") clam-0)) ((equal? arg-5 1) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "Int8Type") clam-0)) ((equal? arg-5 2) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "Int16Type") clam-0)) ((equal? arg-5 3) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "Int32Type") clam-0)) ((equal? arg-5 4) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "Int64Type") clam-0)) ((equal? arg-5 5) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "IntegerType") clam-0)) ((equal? arg-5 6) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "Bits8Type") clam-0)) ((equal? arg-5 7) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "Bits16Type") clam-0)) ((equal? arg-5 8) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "Bits32Type") clam-0)) ((equal? arg-5 9) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "Bits64Type") clam-0)) ((equal? arg-5 10) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "StringType") clam-0)) ((equal? arg-5 11) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "CharType") clam-0)) ((equal? arg-5 12) (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "DoubleType") clam-0)) (else (CoreC-45Reflect-getCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "WorldType") clam-0))))))
(define CoreC-45Reflect-u--reflect_Reflect_String (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5 ext-0) (vector 1 (vector 9 arg-1 (vector 10 arg-5)))))
(define CoreC-45Reflect-u--reflect_Reflect_Constant (lambda (arg-0 arg-1 arg-2 arg-3 arg-4 arg-5) (lambda (clam-0) (case (vector-ref arg-5 0) ((0) (let ((e-0 (vector-ref arg-5 1))) (let ((act-1 (CoreC-45Reflect-u--reflect_Reflect_Int arg-0 arg-1 arg-2 arg-3 arg-4 e-0 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "I") (cons e-5 '()) eta-0)))) eff-0) clam-0))))))) ((1) (let ((e-1 (vector-ref arg-5 1))) (let ((act-1 (CoreC-45Reflect-u--reflect_Reflect_Int8 arg-0 arg-1 arg-2 arg-3 arg-4 e-1 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "I8") (cons e-5 '()) eta-0)))) eff-0) clam-0))))))) ((2) (let ((e-2 (vector-ref arg-5 1))) (let ((act-1 (CoreC-45Reflect-u--reflect_Reflect_Int16 arg-0 arg-1 arg-2 arg-3 arg-4 e-2 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-3 (vector-ref act-1 1))) (vector 0 e-3))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "I16") (cons e-5 '()) eta-0)))) eff-0) clam-0))))))) ((3) (let ((e-3 (vector-ref arg-5 1))) (let ((act-1 (CoreC-45Reflect-u--reflect_Reflect_Int32 arg-0 arg-1 arg-2 arg-3 arg-4 e-3 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "I32") (cons e-5 '()) eta-0)))) eff-0) clam-0))))))) ((4) (let ((e-4 (vector-ref arg-5 1))) (let ((act-1 (CoreC-45Reflect-u--reflect_Reflect_Int64 arg-0 arg-1 arg-2 arg-3 arg-4 e-4 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "I64") (cons e-5 '()) eta-0)))) eff-0) clam-0))))))) ((5) (let ((e-5 (vector-ref arg-5 1))) (let ((act-1 (CoreC-45Reflect-u--reflect_Reflect_Integer arg-0 arg-1 arg-2 arg-3 arg-4 e-5 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-6 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "BI") (cons e-6 '()) eta-0)))) eff-0) clam-0))))))) ((6) (let ((e-6 (vector-ref arg-5 1))) (let ((act-1 (CoreC-45Reflect-u--reflect_Reflect_Bits8 arg-0 arg-1 arg-2 arg-3 arg-4 e-6 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "B8") (cons e-5 '()) eta-0)))) eff-0) clam-0))))))) ((7) (let ((e-7 (vector-ref arg-5 1))) (let ((act-1 (CoreC-45Reflect-u--reflect_Reflect_Bits16 arg-0 arg-1 arg-2 arg-3 arg-4 e-7 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "B16") (cons e-5 '()) eta-0)))) eff-0) clam-0))))))) ((8) (let ((e-8 (vector-ref arg-5 1))) (let ((act-1 (CoreC-45Reflect-u--reflect_Reflect_Bits32 arg-0 arg-1 arg-2 arg-3 arg-4 e-8 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "B32") (cons e-5 '()) eta-0)))) eff-0) clam-0))))))) ((9) (let ((e-9 (vector-ref arg-5 1))) (let ((act-1 (CoreC-45Reflect-u--reflect_Reflect_Bits64 arg-0 arg-1 arg-2 arg-3 arg-4 e-9 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "B64") (cons e-5 '()) eta-0)))) eff-0) clam-0))))))) ((10) (let ((e-10 (vector-ref arg-5 1))) (let ((act-1 (CoreC-45Reflect-u--reflect_Reflect_String arg-0 arg-1 arg-2 arg-3 arg-4 e-10 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectiontt "Str") (cons e-5 '()) eta-0)))) eff-0) clam-0))))))) ((11) (let ((e-11 (vector-ref arg-5 1))) (let ((act-1 (CoreC-45Reflect-u--reflect_Reflect_Char arg-0 arg-1 arg-2 arg-3 arg-4 e-11 clam-0))) (case (vector-ref act-1 0) ((0) (let ((e-2 (vector-ref act-1 1))) (vector 0 e-2))) (else (let ((e-5 (vector-ref act-1 1))) ((let ((eff-0 (lambda (eta-0) (CoreC-45Reflect-appCon arg-0 arg-1 arg-2 (CoreC-45Reflect-reflectio