/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dom.builder.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.shared.impl.StringCase;
import com.google.gwt.dom.builder.client.DomBuilderImpl;
import com.google.gwt.dom.builder.shared.StylesBuilder;
import com.google.gwt.dom.client.Style;
import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.safehtml.shared.SafeUri;

class DomStylesBuilder
implements StylesBuilder {
    private static JavaScriptObject hyphenatedMap;
    private static RegExp maybeHyphenatedWord;
    private final DomBuilderImpl delegate;

    static String toCamelCaseForm(String name) {
        if (hyphenatedMap == null) {
            hyphenatedMap = JavaScriptObject.createObject();
            maybeHyphenatedWord = RegExp.compile("([-]?)([a-z])([a-z0-9]*)", "g");
        }
        if (!name.contains("-")) {
            return name;
        }
        String camelCase = DomStylesBuilder.getCamelCaseName(hyphenatedMap, name);
        if (camelCase == null) {
            MatchResult matches;
            if (name.startsWith("-") && name.length() > 1) {
                name = name.substring(1);
            }
            camelCase = "";
            while ((matches = maybeHyphenatedWord.exec(name)) != null) {
                String word = matches.getGroup(0);
                if (!word.startsWith("-")) {
                    camelCase = camelCase + word;
                    continue;
                }
                camelCase = camelCase + StringCase.toUpper(matches.getGroup(2));
                if (matches.getGroupCount() <= 2) continue;
                camelCase = camelCase + matches.getGroup(3);
            }
            DomStylesBuilder.putCamelCaseName(hyphenatedMap, name, camelCase);
        }
        return camelCase;
    }

    private static native String getCamelCaseName(JavaScriptObject var0, String var1);

    private static native void putCamelCaseName(JavaScriptObject var0, String var1, String var2);

    DomStylesBuilder(DomBuilderImpl delegate) {
        this.delegate = delegate;
    }

    @Override
    public StylesBuilder backgroundImage(SafeUri uri) {
        this.delegate.assertCanAddStyleProperty().setBackgroundImage(uri.asString());
        return this;
    }

    @Override
    public StylesBuilder borderStyle(Style.BorderStyle value) {
        this.delegate.assertCanAddStyleProperty().setBorderStyle(value);
        return this;
    }

    @Override
    public StylesBuilder borderWidth(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setBorderWidth(value, unit);
        return this;
    }

    @Override
    public StylesBuilder bottom(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setBottom(value, unit);
        return this;
    }

    @Override
    public StylesBuilder cursor(Style.Cursor value) {
        this.delegate.assertCanAddStyleProperty().setCursor(value);
        return this;
    }

    @Override
    public StylesBuilder display(Style.Display value) {
        this.delegate.assertCanAddStyleProperty().setDisplay(value);
        return this;
    }

    @Override
    public void endStyle() {
        this.delegate.endStyle();
    }

    @Override
    public StylesBuilder floatprop(Style.Float value) {
        this.delegate.assertCanAddStyleProperty().setFloat(value);
        return this;
    }

    @Override
    public StylesBuilder fontSize(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setFontSize(value, unit);
        return this;
    }

    @Override
    public StylesBuilder fontStyle(Style.FontStyle value) {
        this.delegate.assertCanAddStyleProperty().setFontStyle(value);
        return this;
    }

    @Override
    public StylesBuilder fontWeight(Style.FontWeight value) {
        this.delegate.assertCanAddStyleProperty().setFontWeight(value);
        return this;
    }

    @Override
    public StylesBuilder height(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setHeight(value, unit);
        return this;
    }

    @Override
    public StylesBuilder left(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setLeft(value, unit);
        return this;
    }

    @Override
    public StylesBuilder lineHeight(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setLineHeight(value, unit);
        return this;
    }

    @Override
    public StylesBuilder listStyleType(Style.ListStyleType value) {
        this.delegate.assertCanAddStyleProperty().setListStyleType(value);
        return this;
    }

    @Override
    public StylesBuilder margin(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setMargin(value, unit);
        return this;
    }

    @Override
    public StylesBuilder marginBottom(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setMarginBottom(value, unit);
        return this;
    }

    @Override
    public StylesBuilder marginLeft(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setMarginLeft(value, unit);
        return this;
    }

    @Override
    public StylesBuilder marginRight(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setMarginRight(value, unit);
        return this;
    }

    @Override
    public StylesBuilder marginTop(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setMarginTop(value, unit);
        return this;
    }

    @Override
    public StylesBuilder opacity(double value) {
        this.delegate.assertCanAddStyleProperty().setOpacity(value);
        return this;
    }

    @Override
    public StylesBuilder outlineStyle(Style.OutlineStyle value) {
        this.delegate.assertCanAddStyleProperty().setOutlineStyle(value);
        return this;
    }

    @Override
    public StylesBuilder outlineWidth(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setOutlineWidth(value, unit);
        return this;
    }

    @Override
    public StylesBuilder overflow(Style.Overflow value) {
        this.delegate.assertCanAddStyleProperty().setOverflow(value);
        return this;
    }

    @Override
    public StylesBuilder overflowX(Style.Overflow value) {
        this.delegate.assertCanAddStyleProperty().setOverflowX(value);
        return this;
    }

    @Override
    public StylesBuilder overflowY(Style.Overflow value) {
        this.delegate.assertCanAddStyleProperty().setOverflowY(value);
        return this;
    }

    @Override
    public StylesBuilder padding(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setPadding(value, unit);
        return this;
    }

    @Override
    public StylesBuilder paddingBottom(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setPaddingBottom(value, unit);
        return this;
    }

    @Override
    public StylesBuilder paddingLeft(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setPaddingLeft(value, unit);
        return this;
    }

    @Override
    public StylesBuilder paddingRight(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setPaddingRight(value, unit);
        return this;
    }

    @Override
    public StylesBuilder paddingTop(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setPaddingTop(value, unit);
        return this;
    }

    @Override
    public StylesBuilder position(Style.Position value) {
        this.delegate.assertCanAddStyleProperty().setPosition(value);
        return this;
    }

    @Override
    public StylesBuilder right(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setRight(value, unit);
        return this;
    }

    @Override
    public StylesBuilder tableLayout(Style.TableLayout value) {
        this.delegate.assertCanAddStyleProperty().setTableLayout(value);
        return this;
    }

    @Override
    public StylesBuilder textAlign(Style.TextAlign value) {
        this.delegate.assertCanAddStyleProperty().setTextAlign(value);
        return this;
    }

    @Override
    public StylesBuilder textDecoration(Style.TextDecoration value) {
        this.delegate.assertCanAddStyleProperty().setTextDecoration(value);
        return this;
    }

    @Override
    public StylesBuilder textIndent(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setTextIndent(value, unit);
        return this;
    }

    @Override
    public StylesBuilder textJustify(Style.TextJustify value) {
        this.delegate.assertCanAddStyleProperty().setTextJustify(value);
        return this;
    }

    @Override
    public StylesBuilder textOverflow(Style.TextOverflow value) {
        this.delegate.assertCanAddStyleProperty().setTextOverflow(value);
        return this;
    }

    @Override
    public StylesBuilder textTransform(Style.TextTransform value) {
        this.delegate.assertCanAddStyleProperty().setTextTransform(value);
        return this;
    }

    @Override
    public StylesBuilder top(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setTop(value, unit);
        return this;
    }

    @Override
    public StylesBuilder trustedBackgroundColor(String value) {
        this.delegate.assertCanAddStyleProperty().setBackgroundColor(value);
        return this;
    }

    @Override
    public StylesBuilder trustedBackgroundImage(String value) {
        this.delegate.assertCanAddStyleProperty().setBackgroundImage(value);
        return this;
    }

    @Override
    public StylesBuilder trustedBorderColor(String value) {
        this.delegate.assertCanAddStyleProperty().setBorderColor(value);
        return this;
    }

    @Override
    public StylesBuilder trustedColor(String value) {
        this.delegate.assertCanAddStyleProperty().setColor(value);
        return this;
    }

    @Override
    public StylesBuilder trustedOutlineColor(String value) {
        this.delegate.assertCanAddStyleProperty().setOutlineColor(value);
        return this;
    }

    @Override
    public StylesBuilder trustedProperty(String name, double value, Style.Unit unit) {
        name = DomStylesBuilder.toCamelCaseForm(name);
        this.delegate.assertCanAddStyleProperty().setProperty(name, value, unit);
        return this;
    }

    @Override
    public StylesBuilder trustedProperty(String name, String value) {
        name = DomStylesBuilder.toCamelCaseForm(name);
        this.delegate.assertCanAddStyleProperty().setProperty(name, value);
        return this;
    }

    @Override
    public StylesBuilder verticalAlign(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setVerticalAlign(value, unit);
        return this;
    }

    @Override
    public StylesBuilder verticalAlign(Style.VerticalAlign value) {
        this.delegate.assertCanAddStyleProperty().setVerticalAlign(value);
        return this;
    }

    @Override
    public StylesBuilder visibility(Style.Visibility value) {
        this.delegate.assertCanAddStyleProperty().setVisibility(value);
        return this;
    }

    @Override
    public StylesBuilder width(double value, Style.Unit unit) {
        this.delegate.assertCanAddStyleProperty().setWidth(value, unit);
        return this;
    }

    @Override
    public StylesBuilder zIndex(int value) {
        this.delegate.assertCanAddStyleProperty().setZIndex(value);
        return this;
    }
}

