/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.transport.sshd;

import java.io.File;
import java.nio.file.Path;
import java.security.KeyPair;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshConfigStore;
import org.eclipse.jgit.transport.sshd.KeyCache;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.transport.sshd.ProxyDataFactory;
import org.eclipse.jgit.transport.sshd.ServerKeyDatabase;
import org.eclipse.jgit.transport.sshd.SshdSessionFactory;
import org.eclipse.jgit.util.StringUtils;

public final class SshdSessionFactoryBuilder {
    private final State state = new State();

    public SshdSessionFactoryBuilder setProxyDataFactory(ProxyDataFactory proxyDataFactory) {
        this.state.proxyDataFactory = proxyDataFactory;
        return this;
    }

    public SshdSessionFactoryBuilder setHomeDirectory(File homeDirectory) {
        this.state.homeDirectory = homeDirectory;
        return this;
    }

    public SshdSessionFactoryBuilder setSshDirectory(File sshDirectory) {
        this.state.sshDirectory = sshDirectory;
        return this;
    }

    public SshdSessionFactoryBuilder setPreferredAuthentications(String authentications) {
        this.state.preferredAuthentications = authentications;
        return this;
    }

    public SshdSessionFactoryBuilder setConfigFile(Function<File, File> supplier) {
        this.state.configFileFinder = supplier;
        return this;
    }

    public SshdSessionFactoryBuilder setConfigStoreFactory(ConfigStoreFactory factory) {
        this.state.configFactory = factory;
        return this;
    }

    public SshdSessionFactoryBuilder setDefaultKnownHostsFiles(Function<File, List<Path>> supplier) {
        this.state.knownHostsFileFinder = supplier;
        return this;
    }

    public SshdSessionFactoryBuilder setDefaultIdentities(Function<File, List<Path>> supplier) {
        this.state.defaultKeyFileFinder = supplier;
        return this;
    }

    public SshdSessionFactoryBuilder setDefaultKeysProvider(Function<File, Iterable<KeyPair>> provider) {
        this.state.defaultKeysProvider = provider;
        return this;
    }

    public SshdSessionFactoryBuilder setKeyPasswordProvider(Function<CredentialsProvider, KeyPasswordProvider> factory) {
        this.state.passphraseProviderFactory = factory;
        return this;
    }

    public SshdSessionFactoryBuilder setServerKeyDatabase(BiFunction<File, File, ServerKeyDatabase> factory) {
        this.state.serverKeyDatabaseCreator = factory;
        return this;
    }

    public SshdSessionFactory build(KeyCache cache) {
        return this.state.copy().build(cache);
    }

    @FunctionalInterface
    public static interface ConfigStoreFactory {
        public SshConfigStore create(@NonNull File var1, File var2, String var3);
    }

    private static class State {
        ProxyDataFactory proxyDataFactory;
        File homeDirectory;
        File sshDirectory;
        String preferredAuthentications;
        Function<File, File> configFileFinder;
        ConfigStoreFactory configFactory;
        Function<CredentialsProvider, KeyPasswordProvider> passphraseProviderFactory;
        Function<File, List<Path>> knownHostsFileFinder;
        Function<File, List<Path>> defaultKeyFileFinder;
        Function<File, Iterable<KeyPair>> defaultKeysProvider;
        BiFunction<File, File, ServerKeyDatabase> serverKeyDatabaseCreator;

        private State() {
        }

        State copy() {
            State c = new State();
            c.proxyDataFactory = this.proxyDataFactory;
            c.homeDirectory = this.homeDirectory;
            c.sshDirectory = this.sshDirectory;
            c.preferredAuthentications = this.preferredAuthentications;
            c.configFileFinder = this.configFileFinder;
            c.configFactory = this.configFactory;
            c.passphraseProviderFactory = this.passphraseProviderFactory;
            c.knownHostsFileFinder = this.knownHostsFileFinder;
            c.defaultKeyFileFinder = this.defaultKeyFileFinder;
            c.defaultKeysProvider = this.defaultKeysProvider;
            c.serverKeyDatabaseCreator = this.serverKeyDatabaseCreator;
            return c;
        }

        SshdSessionFactory build(KeyCache cache) {
            SessionFactory factory = new SessionFactory(cache, this.proxyDataFactory);
            factory.setHomeDirectory(this.homeDirectory);
            factory.setSshDirectory(this.sshDirectory);
            return factory;
        }

        private class SessionFactory
        extends SshdSessionFactory {
            public SessionFactory(KeyCache cache, ProxyDataFactory proxyDataFactory) {
                super(cache, proxyDataFactory);
            }

            @Override
            protected File getSshConfig(File sshDir) {
                if (State.this.configFileFinder != null) {
                    return State.this.configFileFinder.apply(sshDir);
                }
                return super.getSshConfig(sshDir);
            }

            @Override
            protected List<Path> getDefaultKnownHostsFiles(File sshDir) {
                if (State.this.knownHostsFileFinder != null) {
                    List<Path> result = State.this.knownHostsFileFinder.apply(sshDir);
                    return result == null ? Collections.emptyList() : result;
                }
                return super.getDefaultKnownHostsFiles(sshDir);
            }

            @Override
            protected List<Path> getDefaultIdentities(File sshDir) {
                if (State.this.defaultKeyFileFinder != null) {
                    List<Path> result = State.this.defaultKeyFileFinder.apply(sshDir);
                    return result == null ? Collections.emptyList() : result;
                }
                return super.getDefaultIdentities(sshDir);
            }

            @Override
            protected String getDefaultPreferredAuthentications() {
                if (!StringUtils.isEmptyOrNull((String)State.this.preferredAuthentications)) {
                    return State.this.preferredAuthentications;
                }
                return super.getDefaultPreferredAuthentications();
            }

            @Override
            protected Iterable<KeyPair> getDefaultKeys(File sshDir) {
                if (State.this.defaultKeysProvider != null) {
                    Iterable<KeyPair> result = State.this.defaultKeysProvider.apply(sshDir);
                    return result == null ? Collections.emptyList() : result;
                }
                return super.getDefaultKeys(sshDir);
            }

            @Override
            protected KeyPasswordProvider createKeyPasswordProvider(CredentialsProvider provider) {
                KeyPasswordProvider result;
                if (State.this.passphraseProviderFactory != null && (result = State.this.passphraseProviderFactory.apply(provider)) != null) {
                    return result;
                }
                return super.createKeyPasswordProvider(provider);
            }

            @Override
            protected ServerKeyDatabase createServerKeyDatabase(File homeDir, File sshDir) {
                ServerKeyDatabase result;
                if (State.this.serverKeyDatabaseCreator != null && (result = State.this.serverKeyDatabaseCreator.apply(homeDir, sshDir)) != null) {
                    return result;
                }
                return super.createServerKeyDatabase(homeDir, sshDir);
            }

            @Override
            protected SshConfigStore createSshConfigStore(File homeDir, File configFile, String localUserName) {
                if (State.this.configFactory != null) {
                    return State.this.configFactory.create(homeDir, configFile, localUserName);
                }
                return super.createSshConfigStore(homeDir, configFile, localUserName);
            }
        }
    }
}

