/*
 * Decompiled with CFR 0.152.
 */
package jmapps.rtp;

import com.sun.media.util.JMFI18N;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import javax.media.rtp.GlobalReceptionStats;
import javax.media.rtp.SessionManager;
import jmapps.ui.JMPanel;

public class PanelOverallRtpStats
extends JMPanel {
    private SessionManager mngrSession;
    private UpdateThread threadUpdate = null;
    private Label fieldTotalRtpPackets;
    private Label fieldTotalBytes;
    private Label fieldBadRtpPackets;
    private Label fieldLocalCollisions;
    private Label fieldRemoteCollisions;
    private Label fieldPacketsLooped;
    private Label fieldFailedTransmissions;
    private Label fieldRtcpPackets;
    private Label fieldSrPackets;
    private Label fieldBadRtcpPackets;
    private Label fieldUnknownRtcpTypes;
    private Label fieldMalformedRr;
    private Label fieldMalformedSdes;
    private Label fieldMalformedBye;
    private Label fieldMalformedSr;
    private static final String LABEL_TOTAL_PACKETS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.totalpackets");
    private static final String LABEL_TOTAL_BYTES = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.totalbytes");
    private static final String LABEL_BAD_RTP_PACKETS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.badrtppackets");
    private static final String LABEL_LOCAL_COLLISIONS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.localcollisions");
    private static final String LABEL_REMOTE_COLLISIONS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.remotecollisions");
    private static final String LABEL_PACKETS_LOOPED = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.packetslooped");
    private static final String LABEL_FAILED_TRANSMISSIONS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.failedtransmissions");
    private static final String LABEL_RTCP_PACKETS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.rtcppackets");
    private static final String LABEL_SR_PACKETS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.srpackets");
    private static final String LABEL_BAD_RTCP_PACKETS = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.badrtcppackets");
    private static final String LABEL_UNKNOWN_RTCP_TYPES = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.unknownrtcptypes");
    private static final String LABEL_MALFORMED_RR = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.malformedrr");
    private static final String LABEL_MALFORMED_SDES = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.malformedsdes");
    private static final String LABEL_MALFORMED_BYE = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.malformedbye");
    private static final String LABEL_MALFORMED_SR = JMFI18N.getResource("jmstudio.rtpsessionctrl.overall.malformedsr");

    public PanelOverallRtpStats(SessionManager mngrSession) {
        this.mngrSession = mngrSession;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.threadUpdate == null) {
            this.threadUpdate = new UpdateThread();
        }
        this.threadUpdate.start();
    }

    public void removeNotify() {
        if (this.threadUpdate != null) {
            this.threadUpdate.terminate();
            this.threadUpdate = null;
        }
        super.removeNotify();
    }

    private void init() throws Exception {
        this.setLayout(new GridLayout(1, 0, 24, 6));
        JMPanel panelColumn1 = new JMPanel(new BorderLayout(6, 6));
        this.add(panelColumn1);
        JMPanel panelColumn2 = new JMPanel(new BorderLayout(6, 6));
        this.add(panelColumn2);
        JMPanel panel = new JMPanel(new BorderLayout(6, 6));
        panelColumn1.add((Component)panel, "North");
        JMPanel panelLabels = new JMPanel(new GridLayout(0, 1, 0, 0));
        panel.add((Component)panelLabels, "West");
        JMPanel panelData = new JMPanel(new GridLayout(0, 1, 0, 0));
        panel.add((Component)panelData, "Center");
        Label label = new Label(LABEL_TOTAL_PACKETS);
        panelLabels.add(label);
        this.fieldTotalRtpPackets = new Label("000000000000");
        panelData.add(this.fieldTotalRtpPackets);
        label = new Label(LABEL_TOTAL_BYTES);
        panelLabels.add(label);
        this.fieldTotalBytes = new Label();
        panelData.add(this.fieldTotalBytes);
        label = new Label(LABEL_BAD_RTP_PACKETS);
        panelLabels.add(label);
        this.fieldBadRtpPackets = new Label();
        panelData.add(this.fieldBadRtpPackets);
        label = new Label(LABEL_LOCAL_COLLISIONS);
        panelLabels.add(label);
        this.fieldLocalCollisions = new Label();
        panelData.add(this.fieldLocalCollisions);
        label = new Label(LABEL_REMOTE_COLLISIONS);
        panelLabels.add(label);
        this.fieldRemoteCollisions = new Label();
        panelData.add(this.fieldRemoteCollisions);
        label = new Label(LABEL_PACKETS_LOOPED);
        panelLabels.add(label);
        this.fieldPacketsLooped = new Label();
        panelData.add(this.fieldPacketsLooped);
        label = new Label(LABEL_FAILED_TRANSMISSIONS);
        panelLabels.add(label);
        this.fieldFailedTransmissions = new Label();
        panelData.add(this.fieldFailedTransmissions);
        panel = new JMPanel(new BorderLayout(6, 6));
        panelColumn2.add((Component)panel, "North");
        panelLabels = new JMPanel(new GridLayout(0, 1, 0, 0));
        panel.add((Component)panelLabels, "West");
        panelData = new JMPanel(new GridLayout(0, 1, 0, 0));
        panel.add((Component)panelData, "Center");
        label = new Label(LABEL_RTCP_PACKETS);
        panelLabels.add(label);
        this.fieldRtcpPackets = new Label();
        panelData.add(this.fieldRtcpPackets);
        label = new Label(LABEL_SR_PACKETS);
        panelLabels.add(label);
        this.fieldSrPackets = new Label();
        panelData.add(this.fieldSrPackets);
        label = new Label(LABEL_BAD_RTCP_PACKETS);
        panelLabels.add(label);
        this.fieldBadRtcpPackets = new Label();
        panelData.add(this.fieldBadRtcpPackets);
        label = new Label(LABEL_UNKNOWN_RTCP_TYPES);
        panelLabels.add(label);
        this.fieldUnknownRtcpTypes = new Label();
        panelData.add(this.fieldUnknownRtcpTypes);
        label = new Label(LABEL_MALFORMED_RR);
        panelLabels.add(label);
        this.fieldMalformedRr = new Label();
        panelData.add(this.fieldMalformedRr);
        label = new Label(LABEL_MALFORMED_SDES);
        panelLabels.add(label);
        this.fieldMalformedSdes = new Label();
        panelData.add(this.fieldMalformedSdes);
        label = new Label(LABEL_MALFORMED_BYE);
        panelLabels.add(label);
        this.fieldMalformedBye = new Label();
        panelData.add(this.fieldMalformedBye);
        label = new Label(LABEL_MALFORMED_SR);
        panelLabels.add(label);
        this.fieldMalformedSr = new Label();
        panelData.add(this.fieldMalformedSr);
        this.updateFields();
    }

    private void updateFields() {
        GlobalReceptionStats stats = this.mngrSession.getGlobalReceptionStats();
        this.fieldTotalRtpPackets.setText("" + stats.getPacketsRecd());
        this.fieldTotalBytes.setText("" + stats.getBytesRecd());
        this.fieldBadRtpPackets.setText("" + stats.getBadRTPkts());
        this.fieldLocalCollisions.setText("" + stats.getLocalColls());
        this.fieldRemoteCollisions.setText("" + stats.getRemoteColls());
        this.fieldPacketsLooped.setText("" + stats.getPacketsLooped());
        this.fieldFailedTransmissions.setText("" + stats.getTransmitFailed());
        this.fieldRtcpPackets.setText("" + stats.getRTCPRecd());
        this.fieldSrPackets.setText("" + stats.getSRRecd());
        this.fieldBadRtcpPackets.setText("" + stats.getBadRTCPPkts());
        this.fieldUnknownRtcpTypes.setText("" + stats.getUnknownTypes());
        this.fieldMalformedRr.setText("" + stats.getMalformedRR());
        this.fieldMalformedSdes.setText("" + stats.getMalformedSDES());
        this.fieldMalformedBye.setText("" + stats.getMalformedBye());
        this.fieldMalformedSr.setText("" + stats.getMalformedSR());
    }

    private class UpdateThread
    extends Thread {
        private boolean boolTerminate = false;

        public void terminate() {
            this.boolTerminate = true;
        }

        public void run() {
            while (!this.boolTerminate) {
                try {
                    Thread.sleep(1000L);
                    PanelOverallRtpStats.this.updateFields();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

