/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.html;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.owasp.html.HtmlEntities;
import org.owasp.html.TCB;

final class Encoding {
    private static final char[] HEX_NUMERAL;
    static final String[] REPLACEMENTS;
    private static boolean[] IS_BANNED_ASCII;

    Encoding() {
    }

    @VisibleForTesting
    static String decodeHtml(String s) {
        int safeLimit;
        int firstAmp = s.indexOf(38);
        if ((firstAmp & (safeLimit = Encoding.longestPrefixOfGoodCodeunits(s))) < 0) {
            return s;
        }
        int n = s.length();
        StringBuilder sb = new StringBuilder(n);
        int pos = 0;
        int amp = firstAmp;
        while (amp >= 0) {
            long endAndCodepoint = HtmlEntities.decodeEntityAt(s, amp, n);
            int end = (int)(endAndCodepoint >>> 32);
            int codepoint = (int)endAndCodepoint;
            sb.append(s, pos, amp).appendCodePoint(codepoint);
            pos = end;
            amp = s.indexOf(38, end);
        }
        sb.append(s, pos, n);
        Encoding.stripBannedCodeunits(sb, firstAmp < 0 ? safeLimit : (safeLimit < 0 ? firstAmp : Math.min(firstAmp, safeLimit)));
        return sb.toString();
    }

    @TCB
    static String stripBannedCodeunits(String s) {
        int safeLimit = Encoding.longestPrefixOfGoodCodeunits(s);
        if (safeLimit < 0) {
            return s;
        }
        StringBuilder sb = new StringBuilder(s);
        Encoding.stripBannedCodeunits(sb, safeLimit);
        return sb.toString();
    }

    @TCB
    static void stripBannedCodeunits(StringBuilder sb) {
        Encoding.stripBannedCodeunits(sb, 0);
    }

    @TCB
    private static void stripBannedCodeunits(StringBuilder sb, int start) {
        int k = start;
        int n = sb.length();
        for (int i = start; i < n; ++i) {
            char ch = sb.charAt(i);
            if (ch < ' ') {
                if (IS_BANNED_ASCII[ch]) {
                    continue;
                }
            } else if ('\ud800' <= ch) {
                if (ch <= '\udfff') {
                    char next;
                    if (i + 1 >= n || !Character.isSurrogatePair(ch, next = sb.charAt(i + 1))) continue;
                    sb.setCharAt(k++, ch);
                    sb.setCharAt(k++, next);
                    ++i;
                    continue;
                }
                if ((ch & 0xFFFE) == 65534) continue;
            }
            sb.setCharAt(k++, ch);
        }
        sb.setLength(k);
    }

    @TCB
    private static int longestPrefixOfGoodCodeunits(String s) {
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char ch = s.charAt(i);
            if (ch < ' ') {
                if (!IS_BANNED_ASCII[ch]) continue;
                return i;
            }
            if ('\ud800' > ch) continue;
            if (ch <= '\udfff') {
                if (i + 1 < n && Character.isSurrogatePair(ch, s.charAt(i + 1))) {
                    ++i;
                    continue;
                }
                return i;
            }
            if ((ch & 0xFFFE) != 65534) continue;
            return i;
        }
        return -1;
    }

    @TCB
    static void encodeHtmlOnto(String plainText, Appendable output) throws IOException {
        int n = plainText.length();
        int pos = 0;
        for (int i = 0; i < n; ++i) {
            char ch = plainText.charAt(i);
            if (ch < REPLACEMENTS.length) {
                String repl = REPLACEMENTS[ch];
                if (repl == null) continue;
                output.append(plainText, pos, i).append(repl);
                pos = i + 1;
                continue;
            }
            if ('\ud800' > ch) continue;
            if (ch <= '\udfff') {
                char next;
                if (i + 1 < n && Character.isSurrogatePair(ch, next = plainText.charAt(i + 1))) {
                    int codepoint = Character.toCodePoint(ch, next);
                    output.append(plainText, pos, i);
                    Encoding.appendNumericEntity(codepoint, output);
                    pos = ++i + 1;
                    continue;
                }
                output.append(plainText, pos, i);
                pos = i + 1;
                continue;
            }
            if ('\uff00' > ch) continue;
            output.append(plainText, pos, i);
            pos = i + 1;
            if ((ch & 0xFFFE) == 65534) continue;
            Encoding.appendNumericEntity(ch, output);
        }
        output.append(plainText, pos, n);
    }

    @TCB
    static void appendNumericEntity(int codepoint, Appendable output) throws IOException {
        if (codepoint < 100) {
            output.append("&#");
            if (codepoint < 10) {
                output.append((char)(48 + codepoint));
            } else {
                output.append((char)(48 + codepoint / 10));
                output.append((char)(48 + codepoint % 10));
            }
            output.append(";");
        } else {
            int nDigits = codepoint < 4096 ? (codepoint < 256 ? 2 : 3) : (codepoint < 65536 ? 4 : (codepoint < 0x100000 ? 5 : 6));
            output.append("&#x");
            int digit = nDigits;
            while (--digit >= 0) {
                int hexDigit = codepoint >>> (digit << 2) & 0xF;
                output.append(HEX_NUMERAL[hexDigit]);
            }
            output.append(";");
        }
    }

    static {
        int i;
        HEX_NUMERAL = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        REPLACEMENTS = new String[97];
        for (i = 0; i < 32; ++i) {
            if (i == 9 || i == 10 || i == 13) continue;
            Encoding.REPLACEMENTS[i] = "";
        }
        Encoding.REPLACEMENTS[34] = "&#34;";
        Encoding.REPLACEMENTS[38] = "&amp;";
        Encoding.REPLACEMENTS[39] = "&#39;";
        Encoding.REPLACEMENTS[43] = "&#43;";
        Encoding.REPLACEMENTS[60] = "&lt;";
        Encoding.REPLACEMENTS[61] = "&#61;";
        Encoding.REPLACEMENTS[62] = "&gt;";
        Encoding.REPLACEMENTS[64] = "&#64;";
        Encoding.REPLACEMENTS[96] = "&#96;";
        IS_BANNED_ASCII = new boolean[32];
        for (i = 0; i < IS_BANNED_ASCII.length; ++i) {
            Encoding.IS_BANNED_ASCII[i] = i != 9 && i != 10 && i != 13;
        }
    }
}

