/*
 * Decompiled with CFR 0.152.
 */
package org.diylc.swing.gui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import org.apache.log4j.Logger;
import org.diylc.common.PropertyWrapper;
import org.diylc.core.measures.AbstractMeasure;
import org.diylc.swing.gui.editor.BooleanEditor;
import org.diylc.swing.gui.editor.ByteEditor;
import org.diylc.swing.gui.editor.ColorEditor;
import org.diylc.swing.gui.editor.EnumEditor;
import org.diylc.swing.gui.editor.FontEditor;
import org.diylc.swing.gui.editor.ImageEditor;
import org.diylc.swing.gui.editor.IntEditor;
import org.diylc.swing.gui.editor.MeasureEditor;
import org.diylc.swing.gui.editor.StringEditor;

public class FieldEditorFactory {
    private static final Logger LOG = Logger.getLogger(FieldEditorFactory.class);

    public static Component createFieldEditor(PropertyWrapper propertyWrapper) {
        if (propertyWrapper.getType().equals(String.class)) {
            StringEditor stringEditor = new StringEditor(propertyWrapper);
            return stringEditor;
        }
        if (propertyWrapper.getType().equals(Color.class)) {
            ColorEditor colorEditor = new ColorEditor(propertyWrapper);
            return colorEditor;
        }
        if (AbstractMeasure.class.isAssignableFrom(propertyWrapper.getType())) {
            MeasureEditor measureEditor = new MeasureEditor(propertyWrapper);
            return measureEditor;
        }
        if (ImageIcon.class.isAssignableFrom(propertyWrapper.getType())) {
            ImageEditor imageEditor = new ImageEditor(propertyWrapper);
            return imageEditor;
        }
        if (propertyWrapper.getType().isEnum()) {
            EnumEditor enumEditor = new EnumEditor(propertyWrapper);
            return enumEditor;
        }
        if (Byte.class.isAssignableFrom(propertyWrapper.getType()) || Byte.TYPE.isAssignableFrom(propertyWrapper.getType())) {
            ByteEditor byteEditor = new ByteEditor(propertyWrapper);
            return byteEditor;
        }
        if (Boolean.class.isAssignableFrom(propertyWrapper.getType()) || Boolean.TYPE.isAssignableFrom(propertyWrapper.getType())) {
            BooleanEditor booleanEditor = new BooleanEditor(propertyWrapper);
            return booleanEditor;
        }
        if (Font.class.isAssignableFrom(propertyWrapper.getType())) {
            FontEditor fontEditor = new FontEditor(propertyWrapper);
            return fontEditor;
        }
        if (Integer.class.isAssignableFrom(propertyWrapper.getType()) || Integer.TYPE.isAssignableFrom(propertyWrapper.getType())) {
            IntEditor intEditor = new IntEditor(propertyWrapper);
            return intEditor;
        }
        LOG.error((Object)("Unrecognized parameter type: " + propertyWrapper.getType().getName()));
        return new JLabel("Unrecognized");
    }
}

