/*  =========================================================================
    zhttp_server_options - zhttp server.

    Copyright (c) the Contributors as noted in the AUTHORS file.
    This file is part of CZMQ, the high-level C binding for 0MQ:
    http://czmq.zeromq.org.

    This Source Code Form is subject to the terms of the Mozilla Public
    License, v. 2.0. If a copy of the MPL was not distributed with this
    file, You can obtain one at http://mozilla.org/MPL/2.0/.
    =========================================================================
*/

#ifndef ZHTTP_SERVER_OPTIONS_H_INCLUDED
#define ZHTTP_SERVER_OPTIONS_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

//  @warning THE FOLLOWING @INTERFACE BLOCK IS AUTO-GENERATED BY ZPROJECT
//  @warning Please edit the model at "api/zhttp_server_options.api" to make changes.
//  @interface
//  This is a draft class, and may change without notice. It is disabled in
//  stable builds by default. If you use this in applications, please ask
//  for it to be pushed to stable state. Use --enable-drafts to enable.
#ifdef CZMQ_BUILD_DRAFT_API
//  *** Draft method, for development use, may change without warning ***
//  Create a new zhttp_server_options.
CZMQ_EXPORT zhttp_server_options_t *
    zhttp_server_options_new (void);

//  *** Draft method, for development use, may change without warning ***
//  Create options from config tree.
CZMQ_EXPORT zhttp_server_options_t *
    zhttp_server_options_from_config (zconfig_t *config);

//  *** Draft method, for development use, may change without warning ***
//  Destroy the zhttp_server_options.
CZMQ_EXPORT void
    zhttp_server_options_destroy (zhttp_server_options_t **self_p);

//  *** Draft method, for development use, may change without warning ***
//  Get the server listening port.
CZMQ_EXPORT int
    zhttp_server_options_port (zhttp_server_options_t *self);

//  *** Draft method, for development use, may change without warning ***
//  Set the server listening port
CZMQ_EXPORT void
    zhttp_server_options_set_port (zhttp_server_options_t *self, int port);

//  *** Draft method, for development use, may change without warning ***
//  Get the address sockets should connect to in order to receive requests.
CZMQ_EXPORT const char *
    zhttp_server_options_backend_address (zhttp_server_options_t *self);

//  *** Draft method, for development use, may change without warning ***
//  Set the address sockets should connect to in order to receive requests.
CZMQ_EXPORT void
    zhttp_server_options_set_backend_address (zhttp_server_options_t *self, const char *address);

//  *** Draft method, for development use, may change without warning ***
//  Self test of this class.
CZMQ_EXPORT void
    zhttp_server_options_test (bool verbose);

#endif // CZMQ_BUILD_DRAFT_API
//  @end

#ifdef __cplusplus
}
#endif

#endif
