#!/usr/bin/python

# Find out when GNU Make debug messages like "Live child" started
# appearing in build logs

# 2014.04.18.06.23.32 pass
# 2016.07.22.07.13.56 fail

from __future__ import print_function

import re
from bracket import *

def gmake_debug(ts):
    fn = os.path.join(test_dir(ts), 'build.log')
    f = open(fn, "r")
    matches = 0
    for line in f:
        if re.search(r'Live child', line):
            matches += 1
    f.close()
    print(matches, "matches")
    return matches < 100
    
find_failure(rcs2ts('2014.04.18.06.23.32'),
             rcs2ts('2016.07.22.07.13.56'),
             TestOp(gmake_debug,
                    [build_op],
                    name = 'gmake_debug'),
             confirm = False)
