/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cache;

import com.codahale.metrics.Timer;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.github.benmanes.caffeine.cache.RemovalListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.MoreExecutors;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.cassandra.cache.CacheSize;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.sstable.CorruptSSTableException;
import org.apache.cassandra.io.util.ChannelProxy;
import org.apache.cassandra.io.util.ChunkReader;
import org.apache.cassandra.io.util.FileHandle;
import org.apache.cassandra.io.util.Rebufferer;
import org.apache.cassandra.io.util.RebuffererFactory;
import org.apache.cassandra.metrics.CacheMissMetrics;
import org.apache.cassandra.utils.memory.BufferPool;

public class ChunkCache
implements CacheLoader<Key, Buffer>,
RemovalListener<Key, Buffer>,
CacheSize {
    public static final int RESERVED_POOL_SPACE_IN_MB = 32;
    public static final long cacheSize = 0x100000L * (long)Math.max(0, DatabaseDescriptor.getFileCacheSizeInMB() - 32);
    public static final boolean roundUp = DatabaseDescriptor.getFileCacheRoundUp();
    private static boolean enabled = cacheSize > 0L;
    public static final ChunkCache instance = enabled ? new ChunkCache() : null;
    private final LoadingCache<Key, Buffer> cache = Caffeine.newBuilder().maximumWeight(cacheSize).executor(MoreExecutors.directExecutor()).weigher((key, buffer) -> ((Buffer)buffer).buffer.capacity()).removalListener((RemovalListener)this).build((CacheLoader)this);
    public final CacheMissMetrics metrics = new CacheMissMetrics("ChunkCache", this);

    public Buffer load(Key key) throws Exception {
        ChunkReader rebufferer = key.file;
        this.metrics.misses.mark();
        try (Timer.Context ctx = this.metrics.missLatency.time();){
            ByteBuffer buffer = BufferPool.get(key.file.chunkSize(), key.file.preferredBufferType());
            assert (buffer != null);
            rebufferer.readChunk(key.position, buffer);
            Buffer buffer2 = new Buffer(buffer, key.position);
            return buffer2;
        }
    }

    public void onRemoval(Key key, Buffer buffer, RemovalCause cause) {
        buffer.release();
    }

    public void close() {
        this.cache.invalidateAll();
    }

    public RebuffererFactory wrap(ChunkReader file) {
        return new CachingRebufferer(file);
    }

    public static RebuffererFactory maybeWrap(ChunkReader file) {
        if (!enabled) {
            return file;
        }
        return instance.wrap(file);
    }

    public void invalidatePosition(FileHandle dfile, long position) {
        if (!(dfile.rebuffererFactory() instanceof CachingRebufferer)) {
            return;
        }
        ((CachingRebufferer)dfile.rebuffererFactory()).invalidate(position);
    }

    public void invalidateFile(String fileName) {
        this.cache.invalidateAll(Iterables.filter(this.cache.asMap().keySet(), x -> x.path.equals(fileName)));
    }

    @VisibleForTesting
    public void enable(boolean enabled) {
        ChunkCache.enabled = enabled;
        this.cache.invalidateAll();
        this.metrics.reset();
    }

    @Override
    public long capacity() {
        return cacheSize;
    }

    @Override
    public void setCapacity(long capacity) {
        throw new UnsupportedOperationException("Chunk cache size cannot be changed.");
    }

    @Override
    public int size() {
        return this.cache.asMap().size();
    }

    @Override
    public long weightedSize() {
        return this.cache.policy().eviction().map(policy -> policy.weightedSize().orElseGet(() -> this.cache.estimatedSize())).orElseGet(() -> this.cache.estimatedSize());
    }

    class CachingRebufferer
    implements Rebufferer,
    RebuffererFactory {
        private final ChunkReader source;
        final long alignmentMask;

        public CachingRebufferer(ChunkReader file) {
            this.source = file;
            int chunkSize = file.chunkSize();
            assert (Integer.bitCount(chunkSize) == 1) : String.format("%d must be a power of two", chunkSize);
            this.alignmentMask = -chunkSize;
        }

        @Override
        public Buffer rebuffer(long position) {
            try {
                Buffer buf;
                ChunkCache.this.metrics.requests.mark();
                long pageAlignedPos = position & this.alignmentMask;
                while ((buf = ((Buffer)ChunkCache.this.cache.get((Object)new Key(this.source, pageAlignedPos))).reference()) == null) {
                }
                return buf;
            }
            catch (Throwable t) {
                Throwables.propagateIfInstanceOf((Throwable)t.getCause(), CorruptSSTableException.class);
                throw Throwables.propagate((Throwable)t);
            }
        }

        public void invalidate(long position) {
            long pageAlignedPos = position & this.alignmentMask;
            ChunkCache.this.cache.invalidate((Object)new Key(this.source, pageAlignedPos));
        }

        @Override
        public Rebufferer instantiateRebufferer() {
            return this;
        }

        @Override
        public void close() {
            this.source.close();
        }

        @Override
        public void closeReader() {
        }

        @Override
        public ChannelProxy channel() {
            return this.source.channel();
        }

        @Override
        public long fileLength() {
            return this.source.fileLength();
        }

        @Override
        public double getCrcCheckChance() {
            return this.source.getCrcCheckChance();
        }

        public String toString() {
            return "CachingRebufferer:" + this.source.toString();
        }
    }

    static class Buffer
    implements Rebufferer.BufferHolder {
        private final ByteBuffer buffer;
        private final long offset;
        private final AtomicInteger references;

        public Buffer(ByteBuffer buffer, long offset) {
            this.buffer = buffer;
            this.offset = offset;
            this.references = new AtomicInteger(1);
        }

        Buffer reference() {
            int refCount;
            do {
                if ((refCount = this.references.get()) != 0) continue;
                return null;
            } while (!this.references.compareAndSet(refCount, refCount + 1));
            return this;
        }

        @Override
        public ByteBuffer buffer() {
            assert (this.references.get() > 0);
            return this.buffer.duplicate();
        }

        @Override
        public long offset() {
            return this.offset;
        }

        @Override
        public void release() {
            if (this.references.decrementAndGet() == 0) {
                BufferPool.put(this.buffer);
            }
        }
    }

    static class Key {
        final ChunkReader file;
        final String path;
        final long position;

        public Key(ChunkReader file, long position) {
            this.file = file;
            this.position = position;
            this.path = file.channel().filePath();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.path.hashCode();
            result = 31 * result + this.file.getClass().hashCode();
            result = 31 * result + Long.hashCode(this.position);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            Key other = (Key)obj;
            return this.position == other.position && this.file.getClass() == other.file.getClass() && this.path.equals(other.path);
        }
    }
}

