/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sitraka;

import java.util.Vector;
import org.apache.tools.ant.taskdefs.optional.sitraka.StringUtil;
import org.apache.tools.ant.util.regexp.RegexpMatcher;
import org.apache.tools.ant.util.regexp.RegexpMatcherFactory;

public class ReportFilters {
    protected Vector filters = new Vector();
    protected Vector matchers = null;

    public void addInclude(Include incl) {
        this.filters.addElement(incl);
    }

    public void addExclude(Exclude excl) {
        this.filters.addElement(excl);
    }

    public int size() {
        return this.filters.size();
    }

    public boolean accept(String methodname) {
        if (this.matchers == null) {
            this.createMatchers();
        }
        boolean result = false;
        int size = this.filters.size();
        for (int i = 0; i < size; ++i) {
            FilterElement filter = (FilterElement)this.filters.elementAt(i);
            RegexpMatcher matcher = (RegexpMatcher)this.matchers.elementAt(i);
            if (filter instanceof Include) {
                result = result || matcher.matches(methodname);
                continue;
            }
            if (filter instanceof Exclude) {
                result = result && !matcher.matches(methodname);
                continue;
            }
            throw new IllegalArgumentException("Invalid filter element: " + filter.getClass().getName());
        }
        return result;
    }

    protected void createMatchers() {
        RegexpMatcherFactory factory = new RegexpMatcherFactory();
        int size = this.filters.size();
        this.matchers = new Vector();
        for (int i = 0; i < size; ++i) {
            FilterElement filter = (FilterElement)this.filters.elementAt(i);
            RegexpMatcher matcher = factory.newRegexpMatcher();
            String pattern = filter.getAsPattern();
            matcher.setPattern(pattern);
            this.matchers.addElement(matcher);
        }
    }

    public static class Exclude
    extends FilterElement {
    }

    public static class Include
    extends FilterElement {
    }

    public static abstract class FilterElement {
        protected String clazz = "*";
        protected String method = "*";

        public void setClass(String value) {
            this.clazz = value;
        }

        public void setMethod(String value) {
            this.method = value;
        }

        public String getAsPattern() {
            StringBuffer buf = new StringBuffer(this.toString());
            StringUtil.replace(buf, ".", "\\.");
            StringUtil.replace(buf, "*", ".*");
            StringUtil.replace(buf, "(", "\\(");
            StringUtil.replace(buf, ")", "\\)");
            return buf.toString();
        }

        public String toString() {
            return this.clazz + "." + this.method + "()";
        }
    }
}

