#!/usr/pkg/bin/python3.10

#Copyright (C) 2008 Luar Roji

#This program is free software; you can redistribute it and/or
#modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation; either version 2
#of the License, or (at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program; if not, write to the Free Software
#Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#
#For full license view COPYRIGHT file or go to:
#http://www.fsf.org/licensing/licenses/info/GPLv2.html

from datetime import *
import sys

print "CenterIM Log2HTML - $Rev: 25$"
print "Luar Roji - http://roji.net\n"

def usage():
    print "Usage: " + sys.argv[0] + " [logFileName] {outFileName}"
    print ""
    print " If outFileName is not specified, logFileName+.html is assumed."
    print ""
    sys.exit()

def getLine(f):
    s = f.readline()
    s = s.rstrip('\n\r')
    return s

def out(s):
    outfile.write(s + "\n")
#    print s

def outtd(msg, field):
    data = msg[field]
    if (field=="timestamp1" or field=="timestamp2"):
        if (data!=""):
            floatData = float(data)
            dateTimeObj = datetime.fromtimestamp(floatData)
            data = dateTimeObj.strftime(DATEFORMAT)
    out("    <td class=\""+field+"\">"+data+"</td>")

msglist = []
x=0

DATEFORMAT = "%d/%b/%Y %H:%M:%S"
now = datetime.now().strftime(DATEFORMAT)
HTMLHEADER = "<html>\n" + \
             " <head>\n" + \
             "  <title>CenterIM Conversation</title>\n" + \
             "  <style type=\"text/css\">\n" + \
             "   tr.imparOUT   { background-color: #BAF0FA; }\n" + \
             "   tr.parOUT     { background-color: #F0BAFA; }\n" + \
             "   tr.imparIN    { background-color: #BAF000; }\n" + \
             "   tr.parIN      { background-color: #F0BA00; }\n" + \
             "   td.timestamp1 { width:11%; font-size: 80%; }\n" + \
             "  </style>\n" + \
             " </head>\n" + \
             " <!-- Generated by $Id$ on " +now+ " -->\n" + \
             " <body>\n" + \
             "  <table border=\"1\">"

HTMLFOOTER = "  </table>\n" + \
             " </body>\n" + \
             "</html>\n"

if len(sys.argv)<2: 
    usage()

infilename  = sys.argv[1]
if len(sys.argv)>2:
    outfilename = sys.argv[2]
else:
    outfilename = infilename + ".html"
    
print "Opening input file..",
infile  = open(infilename,"r")
print "Ok"
print "Opening output file..",
outfile = open(outfilename,"w")
print "Ok"

print "Processing..."
lineCount = 0
while infile:
    s = infile.readline()
    lineCount = lineCount+1
    if (lineCount%500==0):
        print str(lineCount) + " lines readed"
    if (len(s)==0):
        break;
    if (s=="\x0c\n"):
        msg = {'direction'  : getLine(infile),
               'type'       : getLine(infile),
               'timestamp1' : getLine(infile),
               'timestamp2' : getLine(infile),
               'message'    : getLine(infile)}
    msglist.append(msg)    

print "File reading done. " + str(lineCount) +" lines readed."
print "Generating HTML output..",
    
out(HTMLHEADER)
for msg in msglist:
    if (msg["type"]!="MSG"):
        continue
    x=x+1
    if (x%2==0):
        trClass = "par"
    else:
        trClass = "impar"
    
    out("   <tr class=\""+trClass+msg["direction"]+"\">")
    outtd(msg,"timestamp1")
#    outtd(msg,"timestamp2") -- Don't understand the difference between those
    outtd(msg,"direction")
#    outtd(msg,"type") -- Redundant with the above if
    outtd(msg,"message")
    out("   </tr>")

out(HTMLFOOTER)
print "Done."

infile.close()
outfile.close()
