/*
 * Decompiled with CFR 0.152.
 */
package cycinf.ui;

import cycinf.cvars.Cvar;
import cycinf.cvars.Decision;
import cycinf.infstats.DirInfstats;
import cycinf.reasoning.RConstraint;
import cycinf.reasoning.RLocationNode;
import cycinf.ui.GlobalSelectionListener;
import cycinf.ui.ReasoningView;
import cycinf.ui.UIUtils;
import java.util.Observer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.ViewPart;

public class ReasoningView
extends ViewPart {
    public static final String PART_ID = "cycinf.ReasoningView";
    Decision mainDecision;
    Composite viewArea;
    private Layout viewAreaLayout;
    private Label label;
    TreeViewer reasoningViewer;
    private Observer infstatsObserver = new /* Unavailable Anonymous Inner Class!! */;

    void doRevealSomething() {
        ISelection selection = this.reasoningViewer.getSelection();
        GlobalSelectionListener.fireSelection((IWorkbenchPage)this.getSite().getPage(), (ISelection)selection);
        if (!selection.isEmpty()) {
            ReasoningNode n = (ReasoningNode)((IStructuredSelection)selection).getFirstElement();
            if (n instanceof DecisionNode) {
                UIUtils.revealDecision((Decision)((DecisionNode)n).decision);
            } else if (n instanceof ConstraintNode) {
                ConstraintNode n2 = (ConstraintNode)n;
                RLocationNode ln = n2.constraint.getLocationNode();
                if (ln == null) {
                    ln = ((RConstraint)n2.constraint.findConstraintTop().getNode()).getLocationNode();
                }
                if (ln != null) {
                    UIUtils.revealRLocationNode((RLocationNode)ln);
                }
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.viewArea = parent;
        this.viewAreaLayout = new FormLayout();
        this.viewArea.setLayout(this.viewAreaLayout);
        this.reasoningViewer = new TreeViewer(parent, 770);
        this.reasoningViewer.setContentProvider((IContentProvider)new ViewContentProvider(this));
        this.reasoningViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider(this));
        this.reasoningViewer.setAutoExpandLevel(5);
        this.label = new Label(this.viewArea, 16448);
        this.setMainDecision(null);
        FormData lbd = new FormData();
        lbd.top = new FormAttachment(0, 2);
        lbd.left = new FormAttachment(0, 2);
        lbd.right = new FormAttachment(100, -2);
        this.label.setLayoutData((Object)lbd);
        FormData ifd = new FormData();
        ifd.top = new FormAttachment((Control)this.label, 2);
        ifd.bottom = new FormAttachment(100, -2);
        ifd.left = new FormAttachment(0, 2);
        ifd.right = new FormAttachment(100, -2);
        this.reasoningViewer.getControl().setLayoutData((Object)ifd);
        this.reasoningViewer.addSelectionChangedListener((ISelectionChangedListener)new /* Unavailable Anonymous Inner Class!! */);
        this.getSite().setSelectionProvider((ISelectionProvider)this.reasoningViewer);
        UIUtils.register((ReasoningView)this);
    }

    void setMainDecision(Decision d) {
        if (this.mainDecision != null) {
            this.mainDecision.getOwningInfstats().getDir().deleteObserver(this.infstatsObserver);
        }
        this.reasoningViewer.setInput((Object)d);
        if (d == null) {
            this.label.setText("Empty.  Double-click a decision.");
        } else {
            this.label.setText("Reasoning behind " + d.getCvar().prettyString());
        }
        this.viewArea.layout();
        if (this.mainDecision != null) {
            this.mainDecision.getOwningInfstats().getDir().addObserver(this.infstatsObserver);
        }
    }

    void refresh() {
        Cvar cvar = this.mainDecision.getCvar();
        DirInfstats newInfstats = this.mainDecision.getOwningInfstats().getDir().getCurInfstats();
        if (newInfstats == null) {
            this.setMainDecision(null);
        } else {
            Decision newDecision = newInfstats.getDecisionOnCvar(cvar);
            this.setMainDecision(newDecision);
        }
    }

    public void setFocus() {
        this.reasoningViewer.getControl().setFocus();
    }

    public void dispose() {
        super.dispose();
        UIUtils.unregister((ReasoningView)this);
    }
}

