/*
 * Decompiled with CFR 0.152.
 */
package cycinf.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GlobalSelectionListener<T>
implements ISelectionListener,
ISelectionChangedListener {
    static Set<GlobalSelectionListener<?>> listeners = new HashSet();
    IWorkbenchPart myPart;

    public static void fireSelection(IWorkbenchPage page, ISelection selection) {
        for (GlobalSelectionListener l : listeners) {
            if (l.myPart.getSite().getPage() != page) continue;
            l.processSelection(selection);
        }
    }

    public GlobalSelectionListener(IWorkbenchPart myPart) {
        this.myPart = myPart;
        listeners.add(this);
        this.applyGlobalSelectionNow();
    }

    public void unregister() {
        listeners.remove(this);
    }

    public void applyGlobalSelectionNow() {
        IWorkbenchPage page = this.myPart.getSite().getPage();
        this.selectionChanged(page.getActivePart(), page.getSelection());
    }

    public void processSelection(ISelection selection) {
        if (selection != null && selection instanceof IStructuredSelection) {
            IStructuredSelection globalSelection2 = (IStructuredSelection)selection;
            List objects = globalSelection2.toList();
            ArrayList<Object> wants = new ArrayList<Object>();
            for (Object o : objects) {
                Object want = this.wantObject(o);
                if (want == null) continue;
                wants.add(want);
            }
            if (!wants.isEmpty()) {
                this.selectObjects(Collections.unmodifiableList(wants));
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection globalSelection) {
        if (part != this.myPart) {
            this.processSelection(globalSelection);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.processSelection(event.getSelection());
    }

    protected abstract T wantObject(Object var1);

    protected abstract void selectObjects(List<T> var1);
}

