/*
 * Decompiled with CFR 0.152.
 */
package cycinf.cvars.usedtype;

import cycinf.cvars.usedtype.UsedTypeLayer;
import cycinf.cvars.usedtype.UsedTypeList;
import cycinf.util.ParseException;
import cycinf.util.ParsingUtils;
import general.util.Validator;
import java.text.MessageFormat;

public class FunctionArgumentList
extends UsedTypeList {
    private final UsedTypeLayer function;
    private static final String l1 = "_ARG";
    private static final MessageFormat prettyFormat = new MessageFormat("arg. #{0} to {1}");

    public final UsedTypeLayer getFunction() {
        return this.function;
    }

    public FunctionArgumentList(UsedTypeLayer function) {
        this.function = (UsedTypeLayer)Validator.nonnull((Object)function, (String)"function");
    }

    public final String fieldLocatorStringBase() {
        return String.valueOf(this.getFunction().toString()) + l1;
    }

    public final String prettyStringForVariable(int index) {
        return prettyFormat.format(new Object[]{index + 1, this.getFunction().prettyString()});
    }

    public static final FunctionArgumentList parseBase1(String x) throws ParseException {
        String functionStr = ParsingUtils.chopSuffix((String)x, (String)l1);
        if (functionStr == null) {
            return null;
        }
        UsedTypeLayer function = UsedTypeLayer.parse((String)functionStr);
        return new FunctionArgumentList(function);
    }
}

