/*
 * Decompiled with CFR 0.152.
 */
package cycinf.constraints;

import cycinf.constraints.ComparisonOperator;
import cycinf.constraints.CvalueExpression;
import cycinf.constraints.Guard;
import cycinf.infstats.DirInfstats;
import cycinf.util.ParseException;
import cycinf.util.ParsePosition;
import cycinf.util.ParsingUtils;
import cycinf.util.SourceLocation;
import general.util.Validator;

public class ComparisonGuard
extends Guard {
    private final ComparisonOperator operator;
    private final CvalueExpression value1;
    private final CvalueExpression value2;

    public final ComparisonOperator getOperator() {
        return this.operator;
    }

    public final CvalueExpression getValue1() {
        return this.value1;
    }

    public final CvalueExpression getValue2() {
        return this.value2;
    }

    public ComparisonGuard(SourceLocation loc, ComparisonOperator operator, CvalueExpression value1, CvalueExpression value2) {
        super(loc);
        this.operator = (ComparisonOperator)Validator.nonnull((Object)operator, (String)"operator");
        this.value1 = (CvalueExpression)Validator.nonnull((Object)value1, (String)"value1");
        this.value2 = (CvalueExpression)Validator.nonnull((Object)value2, (String)"value2");
    }

    public static final ComparisonGuard parse1(String s, ParsePosition used, SourceLocation loc) throws ParseException {
        used.setIndex(0);
        String s1 = ParsingUtils.chopPrefix((String)s, (String)"^(");
        if (s1 == null) {
            return null;
        }
        used.advance(2);
        ComparisonOperator op = null;
        String s2eq = ParsingUtils.chopPrefix((String)s1, (String)"=,");
        if (s2eq == null) {
            throw new ParseException("Badly operator-ed ComparisonGuard");
        }
        op = ComparisonOperator.EQUAL;
        used.advance(2);
        ParsePosition v1used = new ParsePosition();
        CvalueExpression val1 = CvalueExpression.parse((String)s2eq, (ParsePosition)v1used);
        String s3 = s2eq.substring(v1used.getIndex());
        used.advance(v1used.getIndex());
        String s4 = ParsingUtils.chopPrefix((String)s3, (String)",");
        if (s4 == null) {
            throw new ParseException("Badly comma-ed ComparisonGuard: " + s);
        }
        used.advance(1);
        ParsePosition v2used = new ParsePosition();
        CvalueExpression val2 = CvalueExpression.parse((String)s4, (ParsePosition)v2used);
        String s5 = s4.substring(v2used.getIndex());
        used.advance(v2used.getIndex());
        String s6 = ParsingUtils.chopPrefix((String)s5, (String)")");
        if (s6 == null) {
            throw new ParseException("Badly parenthesized ComparisonGuard: " + s);
        }
        used.advance(1);
        return new ComparisonGuard(loc, op, val1, val2);
    }

    public String toString1() {
        return "^(" + this.getOperator().symbol + "," + this.getValue1().toString() + "," + this.getValue2().toString() + ")";
    }

    public boolean evaluate(DirInfstats reference) {
        return this.operator.evaluate(this.getValue1().evaluate(reference), this.getValue2().evaluate(reference));
    }
}

