/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.filtermanager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.StringTokenizer;
import uk.org.iscream.cms.server.componentmanager.ComponentCORBAException;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.ConfigurationManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.filter.FilterHelper;
import uk.org.iscream.cms.server.filter.FilterOperations;
import uk.org.iscream.cms.server.util.FormatName;

class HostInit
extends Thread {
    public final String REVISION = "$Revision: 1.28 $";
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private ConfigurationManager _configManager = ReferenceManager.getInstance().getCM();
    private String _name = "FilterManager";
    private Socket _socket;
    private BufferedReader _socketIn;
    private PrintWriter _socketOut;

    public HostInit(Socket socket) throws IOException {
        this.setName("filtermanager.HostInit");
        this._socket = socket;
        this._socketIn = new BufferedReader(new InputStreamReader(this._socket.getInputStream()));
        this._socketOut = new PrintWriter(this._socket.getOutputStream(), true);
        this._logger.write(this.toString(), 4, "created");
    }

    public void run() {
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        String string = "Host." + this._socket.getInetAddress().getHostName().toLowerCase();
        try {
            String string2;
            this.getInBound("STARTCONFIG");
            this._socketOut.println("OK");
            this.getInBound("LASTMODIFIED");
            this._socketOut.println(configurationProxy.getLastModified(string));
            this.getInBound("FILELIST");
            this._socketOut.println(configurationProxy.getFileList(string));
            this.getInBound("FQDN");
            this._socketOut.println(this._socket.getInetAddress().getHostName().toLowerCase());
            String string3 = this.getInBound();
            while (!string3.equals("ENDCONFIG")) {
                try {
                    string2 = configurationProxy.getProperty(string, "Host." + string3);
                    this._socketOut.println(string2);
                }
                catch (PropertyNotFoundException propertyNotFoundException) {
                    this._socketOut.println("ERROR");
                }
                string3 = this._socketIn.readLine();
            }
            this._logger.write(this.toString(), 3, "configured host");
            this._socketOut.println("OK");
            this.getInBound("FILTER");
            string2 = configurationProxy.getProperty(string, "Host.filter");
            FilterOperations filterOperations = null;
            String string4 = null;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
            while (filterOperations == null && stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken();
                this._logger.write(this.toString(), 5, " looking for filter- " + string4);
                try {
                    filterOperations = FilterHelper.narrow(ReferenceManager.getInstance().getCORBARef("iscream.Filter." + string4));
                }
                catch (ComponentCORBAException componentCORBAException) {
                    this._logger.write(this.toString(), 5, " unable to find filter- " + string4);
                }
            }
            if (filterOperations == null) {
                this._socketOut.println("ERROR");
                throw new IOException("unable to find filter for host");
            }
            this._logger.write(this.toString(), 5, " found filter- " + string4);
            this._socketOut.println(filterOperations.getHostName() + ";" + filterOperations.getUDPPort() + ";" + filterOperations.getTCPPort());
            this.getInBound("END");
            this._socketOut.println("OK");
        }
        catch (Exception exception) {
            this._logger.write(this.toString(), 1, "ERROR - " + exception);
        }
        try {
            this._socketIn.close();
            this._socketOut.close();
            this._socket.close();
        }
        catch (IOException iOException) {
            this._logger.write(this.toString(), 1, "exception on socket close");
        }
        this._logger.write(this.toString(), 3, "finished");
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.28 $");
    }

    private String getInBound(String string) throws IOException {
        String string2 = this.getInBound();
        if (!string2.equals(string)) {
            throw new IOException("protocol error - expected:" + string + " got:" + string2);
        }
        return string2;
    }

    private String getInBound() throws IOException {
        String string = this._socketIn.readLine();
        if (string == null) {
            throw new IOException("got null from host, maybe it died");
        }
        return string;
    }
}

