/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.filter;

import java.io.IOException;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.filter.FilterMain;
import uk.org.iscream.cms.server.util.FormatName;
import uk.org.iscream.cms.server.util.Queue;

public class UDPReader
extends Thread {
    public final String REVISION = "$Revision: 1.18 $";
    private final int packetSizeLimit = 8192;
    private String _name = FilterMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    int _port;
    Queue _queue;

    public UDPReader(int n, Queue queue) {
        this.setName("filter.UDPReader");
        this._port = n;
        this._queue = queue;
        this._logger.write(this.toString(), 4, "started");
    }

    public void run() {
        DatagramSocket datagramSocket = null;
        try {
            datagramSocket = new DatagramSocket(this._port);
        }
        catch (BindException bindException) {
            this._logger.write(this.toString(), 0, "Could not start the UDPReader thread on port " + this._port + " as this port was already in use.");
            return;
        }
        catch (Exception exception) {
            this._logger.write(this.toString(), 0, "Could not start the UDPReader thread on port " + this._port + ".");
            return;
        }
        this._logger.write(this.toString(), 3, "UDPReader thread ready and listening for UDP packets on port " + this._port);
        boolean bl = true;
        while (bl) {
            try {
                byte[] byArray = new byte[8192];
                DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                datagramSocket.receive(datagramPacket);
                String string = new String(datagramPacket.getData());
                this._queue.add(string);
            }
            catch (IOException iOException) {
                this._logger.write(this.toString(), 2, "This UDPReader thread has been shut down as an exception occured: " + iOException);
                bl = false;
            }
        }
        datagramSocket.close();
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.18 $");
    }
}

