/*
 * Decompiled with CFR 0.152.
 */
package uk.org.iscream.cms.server.filter;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import uk.org.iscream.cms.server.componentmanager.ConfigurationProxy;
import uk.org.iscream.cms.server.componentmanager.PropertyNotFoundException;
import uk.org.iscream.cms.server.componentmanager.ReferenceManager;
import uk.org.iscream.cms.server.core.Logger;
import uk.org.iscream.cms.server.filter.FilterMain;
import uk.org.iscream.cms.server.filter.PluginServiceCheck;
import uk.org.iscream.cms.server.filter.PluginServiceCheckManager;
import uk.org.iscream.cms.server.util.FormatName;

class PluginServiceCheckPipeline {
    public final String REVISION = "$Revision: 1.7 $";
    private final String _suffix = "__ServiceCheck";
    private String _hostname;
    private LinkedList _pipeline;
    private long _created;
    private long _lastModified;
    private String _fileList;
    private PluginServiceCheckManager _manager;
    private String _name = FilterMain.NAME;
    private Logger _logger = ReferenceManager.getInstance().getLogger();
    private ReferenceManager _refman = ReferenceManager.getInstance();

    public PluginServiceCheckPipeline(String string, PluginServiceCheckManager pluginServiceCheckManager) {
        this._logger.write(this.toString(), 4, "Created.");
        this._hostname = string;
        this._manager = pluginServiceCheckManager;
        this._pipeline = this.buildPipeline();
        this._created = System.currentTimeMillis();
    }

    public String runPipeline() {
        if (this._refman.getCM().isModified(this._fileList, this._lastModified)) {
            this._pipeline = this.buildPipeline();
        }
        String string = "";
        Iterator iterator = this._pipeline.iterator();
        while (iterator.hasNext()) {
            PluginServiceCheck pluginServiceCheck = (PluginServiceCheck)iterator.next();
            string = string + pluginServiceCheck.runServiceCheck(this._hostname);
        }
        return string;
    }

    public String toString() {
        return FormatName.getName(this._name, this.getClass().getName(), "$Revision: 1.7 $");
    }

    private LinkedList buildPipeline() {
        String string;
        String string2;
        this._logger.write(this.toString(), 3, "Creating plugin pipeline for service checks for - " + this._hostname);
        ConfigurationProxy configurationProxy = ConfigurationProxy.getInstance();
        String string3 = "Host." + this._hostname;
        this._lastModified = configurationProxy.getLastModified(string3);
        this._fileList = configurationProxy.getFileList(string3);
        try {
            string2 = configurationProxy.getProperty(string3, "Host.serviceChecksPackage");
            string = configurationProxy.getProperty(string3, "Host.serviceChecks");
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            string2 = "";
            string = "";
        }
        LinkedList<PluginServiceCheck> linkedList = new LinkedList<PluginServiceCheck>();
        this._logger.write(this.toString(), 5, "building pipeline of - " + string);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = string2 + "." + stringTokenizer.nextToken() + "__ServiceCheck";
            linkedList.add(this._manager.getServiceCheck(string4));
        }
        return linkedList;
    }

    public long getCreated() {
        return this._created;
    }
}

